﻿---
title: File Log OpenTelemetry input
description: The File Log OpenTelemetry input collects logs from files using the File Log Receiver of the OTel Collector. This integration can be used to collect logs...
url: https://www.elastic.co/docs/reference/integrations/filelog_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# File Log OpenTelemetry input
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The File Log OpenTelemetry input integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The File Log OpenTelemetry input collects logs from files using the [File Log
Receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/filelogreceiver/README.md)
of the OTel Collector.
This integration can be used to collect logs from files.

### How it works

This integration tails and parses logs from files. Observed files are the ones
matching the configured patterns.

## What data does this integration collect?

Key fields are stored following [Semantic Conventions for logs](https://opentelemetry.io/docs/specs/semconv/general/logs/), among them:

| Field Name    | Description         |
|---------------|---------------------|
| message       | Collected log line. |
| log.file.name | File name.          |
| log.file.path | File path.          |


### Supported use cases

This integration can be used to collect custom log files.

## How do I deploy this integration?


### Agent-based deployment

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.
Elastic Agent is required to have permissions to read the monitored files.

### Onboard / configure

This integration needs to be configured with the glob patterns of the files to
collect.

### Validation

Once configured, you can find documents with the content of the collected log files.

## Troubleshooting

For help with Elastic ingest tools, check [Common problems](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).

## Scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### Inputs used

This package uses the [File Log Receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/filelogreceiver/README.md) of the OTel Collector.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                 | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16181))Initial version of the package |                        |
</dropdown>