﻿---
title: Falco Integration
description: This integration allows for the shipping of Falco alerts to Elastic for observability and organizational awareness. Alerts can then be analyzed by using...
url: https://www.elastic.co/docs/reference/integrations/falco
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Falco Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.0.2 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | File, Network Protocol         |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.3                    |

This integration allows for the shipping of [Falco](https://falco.org/) alerts to Elastic for observability and organizational awareness. Alerts can then be analyzed by using either the dashboard included with the integration or via the creation of a custom dashboard within Kibana.

## Data Streams

The Falco integration collects one type of data stream:
- **Logs** The Logs data stream collected by the Falco integration is comprised of Falco Alerts. See more details about Falco Alerts in [Falco's Outputs Documentation](https://falco.org/docs/outputs/). A complete list of potential fields used by this integration can be found in the *Logs reference*


## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.
Falco must be configured to output alerts to a supported output channel as defined in *Setup*. The system will only receive fields output by Falco's rules. If a rule does not include a desired field the rule must be edited in Falco to add the field.
This integration is compatible with Falco version 0.37 and above, and should not be expected to perform successfully in lower versions.

## Setup

For step-by-step instructions on how to set up an integration, see the [Getting started](https://www.elastic.co/guide/en/starting-with-the-elasticsearch-platform-and-its-solutions/current/getting-started-observability.html) guide.
In order to capture alerts from Falco you **must** configure Falco to output Alerts as JSON to one of the supported channels: *Logfile* or *TCP Syslog*.
**Required:** To configure Falco to output JSON, set the config properties `json_output=true` and `json_include_output_property=true` in Falco's config. See the examples in Falco's [Output Channels documentation](https://falco.org/docs/outputs/channels/#http-output).

### Logfile Input

The logfile input reads data from one or more Falco log files using the Elastic Agent. Use this input when the Elastic Agent will be deployed to the same machine as Falco or when Falco's log files are available via a mounted filesystem.
To use this input Falco must be configured to output alerts to a log file. See Falco's [File Output](https://falco.org/docs/outputs/channels/#file-output) documentation for details.

### TCP Syslog Input

The TCP Syslog input allows the Elastic Agent to receive Falco Alerts via remote syslog. Use this input when you want to send data via [Falco Sidekick](https://github.com/falcosecurity/falcosidekick).
To use this input you will need to deploy the Elastic Agent *first* and then configure and deploy Falco Sidekick to send Alerts to the Agent via Syslog. See [Syslog Output](https://github.com/falcosecurity/falcosidekick/blob/master/docs/outputs/syslog.md) and [Connecting Falco to Sidekick](https://github.com/falcosecurity/falcosidekick?tab=readme-ov-file#connect-falco) for more details.

## Logs Reference


### alerts

Falco alerts can contain a multitude of various fields pertaining to the type of activity on the host machine.
<dropdown title="Exported fields">
  | Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit  |
  |-------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------|
  | @timestamp                                                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |       |
  | cloud.image.id                                              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |       |
  | data_stream.dataset                                         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |       |
  | data_stream.namespace                                       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |       |
  | data_stream.type                                            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |       |
  | event.dataset                                               | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |       |
  | event.module                                                | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |       |
  | falco.container.mounts                                      | List of mount information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | nested           |       |
  | falco.container.mounts.dest                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.container.mounts.mode                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.container.mounts.propagation                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.container.mounts.rdrw                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.container.mounts.source                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.hostname                                              | Required field for integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |       |
  | falco.output                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |       |
  | falco.output_fields.client.ip                               | Falco copy of the ECS field of the same name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |       |
  | falco.output_fields.container.cni_json                      | Container's CNI result field from the respective container status info.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | object           |       |
  | falco.output_fields.container.duration                      | Number of nanoseconds since container.start_ts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             | nanos |
  | falco.output_fields.container.full_id                       | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.container.healthcheck                   | The container's health check. Will be N/A if no health check configured.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | text             |       |
  | falco.output_fields.container.id                            | The truncated container ID (first 12 characters) extracted from the Linux cgroups by Falco within the kernel                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |       |
  | falco.output_fields.container.image.digest                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.container.image.full_id                 | Full container image ID, enriched as part of the container engine enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |       |
  | falco.output_fields.container.image.id                      | Container image ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |       |
  | falco.output_fields.container.image.name                    | Falco copy of the ECS field of the same name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | text             |       |
  | falco.output_fields.container.image.repository              | The container image repository.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.output_fields.container.image.tag                     | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.container.ip                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.container.liveness_probe                | The container's liveness probe. Will be N/A if no liveness probe configured.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | text             |       |
  | falco.output_fields.container.mounts                        | The raw text value for container mounts information                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | text             |       |
  | falco.output_fields.container.name                          | The container name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |       |
  | falco.output_fields.container.privileged                    | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |       |
  | falco.output_fields.container.readiness_probe               | The container's readiness probe. Will be N/A if no readiness probe configured.                                                                                                                                                                                                                                                                                                                                                                                                                                               | text             |       |
  | falco.output_fields.container.start_ts                      | Container start as epoch timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date_nanos       |       |
  | falco.output_fields.container.type                          | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.destination.ip                          | Falco copy of the ECS field of the same name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |       |
  | falco.output_fields.event.time                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |       |
  | falco.output_fields.evt.abspath                             | Calculated absolute path.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | text             |       |
  | falco.output_fields.evt.abspath_dst                         | Destination of the absolute path.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | text             |       |
  | falco.output_fields.evt.abspath_src                         | Source of the absolute path.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | text             |       |
  | falco.output_fields.evt.arg.flags                           | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.evt.args                                | Aggregated string of all event arguments.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | text             |       |
  | falco.output_fields.evt.asynctype                           | The type of event, if asyncronous.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |       |
  | falco.output_fields.evt.buffer                              | Binary buffer for events which have one.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | binary           |       |
  | falco.output_fields.evt.buflen                              | Length of the binary buffer, if applicable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | unsigned_long    |       |
  | falco.output_fields.evt.category                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.evt.count.error                         | Returns 1 for events that returned with an error                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | integer          |       |
  | falco.output_fields.evt.count.error_file                    | Returns 1 for events that returned with an error and are related to file I/O                                                                                                                                                                                                                                                                                                                                                                                                                                                 | integer          |       |
  | falco.output_fields.evt.count.error_memory                  | Returns 1 for events that returned with an error and are related to memory allocation.                                                                                                                                                                                                                                                                                                                                                                                                                                       | integer          |       |
  | falco.output_fields.evt.count.error_net                     | Returns 1 for events that returned with an error and are related to network I/O                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          |       |
  | falco.output_fields.evt.count.error_other                   | Returns 1 for events that returned with an error and are related to none of the previous categories.                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |       |
  | falco.output_fields.evt.count.exit                          | Returns 1 for exit events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |       |
  | falco.output_fields.evt.cpu                                 | Number of the CPU where the event occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | integer          |       |
  | falco.output_fields.evt.deltatime                           | Delta between current event and previous.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             | nanos |
  | falco.output_fields.evt.dir                                 | Either an enter event (>) or an exit event (<).                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.output_fields.evt.failed                              | Denotes if the event returned an error status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |       |
  | falco.output_fields.evt.hostname                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.evt.info                                | Contains either the event arguments, or the data decoded from them.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | text             |       |
  | falco.output_fields.evt.io_dir                              | Type based on whether the event reads from or writes to FDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |       |
  | falco.output_fields.evt.is_async                            | Denotes whether the event is async or not.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |       |
  | falco.output_fields.evt.is_io                               | Denotes events that read or write to FDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | boolean          |       |
  | falco.output_fields.evt.is_io_read                          | Denotes events that read from FDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |       |
  | falco.output_fields.evt.is_io_write                         | Denotes events that write to FDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | boolean          |       |
  | falco.output_fields.evt.is_open_create                      | Denotes whether or not a file was created for open/openat/openat2/open_by_handle_at events.                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |       |
  | falco.output_fields.evt.is_open_exec                        | Denotes whether or not a file was created with execute permissions for open/openat/openat2/open_by_handle_at or create events.                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |       |
  | falco.output_fields.evt.is_open_read                        | Denotes whether or not the path was opened for reading for open/openat/openat2/open_by_handle_at events.                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |       |
  | falco.output_fields.evt.is_open_write                       | Denotes whether or not the path was opened for writing for open/openat/openat2/open_by_handle_at events.                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |       |
  | falco.output_fields.evt.is_syslog                           | Denotes events that are written to /dev/log                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |       |
  | falco.output_fields.evt.is_wait                             | Denotes events that force the thread to wait.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |       |
  | falco.output_fields.evt.latency                             | Delta between an exit event and corresponding enter event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             | nanos |
  | falco.output_fields.evt.num                                 | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.evt.plugininfo                          | Summary of the event if it came from a plugin-defined event source.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | text             |       |
  | falco.output_fields.evt.pluginname                          | Name of the plugin that generated the event (if applicable).                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |       |
  | falco.output_fields.evt.rawres                              | Return value of the event, as a number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |       |
  | falco.output_fields.evt.res                                 | Return value of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | text             |       |
  | falco.output_fields.evt.source                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.evt.time.iso8601                        | Time event occurred                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |       |
  | falco.output_fields.evt.type                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.evt.wait_latency                        | Time spent waiting for events to return, in cases where the thread is forced to wait.                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             | nanos |
  | falco.output_fields.fd.I4proto                              | The IP protocol of a socket. Can be 'tcp', 'udp', 'icmp' or 'raw'.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |       |
  | falco.output_fields.fd.cip.name                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.connected                            | Denotes if the socket is connected for TCP/UDP FDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | boolean          |       |
  | falco.output_fields.fd.containerdirectory                   | Concatenation of the container ID and the directory name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |       |
  | falco.output_fields.fd.containername                        | Concatenation of the container ID and the FD name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |       |
  | falco.output_fields.fd.cport                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.fd.cproto                               | For TCP/UDP FDs, the client protocol.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.output_fields.fd.dev                                  | Device number containing the referenced file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | integer          |       |
  | falco.output_fields.fd.dev_major                            | Major device number containing the referenced file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | integer          |       |
  | falco.output_fields.fd.dev_minor                            | Minor device number containing the referenced file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | integer          |       |
  | falco.output_fields.fd.directory                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.filename                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.ino                                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.is_server                            | Denotes if process owning the FD is the server endpoint in the connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |       |
  | falco.output_fields.fd.lip.name                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.lport                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.fd.lproto                               | For TCP/UDP FDs, the local protocol.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |       |
  | falco.output_fields.fd.name                                 | FD full name. If the fd is a file, this field contains the full path. If the FD is a socket, this field contain the connection tuple.                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.name_changed                         | Denotes if the name of an FD changes due to an event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |       |
  | falco.output_fields.fd.num                                  | Unique number identifying the file descriptor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |       |
  | falco.output_fields.fd.rip.name                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.rport                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.fd.rproto                               | For TCP/UDP FDs, the remote protocol.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.output_fields.fd.sip.name                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.fd.sockfamily                           | The socket family for socket events. Can be 'ip' or 'unix'.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |       |
  | falco.output_fields.fd.sport                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.fd.sproto                               | For TCP/UDP FDs, the server protocol.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.output_fields.fd.type                                 | Type of FD. Can be 'file', 'directory', 'ipv4', 'ipv6', 'unix', 'pipe', 'event', 'signalfd', 'eventpoll', 'inotify' 'signalfd' or 'memfd'.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |       |
  | falco.output_fields.fd.typechar                             | Type of FD as a single character. Can be 'f' for file, 4 for IPv4 socket, 6 for IPv6 socket, 'u' for unix socket, p for pipe, 'e' for eventfd, 's' for signalfd, 'l' for eventpoll, 'i' for inotify, 'b' for bpf, 'u' for userfaultd, 'r' for io_uring, 'm' for memfd ,'o' for unknown.                                                                                                                                                                                                                                      | keyword          |       |
  | falco.output_fields.fd.uid                                  | Unique identifier for the FD, created from the FD number and thread ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |       |
  | falco.output_fields.fdlist.cips                             | For poll events, client IP addresses in the fds argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | ip               |       |
  | falco.output_fields.fdlist.cports                           | For poll events / TCP/UDP FDs, client TCP/UDP ports in the fds argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |       |
  | falco.output_fields.fdlist.names                            | For poll events, FD names in the fds argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |       |
  | falco.output_fields.fdlist.sips                             | For poll events, server IP addresses in the fds argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | ip               |       |
  | falco.output_fields.fdlist.sports                           | For poll events, server TCP/UDP ports in the fds argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |       |
  | falco.output_fields.fs.path.name                            | For any event type that deals with a filesystem path, the path the file syscall is operating on. This path is always fully resolved, prepending the thread cwd when needed.                                                                                                                                                                                                                                                                                                                                                  | keyword          |       |
  | falco.output_fields.fs.path.source                          | For any event type that deals with a filesystem path, and specifically for a source and target like mv, cp, etc, the source path the file syscall is operating on. This path is always fully resolved, prepending the thread cwd when needed.                                                                                                                                                                                                                                                                                | keyword          |       |
  | falco.output_fields.fs.path.target                          | For any event type that deals with a filesystem path, and specifically for a target and target like mv, cp, etc, the target path the file syscall is operating on. This path is always fully resolved, prepending the thread cwd when needed.                                                                                                                                                                                                                                                                                | keyword          |       |
  | falco.output_fields.group.gid                               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.group.name                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.k8s.ns.name                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.k8s.pod.cni_json                        | Kubernetes CNI result field from the respective pod status info.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | object           |       |
  | falco.output_fields.k8s.pod.full_sandbox_id                 | Full, non-truncated Kubernetes pod sandbox ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |       |
  | falco.output_fields.k8s.pod.ip                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.k8s.pod.labels                          | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.k8s.pod.name                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.k8s.pod.sandbox_id                      | Truncated Kubernetes pod sandbox ID (first 12 characters).                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |       |
  | falco.output_fields.k8s.pod.uid                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.output                                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.priority                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.output_fields.proc.args                               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.cmdlenargs                         | Total length of command line args, excluding whitespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |       |
  | falco.output_fields.proc.cmdline                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.cmdnargs                           | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.proc.cwd                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.duration                           | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.env                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.exe                                | First command line argument, collected from args.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | text             |       |
  | falco.output_fields.proc.exe_ino                            | The inode number of the executable file on disk.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |       |
  | falco.output_fields.proc.exe_ino_ctime                      | Last status change of executable file as epoch timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | date_nanos       |       |
  | falco.output_fields.proc.exe_ino_ctime_duration_pidns_start | Number of nanoseconds between PID namespace start ts and ctime exe file if PID namespace start predates ctime.                                                                                                                                                                                                                                                                                                                                                                                                               | long             |       |
  | falco.output_fields.proc.exe_ino_ctime_duration_proc_start  | Number of nanoseconds between modifying status of executable image and spawning a new process using the changed executable image.                                                                                                                                                                                                                                                                                                                                                                                            | long             |       |
  | falco.output_fields.proc.exe_ino_mtime                      | Last modification time of executable file as epoch timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | date_nanos       |       |
  | falco.output_fields.proc.exeline                            | Full command line, with exe as first argument.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | text             |       |
  | falco.output_fields.proc.exepath                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.fdopencount                        | Number of open FDs for the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | unsigned_long    |       |
  | falco.output_fields.proc.fdopenlimit                        | Maximum number of FDs the process can open.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |       |
  | falco.output_fields.proc.fdusage                            | Ratio between open FDs and maximum available FDs for the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | double           |       |
  | falco.output_fields.proc.is_container_healthcheck           | Denotes if this process is running as a part of the container's health check.                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |       |
  | falco.output_fields.proc.is_container_liveness_probe        | Denotes if this process is running as a part of the container's liveness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |       |
  | falco.output_fields.proc.is_container_readiness_probe       | Denotes if this process is running as a part of the container's readiness probe.                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |       |
  | falco.output_fields.proc.is_exe_from_memfd                  | Denotes if this process' executable file is in upper layer in overlayfs.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |       |
  | falco.output_fields.proc.is_exe_upper_layer                 | Denotes if this process' executable file is in upper layer in overlayfs.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |       |
  | falco.output_fields.proc.is_exe_writable                    | Denotes if this process' executable file is writable by the same user that spawned the process.                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |       |
  | falco.output_fields.proc.is_sid_leader                      | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |       |
  | falco.output_fields.proc.is_vpgid_leader                    | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |       |
  | falco.output_fields.proc.loginshellid                       | PID of the oldest shell among the ancestors of the current process, if applicable.                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |       |
  | falco.output_fields.proc.name                               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.nchilds                            | Number of alive (not leader) threads in the process generating the event currently has, excluding the leader thread.                                                                                                                                                                                                                                                                                                                                                                                                         | unsigned_long    |       |
  | falco.output_fields.proc.nthreads                           | Number of alive threads in the process generating the event currently has, including the leader thread.                                                                                                                                                                                                                                                                                                                                                                                                                      | unsigned_long    |       |
  | falco.output_fields.proc.pcmdline                           | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.pexe                               | First command line argument of the parent process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | text             |       |
  | falco.output_fields.proc.pexepath                           | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.pid.ts                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.pidns_init_start_ts                | Start of PID namespace as epoch timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date_nanos       |       |
  | falco.output_fields.proc.pname                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.ppid.duration                      | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.proc.ppid.ts                            | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.pvpid                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.proc.sid.exe                            | First command line argument of the current process's session leader.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | text             |       |
  | falco.output_fields.proc.sid.exepath                        | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.sname                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.thread.cap_inheritable             | Set of inheritable capabilities set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |       |
  | falco.output_fields.proc.tty                                | Controlling terminal of the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |       |
  | falco.output_fields.proc.vmrss                              | Resident non-swapped memory for the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | unsigned_long    | byte  |
  | falco.output_fields.proc.vmsize                             | Total virtual memory for the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | unsigned_long    | byte  |
  | falco.output_fields.proc.vmswap                             | Swapped memory for the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | unsigned_long    |       |
  | falco.output_fields.proc.vpgid.exe                          | First command line argument of the current process's group leader.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | text             |       |
  | falco.output_fields.proc.vpgid.exepath                      | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.vpgid.name                         | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.proc.vpid                               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.process.group_leader.vpid               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.process.parent.pid                      | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.process.pid                             | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.process.session_leader.pid              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |       |
  | falco.output_fields.proct.ppid.duration                     | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.rule                                    | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.server.ip                               | Falco copy of the ECS field of the same name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |       |
  | falco.output_fields.source.ip                               | Falco copy of the ECS field of the same name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |       |
  | falco.output_fields.syslog.facility.str                     | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.syslog.severity.str                     | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.syslog_facility                         | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.syslog_severity                         | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.thread.cap_effective                    | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.thread.cap_permitted                    | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.thread.cgroups                          | Aggregated string of cgroups the thread belongs to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | flattened        |       |
  | falco.output_fields.thread.cpu                              | CPU consumed by the thread in the last second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           |       |
  | falco.output_fields.thread.cpu_system                       | The system CPU consumed by the thread in the last second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | double           |       |
  | falco.output_fields.thread.cpu_user                         | The user CPU consumed by the thread in the last second.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | double           |       |
  | falco.output_fields.thread.exectime                         | CPU time spent by last scheduled thread.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             | nanos |
  | falco.output_fields.thread.ismain                           | Denotes if the threat generating the event is the main one in the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |       |
  | falco.output_fields.thread.pfmajor                          | Number of major page faults since thread start.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | unsigned_long    |       |
  | falco.output_fields.thread.pfminor                          | Number of minor page faults since thread start.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | unsigned_long    |       |
  | falco.output_fields.thread.tid                              | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.output_fields.thread.totalexectime                    | Total CPU time for the current thread since the beginning of the capture.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             | nanos |
  | falco.output_fields.thread.vmrss                            | Resident non-swapped memory for the process' main thread. Non-main threads will appear as zero.                                                                                                                                                                                                                                                                                                                                                                                                                              | unsigned_long    |       |
  | falco.output_fields.thread.vmsize                           | Total virtual memory for the process' main thread. Non-main threads will appear as zero.                                                                                                                                                                                                                                                                                                                                                                                                                                     | unsigned_long    |       |
  | falco.output_fields.thread.vtid                             | The ID of the thread generating the event as seen from its current PID namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |       |
  | falco.output_fields.user.homedir                            | Home directory of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | text             |       |
  | falco.output_fields.user.loginname                          | Audit user name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |       |
  | falco.output_fields.user.loginuid                           | Audit user ID. If an invalid UID is encountered, returns -1.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |       |
  | falco.output_fields.user.name                               | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | text             |       |
  | falco.output_fields.user.shell                              | User's shell.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |       |
  | falco.output_fields.user.uid                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |       |
  | falco.priority                                              | Falco alert priority                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |       |
  | falco.rule                                                  | Name of the Falco rule that triggered the alert                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |       |
  | falco.source                                                | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.tags                                                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | falco.time                                                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |       |
  | falco.uuid                                                  | Preserved Falco field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | host.containerized                                          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |       |
  | host.os.build                                               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |       |
  | host.os.codename                                            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |       |
  | input.type                                                  | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |       |
  | log.offset                                                  | Log offset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |       |
  | log.source.address                                          | Log source when collecting via TCP input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |       |
  | process.group.id                                            | Unique identifier for the group on the system/platform.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |       |
  | process.group.name                                          | Name of the group.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |       |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-05-07T18:54:19.341Z",
      "agent": {
          "ephemeral_id": "e34b6aee-8a34-4453-9886-bcd7d86cc1ae",
          "id": "7f656253-e996-42c6-92ed-2c256a8ffde9",
          "name": "elastic-agent-40498",
          "type": "filebeat",
          "version": "8.13.3"
      },
      "container": {
          "id": "9656db3bb358",
          "name": "elastic-package-service-falco-event-generator-1"
      },
      "data_stream": {
          "dataset": "falco.alerts",
          "namespace": "16320",
          "type": "logs"
      },
      "ecs": {
          "version": "8.0.0"
      },
      "elastic_agent": {
          "id": "7f656253-e996-42c6-92ed-2c256a8ffde9",
          "snapshot": false,
          "version": "8.13.3"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "process"
          ],
          "dataset": "falco.alerts",
          "ingested": "2025-05-02T12:05:55Z",
          "kind": "alert",
          "original": "{\"hostname\":\"97ade2b595f0\",\"output\":\"2024-05-07T18:54:19.341081180+0000: Warning Sensitive file opened for reading by non-trusted program (file=/etc/shadow gparent=runc ggparent=init gggparent=init evt_type=openat user=root user_uid=0 user_loginuid=-1 process=event-generator proc_exepath=/bin/event-generator parent=containerd-shim command=event-generator run --loop terminal=0 container_id=9656db3bb358 container_name=elastic-package-service-falco-event-generator-1)\",\"priority\":\"Warning\",\"rule\":\"Read sensitive file untrusted\",\"source\":\"syscall\",\"tags\":[\"T1555\",\"container\",\"filesystem\",\"host\",\"maturity_stable\",\"mitre_credential_access\"],\"time\":\"2024-05-07T18:54:19.341081180Z\", \"output_fields\": {\"container.id\":\"9656db3bb358\",\"container.name\":\"elastic-package-service-falco-event-generator-1\",\"evt.time.iso8601\":1715108059341081180,\"evt.type\":\"openat\",\"fd.name\":\"/etc/shadow\",\"proc.cmdline\":\"event-generator run --loop\",\"proc.exepath\":\"/bin/event-generator\",\"proc.name\":\"event-generator\",\"proc.pname\":\"containerd-shim\",\"proc.tty\":0,\"user.loginuid\":-1,\"user.name\":\"root\",\"user.uid\":0}}",
          "provider": "syscall",
          "severity": 47,
          "timezone": "+00:00",
          "type": [
              "access"
          ]
      },
      "falco": {
          "hostname": "97ade2b595f0",
          "output": "2024-05-07T18:54:19.341081180+0000: Warning Sensitive file opened for reading by non-trusted program (file=/etc/shadow gparent=runc ggparent=init gggparent=init evt_type=openat user=root user_uid=0 user_loginuid=-1 process=event-generator proc_exepath=/bin/event-generator parent=containerd-shim command=event-generator run --loop terminal=0 container_id=9656db3bb358 container_name=elastic-package-service-falco-event-generator-1)",
          "output_fields": {
              "container": {
                  "id": "9656db3bb358",
                  "name": "elastic-package-service-falco-event-generator-1"
              },
              "evt": {
                  "time": {
                      "iso8601": 1715108059341
                  },
                  "type": "openat"
              },
              "fd": {
                  "name": "/etc/shadow"
              },
              "proc": {
                  "cmdline": "event-generator run --loop",
                  "exepath": "/bin/event-generator",
                  "name": "event-generator",
                  "pname": "containerd-shim",
                  "tty": 0
              },
              "user": {
                  "loginuid": -1,
                  "name": "root",
                  "uid": "0"
              }
          },
          "priority": "Warning",
          "rule": "Read sensitive file untrusted",
          "source": "syscall",
          "tags": [
              "T1555",
              "container",
              "filesystem",
              "host",
              "maturity_stable",
              "mitre_credential_access"
          ],
          "time": "2024-05-07T18:54:19.341081180Z"
      },
      "falco.container.mounts": null,
      "host": {
          "architecture": "x86_64",
          "containerized": true,
          "hostname": "elastic-agent-40498",
          "id": "e2673383c29c4c6e92abf0f43543814c",
          "ip": [
              "192.168.251.2",
              "192.168.247.6"
          ],
          "mac": [
              "02-42-C0-A8-F7-06",
              "02-42-C0-A8-FB-02"
          ],
          "name": "97ade2b595f0",
          "os": {
              "codename": "focal",
              "family": "debian",
              "kernel": "3.10.0-1160.92.1.el7.x86_64",
              "name": "Ubuntu",
              "platform": "ubuntu",
              "type": "linux",
              "version": "20230201"
          }
      },
      "input": {
          "type": "log"
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/sample.log"
          },
          "offset": 0
      },
      "message": "Read sensitive file untrusted",
      "observer": {
          "hostname": "97ade2b595f0",
          "product": "falco",
          "type": "sensor",
          "vendor": "sysdig"
      },
      "process": {
          "command_line": "event-generator run --loop",
          "executable": "/bin/event-generator",
          "name": "event-generator",
          "parent": {
              "name": "containerd-shim"
          },
          "user": {
              "id": "0",
              "name": "root"
          }
      },
      "related": {
          "hosts": [
              "97ade2b595f0"
          ]
      },
      "rule": {
          "name": "Read sensitive file untrusted"
      },
      "tags": [
          "preserve_original_event",
          "preserve_falco_fields"
      ],
      "threat.technique.id": [
          "T1555"
      ]
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Screenshot of main Falco dashboard](https://epr.elastic.co/package/falco/2.0.2/img/falco-application-dashboard-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                  | Minimum Kibana version |
  |-----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.0.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16356))Fix handling of new event time name.                                                                                                                                                                                                | 9.0.08.13.3            |
  | **2.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14541))Fix type conflicts with ECS and nested type definitions, and use ECS definitions where possible.                                                                                                                                    | 9.0.08.13.3            |
  | **2.0.0** | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/12896))Route documents to data stream based on ingest source. Ingest with CNCF data sources will use 'falco-*' dataset, and agent-based ingestion will use 'falco-agent-*'.                                                        | 9.0.08.13.3            |
  | **1.3.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13800))Fix conflicting field definitions.                                                                                                                                                                                                  | 9.0.08.13.3            |
  | **1.3.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13589))Align field definitions with ECS. The `process.group.id` and `process.group.name` fields were changed from text to keyword.                                                                                                         | 9.0.08.13.3            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                      | 9.0.08.13.3            |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                                                                                                                                                                | 8.13.3                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                         | 8.13.3                 |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11881))Add `event.original` for events forwarded from Falco Sidekick.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11881))Use `host.name` for `Alerts by Host` visualization in Alerts Overview dashboard. | 8.13.3                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                       | 8.13.3                 |
  | **1.0.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                | 8.13.3                 |
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                | 8.13.3                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11210))Release package as GA.                                                                                                                                                                                                          | 8.13.3                 |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11051))Support external alerts on index                                                                                                                                                                                                |                        |
  | **0.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11016))Fix definition of subfields of nested objects                                                                                                                                                                                       |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9619))Initial release of the Falco package                                                                                                                                                                                             |                        |
</dropdown>