﻿---
title: F5 BIG-IP
description: The F5 BIG-IP integration allows users to monitor LTM, AFM, APM, ASM, AVR, System Information, iHealth Information, BOT, and DOS activity. F5 BIG-IP covers...
url: https://www.elastic.co/docs/reference/integrations/f5_bigip
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# F5 BIG-IP
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.27.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | AWS S3, File, Webhook           |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.5                     |


## Overview

The [F5 BIG-IP](https://www.f5.com/products/big-ip-services) integration allows users to monitor LTM, AFM, APM, ASM, AVR, System Information, iHealth Information, BOT, and DOS activity. F5 BIG-IP covers software and hardware designed around application availability, access control, and security solutions.
Use the F5 BIG-IP integration to collect and parse data from F5 BIG-IP using **telemetry streaming** and then visualize that data in Kibana. The integration currently only supports JSON-formatted telemetry data generated by following F5 features: LTM, AFM, APM, ASM, AVR, System Information, iHealth Information, BOT, and DOS activity. Ingesting or parsing the **syslog events** produced at the operating system level is not supported. Use the [Custom Logs integration](https://docs.elastic.co/integrations/log) to ingest these system-level log messages instead.
The F5 BIG-IP integration can be used in three different modes to collect data:
- **HTTP Endpoint mode** - F5 BIG-IP pushes logs directly to an HTTP endpoint hosted by users’ Elastic Agent.
- **AWS S3 polling mode** - F5 BIG-IP writes data to S3 and Elastic Agent polls the S3 bucket by listing its contents and reading new files.
- **AWS S3 SQS mode** - F5 BIG-IP writes data to S3, S3 pushes a new object notification to SQS, Elastic Agent receives the notification from SQS, and then reads the S3 object. Multiple Agents can be used in this mode.

For example, users can use the data from this integration to analyze the traffic that passes through their F5 BIG-IP network.

## Data streams

The F5 BIG-IP integration collects one type of data stream: log.
**Log** help users to keep a record of events happening on the network using telemetry streaming.
The log data stream collected by the F5 BIG-IP integration includes events that are related to network traffic. See more details in the [logs examples documentation](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/output-example.html). F5 BIG-IP streams a variety of log types, categorized by the `telemetryEventCategory` field.
This integration targets the eight types of events as mentioned below:
- **LTM** provides the platform for creating virtual servers, performance, service, protocol, authentication, and security profiles to define and shape users’ application traffic. For more information, refer to the link [here](https://www.f5.com/products/big-ip-services/local-traffic-manager).
- **AFM** is designed to reduce the hardware and extra hops required when ADC's are paired with traditional firewalls and helps to protect traffic destined for the user's data center. For more information, refer to the link [here](https://www.f5.com/products/security/advanced-firewall-manager).
- **APM** provides federation, SSO, application access policies, and secure web tunneling and allows granular access to users' various applications, virtualized desktop environments, or just go full VPN tunnel. For more information, refer to the link [here](https://www.f5.com/products/security/access-policy-manager).
- **ASM** is F5's web application firewall (WAF) solution. It allows users to tailor acceptable and expected application behavior on a per-application basis. For more information, refer to the link [here](https://www.f5.com/pdf/products/big-ip-application-security-manager-overview.pdf).
  - **BOT and DOS** provides details about the BOT events and distributed DOS attacks events related to F5 BIG-IP ASM. For more information on BOT, refer to the knowledge base article [here](https://my.f5.com/manage/s/article/K17680287). For more information on DOS, refer to the article [here](https://my.f5.com/manage/s/article/K75699030).
- **AVR** provides detailed charts and graphs to give users more insight into the performance of web applications, with detailed views on HTTP and TCP stats, as well as system performance (CPU, memory, etc.). For more information, refer to the link [here](https://clouddocs.f5.com/training/community/analytics/html/class1/class1.html).
- **System Information** provides the system information that F5 BIG-IP Telemetry Streaming collects. For more information, refer to the documentation [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/output-example.html#system-information).
- **iHealth Information** highlights vulnerability and importance, potentially leading to memory exhaustion if exploited. It also directs to a solution article for further details and specifies unaffected F5 products. For more information, refer to the documentation [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/output-example.html#ihealth-information-request).


## Requirements

Elasticsearch is needed to store and search data, and Kibana is needed for visualizing and managing it. You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your hardware.
The reference link for requirements of telemetry streaming is [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/prereqs.html).
The reference link for requirements of Application Services 3(AS3) Extension is [here](https://clouddocs.f5.com/products/extensions/f5-appsvcs-extension/latest/userguide/prereqs.html).
This module has been tested against `F5 BIG-IP version 16.1.0`, `Telemetry Streaming version 1.32.0` and `AS3 version 3.40.0`.

## Setup


### To collect LTM, AFM, APM, ASM, AVR, System Information and iHealth Information data from F5 BIG-IP, the user has to configure modules in F5 BIG-IP as per the requirements.

To set up the F5 BIG-IP environment, users can use the BIG-IP system browser-based Configuration Utility or the command line tools that are provided. For more information related to the configuration of F5 BIG-IP servers, refer to F5 support website [here](https://support.f5.com/csp/knowledge-center/software).

### Configuration of Telemetry Streaming in F5

For downloading and installing Telemetry Streaming, refer to the link [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/installation.html).
Telemetry Streaming will send logs in the JSON format to the destination. Telemetry Streaming is compatible with **BIG-IP versions 13.0 and later**. Users have to prepare F5 servers for it and set up the Telemetry Streaming Consumer.
To use telemetry streaming, user have to send **POST** request on `https://<BIG-IP>/mgmt/shared/telemetry/declare` for declaration.
Sample declaration to set up Telemetry Streaming Consumer(Generic_HTTP) is as follows:
```
{
    "class": "Telemetry",
       "My_System": {
        "class": "Telemetry_System",
        "systemPoller": {
            "interval": <INTERVAL>
        }
    },
    "My_Listener": {
        "class": "Telemetry_Listener",
        "port": 6514
    },
    "My_Consumer": {
        "class": "Telemetry_Consumer",
        "type": "Generic_HTTP",
        "host": "<HOST-IP>",
        "protocol": "http",
        "port": <PORT>,
        "path": "/",
        "method": "POST",
        "headers": [
            {
                "name": "content-type",
                "value": "application/json"
            }
        ],
        "outputMode": "processed"
    }
}
```

For more information related to Generic HTTP consumers, refer to the link [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/setting-up-consumer.html#generic-http).
To set up TLS client authentication in Generic HTTP consumer, refer to the link [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/declarations.html#generic-http-consumer-with-tls-client-authentication).
Sample declaration to set up Telemetry Streaming Consumer(AWS_S3) is as follows:
```
{
    "class": "Telemetry",
    "My_System": {
        "class": "Telemetry_System",
        "systemPoller": {
            "interval": <INTERVAL>
        }
    },
    "My_Listener": {
        "class": "Telemetry_Listener",
        "port": 6514
    },
    "My_Consumer": {
        "class": "Telemetry_Consumer",
        "type": "AWS_S3",
        "region": "<AWS_REGION>",
        "bucket": "<BUCKET_NAME>",
        "username": "<ACCESS_KEY_ID>",
        "passphrase": {
            "cipherText": "<SECRET_ACCESS_KEY>"
        }
    }
}
```

F5 BIG-IP modules named LTM, AFM, ASM, and APM are not configured by Telemetry Streaming, they must be configured with AS3 or another method. Reference link for setup AS3 extension in F5 BIG-IP is [here](https://clouddocs.f5.com/products/extensions/f5-appsvcs-extension/latest/).
To configure logging using AS3, refer to the link [here](https://clouddocs.f5.com/products/extensions/f5-telemetry-streaming/latest/event-listener.html?highlight=as3#configure-logging-using-as3).

### To collect data from AWS S3 Bucket, follow the below steps:

- Create an Amazon S3 bucket. Refer to the link [here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html).
- The default value of the "Bucket List Prefix" is listed below. However, the user can set the parameter "Bucket List Prefix" according to the requirement.
  | Data Stream Name | Bucket List Prefix                                      |
  |------------------|---------------------------------------------------------|
  | Log              | `<Bucket list prefix which has been created in AWS S3>` |


### To collect data from AWS SQS, follow the below steps:

1. If data forwarding to an AWS S3 Bucket hasn't been configured, then first set up an AWS S3 Bucket as mentioned in the above documentation.
2. To set up an SQS queue, follow "Step 1: Create an Amazon SQS queue" mentioned in the [Documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ways-to-add-notification-config-to-bucket.html).

- While creating an SQS Queue, please provide the same bucket ARN that has been generated after creating an AWS S3 Bucket.

1. Set up event notifications for an S3 bucket. Follow this [link](https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-event-notifications.html).

- Users have to set the prefix parameter the same as the S3 Bucket List Prefix as created earlier. (for example, `log/` for a log data stream.)
- Select the event type as s3:ObjectCreated:*, select the destination type SQS Queue, and select the queue that has been created in Step 2.

**Note**:
- Credentials for the above AWS S3 and SQS input types should be configured using the [link](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-aws-s3.html#aws-credentials-config).
- Data collection via AWS S3 Bucket and AWS SQS are mutually exclusive in this case.


### Enabling the integration in Elastic

1. In Kibana go to **Management > Integrations**.
2. In the "Search for integrations" search bar, type **F5 BIG-IP**.
3. Click on **F5 BIG-IP** integration from the search results.
4. Click on the **Add F5 BIG-IP** button to add F5 BIG-IP integration.
5. Enable the Integration to collect logs via AWS S3 or HTTP endpoint input.


## Logs Reference


### log

This is the `log` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2018-11-19T22:34:40.000Z",
      "agent": {
          "ephemeral_id": "5783a7ca-031c-49a4-a74c-6bf741bd44a7",
          "id": "7036eed3-e508-4a47-99a4-b144655eb291",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.14.0"
      },
      "client": {
          "ip": "81.2.69.142",
          "port": 49804
      },
      "data_stream": {
          "dataset": "f5_bigip.log",
          "namespace": "45148",
          "type": "logs"
      },
      "destination": {
          "ip": "81.2.69.142",
          "port": 80
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7036eed3-e508-4a47-99a4-b144655eb291",
          "snapshot": false,
          "version": "8.14.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "f5_bigip.log",
          "ingested": "2024-08-06T23:25:39Z",
          "kind": "alert",
          "original": "{\"application\":\"app.app\",\"attack_type\":\"Detection Evasion\",\"blocking_exception_reason\":\"test\",\"captcha_result\":\"not_received\",\"date_time\":\"2018-11-19 22:34:40\",\"dest_ip\":\"81.2.69.142\",\"dest_port\":\"80\",\"device_id\":\"12bdca32\",\"fragment\":\"test_Fragment\",\"geo_location\":\"US\",\"hostname\":\"hostname\",\"http_class_name\":\"/Common/abc/test\",\"ip_address_intelligence\":\"host1\",\"ip_client\":\"81.2.69.142\",\"management_ip_address\":\"81.2.69.142\",\"management_ip_address_2\":\"81.2.69.144\",\"method\":\"GET\",\"policy_apply_date\":\"2018-11-19 22:17:57\",\"policy_name\":\"/Common/abc\",\"protocol\":\"HTTP\",\"query_string\":\"name=abc\",\"request\":\"GET /admin/.\",\"request_status\":\"blocked\",\"response_code\":\"0\",\"route_domain\":\"example.com\",\"session_id\":\"abc123abcd\",\"severity\":\"Critical\",\"sig_ids\":\"abc12bcd\",\"sig_names\":\"Sig_Name\",\"src_port\":\"49804\",\"staged_sig_ids\":\"abc23121bc\",\"staged_sig_names\":\"test_name\",\"staged_threat_campaign_names\":\"test\",\"sub_violations\":\"Evasion technique detected:Directory traversals\",\"support_id\":\"123456789\",\"telemetryEventCategory\":\"ASM\",\"tenant\":\"Common\",\"threat_campaign_names\":\"threat\",\"uri\":\"/directory/file\",\"username\":\"test User\",\"violation_rating\":\"3\",\"violations\":\"Evasion technique detected\",\"virus_name\":\"test Virus\",\"web_application_name\":\"/Common/abc\",\"websocket_direction\":\"test\",\"websocket_message_type\":\"test\",\"x_forwarded_for_header_value\":\"81.2.69.144\"}",
          "type": [
              "info"
          ]
      },
      "f5_bigip": {
          "log": {
              "application": {
                  "name": "app.app"
              },
              "attack": {
                  "type": "Detection Evasion"
              },
              "blocking_exception_reason": "test",
              "captcha_result": "not_received",
              "client": {
                  "ip": "81.2.69.142"
              },
              "date_time": "2018-11-19T22:34:40.000Z",
              "dest": {
                  "ip": "81.2.69.142",
                  "port": 80
              },
              "device": {
                  "id": "12bdca32"
              },
              "fragment": "test_Fragment",
              "geo": {
                  "location": "US"
              },
              "hostname": "hostname",
              "http": {
                  "class_name": "/Common/abc/test"
              },
              "ip_address_intelligence": "host1",
              "management": {
                  "ip_address": "81.2.69.142",
                  "ip_address_2": "81.2.69.144"
              },
              "method": "GET",
              "policy": {
                  "apply_date": "2018-11-19T22:17:57.000Z",
                  "name": "/Common/abc"
              },
              "protocol": "HTTP",
              "query": {
                  "string": "name=abc"
              },
              "request": {
                  "detail": "GET /admin/.",
                  "status": "blocked"
              },
              "response": {
                  "code": 0
              },
              "route_domain": "example.com",
              "session": {
                  "id": "abc123abcd"
              },
              "severity": {
                  "name": "Critical"
              },
              "sig": {
                  "ids": "abc12bcd",
                  "names": "Sig_Name"
              },
              "src": {
                  "port": 49804
              },
              "staged": {
                  "sig": {
                      "ids": "abc23121bc",
                      "names": "test_name"
                  },
                  "threat_campaign_names": "test"
              },
              "sub_violations": "Evasion technique detected:Directory traversals",
              "support": {
                  "id": "123456789"
              },
              "telemetry": {
                  "event": {
                      "category": "ASM"
                  }
              },
              "tenant": "Common",
              "threat_campaign_names": "threat",
              "uri": "/directory/file",
              "username": "test User",
              "violation": {
                  "rating": 3
              },
              "violations": "Evasion technique detected",
              "virus_name": "test Virus",
              "web_application_name": "/Common/abc",
              "websocket": {
                  "direction": "test",
                  "message_type": "test"
              },
              "x_forwarded_for_header_value": [
                  "81.2.69.144"
              ]
          }
      },
      "host": {
          "geo": {
              "country_iso_code": "US"
          },
          "id": "12bdca32",
          "name": "hostname"
      },
      "http": {
          "request": {
              "method": "GET"
          }
      },
      "input": {
          "type": "http_endpoint"
      },
      "log": {
          "level": "critical"
      },
      "network": {
          "application": "app.app",
          "protocol": "http"
      },
      "observer": {
          "product": "Application Security Module",
          "vendor": "F5"
      },
      "related": {
          "hosts": [
              "hostname",
              "12bdca32"
          ],
          "ip": [
              "81.2.69.142",
              "81.2.69.144"
          ],
          "user": [
              "test User"
          ]
      },
      "server": {
          "ip": "81.2.69.142",
          "port": 80
      },
      "source": {
          "ip": "81.2.69.142",
          "port": 49804
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "f5_bigip-log"
      ],
      "user": {
          "name": "test User"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                  | Description                                                                               | Type             |
  |--------------------------------------------------------|-------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                             | Event timestamp.                                                                          | date             |
  | cloud.image.id                                         | Image ID for the cloud instance.                                                          | keyword          |
  | data_stream.dataset                                    | Data stream dataset.                                                                      | constant_keyword |
  | data_stream.namespace                                  | Data stream namespace.                                                                    | constant_keyword |
  | data_stream.type                                       | Data stream type.                                                                         | constant_keyword |
  | event.dataset                                          | Event dataset.                                                                            | constant_keyword |
  | event.module                                           | Event module.                                                                             | constant_keyword |
  | f5_bigip.log.abandoned_conns                           |                                                                                           | long             |
  | f5_bigip.log.accept_fails                              |                                                                                           | long             |
  | f5_bigip.log.accepts                                   |                                                                                           | long             |
  | f5_bigip.log.access.policy_result                      |                                                                                           | keyword          |
  | f5_bigip.log.access.profile                            |                                                                                           | keyword          |
  | f5_bigip.log.acl.policy.name                           |                                                                                           | keyword          |
  | f5_bigip.log.acl.policy.type                           |                                                                                           | keyword          |
  | f5_bigip.log.acl.rule.name                             |                                                                                           | keyword          |
  | f5_bigip.log.acl.rule.uuid                             |                                                                                           | keyword          |
  | f5_bigip.log.action                                    |                                                                                           | keyword          |
  | f5_bigip.log.active_conns                              |                                                                                           | double           |
  | f5_bigip.log.actual_mitigation_action.reason           |                                                                                           | keyword          |
  | f5_bigip.log.actual_mitigation_action.value            |                                                                                           |                  |
  | f5_bigip.log.additional_bot_signatures                 |                                                                                           | keyword          |
  | f5_bigip.log.afm_state                                 |                                                                                           | keyword          |
  | f5_bigip.log.aggr_interval                             |                                                                                           | long             |
  | f5_bigip.log.anomalies                                 |                                                                                           | keyword          |
  | f5_bigip.log.anomaly_categories                        |                                                                                           | keyword          |
  | f5_bigip.log.apm_state                                 |                                                                                           | keyword          |
  | f5_bigip.log.application.display_name                  |                                                                                           | keyword          |
  | f5_bigip.log.application.name                          |                                                                                           | keyword          |
  | f5_bigip.log.application.response.max_time             |                                                                                           | long             |
  | f5_bigip.log.application.response.min_time             |                                                                                           | long             |
  | f5_bigip.log.application.response.time                 |                                                                                           | long             |
  | f5_bigip.log.application_name                          |                                                                                           | keyword          |
  | f5_bigip.log.asm_attack_signatures.*.create_date_time  |                                                                                           | object           |
  | f5_bigip.log.asm_attack_signatures.*.filename          |                                                                                           | object           |
  | f5_bigip.log.asm_state                                 |                                                                                           | keyword          |
  | f5_bigip.log.attack.count                              |                                                                                           | long             |
  | f5_bigip.log.attack.id                                 |                                                                                           | keyword          |
  | f5_bigip.log.attack.mitigation_name                    |                                                                                           | keyword          |
  | f5_bigip.log.attack.trigger_name                       |                                                                                           | keyword          |
  | f5_bigip.log.attack.type                               |                                                                                           | keyword          |
  | f5_bigip.log.attack.vector_name                        |                                                                                           | keyword          |
  | f5_bigip.log.bad_actor.detection.avg                   |                                                                                           | long             |
  | f5_bigip.log.bad_actor.drops                           |                                                                                           | long             |
  | f5_bigip.log.bad_actor.events                          |                                                                                           | long             |
  | f5_bigip.log.bad_actor.mitigation.max                  |                                                                                           | long             |
  | f5_bigip.log.bad_actor.mitigation.min                  |                                                                                           | long             |
  | f5_bigip.log.base_mac                                  |                                                                                           | keyword          |
  | f5_bigip.log.bigip_management.ip                       |                                                                                           | ip               |
  | f5_bigip.log.bigip_management.ip2                      |                                                                                           | ip               |
  | f5_bigip.log.bigip_management.ip_2                     |                                                                                           | ip               |
  | f5_bigip.log.blocking_exception_reason                 |                                                                                           | keyword          |
  | f5_bigip.log.bot_name                                  |                                                                                           | keyword          |
  | f5_bigip.log.bot_signature.category                    |                                                                                           | keyword          |
  | f5_bigip.log.bot_signature.value                       |                                                                                           | keyword          |
  | f5_bigip.log.browser_actual_verification_action.reason |                                                                                           | keyword          |
  | f5_bigip.log.browser_actual_verification_action.value  |                                                                                           | keyword          |
  | f5_bigip.log.browser_configured_verification_action    |                                                                                           | keyword          |
  | f5_bigip.log.browser_name                              |                                                                                           | keyword          |
  | f5_bigip.log.browser_verification_status               |                                                                                           | keyword          |
  | f5_bigip.log.bytes.in                                  |                                                                                           | long             |
  | f5_bigip.log.bytes.out                                 |                                                                                           | long             |
  | f5_bigip.log.bytes.total                               |                                                                                           | long             |
  | f5_bigip.log.callback_url                              |                                                                                           | keyword          |
  | f5_bigip.log.captcha_result                            |                                                                                           | keyword          |
  | f5_bigip.log.captcha_status                            |                                                                                           | keyword          |
  | f5_bigip.log.chassis_id                                |                                                                                           | keyword          |
  | f5_bigip.log.class                                     |                                                                                           | keyword          |
  | f5_bigip.log.classification_reason                     |                                                                                           | keyword          |
  | f5_bigip.log.client.ip                                 |                                                                                           | ip               |
  | f5_bigip.log.client.ip_geo_location                    |                                                                                           | keyword          |
  | f5_bigip.log.client.ip_route_domain                    |                                                                                           | keyword          |
  | f5_bigip.log.client.latency.hit_count                  |                                                                                           | long             |
  | f5_bigip.log.client.latency.max                        |                                                                                           | long             |
  | f5_bigip.log.client.latency.total                      |                                                                                           | long             |
  | f5_bigip.log.client.port                               |                                                                                           | long             |
  | f5_bigip.log.client.request_uri                        |                                                                                           | keyword          |
  | f5_bigip.log.client.type                               |                                                                                           | keyword          |
  | f5_bigip.log.client_side.network.latency               |                                                                                           | long             |
  | f5_bigip.log.client_side.network.max_latency           |                                                                                           | long             |
  | f5_bigip.log.client_side.network.min_latency           |                                                                                           | long             |
  | f5_bigip.log.client_ttfb.hit_count                     |                                                                                           | long             |
  | f5_bigip.log.client_ttfb.max                           |                                                                                           | long             |
  | f5_bigip.log.client_ttfb.min                           |                                                                                           | long             |
  | f5_bigip.log.client_ttfb.value                         |                                                                                           | long             |
  | f5_bigip.log.compression_method                        |                                                                                           | keyword          |
  | f5_bigip.log.concurrent.connections.avg                |                                                                                           | long             |
  | f5_bigip.log.concurrent.connections.health             |                                                                                           | long             |
  | f5_bigip.log.concurrent.connections.max                |                                                                                           | long             |
  | f5_bigip.log.concurrent.users.max                      |                                                                                           | long             |
  | f5_bigip.log.config_ready                              |                                                                                           | keyword          |
  | f5_bigip.log.config_sync_succeeded                     |                                                                                           | boolean          |
  | f5_bigip.log.configuration_date_time                   |                                                                                           | date             |
  | f5_bigip.log.configured_mitigation_action.reason       |                                                                                           | keyword          |
  | f5_bigip.log.configured_mitigation_action.value        |                                                                                           | keyword          |
  | f5_bigip.log.connections_performance.*.average         |                                                                                           | object           |
  | f5_bigip.log.connections_performance.*.current         |                                                                                           | object           |
  | f5_bigip.log.connections_performance.*.max             |                                                                                           | object           |
  | f5_bigip.log.context.name                              |                                                                                           | keyword          |
  | f5_bigip.log.context.type                              |                                                                                           | keyword          |
  | f5_bigip.log.continent                                 |                                                                                           | keyword          |
  | f5_bigip.log.conviction_traps                          |                                                                                           | keyword          |
  | f5_bigip.log.cookie                                    |                                                                                           | keyword          |
  | f5_bigip.log.country                                   |                                                                                           | keyword          |
  | f5_bigip.log.country_code                              |                                                                                           | keyword          |
  | f5_bigip.log.cpu.analysis_plane.avg                    |                                                                                           | long             |
  | f5_bigip.log.cpu.avg                                   |                                                                                           | long             |
  | f5_bigip.log.cpu.control_plane.avg                     |                                                                                           | long             |
  | f5_bigip.log.cpu.data_plane.avg                        |                                                                                           | long             |
  | f5_bigip.log.cpu.health                                |                                                                                           | long             |
  | f5_bigip.log.cpu_value                                 |                                                                                           | long             |
  | f5_bigip.log.credential_stuffing_lookup_result         |                                                                                           | keyword          |
  | f5_bigip.log.date_time                                 |                                                                                           | date             |
  | f5_bigip.log.description                               |                                                                                           | keyword          |
  | f5_bigip.log.dest.fqdn                                 |                                                                                           | keyword          |
  | f5_bigip.log.dest.ip                                   |                                                                                           | ip               |
  | f5_bigip.log.dest.ipint_categories                     |                                                                                           | keyword          |
  | f5_bigip.log.dest.port                                 |                                                                                           | long             |
  | f5_bigip.log.dest.vlan                                 |                                                                                           | keyword          |
  | f5_bigip.log.dest.zone                                 |                                                                                           | keyword          |
  | f5_bigip.log.destination.ip                            |                                                                                           | ip               |
  | f5_bigip.log.destination.port                          |                                                                                           | long             |
  | f5_bigip.log.detection.avg                             |                                                                                           | long             |
  | f5_bigip.log.device.blade                              |                                                                                           | keyword          |
  | f5_bigip.log.device.id                                 |                                                                                           | keyword          |
  | f5_bigip.log.device.product                            |                                                                                           | keyword          |
  | f5_bigip.log.device.vendor                             |                                                                                           | keyword          |
  | f5_bigip.log.device.version                            |                                                                                           | keyword          |
  | f5_bigip.log.device_id.action                          |                                                                                           | keyword          |
  | f5_bigip.log.device_id.status                          |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.action                        |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.cve_ids                       |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.header                        |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.importance                    |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.name                          |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.solution.id                   |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.solution.value                |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.summary                       |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.version.fix                   |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.version.maintenance           |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.version.major                 |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.version.minor                 |                                                                                           | keyword          |
  | f5_bigip.log.diagnostics.version.point                 |                                                                                           | keyword          |
  | f5_bigip.log.disk_latency.*.per_util                   |                                                                                           | object           |
  | f5_bigip.log.disk_latency.*.r/s                        |                                                                                           | object           |
  | f5_bigip.log.disk_latency.*.w/s                        |                                                                                           | object           |
  | f5_bigip.log.disk_storage.*.1024_blocks                |                                                                                           | object           |
  | f5_bigip.log.disk_storage.*.capacity_float             |                                                                                           | object           |
  | f5_bigip.log.dos.attack.detection_mode                 |                                                                                           | keyword          |
  | f5_bigip.log.dos.attack.event                          |                                                                                           | keyword          |
  | f5_bigip.log.dos.attack.id                             |                                                                                           | keyword          |
  | f5_bigip.log.dos.attack.latency                        |                                                                                           | keyword          |
  | f5_bigip.log.dos.attack.name                           |                                                                                           | keyword          |
  | f5_bigip.log.dos.attack.tps                            |                                                                                           | keyword          |
  | f5_bigip.log.dos.baseline.latency                      |                                                                                           | keyword          |
  | f5_bigip.log.dos.baseline.tps                          |                                                                                           | keyword          |
  | f5_bigip.log.dos.baseline.traffic_percent              |                                                                                           | keyword          |
  | f5_bigip.log.dos.current_traffic_percent               |                                                                                           | keyword          |
  | f5_bigip.log.dos.dropped_requests_count                |                                                                                           | long             |
  | f5_bigip.log.dos.incoming_requests_count               |                                                                                           | long             |
  | f5_bigip.log.dos.mobile_app.client_type                |                                                                                           | keyword          |
  | f5_bigip.log.dos.mobile_app.display_name               |                                                                                           | keyword          |
  | f5_bigip.log.dos.mobile_app.version                    |                                                                                           | keyword          |
  | f5_bigip.log.dos.profile_name                          |                                                                                           | keyword          |
  | f5_bigip.log.dos_detection.condition                   |                                                                                           | keyword          |
  | f5_bigip.log.dos_detection.threshold                   |                                                                                           | keyword          |
  | f5_bigip.log.dos_mitigate_to_threshold                 |                                                                                           | keyword          |
  | f5_bigip.log.dos_mitigation.action                     |                                                                                           | keyword          |
  | f5_bigip.log.dos_mitigation.reason                     |                                                                                           | keyword          |
  | f5_bigip.log.dos_mitigation.threshold                  |                                                                                           | long             |
  | f5_bigip.log.drop_reason                               |                                                                                           | keyword          |
  | f5_bigip.log.dst.geo                                   |                                                                                           | keyword          |
  | f5_bigip.log.enforced_by                               |                                                                                           | keyword          |
  | f5_bigip.log.enforcement_action                        |                                                                                           | keyword          |
  | f5_bigip.log.entity                                    |                                                                                           | keyword          |
  | f5_bigip.log.eoc.timestamp                             |                                                                                           | date             |
  | f5_bigip.log.epoch_time                                |                                                                                           | date             |
  | f5_bigip.log.errdefs.msg_name                          |                                                                                           | keyword          |
  | f5_bigip.log.errdefs.msgno                             |                                                                                           | keyword          |
  | f5_bigip.log.event.id                                  |                                                                                           | keyword          |
  | f5_bigip.log.event.source                              |                                                                                           | keyword          |
  | f5_bigip.log.event.timestamp                           |                                                                                           | date             |
  | f5_bigip.log.events.total                              |                                                                                           | long             |
  | f5_bigip.log.expired_conns                             |                                                                                           | long             |
  | f5_bigip.log.failed_conns                              |                                                                                           | long             |
  | f5_bigip.log.failover_color                            |                                                                                           | keyword          |
  | f5_bigip.log.failover_status                           |                                                                                           | keyword          |
  | f5_bigip.log.flow.id                                   |                                                                                           | keyword          |
  | f5_bigip.log.fragment                                  |                                                                                           | keyword          |
  | f5_bigip.log.geo.code                                  |                                                                                           | keyword          |
  | f5_bigip.log.geo.country                               |                                                                                           | keyword          |
  | f5_bigip.log.geo.info                                  |                                                                                           | keyword          |
  | f5_bigip.log.geo.location                              |                                                                                           | keyword          |
  | f5_bigip.log.global_bigiq_conf                         |                                                                                           | keyword          |
  | f5_bigip.log.gtm_config_time                           |                                                                                           | date             |
  | f5_bigip.log.hardware_drops                            |                                                                                           | long             |
  | f5_bigip.log.headers                                   |                                                                                           | keyword          |
  | f5_bigip.log.hit_count                                 |                                                                                           | long             |
  | f5_bigip.log.hostname                                  |                                                                                           | keyword          |
  | f5_bigip.log.http.cache_control                        |                                                                                           | keyword          |
  | f5_bigip.log.http.class_name                           |                                                                                           | keyword          |
  | f5_bigip.log.http.connection                           |                                                                                           | keyword          |
  | f5_bigip.log.http.content_type                         |                                                                                           | keyword          |
  | f5_bigip.log.http.host                                 |                                                                                           | keyword          |
  | f5_bigip.log.http.method                               |                                                                                           | keyword          |
  | f5_bigip.log.http.other_headers                        |                                                                                           | keyword          |
  | f5_bigip.log.http.path                                 |                                                                                           | keyword          |
  | f5_bigip.log.http.pragma                               |                                                                                           | keyword          |
  | f5_bigip.log.http.protocol_indication                  |                                                                                           | keyword          |
  | f5_bigip.log.http.referrer                             |                                                                                           | keyword          |
  | f5_bigip.log.http.request                              |                                                                                           | keyword          |
  | f5_bigip.log.http.request_host                         |                                                                                           | ip               |
  | f5_bigip.log.http.status                               |                                                                                           | keyword          |
  | f5_bigip.log.http.uri                                  |                                                                                           | keyword          |
  | f5_bigip.log.http.url                                  |                                                                                           | keyword          |
  | f5_bigip.log.http.user_agent                           |                                                                                           | keyword          |
  | f5_bigip.log.http.version                              |                                                                                           | keyword          |
  | f5_bigip.log.human_behaviour                           |                                                                                           | keyword          |
  | f5_bigip.log.hw.cookie_valid                           |                                                                                           | long             |
  | f5_bigip.log.imei                                      |                                                                                           | keyword          |
  | f5_bigip.log.ip_address_intelligence                   |                                                                                           | keyword          |
  | f5_bigip.log.ip_protocol                               |                                                                                           | keyword          |
  | f5_bigip.log.ip_reputation                             |                                                                                           | keyword          |
  | f5_bigip.log.ip_route_domain                           |                                                                                           | keyword          |
  | f5_bigip.log.ip_with_route_domain                      |                                                                                           | keyword          |
  | f5_bigip.log.is_attacking_ip                           |                                                                                           | boolean          |
  | f5_bigip.log.is_internal_activity                      |                                                                                           | boolean          |
  | f5_bigip.log.is_mobile_device                          |                                                                                           | boolean          |
  | f5_bigip.log.is_truncated                              |                                                                                           | keyword          |
  | f5_bigip.log.is_trunct                                 |                                                                                           | keyword          |
  | f5_bigip.log.jailbroken_or_rooted_device               |                                                                                           | keyword          |
  | f5_bigip.log.last_afm_deploy                           |                                                                                           | date             |
  | f5_bigip.log.last_asm_change                           |                                                                                           | date             |
  | f5_bigip.log.latency_histogram                         |                                                                                           | keyword          |
  | f5_bigip.log.license_ready                             |                                                                                           | keyword          |
  | f5_bigip.log.likely_false_positive_sig_ids             |                                                                                           | keyword          |
  | f5_bigip.log.listener                                  |                                                                                           | keyword          |
  | f5_bigip.log.location                                  |                                                                                           | keyword          |
  | f5_bigip.log.login_result                              |                                                                                           | keyword          |
  | f5_bigip.log.ltm_config_time                           |                                                                                           | date             |
  | f5_bigip.log.machine_id                                |                                                                                           | keyword          |
  | f5_bigip.log.management.ip_address                     |                                                                                           | ip               |
  | f5_bigip.log.management.ip_address_2                   |                                                                                           | ip               |
  | f5_bigip.log.marketing_name                            |                                                                                           | keyword          |
  | f5_bigip.log.max_active_conns                          |                                                                                           | long             |
  | f5_bigip.log.memory.avg                                |                                                                                           | long             |
  | f5_bigip.log.memory.health                             |                                                                                           | long             |
  | f5_bigip.log.memory_value                              |                                                                                           | long             |
  | f5_bigip.log.method                                    |                                                                                           | keyword          |
  | f5_bigip.log.mgmt_ip                                   |                                                                                           | ip               |
  | f5_bigip.log.micro_service.hostname                    |                                                                                           | keyword          |
  | f5_bigip.log.micro_service.matched_wildcard_url        |                                                                                           | keyword          |
  | f5_bigip.log.micro_service.name                        |                                                                                           | keyword          |
  | f5_bigip.log.micro_service.type                        |                                                                                           | keyword          |
  | f5_bigip.log.microservice                              |                                                                                           | keyword          |
  | f5_bigip.log.mitigation.max                            |                                                                                           | long             |
  | f5_bigip.log.mitigation.min                            |                                                                                           | long             |
  | f5_bigip.log.mobile_application.name                   |                                                                                           | keyword          |
  | f5_bigip.log.mobile_application.version                |                                                                                           | keyword          |
  | f5_bigip.log.mobile_in_emulation_mode                  |                                                                                           | keyword          |
  | f5_bigip.log.mobile_is_app                             |                                                                                           | keyword          |
  | f5_bigip.log.module                                    |                                                                                           | keyword          |
  | f5_bigip.log.network.protocol                          |                                                                                           | keyword          |
  | f5_bigip.log.network_interfaces                        |                                                                                           | flattened        |
  | f5_bigip.log.new_conns                                 |                                                                                           | long             |
  | f5_bigip.log.new_request_status                        |                                                                                           | keyword          |
  | f5_bigip.log.node                                      |                                                                                           | ip               |
  | f5_bigip.log.node_port                                 |                                                                                           | long             |
  | f5_bigip.log.object_tags_list                          |                                                                                           | keyword          |
  | f5_bigip.log.operation.id                              |                                                                                           | keyword          |
  | f5_bigip.log.osname                                    |                                                                                           | keyword          |
  | f5_bigip.log.partition                                 |                                                                                           | keyword          |
  | f5_bigip.log.partition_name                            |                                                                                           | keyword          |
  | f5_bigip.log.password_hash_prefix                      |                                                                                           | keyword          |
  | f5_bigip.log.platform_id                               |                                                                                           | keyword          |
  | f5_bigip.log.policy.apply_date                         |                                                                                           | date             |
  | f5_bigip.log.policy.name                               |                                                                                           | keyword          |
  | f5_bigip.log.pool.ip                                   |                                                                                           | ip               |
  | f5_bigip.log.pool.ip_route_domain                      |                                                                                           | keyword          |
  | f5_bigip.log.pool.port                                 |                                                                                           | long             |
  | f5_bigip.log.previous.action                           |                                                                                           | keyword          |
  | f5_bigip.log.previous.initiated_action.status          |                                                                                           | keyword          |
  | f5_bigip.log.previous.initiated_action.value           |                                                                                           | keyword          |
  | f5_bigip.log.previous.request_date_time                |                                                                                           | date             |
  | f5_bigip.log.previous.requests_status                  |                                                                                           | date             |
  | f5_bigip.log.previous.support_id                       |                                                                                           | keyword          |
  | f5_bigip.log.profile.name                              |                                                                                           | keyword          |
  | f5_bigip.log.profile_name                              |                                                                                           | keyword          |
  | f5_bigip.log.protocol                                  |                                                                                           | keyword          |
  | f5_bigip.log.protocol_info                             |                                                                                           | keyword          |
  | f5_bigip.log.provision_ready                           |                                                                                           | keyword          |
  | f5_bigip.log.provisioning                              |                                                                                           | flattened        |
  | f5_bigip.log.query.name                                |                                                                                           | keyword          |
  | f5_bigip.log.query.sam_account_name                    |                                                                                           | keyword          |
  | f5_bigip.log.query.string                              |                                                                                           | keyword          |
  | f5_bigip.log.query.type                                |                                                                                           | keyword          |
  | f5_bigip.log.query.user_name                           |                                                                                           | keyword          |
  | f5_bigip.log.query.user_principle_name                 |                                                                                           | keyword          |
  | f5_bigip.log.reason                                    |                                                                                           | keyword          |
  | f5_bigip.log.reported_entity_type                      |                                                                                           | keyword          |
  | f5_bigip.log.reputation                                |                                                                                           | keyword          |
  | f5_bigip.log.req.elapsed_time                          |                                                                                           | long             |
  | f5_bigip.log.req.start_time                            |                                                                                           | date             |
  | f5_bigip.log.request.accept                            |                                                                                           | keyword          |
  | f5_bigip.log.request.cache_control                     |                                                                                           | keyword          |
  | f5_bigip.log.request.connection                        |                                                                                           | keyword          |
  | f5_bigip.log.request.date_time                         |                                                                                           | date             |
  | f5_bigip.log.request.detail                            |                                                                                           | keyword          |
  | f5_bigip.log.request.duration                          |                                                                                           | long             |
  | f5_bigip.log.request.duration_hit_count                |                                                                                           | long             |
  | f5_bigip.log.request.host                              |                                                                                           | keyword          |
  | f5_bigip.log.request.max_duration                      |                                                                                           | long             |
  | f5_bigip.log.request.method                            |                                                                                           | keyword          |
  | f5_bigip.log.request.min_duration                      |                                                                                           | long             |
  | f5_bigip.log.request.path                              |                                                                                           | keyword          |
  | f5_bigip.log.request.protocol                          |                                                                                           | keyword          |
  | f5_bigip.log.request.status                            |                                                                                           | keyword          |
  | f5_bigip.log.request.user_agent                        |                                                                                           | keyword          |
  | f5_bigip.log.request.x_forwarded_for                   |                                                                                           | keyword          |
  | f5_bigip.log.request_date_time                         |                                                                                           | date             |
  | f5_bigip.log.request_status                            |                                                                                           | keyword          |
  | f5_bigip.log.res.start_time                            |                                                                                           | date             |
  | f5_bigip.log.resp                                      |                                                                                           | keyword          |
  | f5_bigip.log.response.code                             |                                                                                           | long             |
  | f5_bigip.log.response.duration                         |                                                                                           | long             |
  | f5_bigip.log.response.duration_hit_count               |                                                                                           | long             |
  | f5_bigip.log.response.max_duration                     |                                                                                           | long             |
  | f5_bigip.log.response.min_duration                     |                                                                                           | long             |
  | f5_bigip.log.response.value                            |                                                                                           | keyword          |
  | f5_bigip.log.route_domain                              |                                                                                           | keyword          |
  | f5_bigip.log.rxbad_cookie                              |                                                                                           | long             |
  | f5_bigip.log.rxbadseg                                  |                                                                                           | long             |
  | f5_bigip.log.rxbadsum                                  |                                                                                           | long             |
  | f5_bigip.log.rxcookie                                  |                                                                                           | long             |
  | f5_bigip.log.rxooseg                                   |                                                                                           | long             |
  | f5_bigip.log.rxrst                                     |                                                                                           | long             |
  | f5_bigip.log.sa_translation.pool                       |                                                                                           | keyword          |
  | f5_bigip.log.sa_translation.type                       |                                                                                           | keyword          |
  | f5_bigip.log.send_to_vs                                |                                                                                           | keyword          |
  | f5_bigip.log.server.hit_count                          |                                                                                           | long             |
  | f5_bigip.log.server.ip                                 |                                                                                           | ip               |
  | f5_bigip.log.server.latency.max                        |                                                                                           | long             |
  | f5_bigip.log.server.latency.min                        |                                                                                           | long             |
  | f5_bigip.log.server.latency.total                      |                                                                                           | long             |
  | f5_bigip.log.server_side.network.latency               |                                                                                           | long             |
  | f5_bigip.log.server_side.network.max_latency           |                                                                                           | long             |
  | f5_bigip.log.server_side.network.min_latency           |                                                                                           | long             |
  | f5_bigip.log.session.id                                |                                                                                           | keyword          |
  | f5_bigip.log.severity.code                             |                                                                                           | long             |
  | f5_bigip.log.severity.name                             |                                                                                           | keyword          |
  | f5_bigip.log.sig.cves                                  |                                                                                           | keyword          |
  | f5_bigip.log.sig.ids                                   |                                                                                           | keyword          |
  | f5_bigip.log.sig.names                                 |                                                                                           | keyword          |
  | f5_bigip.log.sig.set_names                             |                                                                                           | keyword          |
  | f5_bigip.log.slot.id                                   |                                                                                           | keyword          |
  | f5_bigip.log.slot.number                               |                                                                                           | long             |
  | f5_bigip.log.sndpack                                   |                                                                                           | long             |
  | f5_bigip.log.software_drops                            |                                                                                           | long             |
  | f5_bigip.log.sos.application_response_time             |                                                                                           | long             |
  | f5_bigip.log.sos.client_side_network_latency           |                                                                                           | long             |
  | f5_bigip.log.sos.client_ttfb                           |                                                                                           | long             |
  | f5_bigip.log.sos.request_duration                      |                                                                                           | long             |
  | f5_bigip.log.sos.response_duration                     |                                                                                           | long             |
  | f5_bigip.log.sos.server_side_network_latency           |                                                                                           | long             |
  | f5_bigip.log.source.fqdn                               |                                                                                           | keyword          |
  | f5_bigip.log.source.ip                                 |                                                                                           | ip               |
  | f5_bigip.log.source.ip_route_domain                    |                                                                                           | keyword          |
  | f5_bigip.log.source.ipint_categories                   |                                                                                           | keyword          |
  | f5_bigip.log.source.port                               |                                                                                           | long             |
  | f5_bigip.log.source.user                               |                                                                                           | keyword          |
  | f5_bigip.log.source.user_group                         |                                                                                           | keyword          |
  | f5_bigip.log.src.geo                                   |                                                                                           | keyword          |
  | f5_bigip.log.src.ip                                    |                                                                                           | ip               |
  | f5_bigip.log.src.port                                  |                                                                                           | long             |
  | f5_bigip.log.src.zone                                  |                                                                                           | keyword          |
  | f5_bigip.log.staged.sig.cves                           |                                                                                           | keyword          |
  | f5_bigip.log.staged.sig.ids                            |                                                                                           | keyword          |
  | f5_bigip.log.staged.sig.names                          |                                                                                           | keyword          |
  | f5_bigip.log.staged.sig.set_names                      |                                                                                           | keyword          |
  | f5_bigip.log.staged.threat_campaign_names              |                                                                                           | keyword          |
  | f5_bigip.log.stat_src                                  |                                                                                           | keyword          |
  | f5_bigip.log.state                                     |                                                                                           | keyword          |
  | f5_bigip.log.sub_violations                            |                                                                                           | keyword          |
  | f5_bigip.log.subnet.ip                                 |                                                                                           | ip               |
  | f5_bigip.log.subnet.name                               |                                                                                           | keyword          |
  | f5_bigip.log.subnet.route_domain                       |                                                                                           | keyword          |
  | f5_bigip.log.support.id                                |                                                                                           | keyword          |
  | f5_bigip.log.swap                                      |                                                                                           | long             |
  | f5_bigip.log.sync_color                                |                                                                                           | keyword          |
  | f5_bigip.log.sync_mode                                 |                                                                                           | keyword          |
  | f5_bigip.log.sync_status                               |                                                                                           | keyword          |
  | f5_bigip.log.sync_summary                              |                                                                                           | keyword          |
  | f5_bigip.log.syncacheover                              |                                                                                           | long             |
  | f5_bigip.log.system.hostname                           |                                                                                           | keyword          |
  | f5_bigip.log.system.ihealth_link                       |                                                                                           | keyword          |
  | f5_bigip.log.system.qkview_number                      |                                                                                           | keyword          |
  | f5_bigip.log.system_timestamp                          |                                                                                           | date             |
  | f5_bigip.log.tap.event_id                              |                                                                                           | keyword          |
  | f5_bigip.log.tap.requested_actions                     |                                                                                           | keyword          |
  | f5_bigip.log.tap.sent_token                            |                                                                                           | long             |
  | f5_bigip.log.tap.transaction_id                        |                                                                                           | keyword          |
  | f5_bigip.log.tap.vid                                   |                                                                                           | keyword          |
  | f5_bigip.log.tcp_prof                                  |                                                                                           | keyword          |
  | f5_bigip.log.telemetry.event.category                  |                                                                                           | keyword          |
  | f5_bigip.log.telemetry.timestamp                       |                                                                                           | date             |
  | f5_bigip.log.telemetry_service_info.cycle_end          |                                                                                           | date             |
  | f5_bigip.log.telemetry_service_info.cycle_start        |                                                                                           | date             |
  | f5_bigip.log.telemetry_service_info.polling_interval   |                                                                                           | long             |
  | f5_bigip.log.tenant                                    |                                                                                           | keyword          |
  | f5_bigip.log.threat_campaign_names                     |                                                                                           | keyword          |
  | f5_bigip.log.throughput.avg                            |                                                                                           | long             |
  | f5_bigip.log.throughput.health                         |                                                                                           | long             |
  | f5_bigip.log.throughput.req_per_interval.total         |                                                                                           | long             |
  | f5_bigip.log.throughput.req_per_sec.max                |                                                                                           | long             |
  | f5_bigip.log.throughput.resp_per_interval.total        |                                                                                           | long             |
  | f5_bigip.log.throughput.resp_per_sec.max               |                                                                                           | long             |
  | f5_bigip.log.throughput_performance.*.average          |                                                                                           | object           |
  | f5_bigip.log.throughput_performance.*.current          |                                                                                           | object           |
  | f5_bigip.log.throughput_performance.*.max              |                                                                                           | object           |
  | f5_bigip.log.timestamp                                 |                                                                                           | date             |
  | f5_bigip.log.tmm_cpu                                   |                                                                                           | long             |
  | f5_bigip.log.tmm_memory                                |                                                                                           | long             |
  | f5_bigip.log.tmm_traffic.client_side_traffic.bits_in   |                                                                                           | long             |
  | f5_bigip.log.tmm_traffic.client_side_traffic.bits_out  |                                                                                           | long             |
  | f5_bigip.log.tmm_traffic.server_side_traffic.bits_in   |                                                                                           | long             |
  | f5_bigip.log.tmm_traffic.server_side_traffic.bits_out  |                                                                                           | long             |
  | f5_bigip.log.tps.max                                   |                                                                                           | double           |
  | f5_bigip.log.transaction_outcome                       |                                                                                           | keyword          |
  | f5_bigip.log.translated.dest.ip                        |                                                                                           | ip               |
  | f5_bigip.log.translated.dest.port                      |                                                                                           | long             |
  | f5_bigip.log.translated.ip_protocol                    |                                                                                           | keyword          |
  | f5_bigip.log.translated.route_domain                   |                                                                                           | keyword          |
  | f5_bigip.log.translated.source.ip                      |                                                                                           | ip               |
  | f5_bigip.log.translated.source.port                    |                                                                                           | long             |
  | f5_bigip.log.translated.vlan                           |                                                                                           | keyword          |
  | f5_bigip.log.txrexmits                                 |                                                                                           | long             |
  | f5_bigip.log.unit_host                                 |                                                                                           | keyword          |
  | f5_bigip.log.unit_hostname                             |                                                                                           | keyword          |
  | f5_bigip.log.uri                                       |                                                                                           | keyword          |
  | f5_bigip.log.url                                       |                                                                                           | keyword          |
  | f5_bigip.log.user.agent                                |                                                                                           | keyword          |
  | f5_bigip.log.user.name                                 |                                                                                           | keyword          |
  | f5_bigip.log.user.sessions.new_total                   |                                                                                           | long             |
  | f5_bigip.log.username                                  |                                                                                           | keyword          |
  | f5_bigip.log.version                                   |                                                                                           | keyword          |
  | f5_bigip.log.version_build                             |                                                                                           | keyword          |
  | f5_bigip.log.violate_details                           |                                                                                           | keyword          |
  | f5_bigip.log.violation.details                         |                                                                                           | keyword          |
  | f5_bigip.log.violation.rating                          |                                                                                           | long             |
  | f5_bigip.log.violations                                |                                                                                           | keyword          |
  | f5_bigip.log.vip                                       |                                                                                           | keyword          |
  | f5_bigip.log.virtual.ip                                |                                                                                           | ip               |
  | f5_bigip.log.virtual.name                              |                                                                                           | keyword          |
  | f5_bigip.log.virtual.server                            |                                                                                           | keyword          |
  | f5_bigip.log.virtual_server_name                       |                                                                                           | keyword          |
  | f5_bigip.log.virus_name                                |                                                                                           | keyword          |
  | f5_bigip.log.vlan                                      |                                                                                           | keyword          |
  | f5_bigip.log.vs_name                                   |                                                                                           | keyword          |
  | f5_bigip.log.web_application_name                      |                                                                                           | keyword          |
  | f5_bigip.log.websocket.direction                       |                                                                                           | keyword          |
  | f5_bigip.log.websocket.message_type                    |                                                                                           | keyword          |
  | f5_bigip.log.wl_events                                 |                                                                                           | long             |
  | f5_bigip.log.x_forwarded_for_header_value              |                                                                                           | ip               |
  | host.containerized                                     | If the host is a container.                                                               | boolean          |
  | host.os.build                                          | OS build information.                                                                     | keyword          |
  | host.os.codename                                       | OS codename, if any.                                                                      | keyword          |
  | input.type                                             | Input type                                                                                | keyword          |
  | log.file.device_id                                     | ID of the device containing the filesystem where the file resides.                        | keyword          |
  | log.file.fingerprint                                   | The sha256 fingerprint identity of the file when fingerprinting is enabled.               | keyword          |
  | log.file.idxhi                                         | The high-order part of a unique identifier that is associated with a file. (Windows-only) | keyword          |
  | log.file.idxlo                                         | The low-order part of a unique identifier that is associated with a file. (Windows-only)  | keyword          |
  | log.file.inode                                         | Inode number of the log file.                                                             | keyword          |
  | log.file.vol                                           | The serial number of the volume that contains a file. (Windows-only)                      | keyword          |
  | log.offset                                             | Log offset                                                                                | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![F5 BIG-IP dashboard screenshot](https://epr.elastic.co/package/f5_bigip/1.27.1/img/f5-bigip-screenshot.png)

  ![F5 BIG-IP System Information dashboard](https://epr.elastic.co/package/f5_bigip/1.27.1/img/f5-bigip-system-information.png)

  ![F5 BIG-IP IHealth Information dashboard](https://epr.elastic.co/package/f5_bigip/1.27.1/img/f5-bigip-ihealth-information.png)

  ![F5 BIG-IP Bot-DoS dashboard screenshot](https://epr.elastic.co/package/f5_bigip/1.27.1/img/f5-bigip-bot-dos.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                       | Minimum Kibana version |
  |------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                          | 9.0.08.16.5            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                   | 9.0.08.16.5            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                           | 9.0.08.16.2            |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                     | 8.16.2                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                    | 8.16.2                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12355))Add geoip processor for source and destination IPs.                                                                                                                                                  | 8.16.2                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                         | 8.16.2                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                   | 8.13.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                            | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11222))URL decode user agent strings.                                                                                                                                                                       | 8.13.0                 |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11027))Fix ASM script processor when `event.original` is absent.                                                                                                                                                | 8.13.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10718))Handle `x_forwarded_for_header_value` fields with multiple IP addresses.                                                                                                                             | 8.13.0                 |
  | **1.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10540))Update event.kind values based on severity.                                                                                                                                                              | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10355))Add Support of System Info, iHealth information, BOT and DOS logs.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10355))Add Support of new fields of ASM and APM. | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                  | 8.13.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9853))Clarify the supported events in README.                                                                                                                                                               | 8.12.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9510))Clarify the lack of support for syslog messages in README.                                                                                                                                            | 8.12.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9127))Set sensitive values as secret.                                                                                                                                                                       | 8.12.0                 |
  | **1.13.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                        | 8.0.07.17.0            |
  | **1.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                                | 8.0.07.17.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                        | 8.0.07.17.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                | 8.0.07.17.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8014))Adapt fields for changes in file system info                                                                                                                                                          | 8.0.07.17.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                                                                        | 8.0.07.17.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                             | 8.0.07.17.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                  | 8.0.07.17.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                                                                          | 8.0.07.17.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                              | 8.0.07.17.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6988))Provide logfile input.                                                                                                                                                                                | 8.0.07.17.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                               | 8.0.07.17.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                                                          | 8.0.07.17.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                                                                 | 8.0.07.17.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                          | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5677))Release F5 BIG-IP as GA.                                                                                                                                                                              | 8.0.07.17.0            |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4242))Initial Release.                                                                                                                                                                                      |                        |
</dropdown>