﻿---
title: ESET PROTECT
description: ESET PROTECT enables you to manage ESET products on workstations and servers in a networked environment with up to 50,000 devices from one central location...
url: https://www.elastic.co/docs/reference/integrations/eset_protect
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# ESET PROTECT
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.12.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | API, Network Protocol           |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.0                     |

ESET PROTECT enables you to manage ESET products on workstations and servers in a networked environment with up to 50,000 devices from one central location. Using the ESET PROTECT Web Console, you can deploy ESET solutions, manage tasks, enforce security policies, monitor system status, and quickly respond to problems or threats on remote computers.

## Data streams

The ESET PROTECT integration collects three types of logs: Detection, Device Task and Event.
**[Detection](https://help.eset.com/protect_cloud/en-US/admin_ct.html?threats.html)** is used to retrieve detections via the [ESET Connect - Incident Management](https://eu.business-account.iam.eset.systems/swagger/?urls.primaryName=Incident%20Management).
**[Device Task](https://help.eset.com/protect_cloud/en-US/admin_ct.html?admin_ct.html)** is used to retrieve device tasks via the [ESET Connect - Automation](https://eu.business-account.iam.eset.systems/swagger/?urls.primaryName=Automation).
**Event** is used to retrieve Detection, Firewall, HIPS, Audit, and ESET Inspect logs using the [Syslog Server](https://help.eset.com/protect_cloud/en-US/events-exported-to-json-format.html?admin_server_settings_export_to_syslog.html). ESET notifications are also retrieved but in plain text.

## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
This module has been tested against the **ESET PROTECT (version: 5.0.9.1)**.

## Setup


### Collect data from ESET Connect

1. [Create API User Account](https://help.eset.com/eset_connect/en-US/use_api_with_swagger.html?create_api_user_account.html)
2. Retrieve the username and password generated during the creation of an API user account.
3. Retrieve the region from the ESET Web Console URL.


### Collect data from ESET PROTECT via Syslog

Follow these steps to [configure syslog server](https://help.eset.com/protect_cloud/en-US/admin_server_settings_export_to_syslog.html?admin_server_settings_syslog.html):
1. Set the format of the payload to **JSON** (Hint: ESET Notifications are sent as plain text, regardless of the selection made ).
2. Set the format of the envelope to **Syslog**.
3. Set the minimal log level to **Information** to collect all data.
4. Select all checkboxes to collect logs for all event types.
5. Enter the **IP Address** or **FQDN** of the Elastic Agent that is running the integration in the Destination IP field.


### Enable the integration in Elastic

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **ESET PROTECT**.
3. Select the **ESET PROTECT** integration and add it.
4. Configure all required integration parameters, including username, password, and region, to enable data collection from the ESET Connect REST API. For syslog data collection, provide parameters such as listen address, listen port, and SSL settings.
5. Save the integration.


## Logs Reference


### Detection

This is the `Detection` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-10-26T13:36:53.000Z",
      "agent": {
          "ephemeral_id": "b51f7ff3-ce17-4024-92bc-3d0e88739447",
          "id": "b48af936-fff7-410e-bceb-954a720e7c99",
          "name": "elastic-agent-51462",
          "type": "filebeat",
          "version": "8.16.0"
      },
      "data_stream": {
          "dataset": "eset_protect.detection",
          "namespace": "23163",
          "type": "logs"
      },
      "destination": {
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.112",
          "port": 443
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "b48af936-fff7-410e-bceb-954a720e7c99",
          "snapshot": false,
          "version": "8.16.0"
      },
      "eset_protect": {
          "detection": {
              "category": "DETECTION_CATEGORY_NETWORK_INTRUSION",
              "context": {
                  "circumstances": "Eicar",
                  "device_uuid": "xxx-xxxx-1234-5678-xxxxxxxxxxxx",
                  "process": {
                      "path": "C:\\Windows\\chrome.exe"
                  },
                  "user_name": "testingpc\\example"
              },
              "network_communication": {
                  "protocol_name": "0",
                  "remote": {
                      "ip_address": "89.160.20.112",
                      "port": 443
                  }
              },
              "object_hash_sha1": "AAF4C61DDCC5E8A2DABEDE0F3B4820123456789D",
              "object_type_name": "File",
              "object_url": "C:\\Temp\\06516f11-xxxx-xxxx-xxxx-37da66b5de99_ccf7464ba6e2e12e984514f694bfb10d03de77358d8a3afd7a2ffed150ec1df8.zip.e99\\ccf7464ba6e2e12e984514f694bfb10d03de77358d8a3afd7a2ffed150ec1df8",
              "occur_time": "2023-10-26T13:36:53.000Z",
              "severity_level": "SEVERITY_LEVEL_MEDIUM",
              "type_name": "TCP Port scanning attack",
              "uuid": "xxx-xxxx-xxxx-1234-xxxxxxxxxxxx"
          }
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "intrusion_detection"
          ],
          "dataset": "eset_protect.detection",
          "ingested": "2025-11-10T06:06:25Z",
          "kind": "alert",
          "original": "{\"category\":\"DETECTION_CATEGORY_NETWORK_INTRUSION\",\"context\":{\"circumstances\":\"Eicar\",\"deviceUuid\":\"xxx-xxxx-1234-5678-xxxxxxxxxxxx\",\"process\":{\"path\":\"C:\\\\Windows\\\\chrome.exe\"},\"userName\":\"testingpc\\\\example\"},\"networkCommunication\":{\"protocolName\":\"0\",\"remoteIpAddress\":\"89.160.20.112\",\"remotePort\":443},\"objectHashSha1\":\"AAF4C61DDCC5E8A2DABEDE0F3B4820123456789D\",\"objectTypeName\":\"File\",\"objectUrl\":\"C:\\\\Temp\\\\06516f11-xxxx-xxxx-xxxx-37da66b5de99_ccf7464ba6e2e12e984514f694bfb10d03de77358d8a3afd7a2ffed150ec1df8.zip.e99\\\\ccf7464ba6e2e12e984514f694bfb10d03de77358d8a3afd7a2ffed150ec1df8\",\"occurTime\":\"2023-10-26T13:36:53Z\",\"responses\":[{}],\"severityLevel\":\"SEVERITY_LEVEL_MEDIUM\",\"typeName\":\"TCP Port scanning attack\",\"uuid\":\"xxx-xxxx-xxxx-1234-xxxxxxxxxxxx\"}",
          "type": [
              "info"
          ]
      },
      "file": {
          "hash": {
              "sha1": "aaf4c61ddcc5e8a2dabede0f3b4820123456789d"
          }
      },
      "host": {
          "id": "xxx-xxxx-1234-5678-xxxxxxxxxxxx"
      },
      "input": {
          "type": "cel"
      },
      "message": "Eicar",
      "observer": {
          "product": "ESET PROTECT",
          "type": "ids",
          "vendor": "ESET"
      },
      "process": {
          "executable": "C:\\Windows\\chrome.exe",
          "name": "chrome.exe"
      },
      "related": {
          "hash": [
              "aaf4c61ddcc5e8a2dabede0f3b4820123456789d"
          ],
          "hosts": [
              "xxx-xxxx-1234-5678-xxxxxxxxxxxx"
          ],
          "ip": [
              "89.160.20.112"
          ],
          "user": [
              "example"
          ]
      },
      "rule": {
          "category": "DETECTION_CATEGORY_NETWORK_INTRUSION"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "eset_protect-detection"
      ],
      "threat": {
          "technique": {
              "name": [
                  "TCP Port scanning attack"
              ]
          }
      },
      "user": {
          "domain": "testingpc",
          "name": "example"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                          | Description                                                                                                                                 | Type             |
  |----------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                     | Event timestamp.                                                                                                                            | date             |
  | data_stream.dataset                                            | Data stream dataset.                                                                                                                        | constant_keyword |
  | data_stream.namespace                                          | Data stream namespace.                                                                                                                      | constant_keyword |
  | data_stream.type                                               | Data stream type.                                                                                                                           | constant_keyword |
  | eset_protect.detection.category                                | Category of detection.                                                                                                                      | keyword          |
  | eset_protect.detection.context.circumstances                   | Human-friendly description of [detection]'s circumstances.                                                                                  | keyword          |
  | eset_protect.detection.context.device_uuid                     | Reference to [device].                                                                                                                      | keyword          |
  | eset_protect.detection.context.process.path                    | Disk path to the executable.                                                                                                                | keyword          |
  | eset_protect.detection.context.user_name                       | User name in whose context detection occurred.                                                                                              | keyword          |
  | eset_protect.detection.display_name                            | Human-friendly name of the detection. This value can be used to look up details at .                                                        | keyword          |
  | eset_protect.detection.network_communication.direction         | Direction of network communication.                                                                                                         | keyword          |
  | eset_protect.detection.network_communication.local.ip_address  | IPv4 or IPv6 address of the device (i.e. the device where detection occurred).                                                              | ip               |
  | eset_protect.detection.network_communication.local.port        | TCP or UDP port on the device (i.e. the device where detection occurred).                                                                   | long             |
  | eset_protect.detection.network_communication.protocol_name     | Human readable name of the protocol used to communicate between local and remote hosts.                                                     | keyword          |
  | eset_protect.detection.network_communication.remote.ip_address | IPv4 or IPv6 address of the remote host (i.e. not the device where detection occurred).                                                     | ip               |
  | eset_protect.detection.network_communication.remote.port       | TCP or UDP port on the remote host (i.e. not the device where detection occurred).                                                          | long             |
  | eset_protect.detection.object_hash_sha1                        | SHA1 hash of content of scanned object.                                                                                                     | keyword          |
  | eset_protect.detection.object_name                             | Name/path of scanned object.                                                                                                                | keyword          |
  | eset_protect.detection.object_type_name                        | Human-friendly type name of scanned object.                                                                                                 | keyword          |
  | eset_protect.detection.object_url                              | URL (uniform resource locator) of scanned object.                                                                                           | keyword          |
  | eset_protect.detection.occur_time                              | Timestamp of detection occurrence.                                                                                                          | date             |
  | eset_protect.detection.responses.description                   | Human-readable description of the response.                                                                                                 | keyword          |
  | eset_protect.detection.responses.device_restart_required       | Response needs restart of the device to be completed.                                                                                       | boolean          |
  | eset_protect.detection.responses.display_name                  | Human-friendly name of the response.                                                                                                        | keyword          |
  | eset_protect.detection.responses.protection_name               | Human-readable name of the protection that performed the response.                                                                          | keyword          |
  | eset_protect.detection.severity_level                          | Severity levels abstracted to cover all the possible GUIs. Vocabulary is leaving interpretation of severity level completely to API client. | keyword          |
  | eset_protect.detection.type_name                               | Human-friendly type of detection.                                                                                                           | keyword          |
  | eset_protect.detection.uuid                                    | Universally Unique Identifier of detection.                                                                                                 | keyword          |
  | event.dataset                                                  | Event dataset.                                                                                                                              | constant_keyword |
  | event.module                                                   | Event module.                                                                                                                               | constant_keyword |
  | input.type                                                     | Type of Filebeat input.                                                                                                                     | keyword          |
  | log.offset                                                     | Log offset.                                                                                                                                 | long             |
</dropdown>


### Device Task

This is the `Device Task` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-11-10T06:07:33.442Z",
      "agent": {
          "ephemeral_id": "2de42df7-1a70-45c2-bdb4-f36db2841c08",
          "id": "3d09e751-a7b0-418a-ba1c-07154b8f5558",
          "name": "elastic-agent-81384",
          "type": "filebeat",
          "version": "8.16.0"
      },
      "data_stream": {
          "dataset": "eset_protect.device_task",
          "namespace": "78597",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "3d09e751-a7b0-418a-ba1c-07154b8f5558",
          "snapshot": false,
          "version": "8.16.0"
      },
      "eset_protect": {
          "device_task": {
              "action": {
                  "name": "Shutdown computer",
                  "params": {
                      "@type": "type.googleapis.com/Era.Common.DataDefinition.Task.ESS.OnDemandScan",
                      "cleaning_enabled": true,
                      "custom_profile_name": "DefaultProfile",
                      "scan_profile": "InDepth",
                      "scan_targets": [
                          "eset://AllTargets"
                      ]
                  }
              },
              "description": "Automatically created via context menu",
              "display_name": "Reboot Computer - via context menu",
              "targets": {
                  "devices_uuids": [
                      "0205321e-XXXX-XXXX-1234-feeb35010ea7",
                      "0205321e-XXXX-XXXX-5678-feeb35010ea7",
                      "0205321e-XXXX-1234-5678-feeb35010ea7"
                  ]
              },
              "triggers": [
                  {
                      "manual": {
                          "expire_time": "2023-12-01T01:30:00.000Z"
                      }
                  }
              ],
              "uuid": "c93070e0-XXXX-1234-5678-c48f0e5e0b7e",
              "version_id": "1511"
          }
      },
      "event": {
          "action": "Shutdown computer",
          "agent_id_status": "verified",
          "dataset": "eset_protect.device_task",
          "ingested": "2025-11-10T06:07:36Z",
          "kind": "event",
          "original": "{\"action\":{\"name\":\"Shutdown computer\",\"params\":{\"@type\":\"type.googleapis.com/Era.Common.DataDefinition.Task.ESS.OnDemandScan\",\"cleaningEnabled\":true,\"customProfileName\":\"DefaultProfile\",\"scanProfile\":\"InDepth\",\"scanTargets\":[\"eset://AllTargets\"]}},\"description\":\"Automatically created via context menu\",\"displayName\":\"Reboot Computer - via context menu\",\"targets\":{\"devicesUuids\":[\"0205321e-XXXX-XXXX-1234-feeb35010ea7\",\"0205321e-XXXX-XXXX-5678-feeb35010ea7\",\"0205321e-XXXX-1234-5678-feeb35010ea7\"]},\"triggers\":[{\"manual\":{\"expireTime\":\"2023-12-01T01:30:00Z\"}}],\"uuid\":\"c93070e0-XXXX-1234-5678-c48f0e5e0b7e\",\"versionId\":\"1511\"}",
          "type": [
              "info"
          ]
      },
      "host": {
          "id": [
              "0205321e-XXXX-XXXX-1234-feeb35010ea7",
              "0205321e-XXXX-XXXX-5678-feeb35010ea7",
              "0205321e-XXXX-1234-5678-feeb35010ea7"
          ]
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hosts": [
              "0205321e-XXXX-XXXX-1234-feeb35010ea7",
              "0205321e-XXXX-XXXX-5678-feeb35010ea7",
              "0205321e-XXXX-1234-5678-feeb35010ea7"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "eset_protect-device_task"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                        | Description                                                                                      | Type             |
  |--------------------------------------------------------------|--------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                   | Event timestamp.                                                                                 | date             |
  | data_stream.dataset                                          | Data stream dataset.                                                                             | constant_keyword |
  | data_stream.namespace                                        | Data stream namespace.                                                                           | constant_keyword |
  | data_stream.type                                             | Data stream type.                                                                                | constant_keyword |
  | eset_protect.device_task.action.name                         | Name of the function to execute.                                                                 | keyword          |
  | eset_protect.device_task.action.params.@type                 | A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. | keyword          |
  | eset_protect.device_task.action.params.actions.cancel_action |                                                                                                  | boolean          |
  | eset_protect.device_task.action.params.actions.postpone      |                                                                                                  | keyword          |
  | eset_protect.device_task.action.params.cleaning_enabled      |                                                                                                  | boolean          |
  | eset_protect.device_task.action.params.custom_profile_name   |                                                                                                  | keyword          |
  | eset_protect.device_task.action.params.restart               |                                                                                                  | boolean          |
  | eset_protect.device_task.action.params.scan_profile          |                                                                                                  | keyword          |
  | eset_protect.device_task.action.params.scan_targets          |                                                                                                  | keyword          |
  | eset_protect.device_task.description                         | User's description.                                                                              | keyword          |
  | eset_protect.device_task.display_name                        | User friendly name of the task.                                                                  | keyword          |
  | eset_protect.device_task.targets.device_groups_uuids         | Task can be assigned to groups of devices.                                                       | keyword          |
  | eset_protect.device_task.targets.devices_uuids               | Task can be assigned to individual devices, for example if task run failed on these devices.     | keyword          |
  | eset_protect.device_task.triggers.manual.create_time         | When the manual trigger has been created. Task can only be triggered after this time.            | date             |
  | eset_protect.device_task.triggers.manual.expire_time         | Task is not triggered after this time.                                                           | date             |
  | eset_protect.device_task.uuid                                | Universally Unique Identifier for device task.                                                   | keyword          |
  | eset_protect.device_task.version_id                          | Identifier of entity version.                                                                    | keyword          |
  | event.dataset                                                | Event dataset.                                                                                   | constant_keyword |
  | event.module                                                 | Event module.                                                                                    | constant_keyword |
  | input.type                                                   | Type of Filebeat input.                                                                          | keyword          |
  | log.offset                                                   | Log offset.                                                                                      | long             |
</dropdown>


### Event

This is the `Event` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-06-21T03:56:20.000Z",
      "agent": {
          "ephemeral_id": "15db6629-f3a1-4a0f-94ea-1bf6ec62aaba",
          "id": "adf2804e-ca6b-4c6b-90af-e9060e7ee1b2",
          "name": "elastic-agent-28441",
          "type": "filebeat",
          "version": "8.16.0"
      },
      "data_stream": {
          "dataset": "eset_protect.event",
          "namespace": "71776",
          "type": "logs"
      },
      "destination": {
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.128"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "adf2804e-ca6b-4c6b-90af-e9060e7ee1b2",
          "snapshot": false,
          "version": "8.16.0"
      },
      "eset_protect": {
          "event": {
              "action_taken": "blocked",
              "group_description": "Lost & found static group",
              "group_name": "All/Lost & found",
              "hash": "ABCDAA625E6961037B8904E113FD0C232A7D0EDC",
              "hostname": "win-test",
              "ipv4": "192.168.30.30",
              "is_handled": false,
              "name": "An attempt to connect to URL",
              "object_uri": "https://example.com",
              "occured": "2021-06-21T03:56:20.000Z",
              "os_name": "Microsoft Windows 11 Pro",
              "processname": "C:\\Program Files\\Web browser\\brwser.exe",
              "rule_id": "Blocked by PUA blacklist",
              "scanner_id": "HTTP filter",
              "severity": "Warning",
              "source_uuid": "d9477661-8fa4-4144-b8d4-e37b983bcd69",
              "target_address": "89.160.20.128",
              "target_address_type": "IPv4",
              "type": "FilteredWebsites_Event",
              "username": "WIN-TEST\\Administrator"
          }
      },
      "event": {
          "action": "blocked",
          "agent_id_status": "verified",
          "category": [
              "web"
          ],
          "dataset": "eset_protect.event",
          "ingested": "2025-10-30T10:35:48Z",
          "kind": "alert",
          "original": "{\"event_type\":\"FilteredWebsites_Event\",\"ipv4\":\"192.168.30.30\",\"hostname\":\"win-test\",\"group_name\":\"All/Lost & found\",\"os_name\":\"Microsoft Windows 11 Pro\",\"group_description\":\"Lost & found static group\",\"source_uuid\":\"d9477661-8fa4-4144-b8d4-e37b983bcd69\",\"occured\":\"21-Jun-2021 03:56:20\",\"severity\":\"Warning\",\"event\":\"An attempt to connect to URL\",\"target_address\":\"89.160.20.128\",\"target_address_type\":\"IPv4\",\"scanner_id\":\"HTTP filter\",\"action_taken\":\"blocked\",\"object_uri\":\"https://example.com\",\"hash\":\"ABCDAA625E6961037B8904E113FD0C232A7D0EDC\",\"username\":\"WIN-TEST\\\\Administrator\",\"processname\":\"C:\\\\Program Files\\\\Web browser\\\\brwser.exe\",\"rule_id\":\"Blocked by PUA blacklist\"}",
          "type": [
              "info"
          ]
      },
      "group": {
          "name": "All/Lost & found"
      },
      "host": {
          "hostname": "win-test",
          "id": "d9477661-8fa4-4144-b8d4-e37b983bcd69",
          "ip": [
              "192.168.30.30"
          ],
          "name": "win-test",
          "os": {
              "name": "Microsoft Windows 11 Pro"
          }
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "192.168.241.3:58054"
          },
          "syslog": {
              "appname": "ERAServer",
              "facility": {
                  "code": 1,
                  "name": "user-level"
              },
              "hostname": "co7",
              "priority": 15,
              "procid": "75",
              "severity": {
                  "code": 7,
                  "name": "Debug"
              }
          }
      },
      "message": "An attempt to connect to URL",
      "process": {
          "executable": "C:\\Program Files\\Web browser\\brwser.exe",
          "name": "brwser.exe"
      },
      "related": {
          "hash": [
              "abcdaa625e6961037b8904e113fd0c232a7d0edc"
          ],
          "hosts": [
              "win-test",
              "d9477661-8fa4-4144-b8d4-e37b983bcd69"
          ],
          "ip": [
              "192.168.30.30",
              "89.160.20.128"
          ],
          "user": [
              "Administrator"
          ]
      },
      "rule": {
          "name": "Blocked by PUA blacklist"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "eset_protect-event"
      ],
      "threat": {
          "indicator": {
              "provider": "ESET PROTECT"
          }
      },
      "user": {
          "domain": "WIN-TEST",
          "name": "Administrator"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                        | Type             |
  |--------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                 | Event timestamp.                                                                                                                                                   | date             |
  | data_stream.dataset                        | Data stream dataset.                                                                                                                                               | constant_keyword |
  | data_stream.namespace                      | Data stream namespace.                                                                                                                                             | constant_keyword |
  | data_stream.type                           | Data stream type.                                                                                                                                                  | constant_keyword |
  | eset_protect.event.account                 | Name of the user account associated with the event.                                                                                                                | keyword          |
  | eset_protect.event.action                  | Action taken.                                                                                                                                                      | keyword          |
  | eset_protect.event.action_error            | Error message if the "action" was not successful.                                                                                                                  | keyword          |
  | eset_protect.event.action_taken            | Action taken by the Endpoint.                                                                                                                                      | keyword          |
  | eset_protect.event.aggregate_count         | How many exact same messages were generated by the endpoint between two consecutive replications between ESET PROTECT Server and managing ESET Management Agent.   | long             |
  | eset_protect.event.application             | Application name associated with the event.                                                                                                                        | keyword          |
  | eset_protect.event.cause                   |                                                                                                                                                                    | keyword          |
  | eset_protect.event.circumstances           | Short description of what caused the event.                                                                                                                        | keyword          |
  | eset_protect.event.command_line            | Command line of process which triggered detection.                                                                                                                 | keyword          |
  | eset_protect.event.computer_severity_score | Computer severity score associated with the event.                                                                                                                 | long             |
  | eset_protect.event.count                   | Number of alerts of this type generated since last alarm.                                                                                                          | long             |
  | eset_protect.event.description             | Description of the blocked file.                                                                                                                                   | keyword          |
  | eset_protect.event.detail                  | Detailed description of the action.                                                                                                                                | keyword          |
  | eset_protect.event.detection_uuid          | A detection's unique identifier can be used to query details via ESET CONNECT API.                                                                                 | keyword          |
  | eset_protect.event.domain                  | Audit log domain.                                                                                                                                                  | keyword          |
  | eset_protect.event.eialarmid               | ID sub-part of the alarm link ($1 in ^http.*/alarm/([0-9]+)$).                                                                                                     | keyword          |
  | eset_protect.event.eiconsolelink           | Link to the alarm in ESET Inspect console.                                                                                                                         | keyword          |
  | eset_protect.event.engine_version          | Version of the scanning engine.                                                                                                                                    | keyword          |
  | eset_protect.event.firstseen               | Time and date when the detection was found for the first time at that machine.                                                                                     | date             |
  | eset_protect.event.group_description       | Description of the static group.                                                                                                                                   | keyword          |
  | eset_protect.event.group_name              | The full path to the static group of the computer generating the event. If the path is longer than 255 characters, group_name only contains the static group name. | keyword          |
  | eset_protect.event.handled                 | Indicates whether or not the detection was handled.                                                                                                                | keyword          |
  | eset_protect.event.hash                    | SHA1 hash associated with the event.                                                                                                                               | keyword          |
  | eset_protect.event.hostname                | Hostname of the computer generating the event.                                                                                                                     | keyword          |
  | eset_protect.event.inbound                 | Whether or not the connection was inbound.                                                                                                                         | boolean          |
  | eset_protect.event.ipv4                    | IPv4 address of the computer generating the event.                                                                                                                 | ip               |
  | eset_protect.event.ipv6                    | IPv6 address of the computer generating the event.                                                                                                                 | ip               |
  | eset_protect.event.is_handled              | Indicates whether or not the detection was handled.                                                                                                                | boolean          |
  | eset_protect.event.name                    | Event name.                                                                                                                                                        | keyword          |
  | eset_protect.event.need_restart            | Whether or not the restart is needed.                                                                                                                              | boolean          |
  | eset_protect.event.object_type             | Type of object related to this event.                                                                                                                              | keyword          |
  | eset_protect.event.object_uri              | Object URI associated with the event.                                                                                                                              | keyword          |
  | eset_protect.event.occured                 | UTC time of occurrence of the event. Format is %d-%b-%Y %H:%M:%S.                                                                                                  | date             |
  | eset_protect.event.operation               | Operation associated with the event.                                                                                                                               | keyword          |
  | eset_protect.event.os_name                 | Information about the computer´s operating system.                                                                                                                 | keyword          |
  | eset_protect.event.processname             | Name of the process associated with the event.                                                                                                                     | keyword          |
  | eset_protect.event.protocol                | Protocol associated with the event.                                                                                                                                | keyword          |
  | eset_protect.event.result                  | Result of the action.                                                                                                                                              | keyword          |
  | eset_protect.event.rule_id                 | Rule ID associated with the event.                                                                                                                                 | keyword          |
  | eset_protect.event.rulename                | Rule name associated with the event.                                                                                                                               | keyword          |
  | eset_protect.event.scan_id                 | Scan ID associated with the event.                                                                                                                                 | keyword          |
  | eset_protect.event.scanner_id              | Scanner ID associated with the event.                                                                                                                              | keyword          |
  | eset_protect.event.severity                | Severity of the event. Possible values (from least severe to most severe) are: Information, Notice, Warning, Error, Critical, Fatal.                               | keyword          |
  | eset_protect.event.severity_score          | Rule severity score associated with the event.                                                                                                                     | long             |
  | eset_protect.event.source_address          | Address of the event source.                                                                                                                                       | ip               |
  | eset_protect.event.source_address_type     | Type of address of the event source.                                                                                                                               | keyword          |
  | eset_protect.event.source_port             | Port of the event source.                                                                                                                                          | long             |
  | eset_protect.event.source_uuid             | UUID of the computer generating the event.                                                                                                                         | keyword          |
  | eset_protect.event.target                  | Target action is operating on.                                                                                                                                     | keyword          |
  | eset_protect.event.target_address          | Address of the event destination.                                                                                                                                  | ip               |
  | eset_protect.event.target_address_type     | Type of address of the event destination.                                                                                                                          | keyword          |
  | eset_protect.event.target_port             | Port of the event destination.                                                                                                                                     | long             |
  | eset_protect.event.threat_flags            | Detection related flags.                                                                                                                                           | keyword          |
  | eset_protect.event.threat_handled          | Indicates whether or not the detection was handled.                                                                                                                | boolean          |
  | eset_protect.event.threat_name             | Name of the detection.                                                                                                                                             | keyword          |
  | eset_protect.event.threat_type             | Type of detection.                                                                                                                                                 | keyword          |
  | eset_protect.event.trigger_event           | Description of event which triggered detection.                                                                                                                    | keyword          |
  | eset_protect.event.type                    | Type of exported events.                                                                                                                                           | keyword          |
  | eset_protect.event.username                | Name of the user account associated with the event.                                                                                                                | keyword          |
  | event.dataset                              | Event dataset.                                                                                                                                                     | constant_keyword |
  | event.module                               | Event module.                                                                                                                                                      | constant_keyword |
  | input.type                                 | Type of Filebeat input.                                                                                                                                            | keyword          |
  | log.offset                                 | Log offset.                                                                                                                                                        | long             |
  | log.source.address                         | Source address from which the log event was read / sent from.                                                                                                      | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![ESET PROTECT Event Dashboard Screenshot](https://epr.elastic.co/package/eset_protect/1.12.0/img/eset_protect-event-dashboard.png)

  ![ESET PROTECT Detection Dashboard Screenshot](https://epr.elastic.co/package/eset_protect/1.12.0/img/eset_protect-detection-dashboard.png)

  ![ESET PROTECT Device Task Dashboard Screenshot](https://epr.elastic.co/package/eset_protect/1.12.0/img/eset_protect-device_task-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                         | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16897))Remove deprecated OAuth2 client_id/client_secret fields from the detection and device_task data streams.                                                                               | 9.0.08.16.0            |
  | **1.11.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16896))Fix batch_size default/max to match the ESET API page_size limit (1000).                                                                                                                   | 9.0.08.16.0            |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15911))Fix `404 Not Found` responses caused by a stale cached `response-id` header by correctly clearing `cursor` on API errors.                                                                  | 9.0.08.16.0            |
  | **1.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15831))Fix 404 Not Found responses caused by a stale cached `response-id` header. Clear `cursor.response_id` on 200 OK and only include the header after 202 Accepted.                            | 9.0.08.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15817))Add support for a toggle to preserve or drop the HEARTBEAT messages.                                                                                                                   | 9.0.08.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15799))Enhance error handling for agent failures.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15799))Fix parsing of HEARTBEAT messages in event data stream. | 9.0.08.16.0            |
  | **1.9.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15333))Fix issue with missing parameter mapping causing 'invalid_grant' error during OAuth2 username password authentication.                                                                     | 9.0.08.13.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13573))Remove redundant installation instructions.                                                                                                                                            | 9.0.08.13.0            |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13622))Fix ingest pipeline to remove BOM from Syslog messages.                                                                                                                                    | 9.0.08.13.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12887))Add support for eset notifications. These notifications are currently not sent in json format.                                                                                         | 9.0.08.13.0            |
  | **1.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12934))Add missing field support.                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                             | 9.0.08.13.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                               | 8.13.0                 |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                     | 8.13.0                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                | 8.13.0                 |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                              | 8.13.0                 |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11726))Add 3rd-integration header to API calls.                                                                                                                                               | 8.13.0                 |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10182))Remove reference to a Kibana version from the README.                                                                                                                                      | 8.13.0                 |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                             | 8.13.0                 |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9779))Release package as GA.                                                                                                                                                                  | 8.13.0                 |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9778))Use modern ecs@mappings.                                                                                                                                                                |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9600))Update OAuth grant type to password because ESET is deprecating the client_credentials grant type.                                                                                      |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9465))Lowercase related hash and indicator hash to support indicator rule matching. Fixed grok parse error when object_uri equals 'script'.                                                   |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9382))Fix host and file ECS fields.                                                                                                                                                           |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9238))Set sensitive values as secret, upgrade to package spec 3.0.3.                                                                                                                          |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                          |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8788))Initial Release.                                                                                                                                                                        |                        |
</dropdown>