﻿---
title: Docker OpenTelemetry Assets
description: The Docker OpenTelemetry Assets content package provides out-of-the-box dashboards for visualizing container performance and resource utilization metrics...
url: https://www.elastic.co/docs/reference/integrations/docker_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Docker OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.2.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The Docker OpenTelemetry Assets integration v0.2.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

The Docker OpenTelemetry Assets content package provides out-of-the-box dashboards for visualizing container performance and resource utilization metrics such as CPU usage, memory consumption, disk I/O, and network traffic from Docker hosts running OpenTelemetry Collector with the Docker Stats Receiver.
For example, if you wanted to monitor container CPU spikes, you could track CPU usage metrics across all containers. Then you can visualize these metrics in dashboards or create alerts when CPU usage exceeds defined thresholds.

## Setup

The minimal required configuration for the Docker Stats Receiver is:
```yaml
receivers:
  docker_stats:
```

Additional configuration options are available in the [OpenTelemetry Docker Stats Receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/dockerstatsreceiver/README.md) documentation. The configuration options available will depend on the version of the OpenTelemetry Collector you are using.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Overview Page](https://epr.elastic.co/package/docker_otel/0.2.0/img/docker_stats_overview.png)

  ![Container Stats](https://epr.elastic.co/package/docker_otel/0.2.0/img/docker_stats_container_stats.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                | Minimum Kibana version |
  |-----------|----------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15733))Add `discovery` field to support auto-install |                        |
  | **0.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15615))Add `opentelemetry` category                  |                        |
  | **0.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14426))Update documentation and fix Data View ID         |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13018))Initial availability of the package           |                        |
</dropdown>