﻿---
title: Domain Generation Algorithm Detection
description: The Domain Generation Algorithm (DGA) Detection package contains assets to detect DGA activity in your network data. This package requires a Platinum...
url: https://www.elastic.co/docs/reference/integrations/dga
products:
  - Elastic integrations
applies_to:
  - Elastic Stack: Generally available since 9.0
---

# Domain Generation Algorithm Detection
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.3.5 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Platinum                       |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.9.0                     |

The Domain Generation Algorithm (DGA) Detection package contains assets to detect DGA activity in your network data. This package requires a Platinum subscription. Please ensure that you have a Trial or Platinum level subscription installed on your cluster before proceeding. This package is licensed under [Elastic License 2.0](https://www.elastic.co/licensing/elastic-license).
This package leverages event logs on Linux, macOS, and Windows. Prior to using this integration, you must have Elastic Endpoint via Elastic Defend, or have equivalent tools/endpoints set up. If using Elastic Defend, Elastic Defend should be installed through Elastic Agent and collecting data from hosts. See [Configure endpoint protection with Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend) for more information.
<note>
  In versions 2.0.1 and later, this package ignores data in cold and frozen data tiers to reduce heap memory usage, avoid running on outdated data, and to follow best practices.
</note>

For more detailed information refer to the following blogs:
- [Detect domain generation algorithm (DGA) activity with new Kibana integration](https://www.elastic.co/security-labs/detect-domain-generation-algorithm-activity-with-new-kibana-integration)
- [Combining supervised and unsupervised machine learning for DGA detection](https://www.elastic.co/blog/supervised-and-unsupervised-machine-learning-for-dga-detection)


## Installation

1. **Upgrading**: If upgrading from a version below v2.0.0, see the section v2.0.0 and beyond.
2. **Add the Integration Package**: Install the package via **Management > Integrations > Add Domain Generation Algorithm Detection**. Configure the integration name and agent policy. Click Save and Continue. (Note that this integration does not rely on an agent, and can be assigned to a policy without an agent.)
3. **Install assets**: Install the assets by clicking **Settings > Install Domain Generation Algorithm Detection assets**.
4. **Configure the pipeline**: To configure the pipeline you can use one of the following steps:
   - If using Elastic Defend, add a custom pipeline to the data stream. Go to **Stack Management > Ingest Pipelines**, and check if the pipeline `logs-endpoint.events.network@custom` exists.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/custom-pipeline.png)
  If it does not exist, you can create it by running the following command in the Dev Console. Be sure to replace `<VERSION>` with the current package version.
  ```
  PUT _ingest/pipeline/logs-endpoint.events.network@custom
  {
    "processors": [
      {
        "pipeline": {
          "name": "<VERSION>-ml_dga_ingest_pipeline",
          "ignore_missing_pipeline": true,
          "ignore_failure": true
        }
      }
    ]
  }
  ```
- If `logs-endpoint.events.network@custom` already exists, select the three dots next to it and choose **Edit**. Click **Add a processor**. Select **Pipeline** for Processor, enter `<VERSION>-ml_dga_ingest_pipeline` for name (replacing `<VERSION>` with the current package version), and check **Ignore missing pipeline** and **Ignore failures for this processor**. Select **Add Processor**.
- If using an Elastic Beat such as Packetbeat, add the ingest pipeline to it by adding a simple configuration [setting](https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest.html#pipelines-for-beats) to `packetbeat.yml` and skip to the **Add preconfigured anomaly detection jobs** section in these instructions.
5. **Add the required mappings to the index or component template**: Go to **Stack Management > Index Management > Component Templates**. Templates that can be edited to add custom components will be marked with a `@custom` suffix. For instance, the custom component template for Elastic Defend network events is `logs-endpoint.events.network@custom`. **Note:** Do not attempt to edit the `@package` template.
   ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/component-templates.png)
   - If the `@custom` component template does not exist, you can execute the following command in the Dev Console to create it and then continue to the **Rollover** section in these instructions.
  ```
  PUT _component_template/{COMPONENT_TEMPLATE_NAME}@custom
  {
    "template": {
      "mappings": {
        "properties": {
          "ml_is_dga": {
            "type": "object",
            "properties": {
              "malicious_prediction": {
                "type": "long"
              },
              "malicious_probability": {
                "type": "float"
              }
            }
          }
        }
      }
    }
  }
  ```
- If the `@custom` component template already exists, you will need to edit it to add mappings for data to be properly enriched. Click the three dots next to it and select **Edit**.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/component-templates-edit.png)
- Proceed to the mappings step in the UI. Click **Add Field** at the bottom of the page and create an an `Object` field for `ml_is_dga`.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/field1.png)
- Finally create two properties under `ml_is_dga`.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/field1a.png)
- The first for `malicious_prediction` of type `Long` and then for `malicious_probability` or type `Float`.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/field2.png)
- Your component mappings should look like the following:
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/dga/fields-complete.png)
- Click **Review** then **Save Component Template**.
6. **Rollover** Depending on your environment, you may need to [rollover](https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-rollover-index.html) in order for these mappings to get picked up. The deault index pattern for Elastic Defend is `logs-endpoint.events.network-default`.
   ```
   POST INDEX_NAME/_rollover
   ```
7. **(Optional) [Create a data view](https://www.elastic.co/guide/en/kibana/current/data-views.html)** for your network logs.
8. **Add preconfigured anomaly detection jobs**: In **Stack Management -> Anomaly Detection Jobs**, you will see **Select data view or saved search**. Select the data view created in the previous step. Then under `Use preconfigured jobs` you will see `DGA`. When you select the card, you will see a pre-configured anomaly detection job that you can create. Note this job is only useful for indices that have been enriched by the ingest pipeline.
9. **Enable detection rules**: You can also enable detection rules to alert on DGA activity in your environment, based on anomalies flagged by the above ML jobs. As of version 2.0.0 of this package, these rules are available as part of the Detection Engine in **Security > Rules**, and can be found using the tag `Use Case: Domain Generated Algorithm Detection`. See this [documentation](https://www.elastic.co/guide/en/security/current/prebuilt-rules-management.html#load-prebuilt-rules) for more information on importing and enabling the rules. **Warning**: if the ingest pipeline hasn't run for some reason, such as no eligible data has come in yet, or the required mapping has not been added, *you won't be able to see this card yet*. If that is the case, try troubleshooting the ingest pipeline, and if any predictions have been populated yet.

![Domain Generation Detection Detection Rules](https://www.elastic.co/docs/reference/integrations/images/dga/dgarules.png)
*In **Security > Rules**, filtering with the “Use Case: Domain Generation Algorithm Detection” tag*

## Anomaly Detection Jobs


| Job                      | Description                                                                                                                                                                                                                                    |
|--------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| dga_high_sum_probability | Detects potential DGA (domain generation algorithm) activity that is often used by malware command and control (C2) channels. Looks for a source IP address making DNS requests that have an aggregate high probability of being DGA activity. |


## Customize ML jobs for Domain Generation Algorithm Detection

To customize the datafeed query and other settings such as model memory limit, frequency, query delay, bucket span and influencers for the Domain Generation Algorithm Detection ML jobs, follow the steps below.
1. To update the datafeed query, stop the datafeed and select **Edit job** from the Actions menu.
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_1.png)
2. In the Edit job window, navigate to the **Datafeed** section and update the query filters. You can add or remove field values to help reduce noise and false positives based on your environment.
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_2.png)
3. You may also update the model memory limit if your environment has high data volume or if the job requires additional resources. Go to the **Job details** section and update the **Model memory limit** and hit **Save**. For more information on resizing ML jobs, refer to the [documentation](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/anomaly-detection-scale#set-model-memory-limit).
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_3.png)
4. In order to do more advanced changes to your job, clone the job by selecting **Clone job** from the **Actions** menu.
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_4.png)
5. In the cloned job, you can update datafeed settings such as **Frequency** and **Query delay**, which help control how often data is analyzed and account for ingestion delays.
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_5.png)
6. You can also modify the job configuration by adjusting the **Bucket span** and by adding or removing **Influencers** to improve anomaly attribution.
   ![Domain Generation Algorithm Detection jobs](https://www.elastic.co/docs/reference/integrations/images/dga/dga_ml_job_6.png)
7. Finally, assign a new Job ID, and click on **Create job**, and start the datafeed to apply the updated settings.


## v2.0.0 and beyond

v2.0.0 of the package introduces breaking changes, namely deprecating detection rules from the package. To continue receiving updates to DGA Detection, we recommend upgrading to v2.0.0 after doing the following:
- Uninstall existing rules associated with this package: Navigate to **Security > Rules** and delete the following rules:
  - Machine Learning Detected DGA activity using a known SUNBURST DNS domain
- Machine Learning Detected a DNS Request Predicted to be a DGA Domain
- Potential DGA Activity
- Machine Learning Detected a DNS Request With a High DGA Probability Score

Depending on the version of the package you're using, you might also be able to search for the above rules using the tag `DGA`
- Upgrade the DGA package to v2.0.0 using the steps [here](https://www.elastic.co/guide/en/fleet/current/upgrade-integration.html)
- Install the new rules as described in the *Enable detection rules* section below


## Licensing

Usage in production requires that you have a license key that permits use of machine learning features.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Sample screenshot](https://epr.elastic.co/package/dga/2.3.5/img/sample-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                         | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.3.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17039))Update package docs with customization steps for ML jobs and transforms                                                | 9.0.08.9.0             |
  | **2.3.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16209))Add filtering for Elastic endpoint agents                                                                                  | 9.0.08.9.0             |
  | **2.3.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15229))Remove instructions to change the `default_pipeline` for an index                                                          | 9.0.08.9.0             |
  | **2.3.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15165))Correct typo in Readme                                                                                                     | 9.0.08.9.0             |
  | **2.3.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14358))Update platform support docs                                                                                           | 9.0.08.9.0             |
  | **2.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13058))Add exclusions for Elastic endpoint agents                                                                             | 9.0.08.9.0             |
  | **2.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12940))Add support for Kibana `9.0.0`                                                                                         | 9.0.08.9.0             |
  | **2.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12168))Add agent policy documentation                                                                                         | 8.9.0                  |
  | **2.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12153))Update spec version to 3.0.4                                                                                           | 8.9.0                  |
  | **2.0.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10823))Add fields for integration package testing                                                                                 | 8.9.0                  |
  | **2.0.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10476))Add mapping instructions                                                                                                   | 8.9.0                  |
  | **2.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9791))Improve package installation documentation                                                                              | 8.9.0                  |
  | **2.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8500))Add query settings to ignore frozen and cold data tiers                                                                 | 8.9.0                  |
  | **2.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7902))Removing detection rules from the package, bumped license and format versions, subscription tier                        | 8.9.0                  |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7053))Ensure event.kind is correctly set for pipeline errors                                                                  | 8.0.0                  |
  | **1.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6241))Add the Advanced Analytics (UEBA) subcategory                                                                           | 8.0.0                  |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5721))Update version number to follow GA format and to improve visibility                                                     | 8.0.0                  |
  | **0.0.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                  |                        |
  | **0.0.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4829))Clean up ML job groups and rule tags, change release to `ga`, documentation updates                                     |                        |
  | **0.0.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3777))Add a `DGA` tag to all rules, fix n-gram generation logic, remove a reference to a non-existent ML job in one of the rules. |                        |
  | **0.0.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3033))Update DGA integration Readme                                                                                               |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2352))Initial release of the package                                                                                          |                        |
</dropdown>