﻿---
title: Elastic, community, and partner integrations
description: Integrations can be developed by Elastic, by community contributors, or by official partners. Integrations developed, supported and maintained by Elastic...
url: https://www.elastic.co/docs/reference/integrations/developed-by
products:
  - Elastic integrations
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic, community, and partner integrations
Integrations can be developed by Elastic, by community contributors, or by official partners.
<note>
  An [Elastic subscription](https://www.elastic.co/pricing) is required to submit a support ticket. For more details, refer to [Getting Help](https://www.elastic.co/guide/en/cloud/current/ec-get-help.html). If you don’t have a subscription, open an issue in the GitHub Integrations repository or post in the [Elastic community forums](https://discuss.elastic.co).
  Non-GA integrations are not recommended for use in production environments. Elastic will address reported issues; however, features in beta, alpha, or tech preview are not covered by the support SLA that applies to official GA features.
</note>


## Elastic Developed

Integrations developed, supported and maintained by Elastic. These integrations have been validated against the applicable data source. Elastic ensures compatibility of these integrations with future releases of applicable software.

## Partner Developed

Integrations developed, published, and maintained by an Elastic Technology Partner, typically the vendor of the applicable data source. Elastic has reviewed the integration but has not tested against the applicable data source and cannot guarantee compatibility with future releases of the applicable data source. If you encounter problems with these integrations, you can raise a support ticket with Elastic, but may be referred to the Technology Partner who developed the integration.

## Community Developed

Integrations developed and kindly contributed to Elastic by our Community members. While it has undergone review by Elastic, we may not be as knowledgeable about the third party technology and we have not tested it against the applicable software. If you encounter problems with these integrations, you can raise a support ticket but may be referred to the original author.