﻿---
title: Darktrace
description: The Darktrace integration allows you to monitor Alert Logs. Darktrace is a network solution for detecting and investigating emerging cyber-threats that...
url: https://www.elastic.co/docs/reference/integrations/darktrace
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Darktrace
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.0.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |


## Overview

The [Darktrace](https://darktrace.com/) integration allows you to monitor Alert Logs. Darktrace is a network solution for detecting and investigating emerging cyber-threats that evade traditional security tools. It is powered by Enterprise Immune System technology, which uses machine learning and mathematics to monitor behaviors and detect anomalies in your organization’s network.
Use the Darktrace integration to collect and parse data from the REST APIs or via Syslog. Then visualise that data in Kibana.
For example, you could use the data from this integration to know which model is breached and analyse model breaches, and also know about system health, changes in monitored traffic, and any errors experienced by Darktrace Security Modules or probe instances.

## Data streams

The Darktrace integration collects logs for three types of events: AI Analyst Alert, Model Breach Alert and System Status Alert.
**AI Analyst Alert** is generated by investigates, analyzes, and reports upon threats seen within your Darktrace environment; as a starting point, it reviews and investigates all Model Breaches that occur on the system. If behavior which would be of interest to a cyber analyst is detected, an event is created. See Example Schema [here](https://customerportal.darktrace.com/product-guides/main/syslog-aia-json-schema).
**Model Breach Alert** is generated when a model breach is triggered. A model is used to define a set of conditions which, when met, will alert the system to the occurrence of a particular event or chain of anomalous behavior. Darktrace models are focused on pattern-of-life anomaly detection, potentially malicious behavior, and compliance issues. See Example Schema [here](https://customerportal.darktrace.com/product-guides/main/syslog-json-schema).
**System Status Alert** keep Darktrace operators informed of system health, changes in monitored traffic, and any errors experienced by Darktrace Security Modules or probe instances. System Status Alerts include details of the originating host, the severity of the event, and links that may be helpful to investigate or resolve the issue. Notifications are sent for active system events and (optionally) on event resolution. See Example Schema [here](https://customerportal.darktrace.com/product-guides/main/syslog-json-system-schema).

## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it. You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.
Firewall exceptions to allow communication from the Darktrace master instance to the Syslog server.
This module has been tested against **Darktrace Threat Visualizer v5.2**.

## Setup


### To collect data from Darktrace REST APIs, follow the below steps:

1. Hostname URL will be your `<appliance-ip>`. (Threat Visualizer Console Hostname)
2. Public and Private Token will be generated by following this [Link](https://customerportal.darktrace.com/product-guides/main/api-tokens).

<note>
  System Status Alert are not supported by REST API.
</note>


### To collect data from Darktrace via Syslog, follow the below steps:

The user needs to create a different Syslog Forwarder with different ports for each data stream.
The process for configuring syslog-format alerts is identical for AI Analyst Alerts, Model Breach Alerts and System Status Alerts. Generic configuration guidance is provided below:
1. Open the Darktrace Threat Visualizer Dashboard and navigate to the **System Config** page. (**Main menu › Admin**).
2. From the left-side menu, select **Modules**, then navigate to the **Workflow Integrations** section and choose **Syslog**.
3. Select **Syslog JSON** tab and click **New** to set up new Syslog Forwarder.
4. Enter the **IP Address**  and **Port** of the Elastic Agent that is running the integration in the **Server** and **Server Port** field respectively.

For more details, see [Documentation](https://customerportal.darktrace.com/product-guides/main/json-alerts).
**Note:**
- It is recommended to turn on **Full Timestamps** toggle in **Show Advanced Options** to get the full timestamp instead of the RFC3164-formatted timestamp.
- It is also recommended to turn off **Reduced Message Size** toggle in **Show Advanced Options** to get more information about alerts.


### After following generic guidance steps, below are the steps for collecting individual logs for all three data streams.


#### For AI Analyst Alert, below are the suggested configurations to collect all the events of AI Analyst Alert:

- Configure the following settings in **Show Advanced Options**:


| Field Name                              | Value                               |
|-----------------------------------------|-------------------------------------|
| Send AI Analyst Alerts                  | ON                                  |
| Send AI Analyst Alerts Immediately      | ON                                  |
| AI Analyst Behavior Filter              | Critical, Suspicious and Compliance |
| Minimum AI Analyst Incident Event Score | 0                                   |
| Minimum AI Analyst Incident Score       | 0                                   |
| Legacy AI Analyst Alerts                | OFF                                 |


#### For Model Breach Alert, below are the suggested configurations to collect all the events of Model Breach Alert:

- Configure the following settings in **Show Advanced Options**:


| Field Name                   | Value                                              |
|------------------------------|----------------------------------------------------|
| Send Model Breach Alerts     | ON                                                 |
| Model Breach Behavior Filter | Critical, Suspicious, Compliance and Informational |
| Minimum Breach Score         | 0                                                  |
| Minimum Breach Priority      | 0                                                  |
| Model Expression             | N/A                                                |
| Model Tags Expression        | N/A                                                |
| Device IP Addresses          | N/A                                                |
| Device Tags Addresses        | N/A                                                |


#### For System Status Alert, below are the suggested configurations to collect all the events of System Status Alert:

- Configure the following settings in **Show Advanced Options**:


| Field Name                         | Value         |
|------------------------------------|---------------|
| Send System Status Alerts          | ON            |
| Send Resolved System Status Alerts | ON            |
| Minimum System Status Priority     | Informational |


### See more about [Syslog Filters and Optional Settings](https://customerportal.darktrace.com/product-guides/main/syslog-json-alert-settings)

<note>
  A Fully Qualified Domain Name (FQDN) must be configured for the Darktrace instance in order for links to be included in external alerts.
</note>

- An FQDN can be configured from the **System** subsection on the **Settings** tab of the Darktrace **System Config** page.


## Logs reference


### ai_analyst_alert

This is the `ai_analyst_alert` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-08-03T14:48:09.240Z",
      "agent": {
          "ephemeral_id": "315a1a3f-bc7a-4a11-9540-c316f1ec95ee",
          "id": "85270a54-b915-4d11-9305-d004346cb8cf",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.9.0"
      },
      "darktrace": {
          "ai_analyst_alert": {
              "activity_id": "abcd1234",
              "aia_score": 98,
              "attack_phases": [
                  5
              ],
              "breach_devices": [
                  {
                      "did": 10,
                      "ip": "81.2.69.144",
                      "sid": 12,
                      "subnet": "VPN"
                  }
              ],
              "category": "critical",
              "children": [
                  "eabcdef0-1234-1234-1234-cabcdefghij9"
              ],
              "created_at": "2021-08-03T14:48:09.240Z",
              "current_group": "eabc1234-1234-1234-1234-cabcdefg0011",
              "details": [
                  [
                      {
                          "contents": [
                              {
                                  "type": "device",
                                  "values": [
                                      {
                                          "did": 10,
                                          "ip": "175.16.199.1",
                                          "sid": 12,
                                          "subnet": "VPN"
                                      }
                                  ]
                              }
                          ],
                          "header": "Breaching Device"
                      }
                  ],
                  [
                      {
                          "contents": [
                              {
                                  "key": "Time",
                                  "type": "timestampRange",
                                  "values": [
                                      {
                                          "end": 1628000141220,
                                          "start": 1627985298683
                                      }
                                  ]
                              },
                              {
                                  "key": "Number of unique IPs",
                                  "type": "integer",
                                  "values": [
                                      16
                                  ]
                              },
                              {
                                  "key": "Targeted IP ranges include",
                                  "type": "device",
                                  "values": [
                                      {
                                          "ip": "81.2.69.192"
                                      },
                                      {
                                          "ip": "175.16.199.1"
                                      },
                                      {
                                          "ip": "175.16.199.3"
                                      }
                                  ]
                              },
                              {
                                  "key": "Destination port",
                                  "type": "integer",
                                  "values": [
                                      22
                                  ]
                              },
                              {
                                  "key": "Connection count",
                                  "type": "integer",
                                  "values": [
                                      40
                                  ]
                              },
                              {
                                  "key": "Percentage successful",
                                  "type": "percentage",
                                  "values": [
                                      100
                                  ]
                              }
                          ],
                          "header": "SSH Activity"
                      }
                  ]
              ],
              "group_by_activity": false,
              "group_category": "critical",
              "group_score": 72.9174234,
              "grouping_ids": [
                  "abcdef12"
              ],
              "id": "eabc0011-1234-1234-1234-cabcdefg0011",
              "is_acknowledged": false,
              "is_external_triggered": false,
              "is_pinned": true,
              "is_user_triggered": false,
              "periods": [
                  {
                      "end": "2021-08-03T14:15:41.220Z",
                      "start": "2021-08-03T10:08:18.683Z"
                  }
              ],
              "related_breaches": [
                  {
                      "model_name": "Unusual Activity / Unusual Activity from Re-Activated Device",
                      "pbid": 1234,
                      "threat_score": 37,
                      "timestamp": "2021-08-03T13:25:57.000Z"
                  }
              ],
              "summariser": "AdminConnSummary",
              "summary": "The device 175.16.199.1 was observed making unusual internal SSH connections to a wide range of devices.\n\nThough this behaviour could be the result of legitimate remote access or administration, it could also be a sign of attempted lateral movement by a compromised machine.\n\nConsequently, if this activity was not expected, the security team may wish to investigate further.",
              "title": "Extensive Unusual SSH Connections"
          }
      },
      "data_stream": {
          "dataset": "darktrace.ai_analyst_alert",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "85270a54-b915-4d11-9305-d004346cb8cf",
          "snapshot": true,
          "version": "8.9.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "darktrace.ai_analyst_alert",
          "duration": [
              14842537000000
          ],
          "end": [
              "2021-08-03T14:15:41.220Z"
          ],
          "id": "eabc0011-1234-1234-1234-cabcdefg0011",
          "ingested": "2023-06-14T17:00:35Z",
          "kind": "alert",
          "original": "{\"summariser\":\"AdminConnSummary\",\"acknowledged\":false,\"pinned\":true,\"createdAt\":1628002089240,\"attackPhases\":[5],\"title\":\"Extensive Unusual SSH Connections\",\"id\":\"eabc0011-1234-1234-1234-cabcdefg0011\",\"children\":[\"eabcdef0-1234-1234-1234-cabcdefghij9\"],\"category\":\"critical\",\"currentGroup\":\"eabc1234-1234-1234-1234-cabcdefg0011\",\"groupCategory\":\"critical\",\"groupScore\":\"72.9174234\",\"groupPreviousGroups\":null,\"activityId\":\"abcd1234\",\"groupingIds\":[\"abcdef12\"],\"groupByActivity\":false,\"userTriggered\":false,\"externalTriggered\":false,\"aiaScore\":98,\"summary\":\"The device 175.16.199.1 was observed making unusual internal SSH connections to a wide range of devices.\\n\\nThough this behaviour could be the result of legitimate remote access or administration, it could also be a sign of attempted lateral movement by a compromised machine.\\n\\nConsequently, if this activity was not expected, the security team may wish to investigate further.\",\"periods\":[{\"start\":1627985298683,\"end\":1628000141220}],\"breachDevices\":[{\"identifier\":null,\"hostname\":null,\"ip\":\"81.2.69.144\",\"mac\":null,\"subnet\":\"VPN\",\"did\":10,\"sid\":12}],\"relatedBreaches\":[{\"modelName\":\"Unusual Activity / Unusual Activity from Re-Activated Device\",\"pbid\":1234,\"threatScore\":37,\"timestamp\":1627997157000}],\"details\":[[{\"header\":\"Breaching Device\",\"contents\":[{\"key\":null,\"type\":\"device\",\"values\":[{\"identifier\":null,\"hostname\":null,\"ip\":\"175.16.199.1\",\"mac\":null,\"subnet\":\"VPN\",\"did\":10,\"sid\":12}]}]}],[{\"header\":\"SSH Activity\",\"contents\":[{\"key\":\"Time\",\"type\":\"timestampRange\",\"values\":[{\"start\":1627985298683,\"end\":1628000141220}]},{\"key\":\"Number of unique IPs\",\"type\":\"integer\",\"values\":[16]},{\"key\":\"Targeted IP ranges include\",\"type\":\"device\",\"values\":[{\"identifier\":null,\"hostname\":null,\"ip\":\"81.2.69.192\",\"mac\":null,\"subnet\":null,\"did\":null,\"sid\":null},{\"identifier\":null,\"hostname\":null,\"ip\":\"175.16.199.1\",\"mac\":null,\"subnet\":null,\"did\":null,\"sid\":null},{\"identifier\":null,\"hostname\":null,\"ip\":\"175.16.199.3\",\"mac\":null,\"subnet\":null,\"did\":null,\"sid\":null}]},{\"key\":\"Destination port\",\"type\":\"integer\",\"values\":[22]},{\"key\":\"Connection count\",\"type\":\"integer\",\"values\":[40]},{\"key\":\"Percentage successful\",\"type\":\"percentage\",\"values\":[100]}]}]]}",
          "reason": "Extensive Unusual SSH Connections",
          "risk_score": 98,
          "risk_score_norm": 98,
          "start": [
              "2021-08-03T10:08:18.683Z"
          ],
          "type": [
              "indicator"
          ]
      },
      "host": {
          "id": [
              "10"
          ],
          "ip": [
              "81.2.69.144"
          ]
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.31.0.4:53890"
          },
          "syslog": {
              "facility": {
                  "code": 20,
                  "name": "local4"
              },
              "hostname": "example.cloud.darktrace.com",
              "priority": 165,
              "severity": {
                  "code": 5,
                  "name": "Notice"
              },
              "version": "1"
          }
      },
      "message": "The device 175.16.199.1 was observed making unusual internal SSH connections to a wide range of devices.\n\nThough this behaviour could be the result of legitimate remote access or administration, it could also be a sign of attempted lateral movement by a compromised machine.\n\nConsequently, if this activity was not expected, the security team may wish to investigate further.",
      "related": {
          "ip": [
              "81.2.69.144",
              "175.16.199.1",
              "81.2.69.192",
              "175.16.199.3"
          ]
      },
      "rule": {
          "name": [
              "Unusual Activity / Unusual Activity from Re-Activated Device"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "darktrace-ai_analyst_alert"
      ],
      "threat": {
          "enrichments": {
              "matched": {
                  "id": [
                      "eabcdef0-1234-1234-1234-cabcdefghij9"
                  ]
              }
          },
          "group": {
              "id": "eabc1234-1234-1234-1234-cabcdefg0011"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                    | Description                                                                                                                                                                                                                                                                                | Type             |
  |----------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                               | Event timestamp.                                                                                                                                                                                                                                                                           | date             |
  | cloud.image.id                                           | Image ID for the cloud instance.                                                                                                                                                                                                                                                           | keyword          |
  | darktrace.ai_analyst_alert.activity_id                   | An identifier for the specific activity detected by AI Analyst. If groupByActivity=true , this field should be used to group events together into an incident.                                                                                                                             | keyword          |
  | darktrace.ai_analyst_alert.aia_score                     | The score of the event as classified by AI Analyst - out of 100.                                                                                                                                                                                                                           | double           |
  | darktrace.ai_analyst_alert.attack_phases                 | Of the six attack phases, which phases are applicable to the activity.                                                                                                                                                                                                                     | long             |
  | darktrace.ai_analyst_alert.breach_devices.did            | The unique device id identifier for the device that triggered the breach. This field is used to group events into device-based incidents within the Threat Visualizer.                                                                                                                     | long             |
  | darktrace.ai_analyst_alert.breach_devices.hostname       | The hostname associated with the device, if available.                                                                                                                                                                                                                                     | keyword          |
  | darktrace.ai_analyst_alert.breach_devices.identifier     | An identifier for the device used when constructing summaries or reports. May be the device label, hostname or IP, depending on availability.                                                                                                                                              | keyword          |
  | darktrace.ai_analyst_alert.breach_devices.ip             | The IP associated with the device.                                                                                                                                                                                                                                                         | keyword          |
  | darktrace.ai_analyst_alert.breach_devices.mac_address    | The MAC address associated with the device.                                                                                                                                                                                                                                                | keyword          |
  | darktrace.ai_analyst_alert.breach_devices.sid            | The subnet id for the subnet the device is currently located in.                                                                                                                                                                                                                           | long             |
  | darktrace.ai_analyst_alert.breach_devices.subnet         | The subnet label for the corresponding subnet, if available.                                                                                                                                                                                                                               | keyword          |
  | darktrace.ai_analyst_alert.category                      | The behavior category associated with the incident event.                                                                                                                                                                                                                                  | keyword          |
  | darktrace.ai_analyst_alert.children                      | One or more unique identifiers that can be used to request this AI Analyst event via the UI or API. Where there is more than one uuid, requests can be made with comma-separated values.                                                                                                   | keyword          |
  | darktrace.ai_analyst_alert.created_at                    | Timestamp for event creation in epoch time.                                                                                                                                                                                                                                                | date             |
  | darktrace.ai_analyst_alert.current_group                 | The UUID of the current incident this event belongs to.                                                                                                                                                                                                                                    | keyword          |
  | darktrace.ai_analyst_alert.details                       | An array of multiple sections (sub-arrays) of event information.                                                                                                                                                                                                                           | flattened        |
  | darktrace.ai_analyst_alert.group_by_activity             | Used by pre-v5.2 legacy incident construction. Indicates whether the event should be aggregated by activity or by device to create an incident. When true, the event should be aggregated by activityID, and when false, aggregated by groupingID(s).                                      | boolean          |
  | darktrace.ai_analyst_alert.group_category                | The behavior category associated with the incident overall. Relevant for v5.2+ incident construction only.                                                                                                                                                                                 | keyword          |
  | darktrace.ai_analyst_alert.group_previous_groups         | If the incident event was part of an incident which was later merged with another, the UUIDs of the incidents before they were merged.                                                                                                                                                     | keyword          |
  | darktrace.ai_analyst_alert.group_score                   | The current overall score of the incident this event is part of.                                                                                                                                                                                                                           | double           |
  | darktrace.ai_analyst_alert.grouping_ids                  | Used by pre-v5.2 legacy incident construction. Each entry in the groupingIDs array refers to a device that triggered the activity detection. In single events, should only contain one ID. If groupByActivity=false , this field should be used to group events together into an incident. | keyword          |
  | darktrace.ai_analyst_alert.id                            | A system field.                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.domain     |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.extension  |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.fragment   |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.full       |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.original   |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.password   |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.path       |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.port       |                                                                                                                                                                                                                                                                                            | long             |
  | darktrace.ai_analyst_alert.incident_event_url.query      |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.scheme     |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.incident_event_url.username   |                                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.is_acknowledged               | Whether the event has been acknowledged.                                                                                                                                                                                                                                                   | boolean          |
  | darktrace.ai_analyst_alert.is_external_triggered         | Whether the event was created as a result of an externally triggered AI Analyst investigation.                                                                                                                                                                                             | boolean          |
  | darktrace.ai_analyst_alert.is_pinned                     | Whether the event, or an incident that the event is associated with, is pinned within the Threat Visualizer user interface. Pinned events will always return regardless of the timeframe specified.                                                                                        | boolean          |
  | darktrace.ai_analyst_alert.is_user_triggered             | Whether the event was created as a result of a user-triggered AI Analyst investigation.                                                                                                                                                                                                    | boolean          |
  | darktrace.ai_analyst_alert.periods.end                   | A timestamp for the end of the activity period in epoch time.                                                                                                                                                                                                                              | date             |
  | darktrace.ai_analyst_alert.periods.start                 | A timestamp for the start of the activity period in epoch time.                                                                                                                                                                                                                            | date             |
  | darktrace.ai_analyst_alert.related_breaches.model_name   | The name of the model that breached.                                                                                                                                                                                                                                                       | keyword          |
  | darktrace.ai_analyst_alert.related_breaches.pbid         | The policy breach ID unique identifier of the model breach.                                                                                                                                                                                                                                | long             |
  | darktrace.ai_analyst_alert.related_breaches.threat_score | The breach score of the associated model breach - out of 100.                                                                                                                                                                                                                              | long             |
  | darktrace.ai_analyst_alert.related_breaches.timestamp    | The timestamp at which the model breach occurred in epoch time.                                                                                                                                                                                                                            | date             |
  | darktrace.ai_analyst_alert.summariser                    | A system field.                                                                                                                                                                                                                                                                            | keyword          |
  | darktrace.ai_analyst_alert.summary                       | A textual summary of the suspicious activity. This example is abbreviated.                                                                                                                                                                                                                 | keyword          |
  | darktrace.ai_analyst_alert.title                         | A title describing the activity that occurred.                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset                                      | Data stream dataset.                                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.namespace                                    | Data stream namespace.                                                                                                                                                                                                                                                                     | constant_keyword |
  | data_stream.type                                         | Data stream type.                                                                                                                                                                                                                                                                          | constant_keyword |
  | event.dataset                                            | Event dataset.                                                                                                                                                                                                                                                                             | constant_keyword |
  | event.module                                             | Event module.                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized                                       | If the host is a container.                                                                                                                                                                                                                                                                | boolean          |
  | host.os.build                                            | OS build information.                                                                                                                                                                                                                                                                      | keyword          |
  | host.os.codename                                         | OS codename, if any.                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                                               | Input type                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                                               | Log offset                                                                                                                                                                                                                                                                                 | long             |
  | log.source.address                                       | Source address from which the log event was read / sent from.                                                                                                                                                                                                                              | keyword          |
</dropdown>


### model_breach_alert

This is the `model_breach_alert` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-07-11T13:04:08.000Z",
      "agent": {
          "ephemeral_id": "ec882d5d-4e2f-46d7-9436-1bf500ebbe15",
          "id": "12398e67-5831-430a-bd92-515cfa993c86",
          "name": "elastic-agent-32495",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "darktrace": {
          "model_breach_alert": {
              "aianalyst_data": [
                  {
                      "related": [
                          1
                      ],
                      "summariser": "BeaconSummary",
                      "uuid": "1234abcd-1234-1234-1234-123456abcdef"
                  }
              ],
              "comment": {
                  "count": 0
              },
              "creation_time": "2022-07-11T13:04:19.000Z",
              "device": {
                  "did": 3,
                  "first_seen": "2022-07-11T12:54:49.000Z",
                  "ip": "81.2.69.142",
                  "last_seen": "2022-07-11T13:00:18.000Z",
                  "sid": 1,
                  "type_label": "Desktop",
                  "type_name": "desktop"
              },
              "is_acknowledged": false,
              "model": {
                  "actions": {
                      "is_alerting": true,
                      "is_breach": true,
                      "is_priority_set": false,
                      "is_tag_set": false,
                      "is_type_set": false,
                      "model": true
                  },
                  "active_times": {
                      "type": "exclusions",
                      "version": 2
                  },
                  "behaviour": "incdec1",
                  "category": "Informational",
                  "created": {
                      "by": "System"
                  },
                  "delay": 0,
                  "description": "A device has been repeatedly connecting to a rare external location with a beacon score. A beacon score is added when Darktrace identifies that a device is regularly communicating with an endpoint, for example, if a device connects to a rare external endpoint every 12 minutes this would get a beacon score. This model is designed to identify beaconing at a lower threshold and be protocol agnostic.\\n\\nAction: Review the external domains and IPs being connected to to see if they are legitimate and would be expected for business purposes.",
                  "edited": {
                      "by": "System"
                  },
                  "in_compliance_behavior_category": false,
                  "interval": 10800,
                  "is_active": true,
                  "is_auto_suppress": true,
                  "is_auto_updatable": true,
                  "is_auto_update": true,
                  "is_sequenced": false,
                  "is_shared_endpoints": false,
                  "logic": {
                      "data_weighted_component_list": [
                          {
                              "cid": 2026,
                              "weight": 1
                          },
                          {
                              "cid": 2024,
                              "weight": 1
                          },
                          {
                              "cid": 2025,
                              "weight": -100
                          }
                      ],
                      "target_score": 1,
                      "type": "weightedComponentList",
                      "version": 1
                  },
                  "modified": "2022-07-11T11:47:37.000Z",
                  "name": "Compromise::Beaconing Activity To External Rare",
                  "phid": 1072,
                  "pid": 156,
                  "priority": 2,
                  "tags": [
                      "AP: C2 Comms"
                  ],
                  "throttle": 10800,
                  "uuid": "1234abcd-1234-1234-1234-123456abcdef",
                  "version": 23
              },
              "pbid": 1,
              "score": 0.674,
              "time": "2022-07-11T13:04:08.000Z",
              "triggered_components": [
                  {
                      "cbid": 1,
                      "chid": 2113,
                      "cid": 2026,
                      "interval": 3600,
                      "logic": {
                          "data": "{left={left=A, right={left=AA, right={left=AC, right={left=AD, right={left=AF, right={left=AG, right={left=AH, right={left=B, right={left=C, right={left=D, right={left=E, right={left=H, right={left=I, right={left=J, right={left=K, right={left=L, right={left=M, right={left=N, right={left=O, right={left=P, right={left=S, right={left=U, right={left=V, right={left=X, right={left=Y, right=Z, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, right={left=A, right={left=AA, right={left=AB, right={left=AE, right={left=AF, right={left=AG, right={left=AH, right={left=C, right={left=D, right={left=E, right={left=H, right={left=I, right={left=J, right={left=K, right={left=L, right={left=M, right={left=N, right={left=O, right={left=P, right={left=S, right={left=U, right={left=V, right={left=X, right={left=Y, right=Z, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=AND}, operator=OR}",
                          "version": "v0.1"
                      },
                      "metric": {
                          "label": "External Connections",
                          "mlid": 1,
                          "name": "externalconnections"
                      },
                      "size": 11,
                      "threshold": 10,
                      "time": "2022-07-11T13:04:08.000Z",
                      "triggered_filters": [
                          {
                              "arguments": {
                                  "value": 60
                              },
                              "cfid": 23426,
                              "comparator_type": ">",
                              "filter_type": "Beaconing score",
                              "id": "A",
                              "trigger": {
                                  "value": "100"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 0
                              },
                              "cfid": 23427,
                              "comparator_type": ">",
                              "filter_type": "Individual size up",
                              "id": "AA",
                              "trigger": {
                                  "value": "4382"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 95
                              },
                              "cfid": 23428,
                              "comparator_type": ">",
                              "filter_type": "Rare domain",
                              "id": "AB",
                              "trigger": {
                                  "value": "100"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 1209600
                              },
                              "cfid": 23430,
                              "comparator_type": "<",
                              "filter_type": "Age of destination",
                              "id": "AD",
                              "trigger": {
                                  "value": "558"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 1209600
                              },
                              "cfid": 23431,
                              "comparator_type": "<",
                              "filter_type": "Age of external hostname",
                              "id": "AE",
                              "trigger": {
                                  "value": "558"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "examples"
                              },
                              "cfid": 23432,
                              "comparator_type": "does not match regular expression",
                              "filter_type": "Connection hostname",
                              "id": "AF",
                              "trigger": {
                                  "value": "example.com"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "examples"
                              },
                              "cfid": 23433,
                              "comparator_type": "does not match regular expression",
                              "filter_type": "ASN",
                              "id": "AG",
                              "trigger": {
                                  "value": "AS12345 LOCAL-02"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "5d41402abc4b2a76b9719d911017c592"
                              },
                              "cfid": 23434,
                              "comparator_type": "does not match",
                              "filter_type": "JA3 hash",
                              "id": "AH",
                              "trigger": {
                                  "value": "5d41402abc4b2a76b9719d911017c592"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 95
                              },
                              "cfid": 23435,
                              "comparator_type": ">",
                              "filter_type": "Rare external IP",
                              "id": "B",
                              "trigger": {
                                  "value": "100"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "1003"
                              },
                              "cfid": 23436,
                              "comparator_type": "is not",
                              "filter_type": "Application protocol",
                              "id": "C",
                              "trigger": {
                                  "value": "1004"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 53
                              },
                              "cfid": 23437,
                              "comparator_type": "!=",
                              "filter_type": "Destination port",
                              "id": "D",
                              "trigger": {
                                  "value": "443"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "out"
                              },
                              "cfid": 23438,
                              "comparator_type": "is",
                              "filter_type": "Direction",
                              "id": "E",
                              "trigger": {
                                  "value": "out"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 137
                              },
                              "cfid": 23439,
                              "comparator_type": "!=",
                              "filter_type": "Destination port",
                              "id": "H",
                              "trigger": {
                                  "value": "443"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 161
                              },
                              "cfid": 23440,
                              "comparator_type": "!=",
                              "filter_type": "Destination port",
                              "id": "I",
                              "trigger": {
                                  "value": "443"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "6"
                              },
                              "cfid": 23441,
                              "comparator_type": "is",
                              "filter_type": "Protocol",
                              "id": "J",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "Company"
                              },
                              "cfid": 23442,
                              "comparator_type": "does not contain",
                              "filter_type": "ASN",
                              "id": "K",
                              "trigger": {
                                  "value": "AS12345 LOCAL-02"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "Company"
                              },
                              "cfid": 23443,
                              "comparator_type": "does not contain",
                              "filter_type": "ASN",
                              "id": "L",
                              "trigger": {
                                  "value": "AS12345 LOCAL-02"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "13"
                              },
                              "cfid": 23444,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "M",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "5"
                              },
                              "cfid": 23445,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "N",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "9"
                              },
                              "cfid": 23446,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "O",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "12"
                              },
                              "cfid": 23447,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "P",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "30"
                              },
                              "cfid": 23448,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "S",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "4"
                              },
                              "cfid": 23449,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "U",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "3"
                              },
                              "cfid": 23450,
                              "comparator_type": "is not",
                              "filter_type": "Internal source device type",
                              "id": "V",
                              "trigger": {
                                  "value": "6"
                              }
                          },
                          {
                              "arguments": {
                                  "value": "false"
                              },
                              "cfid": 23451,
                              "comparator_type": "is",
                              "filter_type": "Trusted hostname",
                              "id": "X",
                              "trigger": {
                                  "value": "false"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 26
                              },
                              "cfid": 23452,
                              "comparator_type": "does not have tag",
                              "filter_type": "Tagged internal source",
                              "id": "Y",
                              "trigger": {
                                  "tag": {
                                      "data": {
                                          "auto": false,
                                          "color": 5,
                                          "visibility": "Public"
                                      },
                                      "expiry": 0,
                                      "is_referenced": true,
                                      "name": "No Device Tracking",
                                      "restricted": false,
                                      "thid": 26,
                                      "tid": 26
                                  },
                                  "value": "26"
                              }
                          },
                          {
                              "arguments": {
                                  "value": 0
                              },
                              "cfid": 23453,
                              "comparator_type": ">",
                              "filter_type": "Individual size down",
                              "id": "Z",
                              "trigger": {
                                  "value": "5862"
                              }
                          },
                          {
                              "cfid": 23454,
                              "comparator_type": "display",
                              "filter_type": "JA3 hash",
                              "id": "d1",
                              "trigger": {
                                  "value": "5d41402abc4b2a76b9719d911017c592"
                              }
                          },
                          {
                              "cfid": 23455,
                              "comparator_type": "display",
                              "filter_type": "ASN",
                              "id": "d2",
                              "trigger": {
                                  "value": "AS12345 LOCAL-02"
                              }
                          },
                          {
                              "cfid": 23456,
                              "comparator_type": "display",
                              "filter_type": "Destination IP",
                              "id": "d3",
                              "trigger": {
                                  "value": "81.2.69.192"
                              }
                          },
                          {
                              "cfid": 23457,
                              "comparator_type": "display",
                              "filter_type": "Connection hostname",
                              "id": "d4",
                              "trigger": {
                                  "value": "example.com"
                              }
                          }
                      ]
                  }
              ]
          }
      },
      "data_stream": {
          "dataset": "darktrace.model_breach_alert",
          "namespace": "56997",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "12398e67-5831-430a-bd92-515cfa993c86",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "created": "2022-07-11T13:04:19.000Z",
          "dataset": "darktrace.model_breach_alert",
          "ingested": "2024-10-25T03:45:44Z",
          "kind": "event",
          "original": "{\"commentCount\":0,\"pbid\":1,\"time\":1657544648000,\"creationTime\":1657544659000,\"aianalystData\":[{\"uuid\":\"1234abcd-1234-1234-1234-123456abcdef\",\"related\":[1],\"summariser\":\"BeaconSummary\"}],\"model\":{\"name\":\"Compromise::Beaconing Activity To External Rare\",\"pid\":156,\"phid\":1072,\"uuid\":\"1234abcd-1234-1234-1234-123456abcdef\",\"logic\":{\"data\":[{\"cid\":2026,\"weight\":1},{\"cid\":2024,\"weight\":1},{\"cid\":2025,\"weight\":-100}],\"targetScore\":1,\"type\":\"weightedComponentList\",\"version\":1},\"throttle\":10800,\"sharedEndpoints\":false,\"actions\":{\"alert\":true,\"antigena\":{},\"breach\":true,\"model\":true,\"setPriority\":false,\"setTag\":false,\"setType\":false},\"tags\":[\"AP: C2 Comms\"],\"interval\":10800,\"delay\":0,\"sequenced\":false,\"active\":true,\"modified\":\"2022-07-11 11:47:37\",\"activeTimes\":{\"devices\":{},\"tags\":{},\"type\":\"exclusions\",\"version\":2},\"autoUpdatable\":true,\"autoUpdate\":true,\"autoSuppress\":true,\"description\":\"A device has been repeatedly connecting to a rare external location with a beacon score. A beacon score is added when Darktrace identifies that a device is regularly communicating with an endpoint, for example, if a device connects to a rare external endpoint every 12 minutes this would get a beacon score. This model is designed to identify beaconing at a lower threshold and be protocol agnostic.\\\\n\\\\nAction: Review the external domains and IPs being connected to to see if they are legitimate and would be expected for business purposes.\",\"behaviour\":\"incdec1\",\"created\":{\"by\":\"System\"},\"edited\":{\"by\":\"System\"},\"version\":23,\"priority\":2,\"category\":\"Informational\",\"compliance\":false},\"triggeredComponents\":[{\"time\":1657544648000,\"cbid\":1,\"cid\":2026,\"chid\":2113,\"size\":11,\"threshold\":10,\"interval\":3600,\"logic\":{\"data\":{\"left\":{\"left\":\"A\",\"operator\":\"AND\",\"right\":{\"left\":\"AA\",\"operator\":\"AND\",\"right\":{\"left\":\"AC\",\"operator\":\"AND\",\"right\":{\"left\":\"AD\",\"operator\":\"AND\",\"right\":{\"left\":\"AF\",\"operator\":\"AND\",\"right\":{\"left\":\"AG\",\"operator\":\"AND\",\"right\":{\"left\":\"AH\",\"operator\":\"AND\",\"right\":{\"left\":\"B\",\"operator\":\"AND\",\"right\":{\"left\":\"C\",\"operator\":\"AND\",\"right\":{\"left\":\"D\",\"operator\":\"AND\",\"right\":{\"left\":\"E\",\"operator\":\"AND\",\"right\":{\"left\":\"H\",\"operator\":\"AND\",\"right\":{\"left\":\"I\",\"operator\":\"AND\",\"right\":{\"left\":\"J\",\"operator\":\"AND\",\"right\":{\"left\":\"K\",\"operator\":\"AND\",\"right\":{\"left\":\"L\",\"operator\":\"AND\",\"right\":{\"left\":\"M\",\"operator\":\"AND\",\"right\":{\"left\":\"N\",\"operator\":\"AND\",\"right\":{\"left\":\"O\",\"operator\":\"AND\",\"right\":{\"left\":\"P\",\"operator\":\"AND\",\"right\":{\"left\":\"S\",\"operator\":\"AND\",\"right\":{\"left\":\"U\",\"operator\":\"AND\",\"right\":{\"left\":\"V\",\"operator\":\"AND\",\"right\":{\"left\":\"X\",\"operator\":\"AND\",\"right\":{\"left\":\"Y\",\"operator\":\"AND\",\"right\":\"Z\"}}}}}}}}}}}}}}}}}}}}}}}}},\"operator\":\"OR\",\"right\":{\"left\":\"A\",\"operator\":\"AND\",\"right\":{\"left\":\"AA\",\"operator\":\"AND\",\"right\":{\"left\":\"AB\",\"operator\":\"AND\",\"right\":{\"left\":\"AE\",\"operator\":\"AND\",\"right\":{\"left\":\"AF\",\"operator\":\"AND\",\"right\":{\"left\":\"AG\",\"operator\":\"AND\",\"right\":{\"left\":\"AH\",\"operator\":\"AND\",\"right\":{\"left\":\"C\",\"operator\":\"AND\",\"right\":{\"left\":\"D\",\"operator\":\"AND\",\"right\":{\"left\":\"E\",\"operator\":\"AND\",\"right\":{\"left\":\"H\",\"operator\":\"AND\",\"right\":{\"left\":\"I\",\"operator\":\"AND\",\"right\":{\"left\":\"J\",\"operator\":\"AND\",\"right\":{\"left\":\"K\",\"operator\":\"AND\",\"right\":{\"left\":\"L\",\"operator\":\"AND\",\"right\":{\"left\":\"M\",\"operator\":\"AND\",\"right\":{\"left\":\"N\",\"operator\":\"AND\",\"right\":{\"left\":\"O\",\"operator\":\"AND\",\"right\":{\"left\":\"P\",\"operator\":\"AND\",\"right\":{\"left\":\"S\",\"operator\":\"AND\",\"right\":{\"left\":\"U\",\"operator\":\"AND\",\"right\":{\"left\":\"V\",\"operator\":\"AND\",\"right\":{\"left\":\"X\",\"operator\":\"AND\",\"right\":{\"left\":\"Y\",\"operator\":\"AND\",\"right\":\"Z\"}}}}}}}}}}}}}}}}}}}}}}}}},\"version\":\"v0.1\"},\"metric\":{\"mlid\":1,\"name\":\"externalconnections\",\"label\":\"External Connections\"},\"triggeredFilters\":[{\"cfid\":23426,\"id\":\"A\",\"filterType\":\"Beaconing score\",\"arguments\":{\"value\":60},\"comparatorType\":\">\",\"trigger\":{\"value\":\"100\"}},{\"cfid\":23427,\"id\":\"AA\",\"filterType\":\"Individual size up\",\"arguments\":{\"value\":0},\"comparatorType\":\">\",\"trigger\":{\"value\":\"4382\"}},{\"cfid\":23428,\"id\":\"AB\",\"filterType\":\"Rare domain\",\"arguments\":{\"value\":95},\"comparatorType\":\">\",\"trigger\":{\"value\":\"100\"}},{\"cfid\":23430,\"id\":\"AD\",\"filterType\":\"Age of destination\",\"arguments\":{\"value\":1209600},\"comparatorType\":\"<\",\"trigger\":{\"value\":\"558\"}},{\"cfid\":23431,\"id\":\"AE\",\"filterType\":\"Age of external hostname\",\"arguments\":{\"value\":1209600},\"comparatorType\":\"<\",\"trigger\":{\"value\":\"558\"}},{\"cfid\":23432,\"id\":\"AF\",\"filterType\":\"Connection hostname\",\"arguments\":{\"value\":\"examples\"},\"comparatorType\":\"does not match regular expression\",\"trigger\":{\"value\":\"example.com\"}},{\"cfid\":23433,\"id\":\"AG\",\"filterType\":\"ASN\",\"arguments\":{\"value\":\"examples\"},\"comparatorType\":\"does not match regular expression\",\"trigger\":{\"value\":\"AS12345 LOCAL-02\"}},{\"cfid\":23434,\"id\":\"AH\",\"filterType\":\"JA3 hash\",\"arguments\":{\"value\":\"5d41402abc4b2a76b9719d911017c592\"},\"comparatorType\":\"does not match\",\"trigger\":{\"value\":\"5d41402abc4b2a76b9719d911017c592\"}},{\"cfid\":23435,\"id\":\"B\",\"filterType\":\"Rare external IP\",\"arguments\":{\"value\":95},\"comparatorType\":\">\",\"trigger\":{\"value\":\"100\"}},{\"cfid\":23436,\"id\":\"C\",\"filterType\":\"Application protocol\",\"arguments\":{\"value\":\"1003\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"1004\"}},{\"cfid\":23437,\"id\":\"D\",\"filterType\":\"Destination port\",\"arguments\":{\"value\":53},\"comparatorType\":\"!=\",\"trigger\":{\"value\":\"443\"}},{\"cfid\":23438,\"id\":\"E\",\"filterType\":\"Direction\",\"arguments\":{\"value\":\"out\"},\"comparatorType\":\"is\",\"trigger\":{\"value\":\"out\"}},{\"cfid\":23439,\"id\":\"H\",\"filterType\":\"Destination port\",\"arguments\":{\"value\":137},\"comparatorType\":\"!=\",\"trigger\":{\"value\":\"443\"}},{\"cfid\":23440,\"id\":\"I\",\"filterType\":\"Destination port\",\"arguments\":{\"value\":161},\"comparatorType\":\"!=\",\"trigger\":{\"value\":\"443\"}},{\"cfid\":23441,\"id\":\"J\",\"filterType\":\"Protocol\",\"arguments\":{\"value\":\"6\"},\"comparatorType\":\"is\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23442,\"id\":\"K\",\"filterType\":\"ASN\",\"arguments\":{\"value\":\"Company\"},\"comparatorType\":\"does not contain\",\"trigger\":{\"value\":\"AS12345 LOCAL-02\"}},{\"cfid\":23443,\"id\":\"L\",\"filterType\":\"ASN\",\"arguments\":{\"value\":\"Company\"},\"comparatorType\":\"does not contain\",\"trigger\":{\"value\":\"AS12345 LOCAL-02\"}},{\"cfid\":23444,\"id\":\"M\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"13\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23445,\"id\":\"N\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"5\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23446,\"id\":\"O\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"9\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23447,\"id\":\"P\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"12\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23448,\"id\":\"S\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"30\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23449,\"id\":\"U\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"4\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23450,\"id\":\"V\",\"filterType\":\"Internal source device type\",\"arguments\":{\"value\":\"3\"},\"comparatorType\":\"is not\",\"trigger\":{\"value\":\"6\"}},{\"cfid\":23451,\"id\":\"X\",\"filterType\":\"Trusted hostname\",\"arguments\":{\"value\":\"false\"},\"comparatorType\":\"is\",\"trigger\":{\"value\":\"false\"}},{\"cfid\":23452,\"id\":\"Y\",\"filterType\":\"Tagged internal source\",\"arguments\":{\"value\":26},\"comparatorType\":\"does not have tag\",\"trigger\":{\"value\":\"26\",\"tag\":{\"tid\":26,\"expiry\":0,\"thid\":26,\"name\":\"No Device Tracking\",\"restricted\":false,\"data\":{\"auto\":false,\"color\":5,\"description\":\"\",\"visibility\":\"Public\"},\"isReferenced\":true}}},{\"cfid\":23453,\"id\":\"Z\",\"filterType\":\"Individual size down\",\"arguments\":{\"value\":0},\"comparatorType\":\">\",\"trigger\":{\"value\":\"5862\"}},{\"cfid\":23454,\"id\":\"d1\",\"filterType\":\"JA3 hash\",\"arguments\":{},\"comparatorType\":\"display\",\"trigger\":{\"value\":\"5d41402abc4b2a76b9719d911017c592\"}},{\"cfid\":23455,\"id\":\"d2\",\"filterType\":\"ASN\",\"arguments\":{},\"comparatorType\":\"display\",\"trigger\":{\"value\":\"AS12345 LOCAL-02\"}},{\"cfid\":23456,\"id\":\"d3\",\"filterType\":\"Destination IP\",\"arguments\":{},\"comparatorType\":\"display\",\"trigger\":{\"value\":\"81.2.69.192\"}},{\"cfid\":23457,\"id\":\"d4\",\"filterType\":\"Connection hostname\",\"arguments\":{},\"comparatorType\":\"display\",\"trigger\":{\"value\":\"example.com\"}}]}],\"score\":0.674,\"device\":{\"did\":3,\"ip\":\"81.2.69.142\",\"sid\":1,\"firstSeen\":1657544089000,\"lastSeen\":1657544418000,\"typename\":\"desktop\",\"typelabel\":\"Desktop\"}}",
          "risk_score": 0.674,
          "risk_score_norm": 67.4,
          "severity": 2,
          "start": [
              "2022-07-11T13:04:08.000Z"
          ],
          "type": [
              "info",
              "connection"
          ]
      },
      "host": {
          "id": "3",
          "ip": [
              "81.2.69.142"
          ],
          "type": "desktop"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "192.168.112.3:50896"
          },
          "syslog": {
              "facility": {
                  "code": 20,
                  "name": "local4"
              },
              "hostname": "example.cloud.darktrace.com",
              "priority": 165,
              "severity": {
                  "code": 5,
                  "name": "Notice"
              },
              "version": "1"
          }
      },
      "related": {
          "ip": [
              "81.2.69.142"
          ],
          "user": [
              "System"
          ]
      },
      "rule": {
          "author": [
              "System"
          ],
          "category": "Informational",
          "description": "A device has been repeatedly connecting to a rare external location with a beacon score. A beacon score is added when Darktrace identifies that a device is regularly communicating with an endpoint, for example, if a device connects to a rare external endpoint every 12 minutes this would get a beacon score. This model is designed to identify beaconing at a lower threshold and be protocol agnostic.\\n\\nAction: Review the external domains and IPs being connected to to see if they are legitimate and would be expected for business purposes.",
          "name": "Compromise::Beaconing Activity To External Rare",
          "ruleset": [
              "AP: C2 Comms"
          ],
          "uuid": "1234abcd-1234-1234-1234-123456abcdef",
          "version": "23"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "darktrace-model_breach_alert"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                            | Description                                                                                                                                                                                                        | Type             |
  |--------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                       | Event timestamp.                                                                                                                                                                                                   | date             |
  | cloud.image.id                                                                                   | Image ID for the cloud instance.                                                                                                                                                                                   | keyword          |
  | darktrace.model_breach_alert.acknowledged.time                                                   |                                                                                                                                                                                                                    | date             |
  | darktrace.model_breach_alert.acknowledged.username                                               |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.aianalyst_data.related                                              |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.aianalyst_data.summariser                                           |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.aianalyst_data.uuid                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.domain                                                   |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.extension                                                |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.fragment                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.full                                                     |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.original                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.password                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.path                                                     |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.port                                                     |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.breach_url.query                                                    |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.scheme                                                   |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.breach_url.username                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.comment.count                                                       | The number of comments made against this breach.                                                                                                                                                                   | long             |
  | darktrace.model_breach_alert.creation_time                                                       | The timestamp that the record of the breach was created. This is distinct from the “time” field.                                                                                                                   | date             |
  | darktrace.model_breach_alert.device.credentials                                                  |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.device.did                                                          | The “device id”, a unique identifier.                                                                                                                                                                              | long             |
  | darktrace.model_breach_alert.device.first_seen                                                   | The first time the device was seen on the network.                                                                                                                                                                 | date             |
  | darktrace.model_breach_alert.device.hostname                                                     | The current device hostname.                                                                                                                                                                                       | keyword          |
  | darktrace.model_breach_alert.device.ip                                                           | The current IP associated with the device.                                                                                                                                                                         | keyword          |
  | darktrace.model_breach_alert.device.ip6                                                          | Current IPv6 address of this device if applicable, otherwise undefined.                                                                                                                                            | keyword          |
  | darktrace.model_breach_alert.device.ips.ip                                                       | A historic IP associated with the device.                                                                                                                                                                          | keyword          |
  | darktrace.model_breach_alert.device.ips.sid                                                      | The subnet id for the subnet the IP belongs to.                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.device.ips.time                                                     | The time the IP was last seen associated with that device in readable format.                                                                                                                                      | date             |
  | darktrace.model_breach_alert.device.ips.timems                                                   | The time the IP was last seen associated with that device in epoch time.                                                                                                                                           | date             |
  | darktrace.model_breach_alert.device.last_seen                                                    | The last time the device was seen on the network.                                                                                                                                                                  | date             |
  | darktrace.model_breach_alert.device.mac_address                                                  | The current MAC address associated with the device.                                                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.device.sid                                                          | The subnet id for the subnet the device is currently located in.                                                                                                                                                   | long             |
  | darktrace.model_breach_alert.device.tags.data.auto                                               |                                                                                                                                                                                                                    | boolean          |
  | darktrace.model_breach_alert.device.tags.data.color                                              |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.device.tags.data.description                                        |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.device.tags.data.visibility                                         |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.device.tags.expiry                                                  |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.device.tags.is_referenced                                           |                                                                                                                                                                                                                    | boolean          |
  | darktrace.model_breach_alert.device.tags.name                                                    |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.device.tags.restricted                                              |                                                                                                                                                                                                                    | boolean          |
  | darktrace.model_breach_alert.device.tags.thid                                                    |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.device.tags.tid                                                     |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.device.type_label                                                   | The device type in readable format.                                                                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.device.type_name                                                    | The device type in system format.                                                                                                                                                                                  | keyword          |
  | darktrace.model_breach_alert.device.vendor                                                       | The vendor of the device network card as derived by Darktrace from the MAC address.                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.device_score                                                        |                                                                                                                                                                                                                    | double           |
  | darktrace.model_breach_alert.is_acknowledged                                                     |                                                                                                                                                                                                                    | boolean          |
  | darktrace.model_breach_alert.mitre_techniques.id                                                 |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.mitre_techniques.name                                               |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.model.actions.antigena.action                                       | The action to be performed.                                                                                                                                                                                        | keyword          |
  | darktrace.model_breach_alert.model.actions.antigena.duration                                     | The duration in seconds that the antigena action should last for.                                                                                                                                                  | long             |
  | darktrace.model_breach_alert.model.actions.antigena.is_confirm_by_human_operator                 | Whether the action must be confirmed by a human operator, regardless of the global setting for Human Confirmation mode.                                                                                            | boolean          |
  | darktrace.model_breach_alert.model.actions.antigena.threshold                                    | The breach score threshold (out of 100) over which antigena will take an action.                                                                                                                                   | long             |
  | darktrace.model_breach_alert.model.actions.is_alerting                                           | If true, an alert turned on will be pushed out to external systems if conditions for such alerting are met.                                                                                                        | boolean          |
  | darktrace.model_breach_alert.model.actions.is_breach                                             | If true, an alert turned on will be pushed out to external systems if conditions for such alerting are met.                                                                                                        | boolean          |
  | darktrace.model_breach_alert.model.actions.is_priority_set                                       | If the priority is to be changed on breach, the numeric value it should become. If no priority change action, a false boolean.                                                                                     | boolean          |
  | darktrace.model_breach_alert.model.actions.is_tag_set                                            | If a tag is to be applied on model breach, a single number or array of the system ID for the tag(s) to be applied. If no tag action, a false boolean.                                                              | boolean          |
  | darktrace.model_breach_alert.model.actions.is_type_set                                           | If a change device type action is to be applied on model breach, the numeric system ID for the label to be applied. If no change device type action is applied to the model, a false boolean.                      | boolean          |
  | darktrace.model_breach_alert.model.actions.model                                                 | If true, creates an event in the device’s event log without creating an alert/ model breach in the threat tray.                                                                                                    | boolean          |
  | darktrace.model_breach_alert.model.active_times.devices                                          | The device ids for devices on the list.                                                                                                                                                                            | flattened        |
  | darktrace.model_breach_alert.model.active_times.tags                                             | A system field.                                                                                                                                                                                                    | flattened        |
  | darktrace.model_breach_alert.model.active_times.type                                             | The type of list: “restrictions” indicates a blacklist, “exclusions” a whitelist.                                                                                                                                  | keyword          |
  | darktrace.model_breach_alert.model.active_times.version                                          | A system field.                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.behaviour                                                     | The score modulation function as set in the model editor.                                                                                                                                                          | keyword          |
  | darktrace.model_breach_alert.model.category                                                      | The behavior category of the model that was breached.                                                                                                                                                              | keyword          |
  | darktrace.model_breach_alert.model.created.by                                                    | Username that created the model.                                                                                                                                                                                   | keyword          |
  | darktrace.model_breach_alert.model.defeats.arguments.value                                       | The value(s) that must match for the defeat to take effect.                                                                                                                                                        | keyword          |
  | darktrace.model_breach_alert.model.defeats.comparator                                            | The comparator that the value is compared against the create the defeat.                                                                                                                                           | keyword          |
  | darktrace.model_breach_alert.model.defeats.filtertype                                            | The filter the defeat is made from.                                                                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.model.defeats.id                                                    | A unique ID for the defeat.                                                                                                                                                                                        | keyword          |
  | darktrace.model_breach_alert.model.delay                                                         | Minimum delay in seconds after a positive-scoring component has fired before the overall model score is calculated. Only applicable in target score models.                                                        | long             |
  | darktrace.model_breach_alert.model.description                                                   | The optional description of the model.                                                                                                                                                                             | keyword          |
  | darktrace.model_breach_alert.model.edited.by                                                     | Username that last edited the model.                                                                                                                                                                               | keyword          |
  | darktrace.model_breach_alert.model.edited.userid                                                 |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.in_compliance_behavior_category                               | Whether the model is in the compliance behavior category.                                                                                                                                                          | boolean          |
  | darktrace.model_breach_alert.model.interval                                                      | Where a model contains multiple components, this interval represents the time window in seconds in which all the components should fire for this model to be breached.                                             | long             |
  | darktrace.model_breach_alert.model.is_active                                                     | Whether the model is enabled or disabled.                                                                                                                                                                          | boolean          |
  | darktrace.model_breach_alert.model.is_auto_suppress                                              | Whether the model will automatically be suppressed in the case of over-breaching.                                                                                                                                  | boolean          |
  | darktrace.model_breach_alert.model.is_auto_updatable                                             | Whether the model is suitable for auto update.                                                                                                                                                                     | boolean          |
  | darktrace.model_breach_alert.model.is_auto_update                                                | Whether the model is enabled for auto update.                                                                                                                                                                      | boolean          |
  | darktrace.model_breach_alert.model.is_sequenced                                                  | Whether the components are required to fire in the specified order for the model breach to occur.                                                                                                                  | boolean          |
  | darktrace.model_breach_alert.model.is_shared_endpoints                                           | For models that contain multiple components that reference an endpoint, this value indicates whether all endpoints should be identical for the model to fire.                                                      | boolean          |
  | darktrace.model_breach_alert.model.logic.data_component_list                                     | This will be a list of component ID numbers.                                                                                                                                                                       | long             |
  | darktrace.model_breach_alert.model.logic.data_weighted_component_list.cid                        |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.logic.data_weighted_component_list.weight                     |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.logic.target_score                                            |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.logic.type                                                    | The type of model.                                                                                                                                                                                                 | keyword          |
  | darktrace.model_breach_alert.model.logic.version                                                 | A number representing the version of model logic.                                                                                                                                                                  | long             |
  | darktrace.model_breach_alert.model.modified                                                      | Timestamp at which the model was last modified, in a readable format.                                                                                                                                              | date             |
  | darktrace.model_breach_alert.model.name                                                          | Name of the model that was breached.                                                                                                                                                                               | keyword          |
  | darktrace.model_breach_alert.model.phid                                                          | The model “policy history” id. Increments when the model is modified.                                                                                                                                              | long             |
  | darktrace.model_breach_alert.model.pid                                                           | The “policy id” of the model that was breached.                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.model.priority                                                      | The model’s priority affects the strength with which it breaches (0-5 scale).                                                                                                                                      | long             |
  | darktrace.model_breach_alert.model.tags                                                          | A list of tags that have been applied to this model in the Threat Visualizer model editor.                                                                                                                         | keyword          |
  | darktrace.model_breach_alert.model.throttle                                                      | For an individual device, this is the value in seconds for which this model will not fire again.                                                                                                                   | long             |
  | darktrace.model_breach_alert.model.uuid                                                          | A unique ID that is generated on creation of the model.                                                                                                                                                            | keyword          |
  | darktrace.model_breach_alert.model.version                                                       | The version of the model. Increments on each edit.                                                                                                                                                                 | long             |
  | darktrace.model_breach_alert.pb_score                                                            | The model breach score, represented by a value between 0 and 1.                                                                                                                                                    | double           |
  | darktrace.model_breach_alert.pbid                                                                | The “policy breach ID” of the model breach.                                                                                                                                                                        | long             |
  | darktrace.model_breach_alert.score                                                               | The model breach score, represented by a value between 0 and 1.                                                                                                                                                    | double           |
  | darktrace.model_breach_alert.time                                                                | The timestamp when the record was created in epoch time.                                                                                                                                                           | date             |
  | darktrace.model_breach_alert.triggered_components.cbid                                           | The “component breach id”. A unique identifier for the component breach.                                                                                                                                           | long             |
  | darktrace.model_breach_alert.triggered_components.chid                                           | The “component history id”. Increments when the component is edited.                                                                                                                                               | long             |
  | darktrace.model_breach_alert.triggered_components.cid                                            | The “component id”. A unique identifier.                                                                                                                                                                           | long             |
  | darktrace.model_breach_alert.triggered_components.interval                                       | The timeframe in seconds within which the threshold must be satisfied.                                                                                                                                             | long             |
  | darktrace.model_breach_alert.triggered_components.logic.data                                     | It representing the logical relationship between component filters. Each filter is given an alphabetical reference and the contents of this field describe the relationship between those filters.                 | text             |
  | darktrace.model_breach_alert.triggered_components.logic.version                                  | The version of the component logic.                                                                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.triggered_components.metric.label                                   | The metric which data is returned for in readable format.                                                                                                                                                          | keyword          |
  | darktrace.model_breach_alert.triggered_components.metric.mlid                                    | The “metric logic” id - unique identifier.                                                                                                                                                                         | long             |
  | darktrace.model_breach_alert.triggered_components.metric.name                                    | The metric which data is returned for in system format.                                                                                                                                                            | keyword          |
  | darktrace.model_breach_alert.triggered_components.size                                           | The size of the value that was compared in the component.                                                                                                                                                          | long             |
  | darktrace.model_breach_alert.triggered_components.threshold                                      | The threshold value that the size must exceed for the component to breach.                                                                                                                                         | long             |
  | darktrace.model_breach_alert.triggered_components.time                                           | A timestamp in Epoch time at which the components were triggered.                                                                                                                                                  | date             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.arguments.value              | The value the filtertype should be compared against (using the specified comparator) to create the filter.                                                                                                         | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.cfid                         | The ‘component filter id’. A unique identifier for the filter as part of a the component.                                                                                                                          | long             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.comparator_type              | The comparator. A full list of comparators available for each filtertype can be found on the /filtertypes endpoint.                                                                                                | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.filter_type                  | The filtertype that is used in the filter. A full list of filtertypes can be found on the /filtertypes endpoint.                                                                                                   | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.id                           | A filter that is used in the component logic. All filters are given alphabetical identifiers. Display filters - those that appear in the breach notification - can be identified by a lowercase ‘d’ and a numeral. | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.data.auto        |                                                                                                                                                                                                                    | boolean          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.data.color       |                                                                                                                                                                                                                    | long             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.data.description |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.data.visibility  |                                                                                                                                                                                                                    | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.expiry           | nan                                                                                                                                                                                                                | long             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.is_referenced    | nan                                                                                                                                                                                                                | boolean          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.name             | nan                                                                                                                                                                                                                | keyword          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.restricted       | nan                                                                                                                                                                                                                | boolean          |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.thid             | nan                                                                                                                                                                                                                | long             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.tag.tid              | nan                                                                                                                                                                                                                | long             |
  | darktrace.model_breach_alert.triggered_components.triggered_filters.trigger.value                | The actual value that triggered the filter.                                                                                                                                                                        | keyword          |
  | data_stream.dataset                                                                              | Data stream dataset.                                                                                                                                                                                               | constant_keyword |
  | data_stream.namespace                                                                            | Data stream namespace.                                                                                                                                                                                             | constant_keyword |
  | data_stream.type                                                                                 | Data stream type.                                                                                                                                                                                                  | constant_keyword |
  | event.dataset                                                                                    | Event dataset.                                                                                                                                                                                                     | constant_keyword |
  | event.module                                                                                     | Event module.                                                                                                                                                                                                      | constant_keyword |
  | host.containerized                                                                               | If the host is a container.                                                                                                                                                                                        | boolean          |
  | host.os.build                                                                                    | OS build information.                                                                                                                                                                                              | keyword          |
  | host.os.codename                                                                                 | OS codename, if any.                                                                                                                                                                                               | keyword          |
  | input.type                                                                                       | Input type                                                                                                                                                                                                         | keyword          |
  | log.offset                                                                                       | Log offset                                                                                                                                                                                                         | long             |
  | log.source.address                                                                               | Source address from which the log event was read / sent from.                                                                                                                                                      | keyword          |
</dropdown>


### system_status_alert

This is the `system_status_alert` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-04-18T15:44:11.000Z",
      "agent": {
          "ephemeral_id": "b16aba4d-b447-49c7-ac87-7785481b8e51",
          "id": "85270a54-b915-4d11-9305-d004346cb8cf",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.9.0"
      },
      "darktrace": {
          "system_status_alert": {
              "alert_name": "Advanced Search",
              "child_id": 1,
              "hostname": "example-vsensor",
              "ip_address": "175.16.199.1",
              "last_updated": "2021-04-18T15:44:11.000Z",
              "last_updated_status": "2021-04-18T15:44:11.000Z",
              "message": "There have been no Advanced Search hits for this instance seen since Sun 18 April 2021 13:20:23 (UTC). If this is not expected behaviour, please open a ticket using the following link or get in touch with your Cyber Technology Specialist. https://example.com/test",
              "name": "advanced_search",
              "priority": 43,
              "priority_level": "medium",
              "status": "active",
              "uuid": "abcdabcd-1234-1234-1234-3abababcdcd3"
          }
      },
      "data_stream": {
          "dataset": "darktrace.system_status_alert",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "85270a54-b915-4d11-9305-d004346cb8cf",
          "snapshot": true,
          "version": "8.9.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "darktrace.system_status_alert",
          "id": "abcdabcd-1234-1234-1234-3abababcdcd3",
          "ingested": "2023-06-14T17:06:15Z",
          "kind": "alert",
          "original": "{\"last_updated\":1618760651,\"uuid\":\"abcdabcd-1234-1234-1234-3abababcdcd3\",\"priority\":43,\"priority_level\":\"medium\",\"hostname\":\"example-vsensor\",\"ip_address\":\"175.16.199.1\",\"message\":\"There have been no Advanced Search hits for this instance seen since Sun 18 April 2021 13:20:23 (UTC). If this is not expected behaviour, please open a ticket using the following link or get in touch with your Cyber Technology Specialist. https://example.com/test\",\"name\":\"advanced_search\",\"acknowledge_timeout\":null,\"alert_name\":\"Advanced Search\",\"child_id\":1,\"last_updated_status\":1618760651,\"status\":\"active\"}",
          "reason": "There have been no Advanced Search hits for this instance seen since Sun 18 April 2021 13:20:23 (UTC). If this is not expected behaviour, please open a ticket using the following link or get in touch with your Cyber Technology Specialist. https://example.com/test",
          "risk_score": 43,
          "risk_score_norm": 43,
          "type": [
              "info"
          ]
      },
      "host": {
          "hostname": "example-vsensor",
          "ip": [
              "175.16.199.1"
          ]
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.31.0.4:43852"
          },
          "syslog": {
              "facility": {
                  "code": 20,
                  "name": "local4"
              },
              "hostname": "example.cloud.darktrace.com",
              "priority": 165,
              "severity": {
                  "code": 5,
                  "name": "Notice"
              },
              "version": "1"
          }
      },
      "related": {
          "hosts": [
              "example-vsensor"
          ],
          "ip": [
              "175.16.199.1"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "darktrace-system_status_alert"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                             | Description                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                        | Event timestamp.                                                                                                                                                                                                                                                             | date             |
  | cloud.image.id                                    | Image ID for the cloud instance.                                                                                                                                                                                                                                             | keyword          |
  | darktrace.system_status_alert.acknowledge_timeout | When acknowledgement of the alert expires. As alerts are sent externally on creation before acknowledgement is possible, this will be null in almost all cases.                                                                                                              | keyword          |
  | darktrace.system_status_alert.alert_name          | A human readable name of the alert type.                                                                                                                                                                                                                                     | keyword          |
  | darktrace.system_status_alert.child_id            | For probes (physical or virtual), the unique ID associated with the probe.                                                                                                                                                                                                   | long             |
  | darktrace.system_status_alert.hostname            | The hostname (if known) of the host experiencing the system alert. An exception exists for disconnection notices, where the hostname will be of the master from which the instance has disconnected.                                                                         | keyword          |
  | darktrace.system_status_alert.ip_address          | The IP of the host experiencing the system alert. An exception exists for disconnection notices, where the IP will be of the master from which the instance has disconnected.                                                                                                | keyword          |
  | darktrace.system_status_alert.last_updated        | A timestamp in epoch time that the system alert itself was updated.                                                                                                                                                                                                          | date             |
  | darktrace.system_status_alert.last_updated_status | A timestamp in epoch time that the status of the system alert was last updated globally. A status update is distinct from a update to the alert itself.                                                                                                                      | date             |
  | darktrace.system_status_alert.message             | A textual description of the system event that has triggered the alert.                                                                                                                                                                                                      | keyword          |
  | darktrace.system_status_alert.name                | A system name of the alert type.                                                                                                                                                                                                                                             | keyword          |
  | darktrace.system_status_alert.priority            | The numeric criticality associated with the alert.                                                                                                                                                                                                                           | double           |
  | darktrace.system_status_alert.priority_level      | The criticality of the alert. This value is calculated from the priority value: 0 - 40 low, 41 - 60 medium, 61 - 80 high, 81 - 100 critical.                                                                                                                                 | keyword          |
  | darktrace.system_status_alert.status              | The current status of the alert. Active alerts are ongoing, acknowledged events are those acknowledged on the System Status page, resolved alerts are system alerts that are no longer ongoing. Alerts will only be sent when alert enters the “active” or “resolved” state. | keyword          |
  | darktrace.system_status_alert.url.domain          |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.extension       |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.fragment        |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.full            |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.original        |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.password        |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.path            |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.port            |                                                                                                                                                                                                                                                                              | long             |
  | darktrace.system_status_alert.url.query           |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.scheme          |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.url.username        |                                                                                                                                                                                                                                                                              | keyword          |
  | darktrace.system_status_alert.uuid                | A consistent UUID that can be used to navigate to the specific alert in the Threat Visualizer (https://[instance]/sysstatus/[uuid]). Where an alert is reactivated after resolution due to the issue reoccurring, the UUId will remain consistent across alerts.             | keyword          |
  | data_stream.dataset                               | Data stream dataset.                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                             | Data stream namespace.                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.type                                  | Data stream type.                                                                                                                                                                                                                                                            | constant_keyword |
  | event.dataset                                     | Event dataset.                                                                                                                                                                                                                                                               | constant_keyword |
  | event.module                                      | Event module.                                                                                                                                                                                                                                                                | constant_keyword |
  | host.containerized                                | If the host is a container.                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build                                     | OS build information.                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                                  | OS codename, if any.                                                                                                                                                                                                                                                         | keyword          |
  | input.type                                        | Input type                                                                                                                                                                                                                                                                   | keyword          |
  | log.offset                                        | Log offset                                                                                                                                                                                                                                                                   | long             |
  | log.source.address                                | Source address from which the log event was read / sent from.                                                                                                                                                                                                                | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Darktrace Model Breach Alert Dashboard Screenshot](https://epr.elastic.co/package/darktrace/2.0.0/img/darktrace-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.0.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15552))Fix model defeat handling when nested conditions exist and so defeat ID can be non-numeric.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15552))`darktrace.model_breach_alert.model.defeats.id` field type is changed from `long` to `keyword`. | 9.0.08.13.0            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                                                    | 8.13.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                           | 8.13.0                 |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12047))Fix string literals in painless scripts.                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11685))Handle versions of Darktrace model breach alert documents that hold a boolean in `acknowledged`.                                                                                                                                                                                    | 8.13.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11517))Retain `acknowledged` object.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11517))Fix mapping of `darktrace.model_breach_alert.is_acknowledged`.                                                                                                    | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                 | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `host.mac` field conform to ECS field definition.                                                                                                                                                                                                                              | 8.12.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9402))Update manifest format version to v3.0.3.                                                                                                                                                                                                                                            | 8.12.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9127))Set sensitive values as secret.                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                            | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                 | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6924))Convert visualizations to lens.                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6581))Update package to pkg-spec 2.7.0.                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                         | 8.2.1                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5677))Release Darktrace as GA.                                                                                                                                                                                                                                                             | 8.2.1                  |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                               |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                         |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                         |                        |
  | **0.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4401))Remove duplicate fields.                                                                                                                                                                                                                                                                 |                        |
  | **0.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4427))Fix documentation                                                                                                                                                                                                                                                                        |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4001))Initial Release.                                                                                                                                                                                                                                                                     |                        |
</dropdown>