﻿---
title: Cybereason
description: Cybereason is a cybersecurity company that specializes in endpoint detection and response (EDR) solutions to help organizations detect and respond to...
url: https://www.elastic.co/docs/reference/integrations/cybereason
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cybereason
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.4.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |


## Overview

[Cybereason](https://www.cybereason.com/) is a cybersecurity company that specializes in endpoint detection and response (EDR) solutions to help organizations detect and respond to cyber threats. Cybereason's goal is to provide a comprehensive cybersecurity solution that helps organizations defend against a wide range of cyber threats, including malware, ransomware, and advanced persistent threats (APTs).
Use the Cybereason integration to collect and parse data from the REST APIs. Then visualize that data in Kibana.

## Compatibility

This module has been tested against the latest Cybereason On-Premises version **23.2**.

## Data streams

The Cybereason integration collects six types of logs: Logon Session, Malop Connection, Malop Process, Malware, Poll Malop and Suspicions Process.
- **[Logon Session](https://api-doc.cybereason.com/en/latest/APIReference/QueryAPI/queryElementFeatures.html#logon-session-edr)** - This data stream helps security teams monitor and analyze logon sessions within their network, identifying potential threats and taking appropriate action to mitigate risks.
- **[Malop Connection](https://api-doc.cybereason.com/en/latest/APIReference/QueryAPI/queryElementFeatures.html#connection-edr-and-xdr)** - This data stream provides detailed insights into network connections observed by the endpoint detection and response (EDR) system.
- **[Malop Process](https://api-doc.cybereason.com/en/latest/APIReference/QueryAPI/queryElementFeatures.html#malop-process-edr)** - This data stream provides details about malicious processes detected within their environment, aiding in the detection and mitigation of security threats.
- **[Malware](https://api-doc.cybereason.com/en/latest/APIReference/MalwareAPI/queryMalwareTypes.html#querymalware)** - This data stream provides detailed information about a malware detection event, including the detected file, its type, detection method, and additional metadata for analysis and response.
- **[Poll Malop](https://api-doc.cybereason.com/en/latest/APIReference/MalopAPI/getMalopsMalware.html#getmalopsmalware)** - This data stream provides comprehensive information about Malops detected by Cybereason's EDR system, enabling security teams to analyze and respond to potential threats effectively.
- ***Suspicions Process*** - This data stream provides detailed information about processes that are suspected or deemed malicious within the endpoint detection and response (EDR) system.

<note>
  Suspicions Process has the same endpoint as the first three data streams, we have added a filter - `hasSuspicions : true` and some custom fields to get the logs related to suspicions.
</note>


## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

## Setup


### Collect logs through REST API

1. To deploy a Cybereason instance in your environment, refer to the [Cybereason documentatiion](https://www.cybereason.com/platform/bundles).
2. Once deployed, you'll obtain the parameters such as host, port, username and password to configure Cybereason integration within your Elasticsearch environment.


### Enable the integration in Elastic

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **Cybereason**.
3. Select the **Cybereason** integration and add it.
4. While adding the integration, enter the following details to collect logs via REST API:
   - Host
- Port
- Username
- Password
- Initial Interval
- Interval
- Batch Size


## Logs Reference


### Logon Session

This is the `Logon Session` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-13T12:20:35.086Z",
      "agent": {
          "ephemeral_id": "07dcd4ef-af68-446f-8671-6dd7829fb915",
          "id": "e51f11c7-bcb2-4892-913a-7b52358df1c5",
          "name": "elastic-agent-37291",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "logon_session": {
              "element_values": {
                  "owner_machine": {
                      "element_values": [
                          {
                              "element_type": "Machine",
                              "guid": "_MlzCxCi55eyTiwX",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "desktop-f2nf4st",
                              "object": {
                                  "ownermachine": "myd"
                              },
                              "simple_values": {
                                  "machinesimple": "value"
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "processes": {
                      "element_values": [
                          {
                              "element_type": "MachineProcess",
                              "guid": "_MlzCxCi55eyTiwXYX",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "desktop-f2nf4stgy",
                              "object": {
                                  "process": "myd"
                              },
                              "simple_values": {
                                  "processsimple": "value"
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 320
                  },
                  "remote_machine": {
                      "element_values": [
                          {
                              "element_type": "Remote",
                              "guid": "AAAAGKxw2bFBmcGUssss",
                              "has_malops": false,
                              "has_suspicions": true,
                              "name": "desktop-f2nf4stmjremote",
                              "object": {
                                  "remote": "myd"
                              },
                              "simple_values": {
                                  "remotesimple": "value"
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "user": {
                      "element_values": [
                          {
                              "element_type": "User",
                              "has_malops": false,
                              "has_suspicions": false,
                              "object": {
                                  "user": "myd"
                              },
                              "simple_values": {
                                  "usersimple": "value"
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  }
              },
              "evidence_map": {
                  "evidence": "map"
              },
              "filter_data": {
                  "group_by_value": "{guid=AAAAGKxw2bFBmcGU, __typename=User, elementDisplayName=desktop-f2nf4st\\eden, group=7af5074f-ab26-43b3-b0f1-acc962920615, hasSuspicions=false, hasMalops=false}",
                  "sort_in_group_value": "hyefilter"
              },
              "is_malicious": false,
              "labels_ids": "l1",
              "malicious": false,
              "malop_priority": "HIGH",
              "simple_values": {
                  "creation_time": {
                      "total_values": 1
                  },
                  "element_display_name": {
                      "total_values": 1,
                      "values": [
                          "Unknown host > desktop-f2nf4st"
                      ]
                  },
                  "group": {
                      "total_values": 1,
                      "values": [
                          "00000000-0000-0000-0000-000000000000"
                      ]
                  },
                  "logon_type": {
                      "total_values": 1,
                      "values": [
                          "SLT_RemoteInteractive"
                      ]
                  }
              },
              "suspect": false,
              "suspicion_count": 0,
              "suspicions": {
                  "xyz": "dhyg"
              },
              "suspicions_map": {
                  "suspicions": "map"
              }
          }
      },
      "data_stream": {
          "dataset": "cybereason.logon_session",
          "namespace": "12691",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e51f11c7-bcb2-4892-913a-7b52358df1c5",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "dataset": "cybereason.logon_session",
          "id": "_MlzC6rnLebZ2aBh",
          "ingested": "2026-01-19T11:24:20Z",
          "kind": "alert",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "user": [
              "AAAAGKxw2bFBmcGU",
              "desktop-f2nf4st\\eden"
          ]
      },
      "tags": [
          "forwarded",
          "cybereason-logon_session"
      ],
      "user": {
          "id": [
              "AAAAGKxw2bFBmcGU"
          ],
          "name": [
              "desktop-f2nf4st\\eden"
          ]
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                | Description             | Type             |
  |--------------------------------------------------------------------------------------|-------------------------|------------------|
  | @timestamp                                                                           | Event timestamp.        | date             |
  | cybereason.logon_session.element_values.owner_machine.element_values.element_type    |                         | keyword          |
  | cybereason.logon_session.element_values.owner_machine.element_values.guid            |                         | keyword          |
  | cybereason.logon_session.element_values.owner_machine.element_values.has_malops      |                         | boolean          |
  | cybereason.logon_session.element_values.owner_machine.element_values.has_suspicions  |                         | boolean          |
  | cybereason.logon_session.element_values.owner_machine.element_values.name            |                         | keyword          |
  | cybereason.logon_session.element_values.owner_machine.element_values.object          |                         | flattened        |
  | cybereason.logon_session.element_values.owner_machine.element_values.simple_values   |                         | flattened        |
  | cybereason.logon_session.element_values.owner_machine.guessed_total                  |                         | long             |
  | cybereason.logon_session.element_values.owner_machine.total_malicious                |                         | long             |
  | cybereason.logon_session.element_values.owner_machine.total_suspicious               |                         | long             |
  | cybereason.logon_session.element_values.owner_machine.total_values                   |                         | long             |
  | cybereason.logon_session.element_values.processes.element_values.element_type        |                         | keyword          |
  | cybereason.logon_session.element_values.processes.element_values.guid                |                         | keyword          |
  | cybereason.logon_session.element_values.processes.element_values.has_malops          |                         | boolean          |
  | cybereason.logon_session.element_values.processes.element_values.has_suspicions      |                         | boolean          |
  | cybereason.logon_session.element_values.processes.element_values.name                |                         | keyword          |
  | cybereason.logon_session.element_values.processes.element_values.object              |                         | flattened        |
  | cybereason.logon_session.element_values.processes.element_values.simple_values       |                         | flattened        |
  | cybereason.logon_session.element_values.processes.guessed_total                      |                         | long             |
  | cybereason.logon_session.element_values.processes.total_malicious                    |                         | long             |
  | cybereason.logon_session.element_values.processes.total_suspicious                   |                         | long             |
  | cybereason.logon_session.element_values.processes.total_values                       |                         | long             |
  | cybereason.logon_session.element_values.remote_machine.element_values.element_type   |                         | keyword          |
  | cybereason.logon_session.element_values.remote_machine.element_values.guid           |                         | keyword          |
  | cybereason.logon_session.element_values.remote_machine.element_values.has_malops     |                         | boolean          |
  | cybereason.logon_session.element_values.remote_machine.element_values.has_suspicions |                         | boolean          |
  | cybereason.logon_session.element_values.remote_machine.element_values.name           |                         | keyword          |
  | cybereason.logon_session.element_values.remote_machine.element_values.object         |                         | flattened        |
  | cybereason.logon_session.element_values.remote_machine.element_values.simple_values  |                         | flattened        |
  | cybereason.logon_session.element_values.remote_machine.guessed_total                 |                         | long             |
  | cybereason.logon_session.element_values.remote_machine.total_malicious               |                         | long             |
  | cybereason.logon_session.element_values.remote_machine.total_suspicious              |                         | long             |
  | cybereason.logon_session.element_values.remote_machine.total_values                  |                         | long             |
  | cybereason.logon_session.element_values.user.element_values.element_type             |                         | keyword          |
  | cybereason.logon_session.element_values.user.element_values.guid                     |                         | keyword          |
  | cybereason.logon_session.element_values.user.element_values.has_malops               |                         | boolean          |
  | cybereason.logon_session.element_values.user.element_values.has_suspicions           |                         | boolean          |
  | cybereason.logon_session.element_values.user.element_values.name                     |                         | keyword          |
  | cybereason.logon_session.element_values.user.element_values.object                   |                         | flattened        |
  | cybereason.logon_session.element_values.user.element_values.simple_values            |                         | flattened        |
  | cybereason.logon_session.element_values.user.guessed_total                           |                         | long             |
  | cybereason.logon_session.element_values.user.total_malicious                         |                         | long             |
  | cybereason.logon_session.element_values.user.total_suspicious                        |                         | long             |
  | cybereason.logon_session.element_values.user.total_values                            |                         | long             |
  | cybereason.logon_session.evidence_map                                                |                         | flattened        |
  | cybereason.logon_session.filter_data.group_by_value                                  |                         | keyword          |
  | cybereason.logon_session.filter_data.sort_in_group_value                             |                         | keyword          |
  | cybereason.logon_session.guid_string                                                 |                         | keyword          |
  | cybereason.logon_session.is_malicious                                                |                         | boolean          |
  | cybereason.logon_session.labels_ids                                                  |                         | keyword          |
  | cybereason.logon_session.malicious                                                   |                         | boolean          |
  | cybereason.logon_session.malop_priority                                              |                         | keyword          |
  | cybereason.logon_session.simple_values.creation_time.total_values                    |                         | long             |
  | cybereason.logon_session.simple_values.creation_time.values                          |                         | date             |
  | cybereason.logon_session.simple_values.element_display_name.total_values             |                         | long             |
  | cybereason.logon_session.simple_values.element_display_name.values                   |                         | keyword          |
  | cybereason.logon_session.simple_values.group.total_values                            |                         | long             |
  | cybereason.logon_session.simple_values.group.values                                  |                         | keyword          |
  | cybereason.logon_session.simple_values.logon_type.total_values                       |                         | long             |
  | cybereason.logon_session.simple_values.logon_type.values                             |                         | keyword          |
  | cybereason.logon_session.suspect                                                     |                         | boolean          |
  | cybereason.logon_session.suspicion_count                                             |                         | long             |
  | cybereason.logon_session.suspicions                                                  |                         | flattened        |
  | cybereason.logon_session.suspicions_map                                              |                         | flattened        |
  | data_stream.dataset                                                                  | Data stream dataset.    | constant_keyword |
  | data_stream.namespace                                                                | Data stream namespace.  | constant_keyword |
  | data_stream.type                                                                     | Data stream type.       | constant_keyword |
  | event.dataset                                                                        | Event dataset.          | constant_keyword |
  | event.module                                                                         | Event module.           | constant_keyword |
  | input.type                                                                           | Type of filebeat input. | keyword          |
  | log.offset                                                                           | Log offset.             | long             |
</dropdown>


### Malop Connection

This is the `Malop Connection` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-13T11:54:39.973Z",
      "agent": {
          "ephemeral_id": "2b3b5a2e-e781-44e3-bd05-aace5f649e7e",
          "id": "5e2db3f9-88ca-42de-a8f3-fdc7b4eef616",
          "name": "elastic-agent-27544",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "malop_connection": {
              "element_values": {
                  "dns_query": {
                      "element_values": [
                          {
                              "element_type": "Machine",
                              "guid": "7vCmFBCi55eyTiwX",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "dim-win10"
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "owner_machine": {
                      "element_values": [
                          {
                              "element_type": "Machine",
                              "has_malops": false,
                              "has_suspicions": false,
                              "object": {
                                  "pole": "bye"
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "owner_process": {
                      "element_values": [
                          {
                              "element_type": "Process",
                              "guid": "7vCmFPstj36nuaBO",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "backgroundtaskhost.exe",
                              "object": {
                                  "user": {
                                      "elementValues": [
                                          {
                                              "elementType": "User",
                                              "guid": "AAAAGGZ3xLXVm27e",
                                              "hasMalops": false,
                                              "hasSuspicions": false,
                                              "name": "cy\\cymulator",
                                              "simpleValues": {
                                                  "ok": "lope"
                                              }
                                          }
                                      ],
                                      "guessedTotal": 0,
                                      "totalMalicious": 0,
                                      "totalSuspicious": 0,
                                      "totalValues": 1
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "owner_process_user": {
                      "element_values": [
                          {
                              "element_type": "User",
                              "guid": "AAAAGGZ3xLXVm27e",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "cy\\cymulator"
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  }
              },
              "evidence_map": {
                  "evidence": "map"
              },
              "filter_data": {
                  "group_by_value": "81.2.69.192:50394 > 81.2.69.142:443",
                  "sort_in_group_value": "filter"
              },
              "is_malicious": false,
              "labels_ids": "labelids",
              "malicious": false,
              "malop_priority": "MEDIUM",
              "simple_values": {
                  "accessed_by_malware_evidence": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "aggregated_received_bytes_count": {
                      "total_values": 1,
                      "values": [
                          6811
                      ]
                  },
                  "aggregated_transmitted_bytes_count": {
                      "total_values": 1,
                      "values": [
                          4098
                      ]
                  },
                  "calculated_creation_time": {
                      "total_values": 1
                  },
                  "direction": {
                      "total_values": 1,
                      "values": [
                          "OUTGOING"
                      ]
                  },
                  "element_display_name": {
                      "total_values": 1,
                      "values": [
                          "81.2.69.192:50394 > 81.2.69.142:443"
                      ]
                  },
                  "end_time": {
                      "total_values": 1
                  },
                  "group": {
                      "total_values": 1,
                      "values": [
                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                      ]
                  },
                  "local_port": {
                      "total_values": 1,
                      "values": [
                          50394
                      ]
                  },
                  "port_type": {
                      "total_values": 1,
                      "values": [
                          "SERVICE_HTTP"
                      ]
                  },
                  "remote_address_country_name": {
                      "total_values": 1,
                      "values": [
                          "United States"
                      ]
                  },
                  "remote_port": {
                      "total_values": 1,
                      "values": [
                          443
                      ]
                  },
                  "server_address": {
                      "total_values": 1
                  },
                  "server_port": {
                      "total_values": 1
                  },
                  "state": {
                      "total_values": 1,
                      "values": [
                          "CONNECTION_OPEN"
                      ]
                  },
                  "transport_protocol": {
                      "total_values": 1
                  }
              },
              "suspect": false,
              "suspicion_count": 0,
              "suspicions": {
                  "malop": "connection"
              },
              "suspicions_map": {
                  "suspicions": "map"
              }
          }
      },
      "data_stream": {
          "dataset": "cybereason.malop_connection",
          "namespace": "20774",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5e2db3f9-88ca-42de-a8f3-fdc7b4eef616",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "cybereason.malop_connection",
          "end": "2024-03-13T11:55:40.803Z",
          "id": "7vCmFD3khy-bwG9X",
          "ingested": "2026-01-19T11:28:48Z",
          "kind": "alert",
          "type": [
              "connection"
          ]
      },
      "input": {
          "type": "cel"
      },
      "network": {
          "transport": "TCP"
      },
      "process": {
          "real_user": {
              "id": [
                  "7vCmFBCi55eyTiwX"
              ],
              "name": [
                  "dim-win10"
              ]
          }
      },
      "related": {
          "ip": [
              "0.0.0.0"
          ],
          "user": [
              "7vCmFBCi55eyTiwX",
              "dim-win10"
          ]
      },
      "server": {
          "address": [
              "0.0.0.0"
          ],
          "ip": "0.0.0.0",
          "port": 443
      },
      "tags": [
          "forwarded",
          "cybereason-malop_connection"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                       | Description                                                                | Type             |
  |---------------------------------------------------------------------------------------------|----------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                  | Event timestamp.                                                           | date             |
  | cybereason.malop_connection.element_values.dns_query.element_values.element_type            |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.dns_query.element_values.guid                    |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.dns_query.element_values.has_malops              | Indicates whether or not the connection is associated with any Malops.     | boolean          |
  | cybereason.malop_connection.element_values.dns_query.element_values.has_suspicions          | Indicates whether or not the connection is associated with any suspicions. | boolean          |
  | cybereason.malop_connection.element_values.dns_query.element_values.name                    |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.dns_query.element_values.object                  |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.dns_query.element_values.simple_values           |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.dns_query.guessed_total                          |                                                                            | long             |
  | cybereason.malop_connection.element_values.dns_query.total_malicious                        |                                                                            | long             |
  | cybereason.malop_connection.element_values.dns_query.total_suspicious                       |                                                                            | long             |
  | cybereason.malop_connection.element_values.dns_query.total_values                           |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_machine.element_values.element_type        |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_machine.element_values.guid                |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_machine.element_values.has_malops          |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_machine.element_values.has_suspicions      |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_machine.element_values.name                |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_machine.element_values.object              |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_machine.element_values.simple_values       |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_machine.guessed_total                      |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_machine.total_malicious                    |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_machine.total_suspicious                   |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_machine.total_values                       |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process.element_values.element_type        |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process.element_values.guid                |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process.element_values.has_malops          |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_process.element_values.has_suspicions      |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_process.element_values.name                |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process.element_values.object              |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_process.element_values.simple_values       |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_process.guessed_total                      |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process.total_malicious                    |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process.total_suspicious                   |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process.total_values                       |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.element_type   |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.guid           |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.has_malops     |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.has_suspicions |                                                                            | boolean          |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.name           |                                                                            | keyword          |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.object         |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_process_user.element_values.simple_values  |                                                                            | flattened        |
  | cybereason.malop_connection.element_values.owner_process_user.guessed_total                 |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process_user.total_malicious               |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process_user.total_suspicious              |                                                                            | long             |
  | cybereason.malop_connection.element_values.owner_process_user.total_values                  |                                                                            | long             |
  | cybereason.malop_connection.evidence_map                                                    |                                                                            | flattened        |
  | cybereason.malop_connection.filter_data.group_by_value                                      | The value by which the results are sorted.                                 | keyword          |
  | cybereason.malop_connection.filter_data.sort_in_group_value                                 | The unique numerical value Cybereason assigned to the results group.       | keyword          |
  | cybereason.malop_connection.guid_string                                                     |                                                                            | keyword          |
  | cybereason.malop_connection.is_malicious                                                    |                                                                            | boolean          |
  | cybereason.malop_connection.labels_ids                                                      |                                                                            | keyword          |
  | cybereason.malop_connection.malicious                                                       |                                                                            | boolean          |
  | cybereason.malop_connection.malop_priority                                                  |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.accessed_by_malware_evidence.total_values         |                                                                            | long             |
  | cybereason.malop_connection.simple_values.accessed_by_malware_evidence.values               |                                                                            | boolean          |
  | cybereason.malop_connection.simple_values.aggregated_received_bytes_count.total_values      |                                                                            | long             |
  | cybereason.malop_connection.simple_values.aggregated_received_bytes_count.values            |                                                                            | long             |
  | cybereason.malop_connection.simple_values.aggregated_transmitted_bytes_count.total_values   |                                                                            | long             |
  | cybereason.malop_connection.simple_values.aggregated_transmitted_bytes_count.values         |                                                                            | long             |
  | cybereason.malop_connection.simple_values.calculated_creation_time.total_values             |                                                                            | long             |
  | cybereason.malop_connection.simple_values.calculated_creation_time.values                   |                                                                            | date             |
  | cybereason.malop_connection.simple_values.direction.total_values                            |                                                                            | long             |
  | cybereason.malop_connection.simple_values.direction.values                                  |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.element_display_name.total_values                 |                                                                            | long             |
  | cybereason.malop_connection.simple_values.element_display_name.values                       |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.end_time.total_values                             |                                                                            | long             |
  | cybereason.malop_connection.simple_values.end_time.values                                   | The end time (in epoch) of the period during which to search.              | date             |
  | cybereason.malop_connection.simple_values.group.total_values                                |                                                                            | long             |
  | cybereason.malop_connection.simple_values.group.values                                      |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.local_port.total_values                           |                                                                            | long             |
  | cybereason.malop_connection.simple_values.local_port.values                                 |                                                                            | long             |
  | cybereason.malop_connection.simple_values.port_type.total_values                            |                                                                            | long             |
  | cybereason.malop_connection.simple_values.port_type.values                                  |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.remote_address_country_name.total_values          |                                                                            | long             |
  | cybereason.malop_connection.simple_values.remote_address_country_name.values                |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.remote_port.total_values                          |                                                                            | long             |
  | cybereason.malop_connection.simple_values.remote_port.values                                |                                                                            | long             |
  | cybereason.malop_connection.simple_values.server_address.total_values                       |                                                                            | long             |
  | cybereason.malop_connection.simple_values.server_address.values                             |                                                                            | ip               |
  | cybereason.malop_connection.simple_values.server_port.total_values                          |                                                                            | long             |
  | cybereason.malop_connection.simple_values.server_port.values                                |                                                                            | long             |
  | cybereason.malop_connection.simple_values.state.total_values                                |                                                                            | long             |
  | cybereason.malop_connection.simple_values.state.values                                      |                                                                            | keyword          |
  | cybereason.malop_connection.simple_values.transport_protocol.total_values                   |                                                                            | long             |
  | cybereason.malop_connection.simple_values.transport_protocol.values                         |                                                                            | keyword          |
  | cybereason.malop_connection.suspect                                                         |                                                                            | boolean          |
  | cybereason.malop_connection.suspicion_count                                                 |                                                                            | long             |
  | cybereason.malop_connection.suspicions                                                      |                                                                            | flattened        |
  | cybereason.malop_connection.suspicions_map                                                  |                                                                            | flattened        |
  | data_stream.dataset                                                                         | Data stream dataset.                                                       | constant_keyword |
  | data_stream.namespace                                                                       | Data stream namespace.                                                     | constant_keyword |
  | data_stream.type                                                                            | Data stream type.                                                          | constant_keyword |
  | event.dataset                                                                               | Event dataset.                                                             | constant_keyword |
  | event.module                                                                                | Event module.                                                              | constant_keyword |
  | input.type                                                                                  | Type of filebeat input.                                                    | keyword          |
  | log.offset                                                                                  | Log offset.                                                                | long             |
</dropdown>


### Malop Process

This is the `Malop Process` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-12-28T19:03:51.785Z",
      "agent": {
          "ephemeral_id": "179ce7de-f541-473f-a8bd-d658e77323c5",
          "id": "1d155bfd-3b0e-434f-90a2-20752394d10d",
          "name": "elastic-agent-50879",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "malop_process": {
              "element_values": {
                  "affected_machines": {
                      "element_values": [
                          {
                              "element_type": "Machine",
                              "guid": "zpP73xCi55eyTiwX",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "cybereason",
                              "object": {
                                  "element": "values"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "cybereason"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73xCi55eyTiwX"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          false
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          false
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "affected_users": {
                      "element_values": [
                          {
                              "element_type": "User",
                              "guid": "AAAAGAJYAICT5xYW",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "cybereason\\theavengers",
                              "object": {
                                  "values": "element"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "cybereason\\theavengers"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "AAAAGAJYAICT5xYW"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          false
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          false
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "files_to_remediate": {
                      "element_values": [
                          {
                              "element_type": "File",
                              "guid": "zpP7358Lbsf7z787",
                              "has_malops": false,
                              "has_suspicions": true,
                              "name": "x64cymulateprocesshider.exe",
                              "object": {
                                  "files": "remediate"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "x64cymulateprocesshider.exe"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP7358Lbsf7z787"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          false
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 1,
                      "total_values": 1
                  },
                  "primary_root_cause_elements": {
                      "element_values": [
                          {
                              "element_type": "Process",
                              "guid": "zpP73wfcKRFKvnZa",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wfcKRFKvnZa"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73yUewMOXCNBN",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "object": {
                                  "values": "primaryroot"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73yUewMOXCNBN"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73wdciiw3CcZ9",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wdciiw3CcZ9"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73zALshBfA7mQ",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73zALshBfA7mQ"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP736Yq9t-ujawF",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP736Yq9t-ujawF"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP736adtvfQP86p",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP736adtvfQP86p"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73yUHiaZd-JI6",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73yUHiaZd-JI6"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP733Hfwc2Ol2KV",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP733Hfwc2Ol2KV"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73zlRSCV3N9Si",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73zlRSCV3N9Si"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73-Mvct_YhLo2",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73-Mvct_YhLo2"
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 10
                  },
                  "root_cause_elements": {
                      "element_values": [
                          {
                              "element_type": "Process",
                              "guid": "zpP735vQl83mbAFk",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "object": {
                                  "element": "root"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP735vQl83mbAFk"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP733MJZQ5ua9PD",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP733MJZQ5ua9PD"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73wfcKRFKvnZa",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wfcKRFKvnZa"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73yUewMOXCNBN",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73yUewMOXCNBN"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73wdciiw3CcZ9",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wdciiw3CcZ9"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73-slLQbqr1eb",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73-slLQbqr1eb"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73xTlNawf6qox",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73xTlNawf6qox"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP736adtvfQP86p",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP736adtvfQP86p"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP732Q23xdwLJhh",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP732Q23xdwLJhh"
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73zlRSCV3N9Si",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73zlRSCV3N9Si"
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 10
                  },
                  "suspects": {
                      "element_values": [
                          {
                              "element_type": "Process",
                              "guid": "zpP735vQl83mbAFk",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "object": {
                                  "type": "suspects"
                              },
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP735vQl83mbAFk"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP733MJZQ5ua9PD",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP733MJZQ5ua9PD"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73wfcKRFKvnZa",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wfcKRFKvnZa"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73yUewMOXCNBN",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73yUewMOXCNBN"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73wdciiw3CcZ9",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73wdciiw3CcZ9"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73-slLQbqr1eb",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73-slLQbqr1eb"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73xTlNawf6qox",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73xTlNawf6qox"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP736adtvfQP86p",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP736adtvfQP86p"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP732Q23xdwLJhh",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP732Q23xdwLJhh"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          },
                          {
                              "element_type": "Process",
                              "guid": "zpP73zlRSCV3N9Si",
                              "has_malops": true,
                              "has_suspicions": true,
                              "name": "injected (chain of injections)",
                              "simple_values": {
                                  "element_display_name": {
                                      "total_values": 1,
                                      "values": [
                                          "injected (chain of injections)"
                                      ]
                                  },
                                  "group": {
                                      "total_values": 1,
                                      "values": [
                                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                                      ]
                                  },
                                  "guid": {
                                      "total_values": 1,
                                      "values": [
                                          "zpP73zlRSCV3N9Si"
                                      ]
                                  },
                                  "has_malops": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  },
                                  "has_suspicions": {
                                      "total_values": 1,
                                      "values": [
                                          true
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessedTotal": 0,
                      "total_malicious": 10,
                      "total_suspicious": 10,
                      "total_values": 10
                  }
              },
              "evidence_map": {
                  "evidence": "map"
              },
              "filter_data": {
                  "group_by_value": "NONE_MALOP_ACTIVITY_TYPE",
                  "sort_in_group_value": "hello"
              },
              "is_malicious": false,
              "labels_ids": "lbl2",
              "malicious": false,
              "malop_priority": "LOW",
              "simple_values": {
                  "all_ransomware_processes_suspended": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "creation_time": {
                      "total_values": 1
                  },
                  "decision_feature": {
                      "total_values": 1,
                      "values": [
                          "Process.maliciousByCodeInjection(Malop decision)"
                      ]
                  },
                  "decision_feature_set": {
                      "total_values": 1,
                      "values": [
                          "Process.maliciousByCodeInjection(Malop decision)"
                      ]
                  },
                  "detection_type": {
                      "total_values": 1,
                      "values": [
                          "PROCESS_INJECTION"
                      ]
                  },
                  "has_ransomware_suspended_processes": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "icon_base64": {
                      "total_values": 1,
                      "values": [
                          "base"
                      ]
                  },
                  "is_blocked": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "malop": {
                      "activity_types": {
                          "total_values": 2,
                          "values": [
                              "NONE_MALOP_ACTIVITY_TYPE",
                              "MALICIOUS_INFECTION"
                          ]
                      },
                      "last_update_time": {
                          "total_values": 1
                      },
                      "start_time": {
                          "total_values": 1,
                          "values": [
                              "2023-12-28T18:59:35.356Z"
                          ]
                      }
                  },
                  "root_cause_element": {
                      "company_product": {
                          "total_values": 1,
                          "values": [
                              "product"
                          ]
                      },
                      "hashes": {
                          "total_values": 1,
                          "values": [
                              "nbvgyui765tghnxxx"
                          ]
                      },
                      "names": {
                          "total_values": 1,
                          "values": [
                              "injected (chain of injections)"
                          ]
                      },
                      "types": {
                          "total_values": 1,
                          "values": [
                              "Process"
                          ]
                      }
                  },
                  "total": {
                      "number_of": {
                          "incoming_connections": {
                              "total_values": 1,
                              "values": [
                                  768
                              ]
                          },
                          "outgoing_connections": {
                              "total_values": 1,
                              "values": [
                                  23
                              ]
                          }
                      },
                      "received_bytes": {
                          "total_values": 1
                      },
                      "transmitted_bytes": {
                          "total_values": 1
                      }
                  }
              },
              "suspect": false,
              "suspicion_count": 0,
              "suspicions": {
                  "connectingToBlackListAddressSuspicion": 1710261170916
              },
              "suspicions_map": {
                  "suspicions": "map"
              }
          }
      },
      "data_stream": {
          "dataset": "cybereason.malop_process",
          "namespace": "16645",
          "type": "logs"
      },
      "destination": {
          "bytes": 76
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "1d155bfd-3b0e-434f-90a2-20752394d10d",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2023-12-28T19:01:46.501Z",
          "dataset": "cybereason.malop_process",
          "id": "AAAA0xquIk3X9oQ_",
          "ingested": "2026-01-19T11:33:47Z",
          "kind": "alert",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hash": [
              "nbvgyui765tghnxxx"
          ]
      },
      "source": {
          "bytes": 90
      },
      "tags": [
          "forwarded",
          "cybereason-malop_process"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                                                              | Description                                                                                                          | Type             |
  |------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                                                         | Event timestamp.                                                                                                     | date             |
  | cybereason.malop_process.element_values.affected_machines.element_values.element_type                                              |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.guid                                                      |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.has_malops                                                |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_machines.element_values.has_suspicions                                            |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_machines.element_values.name                                                      |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.object                                                    |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.element_display_name.total_values           |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.element_display_name.values                 |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.group.total_values                          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.group.values                                |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.guid.total_values                           |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.guid.values                                 |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.has_malops.total_values                     |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.has_malops.values                           |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.has_suspicions.total_values                 |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.element_values.simple_values.has_suspicions.values                       |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_machines.guessed_total                                                            |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.total_malicious                                                          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.total_suspicious                                                         |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_machines.total_values                                                             |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.element_type                                                 |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.guid                                                         |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.has_malops                                                   |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_users.element_values.has_suspicions                                               |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_users.element_values.name                                                         |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.object                                                       |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.element_display_name.total_values              |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.element_display_name.values                    |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.group.total_values                             |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.group.values                                   |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.guid.total_values                              |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.guid.values                                    |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.has_malops.total_values                        |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.has_malops.values                              |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.has_suspicions.total_values                    |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.element_values.simple_values.has_suspicions.values                          |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.affected_users.guessed_total                                                               |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.total_malicious                                                             |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.total_suspicious                                                            |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.affected_users.total_values                                                                |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.element_type                                             |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.guid                                                     |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.has_malops                                               |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.has_suspicions                                           |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.name                                                     |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.object                                                   |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.element_display_name.total_values          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.element_display_name.values                |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.group.total_values                         |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.group.values                               |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.guid.total_values                          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.guid.values                                |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.has_malops.total_values                    |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.has_malops.values                          |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.has_suspicions.total_values                |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.element_values.simple_values.has_suspicions.values                      |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.files_to_remediate.guessed_total                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.total_malicious                                                         |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.total_suspicious                                                        |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.files_to_remediate.total_values                                                            |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.element_type                                    |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.guid                                            |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.has_malops                                      |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.has_suspicions                                  |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.name                                            |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.object                                          |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.element_display_name.total_values |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.element_display_name.values       |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.group.total_values                |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.group.values                      |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.guid.total_values                 |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.element_values.simple_values.guid.values                       |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.primary_root_cause_elements.guessed_total                                                  |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.total_malicious                                                |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.total_suspicious                                               |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.primary_root_cause_elements.total_values                                                   |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.element_type                                            |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.guid                                                    |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.has_malops                                              |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.has_suspicions                                          |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.name                                                    |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.object                                                  |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.element_display_name.total_values         |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.element_display_name.values               |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.group.total_values                        |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.group.values                              |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.guid.total_values                         |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.element_values.simple_values.guid.values                               |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.root_cause_elements.guessed_total                                                          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.total_malicious                                                        |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.total_suspicious                                                       |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.root_cause_elements.total_values                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.element_type                                                       |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.guid                                                               |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.has_malops                                                         |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.suspects.element_values.has_suspicions                                                     |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.suspects.element_values.name                                                               |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.object                                                             |                                                                                                                      | flattened        |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.element_display_name.total_values                    |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.element_display_name.values                          |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.group.total_values                                   |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.group.values                                         |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.guid.total_values                                    |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.guid.values                                          |                                                                                                                      | keyword          |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.has_malops.total_values                              |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.has_malops.values                                    |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.has_suspicions.total_values                          |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.element_values.simple_values.has_suspicions.values                                |                                                                                                                      | boolean          |
  | cybereason.malop_process.element_values.suspects.guessedTotal                                                                      |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.total_malicious                                                                   |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.total_suspicious                                                                  |                                                                                                                      | long             |
  | cybereason.malop_process.element_values.suspects.total_values                                                                      |                                                                                                                      | long             |
  | cybereason.malop_process.evidence_map                                                                                              |                                                                                                                      | flattened        |
  | cybereason.malop_process.filter_data.group_by_value                                                                                |                                                                                                                      | keyword          |
  | cybereason.malop_process.filter_data.sort_in_group_value                                                                           |                                                                                                                      | keyword          |
  | cybereason.malop_process.guid_string                                                                                               |                                                                                                                      | keyword          |
  | cybereason.malop_process.is_malicious                                                                                              |                                                                                                                      | boolean          |
  | cybereason.malop_process.labels_ids                                                                                                |                                                                                                                      | keyword          |
  | cybereason.malop_process.malicious                                                                                                 |                                                                                                                      | boolean          |
  | cybereason.malop_process.malop_priority                                                                                            |                                                                                                                      | keyword          |
  | cybereason.malop_process.simple_values.all_ransomware_processes_suspended.total_values                                             |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.all_ransomware_processes_suspended.values                                                   | Indicates whether or not the Malop has malicious processes which are suspended.                                      | boolean          |
  | cybereason.malop_process.simple_values.creation_time.total_values                                                                  |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.creation_time.values                                                                        |                                                                                                                      | date             |
  | cybereason.malop_process.simple_values.decision_feature.total_values                                                               |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.decision_feature.values                                                                     |                                                                                                                      | keyword          |
  | cybereason.malop_process.simple_values.decision_feature_set.total_values                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.decision_feature_set.values                                                                 |                                                                                                                      | keyword          |
  | cybereason.malop_process.simple_values.detection_type.total_values                                                                 |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.detection_type.values                                                                       | The root cause for the Malop. .                                                                                      | keyword          |
  | cybereason.malop_process.simple_values.has_ransomware_suspended_processes.total_values                                             |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.has_ransomware_suspended_processes.values                                                   | Indicates whether or not any of the Malop’s suspicious processes are currently suspended due to ransomware activity. | boolean          |
  | cybereason.malop_process.simple_values.icon_base64.total_values                                                                    |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.icon_base64.values                                                                          |                                                                                                                      | keyword          |
  | cybereason.malop_process.simple_values.is_blocked.total_values                                                                     |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.is_blocked.values                                                                           | Indicates whether or not the Malop has malicious processes that are marked for prevention.                           | boolean          |
  | cybereason.malop_process.simple_values.malop.activity_types.total_values                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.malop.activity_types.values                                                                 | Type of activity detected.                                                                                           | keyword          |
  | cybereason.malop_process.simple_values.malop.last_update_time.total_values                                                         |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.malop.last_update_time.values                                                               |                                                                                                                      | date             |
  | cybereason.malop_process.simple_values.malop.start_time.total_values                                                               |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.malop.start_time.values                                                                     |                                                                                                                      | date             |
  | cybereason.malop_process.simple_values.root_cause_element.company_product.total_values                                             |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.root_cause_element.company_product.values                                                   | The company and product associated with the Element that triggered the Malop, represented as company:product.        | keyword          |
  | cybereason.malop_process.simple_values.root_cause_element.hashes.total_values                                                      |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.root_cause_element.hashes.values                                                            | Hash value of the Element that triggered the Malop.                                                                  | keyword          |
  | cybereason.malop_process.simple_values.root_cause_element.names.total_values                                                       |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.root_cause_element.names.values                                                             | Name of the Element that triggered the Malop.                                                                        | keyword          |
  | cybereason.malop_process.simple_values.root_cause_element.types.total_values                                                       |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.root_cause_element.types.values                                                             | Type of Element that triggered the Malop.                                                                            | keyword          |
  | cybereason.malop_process.simple_values.total.number_of.incoming_connections.total_values                                           |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.total.number_of.incoming_connections.values                                                 | Total number of incoming connections associated with the malicious process.                                          | long             |
  | cybereason.malop_process.simple_values.total.number_of.outgoing_connections.total_values                                           |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.total.number_of.outgoing_connections.values                                                 | Total number of outgoing connections associated with the malicious process.                                          | long             |
  | cybereason.malop_process.simple_values.total.received_bytes.total_values                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.total.received_bytes.values                                                                 | Total bytes received by the malicious process.                                                                       | long             |
  | cybereason.malop_process.simple_values.total.transmitted_bytes.total_values                                                        |                                                                                                                      | long             |
  | cybereason.malop_process.simple_values.total.transmitted_bytes.values                                                              | Total bytes transmitted by the malicious process.                                                                    | long             |
  | cybereason.malop_process.suspect                                                                                                   |                                                                                                                      | boolean          |
  | cybereason.malop_process.suspicion_count                                                                                           |                                                                                                                      | long             |
  | cybereason.malop_process.suspicions                                                                                                |                                                                                                                      | flattened        |
  | cybereason.malop_process.suspicions_map                                                                                            |                                                                                                                      | flattened        |
  | data_stream.dataset                                                                                                                | Data stream dataset.                                                                                                 | constant_keyword |
  | data_stream.namespace                                                                                                              | Data stream namespace.                                                                                               | constant_keyword |
  | data_stream.type                                                                                                                   | Data stream type.                                                                                                    | constant_keyword |
  | event.dataset                                                                                                                      | Event dataset.                                                                                                       | constant_keyword |
  | event.module                                                                                                                       | Event module.                                                                                                        | constant_keyword |
  | input.type                                                                                                                         | Type of filebeat input.                                                                                              | keyword          |
  | log.offset                                                                                                                         | Log offset.                                                                                                          | long             |
</dropdown>


### Malware

This is the `Malware` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-11T08:56:57.000Z",
      "agent": {
          "ephemeral_id": "c2d057d4-1aca-4983-b656-c41004115e84",
          "id": "3b6ceef7-4273-4cba-84da-2a9a2354ac68",
          "name": "elastic-agent-72453",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "malware": {
              "data_model": {
                  "class": ".BaseFileMalwareDataModel",
                  "description": "EXECUTE_MALICIOUS_ACTIVITY",
                  "detection": {
                      "name": "IL:Trojan.MSILZilla.30425",
                      "rule": "Formatting (1106)"
                  },
                  "file_path": "c:\\programdata\\cymulate\\hopper\\boot64_1da739212534cbd666bc903c25b812e0\\cymulatelm64.exe",
                  "module": "Formatting (1106)",
                  "process_name": "remotefxvgpudisablement.exe",
                  "type": "UnknownMalware",
                  "url": "https://malware_data_model"
              },
              "detection": {
                  "engine": "StaticAnalysis",
                  "value": {
                      "original": "62b9e0dfd0ef2cd88fdcd412523c7d9f",
                      "type": "DVT_FILE"
                  }
              },
              "element_type": "File",
              "guid": "-286218732.7910817006083139531",
              "id": {
                  "element_type": "File",
                  "guid": "-286218732.7910817006083139531",
                  "malware_type": "UnknownMalware",
                  "timestamp": "2024-03-11T08:56:57.000Z"
              },
              "name": "cymulatelm64.exe",
              "needs_attention": false,
              "reference": {
                  "element_type": "File",
                  "guid": "-286218732.7910817006083139531"
              },
              "scheduler_scan": false,
              "score": 0.7721870783056456,
              "status": "Detected",
              "type": "UnknownMalware"
          }
      },
      "data_stream": {
          "dataset": "cybereason.malware",
          "namespace": "58750",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "3b6ceef7-4273-4cba-84da-2a9a2354ac68",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "dataset": "cybereason.malware",
          "ingested": "2026-01-20T05:31:37Z",
          "kind": "alert",
          "type": [
              "info"
          ]
      },
      "host": {
          "hostname": "dim-win10"
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hosts": [
              "dim-win10"
          ]
      },
      "tags": [
          "forwarded",
          "cybereason-malware"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                        | Description                                                                                                                  | Type             |
  |----------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                   | Event timestamp.                                                                                                             | date             |
  | cybereason.malware.data_model.class          |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.description    |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.detection.name |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.detection.rule |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.file_path      | The path to the file for the malware.                                                                                        | keyword          |
  | cybereason.malware.data_model.module         |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.process_name   |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.type           |                                                                                                                              | keyword          |
  | cybereason.malware.data_model.url            |                                                                                                                              | keyword          |
  | cybereason.malware.detection.engine          |                                                                                                                              | keyword          |
  | cybereason.malware.detection.value.original  |                                                                                                                              | keyword          |
  | cybereason.malware.detection.value.type      |                                                                                                                              | keyword          |
  | cybereason.malware.element_type              |                                                                                                                              | keyword          |
  | cybereason.malware.guid                      | The unique GUID the Cybereason platform uses for this specific malware instance.                                             | keyword          |
  | cybereason.malware.id.element_type           |                                                                                                                              | keyword          |
  | cybereason.malware.id.guid                   |                                                                                                                              | keyword          |
  | cybereason.malware.id.malware_type           |                                                                                                                              | keyword          |
  | cybereason.malware.id.timestamp              |                                                                                                                              | date             |
  | cybereason.malware.machine_name              | The name of the machine on which the Cybereason platform found the malware.                                                  | keyword          |
  | cybereason.malware.name                      | The name of the process running the malware.                                                                                 | keyword          |
  | cybereason.malware.needs_attention           |                                                                                                                              | boolean          |
  | cybereason.malware.reference.element_type    |                                                                                                                              | keyword          |
  | cybereason.malware.reference.guid            |                                                                                                                              | keyword          |
  | cybereason.malware.scheduler_scan            |                                                                                                                              | boolean          |
  | cybereason.malware.score                     |                                                                                                                              | double           |
  | cybereason.malware.status                    | The detection status of the malware. This should match the Anti-Malware settings you specified for your Cybereason platform. | keyword          |
  | cybereason.malware.timestamp                 | The time (in epoch) when the Cybereason platform detected this malware.                                                      | date             |
  | cybereason.malware.type                      | The type of malware as classified by the Cybereason platform.                                                                | keyword          |
  | data_stream.dataset                          | Data stream dataset.                                                                                                         | constant_keyword |
  | data_stream.namespace                        | Data stream namespace.                                                                                                       | constant_keyword |
  | data_stream.type                             | Data stream type.                                                                                                            | constant_keyword |
  | event.dataset                                | Event dataset.                                                                                                               | constant_keyword |
  | event.module                                 | Event module.                                                                                                                | constant_keyword |
  | input.type                                   | Type of filebeat input.                                                                                                      | keyword          |
  | log.offset                                   | Log offset.                                                                                                                  | long             |
</dropdown>


### Poll Malop

This is the `Poll Malop` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-04T19:12:56.110Z",
      "agent": {
          "ephemeral_id": "f3064f3b-9f53-4b80-a86a-403dcecb96a3",
          "id": "76c22ab0-d551-4b40-b2cd-68f4ad690db9",
          "name": "elastic-agent-64090",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "poll_malop": {
              "class": ".MalopInboxModel",
              "closed": false,
              "closer_name": "Closer Name",
              "containers": [
                  "Testing"
              ],
              "data": {
                  "close_time": "2023-11-23T06:45:15.015Z",
                  "detection_type": "CUSTOM_RULE",
                  "priority": "LOW",
                  "severity": "High",
                  "status": "Active",
                  "type": "CUSTOM_RULE"
              },
              "decision_statuses": [
                  "Testing"
              ],
              "detection": {
                  "engines": [
                      "EDR"
                  ],
                  "types": [
                      "calc_Custom_Rule"
                  ]
              },
              "display_name": "register-cimprovider.exe",
              "edr": true,
              "empty": true,
              "escalated": false,
              "icon_base64": "muhk",
              "labels": [
                  "IT-Pending",
                  "Testing"
              ],
              "machines": [
                  {
                      "class": ".MachineInboxModel",
                      "connected": false,
                      "empty": true,
                      "isolated": false,
                      "last_connected": "2024-01-07T06:23:30.725Z"
                  },
                  {
                      "class": ".MachineInboxModel",
                      "connected": true,
                      "empty": true,
                      "isolated": true,
                      "last_connected": "2024-03-18T08:30:50.941Z"
                  },
                  {
                      "class": ".MachineInboxModel",
                      "connected": false,
                      "empty": true,
                      "isolated": false,
                      "last_connected": "2024-03-17T16:21:34.714Z"
                  }
              ],
              "primary_root_cause_name": "register-cimprovider.exe",
              "priority": "HIGH",
              "root_cause_element": {
                  "hashes": "f7b32703e444fdc75c09840afa3dcda8286f3b24",
                  "names_count": 1,
                  "type": "Process"
              },
              "severity": "High",
              "status": "Active",
              "users": [
                  {
                      "admin": false,
                      "display_name": "d3dock-poc\\administrator",
                      "domain_user": false,
                      "guid": "AAAAGGHyKbMGbI4y",
                      "local_system": false
                  },
                  {
                      "admin": false,
                      "display_name": "cybereason\\system",
                      "domain_user": false,
                      "guid": "AAAAGK97gKTvmLc3",
                      "local_system": true
                  },
                  {
                      "admin": false,
                      "display_name": "cy\\cymulator",
                      "domain_user": false,
                      "guid": "AAAAGGZ3xLXVm27e",
                      "local_system": false
                  }
              ]
          }
      },
      "data_stream": {
          "dataset": "cybereason.poll_malop",
          "namespace": "53482",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "76c22ab0-d551-4b40-b2cd-68f4ad690db9",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2023-09-15T23:52:35.604Z",
          "dataset": "cybereason.poll_malop",
          "id": "AAAA05JzW7vmNhCD",
          "ingested": "2026-01-20T06:17:08Z",
          "kind": "alert",
          "type": [
              "info"
          ]
      },
      "group": {
          "id": [
              "72a61eac-6f79-4670-8607-a1334ddd2ff0"
          ]
      },
      "host": {
          "id": [
              "lbnnvBCi55eyTiwX",
              "zpP73xCi55eyTiwX",
              "7vCmFBCi55eyTiwX"
          ],
          "name": [
              "d3dock-poc",
              "cybereason",
              "dim-win10"
          ],
          "os": {
              "type": [
                  "windows",
                  "linux"
              ]
          }
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hash": [
              "f7b32703e444fdc75c09840afa3dcda8286f3b24"
          ],
          "hosts": [
              "d3dock-poc",
              "cybereason",
              "dim-win10",
              "lbnnvBCi55eyTiwX",
              "zpP73xCi55eyTiwX",
              "7vCmFBCi55eyTiwX",
              "WINDOWS",
              "linux",
              "xyz"
          ],
          "user": [
              "d3dock-poc\\administrator",
              "cybereason\\system",
              "cy\\cymulator",
              "AAAAGGHyKbMGbI4y",
              "AAAAGK97gKTvmLc3",
              "AAAAGGZ3xLXVm27e"
          ]
      },
      "tags": [
          "forwarded",
          "cybereason-poll_malop"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                | Description                                                                                             | Type             |
  |------------------------------------------------------|---------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                           | Event timestamp.                                                                                        | date             |
  | cybereason.poll_malop.class                          |                                                                                                         | keyword          |
  | cybereason.poll_malop.closed                         |                                                                                                         | boolean          |
  | cybereason.poll_malop.closer_name                    |                                                                                                         | keyword          |
  | cybereason.poll_malop.containers                     |                                                                                                         | keyword          |
  | cybereason.poll_malop.creation_time                  | The time (in epoch) when the Malop was generated.                                                       | date             |
  | cybereason.poll_malop.data.close_time                |                                                                                                         | date             |
  | cybereason.poll_malop.data.detection_type            | The type of detection for the root cause. .                                                             | keyword          |
  | cybereason.poll_malop.data.priority                  |                                                                                                         | keyword          |
  | cybereason.poll_malop.data.severity                  |                                                                                                         | keyword          |
  | cybereason.poll_malop.data.status                    |                                                                                                         | keyword          |
  | cybereason.poll_malop.data.type                      |                                                                                                         | keyword          |
  | cybereason.poll_malop.decision_statuses              | The prevention action that the Cybereason platform used for this Malop.                                 | keyword          |
  | cybereason.poll_malop.detection.engines              | The method of detecting the Malop.                                                                      | keyword          |
  | cybereason.poll_malop.detection.types                | The type of detection for the root cause.                                                               | keyword          |
  | cybereason.poll_malop.display_name                   | The display name for the item.                                                                          | keyword          |
  | cybereason.poll_malop.edr                            | Indicates whether the Malop is an Auto Hunt Malop or an Endpoint Protection Malop.                      | boolean          |
  | cybereason.poll_malop.empty                          |                                                                                                         | boolean          |
  | cybereason.poll_malop.escalated                      | Indicates whether someone has marked the Malop as escalated.                                            | boolean          |
  | cybereason.poll_malop.files                          | An object containing details on files associated with the MalOp.                                        | flattened        |
  | cybereason.poll_malop.group                          | The Group ID of the affected sensors.                                                                   | keyword          |
  | cybereason.poll_malop.guid                           | The unique GUID the Cybereason platform uses for the MalOp.                                             | keyword          |
  | cybereason.poll_malop.icon_base64                    | The base64 value for the item that is the root cause of the Malop.                                      | keyword          |
  | cybereason.poll_malop.labels                         | An object that contains details on the labels, such as the label name and the time the label was added. | keyword          |
  | cybereason.poll_malop.last_update_time               | The time (in epoch) when the Malop was last updated.                                                    | date             |
  | cybereason.poll_malop.machines.class                 |                                                                                                         | keyword          |
  | cybereason.poll_malop.machines.connected             | Indicates whether the machine is currently connected to the Cybereason server.                          | boolean          |
  | cybereason.poll_malop.machines.display_name          |                                                                                                         | keyword          |
  | cybereason.poll_malop.machines.empty                 |                                                                                                         | boolean          |
  | cybereason.poll_malop.machines.guid                  |                                                                                                         | keyword          |
  | cybereason.poll_malop.machines.isolated              | Indicates whether the machine is currently isolated.                                                    | boolean          |
  | cybereason.poll_malop.machines.last_connected        | The time (in epoch) when the machine was last connected to a Cybereason server.                         | date             |
  | cybereason.poll_malop.machines.os_type               | The operating system type of the affected machine. .                                                    | keyword          |
  | cybereason.poll_malop.primary_root_cause_name        |                                                                                                         | keyword          |
  | cybereason.poll_malop.priority                       | The priority assigned to the MalOp.                                                                     | keyword          |
  | cybereason.poll_malop.processes                      | An object containing details on processes associated with the MalOp.                                    | flattened        |
  | cybereason.poll_malop.root_cause_element.hashes      |                                                                                                         | keyword          |
  | cybereason.poll_malop.root_cause_element.names_count | A count of the items that are the root cause or causes of the Malop.                                    | long             |
  | cybereason.poll_malop.root_cause_element.type        | The Element that is the root cause of the Malop.                                                        | keyword          |
  | cybereason.poll_malop.severity                       | The Malop severity level.                                                                               | keyword          |
  | cybereason.poll_malop.status                         | The status of the Malop.                                                                                | keyword          |
  | cybereason.poll_malop.users.admin                    | Indicates whether the specified user has administrator privileges on the machine.                       | boolean          |
  | cybereason.poll_malop.users.display_name             |                                                                                                         | keyword          |
  | cybereason.poll_malop.users.domain_user              | Indicates whether the specified user is a domain user.                                                  | boolean          |
  | cybereason.poll_malop.users.guid                     |                                                                                                         | keyword          |
  | cybereason.poll_malop.users.local_system             | Indicates whether the specified user has local system privileges on the machine.                        | boolean          |
  | data_stream.dataset                                  | Data stream dataset.                                                                                    | constant_keyword |
  | data_stream.namespace                                | Data stream namespace.                                                                                  | constant_keyword |
  | data_stream.type                                     | Data stream type.                                                                                       | constant_keyword |
  | event.dataset                                        | Event dataset.                                                                                          | constant_keyword |
  | event.module                                         | Event module.                                                                                           | constant_keyword |
  | input.type                                           | Type of filebeat input.                                                                                 | keyword          |
  | log.offset                                           | Log offset.                                                                                             | long             |
</dropdown>


### Suspicions Process

This is the `Suspicions Process` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-12T15:13:27.872Z",
      "agent": {
          "ephemeral_id": "e51371e9-5904-4398-bbc8-1e624f59287c",
          "id": "02c714ca-5c57-484f-885f-ab3a7c633af8",
          "name": "elastic-agent-98770",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cybereason": {
          "suspicions_process": {
              "element_values": {
                  "calculated_user": {
                      "element_values": [
                          {
                              "element_type": "User",
                              "guid": "AAAAGGZ3xLXVm27e",
                              "has_malops": false,
                              "has_suspicions": false,
                              "name": "cy\\cymulator"
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "children": {
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 0
                  },
                  "image_file": {
                      "element_values": [
                          {
                              "element_type": "File",
                              "has_malops": false,
                              "has_suspicions": false,
                              "object": {
                                  "fileHash": {
                                      "elementValues": [
                                          {
                                              "elementType": "FileHash",
                                              "guid": "AAAAHuaPtU7zGEJc",
                                              "hasMalops": false,
                                              "hasSuspicions": false,
                                              "name": "a3c06b947549921d60d59917575df5ee5dfc472a",
                                              "simpleValues": {
                                                  "iconBase64": {
                                                      "totalValues": 1,
                                                      "values": [
                                                          "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"
                                                      ]
                                                  }
                                              }
                                          }
                                      ],
                                      "guessedTotal": 0,
                                      "totalMalicious": 0,
                                      "totalSuspicious": 0,
                                      "totalValues": 1
                                  }
                              },
                              "simple_values": {
                                  "companyName": {
                                      "totalValues": 1,
                                      "values": [
                                          "Microsoft Corporation"
                                      ]
                                  },
                                  "maliciousClassificationType": {
                                      "totalValues": 1,
                                      "values": [
                                          "indifferent"
                                      ]
                                  },
                                  "md5String": {
                                      "totalValues": 1,
                                      "values": [
                                          "5ac5ddc4c27ecc203b2ed62bbe8fb8b9"
                                      ]
                                  },
                                  "productName": {
                                      "totalValues": 1,
                                      "values": [
                                          "Microsoft Edge"
                                      ]
                                  },
                                  "sha1String": {
                                      "totalValues": 1,
                                      "values": [
                                          "a3c06b947549921d60d59917575df5ee5dfc472a"
                                      ]
                                  }
                              }
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "owner_machine": {
                      "element_values": [
                          {
                              "element_type": "Machine",
                              "has_malops": false,
                              "has_suspicions": false
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  },
                  "parent_process": {
                      "element_values": [
                          {
                              "element_type": "Process",
                              "has_malops": false,
                              "has_suspicions": false
                          }
                      ],
                      "guessed_total": 0,
                      "total_malicious": 0,
                      "total_suspicious": 0,
                      "total_values": 1
                  }
              },
              "evidence_map": {
                  "evidence": "map"
              },
              "filter_data": {
                  "group_by_value": "msedge.exe"
              },
              "is_malicious": true,
              "malicious": true,
              "simple_values": {
                  "command_line": {
                      "total_values": 1
                  },
                  "creation_time": {
                      "total_values": 1
                  },
                  "element_display_name": {
                      "total_values": 1,
                      "values": [
                          "msedge.exe"
                      ]
                  },
                  "end_time": {
                      "total_values": 1
                  },
                  "execution_prevented": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "group": {
                      "total_values": 1,
                      "values": [
                          "72a61eac-6f79-4670-8607-a1334ddd2ff0"
                      ]
                  },
                  "icon_base64": {
                      "total_values": 1,
                      "values": [
                          "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"
                      ]
                  },
                  "image_file_company_name": {
                      "total_values": 1,
                      "values": [
                          "Microsoft Corporation"
                      ]
                  },
                  "image_file_hash_icon_base64": {
                      "total_values": 1,
                      "values": [
                          "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"
                      ]
                  },
                  "image_file_malicious_classification_type": {
                      "total_values": 1,
                      "values": [
                          "indifferent"
                      ]
                  },
                  "image_file_md5_string": {
                      "total_values": 1
                  },
                  "image_file_product_name": {
                      "total_values": 1,
                      "values": [
                          "Microsoft Edge"
                      ]
                  },
                  "image_file_sha1_string": {
                      "total_values": 1
                  },
                  "is_image_file_signed_and_verified": {
                      "total_values": 1,
                      "values": [
                          true
                      ]
                  },
                  "is_white_list_classification": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  },
                  "product_type": {
                      "total_values": 1,
                      "values": [
                          "BROWSER"
                      ]
                  },
                  "ransomware_auto_remediation_suspended": {
                      "total_values": 1,
                      "values": [
                          false
                      ]
                  }
              },
              "suspect": true,
              "suspicion_count": 1,
              "suspicions": {
                  "connectingToBlackListAddressSuspicion": 1710232863248
              },
              "suspicions_map": {
                  "connectingToBlackListAddressSuspicion": {
                      "firstTimestamp": 1710232863248,
                      "potentialEvidence": [
                          "hasBlackListConnectionEvidence"
                      ],
                      "totalSuspicions": 4
                  }
              }
          }
      },
      "data_stream": {
          "dataset": "cybereason.suspicions_process",
          "namespace": "36786",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "02c714ca-5c57-484f-885f-ab3a7c633af8",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": [
              "2024-03-12T08:40:35.122Z"
          ],
          "dataset": "cybereason.suspicions_process",
          "id": "7vCmFCPB0XpbELrD",
          "ingested": "2026-01-20T05:56:29Z",
          "kind": "alert",
          "type": [
              "info"
          ]
      },
      "file": {
          "hash": {
              "md5": [
                  "5ac5ddc4c27ecc203b2ed62bbe8fb8b9"
              ],
              "sha1": [
                  "a3c06b947549921d60d59917575df5ee5dfc472a"
              ]
          },
          "name": [
              "msedge.exe"
          ],
          "uid": [
              "7vCmFKxNAQXpBIkL"
          ]
      },
      "input": {
          "type": "cel"
      },
      "process": {
          "command_line": [
              "\"C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\msedge.exe\" --type=utility --utility-sub-type=network.mojom.NetworkService --lang=en-US --service-sandbox-type=none --no-appcompat-clear --mojo-platform-channel-handle=2744 --field-trial-handle=2328,i,5521555393418764293,4286640738456912470,262144 --variations-seed-version /prefetch:3"
          ],
          "parent": {
              "entity_id": [
                  "7vCmFMsvYy739EW5"
              ],
              "name": [
                  "msedge.exe"
              ]
          },
          "real_user": {
              "id": [
                  "7vCmFBCi55eyTiwX"
              ],
              "name": [
                  "dim-win10"
              ]
          }
      },
      "related": {
          "hash": [
              "5ac5ddc4c27ecc203b2ed62bbe8fb8b9",
              "a3c06b947549921d60d59917575df5ee5dfc472a"
          ],
          "user": [
              "7vCmFBCi55eyTiwX",
              "dim-win10"
          ]
      },
      "tags": [
          "forwarded",
          "cybereason-suspicions_process"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                             | Description             | Type             |
  |---------------------------------------------------------------------------------------------------|-------------------------|------------------|
  | @timestamp                                                                                        | Event timestamp.        | date             |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.element_type          |                         | keyword          |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.guid                  |                         | keyword          |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.has_malops            |                         | boolean          |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.has_suspicions        |                         | boolean          |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.name                  |                         | keyword          |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.object                |                         | flattened        |
  | cybereason.suspicions_process.element_values.calculated_user.element_values.simple_values         |                         | flattened        |
  | cybereason.suspicions_process.element_values.calculated_user.guessed_total                        |                         | long             |
  | cybereason.suspicions_process.element_values.calculated_user.total_malicious                      |                         | long             |
  | cybereason.suspicions_process.element_values.calculated_user.total_suspicious                     |                         | long             |
  | cybereason.suspicions_process.element_values.calculated_user.total_values                         |                         | long             |
  | cybereason.suspicions_process.element_values.children.element_values.element_type                 |                         | keyword          |
  | cybereason.suspicions_process.element_values.children.element_values.guid                         |                         | keyword          |
  | cybereason.suspicions_process.element_values.children.element_values.has_malops                   |                         | boolean          |
  | cybereason.suspicions_process.element_values.children.element_values.has_suspicions               |                         | boolean          |
  | cybereason.suspicions_process.element_values.children.element_values.name                         |                         | keyword          |
  | cybereason.suspicions_process.element_values.children.element_values.object                       |                         | flattened        |
  | cybereason.suspicions_process.element_values.children.element_values.simple_values                |                         | flattened        |
  | cybereason.suspicions_process.element_values.children.guessed_total                               |                         | long             |
  | cybereason.suspicions_process.element_values.children.total_malicious                             |                         | long             |
  | cybereason.suspicions_process.element_values.children.total_suspicious                            |                         | long             |
  | cybereason.suspicions_process.element_values.children.total_values                                |                         | long             |
  | cybereason.suspicions_process.element_values.image_file.element_values.element_type               |                         | keyword          |
  | cybereason.suspicions_process.element_values.image_file.element_values.guid                       |                         | keyword          |
  | cybereason.suspicions_process.element_values.image_file.element_values.has_malops                 |                         | boolean          |
  | cybereason.suspicions_process.element_values.image_file.element_values.has_suspicions             |                         | boolean          |
  | cybereason.suspicions_process.element_values.image_file.element_values.name                       |                         | keyword          |
  | cybereason.suspicions_process.element_values.image_file.element_values.object                     |                         | flattened        |
  | cybereason.suspicions_process.element_values.image_file.element_values.simple_values              |                         | flattened        |
  | cybereason.suspicions_process.element_values.image_file.guessed_total                             |                         | long             |
  | cybereason.suspicions_process.element_values.image_file.total_malicious                           |                         | long             |
  | cybereason.suspicions_process.element_values.image_file.total_suspicious                          |                         | long             |
  | cybereason.suspicions_process.element_values.image_file.total_values                              |                         | long             |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.element_type            |                         | keyword          |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.guid                    |                         | keyword          |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.has_malops              |                         | boolean          |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.has_suspicions          |                         | boolean          |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.name                    |                         | keyword          |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.object                  |                         | flattened        |
  | cybereason.suspicions_process.element_values.owner_machine.element_values.simple_values           |                         | flattened        |
  | cybereason.suspicions_process.element_values.owner_machine.guessed_total                          |                         | long             |
  | cybereason.suspicions_process.element_values.owner_machine.total_malicious                        |                         | long             |
  | cybereason.suspicions_process.element_values.owner_machine.total_suspicious                       |                         | long             |
  | cybereason.suspicions_process.element_values.owner_machine.total_values                           |                         | long             |
  | cybereason.suspicions_process.element_values.parent_process.element_values.element_type           |                         | keyword          |
  | cybereason.suspicions_process.element_values.parent_process.element_values.guid                   |                         | keyword          |
  | cybereason.suspicions_process.element_values.parent_process.element_values.has_malops             |                         | boolean          |
  | cybereason.suspicions_process.element_values.parent_process.element_values.has_suspicions         |                         | boolean          |
  | cybereason.suspicions_process.element_values.parent_process.element_values.name                   |                         | keyword          |
  | cybereason.suspicions_process.element_values.parent_process.element_values.object                 |                         | flattened        |
  | cybereason.suspicions_process.element_values.parent_process.element_values.simple_values          |                         | flattened        |
  | cybereason.suspicions_process.element_values.parent_process.guessed_total                         |                         | long             |
  | cybereason.suspicions_process.element_values.parent_process.total_malicious                       |                         | long             |
  | cybereason.suspicions_process.element_values.parent_process.total_suspicious                      |                         | long             |
  | cybereason.suspicions_process.element_values.parent_process.total_values                          |                         | long             |
  | cybereason.suspicions_process.evidence_map                                                        |                         | flattened        |
  | cybereason.suspicions_process.filter_data.group_by_value                                          |                         | keyword          |
  | cybereason.suspicions_process.filter_data.sort_in_group_value                                     |                         | keyword          |
  | cybereason.suspicions_process.guid_string                                                         |                         | keyword          |
  | cybereason.suspicions_process.is_malicious                                                        |                         | boolean          |
  | cybereason.suspicions_process.labels_ids                                                          |                         | keyword          |
  | cybereason.suspicions_process.malicious                                                           |                         | boolean          |
  | cybereason.suspicions_process.malop_priority                                                      |                         | keyword          |
  | cybereason.suspicions_process.simple_values.command_line.total_values                             |                         | long             |
  | cybereason.suspicions_process.simple_values.command_line.values                                   |                         | keyword          |
  | cybereason.suspicions_process.simple_values.creation_time.total_values                            |                         | long             |
  | cybereason.suspicions_process.simple_values.creation_time.values                                  |                         | date             |
  | cybereason.suspicions_process.simple_values.element_display_name.total_values                     |                         | long             |
  | cybereason.suspicions_process.simple_values.element_display_name.values                           |                         | keyword          |
  | cybereason.suspicions_process.simple_values.end_time.total_values                                 |                         | long             |
  | cybereason.suspicions_process.simple_values.end_time.values                                       |                         | date             |
  | cybereason.suspicions_process.simple_values.execution_prevented.total_values                      |                         | long             |
  | cybereason.suspicions_process.simple_values.execution_prevented.values                            |                         | boolean          |
  | cybereason.suspicions_process.simple_values.group.total_values                                    |                         | long             |
  | cybereason.suspicions_process.simple_values.group.values                                          |                         | keyword          |
  | cybereason.suspicions_process.simple_values.icon_base64.total_values                              |                         | long             |
  | cybereason.suspicions_process.simple_values.icon_base64.values                                    |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_company_name.total_values                  |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_company_name.values                        |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_hash_icon_base64.total_values              |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_hash_icon_base64.values                    |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_malicious_classification_type.total_values |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_malicious_classification_type.values       |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_md5_string.total_values                    |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_md5_string.values                          |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_product_name.total_values                  |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_product_name.values                        |                         | keyword          |
  | cybereason.suspicions_process.simple_values.image_file_sha1_string.total_values                   |                         | long             |
  | cybereason.suspicions_process.simple_values.image_file_sha1_string.values                         |                         | keyword          |
  | cybereason.suspicions_process.simple_values.is_image_file_signed_and_verified.total_values        |                         | long             |
  | cybereason.suspicions_process.simple_values.is_image_file_signed_and_verified.values              |                         | boolean          |
  | cybereason.suspicions_process.simple_values.is_white_list_classification.total_values             |                         | long             |
  | cybereason.suspicions_process.simple_values.is_white_list_classification.values                   |                         | boolean          |
  | cybereason.suspicions_process.simple_values.product_type.total_values                             |                         | long             |
  | cybereason.suspicions_process.simple_values.product_type.values                                   |                         | keyword          |
  | cybereason.suspicions_process.simple_values.ransomware_auto_remediation_suspended.total_values    |                         | long             |
  | cybereason.suspicions_process.simple_values.ransomware_auto_remediation_suspended.values          |                         | boolean          |
  | cybereason.suspicions_process.suspect                                                             |                         | boolean          |
  | cybereason.suspicions_process.suspicion_count                                                     |                         | long             |
  | cybereason.suspicions_process.suspicions                                                          |                         | flattened        |
  | cybereason.suspicions_process.suspicions_map                                                      |                         | flattened        |
  | data_stream.dataset                                                                               | Data stream dataset.    | constant_keyword |
  | data_stream.namespace                                                                             | Data stream namespace.  | constant_keyword |
  | data_stream.type                                                                                  | Data stream type.       | constant_keyword |
  | event.dataset                                                                                     | Event dataset.          | constant_keyword |
  | event.module                                                                                      | Event module.           | constant_keyword |
  | input.type                                                                                        | Type of filebeat input. | keyword          |
  | log.offset                                                                                        | Log offset.             | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Cybereason Logon Session Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-logon-session-dashboard.png)

  ![Cybereason Malop Connection Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-malop-connection-dashboard.png)

  ![Cybereason Malop Process Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-malop-process-dashboard.png)

  ![Cybereason Malware Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-malware-dashboard.png)

  ![Cybereason Poll Malop Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-poll-malop-dashboard.png)

  ![Cybereason Suspicions Process Dashboard](https://epr.elastic.co/package/cybereason/1.4.1/img/cybereason-suspicions-process-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                       | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17017))Increase character limit for `cybereason.suspicions_process.simple_values.icon_base64.values`, `cybereason.suspicions_process.simple_values.image_file_hash_icon_base64.values` and `cybereason.malop_process.simple_values.icon_base64.values` to 4096. | 9.0.08.13.0            |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13573))Remove redundant installation instructions.                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                           | 9.0.08.13.0            |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                     | 8.13.0                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                                                   | 8.13.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                            | 8.13.0                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11210))Release package as GA.                                                                                                                                                                                                                               | 8.13.0                 |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                             |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                         |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9595))Initial release.                                                                                                                                                                                                                                      |                        |
</dropdown>