﻿---
title: CrowdStrike Integration
description: The CrowdStrike integration allows you to easily connect your CrowdStrike Falcon platform to Elastic for seamless onboarding of alerts and telemetry from...
url: https://www.elastic.co/docs/reference/integrations/crowdstrike
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# CrowdStrike Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.3.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, AWS S3, File              |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                    |

The [CrowdStrike](https://www.crowdstrike.com/) integration allows you to easily connect your CrowdStrike Falcon platform to Elastic for seamless onboarding of alerts and telemetry from CrowdStrike Falcon and Falcon Data Replicator. Elastic Security can leverage this data for security analytics including correlation, visualization and incident response. It provides support using four different modes for integrating CrowdStrike to the Elastic:
1. **Falcon SIEM Connector**: This is a pre-built integration designed to connect CrowdStrike Falcon with Security Information and Event Management (SIEM) systems. It streamlines the flow of security data from CrowdStrike Falcon to the SIEM, providing a standardized and structured way of feeding information into the SIEM platform. It includes the following datasets for receiving logs:

- `falcon` dataset: consists of endpoint data and Falcon platform audit data forwarded from Falcon SIEM Connector.
  **Log File Format and Location**
  The CrowdStrike integration only supports JSON output format from the SIEM Connector.
  - Log files are written to multiple rotated output files based on the `output_path` setting in the `cs.falconhoseclient.cfg` file.
- The default output location for the Falcon SIEM Connector is `/var/log/crowdstrike/falconhoseclient/output`.
- By default, files named `output*` in `/var/log/crowdstrike/falconhoseclient` directory contain valid JSON event data and should be used as the source for ingestion.
  <note>
  Files with names like `cs.falconhoseclient-*.log` in the same directory are primarily used for logging internal operations of the Falcon SIEM Connector and are not intended to be consumed by this integration.
  </note>

1. **CrowdStrike REST API**: This provides a programmatic interface to interact with the CrowdStrike Falcon platform. It allows users to perform various operations such as querying information about unified alerts and hosts/devices. It includes the following datasets for receiving logs:

- `alert` dataset: It is typically used to retrieve detailed information about unified alerts generated by the CrowdStrike Falcon platform, via Falcon Intelligence Alert API - `/alerts/combined/alerts/v1`.
- `host` dataset: It retrieves all the hosts/devices in your environment providing information such as device metadata, configuration, and status generated by the CrowdStrike Falcon platform, via Falcon Intelligence Host/Device API - `/devices/combined/devices/v1`. For GovCloud CIDs it uses `/devices/queries/devices/v1` and `/devices/entities/devices/v2` endpoints. It is more focused to provide the management and monitoring information of devices such as login details, status, policies, configuration etc.
  <note>
  GovCloud CID users must enable the GovCloud option in the integration configuration to query the `/devices/queries/devices/v1` endpoint instead of the unsupported `/devices/combined/devices/v1` endpoint.
  </note>
- `vulnerability` dataset: It retrieves all the vulnerabilities in your environment, providing information such as severity, status, confidence levels, remediation guidance, and affected hosts, as detected by the CrowdStrike Falcon platform, via the Falcon Spotlight Vulnerability API - `/spotlight/combined/vulnerabilities/v1`.

1. **Falcon Data Replicator**: This collects events from your endpoints, cloud workloads, identities, and data. CrowdStrike Falcon Data Replicator (FDR) enables you with actionable insights to improve SOC performance. FDR contains data collected by the Falcon platform's single, lightweight agent. It includes the following datasets for receiving logs:

- `fdr` dataset: consists of logs forwarded using the [Falcon Data Replicator](https://github.com/CrowdStrike/FDR). In addition to the existing log types, the integration supports parsing of Cloud Security Posture Management (CSPM). CSPM contains Indicators of Misconfiguration (IOM) and Indicators of Attack (IOA) events.

1. **CrowdStrike Event Stream**: This streams security logs from CrowdStrike Event Stream, including authentication activity, cloud security posture management (CSPM), firewall logs, user activity, and XDR data. It captures real-time security events like user logins, cloud environment changes, network traffic, and advanced threat detections. The streaming integration provides continuous monitoring and analysis for proactive threat detection. It enhances visibility into user behavior, network security, and overall system health. This setup enables faster response capabilities to emerging security incidents. It includes the following datasets for receiving logs:

- `falcon` dataset: consists of streaming data forwarded from CrowdStrike Event Stream.


## Compatibility

This integration is compatible with CrowdStrike Falcon SIEM-Connector-v2.0, REST API, and CrowdStrike Event Streaming.
For Rest API support, this module has been tested against the **CrowdStrike API Version v1/v2**.

## Requirements


### Agentless enabled integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
You can install only one Elastic Agent per host.
Elastic Agent is required to stream data from the GCP Pub/Sub or REST API and ship the data to Elastic, where the events will then be processed via the integration's ingest pipelines.

## Setup


### Collect data from CrowdStrike REST API

The following parameters from your CrowdStrike instance are required:
1. Client ID
2. Client Secret
3. Token url
4. API Endpoint url
5. Required scopes for each data stream :
   | Data Stream   | Scope              |
   |---------------|--------------------|
   | Alert         | read:alert         |
   | Host          | read:host          |
   | Vulnerability | read:vulnerability |


### Collect data from CrowdStrike Event Stream

The following parameters from your CrowdStrike instance are required:
1. Client ID
2. Client Secret
3. Token URL
4. API Endpoint URL
5. CrowdStrike App ID
6. Required scopes for event stream:
   | Data Stream  | Scope               |
   |--------------|---------------------|
   | Event Stream | read: Event streams |


## Logs


### Alert

This is the `Alert` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-11-03T18:00:22.328Z",
      "agent": {
          "ephemeral_id": "efb69ba7-0736-4cf7-a39f-70f3183e7530",
          "id": "d541c008-3558-403d-9392-4faa6d42fcb4",
          "name": "elastic-agent-43429",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "crowdstrike": {
          "alert": {
              "agent_id": "2ce412d17b334ad4adc8c1c54dbfec4b",
              "aggregate_id": "aggind:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778",
              "alleged_filetype": "exe",
              "cid": "92012896127c4a948236ba7601b886b0",
              "cloud_indicator": false,
              "cmdline": "\"C:\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\"",
              "composite_id": "92012896127c4a8236ba7601b886b0:ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
              "confidence": 10,
              "context_timestamp": "2023-11-03T18:00:31.000Z",
              "control_graph_id": "ctg:2ce4127b334ad4adc8c1c54dbfec4b:163208931778",
              "crawl_edge_ids": {
                  "Sensor": [
                      "KZcZ=__;K&cmqQ]Z=W,QK4W.9(rBfs\\gfmjTblqI^F-_oNnAWQ&-o0:dR/>>2J<d2T/ji6R&RIHe-tZSkP*q?HW;:leq.:kk)>IVMD36[+=kiQDRm.bB?;d\"V0JaQlaltC59Iq6nM?6>ZAs+LbOJ9p9A;9'WV9^H3XEMs8N",
                      "KZcZA__;?\"cmott@m_k)MSZ^+C?.cg<Lga#0@71X07*LY2teE56*16pL[=!bjF7g@0jOQE'jT6RX_F@sr#RP-U/d[#nm9A,A,W%cl/T@<WalY1K_h%QDBBF;_e7S!!*'!",
                      "KZd)iK2;s\\ckQl_P*d=Mo?^a7/JKc\\*L48169!7I5;0\\<H^hNG\"ZQ3#U3\"eo<>92t[f!>*b9WLY@H!V0N,BJsNSTD:?/+fY';e<OHh9AmlT?5<gGqK:*L99kat+P)eZ$HR\"Ql@Q!!!$!rr",
                      "N6=Ks_B9Bncmur)?\\[fV$k/N5;:6@aB$P;R$2XAaPJ?E<G5,UfaP')8#2AY4ff+q?T?b0/RBi-YAeGmb<6Bqp[DZh#I(jObGkjJJaMf\\:#mb;BM\\L[g!\\F*M!!*'!",
                      "N6B%O'=_7d#%u&d[+LTNDs<3307?8n=GrFI:4YYGCL,cIt-Tuj!&<6:3RbCuNjL#gW&=)E4^/'fp*.bFX@p_$,R6.\"=lV*T*5Vfc.:nkd$+YD:DJ,Ls0[sArC')K%YTc$:@kUQW5s8N",
                      "N6B%s!\\k)ed$F6>a%iM\"<FTSe/eH8M:<9gf;$$.b??kpC*99aX!Lq:g6:Q3@Ga4Zrb@MaMa]L'YAt$IFBu])\"H^sF$r7gDPf6&CHpVKO3<DgK9,Y/e@V\"b&m!<<'",
                      "N6CU&%VT\"d$=67=h\\I)/BJH:8-lS!.%\\-!$1@bAhtVO?q4]9'9'haE4N0*-0Uh'-'f',YW3]T=jL3D#N=fJi]Pp-bWej+R9q[%h[p]p26NK8q3b50k9G:.&eM<Qer>__\"59K'R?_='rK/'hA\"r+L5i-*Ut5PI!!*'!",
                      "N6CUF__;K!d$:[C93.?=/5(5KnM]!L#UbnSY5HOHc#[6A&FE;(naXB4h/OG\"%MDAR=fo41Z]rXc\"J-\\&&V8UW.?I6V*G+,))Ztu_IuCMV#ZJ:QDJ_EjQmjiX#HENY'WD0rVAV$Gl6_+0e:2$8D)):.LUs+8-S$L!!!$!rr",
                      "N6CUF__;K!d$:\\N43JV0AO56@6D0$!na(s)d.dQ'iI1*uiKt#j?r\"X'\\AtNML2_C__7ic6,8Dc[F<0NTUGtl%HD#?/Y)t8!1X.;G!*FQ9GP-ukQn6I##&$^81(P+hN*-#rf/cUs)Wb\"<_/?I'[##WMh'H[Rcl+!!<<'",
                      "N6L[G__;K!d\"qhT7k?[D\"Bk:5s%+=>#DM0j$_<r/JG0TCEQ!Ug(be3)&R2JnX+RSqorgC-NCjf6XATBWX(5<L1J1DV>44ZjO9q*d!YLuHhkq!3>3tpi>OPYZp9]5f1#/AlRZL06/I6cl\"d.&=To@9kS!prs8N"
                  ]
              },
              "crawl_vertex_ids": {
                  "Sensor": [
                      "aggind:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778",
                      "ctg:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778",
                      "ind:2ce412d17b34ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
                      "mod:2ce412d17b4ad4adc8c1c54dbfec4b:0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4",
                      "mod:2ce412d17b4ad4adc8c1c54dbfec4b:b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "mod:2ce412d17b334ad4adc8c1c54dbfec4b:caef4ae19056eeb122a0540508fa8984cea960173ada0dc648cb846d6ef5dd33",
                      "pid:2ce412d17b33d4adc8c1c54dbfec4b:392734873135",
                      "pid:2ce412d17b334ad4adc8c1c54dbfec4b:392736520876",
                      "pid:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993",
                      "quf:2ce412d17b334ad4adc8c1c54dbfec4b:b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425"
                  ]
              },
              "crawled_timestamp": "2023-11-03T19:00:23.985Z",
              "created_timestamp": "2023-11-03T18:01:23.995Z",
              "data_domains": [
                  "Endpoint"
              ],
              "description": "ThisfilemeetstheAdware/PUPAnti-malwareMLalgorithm'slowest-confidencethreshold.",
              "device": {
                  "agent_load_flags": 0,
                  "agent_local_time": "2023-10-12T03:45:57.753Z",
                  "agent_version": "7.04.17605.0",
                  "bios_manufacturer": "ABC",
                  "bios_version": "F8CN42WW(V2.05)",
                  "cid": "92012896127c4a948236ba7601b886b0",
                  "config_id_base": "65994763",
                  "config_id_build": "17605",
                  "config_id_platform": 3,
                  "external_ip": "81.2.69.142",
                  "first_seen": "2023-04-07T09:36:36.000Z",
                  "groups": [
                      "18704e21288243b58e4c76266d38caaf"
                  ],
                  "hostinfo": {
                      "active_directory_dn_display": [
                          "WinComputers",
                          "WinComputers\\ABC"
                      ],
                      "domain": "ABC.LOCAL"
                  },
                  "hostname": "ABC709-1175",
                  "id": "2ce412d17b334ad4adc8c1c54dbfec4b",
                  "last_seen": "2023-11-03T17:51:42.000Z",
                  "local_ip": "81.2.69.142",
                  "mac_address": "AB-21-48-61-05-B2",
                  "machine_domain": "ABC.LOCAL",
                  "major_version": "10",
                  "minor_version": "0",
                  "modified_timestamp": "2023-11-03T17:53:43.000Z",
                  "os_version": "Windows11",
                  "ou": [
                      "ABC",
                      "WinComputers"
                  ],
                  "platform_id": "0",
                  "platform_name": "Windows",
                  "product_type": "1",
                  "product_type_desc": "Workstation",
                  "site_name": "Default-First-Site-Name",
                  "status": "normal",
                  "system_manufacturer": "LENOVO",
                  "system_product_name": "20VE"
              },
              "falcon_host_link": "https://falcon.us-2.crowdstrike.com/activity-v2/detections/dhjffg:ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
              "filename": "openvpn-abc-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
              "filepath": "\\Device\\HarddiskVolume3\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
              "grandparent_details": {
                  "cmdline": "C:\\Windows\\system32\\userinit.exe",
                  "filename": "userinit.exe",
                  "filepath": "\\Device\\HarddiskVolume3\\Windows\\System32\\userinit.exe",
                  "local_process_id": "4328",
                  "md5": "b07f77fd3f9828b2c9d61f8a36609741",
                  "process_graph_id": "pid:2ce412d17b334ad4adc8c1c54dbfec4b:392734873135",
                  "process_id": "392734873135",
                  "sha256": "caef4ae19056eeb122a0540508fa8984cea960173ada0dc648cb846d6ef5dd33",
                  "timestamp": "2023-10-30T16:49:19.000Z",
                  "user_graph_id": "uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425",
                  "user_id": "S-1-5-21-1909377054-3469629671-4104191496-4425",
                  "user_name": "yuvraj.mahajan"
              },
              "has_script_or_module_ioc": true,
              "id": "ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
              "indicator_id": "ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
              "ioc_context": [
                  {
                      "ioc_description": "\\Device\\HarddiskVolume3\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
                      "ioc_source": "library_load",
                      "ioc_type": "hash_sha256",
                      "ioc_value": "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "md5": "cdf9cfebb400ce89d5b6032bfcdc693b",
                      "sha256": "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "type": "module"
                  }
              ],
              "ioc_values": [
                  "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd"
              ],
              "is_synthetic_quarantine_disposition": true,
              "local_process_id": "17076",
              "logon_domain": "ABSYS",
              "md5": "cdf9cfebb400ce89d5b6032bfcdc693b",
              "name": "PrewittPupAdwareSensorDetect-Lowest",
              "objective": "FalconDetectionMethod",
              "parent_details": {
                  "cmdline": "C:\\WINDOWS\\Explorer.EXE",
                  "filename": "explorer.exe",
                  "filepath": "\\Device\\HarddiskVolume3\\Windows\\explorer.exe",
                  "local_process_id": "1040",
                  "md5": "8cc3fcdd7d52d2d5221303c213e044ae",
                  "process_graph_id": "pid:2ce412d17b334ad4adc8c1c54dbfec4b:392736520876",
                  "process_id": "392736520876",
                  "sha256": "0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4",
                  "timestamp": "2023-11-03T18:00:32.000Z",
                  "user_graph_id": "uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425",
                  "user_id": "S-1-5-21-1909377054-3469629671-4104191496-4425",
                  "user_name": "mohit.jha"
              },
              "parent_process_id": "392736520876",
              "pattern_disposition": 2176,
              "pattern_disposition_description": "Prevention/Quarantine,processwasblockedfromexecutionandquarantinewasattempted.",
              "pattern_disposition_details": {
                  "blocking_unsupported_or_disabled": false,
                  "bootup_safeguard_enabled": false,
                  "critical_process_disabled": false,
                  "detect": false,
                  "fs_operation_blocked": false,
                  "handle_operation_downgraded": false,
                  "inddet_mask": false,
                  "indicator": false,
                  "kill_action_failed": false,
                  "kill_parent": false,
                  "kill_process": false,
                  "kill_subprocess": false,
                  "operation_blocked": false,
                  "policy_disabled": false,
                  "process_blocked": true,
                  "quarantine_file": true,
                  "quarantine_machine": false,
                  "registry_operation_blocked": false,
                  "rooting": false,
                  "sensor_only": false,
                  "suspend_parent": false,
                  "suspend_process": false
              },
              "pattern_id": "5761",
              "platform": "Windows",
              "poly_id": "AACSASiWEnxKlIIaw8LWC-8XINBatE2uYZaWqRAAATiEEfPFwhoY4opnh1CQjm0tvUQp4Lu5eOAx29ZVj-qrGrA==",
              "process_end_time": "2023-11-03T18:00:21.000Z",
              "process_id": "399748687993",
              "process_start_time": "2023-11-03T18:00:13.000Z",
              "product": "epp",
              "quarantined_files": [
                  {
                      "filename": "\\Device\\Volume3\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
                      "id": "2ce412d17b334ad4adc8c1c54dbfec4b_b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "sha256": "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
                      "state": "quarantined"
                  }
              ],
              "scenario": "NGAV",
              "severity": 30,
              "severity_name": "low",
              "sha1": "0000000000000000000000000000000000000000",
              "sha256": "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
              "show_in_ui": true,
              "source_products": [
                  "FalconInsight"
              ],
              "source_vendors": [
                  "CrowdStrike"
              ],
              "status": "new",
              "tactic": "MachineLearning",
              "tactic_id": "CSTA0004",
              "technique": "Adware/PUP",
              "technique_id": "CST0000",
              "timestamp": "2023-11-03T18:00:22.328Z",
              "tree_id": "1931778",
              "tree_root": "38687993",
              "triggering_process_graph_id": "pid:2ce4124ad4adc8c1c54dbfec4b:399748687993",
              "type": "ldt",
              "updated_timestamp": "2023-11-03T19:00:23.985Z",
              "user_id": "S-1-5-21-1909377054-3469629671-4104191496-4425",
              "user_name": "mohit.jha"
          }
      },
      "data_stream": {
          "dataset": "crowdstrike.alert",
          "namespace": "96581",
          "type": "logs"
      },
      "device": {
          "id": "2ce412d17b334ad4adc8c1c54dbfec4b",
          "manufacturer": "LENOVO",
          "model": {
              "name": "20VE"
          }
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "d541c008-3558-403d-9392-4faa6d42fcb4",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "process"
          ],
          "dataset": "crowdstrike.alert",
          "id": "ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600",
          "ingested": "2025-10-09T10:20:29Z",
          "kind": "alert",
          "original": "{\"agent_id\":\"2ce412d17b334ad4adc8c1c54dbfec4b\",\"aggregate_id\":\"aggind:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778\",\"alleged_filetype\":\"exe\",\"cid\":\"92012896127c4a948236ba7601b886b0\",\"cloud_indicator\":\"false\",\"cmdline\":\"\\\"C:\\\\Users\\\\yuvraj.mahajan\\\\AppData\\\\Local\\\\Temp\\\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\\\pfSenseFirewallOpenVPNClients\\\\Windows\\\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\\\"\",\"composite_id\":\"92012896127c4a8236ba7601b886b0:ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600\",\"confidence\":10,\"context_timestamp\":\"2023-11-03T18:00:31Z\",\"control_graph_id\":\"ctg:2ce4127b334ad4adc8c1c54dbfec4b:163208931778\",\"crawl_edge_ids\":{\"Sensor\":[\"KZcZ=__;K\\u0026cmqQ]Z=W,QK4W.9(rBfs\\\\gfmjTblqI^F-_oNnAWQ\\u0026-o0:dR/\\u003e\\u003e2J\\u003cd2T/ji6R\\u0026RIHe-tZSkP*q?HW;:leq.:kk)\\u003eIVMD36[+=kiQDRm.bB?;d\\\"V0JaQlaltC59Iq6nM?6\\u003eZAs+LbOJ9p9A;9'WV9^H3XEMs8N\",\"KZcZA__;?\\\"cmott@m_k)MSZ^+C?.cg\\u003cLga#0@71X07*LY2teE56*16pL[=!bjF7g@0jOQE'jT6RX_F@sr#RP-U/d[#nm9A,A,W%cl/T@\\u003cWalY1K_h%QDBBF;_e7S!!*'!\",\"KZd)iK2;s\\\\ckQl_P*d=Mo?^a7/JKc\\\\*L48169!7I5;0\\\\\\u003cH^hNG\\\"ZQ3#U3\\\"eo\\u003c\\u003e92t[f!\\u003e*b9WLY@H!V0N,BJsNSTD:?/+fY';e\\u003cOHh9AmlT?5\\u003cgGqK:*L99kat+P)eZ$HR\\\"Ql@Q!!!$!rr\",\"N6=Ks_B9Bncmur)?\\\\[fV$k/N5;:6@aB$P;R$2XAaPJ?E\\u003cG5,UfaP')8#2AY4ff+q?T?b0/RBi-YAeGmb\\u003c6Bqp[DZh#I(jObGkjJJaMf\\\\:#mb;BM\\\\L[g!\\\\F*M!!*'!\",\"N6B%O'=_7d#%u\\u0026d[+LTNDs\\u003c3307?8n=GrFI:4YYGCL,cIt-Tuj!\\u0026\\u003c6:3RbCuNjL#gW\\u0026=)E4^/'fp*.bFX@p_$,R6.\\\"=lV*T*5Vfc.:nkd$+YD:DJ,Ls0[sArC')K%YTc$:@kUQW5s8N\",\"N6B%s!\\\\k)ed$F6\\u003ea%iM\\\"\\u003cFTSe/eH8M:\\u003c9gf;$$.b??kpC*99aX!Lq:g6:Q3@Ga4Zrb@MaMa]L'YAt$IFBu])\\\"H^sF$r7gDPf6\\u0026CHpVKO3\\u003cDgK9,Y/e@V\\\"b\\u0026m!\\u003c\\u003c'\",\"N6CU\\u0026%VT\\\"d$=67=h\\\\I)/BJH:8-lS!.%\\\\-!$1@bAhtVO?q4]9'9'haE4N0*-0Uh'-'f',YW3]T=jL3D#N=fJi]Pp-bWej+R9q[%h[p]p26NK8q3b50k9G:.\\u0026eM\\u003cQer\\u003e__\\\"59K'R?_='rK/'hA\\\"r+L5i-*Ut5PI!!*'!\",\"N6CUF__;K!d$:[C93.?=/5(5KnM]!L#UbnSY5HOHc#[6A\\u0026FE;(naXB4h/OG\\\"%MDAR=fo41Z]rXc\\\"J-\\\\\\u0026\\u0026V8UW.?I6V*G+,))Ztu_IuCMV#ZJ:QDJ_EjQmjiX#HENY'WD0rVAV$Gl6_+0e:2$8D)):.LUs+8-S$L!!!$!rr\",\"N6CUF__;K!d$:\\\\N43JV0AO56@6D0$!na(s)d.dQ'iI1*uiKt#j?r\\\"X'\\\\AtNML2_C__7ic6,8Dc[F\\u003c0NTUGtl%HD#?/Y)t8!1X.;G!*FQ9GP-ukQn6I##\\u0026$^81(P+hN*-#rf/cUs)Wb\\\"\\u003c_/?I'[##WMh'H[Rcl+!!\\u003c\\u003c'\",\"N6L[G__;K!d\\\"qhT7k?[D\\\"Bk:5s%+=\\u003e#DM0j$_\\u003cr/JG0TCEQ!Ug(be3)\\u0026R2JnX+RSqorgC-NCjf6XATBWX(5\\u003cL1J1DV\\u003e44ZjO9q*d!YLuHhkq!3\\u003e3tpi\\u003eOPYZp9]5f1#/AlRZL06/I6cl\\\"d.\\u0026=To@9kS!prs8N\"]},\"crawl_vertex_ids\":{\"Sensor\":[\"aggind:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778\",\"ctg:2ce412d17b334ad4adc8c1c54dbfec4b:163208931778\",\"ind:2ce412d17b34ad4adc8c1c54dbfec4b:399748687993-5761-42627600\",\"mod:2ce412d17b4ad4adc8c1c54dbfec4b:0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4\",\"mod:2ce412d17b4ad4adc8c1c54dbfec4b:b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"mod:2ce412d17b334ad4adc8c1c54dbfec4b:caef4ae19056eeb122a0540508fa8984cea960173ada0dc648cb846d6ef5dd33\",\"pid:2ce412d17b33d4adc8c1c54dbfec4b:392734873135\",\"pid:2ce412d17b334ad4adc8c1c54dbfec4b:392736520876\",\"pid:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993\",\"quf:2ce412d17b334ad4adc8c1c54dbfec4b:b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425\"]},\"crawled_timestamp\":\"2023-11-03T19:00:23.985020992Z\",\"created_timestamp\":\"2023-11-03T18:01:23.995794943Z\",\"data_domains\":[\"Endpoint\"],\"description\":\"ThisfilemeetstheAdware/PUPAnti-malwareMLalgorithm'slowest-confidencethreshold.\",\"device\":{\"agent_load_flags\":\"0\",\"agent_local_time\":\"2023-10-12T03:45:57.753Z\",\"agent_version\":\"7.04.17605.0\",\"bios_manufacturer\":\"ABC\",\"bios_version\":\"F8CN42WW(V2.05)\",\"cid\":\"92012896127c4a948236ba7601b886b0\",\"config_id_base\":\"65994763\",\"config_id_build\":\"17605\",\"config_id_platform\":\"3\",\"device_id\":\"2ce412d17b334ad4adc8c1c54dbfec4b\",\"external_ip\":\"81.2.69.142\",\"first_seen\":\"2023-04-07T09:36:36Z\",\"groups\":[\"18704e21288243b58e4c76266d38caaf\"],\"hostinfo\":{\"active_directory_dn_display\":[\"WinComputers\",\"WinComputers\\\\ABC\"],\"domain\":\"ABC.LOCAL\"},\"hostname\":\"ABC709-1175\",\"last_seen\":\"2023-11-03T17:51:42Z\",\"local_ip\":\"81.2.69.142\",\"mac_address\":\"ab-21-48-61-05-b2\",\"machine_domain\":\"ABC.LOCAL\",\"major_version\":\"10\",\"minor_version\":\"0\",\"modified_timestamp\":\"2023-11-03T17:53:43Z\",\"os_version\":\"Windows11\",\"ou\":[\"ABC\",\"WinComputers\"],\"platform_id\":\"0\",\"platform_name\":\"Windows\",\"pod_labels\":null,\"product_type\":\"1\",\"product_type_desc\":\"Workstation\",\"site_name\":\"Default-First-Site-Name\",\"status\":\"normal\",\"system_manufacturer\":\"LENOVO\",\"system_product_name\":\"20VE\"},\"falcon_host_link\":\"https://falcon.us-2.crowdstrike.com/activity-v2/detections/dhjffg:ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600\",\"filename\":\"openvpn-abc-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\",\"filepath\":\"\\\\Device\\\\HarddiskVolume3\\\\Users\\\\yuvraj.mahajan\\\\AppData\\\\Local\\\\Temp\\\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\\\pfSenseFirewallOpenVPNClients\\\\Windows\\\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\",\"grandparent_details\":{\"cmdline\":\"C:\\\\Windows\\\\system32\\\\userinit.exe\",\"filename\":\"userinit.exe\",\"filepath\":\"\\\\Device\\\\HarddiskVolume3\\\\Windows\\\\System32\\\\userinit.exe\",\"local_process_id\":\"4328\",\"md5\":\"b07f77fd3f9828b2c9d61f8a36609741\",\"process_graph_id\":\"pid:2ce412d17b334ad4adc8c1c54dbfec4b:392734873135\",\"process_id\":\"392734873135\",\"sha256\":\"caef4ae19056eeb122a0540508fa8984cea960173ada0dc648cb846d6ef5dd33\",\"timestamp\":\"2023-10-30T16:49:19Z\",\"user_graph_id\":\"uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425\",\"user_id\":\"S-1-5-21-1909377054-3469629671-4104191496-4425\",\"user_name\":\"yuvraj.mahajan\"},\"has_script_or_module_ioc\":\"true\",\"id\":\"ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600\",\"indicator_id\":\"ind:2ce412d17b334ad4adc8c1c54dbfec4b:399748687993-5761-42627600\",\"ioc_context\":[{\"ioc_description\":\"\\\\Device\\\\HarddiskVolume3\\\\Users\\\\yuvraj.mahajan\\\\AppData\\\\Local\\\\Temp\\\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\\\pfSenseFirewallOpenVPNClients\\\\Windows\\\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\",\"ioc_source\":\"library_load\",\"ioc_type\":\"hash_sha256\",\"ioc_value\":\"b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"md5\":\"cdf9cfebb400ce89d5b6032bfcdc693b\",\"sha256\":\"b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"type\":\"module\"}],\"ioc_values\":[],\"is_synthetic_quarantine_disposition\":true,\"local_process_id\":\"17076\",\"logon_domain\":\"ABSYS\",\"md5\":\"cdf9cfebb400ce89d5b6032bfcdc693b\",\"name\":\"PrewittPupAdwareSensorDetect-Lowest\",\"objective\":\"FalconDetectionMethod\",\"parent_details\":{\"cmdline\":\"C:\\\\WINDOWS\\\\Explorer.EXE\",\"filename\":\"explorer.exe\",\"filepath\":\"\\\\Device\\\\HarddiskVolume3\\\\Windows\\\\explorer.exe\",\"local_process_id\":\"1040\",\"md5\":\"8cc3fcdd7d52d2d5221303c213e044ae\",\"process_graph_id\":\"pid:2ce412d17b334ad4adc8c1c54dbfec4b:392736520876\",\"process_id\":\"392736520876\",\"sha256\":\"0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4\",\"timestamp\":\"2023-11-03T18:00:32Z\",\"user_graph_id\":\"uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425\",\"user_id\":\"S-1-5-21-1909377054-3469629671-4104191496-4425\",\"user_name\":\"mohit.jha\"},\"parent_process_id\":\"392736520876\",\"pattern_disposition\":2176,\"pattern_disposition_description\":\"Prevention/Quarantine,processwasblockedfromexecutionandquarantinewasattempted.\",\"pattern_disposition_details\":{\"blocking_unsupported_or_disabled\":false,\"bootup_safeguard_enabled\":false,\"critical_process_disabled\":false,\"detect\":false,\"fs_operation_blocked\":false,\"handle_operation_downgraded\":false,\"inddet_mask\":false,\"indicator\":false,\"kill_action_failed\":false,\"kill_parent\":false,\"kill_process\":false,\"kill_subprocess\":false,\"operation_blocked\":false,\"policy_disabled\":false,\"process_blocked\":true,\"quarantine_file\":true,\"quarantine_machine\":false,\"registry_operation_blocked\":false,\"rooting\":false,\"sensor_only\":false,\"suspend_parent\":false,\"suspend_process\":false},\"pattern_id\":5761,\"platform\":\"Windows\",\"poly_id\":\"AACSASiWEnxKlIIaw8LWC-8XINBatE2uYZaWqRAAATiEEfPFwhoY4opnh1CQjm0tvUQp4Lu5eOAx29ZVj-qrGrA==\",\"process_end_time\":\"1699034421\",\"process_id\":\"399748687993\",\"process_start_time\":\"1699034413\",\"product\":\"epp\",\"quarantined_files\":[{\"filename\":\"\\\\Device\\\\Volume3\\\\Users\\\\yuvraj.mahajan\\\\AppData\\\\Local\\\\Temp\\\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\\\pfSenseFirewallOpenVPNClients\\\\Windows\\\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe\",\"id\":\"2ce412d17b334ad4adc8c1c54dbfec4b_b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"sha256\":\"b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"state\":\"quarantined\"}],\"scenario\":\"NGAV\",\"severity\":30,\"sha1\":\"0000000000000000000000000000000000000000\",\"sha256\":\"b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd\",\"show_in_ui\":true,\"source_products\":[\"FalconInsight\"],\"source_vendors\":[\"CrowdStrike\"],\"status\":\"new\",\"tactic\":\"MachineLearning\",\"tactic_id\":\"CSTA0004\",\"technique\":\"Adware/PUP\",\"technique_id\":\"CST0000\",\"timestamp\":\"2023-11-03T18:00:22.328Z\",\"tree_id\":\"1931778\",\"tree_root\":\"38687993\",\"triggering_process_graph_id\":\"pid:2ce4124ad4adc8c1c54dbfec4b:399748687993\",\"type\":\"ldt\",\"updated_timestamp\":\"2023-11-03T19:00:23.985007341Z\",\"user_id\":\"S-1-5-21-1909377054-3469629671-4104191496-4425\",\"user_name\":\"mohit.jha\"}",
          "severity": 21,
          "type": [
              "start"
          ]
      },
      "file": {
          "name": "openvpn-abc-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
          "path": "\\Device\\HarddiskVolume3\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe"
      },
      "host": {
          "domain": "ABC.LOCAL",
          "hostname": "ABC709-1175",
          "id": "2ce412d17b334ad4adc8c1c54dbfec4b",
          "ip": [
              "81.2.69.142"
          ],
          "mac": [
              "AB-21-48-61-05-B2"
          ],
          "os": {
              "full": "Windows11",
              "platform": "Windows",
              "type": "windows"
          }
      },
      "input": {
          "type": "cel"
      },
      "message": "ThisfilemeetstheAdware/PUPAnti-malwareMLalgorithm'slowest-confidencethreshold.",
      "process": {
          "end": "2023-11-03T18:00:21.000Z",
          "entity_id": "399748687993",
          "executable": "\\Device\\HarddiskVolume3\\Users\\yuvraj.mahajan\\AppData\\Local\\Temp\\Temp3cc4c329-2896-461f-9dea-88009eb2e8fb_pfSenseFirewallOpenVPNClients-20230823T120504Z-001.zip\\pfSenseFirewallOpenVPNClients\\Windows\\openvpn-cds-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
          "hash": {
              "md5": "cdf9cfebb400ce89d5b6032bfcdc693b",
              "sha1": "0000000000000000000000000000000000000000",
              "sha256": "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd"
          },
          "name": "openvpn-abc-pfSense-UDP4-1194-pfsense-install-2.6.5-I001-amd64.exe",
          "parent": {
              "command_line": "C:\\WINDOWS\\Explorer.EXE",
              "entity_id": "392736520876",
              "executable": "\\Device\\HarddiskVolume3\\Windows\\explorer.exe",
              "hash": {
                  "md5": "8cc3fcdd7d52d2d5221303c213e044ae",
                  "sha256": "0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4"
              },
              "name": "explorer.exe",
              "pid": 392736520876
          },
          "pid": 399748687993,
          "start": "2023-11-03T18:00:13.000Z",
          "user": {
              "id": "S-1-5-21-1909377054-3469629671-4104191496-4425",
              "name": "mohit.jha"
          }
      },
      "related": {
          "hash": [
              "b07f77fd3f9828b2c9d61f8a36609741",
              "cdf9cfebb400ce89d5b6032bfcdc693b",
              "b26a6791b72753d2317efd5e1363d93fdd33e611c8b9e08a3b24ea4d755b81fd",
              "8cc3fcdd7d52d2d5221303c213e044ae",
              "0b25d56bd2b4d8a6df45beff7be165117fbf7ba6ba2c07744f039143866335e4",
              "0000000000000000000000000000000000000000"
          ],
          "hosts": [
              "ABC.LOCAL",
              "ABC709-1175"
          ],
          "ip": [
              "81.2.69.142"
          ],
          "user": [
              "uid:2ce412d17b334ad4adc8c1c54dbfec4b:S-1-5-21-1909377054-3469629671-4104191496-4425",
              "S-1-5-21-1909377054-3469629671-4104191496-4425",
              "yuvraj.mahajan",
              "mohit.jha"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "crowdstrike-alert"
      ],
      "threat": {
          "framework": "CrowdStrike Falcon Detections Framework",
          "tactic": {
              "id": [
                  "CSTA0004"
              ],
              "name": [
                  "MachineLearning"
              ]
          },
          "technique": {
              "id": [
                  "CST0000"
              ],
              "name": [
                  "Adware/PUP"
              ]
          }
      },
      "user": {
          "id": "S-1-5-21-1909377054-3469629671-4104191496-4425",
          "name": "mohit.jha"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                          | Description                                                                                                                                                                                                                                         | Type             |
  |--------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                     | Event timestamp.                                                                                                                                                                                                                                    | date             |
  | crowdstrike.alert.active_directory_authentication_method                       |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.activity.browser                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.activity.device                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.activity.id                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.activity.os                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.agent_id                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.agent_scan_id                                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.aggregate_id                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.alert_attributes                                             |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.alleged_filetype                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.assigned_to.name                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.assigned_to.uid                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.assigned_to.uuid                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.associated_files.filepath                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.associated_files.sha256                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.child_process_ids                                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.cid                                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.cloud_indicator                                              |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.cmdline                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.command_line                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.comment                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.composite_id                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.confidence                                                   |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.context_timestamp                                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.control_graph_id                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.crawl_edge_ids.Sensor                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.crawl_vertex_ids.Sensor                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.crawled_timestamp                                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.created_timestamp                                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.data_domains                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.description                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.detect_type                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.agent_load_flags                                      |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.device.agent_local_time                                      |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.device.agent_version                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.bios_manufacturer                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.bios_version                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.cid                                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.config_id_base                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.config_id_build                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.config_id_platform                                    |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.device.external_ip                                           |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.device.first_seen                                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.device.groups                                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.hostinfo.active_directory_dn_display                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.hostinfo.domain                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.hostname                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.id                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.last_seen                                             |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.device.local_ip                                              |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.device.mac_address                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.machine_domain                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.major_version                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.minor_version                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.modified_timestamp                                    |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.device.os_version                                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.ou                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.platform_id                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.platform_name                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.pod_labels                                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.product_type                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.product_type_desc                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.site_name                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.status                                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.system_manufacturer                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.system_product_name                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.device.tags                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.display_name                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.documents_accessed.filename                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.documents_accessed.filepath                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.documents_accessed.timestamp                                 |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.email_sent                                                   |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.end_time                                                     |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.event_id                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.executables_written.filename                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.executables_written.filepath                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.executables_written.timestamp                                |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.falcon_host_link                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.file_writes.name                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.file_writes.sha256                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.filename                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.filepath                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.files_accessed.filename                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.files_accessed.filepath                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.files_accessed.timestamp                                     |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.files_written.filename                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.files_written.filepath                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.files_written.timestamp                                      |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.global_prevalence                                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.cmdline                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.filename                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.filepath                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.local_process_id                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.md5                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.process_graph_id                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.process_id                               |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.sha256                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.timestamp                                |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.grandparent_details.user_graph_id                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.user_id                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.grandparent_details.user_name                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.has_script_or_module_ioc                                     |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.host_name                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.host_type                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.id                                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.idp_policy.enforced_externally                               |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.idp_policy.mfa_factor_type                                   |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.idp_policy.mfa_provider                                      |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.idp_policy.rule_action                                       |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.idp_policy.rule_id                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.idp_policy.rule_name                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.idp_policy.rule_trigger                                      |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.image_file_name                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.incident.created                                             |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.incident.end                                                 |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.incident.id                                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.incident.score                                               |                                                                                                                                                                                                                                                     | double           |
  | crowdstrike.alert.incident.start                                               |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.indicator_id                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.cmdline                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.ioc_description                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.ioc_source                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.ioc_type                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.ioc_value                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.md5                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.sha256                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_context.type                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_description                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_source                                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_type                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_value                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.ioc_values                                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.is_synthetic_quarantine_disposition                          |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.ldap_search_query_attack                                     |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.local_prevalence                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.local_process_id                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.location_country_code                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.location_latitude_as_int                                     |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.location_longitude_as_int                                    |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.logon_domain                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.md5                                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.model_anomaly_indicators                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.name                                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.network_accesses.access_timestamp                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.network_accesses.access_type                                 |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.network_accesses.connection_direction                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.network_accesses.isIPV6                                      |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.network_accesses.local_address                               |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.network_accesses.local_port                                  |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.network_accesses.protocol                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.network_accesses.remote_address                              |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.network_accesses.remote_port                                 |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.objective                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.operating_system                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.os_name                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.overwatch_note                                               |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.overwatch_note_timestamp                                     |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.parent_details.cmdline                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.filename                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.filepath                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.local_process_id                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.md5                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.process_graph_id                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.process_id                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.sha256                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.timestamp                                     |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.parent_details.user_graph_id                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.user_id                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_details.user_name                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.parent_process_id                                            |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.pattern_disposition                                          |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.pattern_disposition_description                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.pattern_disposition_details.blocking_unsupported_or_disabled |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.bootup_safeguard_enabled         |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.containment_file_system          |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.critical_process_disabled        |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.detect                           |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.fs_operation_blocked             |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.handle_operation_downgraded      |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.inddet_mask                      |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.indicator                        |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.kill_action_failed               |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.kill_parent                      |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.kill_process                     |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.kill_subprocess                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.mfa_required                     |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.operation_blocked                |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.policy_disabled                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.prevention_provisioning_enabled  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.process_blocked                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.quarantine_file                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.quarantine_machine               |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.registry_operation_blocked       |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.response_action_already_applied  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.response_action_failed           |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.response_action_triggered        |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.rooting                          |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.sensor_only                      |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.suspend_parent                   |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_disposition_details.suspend_process                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.pattern_id                                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.platform                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.poly_id                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.prevented                                                    |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.process_end_time                                             |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.process_id                                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.process_start_time                                           |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.product                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.protocol_anomaly_classification                              |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.quarantined                                                  |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.quarantined_files.filename                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.quarantined_files.id                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.quarantined_files.sha256                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.quarantined_files.state                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_group_id                                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_group_name                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_instance_created_by                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_instance_id                                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_instance_name                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.rule_instance_version                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.scan_id                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.scenario                                                     |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.seconds_to_resolved                                          |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.seconds_to_triaged                                           |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.severity                                                     |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.severity_name                                                |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.sha1                                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.sha256                                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.show_in_ui                                                   |                                                                                                                                                                                                                                                     | boolean          |
  | crowdstrike.alert.source.account_azure_id                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_domain                                        |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_name                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_object_guid                                   |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_object_sid                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_sam_account_name                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.account_upn                                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.endpoint_account_object_guid                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.endpoint_account_object_sid                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.endpoint_address_ip4                                  |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.source.endpoint_host_name                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.endpoint_ip_address                                   |                                                                                                                                                                                                                                                     | ip               |
  | crowdstrike.alert.source.endpoint_ip_reputation                                |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.source.endpoint_sensor_id                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source.ip_isp_classification                                 |                                                                                                                                                                                                                                                     | long             |
  | crowdstrike.alert.source.ip_isp_domain                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source_products                                              |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.source_vendors                                               |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.start_time                                                   |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.status                                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.tactic                                                       |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.tactic_id                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.tags                                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.account_name                                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.domain_controller_host_name                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.domain_controller_object_guid                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.domain_controller_object_sid                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.endpoint_account_object_guid                          |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.endpoint_account_object_sid                           |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.endpoint_host_name                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.endpoint_sensor_id                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.target.service_access_identifier                             |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.technique                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.technique_id                                                 |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.template_instance_id                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.timestamp                                                    |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.tree_id                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.tree_root                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.triggering_process_graph_id                                  |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.type                                                         |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.updated_timestamp                                            |                                                                                                                                                                                                                                                     | date             |
  | crowdstrike.alert.user_id                                                      |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.user_name                                                    |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.user_principal                                               |                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.alert.worker_node_name                                             |                                                                                                                                                                                                                                                     | keyword          |
  | data_stream.dataset                                                            | Data stream dataset.                                                                                                                                                                                                                                | constant_keyword |
  | data_stream.namespace                                                          | Data stream namespace.                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.type                                                               | Data stream type.                                                                                                                                                                                                                                   | constant_keyword |
  | event.dataset                                                                  | Event dataset.                                                                                                                                                                                                                                      | constant_keyword |
  | event.module                                                                   | Event module.                                                                                                                                                                                                                                       | constant_keyword |
  | input.type                                                                     | Type of filebeat input.                                                                                                                                                                                                                             | keyword          |
  | log.offset                                                                     | Log offset.                                                                                                                                                                                                                                         | long             |
  | tags                                                                           | List of keywords used to tag each event.                                                                                                                                                                                                            | keyword          |
  | threat.framework                                                               | Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events. | keyword          |
  | threat.tactic.id                                                               | The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex.  )                                                                                                                                                      | keyword          |
  | threat.technique.id                                                            | The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. )                                                                                                                                                 | keyword          |
</dropdown>


### Falcon

Contains endpoint data and CrowdStrike Falcon platform audit data forwarded from Falcon SIEM Connector.

#### Falcon SIEM Connector configuration file

By default, the configuration file located at `/opt/crowdstrike/etc/cs.falconhoseclient.cfg` provides configuration options related to the events collected by Falcon SIEM Connector.
Parts of the configuration file called `EventTypeCollection` and `EventSubTypeCollection` provides a list of event types that the connector should collect.
Current supported event types are:
- DataProtectionDetectionSummaryEvent
- DetectionSummaryEvent
- EppDetectionSummaryEvent
- IncidentSummaryEvent
- UserActivityAuditEvent
- AuthActivityAuditEvent
- FirewallMatchEvent
- RemoteResponseSessionStartEvent
- RemoteResponseSessionEndEvent
- CSPM Streaming events
- CSPM Search events
- IDP Incidents
- IDP Summary events
- Mobile Detection events
- Recon Notification events
- XDR Detection events
- Scheduled Report Notification events

<dropdown title="Exported fields">
  | Field                                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |-------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                              | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | agent.id                                                                | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | agent.name                                                              | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | agent.type                                                              | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | agent.version                                                           | Version of the agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.image.id                                                          | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.AccountCreationTimeStamp                              | The timestamp of when the source account was created in Active Directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | date             |
  | crowdstrike.event.AccountId                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ActivityId                                            | ID of the activity that triggered the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.AddedPrivilege                                        | The difference between their current and previous list of privileges.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.AdditionalAccountObjectGuid                           | Additional involved user object GUID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.AdditionalAccountObjectSid                            | Additional involved user object SID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.AdditionalAccountUpn                                  | Additional involved user UPN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.AdditionalActivityId                                  | ID of an additional activity related to the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.AdditionalEndpointAccountObjectGuid                   | Additional involved endpoint object GUID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.AdditionalEndpointAccountObjectSid                    | Additional involved endpoint object SID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.AdditionalEndpointSensorId                            | Additional involved endpoint agent ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.AdditionalLocationCountryCode                         | Additional involved country code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.AdditionalSsoApplicationIdentifier                    | Additional application identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.AgentId                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.AgentIdString                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.AggregateId                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.AnodeIndicators                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.event.AnomalousTicketContentClassification                  | Ticket signature analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | crowdstrike.event.AssociatedFile                                        | The file associated with the triggering indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.Attributes                                            | JSON objects containing additional information about the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | flattened        |
  | crowdstrike.event.AuditKeyValues                                        | Fields that were changed in this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | nested           |
  | crowdstrike.event.AuditKeyValues.Key                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.AuditKeyValues.ValueString                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Category                                              | IDP incident category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.CertificateTemplateIdentifier                         | The ID of the certificate template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.CertificateTemplateName                               | Name of the certificate template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.Certificates                                          | Provides one or more JSON objects which includes related SSL/TLS Certificates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | nested           |
  | crowdstrike.event.CloudPlatform                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.CloudProvider                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.CloudService                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Commands                                              | Commands run in a remote session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.CompositeId                                           | Global unique identifier that identifies a unique alert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.ComputerName                                          | Name of the computer where the detection occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.ContentPatternCounts                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.event.ContentPatterns.ConfidenceLevel                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.ContentPatterns.ID                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ContentPatterns.MatchCount                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.ContentPatterns.Name                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.CustomerId                                            | Customer identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.DataDomains                                           | Data domains of the event that was the primary indicator or created it.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | crowdstrike.event.Description                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Destination                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.event.Destination.Channel                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.DetectId                                              | Unique ID associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.DetectName                                            | Name of the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.DetectionType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.DeviceId                                              | Device on which the event occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.DnsRequests                                           | Detected DNS requests done by a process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | nested           |
  | crowdstrike.event.DocumentsAccessed                                     | Detected documents accessed by a process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | nested           |
  | crowdstrike.event.EgressEventId                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.EgressSessionId                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.EmailAddresses                                        | Summary list of all associated entity email addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.EnvironmentVariables                                  | Provides one or more JSON objects which includes related environment variables.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.event.EventTimestamp                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.EventType                                             | CrowdStrike provided event type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.ExecutablesWritten                                    | Detected executables written to disk by a process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | nested           |
  | crowdstrike.event.ExecutablesWritten.FileName                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutablesWritten.FilePath                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutablesWritten.Timestamp                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutionID                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutionMetadata.ExecutionDuration                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.ExecutionMetadata.ExecutionStart                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.ExecutionMetadata.ReportFileName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutionMetadata.ResultCount                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.ExecutionMetadata.ResultID                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ExecutionMetadata.SearchWindowEnd                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.ExecutionMetadata.SearchWindowStart                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.FalconHostLink                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileCategoryCounts                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.event.FileName                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilePath                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileType.Type.CategoryID                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileType.Type.CategoryName                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileType.Type.Description                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileType.Type.ID                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FileType.Type.Name                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilesAccessed.FileName                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilesAccessed.FilePath                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilesAccessed.Timestamp                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.FilesEgressedCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.FilesWritten.FileName                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilesWritten.FilePath                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.FilesWritten.Timestamp                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.event.Finding                                               | The details of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.FineScore                                             | The highest incident score reached as of the time the event was sent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | float            |
  | crowdstrike.event.Flags.Audit                                           | CrowdStrike audit flag.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | boolean          |
  | crowdstrike.event.Flags.Log                                             | CrowdStrike log flag.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | crowdstrike.event.Flags.Monitor                                         | CrowdStrike monitor flag.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | crowdstrike.event.GrandParentCommandLine                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.GrandParentImageFileName                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.GrandParentImageFilePath                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.GrandparentCommandLine                                | Grandparent process command line arguments.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.GrandparentImageFileName                              | Path to the grandparent process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.GrandparentImageFilePath                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Highlights                                            | Sections of content that matched the monitoring rule.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | text             |
  | crowdstrike.event.HostGroups                                            | Array of related Host Group IDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.Hostname                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ICMPCode                                              | RFC2780 ICMP Code field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.ICMPType                                              | RFC2780 ICMP Type field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.IOARuleGroupName                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.IOARuleInstanceID                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.IOARuleInstanceVersion                                | Version number of the InstanceID that triggered.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | crowdstrike.event.IOARuleName                                           | Name given to the custom IOA rule that triggered.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.IOCType                                               | CrowdStrike type for indicator of compromise.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.IOCValue                                              | CrowdStrike value for indicator of compromise.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.IdpPolicyRuleAction                                   | Identity Protection policy rule action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | crowdstrike.event.IdpPolicyRuleName                                     | Identity Protection policy rule name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.IdpPolicyRuleTrigger                                  | Identity Protection policy rule trigger.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.IncidentType                                          | Incident Type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.Ipv                                                   | Protocol for network request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.IsClipboard                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.ItemPostedTimestamp                                   | Time the raw intelligence was posted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | crowdstrike.event.ItemType                                              | Type of raw intelligence.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.KeyStoreErrors                                        | Describes a KeyStore error.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.LMHostIDs                                             | Array of host IDs seen to have experienced lateral movement because of the incident.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.LateralMovement                                       | Lateral movement field for incident.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | crowdstrike.event.LdapSearchQueryAttack                                 | Detected LDAP tool attack.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | crowdstrike.event.LoadedObjects                                         | Provides one or more JSON objects describing the loaded objects related to the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | nested           |
  | crowdstrike.event.LocalIP                                               | IP address of the host associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.LocalIPv6                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.event.LogonDomain                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MACAddress                                            | MAC address of the host associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.MD5String                                             | MD5 sum of the executable associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.MachineDomain                                         | Domain for the machine associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.MatchCount                                            | Number of firewall rule matches.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | crowdstrike.event.MatchCountSinceLastReport                             | Number of firewall rule matches since the last report.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | crowdstrike.event.MatchedClassification.ID                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MatchedClassification.Name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails                                     | Provides one or more JSON objects describing the related mobile applications.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | nested           |
  | crowdstrike.event.MobileAppsDetails.AndroidAppLabel                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.AndroidAppVersionName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.AppIdentifier                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.AppInstallerInformation             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.DexFileHashes                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.ImageFileName                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.IsBeingDebugged                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileAppsDetails.IsContainerized                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.MobileDnsRequests                                     | Provides one or more JSON objects describing the related DNS requests from the mobile device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | nested           |
  | crowdstrike.event.MobileNetworkConnections                              | Provides one or more JSON objects describing the related network connections from the mobile device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | nested           |
  | crowdstrike.event.MostRecentActivityTimeStamp                           | The timestamp of the latest activity performed by the account.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | crowdstrike.event.MountedVolumes                                        | Provides one or more JSON objects describing mounted volumes on the mobile device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | nested           |
  | crowdstrike.event.Name                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses                                       | Detected Network traffic done by a process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | nested           |
  | crowdstrike.event.NetworkAccesses.AccessTimestamp                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.AccessType                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.ConnectionDirection                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.IsIPV6                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.LocalAddress                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.LocalPort                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.Protocol                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.RemoteAddress                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkAccesses.RemotePort                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.NetworkProfile                                        | CrowdStrike network profile.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.NotificationId                                        | ID of the generated notification.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.NumberOfCompromisedEntities                           | Number of compromised entities, users and endpoints.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | crowdstrike.event.NumbersOfAlerts                                       | Number of alerts in the identity-based incident.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | crowdstrike.event.OARuleInstanceID                                      | Numerical ID of the custom IOA rule under a given CID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.Objective                                             | Method of detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.ObjectiveCRuntimesAltered                             | Provides one or more JSON objects describing the obj-c methods related to the malware.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | nested           |
  | crowdstrike.event.OperationName                                         | Event subtype.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.OriginWebLocations                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | flattened        |
  | crowdstrike.event.ParentImageFileName                                   | The parent image file name involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.ParentImageFilePath                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ParentProcessId                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.PatternDispositionDescription                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.PatternDispositionFlags.BlockingUnsupportedOrDisabled |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.BootupSafeguardEnabled        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.ContainmentFileSystem         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.CriticalProcessDisabled       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.Detect                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.FsOperationBlocked            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.HandleOperationDowngraded     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.InddetMask                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.Indicator                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.KillActionFailed              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.KillParent                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.KillProcess                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.KillSubProcess                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.OperationBlocked              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.PolicyDisabled                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.ProcessBlocked                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.QuarantineFile                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.QuarantineMachine             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.RegistryOperationBlocked      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.Rooting                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.SensorOnly                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.SuspendParent                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionFlags.SuspendProcess                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.PatternDispositionValue                               | Unique ID associated with action taken.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | integer          |
  | crowdstrike.event.PatternId                                             | The numerical ID of the pattern associated with the action taken on the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.PlatformId                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.PlatformName                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.PolicyID                                              | CrowdStrike policy id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.PolicyId                                              | The ID of the associated Policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | crowdstrike.event.PolicyName                                            | CrowdStrike policy name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.PrecedingActivityTimeStamp                            | The timestamp of the activity before the most recent activity was performed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
  | crowdstrike.event.PreviousPrivileges                                    | A list of the source account's privileges before privilege changes were made.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.ProcessId                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.event.Protocol                                              | CrowdStrike provided protocol.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.ProtocolAnomalyClassification                         | Authentication signature analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.ReferrerUrl                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Region                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.RelatedClassifications.ID                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.RelatedClassifications.Name                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ReportFileReference                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ReportID                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ReportName                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ReportType                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.ResourceAttributes                                    | A JSON blob with all resource attributes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | flattened        |
  | crowdstrike.event.ResourceId                                            | The cloud resource identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.ResourceIdType                                        | The type of the detected resource identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.ResourceName                                          | Resource name if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.ResourceUrl                                           | The URL to the cloud resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.ResponseAction                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.RootAccessIndicators                                  | Provides one or more JSON objects which includes logs and stack traces from the suspicious source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | nested           |
  | crowdstrike.event.RpcOpClassification                                   | RPC operation type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.RuleAction                                            | Firewall rule action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.RuleId                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.RulePriority                                          | Priority of the monitoring rule that found the match.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.SELinuxEnforcementPolicy                              | State of SELinux enforcement policy on an Android device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.SHA1String                                            | SHA1 sum of the executable associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.SHA256String                                          | SHA256 sum of the executable associated with the detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.SafetyNetAdvice                                       | Provides information to help explain why the Google SafetyNet Attestation API set eitherCTSProfileMatch or BasicIntegrity fields to false.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | crowdstrike.event.SafetyNetBasicIntegrity                               | The result of a more lenient verdict for device integrity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | crowdstrike.event.SafetyNetCTSProfileMatch                              | The result of a stricter verdict for device integrity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.event.SafetyNetErrorMessage                                 | An encoded error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.SafetyNetErrors                                       | Describes a SafetyNet error                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.SafetyNetEvaluationType                               | Provides information about the type of measurements used to compute fields likeCTSProfileMatch and BasicIntegrity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.ScanResults                                           | Array of scan results.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | nested           |
  | crowdstrike.event.ScheduledSearchExecutionId                            | ID of the specific search execution.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.ScheduledSearchId                                     | Unique identifier of the associated scheduled search.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.ScheduledSearchUserId                                 | User ID of the user that created the the associated scheduled search.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | crowdstrike.event.ScheduledSearchUserUUID                               | UUID of the user that created the the associated scheduled search.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.event.SensorId                                              | Unique ID associated with the Falcon sensor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.ServiceName                                           | Description of which related service was involved in the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.SessionId                                             | Session ID of the remote response session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | crowdstrike.event.Severity                                              | The integer severity level using Crowdstrike scaling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |
  | crowdstrike.event.SeverityName                                          | The severity level of the detection, as a string (High/Medium/Informational).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | crowdstrike.event.SourceAccountUpn                                      | Source user UPN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.SourceEndpointAccountObjectGuid                       | Source endpoint object GUID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.SourceEndpointAccountObjectSid                        | Source endpoint object SID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.SourceEndpointIpReputation                            | Source endpoint IP reputation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | crowdstrike.event.SourceEndpointSensorId                                | Source endpoint agent ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.SourceProducts                                        | Names of the products from which the source data originated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.SourceVendors                                         | Names of the vendors from which the source data originated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.SsoApplicationIdentifier                              | Destination application identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.State                                                 | Identity-based detection or incident status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.Status                                                | CrowdStrike status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.StatusMessage                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.Success                                               | Indicator of whether or not this event was successful.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | crowdstrike.event.SuspiciousMachineAccountAlterationType                | Machine alteration type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.event.SystemProperties                                      | Provides one or more JSON objects which includes related system properties.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | nested           |
  | crowdstrike.event.Tags                                                  | Tags on the cloud resources if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | nested           |
  | crowdstrike.event.TargetAccountDomain                                   | Target user domain.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.TargetAccountName                                     | Target user name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | crowdstrike.event.TargetAccountObjectSid                                | Target user object SID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | crowdstrike.event.TargetAccountUpn                                      | Target user UPN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | crowdstrike.event.TargetEndpointAccountObjectGuid                       | Target endpoint object GUID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.TargetEndpointAccountObjectSid                        | Target endpoint object SID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.TargetEndpointHostName                                | Target endpoint hostname.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.TargetEndpointSensorId                                | Target endpoint agent ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.TargetServiceAccessIdentifier                         | Target SPN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | crowdstrike.event.Timestamp                                             | Firewall rule triggered timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | crowdstrike.event.Trampolines                                           | Provides one or more JSON objects describing the relevant functions and processes performing inline API hooks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | nested           |
  | crowdstrike.event.TreeID                                                | CrowdStrike tree id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | crowdstrike.event.Type                                                  | The endpoint detection type ("ldt": Legacy Endpoint Detection, or "ofp": Office Prevention Macro Detection).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | crowdstrike.event.UserDepartment                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.UserId                                                | Email address or user ID associated with the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.event.UserMapped                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.UserName                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.UserNotified                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.event.UserTitle                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.UserUUID                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.event.VerifiedBootState                                     | Provides the device’s current boot state.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | crowdstrike.event.XdrType                                               | Type of detection: xdr or xdr-scheduled-search.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.metadata.customerIDString                                   | Customer identifier                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | crowdstrike.metadata.eventType                                          | DetectionSummaryEvent, FirewallMatchEvent, IncidentSummaryEvent, RemoteResponseSessionStartEvent, RemoteResponseSessionEndEvent, AuthActivityAuditEvent, or UserActivityAuditEvent                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | crowdstrike.metadata.offset                                             | Offset number that tracks the location of the event in stream. This is used to identify unique detection events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |
  | crowdstrike.metadata.version                                            | Schema version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | data_stream.dataset                                                     | Data stream dataset name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | constant_keyword |
  | data_stream.namespace                                                   | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.type                                                        | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | destination.as.number                                                   | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | destination.as.organization.name                                        | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.organization.name.text                                   | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | destination.geo.city_name                                               | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.geo.continent_name                                          | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_iso_code                                        | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_name                                            | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.location                                                | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | destination.geo.region_iso_code                                         | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_name                                             | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.ip                                                          | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | destination.port                                                        | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | device.id                                                               | The unique identifier of a device. The identifier must not change across application sessions but stay fixed for an instance of a (mobile) device. On iOS, this value must be equal to the vendor identifier (). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application. For GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user.                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | ecs.version                                                             | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | error.message                                                           | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | event.action                                                            | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | event.category                                                          | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.code                                                              | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | event.created                                                           | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                                                                                                                                                                                                            | date             |
  | event.dataset                                                           | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.end                                                               | `event.end` contains the date when the event ended or when the activity was last observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | event.ingested                                                          | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | event.kind                                                              | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.module                                                            | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | event.original                                                          | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | event.outcome                                                           | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword          |
  | event.severity                                                          | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.                                                                                                                                                                                                                                                                                                                                                   | long             |
  | event.start                                                             | `event.start` contains the date when the event started or when the activity was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | event.type                                                              | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.url                                                               | URL linking to an external system to continue investigation of this event. This URL links to another system where in-depth investigation of the specific occurrence of this event can take place. Alert events, indicated by `event.kind:alert`, are a common use case for this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | file.hash.md5                                                           | MD5 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | file.hash.sha1                                                          | SHA1 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | file.hash.sha256                                                        | SHA256 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | file.path                                                               | Full path to the file, including the file name. It should include the drive letter, when appropriate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | file.path.text                                                          | Multi-field of `file.path`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | host.containerized                                                      | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.os.build                                                           | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                                                        | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | input.type                                                              | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.flags                                                               | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                                                              | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | message                                                                 | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | network.direction                                                       | Direction of the network traffic. When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress". When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external". Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers.                                                                                                                                                                                      | keyword          |
  | network.type                                                            | In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | observer.product                                                        | The product name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | observer.vendor                                                         | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | process.args                                                            | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | process.command_line                                                    | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | wildcard         |
  | process.command_line.text                                               | Multi-field of `process.command_line`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | process.end                                                             | The time the process ended.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | date             |
  | process.executable                                                      | Absolute path to the process executable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | process.executable.text                                                 | Multi-field of `process.executable`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | process.name                                                            | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | process.name.text                                                       | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | process.parent.args                                                     | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | process.parent.command_line                                             | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | wildcard         |
  | process.parent.command_line.text                                        | Multi-field of `process.parent.command_line`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | process.parent.executable                                               | Absolute path to the process executable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | process.parent.executable.text                                          | Multi-field of `process.parent.executable`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | process.parent.pid                                                      | Process id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | process.pid                                                             | Process id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | process.start                                                           | The time the process started.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | related.hash                                                            | All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | related.hosts                                                           | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                                                              | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | related.user                                                            | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | rule.author                                                             | Name, organization, or pseudonym of the author or authors who created the rule used to generate this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | rule.category                                                           | A categorization value keyword used by the entity using the rule for detection of this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | rule.description                                                        | The description of the rule generating the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | rule.id                                                                 | A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | rule.name                                                               | The name of the rule or signature generating the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | rule.ruleset                                                            | Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | rule.uuid                                                               | A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | source.as.number                                                        | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.as.organization.name                                             | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.as.organization.name.text                                        | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | source.geo.city_name                                                    | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.geo.continent_name                                               | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_iso_code                                             | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_name                                                 | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.location                                                     | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | source.geo.region_iso_code                                              | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_name                                                  | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.ip                                                               | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | source.port                                                             | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | tags                                                                    | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | threat.framework                                                        | Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | threat.tactic.id                                                        | The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex.  )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | threat.tactic.name                                                      | Name of the type of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | threat.technique.id                                                     | The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | threat.technique.name                                                   | The name of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | threat.technique.name.text                                              | Multi-field of `threat.technique.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | match_only_text  |
  | user.domain                                                             | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | user.email                                                              | User email address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.id                                                                 | Unique identifier of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | user.name                                                               | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user.name.text                                                          | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-11-02T13:41:34.000Z",
      "agent": {
          "ephemeral_id": "8f4a039c-66d4-439c-a43f-c5a95f653dd4",
          "id": "67072e92-576d-47d8-8a43-ebb347b4250b",
          "name": "elastic-agent-93422",
          "type": "filebeat",
          "version": "8.18.1"
      },
      "crowdstrike": {
          "event": {
              "AgentIdString": "fffffffff33333",
              "SessionId": "1111-fffff-4bb4-99c1-74c13cfc3e5a"
          },
          "metadata": {
              "customerIDString": "abcabcabc22221",
              "eventType": "RemoteResponseSessionStartEvent",
              "offset": 1,
              "version": "1.0"
          }
      },
      "data_stream": {
          "dataset": "crowdstrike.falcon",
          "namespace": "99576",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "67072e92-576d-47d8-8a43-ebb347b4250b",
          "snapshot": false,
          "version": "8.18.1"
      },
      "event": {
          "action": [
              "remote_response_session_start_event"
          ],
          "agent_id_status": "verified",
          "category": [
              "network",
              "session"
          ],
          "created": "2023-11-02T13:41:34.000Z",
          "dataset": "crowdstrike.falcon",
          "ingested": "2025-05-30T08:29:21Z",
          "kind": "event",
          "original": "{\"event\":{\"AgentIdString\":\"fffffffff33333\",\"HostnameField\":\"UKCHUDL00206\",\"SessionId\":\"1111-fffff-4bb4-99c1-74c13cfc3e5a\",\"StartTimestamp\":1698932494,\"UserName\":\"admin.rose@example.com\"},\"metadata\":{\"customerIDString\":\"abcabcabc22221\",\"eventCreationTime\":1698932494000,\"eventType\":\"RemoteResponseSessionStartEvent\",\"offset\":1,\"version\":\"1.0\"}}",
          "start": "2023-11-02T13:41:34.000Z",
          "type": [
              "start"
          ]
      },
      "host": {
          "name": "UKCHUDL00206"
      },
      "input": {
          "type": "streaming"
      },
      "message": "Remote response session started.",
      "observer": {
          "product": "Falcon",
          "vendor": "Crowdstrike"
      },
      "related": {
          "hosts": [
              "UKCHUDL00206"
          ],
          "user": [
              "admin.rose",
              "admin.rose@example.com"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "crowdstrike-falcon"
      ],
      "user": {
          "domain": "example.com",
          "email": "admin.rose@example.com",
          "name": "admin.rose"
      }
  }
  ```
</dropdown>


### FDR

The CrowdStrike Falcon Data Replicator (FDR) allows CrowdStrike users to replicate FDR data from CrowdStrike
managed S3 buckets. CrowdStrike writes notification events to a CrowdStrike managed SQS queue when new data is
available in S3.
This integration can be used in two ways. It can consume SQS notifications directly from the CrowdStrike managed
SQS queue or it can be used in conjunction with the FDR tool that replicates the data to a self-managed S3 bucket
and the integration can read from there.
In both cases SQS messages are deleted after they are processed. This allows you to operate more than one Elastic
Agent with this integration if needed and not have duplicate events, but it means you cannot ingest the data a second time.

#### Use with CrowdStrike managed S3/SQS

This is the simplest way to setup the integration, and also the default.
You need to set the integration up with the SQS queue URL provided by Crowdstrike FDR.
Ensure the `Is FDR queue` option is enabled.

#### Use with FDR tool and data replicated to a self-managed S3 bucket

This option can be used if you want to archive the raw CrowdStrike data.
You need to follow the steps below:
- Create a S3 bucket to receive the logs.
- Create a SQS queue.
- Configure your S3 bucket to send object created notifications to your SQS queue.
- Follow the [FDR tool](https://github.com/CrowdStrike/FDR) instructions to replicate data to your own S3 bucket.
- Configure the integration to read from your self-managed SQS topic.
- Disable the `Is FDR queue` option in the integration.

<note>
  While the FDR tool can replicate the files from S3 to your local file system, this integration cannot read those files because they are gzip compressed, and the log file input does not support reading compressed files.
</note>


#### Configuration for the S3 input

AWS credentials are required for running this integration if you want to use the S3 input.

##### Configuration parameters

- `access_key_id`: first part of access key.
- `secret_access_key`: second part of access key.
- `session_token`: required when using temporary security credentials.
- `credential_profile_name`: profile name in shared credentials file.
- `shared_credential_file`: directory of the shared credentials file.
- `endpoint`: URL of the entry point for an AWS web service.
- `role_arn`: AWS IAM Role to assume.


##### Credential Types

There are three types of AWS credentials can be used:
- access keys,
- temporary security credentials, and
- IAM role ARN.


##### Access keys

`AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY` are the two parts of access keys.
They are long-term credentials for an IAM user, or the AWS account root user.
Please see [AWS Access Keys and Secret Access Keys](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)
for more details.

##### Temporary security credentials

Temporary security credentials has a limited lifetime and consists of an
access key ID, a secret access key, and a security token which typically returned
from `GetSessionToken`.
MFA-enabled IAM users would need to submit an MFA code
while calling `GetSessionToken`. `default_region` identifies the AWS Region
whose servers you want to send your first API request to by default.
This is typically the Region closest to you, but it can be any Region. Please see
[Temporary Security Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html)
for more details.
`sts get-session-token` AWS CLI can be used to generate temporary credentials.
For example. with MFA-enabled:
```js
aws> sts get-session-token --serial-number arn:aws:iam::1234:mfa/your-email@example.com --duration-seconds 129600 --token-code 123456
```

Because temporary security credentials are short term, after they expire, the
user needs to generate new ones and manually update the package configuration in
order to continue collecting `aws` metrics.
This will cause data loss if the configuration is not updated with new credentials before the old ones expire.

##### IAM role ARN

An IAM role is an IAM identity that you can create in your account that has
specific permissions that determine what the identity can and cannot do in AWS.
A role does not have standard long-term credentials such as a password or access
keys associated with it. Instead, when you assume a role, it provides you with
temporary security credentials for your role session.
IAM role Amazon Resource Name (ARN) can be used to specify which AWS IAM role to assume to generate
temporary credentials.
Please see [AssumeRole API documentation](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html) for more details.

##### Supported Formats

1. Use access keys: Access keys include `access_key_id`, `secret_access_key`
   and/or `session_token`.
2. Use `role_arn`: `role_arn` is used to specify which AWS IAM role to assume
   for generating temporary credentials.
   If `role_arn` is given, the package will check if access keys are given.
   If not, the package will check for credential profile name.
   If neither is given, default credential profile will be used.

Please make sure credentials are given under either a credential profile or
access keys.
3. Use `credential_profile_name` and/or `shared_credential_file`:
If `access_key_id`, `secret_access_key` and `role_arn` are all not given, then
the package will check for `credential_profile_name`.
If you use different credentials for different tools or applications, you can use profiles to
configure multiple access keys in the same configuration file.
If there is no `credential_profile_name` given, the default profile will be used.
`shared_credential_file` is optional to specify the directory of your shared
credentials file.
If it's empty, the default directory will be used.
In Windows, shared credentials file is at `C:\Users\<yourUserName>\.aws\credentials`.
For Linux, macOS or Unix, the file locates at `~/.aws/credentials`.
Please see[Create Shared Credentials File](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/create-shared-credentials-file.html)
for more details.

#### Troubleshooting


##### Vulnerability API returns 404 Not found

This error may occur for the following reasons:
1. Too many records in the response.
2. The pagination token has expired. Tokens expire 120 seconds after a call is made.

To resolve this, adjust the `Batch Size` setting in the integration to reduce the number of records returned per pagination call.

##### Duplicate Events

The option `Enable Data Deduplication` allows you to avoid consuming duplicate events. By default, this option is set to `false`, and so duplicate events may be ingested. When this option is enabled, a [fingerprint processor](https://www.elastic.co/guide/en/elasticsearch/reference/current/fingerprint-processor.html) is used to calculate a hash from a set of Crowdstrike fields that uniquely identifies the event. The hash is assigned to the Elasticsearch [`_id`](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-id-field.html) field that makes the document unique, thus avoiding duplicates.
If duplicate events are ingested, to help find them, the integration `event.id` field is populated by concatenating a few Crowdstrike fields that uniquely identifies the event. These fields are `id`, `aid`, and `cid` from the Crowdstrike event. The fields are separated with pipe `|`.
For example, if your Crowdstrike event contains `id: 123`, `aid: 456`, and `cid: 789` then the `event.id` would be `123|456|789`.

#### Alert severity mapping

The values used in `event.severity` are consistent with Elastic Detection Rules.

| Severity Name              | `event.severity` |
|----------------------------|------------------|
| Low, Info or Informational | 21               |
| Medium                     | 47               |
| High                       | 73               |
| Critical                   | 99               |

If the severity name is not available from the original document, it is determined from the numeric severity value according to the following table.

| Crowdstrike `severity` | Severity Name |
|------------------------|---------------|
| 0 - 19                 | info          |
| 20 - 39                | low           |
| 40 - 59                | medium        |
| 60 - 79                | high          |
| 80 - 100               | critical      |


#### Example

<dropdown title="Exported fields">
  | Field                                                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |-------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                        | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | aws.s3.bucket.arn                                                 | The AWS S3 bucket ARN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.s3.bucket.name                                                | The AWS S3 bucket name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.s3.object.key                                                 | The AWS S3 Object key.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | crowdstrike.AccessType                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AccountDomain                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.AccountObjectGuid                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.AccountObjectSid                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.AccountType                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ActiveDirectoryAuthenticationMethod                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ActivityId                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AddressFamily                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AdminStatus                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AgentIdString                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AgentLoadFlags                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AgentLocalTime                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.AgentTimeOffset                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | float            |
  | crowdstrike.AgentVersion                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AggregateId                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AllocateVirtualMemoryCount                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.AllowlistingFilterId                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AnodeIndicators                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.AntiTamperStateFlag                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ApiReturnValue                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ApplicationName                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ArchiveFileWrittenCount                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.AsepClass                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AsepFlags                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AsepIndex                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AsepValueType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AsepWrittenCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.AssemblyFlags                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AssemblyId                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AssemblyName                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AssociatedFile                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Attacks.Tactic                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Attacks.Technique                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AttemptNumber                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.AuthenticationActivityId                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticationId                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticationPackage                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticationUuid                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticationUuidAsString                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticodeHashData                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.AuthenticodeHashDataSHA256                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BaseReachableTime                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BatchDataNumber                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BatchDataTotal                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BatchTimestamp                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.BinaryExecutableWrittenCount                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.BiosChanged                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BiosManufacturer                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BiosReleaseDate                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.BiosVersion                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BluetoothClassOfDeviceValue                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothDeviceAppearanceValue                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothDeviceModelNumber                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothDeviceName                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_1                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_3                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_4                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_5                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_6                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_7                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceName_8                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuidArray                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_1                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_2                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_3                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_4                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_5                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_6                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_7                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothServiceUuid_8                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BluetoothVendorIdSource                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.BootArgs                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BootTimeFunctionalityLevel                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BoundedCount                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.BoundingLimitCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.BoundingLimitDuration                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserExtensionId                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserExtensionInstallMethod                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserExtensionStatusEnabled                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserFileHash                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserFilePath                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserName                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserProfileId                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserProfileName                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BrowserVersion                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.BundleID                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CLICreationCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.CNAMERecords                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CallStackModuleNames                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CallStackModuleNamesVersion                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | version          |
  | crowdstrike.CapPrm                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CertificateIssuer                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CertificatePublisher                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CertificateSignatureHash                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CertificateSignatureHashAlgorithm                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChangeTime                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.ChangedPcrBitmap                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ChannelDiffStatus                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChannelId                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChannelVersion                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChannelVersionRequired                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChasisManufacturer                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ChassisType                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ClientComputerName                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ClientId                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ClientProcessStartKey                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CloudIndicator                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.CommandCount                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.CommandCountMax                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.CommandHistory                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CommandHistory.text                                   | Multi-field of `crowdstrike.CommandHistory`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | match_only_text  |
  | crowdstrike.CompanyName                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CompletionEventId                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CompositeId                                           | Global unique identifier that identifies a unique alert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | crowdstrike.ConHostId                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConHostProcessId                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigBuild                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigIDBase                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigIDBuild                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigIDPlatform                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigStateData                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | text             |
  | crowdstrike.ConfigStateHash                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConfigurationDescriptorName                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ConfigurationVersion                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConnectTime                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.ConnectType                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConnectionAddressIP6                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ConnectionFlags                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ConnectionType                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContentPatternCounts                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.ContentPatterns.ConfidenceLevel                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.ContentPatterns.ID                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContentPatterns.MatchCount                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.ContentPatterns.Name                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContentSHA256HashData                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContextBaseFileName                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContextImageFileName                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContextProcessId                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContextProcessTagsAsString                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ContextTimeStamp                                      | System local time of event creation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | date             |
  | crowdstrike.CpuClockSpeed                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CpuFeaturesMask                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CpuProcessorName                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CpuSignature                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CpuVendor                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CreateProcessCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.CreateProcessType                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CurrentFunctionalityLevel                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CurrentLocalIP                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.CustomerIdString                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.CycleTime                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DadState                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DadTransmits                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Data1                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DataDomains                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DcNumAttachments                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.DcNumBlockingPolicies                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.Description                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DesiredAccess                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Destination                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.Destination.Channel                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DetectDescription                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DetectId                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DetectName                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DetectionType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DeviceId                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DeviceMountCounter                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DevicePropertyClassGuid                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.DevicePropertyClassName                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.DevicePropertyLocationInformation                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.DirectionType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DirectoryCreatedCount                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DirectoryEnumeratedCount                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DllCharacteristics                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DnsRequestCount                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DnsRequests                                           | Detected DNS requests done by a process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | nested           |
  | crowdstrike.DnsResponseType                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DocumentFileWrittenCount                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DomainSid                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DotnetModuleFlags                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DotnetModuleId                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DownloadPath                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DownloadPort                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.DownloadServer                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DriverLoadFlags                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DualRequest                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.DylibPath                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ELFSubType                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EffectiveTransmissionClass                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EfiVariableCustomModeAttributes                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableDbAttributes                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableDbSha256Hash                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableKekAttributes                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableKekSha256Hash                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariablePkAttributes                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariablePkSha256Hash                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableSecureBootAttributes                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableSetupMode                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableSetupModeAttributes                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableSignatureSupport                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EfiVariableSignatureSupportAttributes                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.EgressEventId                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EgressSessionId                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EnabledPrivilegesBitmask                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EndTime                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.Entitlements                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EnvironmentVariableName                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EnvironmentVariableValue                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EnvironmentVariablesString                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ErrorCode                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ErrorStatus                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EtwProviderType                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EtwRawProcessId                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.EtwRawRpcClientProcessId                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EtwRawThreadId                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.EventCorrelationId                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EventOrigin                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | crowdstrike.EventTimestamp                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.EventType                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.EventUUID                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExceptionAddress                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExceptionCode                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExceptionInformation0                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExclusionSource                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExclusionType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExeAndServiceCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.ExecutableBytes                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ExecutableDeletedCount                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.ExtendedAttributeValue                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ExtendedAttributeValueReadable                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.ExtendedKeyUsages                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ExternalApiType                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FXFileSize                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Facility                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FailedConnectCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.FalconGroupingTags                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FalconHostLink                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FeatureExtractionVersion                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FeatureVector                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.File                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileAttributes                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileCategory                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileCategoryCounts                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | nested           |
  | crowdstrike.FileContent                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.FileDeletedCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.FileEcpBitmask                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileName                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileObject                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileOperatorSid                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilePath                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileSigningTime                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileSubType                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileSystemOperationType                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileType.Type.CategoryID                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileType.Type.CategoryName                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileType.Type.Description                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileType.Type.ID                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileType.Type.Name                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileVaultIsEnabled                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.FileVersion                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FileWrittenFlags                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilesAccessed.FileName                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilesAccessed.FilePath                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilesAccessed.Timestamp                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.FilesEgressedCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.FilesWritten.FileName                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilesWritten.FilePath                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FilesWritten.Timestamp                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.FirewallAction                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirewallOption                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirewallOptionNumericValue                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirewallProfile                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirewallRule                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirewallRuleId                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirmwareAnalysisEclConsumerInterfaceVersion           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirmwareAnalysisEclControlInterfaceVersion            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirstCommand                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.FirstDiscoveredDate                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.FirstIP4Record                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FirstSeen                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.FixedFileVersion                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Flags                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FltCallbackData                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FltCompletionContext                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FltRelatedObjects                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FontBuffer                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FontBufferLength                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FontFileCount                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.FontFileName                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FontLoadOperation                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FsOperationClassification                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FsOperationClassificationFlags                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.FullExceptionRecord                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GenericFileWrittenCount                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.GrandParentBaseFileName                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GrandparentCommandLine                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GrandparentCommandLine.text                           | Multi-field of `crowdstrike.GrandparentCommandLine`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | crowdstrike.GrandparentImageFileName                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GrandparentImageFilePath                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GrandparentProcessId                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.GroupRid                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HandleCreateAuthenticationId                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HandleCreated                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HandleOperationType                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HashAlgorithm                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HostGroups                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HostHiddenStatus                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HostProcessType                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.HttpInternalSource                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.HttpMethod                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.HttpRequestHeader                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.HttpUrl                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.IOCType                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IOCValue                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IOServiceClass                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IOServiceName                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IOServicePath                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IP4Records                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IcmpCode                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IcmpType                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IfType                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageBaseName                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageCheckSum                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageEntryPoint                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageFileName                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageSignatureLevel                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageSignatureType                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageSubsystem                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImageTimeStamp                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ImpersonatedUserName                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InBroadcastOctets                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InContext                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InDiscards                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InErrors                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InMulticastOctets                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InMulticastPkts                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InNUcastPkts                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InOctets                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InUcastOctets                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InUcastPkts                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InUnknownProtos                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IndividualDiskInfo                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.Information                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InjectedDll                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InjectedDllCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.InjectedThreadCount                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.InjectedThreadFlag                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InstanceMetadata                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.InstanceMetadataSignature                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.IntegrityLevel                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceAlias                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceDescription                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceFlags                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceGuid                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceIdentifier                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceIndex                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.InterfaceKind                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.InterfaceMtu                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceType                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.InterfaceVersion                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IpEntryFlags                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IrpFlags                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsClipboard                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | crowdstrike.IsHosted                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsOnNetwork                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsOnRemovableDisk                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsProcessInitializing                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsTransactedFile                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.IsUnique                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.KernelTime                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.KeyObject                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LanguageId                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LastAdded                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LastDiscoveredBy                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LastDisplayed                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LastLoggedOnHost                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LastPendingUpdateInstalledTime                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LaunchItemType                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LaunchItemUrl                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LdapSearchFilterSample                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.LfoUploadFlags                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LightningLatencyState                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Line                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LinkLocalAddressBehavior                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LinkLocalAddressTimeout                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LocalAddressIP4                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.LocalAddressIP6                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.LocalAddressMaskIP4                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LocalAddressMaskIP6                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LocalAdminAccess                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LocalIP                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.LocalIPv6                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | crowdstrike.LocalIpAddressPipelineSource                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogicalCoreCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.LoginSessionId                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogoffTime                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.LogonDomain                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogonId                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogonInfo                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogonServer                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.LogonTime                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | crowdstrike.LogonType                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MACAddress                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MACPrefix                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MD5HashData                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MD5String                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MLModelVersion                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MachOSubType                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MajorFunction                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MajorVersion                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Malicious                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ManagedPdbBuildPath                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.MappedFromUserMode                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MatchedClassification.ID                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MatchedClassification.Name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MaxReassemblySize                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MaxRouterAdvertisementInterval                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MaxThreadCount                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.MediaConnectState                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MediaType                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MemoryAvailable                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.MemoryTotal                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Metric                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MicrocodeSignature                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MinRouterAdvertisementInterval                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MinorFunction                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MinorVersion                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MmioDataGenPmconB                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.MmioDataSmiEn                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.MmioDataTco1Cnt                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | crowdstrike.MoboManufacturer                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MoboProductName                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ModelPrediction                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ModuleCharacteristics                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ModuleILPath                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ModuleLoadCount                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.ModuleLoadTelemetryClassification                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.ModuleSize                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.MountedVolumeAction                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NDRoot                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NegateInterface                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NegateLocalAddress                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NegateRemoteAddress                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NeighborList                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NeighborName                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetLuidIndex                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkAccesses.AccessTimestamp                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.AccessType                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.ConnectionDirection                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.IsIPV6                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.LocalAddress                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.LocalPort                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.Protocol                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.RemoteAddress                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkAccesses.RemotePort                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkBindCount                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkCapableAsepWriteCount                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkCloseCount                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkConnectCount                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkConnectCountUdp                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkContainmentState                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkGuid                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkInterfaceGuid                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NetworkListenCount                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkModuleLoadCount                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NetworkRecvAcceptCount                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NewExecutableWrittenCount                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | crowdstrike.NewFileIdentifier                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.NlMtu                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | crowdstrike.Nonce                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | crowdstrike.OSVersionFileData                                     |                                                                                                                    