﻿---
title: Cribl
description: The Cribl integration offers users a way to ingest logs from either of Cribl's Elastic outputs into Elastic's Fleet integration data streams. This enables...
url: https://www.elastic.co/docs/reference/integrations/cribl
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cribl
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.0.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

The Cribl integration offers users a way to ingest logs from either of Cribl's Elastic outputs into Elastic's Fleet integration data streams. This enables Cribl users to leverage the power of the Elastic Common Schema to unlock predefined dashboards, alerts and more.

## Instructions

1. Install the relevant integration assets in Kibana
   In order to make the most of your data, install Fleet integration assets to load index templates, ingest pipelines, and dashboards into Kibana. In Kibana, navigate to **Management** > **Integrations** in the sidebar.
   Find the relevant integration(s) by searching or browsing the catalog. For example, the Cisco ASA integration.
   ![Cisco ASA Integration](https://www.elastic.co/docs/reference/integrations/images/cribl/catalog-cisco-asa.png)
   Navigate to the **Settings** tab and click **Install Cisco ASA assets**. Confirm by clicking **Install Cisco ASA** in the popup.
   ![Install Cisco ASA assets](https://www.elastic.co/docs/reference/integrations/images/cribl/install-assets.png)
2. Configuring the Cribl integration
   1. Add informational field to Cribl Source
   Configure the Cribl Source to specify the source of the data in the `_dataId` field.
   ![Configure Cribl Source fields](https://www.elastic.co/docs/reference/integrations/images/cribl/cribl-source-fields.png)
   See [Cribl Data Onboarding](https://docs.cribl.io/stream/data-onboarding/) for more information on configuring sources.
2. Configure the Cribl integration in Kibana
   Map each `_dataId` configured in the step above to the pre-installed Fleet integration's datastream.
   ![Configure Elastic Cribl Integration](https://www.elastic.co/docs/reference/integrations/images/cribl/elastic-cribl-config.png)
   <note>
   The Cribl integration does not require Elastic Agent, but a policy must be configured when setting up the Cribl integration.
   </note>
3. Configure an Elastic destination in Cribl
   Cribl offers two options for sending data to Elastic, the Elastic Cloud output for cloud environments, and the Elasticsearch output for self-managed. Consult [Cribl Elastic Cloud documentation](https://docs.cribl.io/stream/destinations-elastic-cloud/) or [Cribl Elasticsearch documentation](https://docs.cribl.io/stream/destinations-elastic/) for more details on how to configure.
   **Destination settings**
   1. Set **Cloud Id** for the Cloud destination or **Bulk API URLs** for the Elasticsearch destination to point to your Elastic cluster.
2. Set **Index or Data Stream** to `logs-cribl-default` for log-type events or to `metrics-cribl-default` for metric-type events.
3. **API key** should be a Base64 encoded Elastic API key, which you can create in Kibana by following the instructions under **Management** > **Stack Management** > **Security** > **API Keys**. If you are using an API key with “Restrict privileges”, be sure to review the Indices privileges to provide at least "auto_configure" and "write" permissions for the logs-* index, which you will be using for these Fleet integration data streams.


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Logs Overview dashboard screenshot](https://epr.elastic.co/package/cribl/1.0.1/img/logs-overview-dashboard.png)

  ![Metrics Overview dashboard screenshot](https://epr.elastic.co/package/cribl/1.0.1/img/metrics-overview-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                                                      | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16443))Rename `_raw` field to `message` only if the `message` field is null.                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14013))Release package as GA.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14013))Add overview dashboards for logs and metrics.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14013))ECS version updated to 8.17.0. | 9.0.08.13.0            |
  | **0.5.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13930))Fix handling of metric event type.                                                                                                                                                                                                                                                      |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                          |                        |
  | **0.4.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                    |                        |
  | **0.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10312))Update documentation                                                                                                                                                                                                                                                                    |                        |
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Removed import_mappings. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                  |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9399))Update manifest format version to v3.0.3.                                                                                                                                                                                                                                            |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9097))Adds the second phase of the Cribl package                                                                                                                                                                                                                                           |                        |
  | **0.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                       |                        |
  | **0.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8487))Update documentation                                                                                                                                                                                                                                                                 |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8487))Adds the first phase of the Cribl package                                                                                                                                                                                                                                            |                        |
</dropdown>