﻿---
title: Corelight
description: Corelight provides network detection and response (NDR) solutions that enhance visibility, threat detection, and incident response by leveraging open-source...
url: https://www.elastic.co/docs/reference/integrations/corelight
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Corelight
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.0.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.0                    |

[Corelight](https://corelight.com/) provides network detection and response (NDR) solutions that enhance visibility, threat detection, and incident response by leveraging open-source technologies like Zeek. Its platform integrates with existing security tools to deliver high-fidelity network data, helping organizations detect and respond to threats more effectively across both on-premises and cloud environments.
This integration includes only the Corelight dashboards mentioned below:
- Connections
- Corelight Suricata IDS Alert Overview
- DNS
- Files
- HTTP
- Intel
- IP Interrogation
- Log Hunting
- Name Resolution Insights
- Notices
- RDP Inferences Overview
- Remote Activity Insights
- SSH Inferences Overview
- SSL and x509
- Secure Channel Insights
- Security Posture
- Software
- VPN Insights


## Prerequisites:

**Add ECS Mappings**: Start by adding the ECS (Elastic Common Schema) mappings from the [Corelight GitHub organization](https://github.com/corelight). You can find the required templates here: [Corelight ECS Templates](https://github.com/corelight/ecs-templates). The script within the repository installs the necessary components, including index settings, index templates, ILM policies, and ingest pipelines etc. These components will ensure that Corelight data is correctly formatted and aligned with Elastic's schema.
**Send Data from Corelight to Elastic**: Once the ECS mappings are in place, configure Elasticsearch in the web interface under Sensor > Export > Export to Elastic. It will require below parameters:
- **Server:** The HTTP or HTTPS URL (including the port).
- **Prefix:** The Elasticsearch index, alias, and template prefix (e.g. logs-corelight-*).
- **Username:** The Username to authenticate to Elasticsearch.
- **Password:** The Password to authenticate to Elasticsearch.
- **Zeek logs to exclude:** Logs that you don't want to export to Elasticsearch. If blank, sensor will export all log types.
- **Elasticsearch log filter:** Logs to exclude using the Corelight Filtering Language.

<note>
  Use the index prefix name (logs-*) instead of a custom index prefix.
</note>


## Setup


### Enabling the integration in Elastic:

1. In Kibana navigate to Management > Integrations.
2. In "Search for integrations" top bar, search `Corelight`.
3. Select the "Corelight" integration from the search results.
4. Navigate to Settings.
5. Select the "Install Corelight assets".
6. Navigate to Assets to get list of dashboards.

<note>
  This integration provides dashboards only. We recommend regularly checking and updating assets using the script from the Corelight repository. For any mapping or parsing issues, especially those not related to the dashboards, we recommend contacting Corelight, as they maintain those components.
</note>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Security Posture Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/security-posture.png)

  ![Name Resolution Insights Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/name-resolution-insights.png)

  ![Secure Channel Insights Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/secure-channel-insights.png)

  ![Remote Activity Insights Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/remote-activity-insights.png)

  ![Intel Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/intel.png)

  ![IP Interrogation Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/ip-interrogation.png)

  ![Log Hunting Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/log-hunting.png)

  ![Notices Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/notices.png)

  ![RDP Inferences Overview Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/rdp-inferences-overview.png)

  ![SSH Inferences Overview Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/ssh-inferences-overview.png)

  ![Corelight Suricata IDS Alert Overview Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/corelight-suricata-ids-alert-overview.png)

  ![VPN Insights Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/vpn-insights.png)

  ![Connections Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/connections.png)

  ![DNS Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/dns.png)

  ![Files Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/files.png)

  ![HTTP Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/http.png)

  ![Software Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/software.png)

  ![SSL and x509 Dashboard Screenshot](https://epr.elastic.co/package/corelight/1.0.0/img/ssl-and-x509.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                 | Minimum Kibana version |
  |-----------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14141))Release package as GA.                                                                                                                                         | 9.0.08.16.0            |
  | **0.8.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                     |                        |
  | **0.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12665))Enable "Paginate table" toggle and display all available columns of table visualization, and add Less Secure TLS version visualization to relevant dashboards. |                        |
  | **0.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12634))Update saved search of all dashboards to include only timestamps and summary of parsed logs.                                                                   |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12452))Add data explorer dashboards.                                                                                                                                  |                        |
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12215))Add security workflows dashboards.                                                                                                                             |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11998))Added an alert insight panel and updated the VPN connections visualization to a line chart in the security posture dashboard.                                  |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11649))Update inferences field to ssh.inferences for ssh log type.                                                                                                    |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11288))Initial release.                                                                                                                                               |                        |
</dropdown>