﻿---
title: Security Posture Management
description: Use the Security Posture Management integration to maintain the confidentiality, integrity, and availability of your data in the cloud by continuously...
url: https://www.elastic.co/docs/reference/integrations/cloud_security_posture
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Security Posture Management
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.2.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.3.0                          |

Use the Security Posture Management integration to maintain the **confidentiality, integrity, and availability** of your data in the cloud by continuously identifying configuration risks and vulnerabilities in your cloud infrastructure, like publicly exposed storage buckets, overly permissive networking objects and Log4j vulnerability in workloads. Read below to learn more about the components that make up security posture management; CSPM, KSPM and CNVM.

## Cloud Security Posture Management (CSPM)

CSPM discovers and evaluates the services in your cloud environment, like storage, compute, IAM, and more, against hardening guidelines defined by the Center for Internet Security (CIS) to help you identify and remediate configurations risks like:
- Publicly exposed storage buckets
- IAM Users without MFA enabled
- Networking objects that allow ingress to remote server administration ports (22, 3389, etc.)

And much more! For a complete overview of CSPM, including step-by-step getting started guidance, check out [CSPM's documentation](https://ela.st/cspm).

## Kubernetes Security Posture Management (KSPM)

KSPM discovers and evaluates the components that make up your Kubernetes cluster against hardening guidelines defined by the [Center for Internet Security](https://www.cisecurity.org/) (CIS) to help you identify and remediate configurations risks like:
- Kubelete servers that allow anonymous auth
- Unencrypted traffic to load balancers
- Admission of containers with `allowPrivilegeEscalation` permissions

And much more! Check out the [KSPM getting started guide](https://ela.st/kspm-get-started) for step-by-step guidance on how to get started with KSPM.

## Cloud Native Vulnerability Management (CNVM)

Cloud Native Vulnerability Management (CNVM) - an efficient and comprehensive solution designed to discover and scan workloads to identify vulnerabilities in your cloud environment. With CNVM, you can effortlessly identify vulnerabilities in your cloud workloads like OS package vulnerabilities, and language-specific packages, among others. Our user-friendly interface also simplifies the process of triaging vulnerabilities and provides detailed vulnerability scan results in a concise and informative manner.
Check out the [CNVM getting started guide](https://ela.st/cnvm-get-started) for step-by-step guidance on how to get started with CNVM.

## Using C/KSPM & CNVM

To use CSPM, KSPM and CNVM, you'll have to deploy each integration separately. After deploying integrations, the pages described below will begin to get populated with security posture data. Please read the respective use cases section for [CSPM](https://ela.st/cspm-use-cases) and [KSPM](https://ela.st/kspm-use-cases) for step-by-step instructions on how to use these pages to get insight into and improve your cloud security posture.

| Page              | Description                                                                                                                                                                                                                                                                                                                                                                        |
|-------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Posture Dashboard | The posture dashboard provides an overview of the security posture of both Cloud accounts and Kubernetes clusters monitored. You can access the posture dashboard via the dashboards section of the security solution. Please read the [posture dashboard documentation](https://ela.st/posture-dashboard) to learn more.                                                          |
| Findings          | Findings communicate the configuration risks and vulnerabilities discovered in your environments. The findings page will always display the most up-to-date configuration risks and vulnerabilities found. You can access the findings page in the main navigation pane of the security solution. Please read the [findings documentation](https://ela.st/findings) to learn more. |
| Benchmark Rules   | Benchmarks hold the configuration rules that are used to assess your specific environments for secure configuration. You can access benchmark rules in the `Manage` section of the security solution under `CLOUD SECURITY POSTURE.` To learn more, please read the [benchmark rules documentation](https://ela.st/configuration-rules)                                            |


As questions come up, check out the [KSPM FAQ](https://ela.st/kspm-faq), [CSPM FAQ](https://ela.st/cspm-faq), [CNVM FAQ](https://ela.st/cnvm-faq) or reach out to use directly in our [community slack workspace](https://elasticstack.slack.com/) in the `#security` or `#cloud-security` channels.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Dashboard page](https://epr.elastic.co/package/cloud_security_posture/3.2.1/img/dashboard.png)

  ![Findings page](https://epr.elastic.co/package/cloud_security_posture/3.2.1/img/findings.png)

  ![Detailed view of a single finding](https://epr.elastic.co/package/cloud_security_posture/3.2.1/img/findings-flyout.png)

  ![Benchmarks page](https://epr.elastic.co/package/cloud_security_posture/3.2.1/img/benchmarks.png)

  ![Rules page](https://epr.elastic.co/package/cloud_security_posture/3.2.1/img/rules.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17036))GCP infra manager link                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.3.0                  |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16928))Bump up pre-release version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.3.0                  |
  | **3.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15847))Update integration's team ownership.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.2.0                  |
  | **3.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out documents containing an error message from latest vulnerability and misconfiguration indexes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.0                  |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15676))Release version 3.1.0**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15508))Bumped links for Cloud Formation, ARM and GCP Deployment Manager to 9.2.0**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15486))Fixing broken json**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` and `misconfiguration_workflow` sub category labels.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15326))Adding the input type "cloud_connector_id" for Azure**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14532))Update Indentation and adding JSON tags on some rules.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15270))Change misconfiguration latest transform retention_policy to 26h**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15255))Add azure supports cloud connectors and secrets**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15255))Add Cloud Connectors variables for Azure CSPM input                                                                                                                                                                                                                                                                                                                                                                   | 9.2.0                  |
  | **3.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14791))Save GCP Project ID as string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.1.0                  |
  | **3.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14565))Release version 3.0.0.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14532))Add latest Transform to misconfiguration findings to 3.00 version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.0                  |
  | **2.0.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14530))Update the minimum supported Kibana version for the upcoming release.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14466))Fix GCP ARM, Cloud Shell and Cloud Connectors version**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13866))Remove project_id and organization_id from validation**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13714))Fix the Azure credentials validation**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13582))Populate event.outcome field with value from result.evaluation**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13652))Remove unused azure credentials.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13444))Add latest Transform to misconfiguration findings.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13488))Update Cloud Connector fields for CSPM**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13437))Revert bumping branch references on arm templates and gcp cloud shell**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13390))Bump up pre-release version                                                                                  | 8.19.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13053))Promote integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13048))Fix GCP Organization Agentless validation**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12859))Remove azure.credentials.client_certificate_password from required_vars**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12565))Bump template's version**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12363))Add support for conditional required fields and default deployment mode agentless**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12329))Add AWS external_id for cloud connectors flow"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12066))Changed the agentless tags to be a list**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11663))Add cloud connectors support                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.17.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11711))Promote integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11437))Lowercase host.name**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11438))Bump version**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11203))Add deployment_mode agentless to the policy template**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11271))Adding deployment_modes to cspm policy template and secret field linting checks**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11274))Bump package to include new kibana condition**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10479))Change gcp.credentials.json secret to true**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11030))Add observer.vendor field mappings**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10945))Add observer.vendor field**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10913))Deprecate vulneravility data views assets.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10767))Deprecate data views assets.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10706))Add `related.entity` to cspm**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10669))Bump up pre-release version | 9.0.08.16.0            |
  | **1.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11017))Add observer.vendor field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.15.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10667))Promote integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10298))Support conditions in CSPM and KSPM**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10208))Change field type to password where isSecret is true**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10359))Bump version**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9828))Add cloud formation template url to create direct access keys credentials                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.15.0                 |
  | **1.9.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9788))Revert secret of textarea field**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9624))Bump cloudbeat version**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9470))Update findings ingest pipeline to remove empty cloud.account.id and cloud.account.name**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9434))Fix cluster_id missing error in the Ingest Pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9331))Convert fields to secrets                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.14.0                 |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9331))Bump up version**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9213))Add cloudsecurity_cdr sub category label.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9211))Add missing CIS Azure rule templates**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8799))Rollback CIS Azure Rules 9.3,9.10**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8797))Rollback secrets adoption**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8778))Add CIS Azure Rules 6.1,.6.2,6.3,6.4**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8720))Add missing ECS orchestrator fields**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8665))Adopt Secrets**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9168))Bump version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8679))Remove disabled fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8661))8.12 version bump**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8653))Azure rule templates update**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8619))Bump Azure template branch**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8581))Support Azure Management groups**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8540))Add CIS Azure 5.3.1**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8516))Update all CSPM providers to run every 24h**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8376))Azure credentials configuration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8366))CloudFormation version hardening                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.12.0                 |
  | **1.6.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8300))GCP Organization Id as string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.11.0                 |
  | **1.6.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8228))Assign default GCP account type**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8246))Base CloudFormation url only on version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.11.0                 |
  | **1.6.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8226))Update URL for AWS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.11.0                 |
  | **1.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8162))Change the format_version in the package manifest to 3.0.0. Remove dotted YAML keys from package manifest. Add owner.type elastic to package manifest. Add missing object_type fields. Add security capability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.11.0                 |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8092))Update ARM link for Azure                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.11.0                 |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8043))Support multiple installations on the same agent policy**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7892))Add support for Azure benchmark**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7403))Add support for GCP organizations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.11.0                 |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7546))Refactor GCP credentials**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7605))Validate OrganizationalUnitIds in CloudFormation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.10.0                 |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7493))Bump version to 1.5.1**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7485))Remove capitalization and change type for tags                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.10.0                 |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7390))Add CIS GCP rule templates**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7379))Remove default value for project id**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1176))Add vulnerability mappings**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7048))Ensure event.kind is correctly set for pipeline errors.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7235))Add a cloudshell url for the GCP CSPM integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7185))Added ingest processor to copy cluster_id to orchestrator.cluster.id**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6899))Seperate KSPM and CSPM cloudformation templates**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6687))Modify CIS GCP config**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6682))Support AWS Organization onboarding option**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6699))Update CloudFormation template to use al2023 AMI and increased EBS volume size                                                                                                                                                                                                                                                                                              | 8.10.0                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6089))Populate new CloudFormation param ElasticArtifactServer**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6034))Send short notation of ElasticAgentVersion**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6622))Fix CIS 1.1.19 rule                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5266))New vulnerability management integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5872))Support ECS orchestrator.cluster.id field**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5841))Added vulnerability management period and removing region**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5898))Change CSPM resource collection period**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6069))Update CNVM index mapping**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6067))Add CIS AWS rules 1.16, 1.17, 1.19, 1.20, 2.1.5, 2.3.3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.8.0                  |
  | **1.2.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5133))Fixed readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.0                  |
  | **1.2.10** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5271))Add GCP/Azure streams**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5269))Fix beta version**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5267))Add GCP/Azure streams**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5199))Add CSPM/KSPM icons**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5054))move rule_number field to benchmark.rule_number**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5253))Add RDS fetcher to the AWS CSPM hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.0                  |
  | **1.2.9**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5163))Add monitoring fetcher to the aws cspm hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.0                  |
  | **1.2.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5101))Add cloud fields to mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.0                  |
  | **1.2.7**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5091))Add a cloudtrail fetcher to the aws cspm hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.0                  |
  | **1.2.6**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5035))Add posture_type field to mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.0                  |
  | **1.2.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4968))Add S3 fetcher to the AWS CSPM hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.0                  |
  | **1.2.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4878))Remove state from csp rule template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.0                  |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4954))Add a network fetcher to the aws cspm hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.0                  |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4931))Update cspm hbs file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.0                  |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4920))Update CSP mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4913))CSPM support spaces for 8.7.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.0                  |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4891))CSPM support spaces for 8.7.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.0                  |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4885))CSPM support spaces for 8.6 - fix                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                  |
  | **1.0.9**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4804))CSPM support spaces for 8.6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4752))Introduce CSPM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.0                  |
  | **1.0.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4682))Update screenshots and icon                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.0.7**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4664))Add KSPM to integration name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.0.6**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4496))Removing the rule data yaml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.0.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4504))Documentation bugfix                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.5.0                  |
  | **1.0.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4454))Updated mapping to include orchastrator.cluster.name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4470))Updated the readme to remove the broken internal link                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4332))Add AWS EKS documentation for KSPM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.5.0                  |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4392))Add security category to package metadata.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.5.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4362))Cloud Security Posture integration is now GA.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.5.0                  |
  | **0.0.33** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4359))Remove unconfigurable default fields from hbs files                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **0.0.32** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4016))Add event property to finding, this event match the event spec of the ECS .cycle_id mapping is removed as it is no longer reported by the Cloudbeat.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **0.0.31** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4145))Store beat configuration file to be propagated to cloudbeat                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.30** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4168))Add AWS additional auth to KSPM integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.29** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4146))Update min age for delete to 180 days                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                        |
  | **0.0.28** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4039))Add ILM policy for the findings data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.27** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3968))Update input types and var name to support runtime config                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.0.26** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3997))Version bump**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3964))Updates to KSPM Integration README                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.0.25** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3973))Remove unimplemented EKS rules from template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.0.24** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3966))Updated release tag to beta                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.23** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3912))Fix rule id typo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.0.22** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3775))Adjust findings data-stream mappings to fit ECS conventions**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3775))Turned off dynamic mappings of findings data-stream**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3775))Added default pipeline to findings data-stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.0.21** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3817))Update package display name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.20** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3726))Remove Kibana configuration section from README                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.0.19** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3701))Adding EKS rule templates**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3709))Added date time field to index patterns**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3654))Update rule benchmark field to include an id                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.0.18** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3619))enhance integration to support eks                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.0.17** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3561))Refactored csp-rule-template `metadata` field to fit 8.4.0 schema                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.0.16** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3543))update resource id keyword mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.0.15** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3541))update resource id mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.0.14** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3503))Add mapping for rule id and resource id and revert Kibana version constrain                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.13** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3505))Update Kibana version constrain                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.0.12** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3486))Add new rule templates                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.0.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3382))Update elastic-agent deployment instructions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.0.10** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3346))Update CSP rules configuration template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.0.9**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3273))Update csp rule template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.0.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3241))Send dataYaml (Rules Activation YAML) to cloudbeat                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.0.7**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3257))Add rule template assets                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.0.6**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3248))Update findings template asset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.0.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3242))Add CSP rule template asset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3183))Add latest findings data view                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3207))Change README                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3190))Change README                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3113))Initial draft of the package                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
</dropdown>