﻿---
title: Cloud Asset Discovery
description: The Cloud Asset Discovery integration helps you discover and track all the resources in your cloud environment across AWS, Google Cloud Platform (GCP),...
url: https://www.elastic.co/docs/reference/integrations/cloud_asset_inventory
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Cloud Asset Discovery
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.4.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.3.0                          |


## Overview

The Cloud Asset Discovery integration helps you discover and track all the resources in your cloud environment across AWS, Google Cloud Platform (GCP), and Microsoft Azure.

## What data does this integration collect?

Once you connect your cloud accounts, this integration automatically finds and lists your cloud services and assets, such as:
- **AWS**: S3 buckets, EC2 instances, EKS clusters, and more.
- **GCP**: Cloud Storage buckets, Compute Engine instances, Kubernetes clusters, and more.
- **Azure**: Virtual Machines, Blob Storage, Azure Kubernetes Service (AKS), and more.

[View the full list of supported services for discovery](https://github.com/elastic/cloudbeat/blob/main/internal/inventory/ASSETS.md).

### Use cases

- **Automatic Asset Discovery**: Skip the manual work. Get an up-to-date inventory of all your cloud resources in one place.
- **Complete Cloud Visibility**: View assets across AWS, GCP, and Azure in a unified interface.
- **Better Security Oversight**: Know exactly what resources you have so you can make sure they are secure and properly configured.
- **Track All Your Cloud Resources**: Get a full inventory of your cloud assets, across all accounts and providers, with minimal effort.
- **Keep an Eye on Security and Compliance**: Make sure your resources are set up correctly and follow best practices.
- **Additional Cloud Asset Context**: Gain more context about your cloud assets to help in triaging detected threats effectively.


## What do I need to use this integration?

- The Cloud Asset Discovery integration is available to all Elastic Cloud users. On-premise deployments require an [appropriate subscription](https://www.elastic.co/pricing) level.
- Cloud Asset Discovery supports only the AWS, GCP, and Azure commercial cloud platforms. Government cloud platforms are not supported. To request support for other platforms, [open a GitHub issue](https://github.com/elastic/kibana/issues/new/choose).


## How do I deploy this integration?

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **Cloud Asset Discovery**.
3. Select the **Cloud Asset Discovery** integration and add it.
4. Add all the required integration configuration parameters, including Access Token, Interval, Initial Interval and Page Size to enable data collection.
5. Save the integration.

For more information on Cloud security solutions, refer to [Cloud Security](https://www.elastic.co/docs/solutions/security/cloud)

## Changelog

<dropdown title="Changelog">
  | Version             | Details                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |---------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.4.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17036))GCP infra manager link                                                                                                                                                                   | 9.3.0                  |
  | **1.4.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16928))Bump up pre-release version                                                                                                                                                              | 9.3.0                  |
  | **1.3.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16718))Added nested entity fields for user and host                                                                                                                                             | 9.2.0                  |
  | **1.2.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15847))Update integration's team ownership                                                                                                                                                      | 9.2.0                  |
  | **1.2.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15736))Update the Cloud Asset Discovery documentation.                                                                                                                                          | 9.2.0                  |
  | **1.2.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15705))Update the Cloud Asset Discovery documentation.                                                                                                                                          | 9.2.0                  |
  | **1.2.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15676))Release version 1.2.0                                                                                                                                                                    | 9.2.0                  |
  | **1.1.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15508))Bumped links for Cloud Formation, ARM and GCP Deployment Manager to 9.2.0                                                                                                                | 9.2.0                  |
  | **1.1.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14591))Added asset_inventory category                                                                                                                                                           | 9.2.0                  |
  | **1.1.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15326))Add support for Azure Cloud Connectors cloud_connector_id                                                                                                                                | 9.2.0                  |
  | **1.1.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15237))Add support for Azure Cloud Connectors credentials                                                                                                                                       | 9.2.0                  |
  | **1.1.1-preview01** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14978))Add support for Azure Cloud Connectors**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15234))Add support for Azure Cloud Connectors Federated Identity |                        |
  | **1.0.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14591))Release version 1.0.0                                                                                                                                                                    | 9.1.0                  |
  | **0.22.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14467))Fix asset inventory cloudformation for cloud connectors                                                                                                                                      |                        |
  | **0.21.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14414))Fix required kibana version and azure and gcp links                                                                                                                                          |                        |
  | **0.20.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14405))Fix Cloud Formation templates version                                                                                                                                                        |                        |
  | **0.19.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14132))Add Cloud Formation templates for AWS agentless deployment                                                                                                                                   |                        |
  | **0.18.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14087))Add entity.source                                                                                                                                                                        |                        |
  | **0.17.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13992))Add cloud connector support Asset Inventory for AWS                                                                                                                                      |                        |
  | **0.16.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14084))Move object Attributes to flattened entity.raw                                                                                                                                           |                        |
  | **0.15.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14033))Rename type to sub_type and category to type                                                                                                                                             |                        |
  | **0.14.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13971))Fix cloud formation template URL                                                                                                                                                             |                        |
  | **0.13.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13866))Remove GCP project and organization ID from validation                                                                                                                                       |                        |
  | **0.12.0**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13768))Fix the dataview name for the asset inventory data stream                                                                                                                                    |                        |
  | **0.11.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13748))Change name to Cloud Asset Discovery                                                                                                                                                     |                        |
  | **0.10.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12363))Add required variables to the integration                                                                                                                                                |                        |
  | **0.9.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12363))Map entity.name as keyword                                                                                                                                                                   |                        |
  | **0.8.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12363))Default to agentless deployment                                                                                                                                                          |                        |
  | **0.7.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12220))Refactor field names to entity and use ECS                                                                                                                                               |                        |
  | **0.6.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12079))Update cloud provider template URLs                                                                                                                                                      |                        |
  | **0.5.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11398))Add organization support for AWS and Azure                                                                                                                                               |                        |
  | **0.4.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11481))Improve Asset Inventory UX                                                                                                                                                               |                        |
  | **0.3.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11413))Change compatibility to >=8.16                                                                                                                                                           |                        |
  | **0.2.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11417))Update README                                                                                                                                                                            |                        |
  | **0.2.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11238))Enable Agentless deployment.                                                                                                                                                             |                        |
  | **0.2.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13714))Add template variables                                                                                                                                                                   |                        |
  | **0.2.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11125))Restore Azure & GCP Asset Inventory for kibana ^8.16.0                                                                                                                                   |                        |
  | **0.1.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11091))Remove GCP/Azure Asset Inventory for kibana 8.15.0                                                                                                                                       |                        |
  | **0.1.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10976))Add GCP Asset Inventory                                                                                                                                                                  |                        |
  | **0.1.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10719))Update from related.entities to related.entity                                                                                                                                           |                        |
  | **0.1.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10688))Add related.entities field                                                                                                                                                               |                        |
  | **0.1.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10663))Add Azure Asset Inventory                                                                                                                                                                |                        |
  | **0.1.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9828))Add Cloud Asset Inventory                                                                                                                                                                 |                        |
</dropdown>