﻿---
title: Cisco Secure Endpoint Integration
description: This integration is for Cisco Secure Endpoint logs. It includes the following datasets for receiving logs over syslog or read from a file: event dataset:...
url: https://www.elastic.co/docs/reference/integrations/cisco_secure_endpoint
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Cisco Secure Endpoint Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 2.33.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

This integration is for [Cisco Secure Endpoint](https://developer.cisco.com/amp-for-endpoints/) logs. It includes the following datasets for receiving logs over syslog or read from a file:
- `event` dataset: supports Cisco Secure Endpoint Event logs.


## Logs


### Secure Endpoint

The `event` dataset collects Cisco Secure Endpoint logs.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-01-13T10:13:08.000Z",
      "agent": {
          "ephemeral_id": "abbb4be9-abee-4a11-96f8-110da8d2017d",
          "id": "2954441e-28a7-4c00-a9ff-a00856b2ffcc",
          "name": "elastic-agent-95553",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "cisco": {
          "secure_endpoint": {
              "cloud_ioc": {
                  "description": "Microsoft Word launched PowerShell. This is indicative of multiple dropper variants that make use of Visual Basic Application macros to perform nefarious activities, such as downloading and executing malicious executables.",
                  "short_description": "W32.WinWord.Powershell"
              },
              "computer": {
                  "active": true,
                  "external_ip": "8.8.8.8",
                  "network_addresses": [
                      {
                          "ip": "10.10.10.10",
                          "mac": "38:1e:eb:ba:2c:15"
                      }
                  ]
              },
              "connector_guid": "test_connector_guid",
              "event_type_id": 1107296274,
              "file": {
                  "disposition": "Clean",
                  "parent": {
                      "disposition": "Clean"
                  }
              },
              "related": {
                  "mac": [
                      "38-1E-EB-BA-2C-15"
                  ]
              }
          }
      },
      "data_stream": {
          "dataset": "cisco_secure_endpoint.event",
          "namespace": "97647",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "2954441e-28a7-4c00-a9ff-a00856b2ffcc",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "Cloud IOC",
          "agent_id_status": "verified",
          "category": [
              "file"
          ],
          "code": "1107296274",
          "created": "2025-11-24T07:32:05.588Z",
          "dataset": "cisco_secure_endpoint.event",
          "id": "1515298355162029000",
          "ingested": "2025-11-24T07:32:08Z",
          "kind": "alert",
          "original": "{\"data\":{\"cloud_ioc\":{\"description\":\"Microsoft Word launched PowerShell. This is indicative of multiple dropper variants that make use of Visual Basic Application macros to perform nefarious activities, such as downloading and executing malicious executables.\",\"short_description\":\"W32.WinWord.Powershell\"},\"computer\":{\"active\":true,\"connector_guid\":\"test_connector_guid\",\"external_ip\":\"8.8.8.8\",\"hostname\":\"Demo_AMP\",\"links\":{\"computer\":\"https://api.eu.amp.cisco.com/v1/computers/test_computer\",\"group\":\"https://api.eu.amp.cisco.com/v1/groups/test_group\",\"trajectory\":\"https://api.eu.amp.cisco.com/v1/computers/test_computer/trajectory\"},\"network_addresses\":[{\"ip\":\"10.10.10.10\",\"mac\":\"38:1e:eb:ba:2c:15\"}]},\"connector_guid\":\"test_connector_guid\",\"date\":\"2021-01-13T10:13:08+00:00\",\"event_type\":\"Cloud IOC\",\"event_type_id\":1107296274,\"file\":{\"disposition\":\"Clean\",\"file_name\":\"PowerShell.exe\",\"file_path\":\"/C:/Windows/SysWOW64/WindowsPowerShell/v1.0/PowerShell.exe\",\"identity\":{\"sha256\":\"6c05e11399b7e3c8ed31bae72014cf249c144a8f4a2c54a758eb2e6fad47aec7\"},\"parent\":{\"disposition\":\"Clean\",\"identity\":{\"sha256\":\"3d46e95284f93bbb76b3b7e1bf0e1b2d51e8a9411c2b6e649112f22f92de63c2\"}}},\"group_guids\":[\"test_group_guid\"],\"id\":1515298355162029000,\"severity\":\"Medium\",\"start_date\":\"2021-01-13T10:13:08+00:00\",\"start_timestamp\":1610532788,\"timestamp\":1610532788,\"timestamp_nanoseconds\":162019000},\"metadata\":{\"links\":{\"next\":\"http://0d71327368e2:8080/v1/events?start_date=2025-11-23T07:32:05+00:00\\u0026limit=1\\u0026offset=1\",\"self\":\"http://0d71327368e2:8080/v1/events?start_date=2025-11-23T07:32:05+00:00\\u0026limit=1\"},\"results\":{\"current_item_count\":1,\"index\":0,\"items_per_page\":1,\"total\":2}},\"version\":\"v1.2.0\"}",
          "severity": 2,
          "start": "2021-01-13T10:13:08.000Z"
      },
      "file": {
          "hash": {
              "sha256": "6c05e11399b7e3c8ed31bae72014cf249c144a8f4a2c54a758eb2e6fad47aec7"
          },
          "name": "PowerShell.exe",
          "path": "/C:/Windows/SysWOW64/WindowsPowerShell/v1.0/PowerShell.exe"
      },
      "group": {
          "id": [
              "test_group_guid"
          ]
      },
      "host": {
          "hostname": "Demo_AMP",
          "id": "test_connector_guid",
          "ip": [
              "10.10.10.10"
          ],
          "mac": [
              "38-1E-EB-BA-2C-15"
          ],
          "name": "demo_amp"
      },
      "input": {
          "type": "httpjson"
      },
      "process": {
          "hash": {
              "sha256": "3d46e95284f93bbb76b3b7e1bf0e1b2d51e8a9411c2b6e649112f22f92de63c2"
          }
      },
      "related": {
          "hash": [
              "6c05e11399b7e3c8ed31bae72014cf249c144a8f4a2c54a758eb2e6fad47aec7"
          ],
          "hosts": [
              "demo_amp"
          ],
          "ip": [
              "8.8.8.8",
              "10.10.10.10"
          ]
      },
      "tags": [
          "cisco-secure_endpoint",
          "forwarded",
          "preserve_original_event"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                      | Description                                                                                                     | Type             |
  |------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                 | Event timestamp.                                                                                                | date             |
  | cisco.secure_endpoint.bp_data                              | Endpoint isolation information                                                                                  | flattened        |
  | cisco.secure_endpoint.cloud_ioc.description                | Description of the related IOC for specific IOC events from AMP.                                                | keyword          |
  | cisco.secure_endpoint.cloud_ioc.short_description          | Short description of the related IOC for specific IOC events from AMP.                                          | keyword          |
  | cisco.secure_endpoint.command_line.arguments               | The CLI arguments related to the Cloud Threat IOC reported by Cisco.                                            | keyword          |
  | cisco.secure_endpoint.computer.active                      | If the current endpoint is active or not.                                                                       | boolean          |
  | cisco.secure_endpoint.computer.connector_guid              | The GUID of the connector, similar to top level connector_guid, but unique if multiple connectors are involved. | keyword          |
  | cisco.secure_endpoint.computer.external_ip                 | The external IP of the related host.                                                                            | ip               |
  | cisco.secure_endpoint.computer.network_addresses           | All network interface information on the related host.                                                          | flattened        |
  | cisco.secure_endpoint.connector_guid                       | The GUID of the connector sending information to AMP.                                                           | keyword          |
  | cisco.secure_endpoint.detection                            | The name of the malware detected.                                                                               | keyword          |
  | cisco.secure_endpoint.detection_id                         | The ID of the detection.                                                                                        | keyword          |
  | cisco.secure_endpoint.error.description                    | Description of an endpoint error event.                                                                         | keyword          |
  | cisco.secure_endpoint.error.error_code                     | The error code describing the related error event.                                                              | long             |
  | cisco.secure_endpoint.event_type_id                        | A sub ID of the event, depending on event type.                                                                 | long             |
  | cisco.secure_endpoint.file.archived_file.disposition       | Categorization of a file archive related to a file, for example "Malicious" or "Clean".                         | keyword          |
  | cisco.secure_endpoint.file.archived_file.identity.md5      | MD5 hash of the archived file related to the malicious event.                                                   | keyword          |
  | cisco.secure_endpoint.file.archived_file.identity.sha1     | SHA1 hash of the archived file related to the malicious event.                                                  | keyword          |
  | cisco.secure_endpoint.file.archived_file.identity.sha256   | SHA256 hash of the archived file related to the malicious event.                                                | keyword          |
  | cisco.secure_endpoint.file.attack_details.application      | The application name related to Exploit Prevention events.                                                      | keyword          |
  | cisco.secure_endpoint.file.attack_details.attacked_module  | Path to the executable or dll that was attacked and detected by Exploit Prevention.                             | keyword          |
  | cisco.secure_endpoint.file.attack_details.base_address     | The base memory address related to the exploit detected.                                                        | keyword          |
  | cisco.secure_endpoint.file.attack_details.indicators       | Different indicator types that matches the exploit detected, for example different MITRE tactics.               | flattened        |
  | cisco.secure_endpoint.file.attack_details.suspicious_files | An array of related files when an attack is detected by Exploit Prevention.                                     | keyword          |
  | cisco.secure_endpoint.file.disposition                     | Categorization of file, for example "Malicious" or "Clean".                                                     | keyword          |
  | cisco.secure_endpoint.file.parent.disposition              | Categorization of parrent, for example "Malicious" or "Clean".                                                  | keyword          |
  | cisco.secure_endpoint.group_guids                          | An array of group GUIDS related to the connector sending information to AMP.                                    | keyword          |
  | cisco.secure_endpoint.network_info.disposition             | Categorization of a network event related to a file, for example "Malicious" or "Clean".                        | keyword          |
  | cisco.secure_endpoint.network_info.nfm.direction           | The current direction based on source and destination IP.                                                       | keyword          |
  | cisco.secure_endpoint.network_info.parent.disposition      | Categorization of a IOC for example "Malicious" or "Clean".                                                     | keyword          |
  | cisco.secure_endpoint.network_info.parent.identify.sha256  | SHA256 hash of the related IOC.                                                                                 | keyword          |
  | cisco.secure_endpoint.network_info.parent.identity.md5     | MD5 hash of the related IOC.                                                                                    | keyword          |
  | cisco.secure_endpoint.network_info.parent.identity.sha1    | SHA1 hash of the related IOC.                                                                                   | keyword          |
  | cisco.secure_endpoint.related.cve                          | An array of all related CVEs                                                                                    | keyword          |
  | cisco.secure_endpoint.related.mac                          | An array of all related MAC addresses.                                                                          | keyword          |
  | cisco.secure_endpoint.scan.clean                           | Boolean value if a scanned file was clean or not.                                                               | boolean          |
  | cisco.secure_endpoint.scan.description                     | Description of an event related to a scan being initiated, for example the specific directory name.             | keyword          |
  | cisco.secure_endpoint.scan.malicious_detections            | Count of malicious files or documents detected related to a single scan event.                                  | long             |
  | cisco.secure_endpoint.scan.scanned_files                   | Count of files scanned in a directory.                                                                          | long             |
  | cisco.secure_endpoint.scan.scanned_paths                   | Count of different directories scanned related to a single scan event.                                          | long             |
  | cisco.secure_endpoint.scan.scanned_processes               | Count of processes scanned related to a single scan event.                                                      | long             |
  | cisco.secure_endpoint.tactics                              | List of all MITRE tactics related to the incident found.                                                        | flattened        |
  | cisco.secure_endpoint.techniques                           | List of all MITRE techniques related to the incident found.                                                     | flattened        |
  | cisco.secure_endpoint.threat_hunting.incident_end_time     | When the threat hunt finalized or closed.                                                                       | date             |
  | cisco.secure_endpoint.threat_hunting.incident_hunt_guid    | The GUID of the related investigation tracking issue.                                                           | keyword          |
  | cisco.secure_endpoint.threat_hunting.incident_id           | The id of the related incident for the threat hunting activity.                                                 | long             |
  | cisco.secure_endpoint.threat_hunting.incident_remediation  | Recommendations to resolve the vulnerability or exploited host.                                                 | keyword          |
  | cisco.secure_endpoint.threat_hunting.incident_report_guid  | The GUID of the related threat hunting report.                                                                  | keyword          |
  | cisco.secure_endpoint.threat_hunting.incident_start_time   | When the threat hunt was initiated.                                                                             | date             |
  | cisco.secure_endpoint.threat_hunting.incident_summary      | Summary of the outcome on the threat hunting activity.                                                          | keyword          |
  | cisco.secure_endpoint.threat_hunting.incident_title        | Title of the incident related to the threat hunting activity.                                                   | keyword          |
  | cisco.secure_endpoint.threat_hunting.severity              | Severity result of the threat hunt registered to the malicious event. Can be Low-Critical.                      | keyword          |
  | cisco.secure_endpoint.threat_hunting.tactics               | List of all MITRE tactics related to the incident found.                                                        | flattened        |
  | cisco.secure_endpoint.threat_hunting.techniques            | List of all MITRE techniques related to the incident found.                                                     | flattened        |
  | cisco.secure_endpoint.timestamp_nanoseconds                | The timestamp in Epoch nanoseconds.                                                                             | date             |
  | cisco.secure_endpoint.vulnerabilities                      | An array of related vulnerabilities to the malicious event.                                                     | flattened        |
  | cloud.image.id                                             | Image ID for the cloud instance.                                                                                | keyword          |
  | data_stream.dataset                                        | Data stream dataset.                                                                                            | constant_keyword |
  | data_stream.namespace                                      | Data stream namespace.                                                                                          | constant_keyword |
  | data_stream.type                                           | Data stream type.                                                                                               | constant_keyword |
  | event.dataset                                              | Event dataset                                                                                                   | constant_keyword |
  | event.module                                               | Event module                                                                                                    | constant_keyword |
  | host.containerized                                         | If the host is a container.                                                                                     | boolean          |
  | host.os.build                                              | OS build information.                                                                                           | keyword          |
  | host.os.codename                                           | OS codename, if any.                                                                                            | keyword          |
  | input.type                                                 | Type of Filebeat input.                                                                                         | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Cisco Secure Email Gateway dashboard screenshot](https://epr.elastic.co/package/cisco_secure_endpoint/2.33.0/img/cisco_secure_endpoint-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16092))Prevent updating fleet health status to degraded when no next link is present.                                                                                           | 9.1.49.0.78.19.4       |
  | **2.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                  | 9.0.08.15.0            |
  | **2.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13964))Improve handling of pagination end.                                                                                                                                      | 9.0.08.15.0            |
  | **2.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13746))Add dashboard.                                                                                                                                                           | 9.0.08.13.0            |
  | **2.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **2.28.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.13.0                 |
  | **2.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **2.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **2.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.13.0                 |
  | **2.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **2.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **2.24.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9006))Fix ingest pipeline conditional field handling.                                                                                                                               | 8.7.1                  |
  | **2.24.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **2.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **2.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **2.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **2.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **2.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **2.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **2.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **2.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **2.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **2.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6600))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6258))Parse out additional fields to ECS.                                                                                                                                       | 8.7.1                  |
  | **2.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6419))Remove empty fields and user.name field when Not Available.                                                                                                               | 8.7.1                  |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6057))Lowercase host.name field                                                                                                                                                 | 8.7.1                  |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                                     | 8.7.1                  |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.17.0            |
  | **2.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.17.0            |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.17.0            |
  | **2.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4719))Added processor to drop empty documents when there are no events                                                                                                              | 8.0.07.17.0            |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.17.0            |
  | **2.6.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4400))Remove duplicate fields.                                                                                                                                                      | 8.0.07.17.0            |
  | **2.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.17.0            |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3843))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.17.0            |
  | **2.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.17.0            |
  | **2.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3558))Fix rate limit reset time.                                                                                                                                                    | 8.0.07.17.0            |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.17.0            |
  | **2.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3225))update read me with link to vendor documentation                                                                                                                          | 8.0.07.17.0            |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                         | 8.0.07.17.0            |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3092))Fix typo in config template for ignoring host enrichment                                                                                                                      | 8.0.07.17.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2915))Ensure pagination exits correctly and remove possible host fields                                                                                                         |                        |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2915))Fix propagation of information from host.name.                                                                                                                            | 8.0.07.17.0            |
  | **2.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.17.0            |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2888))Adding possibility to extract host and user data if possible.                                                                                                             | 8.0.07.17.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2395))Update to ECS 8.0**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/2395))Normalize MAC address; replace host.user.name with user.name | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2360))GA integration                                                                                                                                                            | 8.0.07.16.0            |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2253))Add 8.0.0 version constraint                                                                                                                                              |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1958))Update Title and Description.                                                                                                                                             |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1645))Initial migration from Filebeat Module                                                                                                                                    |                        |
</dropdown>