﻿---
title: Cisco Nexus
description: The Cisco Nexus integration allows users to monitor Errors and System Messages. The Cisco Nexus series switches are modular and fixed port network switches...
url: https://www.elastic.co/docs/reference/integrations/cisco_nexus
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cisco Nexus
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | File, Network Protocol         |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                    |


## Overview

The [Cisco Nexus](https://www.cisco.com/c/en_my/products/switches/data-center-switches/index.html) integration allows users to monitor Errors and System Messages. The Cisco Nexus series switches are modular and fixed port network switches designed for the data center. All switches in the Nexus range run the modular NX-OS firmware/operating system on the fabric. NX-OS has some high-availability features compared to the well-known Cisco IOS. This platform is optimized for high-density 10 Gigabit Ethernet.
Use the Cisco Nexus integration to collect and parse data from Syslog and log files. Then visualize that data through search, correlation and visualization within Elastic Security.

## Data streams

The Cisco Nexus integration collects one type of data: log.
**Log** consists of errors and system messages. See more details about [errors and system messages](https://www.cisco.com/c/en/us/support/switches/nexus-9000-series-switches/products-system-message-guides-list.html)

## Requirements

Elastic Agent must be installed. For more information, refer to the link [here](https://www.elastic.co/guide/en/fleet/current/elastic-agent-installation.html).
The minimum **kibana.version** required is **8.7.0**.
This module has been tested against the **Cisco Nexus Series 9000, 3172T and 3048 Switches**.

## Setup


### To collect data from Cisco Nexus, follow the below steps:

- [Logging System Messages to a File](https://www.cisco.com/c/en/us/td/docs/switches/datacenter/nexus9000/sw/6-x/system_management/configuration/guide/b_Cisco_Nexus_9000_Series_NX-OS_System_Management_Configuration_Guide/sm_5syslog.html#task_AADF73ACC611470A8FCB903A51A438AD)
- [Configuring Syslog Servers](https://www.cisco.com/c/en/us/td/docs/switches/datacenter/nexus9000/sw/6-x/system_management/configuration/guide/b_Cisco_Nexus_9000_Series_NX-OS_System_Management_Configuration_Guide/sm_5syslog.html#task_5793349949823830091)

**NOTE:**
- Configuration steps can vary from switch to switch. We have mentioned steps for the configuration of the 9K series of switches.
- Use the Timezone Offset parameter, if the timezone is not present in the log messages.


## Logs Reference


### Log

This is the `Log` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-04-26T09:08:48.000Z",
      "agent": {
          "ephemeral_id": "520a22ce-a7c9-4d1d-83df-a6abd00f7f74",
          "id": "13671cfa-49ce-4139-8d65-90166401d5f5",
          "name": "elastic-agent-83602",
          "type": "filebeat",
          "version": "9.0.3"
      },
      "cisco_nexus": {
          "log": {
              "description": "last message repeated 3 time",
              "priority_number": 187,
              "switch_name": "switchname",
              "time": "2023-04-26T09:08:48.000Z",
              "timezone": "UTC"
          }
      },
      "data_stream": {
          "dataset": "cisco_nexus.log",
          "namespace": "90551",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "13671cfa-49ce-4139-8d65-90166401d5f5",
          "snapshot": false,
          "version": "9.0.3"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "cisco_nexus.log",
          "ingested": "2025-07-11T13:14:05Z",
          "kind": "event",
          "module": "cisco_nexus",
          "original": "<187>switchname: 2023 Apr 26 09:08:48 UTC: last message repeated 3 time",
          "timezone": "UTC"
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.22.0.3:46916"
          },
          "syslog": {
              "priority": 187
          }
      },
      "message": "last message repeated 3 time",
      "observer": {
          "name": "switchname",
          "product": "Nexus",
          "type": "switches",
          "vendor": "Cisco"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "cisco_nexus-log"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                   | Description                                                                               | Type             |
  |---------------------------------------------------------|-------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                              | Event timestamp.                                                                          | date             |
  | cisco_nexus.log.command                                 |                                                                                           | keyword          |
  | cisco_nexus.log.description                             |                                                                                           | keyword          |
  | cisco_nexus.log.euid                                    |                                                                                           | keyword          |
  | cisco_nexus.log.facility                                |                                                                                           | keyword          |
  | cisco_nexus.log.interface.mode                          |                                                                                           | keyword          |
  | cisco_nexus.log.interface.name                          |                                                                                           | keyword          |
  | cisco_nexus.log.ip_address                              |                                                                                           | ip               |
  | cisco_nexus.log.line_protocol_state                     |                                                                                           | keyword          |
  | cisco_nexus.log.logname                                 |                                                                                           | keyword          |
  | cisco_nexus.log.network.egress_interface                |                                                                                           | keyword          |
  | cisco_nexus.log.network.ingress_interface               |                                                                                           | keyword          |
  | cisco_nexus.log.operating_value                         |                                                                                           | keyword          |
  | cisco_nexus.log.operational.duplex_mode                 |                                                                                           | keyword          |
  | cisco_nexus.log.operational.receive_flow_control_state  |                                                                                           | keyword          |
  | cisco_nexus.log.operational.speed                       |                                                                                           | keyword          |
  | cisco_nexus.log.operational.transmit_flow_control_state |                                                                                           | keyword          |
  | cisco_nexus.log.priority_number                         |                                                                                           | long             |
  | cisco_nexus.log.pwd                                     |                                                                                           | keyword          |
  | cisco_nexus.log.rhost                                   |                                                                                           | keyword          |
  | cisco_nexus.log.ruser                                   |                                                                                           | keyword          |
  | cisco_nexus.log.sequence_number                         |                                                                                           | long             |
  | cisco_nexus.log.severity                                |                                                                                           | long             |
  | cisco_nexus.log.slot_number                             |                                                                                           | long             |
  | cisco_nexus.log.standby                                 |                                                                                           | keyword          |
  | cisco_nexus.log.state                                   |                                                                                           | keyword          |
  | cisco_nexus.log.switch_name                             |                                                                                           | keyword          |
  | cisco_nexus.log.syslog_time                             |                                                                                           | date             |
  | cisco_nexus.log.terminal                                |                                                                                           | keyword          |
  | cisco_nexus.log.threshold_value                         |                                                                                           | keyword          |
  | cisco_nexus.log.time                                    |                                                                                           | date             |
  | cisco_nexus.log.timezone                                |                                                                                           | keyword          |
  | cisco_nexus.log.tty                                     |                                                                                           | keyword          |
  | cisco_nexus.log.type                                    |                                                                                           | keyword          |
  | cisco_nexus.log.uid                                     |                                                                                           | keyword          |
  | data_stream.dataset                                     | Data stream dataset.                                                                      | constant_keyword |
  | data_stream.namespace                                   | Data stream namespace.                                                                    | constant_keyword |
  | data_stream.type                                        | Data stream type.                                                                         | constant_keyword |
  | event.dataset                                           | Event dataset.                                                                            | constant_keyword |
  | event.module                                            | Event module.                                                                             | constant_keyword |
  | input.type                                              | Type of Filebeat input.                                                                   | keyword          |
  | log.file.device_id                                      | ID of the device containing the filesystem where the file resides.                        | keyword          |
  | log.file.fingerprint                                    | The sha256 fingerprint identity of the file when fingerprinting is enabled.               | keyword          |
  | log.file.idxhi                                          | The high-order part of a unique identifier that is associated with a file. (Windows-only) | keyword          |
  | log.file.idxlo                                          | The low-order part of a unique identifier that is associated with a file. (Windows-only)  | keyword          |
  | log.file.inode                                          | Inode number of the log file.                                                             | keyword          |
  | log.file.vol                                            | The serial number of the volume that contains a file. (Windows-only)                      | keyword          |
  | log.offset                                              | Log offset.                                                                               | long             |
  | log.source.address                                      | Source address from which the log event was read / sent from.                             | keyword          |
  | tags                                                    | User defined tags.                                                                        | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Cisco Nexus Overview Dashboard Screenshot](https://epr.elastic.co/package/cisco_nexus/1.5.0/img/cisco-nexus-overview-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15798))Preserve event.original on pipeline error.                                                                                                                               | 9.0.08.11.0            |
  | **1.4.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15533))Generate processor tags and normalize error handler.                                                                                                                     | 9.0.08.11.0            |
  | **1.4.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15468))Fix whitespace issue with grok pattern.                                                                                                                                      | 9.0.08.11.0            |
  | **1.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                          | 9.0.08.11.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14504))Fix bug that did not recognize timestamps to use tz_map override.                                                                                                            | 9.0.08.11.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                               | 9.0.08.11.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.11.0                 |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12569))ECS version updated to 8.17.0.                                                                                                                                           | 8.11.0                 |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.11.0                 |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9570))Fix ingest pipeline warnings                                                                                                                                                  | 8.7.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                             | 8.7.0                  |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8833))Release package as GA.                                                                                                                                                    | 8.7.0                  |
  | **0.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    |                        |
  | **0.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            |                        |
  | **0.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    |                        |
  | **0.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8014))Adapt fields for changes in file system info                                                                                                                              |                        |
  | **0.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            |                        |
  | **0.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. |                        |
  | **0.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      |                        |
  | **0.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              |                        |
  | **0.14.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7105))Remove confusing error message tag prefix.                                                                                                                                    |                        |
  | **0.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6664))Add support for new log format.                                                                                                                                           |                        |
  | **0.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6600))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   |                        |
  | **0.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6467))Replace RSA2ELK with Syslog integration.                                                                                                                                  |                        |
  | **0.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              |                        |
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                                     |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              |                        |
  | **0.7.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4400))Remove duplicate fields.                                                                                                                                                      |                        |
  | **0.7.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4327))Remove duplicate field.                                                                                                                                                     |                        |
  | **0.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3843))Update package to ECS 8.4.0                                                                                                                                               |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              |                        |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2934))Updated readme file                                                                                                                                                       |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2.0                                                                                                                                                       |                        |
  | **0.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2581))Update to ECS 8.0.0                                                                                                                                                       |                        |
  | **0.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2250))Add 8.0.0 version constraint                                                                                                                                              |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1957))Update Title and Description.                                                                                                                                             |                        |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1882))Fixed a bug that prevents the package from working in 7.16.                                                                                                                   |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1809))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1786))Update to ECS 1.12.0                                                                                                                                                      |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1588))Initial implementation for splitting Cisco nexus from Cisco package                                                                                                       |                        |
</dropdown>