﻿---
title: Cisco ISE
description: The Cisco ISE integration collects and parses data from Cisco Identity Services Engine (ISE) using TCP/UDP. This module has been tested against Cisco...
url: https://www.elastic.co/docs/reference/integrations/cisco_ise
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cisco ISE
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.31.2 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |

The Cisco ISE integration collects and parses data from [Cisco Identity Services Engine](https://www.cisco.com/c/en/us/products/security/identity-services-engine/index.html) (ISE) using TCP/UDP.

## Compatibility

This module has been tested against `Cisco ISE server version 3.1.0.518`.

## Requirements

- Enable the integration with the TCP/UDP input.
- Sign in to Cisco ISE Portal.
- Configure Remote Syslog Collection Locations.
  - **Procedure**
  1. In Cisco ISE Administrator Portal, go to **Administration** > **System** > **Logging** > **Remote Logging Targets**.
2. Click **Add**.
   ![Cisco ISE server setup image](https://www.elastic.co/docs/reference/integrations/images/cisco_ise/cisco-ise-setup.png)
3. Enter all the **Required Details**.
4. Set the maximum length to **8192**.
5. Click **Submit**.
6. Go to the **Remote Logging Targets** page and verify the creation of the new target.


## Note

- It is recommended to have **8192** as Maximum Message Length. Segmentation for certain logs coming from Cisco ISE might cause issues with field mappings.


## Logs

Reference link for Cisco ISE Syslog: [Here](https://www.cisco.com/c/en/us/td/docs/security/ise/syslog/Cisco_ISE_Syslogs/m_SyslogsList.html)

### log

This is the `log` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-04-27T11:11:47.028-08:00",
      "agent": {
          "ephemeral_id": "6c81402f-0755-47b6-bc90-21791e9df481",
          "id": "7d678a1a-bd1e-4279-b210-634e520569c3",
          "name": "elastic-agent-25731",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "cisco_ise": {
          "log": {
              "acct": {
                  "authentic": "RADIUS",
                  "session": {
                      "id": "00000000/d4:ca:6d:14:87:3b/20879"
                  },
                  "status": {
                      "type": "Start"
                  }
              },
              "acs": {
                  "session": {
                      "id": "hijk.example.com/176956368/1092777"
                  }
              },
              "airespace": {
                  "wlan": {
                      "id": 1
                  }
              },
              "allowed_protocol": {
                  "matched": {
                      "rule": "Default"
                  }
              },
              "called_station": {
                  "id": "00-24-97-69-7a-c0"
              },
              "calling_station": {
                  "id": "d4-ca-6d-14-87-3b"
              },
              "category": {
                  "name": "CISE_RADIUS_Accounting"
              },
              "class": "CACS:0a2025060001794f52cfa877:hijk.example.com/176956368/1092772",
              "config_version": {
                  "id": 33
              },
              "cpm": {
                  "session": {
                      "id": "0a222bc0000000d123e111f0"
                  }
              },
              "event": {
                  "timestamp": "2014-01-10T07:59:55.000Z"
              },
              "framed": {
                  "ip": "81.2.69.145"
              },
              "location": "Location#All Locations#SJC#WNBU",
              "message": {
                  "code": "3000",
                  "description": "Radius-Accounting: RADIUS Accounting start request",
                  "id": "0000070618"
              },
              "nas": {
                  "identifier": "Acme_fe:56:00",
                  "ip": "81.2.69.145",
                  "port": {
                      "number": 13,
                      "type": "Wireless - IEEE 802.11"
                  }
              },
              "network": {
                  "device": {
                      "groups": [
                          "Location#All Locations#SJC#WNBU",
                          "Device Type#All Device Types#Wireless#WLC"
                      ],
                      "name": "WNBU-WLC1"
                  }
              },
              "request": {
                  "latency": 6
              },
              "segment": {
                  "number": 0,
                  "total": 1
              },
              "selected": {
                  "access": {
                      "service": "Default Network Access"
                  }
              },
              "step": [
                  "11004",
                  "11017",
                  "15049",
                  "15008",
                  "15048",
                  "15048",
                  "15048",
                  "15004",
                  "15006",
                  "11005"
              ],
              "tunnel": {
                  "medium": {
                      "type": "(tag=0) 802"
                  },
                  "private": {
                      "group_id": "(tag=0) 70"
                  },
                  "type": "(tag=0) VLAN"
              }
          }
      },
      "client": {
          "ip": "81.2.69.145"
      },
      "data_stream": {
          "dataset": "cisco_ise.log",
          "namespace": "46135",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "7d678a1a-bd1e-4279-b210-634e520569c3",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "action": "radius-accounting",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "code": "3000",
          "dataset": "cisco_ise.log",
          "ingested": "2025-04-23T06:54:05Z",
          "kind": "event",
          "sequence": 91827141,
          "timezone": "-08:00",
          "type": [
              "info"
          ]
      },
      "host": {
          "hostname": "hijk.example.com"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "level": "notice",
          "source": {
              "address": "192.168.253.1:51868"
          },
          "syslog": {
              "priority": 182,
              "severity": {
                  "name": "notice"
              }
          }
      },
      "message": "2020-04-27 11:11:47.028075 -08:00 0091827141 3000 NOTICE Radius-Accounting: RADIUS Accounting start request, ConfigVersionId=33, Device IP Address=81.2.69.145, RequestLatency=6, NetworkDeviceName=WNBU-WLC1, User-Name=nisehorrrrn, NAS-IP-Address=81.2.69.145, NAS-Port=13, Framed-IP-Address=81.2.69.145, Class=CACS:0a2025060001794f52cfa877:hijk.example.com/176956368/1092772, Called-Station-ID=00-24-97-69-7a-c0, Calling-Station-ID=d4-ca-6d-14-87-3b, NAS-Identifier=Acme_fe:56:00, Acct-Status-Type=Start, Acct-Session-Id=00000000/d4:ca:6d:14:87:3b/20879, Acct-Authentic=RADIUS, Event-Timestamp=1389340795, NAS-Port-Type=Wireless - IEEE 802.11, Tunnel-Type=(tag=0) VLAN, Tunnel-Medium-Type=(tag=0) 802, Tunnel-Private-Group-ID=(tag=0) 70, Airespace-Wlan-Id=1, AcsSessionID=hijk.example.com/176956368/1092777, SelectedAccessService=Default Network Access, Step=11004, Step=11017, Step=15049, Step=15008, Step=15048, Step=15048, Step=15048, Step=15004, Step=15006, Step=11005, NetworkDeviceGroups=Location#All Locations#SJC#WNBU, NetworkDeviceGroups=Device Type#All Device Types#Wireless#WLC, CPMSessionID=0a222bc0000000d123e111f0, AllowedProtocolMatchedRule=Default, Location=Location#All Locations#SJC#WNBU, Device Type=Device Type#All Device Types#Wireless#WLC",
      "related": {
          "hosts": [
              "hijk.example.com"
          ],
          "ip": [
              "81.2.69.145"
          ],
          "user": [
              "nisehorrrrn"
          ]
      },
      "tags": [
          "forwarded",
          "cisco_ise-log"
      ],
      "user": {
          "name": "nisehorrrrn"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                  | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | date             |
  | cisco_ise.log.acct.authentic                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acct.delay_time                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.input.octets                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.input.packets                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.output.octets                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.output.packets                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.request.flags                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acct.session.id                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acct.session.time                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.acct.status.type                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acct.terminate_cause                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acme-av-pair.audit-session-id                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acme-av-pair.service-type                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acs.instance                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.acs.session.id                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.active_session.count                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.ad.admin                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.domain.controller                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.domain.name                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.error.details                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.forest                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.hostname                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.ip                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | cisco_ise.log.ad.log                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.log_id                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.organization_unit                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | cisco_ise.log.ad.site                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.srv.query                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ad.srv.record                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.adapter_instance.name                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.adapter_instance.uuid                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.admin.interface                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.admin.session                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.airespace.wlan.id                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.allow.easy.wired.session                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.allowed_protocol.matched.rule                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.assigned_targets                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.auth.policy.matched.rule                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.authen_method                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.authentication.identity_store                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.authentication.method                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.authentication.status                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.average.radius.request.latency                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.average.tacacs.request.latency                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.disc.cause                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.disc.cause_ext                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.elapsed_time                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.pre_session_time                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.priv_lvl                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.avpair.start_time                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.avpair.stop_time                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.avpair.task_id                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.avpair.timezone                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.called_station.id                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.calling_station.id                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.calling_station_id                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.category.name                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cause                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.AuthenticationIdentityStore     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.audit-session-id                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.coa-push                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | cisco_ise.log.cisco_av_pair.cts-device-capability           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.cts-environment-data            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.cts-environment-version         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.cts-pac-opaque                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.device-uid-global               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.ac-user-agent           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.computer-name           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-mac              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-platform         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-platform-version |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-public-mac       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-type             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-uid              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cisco_av_pair.mdm-tlv.device-uid-global       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.class                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.client.latency                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.cmdset                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.component                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.config_change.data                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.config_version.id                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.connectivity                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.cpm.session.id                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.currentid.store_name                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.delta.radius.request.count                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.delta.tacacs.request.count                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.detailed_info                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | cisco_ise.log.details                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.device.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.device.registration_status                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.device.type                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.dtls_support                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.eap.authentication                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.eap.chaining_result                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.eap.tunnel                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.eap_key.name                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.enable.flag                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.coa                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.mac.address                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.policy                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.profiler                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.purge.id                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.purge.rule                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.endpoint.purge.scheduletype                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ep.identity_group                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ep.mac.address                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.error.message                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.error_message                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.event.timestamp                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.failure.flag                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | cisco_ise.log.failure.reason                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.failure_reason                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.feed_service.feed.name                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.feed_service.feed.version                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.feed_service.host                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.feed_service.port                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.feed_service.query.from_time                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.feed_service.query.to_time                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.file.name                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.first_name                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.framed.ip                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | cisco_ise.log.framed.mtu                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.groups.process_failure                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | cisco_ise.log.guest.user.name                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.identity.group                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.identity.policy.matched.rule                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.identity.selection.matched.rule               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.ipsec                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.is_third_party_device_flow                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | cisco_ise.log.ise.policy.set_name                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.last_name                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.local_logging                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.location                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.log_details                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | cisco_ise.log.log_error.message                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.log_severity_level                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.logger.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.message.code                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.message.description                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | cisco_ise.log.message.id                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.message.text                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.misconfigured.client.fix.reason               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.model.name                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.nas.identifier                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.nas.ip                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | cisco_ise.log.nas.port.id                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.nas.port.number                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.nas.port.type                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.nas_identifier                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.nas_ip_address                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network.device.groups                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network.device.name                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network.device.profile                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network.device.profile_id                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network.device.profile_name                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.network_device_ip                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | cisco_ise.log.network_device_name                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.object.internal.id                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.object.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.object.type                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.objects.purged                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.openssl.error.message                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.openssl.error.stack                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.operation.id                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.operation.status                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.operation.type                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.operation_counters.counters                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | cisco_ise.log.operation_counters.original                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | cisco_ise.log.operation_message.text                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.original.user.name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.policy.type                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.port                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.portal.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.posture.assessment.status                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.privilege.level                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.probe                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.profiler.server                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.protocol                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.psn.hostname                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.radius.flow.type                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.radius.packet.type                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.radius_identifier                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.radius_packet.type                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.request.latency                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.request.received_time                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | cisco_ise.log.request_response.type                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.response                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | cisco_ise.log.segment.number                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.segment.total                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.selected.access.service                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.selected.authentication.identity_stores       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.selected.authorization.profiles               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.sequence.number                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.server.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.server.type                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.service.argument                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.service.name                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.service.type                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.session.timeout                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.severity.level                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.software.version                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.state                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | cisco_ise.log.static.assignment                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | cisco_ise.log.status                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.step                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.step_data                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.step_latency                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.sysstats.acs.process.health                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | cisco_ise.log.sysstats.cpu.count                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.sysstats.process_memory_mb                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.sysstats.utilization.cpu                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | cisco_ise.log.sysstats.utilization.disk.io                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | cisco_ise.log.sysstats.utilization.disk.space               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.sysstats.utilization.load_avg                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | cisco_ise.log.sysstats.utilization.memory                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | cisco_ise.log.sysstats.utilization.network                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.tls.cipher                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.tls.version                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.total.authen.latency                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.total.failed_attempts                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.total.failed_time                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | cisco_ise.log.tunnel.medium.type                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.tunnel.private.group_id                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.tunnel.type                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.type                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.undefined_52                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.usecase                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.user.type                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco_ise.log.workflow                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | client.geo.city_name                                        | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | client.geo.continent_code                                   | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | client.geo.continent_name                                   | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | client.geo.country_iso_code                                 | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | client.geo.country_name                                     | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | client.geo.location                                         | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | client.geo.name                                             | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | client.geo.postal_code                                      | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | client.geo.region_iso_code                                  | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | client.geo.region_name                                      | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | client.geo.timezone                                         | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | client.ip                                                   | IP address of the client (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | client.mac                                                  | MAC address of the client. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | client.port                                                 | Port of the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | client.user.domain                                          | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | client.user.email                                           | User email address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | client.user.name                                            | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | client.user.name.text                                       | Multi-field of `client.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | cloud.account.id                                            | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone                                     | Availability zone in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.image.id                                              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                                           | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                                         | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                                          | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                                            | Name of the project in Google Cloud.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cloud.provider                                              | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                                                | Region in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | container.id                                                | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                                        | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                                            | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                                              | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                                         | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                                       | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.type                                            | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | destination.address                                         | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                                       | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name                            | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text                       | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.bytes                                           | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | destination.domain                                          | The domain name of the destination system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.city_name                                   | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_code                              | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | destination.geo.continent_name                              | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code                            | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name                                | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location                                    | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                                        | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.postal_code                                 | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_iso_code                             | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name                                 | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.geo.timezone                                    | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.ip                                              | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.nat.ip                                          | Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | ip               |
  | destination.nat.port                                        | Port the source session is translated to by NAT Device. Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | destination.packets                                         | Packets sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | destination.port                                            | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | destination.user.name                                       | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.user.name.text                                  | Multi-field of `destination.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | ecs.version                                                 | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | event.category                                              | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.code                                                  | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.created                                               | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                                               | Event dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | constant_keyword |
  | event.kind                                                  | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                                                | Event module.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.original                                              | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                   | keyword          |
  | event.sequence                                              | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision.                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | event.type                                                  | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                                           | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                                          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                                                 | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.geo.city_name                                          | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.geo.continent_code                                     | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.geo.continent_name                                     | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | host.geo.country_iso_code                                   | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.geo.country_name                                       | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | host.geo.location                                           | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | host.geo.name                                               | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.geo.postal_code                                        | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.geo.region_iso_code                                    | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.geo.region_name                                        | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.geo.timezone                                           | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.hostname                                               | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                                                     | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                                                     | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                                                    | Host mac addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.name                                                   | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.os.build                                               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                                            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                                              | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                                              | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                                                | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                                           | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | text             |
  | host.os.platform                                            | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                                             | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                                                   | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                                                  | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | log.file.device_id                                          | ID of the device containing the filesystem where the file resides.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | log.file.fingerprint                                        | The sha256 fingerprint identity of the file when fingerprinting is enabled.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | log.file.idxhi                                              | The high-order part of a unique identifier that is associated with a file. (Windows-only)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | log.file.idxlo                                              | The low-order part of a unique identifier that is associated with a file. (Windows-only)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | log.file.inode                                              | Inode number of the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | log.file.path                                               | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.file.vol                                                | The serial number of the volume that contains a file. (Windows-only)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.level                                                   | Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.logger                                                  | The name of the logger inside an application. This is usually the name of the class which initialized the logger, or can be a custom name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | log.offset                                                  | Log offset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | log.source.address                                          | Source address from which the log event was read / sent from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | log.syslog.priority                                         | Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | log.syslog.severity.name                                    | The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different severity value (e.g. firewall, IDS), your source's text severity should go to `log.level`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `log.level`.                                                                                                                                                                                                                                                                                  | keyword          |
  | message                                                     | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | network.protocol                                            | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | related.hosts                                               | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | related.ip                                                  | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | related.user                                                | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | server.address                                              | Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | server.mac                                                  | MAC address of the server. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | service.type                                                | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.address                                              | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                                            | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name                                 | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text                            | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.bytes                                                | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | source.domain                                               | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.geo.city_name                                        | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_code                                   | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | source.geo.continent_name                                   | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code                                 | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name                                     | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                                         | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                                             | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.postal_code                                      | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_iso_code                                  | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                                      | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.geo.timezone                                         | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.ip                                                   | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.nat.ip                                               | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | ip               |
  | source.nat.port                                             | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.packets                                              | Packets sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | source.port                                                 | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | source.user.group.name                                      | Name of the group.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.user.name                                            | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.user.name.text                                       | Multi-field of `source.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | tags                                                        | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.full_name                                              | User's full name, if available.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | user.full_name.text                                         | Multi-field of `user.full_name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | user.name                                                   | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user.name.text                                              | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Cisco ISE dashboard screenshot](https://epr.elastic.co/package/cisco_ise/1.31.2/img/cisco-ise-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                         | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.31.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17005))Fix Timezone detection in Purge subpipeline                                                                                                                                                | 9.0.08.11.0            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17024))Remove duplicate security-solution-default tag references                                                                                                                                  | 9.0.08.11.0            |
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16312))Extract nested subkeys from cisco_av_pairs attributes in Passed Authentications pipeline.                                                                                              | 9.0.08.11.0            |
  | **1.30.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16115))Updated dissect processor to grok to address pipeline_error.                                                                                                                               | 9.0.08.11.0            |
  | **1.30.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16016))Fixed typo in ingest pipeline processors.                                                                                                                                                  | 9.0.08.11.0            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15798))Preserve event.original on pipeline error.                                                                                                                                             | 9.0.08.11.0            |
  | **1.29.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15532))Generate processor tags and normalize error handler.                                                                                                                                   | 9.0.08.11.0            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14938))Replace navigation with links panels.                                                                                                                                                  | 9.0.08.11.0            |
  | **1.28.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                                        | 9.0.08.11.0            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                | 9.0.08.11.0            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13540))Add support of timezone in configuration parameter.                                                                                                                                    | 9.0.08.11.0            |
  | **1.26.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13088))Support milliseconds in timestamps                                                                                                                                                         | 9.0.08.11.0            |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13011))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                       | 9.0.08.11.0            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                                             | 9.0.08.11.0            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12569))ECS version updated to 8.17.0.                                                                                                                                                         | 8.11.0                 |
  | **1.24.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11800))Revert mapping change for cisco_av_pair that was introduced with 1.24.1.                                                                                                                   | 8.11.0                 |
  | **1.24.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11619))Fix multiple pipeline processing issues.                                                                                                                                                   | 8.11.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11280))Improve ECS mappings by setting client.mac and event.outcome.                                                                                                                          | 8.11.0                 |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11315))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                       | 8.11.0                 |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11286))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                       | 8.11.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                               | 8.11.0                 |
  | **1.22.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10754))Improve handling of empty data fields                                                                                                                                                      | 8.7.1                  |
  | **1.22.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10534))Fix the Cisco_ISE toggle description for filestream input                                                                                                                              | 8.7.1                  |
  | **1.22.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10461))Handle logs that start with ISO8601 timestamp                                                                                                                                          | 8.7.1                  |
  | **1.22.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9533))Make Cisco ISE syslog priority field optional                                                                                                                                           | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                                           | 8.7.1                  |
  | **1.21.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9165))Remove duplicate 'event.code' 60077 from list for category mapping.                                                                                                                         | 8.7.1                  |
  | **1.21.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9004))Fix ingest pipeline conditional field handling.                                                                                                                                             | 8.7.1                  |
  | **1.21.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                          | 8.7.1                  |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                  | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8537))Handle CISE-Alarm events.                                                                                                                                                               | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                          | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                  | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8071))Add field event.code to capture the cisco_ise.log.message.code.                                                                                                                         | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8014))Adapt fields for changes in file system info                                                                                                                                            | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                                          | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.               | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                    | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7597))Update package-spec to 2.10.0.                                                                                                                                                          | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7394))Add support for filestream input.                                                                                                                                                       | 8.7.1                  |
  | **1.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7269))Add missing ECS field mappings                                                                                                                                                              | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                            | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6799))Convert dashboard to lens.                                                                                                                                                              | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6600))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                 | 8.0.07.17.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                            | 8.0.07.17.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                            | 8.0.07.17.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                  | 8.0.07.17.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                            | 8.0.07.17.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                                                     | 8.0.07.17.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4694))Update Aggregation visualizations to Lens, Add an on_failure processor to the convert and date processors, remove unnecessary white spaces, and convert double quotes to single quotes. | 8.0.07.17.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4653))Enhancements, refacturing and bugfixes                                                                                                                                                  | 8.0.07.17.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                            | 8.0.07.17.0            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3830))Fix handling of IdentityPolicyMatchedRule and IdentitySelectionMatchedRule.                                                                                                                 | 8.0.07.17.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4400))Remove duplicate fields.                                                                                                                                                                    | 8.0.07.17.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4087))Allow non-numeric task ID fields to be ingested                                                                                                                                         | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3859))Make GA                                                                                                                                                                                 | 8.0.07.17.0            |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3842))Update package to ECS 8.4.0.                                                                                                                                                            |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                            |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2855))Initial draft of the package.                                                                                                                                                           |                        |
</dropdown>