﻿---
title: Cisco IOS Integration
description: This integration is for Cisco IOS network devices' logs. It includes the following datasets for receiving logs over syslog or read from a file: The Cisco...
url: https://www.elastic.co/docs/reference/integrations/cisco_ios
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cisco IOS Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.34.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |

This integration is for [Cisco IOS network devices'](https://developer.cisco.com/docs/) logs. It includes the following
datasets for receiving logs over syslog or read from a file:

## Log Configuration

The Cisco appliance may be [configured in a variety of ways](https://www.cisco.com/c/en/us/td/docs/routers/access/wireless/software/guide/SysMsgLogging.html) to include or exclude fields. The Cisco IOS Integration expects the host name and timestamp to be present. If the `sequence-number` is configured to be present it will be used to populate `event.sequence`. If it is not, but `message-count` is configured to be present that field will be used in its place.
Timestamps and timezones are by default not enabled for Cisco IOS logging, to enable them please use `service timestamps log datetime`. For more information, please see the [Timestamp documentation](https://www.cisco.com/c/en/us/td/docs/routers/access/wireless/software/guide/SysMsgLogging.html#wp1054710)
The format of timezones added to Cisco IOS logs does not always match the expected formats used in common programming languages, and therefore 2 options have been added to the integration configuration:
1. `Timezone` - This option allows the user to specify the timezone that the logs will be translated to. This will enforce all logs sent to the integration to the same timezone. This option is recommended for most users and default is `UTC`.
2. `Timezone Map` - This option is for users who have logs from multiple timezones and want to translate them to the correct timezone. This option allows the user to specify a map of timezones to translate from and to. This option is recommended for advanced users who have logs from multiple timezones being sent to the same integration instance. If the timezone in a Cisco IOS log entry does not match any of the configured mappings, the log will fall back to the timezone specified in the `Timezone` option, and also defaults to `UTC`.

If log messages are relayed resulting in additional syslog header prefixes or other text, this text must be removed for ingestion to be successful. This may be done by adding an appropriate Beats processor to the configuration.

### IOS

The `log` dataset collects the Cisco IOS router and switch logs.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-01-06T20:52:12.861Z",
      "agent": {
          "ephemeral_id": "960a0fda-a7b7-4362-9018-34b1d0d119c4",
          "id": "f00ff835-626e-4a18-a8a2-0bb3ebb7503f",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.0.0"
      },
      "cisco": {
          "ios": {
              "facility": "SYS",
              "message_count": 2360957
          }
      },
      "data_stream": {
          "dataset": "cisco_ios.log",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "f00ff835-626e-4a18-a8a2-0bb3ebb7503f",
          "snapshot": false,
          "version": "8.0.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "code": "CONFIG_I",
          "dataset": "cisco_ios.log",
          "ingested": "2023-07-13T09:20:48Z",
          "original": "<189>2360957: Jan  6 2022 20:52:12.861: %SYS-5-CONFIG_I: Configured from console by akroh on vty0 (10.100.11.10)",
          "provider": "firewall",
          "sequence": 2360957,
          "severity": 5,
          "timezone": "+00:00",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "level": "notification",
          "source": {
              "address": "172.25.0.4:46792"
          },
          "syslog": {
              "priority": 189
          }
      },
      "message": "Configured from console by akroh on vty0 (10.100.11.10)",
      "observer": {
          "product": "IOS",
          "type": "firewall",
          "vendor": "Cisco"
      },
      "tags": [
          "preserve_original_event",
          "cisco-ios",
          "forwarded"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cisco.ios.access_list                 | Name of the IP access list.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cisco.ios.action                      | Action taken by the device                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cisco.ios.facility                    | The facility to which the message refers (for example, SNMP, SYS, and so forth). A facility can be a hardware device, a protocol, or a module of the system software. It denotes the source or the cause of the system message.                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco.ios.interface.name              | The name of the network interface.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cisco.ios.message_count               | Message count number provided by the device when the device's service message-counter global configuration is set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | cisco.ios.outcome                     | The result of the event                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cisco.ios.pim.group.ip                | Multicast group IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | cisco.ios.pim.source.ip               | Multicast source IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | ip               |
  | cisco.ios.sequence                    | Sequence number provided by the device when the device's service sequence-numbers global configuration is set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | cisco.ios.session.number              | Session ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |
  | cisco.ios.session.type                | Session type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ios.tableid                     | The tableid associated with badauth errors                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cisco.ios.uptime                      | The uptime for the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone               | Availability zone in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                      | Name of the project in Google Cloud.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                          | Region in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                   | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                 | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.type                      | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.bytes                     | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | elastic.agent.id                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | elastic.agent.snapshot                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | elastic.agent.version                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.code                            | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.duration                        | Duration of the event in nanoseconds. If `event.start` and `event.end` are known this value should be the difference between the end and start time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | event.end                             | `event.end` contains the date when the event ended or when the activity was last observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.original                        | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                   | keyword          |
  | event.provider                        | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing).                                                                                                                                                                                                                                                                                                                           | keyword          |
  | event.severity                        | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.                                                        | long             |
  | event.start                           | `event.start` contains the date when the event started or when the activity was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | event.timezone                        | This field should be populated when the event's timestamp does not include timezone information already (e.g. default Syslog timestamps). It's optional otherwise. Acceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                              | Host mac addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.name                             | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | text             |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | hostname                              | Hostname from syslog header.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | icmp.code                             | ICMP code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | icmp.type                             | ICMP type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | igmp.type                             | IGMP type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | input.type                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | labels                                | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels.                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.level                             | Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | log.source.address                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | log.syslog.hostname                   | The hostname, FQDN, or IP of the machine that originally sent the Syslog message. This is sourced from the hostname field of the syslog header. Depending on the environment, this value may be different from the host that handled the event, especially if the host handling the events is acting as a collector.                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.syslog.priority                   | Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | message                               | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | network.bytes                         | Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.iana_number                   | IANA Protocol Number (). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | network.packets                       | Total packets transferred in both directions. If `source.packets` and `destination.packets` are known, `network.packets` is their sum.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | network.type                          | In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | observer.product                      | The product name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.type                         | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | observer.vendor                       | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | process.program                       | Process from syslog header.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | related.hosts                         | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | related.user                          | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.bytes                          | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | source.domain                         | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.mac                            | MAC address of the source. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.packets                        | Packets sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | source.user.name                      | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.user.name.text                 | Multi-field of `source.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version     | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |-------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.34.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15798))Preserve event.original on pipeline error.                                                                                                                               | 9.0.08.11.0            |
  | **1.33.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15865))Enhancements to parse 4 addition log formats with hostname                                                                                                               | 9.0.08.11.0            |
  | **1.32.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15531))Generate processor tags and normalize error handler.                                                                                                                     | 9.0.08.11.0            |
  | **1.32.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14464))Add Grok and Dissect patterns to support multiple IPACCESSLOGP log formats with Event Code Trimming.                                                                     | 9.0.08.11.0            |
  | **1.31.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                          | 9.0.08.11.0            |
  | **1.31.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14294))Add support for Kiwi format logs                                                                                                                                         | 9.0.08.11.0            |
  | **1.30.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14250))Add support for longer timezone formats                                                                                                                                      | 9.0.08.11.0            |
  | **1.30.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13816))Fix parsing of hostnames that start with a digit                                                                                                                             | 9.0.08.11.0            |
  | **1.30.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13450))Correct parsing of FQDN hostnames                                                                                                                                            | 9.0.08.11.0            |
  | **1.30.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                               | 9.0.08.11.0            |
  | **1.29.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12828))Support additional header format and message type.                                                                                                                           | 8.11.0                 |
  | **1.29.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.11.0                 |
  | **1.29.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12569))ECS version updated to 8.17.0.                                                                                                                                           | 8.11.0                 |
  | **1.28.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12459))Fixing IPv6 parsing for IPV6ACCESSLOGP messages                                                                                                                              | 8.11.0                 |
  | **1.28.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11731))Fix FQDN parsing.                                                                                                                                                            | 8.11.0                 |
  | **1.28.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11497))Add support for ISO 8601 timestamps.                                                                                                                                     | 8.11.0                 |
  | **1.27.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11315))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.11.0                 |
  | **1.27.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10916))Handle timestamp starting with the year such as 'yyyy MMM d HH:mm:ss.SSS z'                                                                                                  | 8.11.0                 |
  | **1.27.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.11.0                 |
  | **1.26.11** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10948))Fix CISCO-IOS integration failing to parse logs coming from different application versions                                                                                   | 8.0.07.16.0            |
  | **1.26.10** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10147))Restore system Message handling for Cisco IOS                                                                                                                                | 8.0.07.16.0            |
  | **1.26.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10030))Update grok if statement to skip IOSXE messages with no sub-message                                                                                                          | 8.0.07.16.0            |
  | **1.26.8**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9900))Fix parsing for timezones with abbreviation and offset representation                                                                                                         | 8.0.07.16.0            |
  | **1.26.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9890))Fix parsing timezone with offset                                                                                                                                              | 8.0.07.16.0            |
  | **1.26.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9662))Fix handling of ACCESSLOGSP logs                                                                                                                                              | 8.0.07.16.0            |
  | **1.26.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9566))Fix ingest pipeline warnings                                                                                                                                                  | 8.0.07.16.0            |
  | **1.26.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9481))Fix hostname parsing for names that contain '_' underscore characters.                                                                                                    | 8.0.07.16.0            |
  | **1.26.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9443))Fix bad auth grok processor handling of missing MD5 sums.                                                                                                                 | 8.0.07.16.0            |
  | **1.26.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9442))Fix handling of timezone configurations.                                                                                                                                      | 8.0.07.16.0            |
  | **1.26.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9102))Improve grok processors to better handle generic messages.                                                                                                                | 8.0.07.16.0            |
  | **1.26.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                             | 8.0.07.16.0            |
  | **1.25.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9228))Remove erroneous period from repeated messages grok                                                                                                                           | 8.0.07.16.0            |
  | **1.25.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9001))Add support for repeated messages logs                                                                                                                                    | 8.0.07.16.0            |
  | **1.24.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9000))Fix time zone configuration not being applied.                                                                                                                                | 8.0.07.16.0            |
  | **1.24.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.0.07.16.0            |
  | **1.24.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8740))Add support for BADAUTH events.                                                                                                                                           | 8.0.07.16.0            |
  | **1.23.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.0.07.16.0            |
  | **1.23.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.22.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.21.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.0.07.16.0            |
  | **1.20.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.0.07.16.0            |
  | **1.19.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7688))Support ingesting IOSXE-*-PLATFORM messages.                                                                                                                              | 8.0.07.16.0            |
  | **1.18.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7466))Support ingesting NTP log messages.                                                                                                                                       | 8.0.07.16.0            |
  | **1.17.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.16.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6919))Fix parsing error when message_count is missing                                                                                                                               | 8.0.07.16.0            |
  | **1.16.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6930))Fix grok to be aware of fman_fp_image                                                                                                                                         | 8.0.07.16.0            |
  | **1.16.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6356))Adding Timezone Map advanced configuration option                                                                                                                         | 8.0.07.16.0            |
  | **1.15.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.14.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.13.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.12.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.11.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                                       | 8.0.07.16.0            |
  | **1.10.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.9.3**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4400))Remove duplicate fields.                                                                                                                                                      | 8.0.07.16.0            |
  | **1.9.2**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4327))Remove duplicate field.                                                                                                                                                     | 8.0.07.16.0            |
  | **1.9.1**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.9.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3694))Handle ASR Log Format.                                                                                                                                                    | 8.0.07.16.0            |
  | **1.8.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3842))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.7.2**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3763))Improve TCP, SSL config description and example.                                                                                                                          | 8.0.07.16.0            |
  | **1.7.1**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2932))update readme file - added link to cisco documentation                                                                                                                    | 8.0.07.16.0            |
  | **1.7.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3338))Add TLS system test**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3314))Add TCP input with TLS support                                 | 8.0.07.16.0            |
  | **1.5.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                         | 8.0.07.16.0            |
  | **1.4.2**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.1**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2636))Add missing event.original mapping                                                                                                                                            | 8.0.07.16.0            |
  | **1.4.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2392))Update to ECS 8.0                                                                                                                                                         |                        |
  | **1.3.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2475))Add syslog header and timestamp parsing.                                                                                                                                  | 8.0.07.16.0            |
  | **1.2.2**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            | 8.0.07.16.0            |
  | **1.2.1**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                |                        |
  | **1.2.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2279))Add 8.0.0 version constraint                                                                                                                                              | 8.0.07.16.0            |
  | **1.1.2**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1955))Update Title and Description.                                                                                                                                             | 7.16.0                 |
  | **1.1.1**   | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1807))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **1.1.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1784))Update to ECS 1.12.0                                                                                                                                                      |                        |
  | **1.0.0**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1582))Initial version of Cisco IOS as separate package                                                                                                                          |                        |
</dropdown>