﻿---
title: Cisco FTD Integration for Elastic
description: The Cisco Firepower Threat Defense (FTD) integration for Elastic collects logs from Cisco FTD devices, enabling comprehensive monitoring, threat detection,...
url: https://www.elastic.co/docs/reference/integrations/cisco_ftd
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cisco FTD Integration for Elastic
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 3.13.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |


## Overview

The Cisco Firepower Threat Defense (FTD) integration for Elastic collects logs from Cisco FTD devices, enabling comprehensive monitoring, threat detection, and security analysis within the Elastic Stack. This integration parses syslog messages from Cisco FTD, providing real-time visibility into network traffic, security events, and system activity. By centralizing these logs, you can enhance your security posture, streamline incident response, and gain deep insights into your network's operations.

### Compatibility

This integration is compatible with Cisco FTD devices that support syslog export. It requires Elastic Stack version 8.11.0 or newer.

### How it works

The integration works by receiving syslog data sent from a Cisco FTD device. Elastic Agent can be configured to listen for these logs on a specific TCP or UDP port, or to read them directly from a log file. Once received, the agent processes and parses the logs before sending them to Elasticsearch.

## What data does this integration collect?

The Cisco FTD integration collects logs containing detailed information about:
- **Connection Events**: Firewall traffic, network address translation (NAT), and connection summaries.
- **Security Events**: Intrusion detection and prevention (IPS/IDS) alerts, file and malware protection events, and security intelligence data.
- **System Events**: Device health, system status, and configuration changes.


### Supported use cases

- **Real-time Threat Detection**: Use Elastic SIEM to identify and respond to threats like malware, intrusions, and policy violations.
- **Network Traffic Analysis**: Visualize and analyze network traffic patterns to identify anomalies, troubleshoot connectivity issues, and optimize performance.
- **Security Auditing and Compliance**: Maintain a searchable archive of all firewall activity to support compliance requirements and forensic investigations.
- **Operational Monitoring**: Track the health and status of your FTD devices to ensure they are functioning correctly.


## What do I need to use this integration?

Elastic Agent must be installed on a host that is reachable by your Cisco FTD device over the network. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.
Elastic Agent is required to stream data from the syslog or log file receiver and ship the data to Elastic, where the events will then be processed through the integration's ingest pipelines.

## How do I deploy this integration?


### Onboard / configure


#### 1. Configure Cisco FTD to send Syslog Data

You must configure your Cisco FTD device to forward syslog messages to the Elastic Agent. The specific steps may vary depending on whether you are using Firepower Device Manager (FDM) or Firepower Management Center (FMC).
1. **Define the Elastic Agent as a Syslog Server**:
   - In your FDM or FMC interface, navigate to the syslog configuration section (for example, **Objects > Syslog Servers** or **Device > System Settings > Logging**).
- Add a new syslog server, providing the IP address and port of the machine where the Elastic Agent is running.
- Ensure the protocol (TCP or UDP) matches the input you configure in the integration.
2. **Configure Logging Rules**:
   - Create or edit a logging rule to send specific event classes to the newly configured syslog server.
- It is recommended to send all relevant message IDs to ensure comprehensive data collection.
3. **Deploy Changes**:
   - Save and deploy your configuration changes to the FTD device.

Refer to the Cisco instructions on how to [configure Logging on FTD via FMC](https://www.cisco.com/c/en/us/support/docs/security/firepower-ngfw/200479-Configure-Logging-on-FTD-via-FMC.html).

#### 2. Add the Cisco FTD Integration in Elastic

1. In Kibana, navigate to **Management > Integrations**.
2. In the search bar, enter **Cisco FTD**.
3. Click the integration to see more details and then click **Add integration**.
4. Configure the integration settings. You must select the input method that matches your Cisco FTD configuration (TCP, UDP, or log file).
   - **For TCP/UDP**: Specify the `host` and `port` where the Elastic Agent should listen for syslog messages. This must match the destination you configured on your FTD device.
- **For Log File**: Provide the file `paths` that the agent should monitor.
5. Click **Save and continue** to add the integration policy to an Elastic Agent.


#### 3. Validate that the integration is working

Navigate to the **Discover** tab in Kibana. Filter for the `cisco_ftd.log` dataset (`data_stream.dataset : "cisco_ftd.log"`) and verify that logs from your FTD device are being ingested. You can also check the pre-built dashboards for this integration by searching for "Cisco FTD" in the **Dashboards** section.

## Troubleshooting

1. **Verify Agent Status**:
   - In Kibana, navigate to **Management** > **Fleet** > **Agents**
- Confirm the Elastic Agent shows as "Healthy" and has the Cisco FTD integration assigned
- Check the agent logs for any connection errors
2. **Trigger Test Events**:
   - Generate test network traffic through the FTD device (for example, web browsing, file download)
- Or trigger a security event by accessing a known malicious URL or downloading a test file
- Verify the FTD device is sending syslog messages (check FTD logs or management interface)
3. **Verify Data Ingestion**:
   - In Kibana, navigate to **Discover**
- Select the `logs-cisco_ftd.log-*` data stream
- Verify events are appearing with recent timestamps
- Check that events contain expected fields such as `cisco.ftd.*`, `source.ip`, `destination.ip`, etc.
4. **Validate Event Fields**:
   - Open a sample event and verify:
  - `@timestamp` is correctly parsed
- `cisco.ftd.message_id` is present
- Network fields (`source.ip`, `destination.ip`, `source.port`, `destination.port`) are populated
- Security event fields are present for security-related events
- `event.original` contains the raw syslog message (if preserve_original_event is enabled)
5. **Check for Parsing Errors**:
   - Filter for `event.outcome: failure` or check for `error.message` fields
- Review any events with parsing issues
- Verify timezone configuration if timestamps appear incorrect

For help with Elastic ingest tools, check [Common problems](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).
A field named `cisco.ftd.security` contains a variable number of sub-fields, which is mapped as a [`flattened` datatype](https://www.elastic.co/guide/en/elasticsearch/reference/current/flattened.html). This mapping limits certain operations, such as aggregations, on its sub-fields.
To enable aggregations on common security-related fields, the integration automatically moves a known set of fields from `cisco.ftd.security` to a new field, `cisco.ftd.security_event`. If you need to perform aggregations on additional fields within `cisco.ftd.security`, you can create a custom ingest pipeline to move them.
To create this custom pipeline:
1. In Kibana, navigate to **Stack Management > Ingest Pipelines**.
2. Click **Create Pipeline > New Pipeline**.
3. Set the `Name` to `logs-cisco_ftd.log@custom`.
4. Add a **Rename** processor:
   - Set `Field` to the source field, for example, `cisco.ftd.security.threat_name`.
- Set `Target field` to the destination, for example, `cisco.ftd.security_event.threat_name`.
5. Add more processors as needed and save the pipeline. This `@custom` pipeline will be automatically applied to all incoming Cisco FTD logs.


## Scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### log

The `log` data stream collects logs from Cisco Firepower Threat Defense (FTD) devices.

#### log fields

<dropdown title="Exported fields">
  | Field                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |-----------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | cisco.ftd.aaa_type                                        | The AAA operation type. One of authentication, authorization, or accounting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cisco.ftd.assigned_ip                                     | The IP address assigned to a VPN client successfully connecting                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | cisco.ftd.assigned_ipv6                                   | The IPv6 address assigned to a VPN client successfully connecting                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | ip               |
  | cisco.ftd.burst.avg_rate                                  | The current average burst rate seen                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | cisco.ftd.burst.configured_avg_rate                       | The current configured average burst rate allowed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cisco.ftd.burst.configured_rate                           | The current configured burst rate                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cisco.ftd.burst.cumulative_count                          | The total count of burst rate hits since the object was created or cleared                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | cisco.ftd.burst.current_rate                              | The current burst rate seen                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cisco.ftd.burst.id                                        | The related rate ID for burst warnings                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cisco.ftd.burst.object                                    | The related object for burst warnings                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cisco.ftd.command_line_arguments                          | The command line arguments logged by the local audit log                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | cisco.ftd.connection_id                                   | Unique identifier for a flow.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cisco.ftd.connection_type                                 | The VPN connection type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ftd.dap_records                                     | The assigned DAP records                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | cisco.ftd.destination_interface                           | Destination interface for the flow or event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cisco.ftd.destination_user_or_sgt                         | The destination user or security group tag.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cisco.ftd.destination_username                            | Name of the user that is the destination for this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | cisco.ftd.effective_mtu                                   | The effective MTU allowed for VPN connections                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | cisco.ftd.icmp_code                                       | ICMP code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | short            |
  | cisco.ftd.icmp_type                                       | ICMP type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | short            |
  | cisco.ftd.mapped_destination_host                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.mapped_destination_ip                           | The translated destination IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | ip               |
  | cisco.ftd.mapped_destination_port                         | The translated destination port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | cisco.ftd.mapped_source_host                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.mapped_source_ip                                | The translated source IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | ip               |
  | cisco.ftd.mapped_source_port                              | The translated source port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | cisco.ftd.message_id                                      | The Cisco FTD message identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cisco.ftd.missed_updates_count                            | The number of Stateful Failover updates missed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | cisco.ftd.privilege.new                                   | When a users privilege is changed this is the new value                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ftd.privilege.old                                   | When a users privilege is changed this is the old value                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ftd.rule_name                                       | Name of the Access Control List rule that matched this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cisco.ftd.security                                        | Cisco FTD security event fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | flattened        |
  | cisco.ftd.security_event.ac_policy                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.access_control_rule_action       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.access_control_rule_name         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.access_control_rule_reason       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.application_protocol             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.client                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.client_version                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.connection_duration              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.destination_ip_dynamic_attribute | Destination IP dynamic attribute (EPG information)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cisco.ftd.security_event.destination_security_group       | Destination Security Group Tag (SGT)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | cisco.ftd.security_event.destination_security_group_tag   | Destination Security Group Tag number                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cisco.ftd.security_event.dns_query                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.dns_record_type                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.dns_response_type                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.dns_ttl                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.dst_ip                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | cisco.ftd.security_event.dst_port                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.egress_interface                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.egress_zone                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.encrypt_peer_ip                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | cisco.ftd.security_event.file_action                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_count                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.file_direction                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_name                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_policy                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_sandbox_status              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_sha256                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.file_size                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.file_type                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.first_packet_second              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | cisco.ftd.security_event.http_referer                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.http_response                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.icmp_code                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.icmp_type                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ingress_interface                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ingress_zone                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.initiator_bytes                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | cisco.ftd.security_event.initiator_packets                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.nap_policy                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.prefilter_policy                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.protocol                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.referenced_host                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.responder_bytes                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | cisco.ftd.security_event.responder_packets                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.sha_disposition                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.source_security_group            | Source Security Group Tag (SGT)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.source_security_group_tag        | Source Security Group Tag number                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cisco.ftd.security_event.source_security_group_type       | Source Security Group Tag type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | cisco.ftd.security_event.spero_disposition                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.src_ip                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | cisco.ftd.security_event.src_port                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | cisco.ftd.security_event.ssl_actual_action                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_certificate                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_expected_action              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_flow_status                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_policy                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_rule_name                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_server_cert_status           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_server_name                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_session_id                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_ticket_id                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.ssl_version                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.sslurl_category                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.tunnel_or_prefilter_rule         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.uri                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.url                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.url_category                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.url_reputation                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.user                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.user_agent                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.vpn_action                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.security_event.web_application                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.session_type                                    | Session type (for example, IPsec or UDP).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | cisco.ftd.source_interface                                | Source interface for the flow or event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ftd.source_user_or_sgt                              | The source user or security group tag.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cisco.ftd.source_username                                 | Name of the user that is the source for this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | cisco.ftd.suffix                                          | Optional suffix after %FTD identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cisco.ftd.termination_user                                | AAA name of user requesting termination                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cisco.ftd.threat_category                                 | Category for the malware / botnet traffic. For example: virus, botnet, trojan, etc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | cisco.ftd.threat_level                                    | Threat level for malware / botnet traffic. One of very-low, low, moderate, high or very-high.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cisco.ftd.translation_type                                | The translation type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | cisco.ftd.tunnel_type                                     | SA type (remote access or L2L)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | cisco.ftd.username                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cisco.ftd.webvpn.group_name                               | The WebVPN group name the user belongs to                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | client.address                                            | Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | client.domain                                             | The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | client.ip                                                 | IP address of the client (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | client.port                                               | Port of the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | client.user.name                                          | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | client.user.name.text                                     | Multi-field of `client.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | cloud.account.id                                          | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.availability_zone                                   | Availability zone in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.image.id                                            | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.id                                         | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.name                                       | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.machine.type                                        | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.project.id                                          | Name of the project in Google Cloud.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | cloud.provider                                            | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.region                                              | Region in which this host is running.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | container.id                                              | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | container.image.name                                      | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | container.labels                                          | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | object           |
  | container.name                                            | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | data_stream.dataset                                       | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | data_stream.namespace                                     | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.type                                          | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | destination.address                                       | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.number                                     | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | destination.as.organization.name                          | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.organization.name.text                     | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | destination.bytes                                         | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | destination.domain                                        | The domain name of the destination system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.city_name                                 | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.geo.continent_code                            | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.continent_name                            | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_iso_code                          | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_name                              | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.location                                  | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | destination.geo.name                                      | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.geo.postal_code                               | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.region_iso_code                           | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_name                               | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.timezone                                  | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.ip                                            | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | destination.nat.ip                                        | Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | destination.nat.port                                      | Port the source session is translated to by NAT Device. Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | destination.packets                                       | Packets sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | destination.port                                          | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | destination.user.domain                                   | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | destination.user.email                                    | User email address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.user.name                                     | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.user.name.text                                | Multi-field of `destination.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | match_only_text  |
  | device.manufacturer                                       | The vendor name of the device manufacturer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | device.model.name                                         | The human readable marketing name of the device model.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | dns.question.name                                         | The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | dns.question.registered_domain                            | The highest registered domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | dns.question.subdomain                                    | The subdomain is all of the labels under the registered_domain. If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | dns.question.top_level_domain                             | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | dns.question.type                                         | The type of record being queried.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | dns.response_code                                         | The DNS response code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | ecs.version                                               | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | error.message                                             | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | event.action                                              | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | event.category                                            | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.code                                                | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | event.created                                             | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                                                                                                                                                                                                            | date             |
  | event.dataset                                             | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.duration                                            | Duration of the event in nanoseconds. If `event.start` and `event.end` are known this value should be the difference between the end and start time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | event.end                                                 | `event.end` contains the date when the event ended or when the activity was last observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | event.ingested                                            | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | event.kind                                                | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.module                                              | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | event.original                                            | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | event.outcome                                             | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword          |
  | event.provider                                            | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | event.reason                                              | Reason why this event happened, according to the source. This describes the why of a particular action or outcome captured in the event. Where `event.action` captures the action from the event, `event.reason` describes why that action was taken. For example, a web proxy with an `event.action` which denied the request may also populate `event.reason` with the reason why (e.g. `blocked site`).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | event.severity                                            | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.                                                                                                                                                                                                                                                                                                                                                   | long             |
  | event.start                                               | `event.start` contains the date when the event started or when the activity was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | date             |
  | event.timezone                                            | This field should be populated when the event's timestamp does not include timezone information already (e.g. default Syslog timestamps). It's optional otherwise. Acceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | event.type                                                | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | file.hash.sha256                                          | SHA256 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | file.name                                                 | Name of the file including the extension, without the directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | file.path                                                 | Full path to the file, including the file name. It should include the drive letter, when appropriate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | file.path.text                                            | Multi-field of `file.path`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | file.size                                                 | File size in bytes. Only relevant when `file.type` is "file".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | host.architecture                                         | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.containerized                                        | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.domain                                               | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.hostname                                             | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.id                                                   | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.ip                                                   | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | host.mac                                                  | Host mac addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.name                                                 | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.os.build                                             | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                                          | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.family                                            | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.full                                              | Operating system name, including the version or code name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.os.full.text                                         | Multi-field of `host.os.full`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | host.os.kernel                                            | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.name                                              | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name.text                                         | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | text             |
  | host.os.platform                                          | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.type                                              | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                                           | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.type                                                 | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | http.request.referrer                                     | Referrer for this HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | http.response.status_code                                 | HTTP response status code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | input.type                                                | Input type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | labels                                                    | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | object           |
  | log.file.path                                             | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | log.level                                                 | Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                                                | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | log.source.address                                        | Source address from which the log event was read / sent from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | log.syslog.facility.code                                  | The Syslog numeric facility of the log event, if available. According to RFCs 5424 and 3164, this value should be an integer between 0 and 23.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | log.syslog.priority                                       | Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | log.syslog.severity.code                                  | The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | message                                                   | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | network.application                                       | When a specific application or service is identified from network connection details (source/dest IPs, ports, certificates, or wire format), this field captures the application's or service's name. For example, the original event identifies the network connection being from a specific web service in a `https` network connection, like `facebook` or `twitter`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | network.bytes                                             | Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | network.community_id                                      | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | network.direction                                         | Direction of the network traffic. When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress". When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external". Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers.                                                                                                                                                                                      | keyword          |
  | network.iana_number                                       | IANA Protocol Number (). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | network.inner                                             | Network.inner fields are added in addition to network.vlan fields to describe the innermost VLAN when q-in-q VLAN tagging is present. Allowed fields include vlan.id and vlan.name. Inner vlan fields are typically used when sending traffic with multiple 802.1q encapsulations to a network sensor (e.g. Zeek, Wireshark.)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | group            |
  | network.inner.vlan.id                                     | VLAN ID as reported by the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | network.inner.vlan.name                                   | Optional VLAN name as reported by the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.protocol                                          | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | network.transport                                         | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | network.type                                              | In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | observer.egress.interface.name                            | Interface name as reported by the system.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | observer.egress.zone                                      | Network zone of outbound traffic as reported by the observer to categorize the destination area of egress traffic, e.g. Internal, External, DMZ, HR, Legal, etc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | observer.geo.city_name                                    | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | observer.geo.continent_code                               | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | observer.geo.continent_name                               | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | observer.geo.country_iso_code                             | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | observer.geo.country_name                                 | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | observer.geo.location                                     | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | observer.geo.name                                         | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | observer.geo.postal_code                                  | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | observer.geo.region_iso_code                              | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | observer.geo.region_name                                  | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.geo.timezone                                     | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | observer.hostname                                         | Hostname of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | observer.ingress.interface.name                           | Interface name as reported by the system.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | observer.ingress.zone                                     | Network zone of incoming traffic as reported by the observer to categorize the source area of ingress traffic. e.g. internal, External, DMZ, HR, Legal, etc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.ip                                               | IP addresses of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | observer.name                                             | Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.product                                          | The product name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | observer.type                                             | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | observer.vendor                                           | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.version                                          | Observer version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | process.name                                              | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | process.name.text                                         | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | process.pid                                               | Process id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | related.hash                                              | All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | related.hosts                                             | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                                                | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | related.user                                              | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | rule.id                                                   | A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | rule.name                                                 | The name of the rule or signature generating the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | rule.ruleset                                              | Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | rule.version                                              | The version / revision of the rule being used for analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | server.address                                            | Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | server.domain                                             | The domain name of the server system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | server.ip                                                 | IP address of the server (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | server.port                                               | Port of the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | server.user.name                                          | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | server.user.name.text                                     | Multi-field of `server.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | service.id                                                | Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes. This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event. Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.address                                            | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.as.number                                          | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.as.organization.name                               | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.as.organization.name.text                          | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | source.bytes                                              | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | source.domain                                             | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.city_name                                      | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.geo.continent_code                                 | Two-letter code representing continent's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.continent_name                                 | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_iso_code                               | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_name                                   | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.location                                       | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | source.geo.name                                           | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.geo.postal_code                                    | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.region_iso_code                                | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_name                                    | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.timezone                                       | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.ip                                                 | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | source.nat.ip                                             | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | source.nat.port                                           | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | source.packets                                            | Packets sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | source.port                                               | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | source.user.domain                                        | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | source.user.email                                         | User email address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.user.group.name                                    | Name of the group.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.user.name                                          | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.user.name.text                                     | Multi-field of `source.user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | tags                                                      | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | url.domain                                                | Domain of the url, such as "[www.elastic.co](http://www.elastic.co)". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | url.extension                                             | The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | url.fragment                                              | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | url.full                                                  | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | wildcard         |
  | url.full.text                                             | Multi-field of `url.full`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | url.original                                              | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | wildcard         |
  | url.original.text                                         | Multi-field of `url.original`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | url.password                                              | Password of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | url.path                                                  | Path of the request, such as "/search".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | wildcard         |
  | url.port                                                  | Port of the request, such as 443.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | url.query                                                 | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | url.registered_domain                                     | The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | url.scheme                                                | Scheme of the request, such as "https". Note: The `:` is not part of the scheme.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | url.subdomain                                             | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "[www.east.example.com](http://www.east.example.com)" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | url.top_level_domain                                      | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | url.username                                              | Username of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | user.email                                                | User email address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.id                                                   | Unique identifier of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | user.name                                                 | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user.name.text                                            | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | user_agent.original                                       | Unparsed user_agent string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user_agent.original.text                                  | Multi-field of `user_agent.original`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | match_only_text  |
</dropdown>


#### log sample event

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-08-16T09:39:02.000Z",
      "agent": {
          "ephemeral_id": "477973c4-b380-4791-ad68-919bc71782eb",
          "id": "dc57df32-adfa-4d1e-9386-d4519fc2d1e9",
          "name": "elastic-agent-79310",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "cisco": {
          "ftd": {
              "rule_name": "malware-and-file-policy",
              "security": {
                  "file_storage_status": "Not Stored (Disposition Was Pending)",
                  "threat_name": "Win.Ransomware.Eicar::95.sbx.tg"
              },
              "security_event": {
                  "application_protocol": "HTTP",
                  "client": "cURL",
                  "dst_ip": "81.2.69.144",
                  "dst_port": 80,
                  "file_action": "Malware Cloud Lookup",
                  "file_direction": "Download",
                  "file_name": "eicar_com.zip",
                  "file_policy": "malware-and-file-policy",
                  "file_sandbox_status": "File Size Is Too Small",
                  "file_sha256": "2546dcffc5ad854d4ddc64fbf056871cd5a00f2471cb7a5bfd4ac23b6e9eedad",
                  "file_size": 184,
                  "file_type": "ZIP",
                  "first_packet_second": "2019-08-16T09:39:02Z",
                  "protocol": "tcp",
                  "sha_disposition": "Unavailable",
                  "spero_disposition": "Spero detection not performed on file",
                  "src_ip": "10.0.1.20",
                  "src_port": 46004,
                  "uri": "http://www.eicar.org/download/eicar_com.zip",
                  "user": "No Authentication Required"
              },
              "threat_category": "Win.Ransomware.Eicar::95.sbx.tg"
          }
      },
      "data_stream": {
          "dataset": "cisco_ftd.log",
          "namespace": "84072",
          "type": "logs"
      },
      "destination": {
          "address": "81.2.69.144",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "ip": "81.2.69.144",
          "port": 80
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "dc57df32-adfa-4d1e-9386-d4519fc2d1e9",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "action": "malware-detected",
          "agent_id_status": "verified",
          "category": [
              "malware",
              "file"
          ],
          "code": "430005",
          "dataset": "cisco_ftd.log",
          "ingested": "2025-05-20T10:32:02Z",
          "kind": "event",
          "original": "2019-08-16T09:39:03Z firepower  %FTD-1-430005: SrcIP: 10.0.1.20, DstIP: 81.2.69.144, SrcPort: 46004, DstPort: 80, Protocol: tcp, FileDirection: Download, FileAction: Malware Cloud Lookup, FileSHA256: 2546dcffc5ad854d4ddc64fbf056871cd5a00f2471cb7a5bfd4ac23b6e9eedad, SHA_Disposition: Unavailable, SperoDisposition: Spero detection not performed on file, ThreatName: Win.Ransomware.Eicar::95.sbx.tg, FileName: eicar_com.zip, FileType: ZIP, FileSize: 184, ApplicationProtocol: HTTP, Client: cURL, User: No Authentication Required, FirstPacketSecond: 2019-08-16T09:39:02Z, FilePolicy: malware-and-file-policy, FileStorageStatus: Not Stored (Disposition Was Pending), FileSandboxStatus: File Size Is Too Small, URI: http://www.eicar.org/download/eicar_com.zip",
          "severity": 1,
          "start": "2019-08-16T09:39:02Z",
          "timezone": "UTC",
          "type": [
              "info"
          ]
      },
      "file": {
          "hash": {
              "sha256": "2546dcffc5ad854d4ddc64fbf056871cd5a00f2471cb7a5bfd4ac23b6e9eedad"
          },
          "name": "eicar_com.zip",
          "size": 184
      },
      "host": {
          "hostname": "firepower"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "level": "alert",
          "source": {
              "address": "192.168.249.3:51934"
          }
      },
      "network": {
          "application": "curl",
          "community_id": "1:jk2uwniJ2oCG0t73HeZ9w8gtA8E=",
          "direction": "outbound",
          "iana_number": "6",
          "protocol": "http",
          "transport": "tcp"
      },
      "observer": {
          "hostname": "firepower",
          "product": "ftd",
          "type": "idps",
          "vendor": "Cisco"
      },
      "related": {
          "hash": [
              "2546dcffc5ad854d4ddc64fbf056871cd5a00f2471cb7a5bfd4ac23b6e9eedad"
          ],
          "hosts": [
              "firepower"
          ],
          "ip": [
              "10.0.1.20",
              "81.2.69.144"
          ]
      },
      "rule": {
          "ruleset": "malware-and-file-policy"
      },
      "source": {
          "address": "10.0.1.20",
          "ip": "10.0.1.20",
          "port": 46004
      },
      "tags": [
          "preserve_original_event",
          "private_is_internal",
          "cisco-ftd",
          "forwarded"
      ],
      "url": {
          "domain": "www.eicar.org",
          "extension": "zip",
          "original": "http://www.eicar.org/download/eicar_com.zip",
          "path": "/download/eicar_com.zip",
          "scheme": "http"
      }
  }
  ```
</dropdown>


### Inputs used

These inputs can be used with this integration:
<dropdown title="logfile">
  ## SetupFor more details about the logfile input settings, check the [Filebeat documentation](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-log).


  ### Collecting logs from logfileTo collect logs via logfile, select **Collect logs via the logfile input** and configure the following parameter:

  - Paths: List of glob-based paths to crawl and fetch log files from. Supports glob patterns like
    `/var/log/*.log` or `/var/log/*/*.log` for subfolder matching. Each file found starts a
    separate harvester.
</dropdown>

<dropdown title="tcp">
  ## SetupFor more details about the TCP input settings, check the [Filebeat documentation](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-tcp).


  ### Collecting logs from TCPTo collect logs via TCP, select **Collect logs via TCP** and configure the following parameters:
  **Required Settings:**
  - Host
  - Port
  **Common Optional Settings:**
  - Max Message Size - Maximum size of incoming messages
  - Max Connections - Maximum number of concurrent connections
  - Timeout - How long to wait for data before closing idle connections
  - Line Delimiter - Character(s) that separate log messages


  ## SSL/TLS ConfigurationTo enable encrypted connections, configure the following SSL settings:
  **SSL Settings:**
  - Enable SSL*- Toggle to enable SSL/TLS encryption
  - Certificate - Path to the SSL certificate file (`.crt` or `.pem`)
  - Certificate Key - Path to the private key file (`.key`)
  - Certificate Authorities - Path to CA certificate file for client certificate validation (optional)
  - Client Authentication - Require client certificates (`none`, `optional`, or `required`)
  - Supported Protocols - TLS versions to support (e.g., `TLSv1.2`, `TLSv1.3`)
  **Example SSL Configuration:**
  ```yaml
  ssl.enabled: true
  ssl.certificate: "/path/to/server.crt"
  ssl.key: "/path/to/server.key"
  ssl.certificate_authorities: ["/path/to/ca.crt"]
  ssl.client_authentication: "optional"
  ```
</dropdown>

<dropdown title="udp">
  ## SetupFor more details about the UDP input settings, check the [Filebeat documentation](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-udp).


  ### Collecting logs from UDPTo collect logs via UDP, select **Collect logs via UDP** and configure the following parameters:
  **Required Settings:**
  - Host
  - Port
  **Common Optional Settings:**
  - Max Message Size - Maximum size of UDP packets to accept (default: 10KB, max: 64KB)
  - Read Buffer - UDP socket read buffer size for handling bursts of messages
  - Read Timeout - How long to wait for incoming packets before checking for shutdown
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                          | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16437))Support alternate pattern for 113005 logs.                                                                                                                                                                  | 9.0.08.11.0            |
  | **3.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15887))Update documentation to the new template.                                                                                                                                                               | 9.0.08.11.0            |
  | **3.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15798))Preserve event.original on pipeline error.                                                                                                                                                              | 9.0.08.11.0            |
  | **3.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15652))Add support for Security Group Tag (SGT) and Endpoint Group (EPG) fields in connection events.                                                                                                          | 9.0.08.11.0            |
  | **3.10.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14983))Fix parsing for message ID 313005 to accept input type unknown.                                                                                                                                             | 9.0.08.11.0            |
  | **3.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14984))Fix parsing for message ID 430003 to correctly set event start to FirstPacketSecond and set the event end to start + duration.                                                                              | 9.0.08.11.0            |
  | **3.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14892))Include NAT IPs and ports from security event messages.                                                                                                                                                 | 9.0.08.11.0            |
  | **3.9.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14667))Fix parsing for message ID 746012 and 746013.                                                                                                                                                               | 9.0.08.11.0            |
  | **3.9.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                                                         | 9.0.08.11.0            |
  | **3.9.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14757))Fix parsing for message ID 113014.                                                                                                                                                                          | 9.0.08.11.0            |
  | **3.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14748))Ensure observer zone fields are set.                                                                                                                                                                        | 9.0.08.11.0            |
  | **3.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13957))Add parsing for `EncryptPeerIP` and `VPN_Action` fields.                                                                                                                                                | 9.0.08.11.0            |
  | **3.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                                                              | 9.0.08.11.0            |
  | **3.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13043))Fix parsing for message ID 302304.                                                                                                                                                                          | 8.11.0                 |
  | **3.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12726))Add parsing for message IDs 109201, 109207, 209210, 111008, 113008, 113009, 113014, 716002, 716058, 716059, 722055, 746012, 746013, and fix patterns for 305012, 602101, 722051.                        | 8.11.0                 |
  | **3.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                | 8.11.0                 |
  | **3.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12569))ECS version updated to 8.17.0.                                                                                                                                                                          | 8.11.0                 |
  | **3.5.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12343))Ensure event message is saved to event.reason for IDs 101001 through 105052.                                                                                                                                | 8.11.0                 |
  | **3.4.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11780))Fixed grok errors on ftd message ID 305006. Added additional matching pattern per specification.                                                                                                            | 8.11.0                 |
  | **3.4.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11315))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                        | 8.11.0                 |
  | **3.4.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11198))Fix grok failure with username with spaces on ftd messageID.                                                                                                                                                | 8.11.0                 |
  | **3.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11257))Fix parsing issues with message IDs 210007, 305013, and 302023.                                                                                                                                             | 8.11.0                 |
  | **3.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                | 8.11.0                 |
  | **3.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10635))Fix handling usernames with spaces for message ids 716002 and 722051                                                                                                                                        | 8.0.07.16.0            |
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9945))Add parsing for message IDs 113042, 210007, 305006, 305013, 401004 and 500004                                                                                                                            | 8.0.07.16.0            |
  | **3.2.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9775))Parse src/dst for message ID 313005                                                                                                                                                                          | 8.0.07.16.0            |
  | **3.2.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9569))Fix ingest pipeline warnings                                                                                                                                                                                 | 8.0.07.16.0            |
  | **3.2.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/9241))Treat FTD suffix as optional                                                                                                                                                                               | 8.0.07.16.0            |
  | **3.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/9198))Handle null network when calculating bytes for Event 113019                                                                                                                                                | 8.0.07.16.0            |
  | **3.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9473))support hidden username for message id 113005                                                                                                                                                                | 8.0.07.16.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                                                            | 8.0.07.16.0            |
  | **3.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9223))Expand grok patterns to handle TCP Probes for 302013, 302014 messages                                                                                                                                    | 8.0.07.16.0            |
  | **3.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9141))Null handling and other clean-up                                                                                                                                                                             | 8.0.07.16.0            |
  | **3.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                           | 8.0.07.16.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8898))Retain email address of source and destination user.                                                                                                                                                     | 8.0.07.16.0            |
  | **3.0.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8883))Added nullcheck for Network Directionality when zones aren't configured                                                                                                                                      | 8.0.07.16.0            |
  | **3.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8798))Fix the handling of spaces in 113005 messages.                                                                                                                                                               | 8.0.07.16.0            |
  | **3.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                                   | 8.0.07.16.0            |
  | **3.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8490))Extract security_event group of fields from flattened security field. NOTE - This is a breaking change.                                                                                                  | 8.0.07.16.0            |
  | **2.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                           | 8.0.07.16.0            |
  | **2.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                   | 8.0.07.16.0            |
  | **2.18.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix field mapping for empty groups imported from ECS                                                                                                                                                         | 8.0.07.16.0            |
  | **2.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8053))Remove redundant regular expression quantifier.                                                                                                                                                              | 8.0.07.16.0            |
  | **2.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                                                                              | 8.0.07.16.0            |
  | **2.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7908))Update package to ECS 8.10.0 and align ECS categorization fields.                                                                                                                                        | 8.0.07.16.0            |
  | **2.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                     | 8.0.07.16.0            |
  | **2.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7596))Update package-spec to 2.10.0.                                                                                                                                                                           | 8.0.07.16.0            |
  | **2.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7267))Add missing geo field mappings                                                                                                                                                                               | 8.0.07.16.0            |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.13.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6929))Fix source.bytes and destination.bytes type                                                                                                                                                                  | 8.0.07.16.0            |
  | **2.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6669))Remove Invalid ID                                                                                                                                                                                            | 8.0.07.16.0            |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6600))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                  | 8.0.07.16.0            |
  | **2.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6423))Fix VPN event.action                                                                                                                                                                                         | 8.0.07.16.0            |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.11.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5648))Allow resolution of network direction from IP range.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5648))Correct discrepancy in pipeline for Message ID's 302013, 302015. |                        |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6322))Add ECS fields for `rule`, `device` and `host`                                                                                                                                                           | 8.0.07.16.0            |
  | **2.10.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/6142))Support additional patterns in 113012, 113004, and 716039 messages                                                                                                                                         | 8.0.07.16.0            |
  | **2.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5859))Convert source.bytes and destination.bytes to integer                                                                                                                                                        | 8.0.07.16.0            |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.9.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5522))Add network.bytes and dns.question.registered_name                                                                                                                                                       | 8.0.07.16.0            |
  | **2.9.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                   | 8.0.07.16.0            |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5139))Allow configuration of time zones.                                                                                                                                                                       | 8.0.07.16.0            |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                                                                      | 8.0.07.16.0            |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4579))Allow configuration of internal/external zones                                                                                                                                                           | 8.0.07.16.0            |
  | **2.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4563))Enhancement of network direction                                                                                                                                                                         | 8.0.07.16.0            |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.4.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4380))Harmonise with pipeline with Cisco ASA.                                                                                                                                                                    | 8.0.07.16.0            |
  | **2.4.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4400))Remove duplicate fields.                                                                                                                                                                                     | 8.0.07.16.0            |
  | **2.4.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4327))Remove duplicate field.                                                                                                                                                                                    | 8.0.07.16.0            |
  | **2.4.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4209))Fix handling of 302020 event messages.                                                                                                                                                                       | 8.0.07.16.0            |
  | **2.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                       |                        |
  | **2.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4163))Clean up grok pattern naming.                                                                                                                                                                                | 8.0.07.16.0            |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3842))Update package to ECS 8.4.0                                                                                                                                                                              | 8.0.07.16.0            |
  | **2.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3763))Improve TCP, SSL config description and example.                                                                                                                                                         | 8.0.07.16.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                             | 8.0.07.16.0            |
  | **2.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3549))Map syslog priority details according to ECS**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3549))Extract syslog facility and severity codes from syslog priority              | 8.0.07.16.0            |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3344))Remove invalid values from ECS fields                                                                                                                                                                        | 8.0.07.16.0            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3339))Add TLS system test**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3313))Add TCP input with TLS support                                                                |                        |
  | **2.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2931))Added link to Cisco's FTD documentation in readme                                                                                                                                                        | 8.0.07.16.0            |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                                                        | 8.0.07.16.0            |
  | **2.0.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3041))Set event.kind to alert only when sha_disposition is malware or custom                                                                                                                                       | 8.0.07.16.0            |
  | **2.0.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3018))Make fields agree with ECS                                                                                                                                                                                   | 8.0.07.16.0            |
  | **2.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2551))Update observer to ftd and idps to better match this integration.                                                                                                                                            |                        |
  | **2.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                       | 8.0.07.16.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2391))Update to ECS 8.0                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                           | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                               |                        |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2258))Add 8.0.0 version constraint                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1954))Update Title and Description.                                                                                                                                                                            | 7.16.0                 |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1806))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1783))Update to ECS 1.12.0                                                                                                                                                                                     |                        |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1731))Adding missing ECS fields                                                                                                                                                                                    |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1586))Initial version to split Cisco FTD out from the general Cisco package                                                                                                                                    |                        |
</dropdown>