﻿---
title: Cisco Aironet
description: This integration is for Cisco Aironet WLC logs. It includes the following datasets for receiving logs over syslog or read from a file: log dataset: supports...
url: https://www.elastic.co/docs/reference/integrations/cisco_aironet
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Cisco Aironet
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.19.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |

This integration is for Cisco Aironet WLC logs. It includes the following
datasets for receiving logs over syslog or read from a file:
- `log` dataset: supports Cisco Aironet WLC logs.


## Logs


### Aironet

The `log` dataset collects the Cisco Aironet WLC logs. The descriptions of system messages can be obtained from the [Cisco documentation](https://www.cisco.com/c/en/us/support/wireless/wireless-lan-controller-software/products-system-message-guides-list.html).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-08-20T11:25:50.157Z",
      "agent": {
          "ephemeral_id": "c47efe0f-c0e2-444b-b292-a9ec40271d4b",
          "id": "0335de7e-b2c1-4352-bf23-c023d21c1252",
          "name": "elastic-agent-54493",
          "type": "filebeat",
          "version": "8.15.3"
      },
      "cisco": {
          "interface": {
              "type": "wired"
          }
      },
      "client": {
          "ip": "fe80::aee2:d3ff:feba:56a4"
      },
      "data_stream": {
          "dataset": "cisco_aironet.log",
          "namespace": "59495",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "0335de7e-b2c1-4352-bf23-c023d21c1252",
          "snapshot": false,
          "version": "8.15.3"
      },
      "event": {
          "action": "ENTRY_DELETED",
          "agent_id_status": "verified",
          "dataset": "cisco_aironet.log",
          "ingested": "2024-11-04T21:04:12Z",
          "original": "<134>WLC001: *SISF BT Process: Aug 20 11:25:50.157: %SISF-6-ENTRY_DELETED: sisf_shim_utils.c:482 Entry deleted A=fe80::aee2:d3ff:feba:56a4 V=0 I=wired:1 P=0000 M=",
          "provider": "SISF",
          "severity": 6,
          "timezone": "+00:00"
      },
      "host": {
          "name": "WLC001"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "level": "informational",
          "source": {
              "address": "172.29.0.3:33867"
          },
          "syslog": {
              "facility": {
                  "code": 16
              },
              "priority": 134,
              "severity": {
                  "code": 6
              }
          }
      },
      "message": "Entry deleted A=fe80::aee2:d3ff:feba:56a4 V=0 I=wired:1 P=0000 M=",
      "process": {
          "name": "SISF BT Process"
      },
      "tags": [
          "preserve_original_event",
          "cisco-aironet",
          "forwarded"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Type             |
  |----------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                       | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | cisco.eapol.descriptor           | Cisco eapol descriptor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | short            |
  | cisco.eapol.type                 | Cisco eapol type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | short            |
  | cisco.eapol.version              | Cisco eapol version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | short            |
  | cisco.interface.type             | Cisco interface type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cisco.ssid                       | Cisco SSID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cisco.wps.channel                | Cisco WPS channel                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | short            |
  | cisco.wps.hits                   | Cisco WPS hits                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | short            |
  | cisco.wps.preced                 | Cisco WPS precedence                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | short            |
  | cisco.wps.radio                  | The radio interface number within a slot                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | short            |
  | cisco.wps.slot                   | Cisco WPS slot                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | short            |
  | cisco.wps.track                  | Cisco WPS track                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | client.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | client.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | client.as.organization.name.text | Multi-field of `client.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | match_only_text  |
  | client.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | client.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | client.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | client.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | client.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | geo_point        |
  | client.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | client.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | client.ip                        | IP address of the client (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | client.mac                       | MAC address of the client. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                   | keyword          |
  | data_stream.dataset              | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.namespace            | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | data_stream.type                 | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | destination.mac                  | MAC address of the destination. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.port                 | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | ecs.version                      | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                         | keyword          |
  | event.dataset                    | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | event.module                     | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | constant_keyword |
  | event.severity                   | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long             |
  | input.type                       | Input type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | log.file.path                    | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | log.level                        | Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.                                                                                                                                                                                                                                               | keyword          |
  | log.offset                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | log.source.address               | Source address from which the log event was read / sent from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.syslog.facility.code         | The Syslog numeric facility of the log event, if available. According to RFCs 5424 and 3164, this value should be an integer between 0 and 23.                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | log.syslog.priority              | Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | log.syslog.severity.code         | The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.                                                                                                                                                                                                      | long             |
  | message                          | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                           | match_only_text  |
  | observer.ingress.interface.id    | Interface ID as reported by an observer (typically SNMP interface ID).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | process.name                     | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | process.name.text                | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | match_only_text  |
  | server.ip                        | IP address of the server (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | source.mac                       | MAC address of the source. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                   | keyword          |
  | tags                             | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | threat.indicator.description     | Describes the type of action conducted by the threat.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | threat.indicator.type            | Type of indicator as represented by Cyber Observable in STIX 2.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.name                        | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | user.name.text                   | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17271))Support logs with dual sequence numbers and timezone abbreviations.                                                                                 | 9.0.08.11.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15798))Preserve event.original on pipeline error.                                                                                                          | 9.0.08.11.0            |
  | **1.17.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15528))Generate processor tags and normalize error handler.                                                                                                | 9.0.08.11.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15517))Parse 'CLIENT_ORCH_LOG-6-CLIENT_ADDED_TO_RUN_STATE' log messages with more fields                                                                   | 9.0.08.11.0            |
  | **1.16.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                     | 9.0.08.11.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                          | 9.0.08.11.0            |
  | **1.15.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12975))Properly parse 'CLIENT_ORCH_LOG-6-CLIENT_ADDED_TO_RUN_STATE' log messages                                                                               | 8.11.0                 |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                            | 8.11.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12569))ECS version updated to 8.17.0.                                                                                                                      | 8.11.0                 |
  | **1.14.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11105))Fix the event.severity ECS field mapping.                                                                                                               | 8.11.0                 |
  | **1.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11103))Fix the destination.port ECS field mapping.                                                                                                             | 8.11.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                            | 8.11.0                 |
  | **1.13.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10445))Handle multiple whitespace characters between month and monthday                                                                                        | 8.0.0                  |
  | **1.13.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10166))Make LOG-3-Q_IND parsing optional.                                                                                                                      | 8.0.0                  |
  | **1.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9545))Fix CLIENT_ORCH_LOG messages.                                                                                                                            | 8.0.0                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                        | 8.0.0                  |
  | **1.12.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.0.0                  |
  | **1.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                               | 8.0.0                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.0.0                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                               | 8.0.0                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                          | 8.0.0                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.0.0                  |
  | **1.8.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7966))Correct invalid ECS field usages at root-level.                                                                                                          | 8.0.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                       | 8.0.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.0.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                         | 8.0.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6600))Ensure event.kind is correctly set for pipeline errors.                                                                                              | 8.0.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                         | 8.0.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                | 8.0.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         | 8.0.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5677))Release Cisco Aironet as GA.                                                                                                                         | 8.0.0                  |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                               |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                         |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                  |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                         |                        |
  | **0.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                   |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4050))Initial draft of the package for Cisco WLC                                                                                                           |                        |
</dropdown>