﻿---
title: CISA KEV integration
description: This integration is for CISA KEV logs. This data can be useful for current awareness of Known Exploited Vulnerabilities according to CISA and also for...
url: https://www.elastic.co/docs/reference/integrations/cisa_kevs
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# CISA KEV integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.7.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

This integration is for [CISA KEV](https://www.cisa.gov/known-exploited-vulnerabilities-catalog) logs. This data can be useful for current awareness of Known Exploited Vulnerabilities according to CISA and also for enriching other vulnerability scan data in the Elastic stack. The integration periodically checks for the latest CISA KEV list. It includes the following datasets for retrieving logs from the CISA KEV website:
- `vulnerability` dataset: Supports vulnerabilities classified as known exploited from CISA.


### Example Enrich Policy and ES|QL Correlation Query

An enrich policy can be created to have other vulnerability information be enriched based on the CVE number.
The following requests can be used to create and execute the enrich policy after the integration has been installed:
```
PUT /_enrich/policy/enrich_cve_with_context_cisa_kev
{
  "match": {
    "indices": ".ds-logs-cisa_kevs.vulnerability-*",
    "match_field": "vulnerability.id",
    "enrich_fields": ["cisa_kev.vulnerability.date_added", "cisa_kev.vulnerability.due_date", "cisa_kev.vulnerability.known_ransomware_campaign_use", "cisa_kev.vulnerability.name", "cisa_kev.vulnerability.notes","cisa_kev.vulnerability.product","cisa_kev.vulnerability.required_action","cisa_kev.vulnerability.vendor_project"]
  }
}

PUT /_enrich/policy/enrich_cve_with_context_cisa_kev/_execute
```

Here is an example ESQL query that uses the index pattern of logs-nessus.vulnerability* to enrich the data source with CISA KEV information and keeping the top 10 results. Note, the enrich policy (shown above) must be created first:
```
from logs-nessus.vulnerability*
| where vulnerability.id IS NOT NULL
| keep vulnerability.*, nessus.plugin.name, host.name
| enrich enrich_cve_with_context_cisa_kev with cisa_kev.vulnerability.due_date, cisa_kev.vulnerability.known_ransomware_campaign_use, cisa_kev.vulnerability.name, cisa_kev.vulnerability.notes, cisa_kev.vulnerability.product, cisa_kev.vulnerability.required_action, cisa_kev.vulnerability.vendor_project, cisa_kev.vulnerability.date_added
| where cisa_kev.vulnerability.name IS NOT NULL
| stats count = COUNT(host.name) BY nessus.plugin.name, vulnerability.severity, cisa_kev.vulnerability.date_added, cisa_kev.vulnerability.product
| sort count desc
| keep nessus.plugin.name, vulnerability.severity, cisa_kev.vulnerability.product, cisa_kev.vulnerability.date_added, count
| limit 10
```


## Upgrading to v1.7.0+

If upgrading from a version of the package before v1.7.0, you will need to re-enter your configuration details and re-enable the package.

## Logs


### Vulnerabilities

The CISA KEV data_stream retrieves vulnerability information from the endpoint `https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities.json`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-02-15T00:00:00.000Z",
      "agent": {
          "ephemeral_id": "fc07fa12-f549-40b8-b71a-d49f02d4941d",
          "id": "5f9e8c36-28d7-4df6-bdeb-68a9e24bfdc0",
          "name": "elastic-agent-37763",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "cisa_kev": {
          "vulnerability": {
              "date_added": "2024-02-15",
              "due_date": "2024-03-07",
              "known_ransomware_campaign_use": "Known",
              "name": "Cisco ASA and FTD Information Disclosure Vulnerability",
              "notes": "https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-asaftd-info-disclose-9eJtycMB",
              "product": "Adaptive Security Appliance (ASA) and Firepower Threat Defense (FTD)",
              "required_action": "Apply mitigations per vendor instructions or discontinue use of the product if mitigations are unavailable.",
              "vendor_project": "Cisco"
          }
      },
      "data_stream": {
          "dataset": "cisa_kevs.vulnerability",
          "namespace": "77864",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5f9e8c36-28d7-4df6-bdeb-68a9e24bfdc0",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "dataset": "cisa_kevs.vulnerability",
          "ingested": "2025-08-05T05:37:31Z",
          "kind": "enrichment",
          "original": "{\"cveID\":\"CVE-2020-3259\",\"dateAdded\":\"2024-02-15\",\"dueDate\":\"2024-03-07\",\"knownRansomwareCampaignUse\":\"Known\",\"notes\":\"https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-asaftd-info-disclose-9eJtycMB\",\"product\":\"Adaptive Security Appliance (ASA) and Firepower Threat Defense (FTD)\",\"requiredAction\":\"Apply mitigations per vendor instructions or discontinue use of the product if mitigations are unavailable.\",\"shortDescription\":\"Cisco Adaptive Security Appliance (ASA) and Firepower Threat Defense (FTD) contain an information disclosure vulnerability. An attacker could retrieve memory contents on an affected device, which could lead to the disclosure of confidential information due to a buffer tracking issue when the software parses invalid URLs that are requested from the web services interface. This vulnerability affects only specific AnyConnect and WebVPN configurations.\",\"vendorProject\":\"Cisco\",\"vulnerabilityName\":\"Cisco ASA and FTD Information Disclosure Vulnerability\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "cisa-kev"
      ],
      "vulnerability": {
          "description": "Cisco Adaptive Security Appliance (ASA) and Firepower Threat Defense (FTD) contain an information disclosure vulnerability. An attacker could retrieve memory contents on an affected device, which could lead to the disclosure of confidential information due to a buffer tracking issue when the software parses invalid URLs that are requested from the web services interface. This vulnerability affects only specific AnyConnect and WebVPN configurations.",
          "id": "CVE-2020-3259"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                | Description                                                                                                                                                                                  | Type             |
  |------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                           | Event timestamp.                                                                                                                                                                             | date             |
  | cisa_kev.vulnerability.date_added                    | The date the vulnerability was added to the catalog in the format YYYY-MM-DD                                                                                                                 | date             |
  | cisa_kev.vulnerability.due_date                      | The date the required action is due in the format YYYY-MM-DD                                                                                                                                 | date             |
  | cisa_kev.vulnerability.known_ransomware_campaign_use | 'Known' if this vulnerability is known to have been leveraged as part of a ransomware campaign; 'Unknown' if CISA lacks confirmation that the vulnerability has been utilized for ransomware | keyword          |
  | cisa_kev.vulnerability.name                          | The name of the vulnerability                                                                                                                                                                | keyword          |
  | cisa_kev.vulnerability.notes                         | Any additional notes about the vulnerability                                                                                                                                                 | keyword          |
  | cisa_kev.vulnerability.product                       | The vulnerability product                                                                                                                                                                    | keyword          |
  | cisa_kev.vulnerability.required_action               | The required action to address the vulnerability                                                                                                                                             | keyword          |
  | cisa_kev.vulnerability.vendor_project                | The vendor or project name for the vulnerability                                                                                                                                             | keyword          |
  | data_stream.dataset                                  | Data stream dataset.                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                                | Data stream namespace.                                                                                                                                                                       | constant_keyword |
  | data_stream.type                                     | Data stream type.                                                                                                                                                                            | constant_keyword |
  | input.type                                           | Type of Filebeat input.                                                                                                                                                                      | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Dashboard for CISA Known Exploitable Vulnerabilities](https://epr.elastic.co/package/cisa_kevs/1.7.0/img/cisa_kevs.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14804))Migrate data streams to the CEL input.                                                                                                              | 9.0.08.13.0            |
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13309))Add 'Security Solution' tag in the dashboard.                                                                                                       | 9.0.08.13.0            |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                            | 8.13.0                 |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.3.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                            | 8.13.0                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                 | 8.11.4                 |
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9631))Update logo to align w/ Elastic Integrations page, fix description wording                                                                               | 8.11.4                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9492))Add Enrich/ES|QL Samples to Readme, make GA.                                                                                                         | 8.11.4                 |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9240))Initial draft of the package                                                                                                                         |                        |
</dropdown>