﻿---
title: CEL Custom API input integration
description: The Common Expression Language (CEL) custom API input integration is used to ingest data from custom HTTP and local file-system APIs that do not currently...
url: https://www.elastic.co/docs/reference/integrations/cel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# CEL Custom API input integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.19.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Minimum Kibana version(s)**                                                                   | 9.1.08.19.0                     |

The Common Expression Language (CEL) custom API input integration is used to ingest data from custom HTTP and local file-system APIs that do not currently have an existing integration.
The input itself supports making both HTTP requests and file-system read operations, and keeping running and persistent state on information from the last collected events. The input performs [Common Expression Language](https://opensource.google.com/projects/cel) expression evaluation with a [set of standard extensions](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-cel.html#_cel_extension_libraries) to both obtain input data from the API and then process the data into events that are published to Elasticsearch.

## Configuration

The full documentation for the input are currently available [here](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-cel.html).
The most commonly used configuration options are available on the main integration page, while more advanced and customizable options currently resides under the "Advanced options" part of the integration settings page.
Configuration is split into two main parts: Program and State, with an associated named Resource.
The program is a CEL program that will obtain data from the API either by an HTTP request or a local file-system read operation, and then transform the data into a set of events and cursor states. The CEL environment that the program is run in is provided with an HTTP client that has been set-up with the user-specified authentication, proxy, rate limit and other options, and with a set of user-defined regular expressions that are available to use during execution.
The state is passed into the program on start of execution and may contain configuration details not included in the standard set of options. The CEL program return value will be the state used during the next cycle of CEL execution, and will include the events to be published to Elasticsearch and then removed from the state. State values in general will not persist over restarts, but it may contain a cursor that is persisted. The cursor part of state is used when there is a need to keep long-lived state that will persist over restarts.
The named resource is a string value that the CEL program can use to identify the location of the API and will usually either be a URL or a file path. It is included in the state as the `state.url`. CEL programs are not required to make use of this configuration, but its presence is required in the configuration.

## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15297))Add options for including global HTTP request headers.                                                                                                                                                        | 9.1.08.19.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15210))Add options for OAuth2 user/password.                                                                                                                                                                         | 9.0.08.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15026))Improve example CEL program in configuration user interface.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15026))Fix missing resource timeout configuration template snippet. | 9.0.08.16.0            |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                       | 9.0.08.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13414))Enable access to environment variables in CEL programs.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13414))Enable request trace log deletion.                            | 9.0.08.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12593))Update Kibana constraint to support 9.0.0.                                                                                                                                                                    | 9.0.08.13.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12555))Add a 'condition' configuration option for specifying to Elastic Agent when it should run the input.                                                                                                          | 8.13.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11602))Add xsd configuration option inside input.                                                                                                                                                                    | 8.13.0                 |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                            | 8.13.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9936))Enable use of Digest Authentication.                                                                                                                                                                           | 8.12.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9919))Enable use of Okta OAuth2.0.                                                                                                                                                                                   | 8.12.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                                                                | 8.12.0                 |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9018))Clarify naming of input.                                                                                                                                                                                       | 8.8.0                  |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                 | 8.8.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                        | 8.8.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                                 | 8.8.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                                                                 | 8.8.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                      | 8.8.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                           | 8.8.0                  |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7335))Fix location of request trace log destination.                                                                                                                                                                     | 8.8.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                                                   | 8.8.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6831))Make debug log field redactions available.                                                                                                                                                                     | 8.8.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6307))Make package GA.                                                                                                                                                                                               | 8.8.0                  |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                                                   |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                                                          |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5922))Change resource tracer filename                                                                                                                                                                                |                        |
  | **0.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5937))Added build manifest to indicate the ECS reference.                                                                                                                                                                |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5539))Initial Implementation                                                                                                                                                                                         |                        |
</dropdown>