﻿---
title: VMware Carbon Black EDR Integration
description: The VMware Carbon Black EDR integration collects EDR Server and raw Endpoint events exported by Carbon Black EDR Event Forwarder. The following output...
url: https://www.elastic.co/docs/reference/integrations/carbonblack_edr
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# VMware Carbon Black EDR Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.21.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File, Network Protocol, Webhook |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

The VMware Carbon Black EDR integration collects EDR Server and raw Endpoint events exported by [Carbon Black EDR Event Forwarder.](https://github.com/carbonblack/cb-event-forwarder) The following output methods are supported: `http`, `tcp`, `udp` and `file`.

## Compatibility

This integration has been tested with the 3.7.4 version of EDR Event Forwarder.

## Configuration

The following configuration is necessary in `cb-event-forwarder.conf`:
- `output_format=json` (default)

For `http` output:
- `output_type=http`
- `http_post_template=[{{range .Events}}{{.EventText}}{{end}}]`
- `content_type=application/json` (default)

For `tcp` output:
- `output_type=tcp`
- `tcpout=<Address of Elastic Agent>:<port>`

For `udp` output:
- `output_type=tcp`
- `tcpout=<Address of Elastic Agent>:<port>`

For `file` output:
- `output_type=file`
- `outfile=<path to a file readable by Elastic Agent>`

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2014-04-11T19:21:33.682Z",
      "agent": {
          "ephemeral_id": "7bb86a18-d262-4348-b206-131e38d2d1c8",
          "id": "9cb9fa70-f3e9-45d8-b1cb-61425bd93e1a",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.0.0-beta1"
      },
      "carbonblack": {
          "edr": {
              "event_timestamp": 1397244093.682,
              "feed_id": 7,
              "feed_name": "dxmtest1",
              "ioc_attr": {},
              "md5": "506708142BC63DABA64F2D3AD1DCD5BF",
              "report_id": "dxmtest1_04",
              "sensor_id": 3321
          }
      },
      "data_stream": {
          "dataset": "carbonblack_edr.log",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "9cb9fa70-f3e9-45d8-b1cb-61425bd93e1a",
          "snapshot": false,
          "version": "8.0.0-beta1"
      },
      "event": {
          "action": "unknown",
          "agent_id_status": "verified",
          "dataset": "carbonblack_edr.log",
          "ingested": "2022-01-25T07:45:03Z",
          "kind": "event",
          "original": "{\"md5\":\"506708142BC63DABA64F2D3AD1DCD5BF\",\"report_id\":\"dxmtest1_04\",\"ioc_type\":\"md5\",\"ioc_value\":\"506708142bc63daba64f2d3ad1dcd5bf\",\"ioc_attr\":{},\"feed_id\":7,\"hostname\":\"FS-SEA-529\",\"sensor_id\":3321,\"cb_version\":\"4.2.1.140808.1059\",\"server_name\":\"localhost.localdomain\",\"feed_name\":\"dxmtest1\",\"event_timestamp\":1397244093.682}\n"
      },
      "host": {
          "name": "FS-SEA-529"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "172.19.0.4:46263"
          }
      },
      "observer": {
          "name": "localhost.localdomain",
          "product": "Carbon Black EDR",
          "type": "edr",
          "vendor": "VMWare",
          "version": "4.2.1.140808.1059"
      },
      "tags": [
          "carbonblack_edr-log",
          "forwarded",
          "preserve_original_event"
      ],
      "threat": {
          "indicator": {
              "file": {
                  "hash": {
                      "md5": "506708142bc63daba64f2d3ad1dcd5bf"
                  }
              },
              "type": "file"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                            | Description                                                   | Type             |
  |--------------------------------------------------|---------------------------------------------------------------|------------------|
  | @timestamp                                       | Event timestamp.                                              | date             |
  | carbonblack.edr.action                           |                                                               | keyword          |
  | carbonblack.edr.actiontype                       |                                                               | keyword          |
  | carbonblack.edr.alert_severity                   |                                                               | double           |
  | carbonblack.edr.alert_type                       |                                                               | keyword          |
  | carbonblack.edr.blocked                          |                                                               | boolean          |
  | carbonblack.edr.blocked_event                    |                                                               | keyword          |
  | carbonblack.edr.blocked_reason                   |                                                               | keyword          |
  | carbonblack.edr.blocked_result                   |                                                               | keyword          |
  | carbonblack.edr.cb_server                        |                                                               | keyword          |
  | carbonblack.edr.cb_version                       |                                                               | keyword          |
  | carbonblack.edr.child_command_line               |                                                               | keyword          |
  | carbonblack.edr.child_pid                        |                                                               | long             |
  | carbonblack.edr.child_process_guid               |                                                               | keyword          |
  | carbonblack.edr.child_suppressed                 |                                                               | boolean          |
  | carbonblack.edr.child_username                   |                                                               | keyword          |
  | carbonblack.edr.childproc_count                  |                                                               | long             |
  | carbonblack.edr.childproc_type                   |                                                               | keyword          |
  | carbonblack.edr.command_line                     |                                                               | keyword          |
  | carbonblack.edr.comms_ip                         |                                                               | keyword          |
  | carbonblack.edr.compressed_size                  |                                                               | long             |
  | carbonblack.edr.computer_name                    |                                                               | keyword          |
  | carbonblack.edr.created                          |                                                               | boolean          |
  | carbonblack.edr.created_time                     |                                                               | keyword          |
  | carbonblack.edr.cross_process_type               |                                                               | keyword          |
  | carbonblack.edr.crossproc_count                  |                                                               | long             |
  | carbonblack.edr.digsig.issuer_name               |                                                               | keyword          |
  | carbonblack.edr.digsig.program_name              |                                                               | keyword          |
  | carbonblack.edr.digsig.publisher                 |                                                               | keyword          |
  | carbonblack.edr.digsig.result                    |                                                               | keyword          |
  | carbonblack.edr.digsig.result_code               |                                                               | keyword          |
  | carbonblack.edr.digsig.sign_time                 |                                                               | keyword          |
  | carbonblack.edr.digsig.subject_name              |                                                               | keyword          |
  | carbonblack.edr.direction                        |                                                               | keyword          |
  | carbonblack.edr.doc                              |                                                               | flattened        |
  | carbonblack.edr.domain                           |                                                               | keyword          |
  | carbonblack.edr.emet_timestamp                   |                                                               | long             |
  | carbonblack.edr.event_timestamp                  |                                                               | double           |
  | carbonblack.edr.event_type                       |                                                               | keyword          |
  | carbonblack.edr.expect_followon_w_md5            |                                                               | boolean          |
  | carbonblack.edr.feed_id                          |                                                               | keyword          |
  | carbonblack.edr.feed_name                        |                                                               | keyword          |
  | carbonblack.edr.feed_rating                      |                                                               | double           |
  | carbonblack.edr.file_md5                         |                                                               | keyword          |
  | carbonblack.edr.file_path                        |                                                               | keyword          |
  | carbonblack.edr.file_sha256                      |                                                               | keyword          |
  | carbonblack.edr.filemod_count                    |                                                               | long             |
  | carbonblack.edr.filetype                         |                                                               | keyword          |
  | carbonblack.edr.filetype_name                    |                                                               | keyword          |
  | carbonblack.edr.filtering_known_dlls             |                                                               | boolean          |
  | carbonblack.edr.group                            |                                                               | keyword          |
  | carbonblack.edr.host                             |                                                               | keyword          |
  | carbonblack.edr.hostname                         |                                                               | keyword          |
  | carbonblack.edr.icon                             |                                                               | keyword          |
  | carbonblack.edr.image_file_header                |                                                               | keyword          |
  | carbonblack.edr.interface_ip                     |                                                               | keyword          |
  | carbonblack.edr.ioc_attr                         |                                                               | flattened        |
  | carbonblack.edr.ioc_confidence                   |                                                               | double           |
  | carbonblack.edr.ioc_type                         |                                                               | keyword          |
  | carbonblack.edr.ioc_value                        |                                                               | keyword          |
  | carbonblack.edr.ipv4                             |                                                               | keyword          |
  | carbonblack.edr.is_target                        |                                                               | boolean          |
  | carbonblack.edr.ja3                              |                                                               | keyword          |
  | carbonblack.edr.ja3s                             |                                                               | keyword          |
  | carbonblack.edr.link_child                       |                                                               | keyword          |
  | carbonblack.edr.link_md5                         |                                                               | keyword          |
  | carbonblack.edr.link_parent                      |                                                               | keyword          |
  | carbonblack.edr.link_process                     |                                                               | keyword          |
  | carbonblack.edr.link_sensor                      |                                                               | keyword          |
  | carbonblack.edr.link_target                      |                                                               | keyword          |
  | carbonblack.edr.local_ip                         |                                                               | keyword          |
  | carbonblack.edr.local_port                       |                                                               | long             |
  | carbonblack.edr.log_id                           |                                                               | keyword          |
  | carbonblack.edr.log_message                      |                                                               | keyword          |
  | carbonblack.edr.md5                              |                                                               | keyword          |
  | carbonblack.edr.mitigation                       |                                                               | keyword          |
  | carbonblack.edr.modload_count                    |                                                               | long             |
  | carbonblack.edr.netconn_count                    |                                                               | long             |
  | carbonblack.edr.os_type                          |                                                               | keyword          |
  | carbonblack.edr.parent_create_time               |                                                               | long             |
  | carbonblack.edr.parent_guid                      |                                                               | keyword          |
  | carbonblack.edr.parent_md5                       |                                                               | keyword          |
  | carbonblack.edr.parent_path                      |                                                               | keyword          |
  | carbonblack.edr.parent_pid                       |                                                               | long             |
  | carbonblack.edr.parent_process_guid              |                                                               | keyword          |
  | carbonblack.edr.parent_sha256                    |                                                               | keyword          |
  | carbonblack.edr.path                             |                                                               | keyword          |
  | carbonblack.edr.pid                              |                                                               | long             |
  | carbonblack.edr.port                             |                                                               | long             |
  | carbonblack.edr.process_guid                     |                                                               | keyword          |
  | carbonblack.edr.process_id                       |                                                               | keyword          |
  | carbonblack.edr.process_name                     |                                                               | keyword          |
  | carbonblack.edr.process_path                     |                                                               | keyword          |
  | carbonblack.edr.process_unique_id                |                                                               | keyword          |
  | carbonblack.edr.protocol                         |                                                               | keyword          |
  | carbonblack.edr.proxy                            |                                                               | boolean          |
  | carbonblack.edr.regmod_count                     |                                                               | long             |
  | carbonblack.edr.remote_ip                        |                                                               | keyword          |
  | carbonblack.edr.remote_port                      |                                                               | long             |
  | carbonblack.edr.report_id                        |                                                               | keyword          |
  | carbonblack.edr.report_score                     |                                                               | long             |
  | carbonblack.edr.requested_access                 |                                                               | long             |
  | carbonblack.edr.scores.alliance_score_srstrust   |                                                               | long             |
  | carbonblack.edr.scores.alliance_score_virustotal |                                                               | long             |
  | carbonblack.edr.script                           |                                                               | keyword          |
  | carbonblack.edr.script_sha256                    |                                                               | keyword          |
  | carbonblack.edr.segment_id                       |                                                               | keyword          |
  | carbonblack.edr.sensor_criticality               |                                                               | double           |
  | carbonblack.edr.sensor_id                        |                                                               | keyword          |
  | carbonblack.edr.server_name                      |                                                               | keyword          |
  | carbonblack.edr.sha256                           |                                                               | keyword          |
  | carbonblack.edr.size                             |                                                               | long             |
  | carbonblack.edr.status                           |                                                               | keyword          |
  | carbonblack.edr.tamper                           |                                                               | boolean          |
  | carbonblack.edr.tamper_sent                      |                                                               | boolean          |
  | carbonblack.edr.tamper_type                      |                                                               | keyword          |
  | carbonblack.edr.target_create_time               |                                                               | long             |
  | carbonblack.edr.target_md5                       |                                                               | keyword          |
  | carbonblack.edr.target_path                      |                                                               | keyword          |
  | carbonblack.edr.target_pid                       |                                                               | long             |
  | carbonblack.edr.target_process_guid              |                                                               | keyword          |
  | carbonblack.edr.target_sha256                    |                                                               | keyword          |
  | carbonblack.edr.timestamp                        |                                                               | double           |
  | carbonblack.edr.type                             |                                                               | keyword          |
  | carbonblack.edr.uid                              |                                                               | keyword          |
  | carbonblack.edr.unique_id                        |                                                               | keyword          |
  | carbonblack.edr.username                         |                                                               | keyword          |
  | carbonblack.edr.utf8_comments                    |                                                               | keyword          |
  | carbonblack.edr.utf8_company_name                |                                                               | keyword          |
  | carbonblack.edr.utf8_copied_module_length        |                                                               | long             |
  | carbonblack.edr.utf8_file_description            |                                                               | keyword          |
  | carbonblack.edr.utf8_file_version                |                                                               | keyword          |
  | carbonblack.edr.utf8_internal_name               |                                                               | keyword          |
  | carbonblack.edr.utf8_legal_copyright             |                                                               | keyword          |
  | carbonblack.edr.utf8_legal_trademark             |                                                               | keyword          |
  | carbonblack.edr.utf8_on_disk_filename            |                                                               | keyword          |
  | carbonblack.edr.utf8_original_file_name          |                                                               | keyword          |
  | carbonblack.edr.utf8_private_build               |                                                               | keyword          |
  | carbonblack.edr.utf8_product_description         |                                                               | keyword          |
  | carbonblack.edr.utf8_product_name                |                                                               | keyword          |
  | carbonblack.edr.utf8_product_version             |                                                               | keyword          |
  | carbonblack.edr.utf8_special_build               |                                                               | keyword          |
  | carbonblack.edr.watchlist_id                     |                                                               | keyword          |
  | carbonblack.edr.watchlist_name                   |                                                               | keyword          |
  | carbonblack.edr.watchlists.watchlist_1           |                                                               | keyword          |
  | carbonblack.edr.watchlists.watchlist_7           |                                                               | keyword          |
  | carbonblack.edr.watchlists.watchlist_9           |                                                               | keyword          |
  | data_stream.dataset                              | Data stream dataset name.                                     | constant_keyword |
  | data_stream.namespace                            | Data stream namespace.                                        | constant_keyword |
  | data_stream.type                                 | Data stream type.                                             | constant_keyword |
  | event.dataset                                    | Event dataset                                                 | constant_keyword |
  | event.module                                     | Event module                                                  | constant_keyword |
  | host.containerized                               | If the host is a container.                                   | boolean          |
  | host.os.build                                    | OS build information.                                         | keyword          |
  | host.os.codename                                 | OS codename, if any.                                          | keyword          |
  | input.type                                       | Type of Filebeat input.                                       | keyword          |
  | log.flags                                        | Flags for the log file.                                       | keyword          |
  | log.offset                                       | Offset of the entry in the log file.                          | long             |
  | log.source.address                               | Source address from which the log event was read / sent from. | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                            | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                   | 8.13.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9399))Update manifest format version to v3.0.3.                                                                                                            | 8.0.07.14.0            |
  | **1.16.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.0.07.14.0            |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                               | 8.0.07.14.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.0.07.14.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.0.07.14.0            |
  | **1.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7965))Removing unused ECS field declarations.                                                                                                                  | 8.0.07.14.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                       | 8.0.07.14.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.0.07.14.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6613))Ensure event.kind is correctly set for pipeline errors.                                                                                              | 8.0.07.14.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                | 8.0.07.14.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                               | 8.0.07.14.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4339))Remove duplicate field.                                                                                                                              | 8.0.07.14.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3842))Update package to ECS 8.4.0                                                                                                                          | 8.0.07.14.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                         | 8.0.07.14.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3440))Add JA3/JA3S parsing                                                                                                                                 | 8.0.07.14.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                    | 8.0.07.14.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                   | 8.0.07.14.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2385))Update to ECS 8.0                                                                                                                                    | 8.0.07.14.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2360))GA integration                                                                                                                                       | 8.0.07.14.0            |
  | **0.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                           |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2232))Add 8.0.0 version constraint                                                                                                                         |                        |
  | **0.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1949))Update Title and Description.                                                                                                                        |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1801))Fix logic that checks for the 'forwarded' tag                                                                                                            |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1651))Update to ECS 1.12.0                                                                                                                                 |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1527))initial release                                                                                                                                      |                        |
</dropdown>