﻿---
title: VMware Carbon Black Cloud
description: The VMware Carbon Black Cloud integration collects and parses data from the Carbon Black Cloud REST APIs and AWS S3 bucket. Agentless integrations allow...
url: https://www.elastic.co/docs/reference/integrations/carbon_black_cloud
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# VMware Carbon Black Cloud
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 4.2.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, AWS S3                    |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4               |

The VMware Carbon Black Cloud integration collects and parses data from the Carbon Black Cloud REST APIs and AWS S3 bucket.

## Agentless Enabled Integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

## Version 1.21+ Update Disclaimer

Starting from version 1.21, if using multiple AWS data streams simultaneously configured to use AWS SQS, separate SQS queues should be configured per
data stream. The default values of file selector regexes have been commented out for this reason. The only reason the global queue now exists is to avoid
a breaking change while upgrading to version 1.21 and above. A separate SQS queue per data stream should help fix the data loss that's been occurring in the
older versions.

## HTTPJSON vs CEL

Version 2.0.0 introduces the use of the CEL input. The HTTPJSON input method has been marked as [Legacy], it will not receive enhancement changes and will not support the new `alert_v7` data stream.

## Note (Important)

1. Do not enable both the HTTPJSON and CEL input methods within a single data stream; having both enabled simultaneously can cause unexpected/duplicated results, as they operate on the same data streams.


## Compatibility

This module has been tested against `Alerts API (v7)`, `Audit Log Events (v3)` and `Vulnerability Assessment (v1)`.

## Requirements


### In order to ingest data from the AWS S3 bucket you must:

1. Configure the [Data Forwarder](https://docs.vmware.com/en/VMware-Carbon-Black-Cloud/services/carbon-black-cloud-user-guide/GUID-F68F63DD-2271-4088-82C9-71D675CD0535.html) to ingest data into an AWS S3 bucket.
2. Create an [AWS Access Keys and Secret Access Keys](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).
3. The default values of the "Bucket List Prefix" are listed below. However, users can set the parameter "Bucket List Prefix" according to their requirements.


| Data Stream Name | Bucket List Prefix  |
|------------------|---------------------|
| Alert_v7         | alert_logs_v7       |
| Endpoint Event   | endpoint_event_logs |
| Watchlist Hit    | watchlist_hit_logs  |


### To collect data from AWS SQS, follow the below steps:

1. If data forwarding to an AWS S3 Bucket hasn't been configured, then first setup an AWS S3 Bucket as mentioned in the above documentation.
2. Follow the steps below for each data stream that has been enabled:
   1. Create an SQS queue
   - To setup an SQS queue, follow "Step 1: Create an Amazon SQS queue" mentioned in the [Amazon documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ways-to-add-notification-config-to-bucket.html).
- While creating an SQS Queue, please provide the same bucket ARN that has been generated after creating an AWS S3 Bucket.
2. Setup event notification from the S3 bucket using the instructions [here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-event-notifications.html). Use the following settings:
   - Event type: `All object create events` (`s3:ObjectCreated:*`)
- Destination: SQS Queue
- Prefix (filter): enter the prefix for this data stream, e.g. `alert_logs_v7/`
- Select the SQS queue that has been created for this data stream

**Note**:
- A separate SQS queue and S3 bucket notification is required for each enabled data stream.
- Permissions for the above AWS S3 bucket and SQS queues should be configured according to the [Filebeat S3 input documentation](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-aws-s3.html#_aws_permissions_2)
- Data collection via AWS S3 Bucket and AWS SQS are mutually exclusive in this case.


### In order to ingest data from the APIs you must generate API keys and API Secret Keys:

1. In Carbon Black Cloud, On the left navigation pane, click **Settings > API Access**.
2. Click Add API Key.
3. Give the API key a unique name and description.
   - Select the appropriate access level type. Please check the required Access Levels & Permissions for integration in the table below.

  **Note:** To use a custom access level, select Custom from the Access Level type drop-down menu and specify the Custom Access Level.
- Optional: Add authorized IP addresses.
- You can restrict the use of an API key to a specific set of IP addresses for security reasons.

  **Note:** Authorized IP addresses are not available with Custom keys.
4. To apply the changes, click Save.


#### Access Levels & Permissions

- The following tables indicate which type of API Key access level is required. If the type is Custom then the permission that is required will also be included.


| Data stream                 | Access Level and Permissions               |
|-----------------------------|--------------------------------------------|
| Audit                       | API                                        |
| Alert v7                    | Custom orgs.alerts (Read)                  |
| Asset Vulnerability Summary | Custom vulnerabilityAssessment.data (Read) |


## Logs


### Audit

This is the `audit` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-02-10T16:04:30.263Z",
      "agent": {
          "ephemeral_id": "d9810f80-bccc-4900-886c-c14f1747369d",
          "id": "e535dae1-9d56-4f72-9e5b-bd456d3edb8f",
          "name": "elastic-agent-33765",
          "type": "filebeat",
          "version": "8.18.1"
      },
      "carbon_black_cloud": {
          "audit": {
              "flagged": false,
              "verbose": false
          }
      },
      "client": {
          "ip": "10.10.10.10",
          "user": {
              "domain": "example.com",
              "email": "abc@example.com",
              "id": "abc@example.com",
              "name": "abc"
          }
      },
      "data_stream": {
          "dataset": "carbon_black_cloud.audit",
          "namespace": "18603",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e535dae1-9d56-4f72-9e5b-bd456d3edb8f",
          "snapshot": false,
          "version": "8.18.1"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "carbon_black_cloud.audit",
          "id": "2122f8ce8xxxxxxxxxxxxx",
          "ingested": "2025-06-02T15:02:56Z",
          "kind": "event",
          "original": "{\"clientIp\":\"10.10.10.10\",\"description\":\"Logged in successfully\",\"eventId\":\"2122f8ce8xxxxxxxxxxxxx\",\"eventTime\":1644509070263,\"flagged\":false,\"loginName\":\"abc@example.com\",\"orgName\":\"cb-xxxx-xxxx.com\",\"requestUrl\":null,\"verbose\":false}",
          "outcome": "success",
          "reason": "Logged in successfully"
      },
      "input": {
          "type": "cel"
      },
      "organization": {
          "name": "cb-xxxx-xxxx.com"
      },
      "related": {
          "ip": [
              "10.10.10.10"
          ],
          "user": [
              "abc@example.com",
              "abc"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "carbon_black_cloud-audit"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                            | Description                                | Type             |
  |----------------------------------|--------------------------------------------|------------------|
  | @timestamp                       | Event timestamp.                           | date             |
  | carbon_black_cloud.audit.flagged | true if action is failed otherwise false.  | boolean          |
  | carbon_black_cloud.audit.verbose | true if verbose audit log otherwise false. | boolean          |
  | cloud.image.id                   | Image ID for the cloud instance.           | keyword          |
  | data_stream.dataset              | Data stream dataset.                       | constant_keyword |
  | data_stream.namespace            | Data stream namespace.                     | constant_keyword |
  | data_stream.type                 | Data stream type.                          | constant_keyword |
  | event.dataset                    | Event dataset.                             | constant_keyword |
  | event.module                     | Event module.                              | constant_keyword |
  | host.containerized               | If the host is a container.                | boolean          |
  | host.os.build                    | OS build information.                      | keyword          |
  | host.os.codename                 | OS codename, if any.                       | keyword          |
  | input.type                       | Input type                                 | keyword          |
  | log.offset                       | Log offset                                 | long             |
</dropdown>


### Alert

This is the `alert_v7` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-13T08:02:36.578Z",
      "agent": {
          "ephemeral_id": "a14ca29b-52fd-47c3-8c78-eac114e3066b",
          "id": "56b48df4-ab0d-427b-b3a5-180a58126f21",
          "name": "elastic-agent-82807",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "carbon_black_cloud": {
          "alert": {
              "alert_notes_present": false,
              "backend_timestamp": "2024-03-13T08:03:29.540Z",
              "backend_update_timestamp": "2024-03-13T08:03:29.540Z",
              "category": "THREAT",
              "determination": {
                  "change_timestamp": "2024-03-13T08:03:29.540Z",
                  "changed_by": "ALERT_CREATION",
                  "changed_by_type": "SYSTEM",
                  "value": "NONE"
              },
              "device": {
                  "external_ip": "75.98.230.194",
                  "internal_ip": "172.16.100.140",
                  "location": "UNKNOWN",
                  "os": "WINDOWS",
                  "policy": "default",
                  "policy_id": 6525,
                  "target_value": "MEDIUM"
              },
              "ioc": {
                  "hit": "(fileless_scriptload_cmdline:Register-ScheduledTask OR fileless_scriptload_cmdline:New-ScheduledTask OR scriptload_content:Register-ScheduledTask OR scriptload_content:New-ScheduledTask) AND NOT (process_cmdline:windows\\\\ccm\\\\systemtemp OR crossproc_name:windows\\\\ccm\\\\ccmexec.exe OR (process_publisher:\"VMware, Inc.\" AND process_publisher_state:FILE_SIGNATURE_STATE_TRUSTED))",
                  "id": "d1080521-e617-4e45-94e0-7a145c62c90a"
              },
              "is_updated": false,
              "mdr": {
                  "alert": false,
                  "alert_notes_present": false,
                  "threat_notes_present": false
              },
              "ml_classification_final_verdict": "NOT_ANOMALOUS",
              "ml_classification_global_prevalence": "LOW",
              "ml_classification_org_prevalence": "LOW",
              "organization_key": "7DESJ9GN",
              "parent": {
                  "cmdline": "C:\\Windows\\system32\\svchost.exe -k netsvcs -p -s Schedule",
                  "effective_reputation": "TRUSTED_WHITE_LIST",
                  "guid": "7DESJ9GN-0064e5a7-0000077c-00000000-1da5ed7ec07b275",
                  "hash": {
                      "md5": "145dcf6706eeea5b066885ee17964c09",
                      "sha256": "f13de58416730d210dab465b242e9c949fb0a0245eef45b07c381f0c6c8a43c3"
                  },
                  "name": "c:\\windows\\system32\\svchost.exe",
                  "pid": 1916,
                  "reputation": "TRUSTED_WHITE_LIST",
                  "username": "NT AUTHORITY\\SYSTEM"
              },
              "policy_applied": "NOT_APPLIED",
              "primary_event_id": "re9M9hp8TbGLqyk6QXqQqA-0",
              "process": {
                  "cmdline": "\"C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe\" -EP Bypass \\\\eip.demo\\sysvol\\EIP.DEMO\\scripts\\Luminol.ps1",
                  "effective_reputation": "TRUSTED_WHITE_LIST",
                  "guid": "7DESJ9GN-0064e5a7-00001434-00000000-1da751c7354ebfe",
                  "hash": {
                      "md5": "2e5a8590cf6848968fc23de3fa1e25f1",
                      "sha256": "9785001b0dcf755eddb8af294a373c0b87b2498660f724e76c4d53f9c217c7a3"
                  },
                  "issuer": [
                      "Microsoft Windows Production PCA 2011"
                  ],
                  "name": "c:\\windows\\system32\\windowspowershell\\v1.0\\powershell.exe",
                  "pid": 5172,
                  "publisher": [
                      "Microsoft Windows"
                  ],
                  "reputation": "TRUSTED_WHITE_LIST",
                  "username": "NT AUTHORITY\\SYSTEM"
              },
              "reason_code": "c21ca826-573a-3d97-8c1e-93c8471aab7f:8033b29d-81d2-3c47-82d2-f4a7f398b85d",
              "report": {
                  "description": "Newer Powershell versions introduced built-in cmdlets to manage scheduled tasks natively without calling out to typical scheduled task processes like at.exe or schtasks.exe. This detection looks for behaviors related to the fileless execution of scheduled tasks. If you are responding to this alert, be sure to correlate the fileless scriptload events with events typically found in your environment Generally, attackers will create scheduled tasks with binaries that are located in user writable directories like AppData, Temp, or public folders.",
                  "id": "LrKOC7DtQbm4g8w0UFruQg-d1080521-e617-4e45-94e0-7a145c62c90a",
                  "link": "https://attack.mitre.org/techniques/T1053/",
                  "name": "Execution - AMSI - New Fileless Scheduled Task Behavior Detected",
                  "tags": [
                      "execution",
                      "privesc",
                      "persistence",
                      "t1053",
                      "windows",
                      "amsi",
                      "attack",
                      "attackframework"
                  ]
              },
              "run_state": "RAN",
              "sensor_action": "ALLOW",
              "threat_id": "C21CA826573A8D974C1E93C8471AAB7F",
              "threat_notes_present": false,
              "type": "WATCHLIST",
              "url": "defense.conferdeploy.net/alerts?s[c][query_string]=id:1c6aba68-24cc-41e3-ad8e-4b545a587b55&orgKey=7DESJ9GN",
              "watchlists": [
                  {
                      "id": "Ci7w5B4URg6HN60hatQMQ",
                      "name": "AMSI Threat Intelligence"
                  }
              ],
              "workflow": {
                  "change_timestamp": "2024-03-13T08:03:29.540Z",
                  "changed_by": "ALERT_CREATION",
                  "changed_by_type": "SYSTEM",
                  "closure_reason": "NO_REASON",
                  "status": "OPEN"
              }
          }
      },
      "data_stream": {
          "dataset": "carbon_black_cloud.alert_v7",
          "namespace": "31466",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "56b48df4-ab0d-427b-b3a5-180a58126f21",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "carbon_black_cloud.alert_v7",
          "end": "2024-03-13T08:00:09.894Z",
          "id": "1c6aba68-24cc-41e3-ad8e-4b545a587b55",
          "ingested": "2025-10-23T08:42:32Z",
          "kind": "alert",
          "original": "{\"alert_notes_present\":false,\"alert_url\":\"defense.conferdeploy.net/alerts?s[c][query_string]=id:1c6aba68-24cc-41e3-ad8e-4b545a587b55\\u0026orgKey=7DESJ9GN\",\"asset_group\":[],\"backend_timestamp\":\"2024-03-13T08:03:29.540Z\",\"backend_update_timestamp\":\"2024-03-13T08:03:29.540Z\",\"childproc_cmdline\":\"\",\"childproc_guid\":\"\",\"childproc_username\":\"\",\"detection_timestamp\":\"2024-03-13T08:02:36.578Z\",\"determination\":{\"change_timestamp\":\"2024-03-13T08:03:29.540Z\",\"changed_by\":\"ALERT_CREATION\",\"changed_by_type\":\"SYSTEM\",\"value\":\"NONE\"},\"device_external_ip\":\"75.98.230.194\",\"device_id\":6612391,\"device_internal_ip\":\"172.16.100.140\",\"device_location\":\"UNKNOWN\",\"device_name\":\"EIP\\\\WW-20002\",\"device_os\":\"WINDOWS\",\"device_os_version\":\"Windows 10 x64\",\"device_policy\":\"default\",\"device_policy_id\":6525,\"device_target_value\":\"MEDIUM\",\"device_uem_id\":\"\",\"device_username\":\"EIP\\\\Administrator\",\"first_event_timestamp\":\"2024-03-13T08:00:09.894Z\",\"id\":\"1c6aba68-24cc-41e3-ad8e-4b545a587b55\",\"ioc_hit\":\"(fileless_scriptload_cmdline:Register-ScheduledTask OR fileless_scriptload_cmdline:New-ScheduledTask OR scriptload_content:Register-ScheduledTask OR scriptload_content:New-ScheduledTask) AND NOT (process_cmdline:windows\\\\\\\\ccm\\\\\\\\systemtemp OR crossproc_name:windows\\\\\\\\ccm\\\\\\\\ccmexec.exe OR (process_publisher:\\\"VMware, Inc.\\\" AND process_publisher_state:FILE_SIGNATURE_STATE_TRUSTED))\",\"ioc_id\":\"d1080521-e617-4e45-94e0-7a145c62c90a\",\"is_updated\":false,\"last_event_timestamp\":\"2024-03-13T08:00:09.894Z\",\"mdr_alert\":false,\"mdr_alert_notes_present\":false,\"mdr_threat_notes_present\":false,\"ml_classification_anomalies\":[],\"ml_classification_final_verdict\":\"NOT_ANOMALOUS\",\"ml_classification_global_prevalence\":\"LOW\",\"ml_classification_org_prevalence\":\"LOW\",\"org_key\":\"7DESJ9GN\",\"parent_cmdline\":\"C:\\\\Windows\\\\system32\\\\svchost.exe -k netsvcs -p -s Schedule\",\"parent_effective_reputation\":\"TRUSTED_WHITE_LIST\",\"parent_guid\":\"7DESJ9GN-0064e5a7-0000077c-00000000-1da5ed7ec07b275\",\"parent_md5\":\"145dcf6706eeea5b066885ee17964c09\",\"parent_name\":\"c:\\\\windows\\\\system32\\\\svchost.exe\",\"parent_pid\":1916,\"parent_reputation\":\"TRUSTED_WHITE_LIST\",\"parent_sha256\":\"f13de58416730d210dab465b242e9c949fb0a0245eef45b07c381f0c6c8a43c3\",\"parent_username\":\"NT AUTHORITY\\\\SYSTEM\",\"policy_applied\":\"NOT_APPLIED\",\"primary_event_id\":\"re9M9hp8TbGLqyk6QXqQqA-0\",\"process_cmdline\":\"\\\"C:\\\\Windows\\\\System32\\\\WindowsPowerShell\\\\v1.0\\\\powershell.exe\\\" -EP Bypass \\\\\\\\eip.demo\\\\sysvol\\\\EIP.DEMO\\\\scripts\\\\Luminol.ps1\",\"process_effective_reputation\":\"TRUSTED_WHITE_LIST\",\"process_guid\":\"7DESJ9GN-0064e5a7-00001434-00000000-1da751c7354ebfe\",\"process_issuer\":[\"Microsoft Windows Production PCA 2011\"],\"process_md5\":\"2e5a8590cf6848968fc23de3fa1e25f1\",\"process_name\":\"c:\\\\windows\\\\system32\\\\windowspowershell\\\\v1.0\\\\powershell.exe\",\"process_pid\":5172,\"process_publisher\":[\"Microsoft Windows\"],\"process_reputation\":\"TRUSTED_WHITE_LIST\",\"process_sha256\":\"9785001b0dcf755eddb8af294a373c0b87b2498660f724e76c4d53f9c217c7a3\",\"process_username\":\"NT AUTHORITY\\\\SYSTEM\",\"reason\":\"Process powershell.exe was detected by the report \\\"Execution - AMSI - New Fileless Scheduled Task Behavior Detected\\\" in watchlist \\\"AMSI Threat Intelligence\\\"\",\"reason_code\":\"c21ca826-573a-3d97-8c1e-93c8471aab7f:8033b29d-81d2-3c47-82d2-f4a7f398b85d\",\"report_description\":\"Newer Powershell versions introduced built-in cmdlets to manage scheduled tasks natively without calling out to typical scheduled task processes like at.exe or schtasks.exe. This detection looks for behaviors related to the fileless execution of scheduled tasks. If you are responding to this alert, be sure to correlate the fileless scriptload events with events typically found in your environment Generally, attackers will create scheduled tasks with binaries that are located in user writable directories like AppData, Temp, or public folders.\",\"report_id\":\"LrKOC7DtQbm4g8w0UFruQg-d1080521-e617-4e45-94e0-7a145c62c90a\",\"report_link\":\"https://attack.mitre.org/techniques/T1053/\",\"report_name\":\"Execution - AMSI - New Fileless Scheduled Task Behavior Detected\",\"report_tags\":[\"execution\",\"privesc\",\"persistence\",\"t1053\",\"windows\",\"amsi\",\"attack\",\"attackframework\"],\"run_state\":\"RAN\",\"sensor_action\":\"ALLOW\",\"severity\":5,\"tags\":null,\"threat_id\":\"C21CA826573A8D974C1E93C8471AAB7F\",\"threat_notes_present\":false,\"type\":\"WATCHLIST\",\"user_update_timestamp\":null,\"watchlists\":[{\"id\":\"Ci7w5B4URg6HN60hatQMQ\",\"name\":\"AMSI Threat Intelligence\"}],\"workflow\":{\"change_timestamp\":\"2024-03-13T08:03:29.540Z\",\"changed_by\":\"ALERT_CREATION\",\"changed_by_type\":\"SYSTEM\",\"closure_reason\":\"NO_REASON\",\"status\":\"OPEN\"}}",
          "reason": "Process powershell.exe was detected by the report \"Execution - AMSI - New Fileless Scheduled Task Behavior Detected\" in watchlist \"AMSI Threat Intelligence\"",
          "severity": 5,
          "start": "2024-03-13T08:00:09.894Z"
      },
      "host": {
          "hostname": "WW-20002",
          "id": "6612391",
          "name": "WW-20002",
          "os": {
              "type": "windows",
              "version": "Windows 10 x64"
          }
      },
      "input": {
          "type": "cel"
      },
      "process": {
          "command_line": "\"C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe\" -EP Bypass \\\\eip.demo\\sysvol\\EIP.DEMO\\scripts\\Luminol.ps1",
          "entity_id": "7DESJ9GN-0064e5a7-00001434-00000000-1da751c7354ebfe",
          "executable": "c:\\windows\\system32\\windowspowershell\\v1.0\\powershell.exe",
          "hash": {
              "md5": "2e5a8590cf6848968fc23de3fa1e25f1",
              "sha256": "9785001b0dcf755eddb8af294a373c0b87b2498660f724e76c4d53f9c217c7a3"
          },
          "name": "powershell.exe",
          "parent": {
              "command_line": "C:\\Windows\\system32\\svchost.exe -k netsvcs -p -s Schedule",
              "entity_id": "7DESJ9GN-0064e5a7-0000077c-00000000-1da5ed7ec07b275",
              "executable": "c:\\windows\\system32\\svchost.exe",
              "hash": {
                  "md5": "145dcf6706eeea5b066885ee17964c09",
                  "sha256": "f13de58416730d210dab465b242e9c949fb0a0245eef45b07c381f0c6c8a43c3"
              },
              "name": "svchost.exe",
              "pid": 1916
          },
          "pid": 5172
      },
      "related": {
          "hash": [
              "f13de58416730d210dab465b242e9c949fb0a0245eef45b07c381f0c6c8a43c3",
              "145dcf6706eeea5b066885ee17964c09",
              "9785001b0dcf755eddb8af294a373c0b87b2498660f724e76c4d53f9c217c7a3",
              "2e5a8590cf6848968fc23de3fa1e25f1"
          ],
          "hosts": [
              "WW-20002",
              "EIP"
          ],
          "user": [
              "Administrator"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "carbon_black_cloud-alert"
      ],
      "user": {
          "domain": "EIP",
          "name": "Administrator"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                          | Description                                                                                                                                      | Type             |
  |----------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                     | Event timestamp.                                                                                                                                 | date             |
  | aws.s3.bucket.arn                                              | The AWS S3 bucket ARN.                                                                                                                           | keyword          |
  | aws.s3.bucket.name                                             | The AWS S3 bucket name.                                                                                                                          | keyword          |
  | aws.s3.object.key                                              | The AWS S3 Object key.                                                                                                                           | keyword          |
  | carbon_black_cloud.alert.additional_events_present             | Indicator to let API and forwarder users know that they should look up other associated events related to this alert.                            | boolean          |
  | carbon_black_cloud.alert.alert_notes_present                   | Indicates if notes are associated with the alert.                                                                                                | boolean          |
  | carbon_black_cloud.alert.attack_tactic                         | S tactic from the MITRE ATT&CK framework.                                                                                                        | keyword          |
  | carbon_black_cloud.alert.attack_technique                      | Technique from the MITRE ATT&CK framework.                                                                                                       | keyword          |
  | carbon_black_cloud.alert.backend_timestamp                     | Timestamp when the alert was first detected by the Carbon Black Cloud backend, it is a ISO 8601 UTC timestamp.                                   | date             |
  | carbon_black_cloud.alert.backend_update_timestamp              | The last time the alert was updated in Carbon Black Cloud, it is a ISO 8601 UTC timestamp.                                                       | date             |
  | carbon_black_cloud.alert.blocked_process.effective_reputation  | Effective reputation of the blocked file or process; applied by the sensor at the time the block occurred.                                       | keyword          |
  | carbon_black_cloud.alert.blocked_process.hash.md5              | MD5 hash of the child process binary; for any process terminated by the sensor.                                                                  | keyword          |
  | carbon_black_cloud.alert.blocked_process.hash.sha256           | SHA-256 hash of the child process binary; for any process terminated by the sensor.                                                              | keyword          |
  | carbon_black_cloud.alert.blocked_process.name                  | Tokenized file path of the files blocked by sensor action.                                                                                       | keyword          |
  | carbon_black_cloud.alert.category                              | The category of the alert.                                                                                                                       | keyword          |
  | carbon_black_cloud.alert.childproc.cmdline                     | Command line executed by the child process.                                                                                                      | keyword          |
  | carbon_black_cloud.alert.childproc.effective_reputation        | Effective reputation of the child process hash.                                                                                                  | keyword          |
  | carbon_black_cloud.alert.childproc.guid                        | Guid of the child process that has fired the alert.                                                                                              | keyword          |
  | carbon_black_cloud.alert.childproc.hash.md5                    | MD5 hash of the child process.                                                                                                                   | keyword          |
  | carbon_black_cloud.alert.childproc.hash.sha256                 | SHA-256 hash of the child process.                                                                                                               | keyword          |
  | carbon_black_cloud.alert.childproc.name                        | Filesystem path of the child process binary.                                                                                                     | keyword          |
  | carbon_black_cloud.alert.childproc.username                    | User context in which the child process was executed.                                                                                            | keyword          |
  | carbon_black_cloud.alert.connection_type                       | The type of network connection (e.g., EGRESS, INGRESS).                                                                                          | keyword          |
  | carbon_black_cloud.alert.determination.change_timestamp        | Timestamp of the determination change                                                                                                            | date             |
  | carbon_black_cloud.alert.determination.changed_by              | Entity that changed the determination                                                                                                            | keyword          |
  | carbon_black_cloud.alert.determination.changed_by_type         | Type of entity that changed the determination                                                                                                    | keyword          |
  | carbon_black_cloud.alert.determination.value                   | Value of the determination                                                                                                                       | keyword          |
  | carbon_black_cloud.alert.device.external_ip                    | IP address of the endpoint according to the Carbon Black Cloud; can differ from device_internal_ip due to network proxy or NAT.                  | keyword          |
  | carbon_black_cloud.alert.device.internal_ip                    | IP address of the endpoint reported by the sensor.                                                                                               | keyword          |
  | carbon_black_cloud.alert.device.location                       | Whether the device was on or off premises when the alert started, based on the current IP address and the device’s registered DNS domain suffix. | keyword          |
  | carbon_black_cloud.alert.device.os                             | OS of the device.                                                                                                                                | keyword          |
  | carbon_black_cloud.alert.device.policy                         | The name of the device policy associated with the device at the time of the alert.                                                               | keyword          |
  | carbon_black_cloud.alert.device.policy_id                      | The identifier for the device policy associated with the device at the time of the alert.                                                        | integer          |
  | carbon_black_cloud.alert.device.target_value                   | Target value assigned to the device, set from the policy.                                                                                        | keyword          |
  | carbon_black_cloud.alert.device.uem_id                         | Device correlation with WS1/EUC, required for our Workspace ONE Intelligence integration to function.                                            | keyword          |
  | carbon_black_cloud.alert.egress_group_id                       | The unique identifier of the egress group associated with the event.                                                                             | keyword          |
  | carbon_black_cloud.alert.egress_group_name                     | The name of the egress group associated with the event.                                                                                          | keyword          |
  | carbon_black_cloud.alert.ioc.field                             | The field the indicator of comprise (IOC) hit contains.                                                                                          | keyword          |
  | carbon_black_cloud.alert.ioc.hit                               | IOC field value or IOC query that matches.                                                                                                       | keyword          |
  | carbon_black_cloud.alert.ioc.id                                | The identifier of the IOC that cause the hit.                                                                                                    | keyword          |
  | carbon_black_cloud.alert.ip_reputation                         | The reputation score of the IP address associated with the event.                                                                                | integer          |
  | carbon_black_cloud.alert.is_updated                            | Set to true if this is an updated copy of the alert initiated by the Carbon Black Cloud backend.                                                 | boolean          |
  | carbon_black_cloud.alert.k8s_cluster                           | The Kubernetes cluster associated with the event.                                                                                                | keyword          |
  | carbon_black_cloud.alert.k8s_kind                              | The type of Kubernetes resource associated with the event (e.g., Pod, DaemonSet).                                                                | keyword          |
  | carbon_black_cloud.alert.k8s_namespace                         | The Kubernetes namespace associated with the event.                                                                                              | keyword          |
  | carbon_black_cloud.alert.k8s_pod_name                          | The name of the Kubernetes pod associated with the event.                                                                                        | keyword          |
  | carbon_black_cloud.alert.k8s_policy                            | The name of the Kubernetes policy associated with the event.                                                                                     | keyword          |
  | carbon_black_cloud.alert.k8s_policy_id                         | The unique identifier of the Kubernetes policy associated with the event.                                                                        | keyword          |
  | carbon_black_cloud.alert.k8s_rule                              | The name of the Kubernetes rule associated with the event.                                                                                       | keyword          |
  | carbon_black_cloud.alert.k8s_rule_id                           | The unique identifier of the Kubernetes rule associated with the event.                                                                          | keyword          |
  | carbon_black_cloud.alert.k8s_workload_name                     | The name of the Kubernetes workload associated with the event.                                                                                   | keyword          |
  | carbon_black_cloud.alert.mdr.alert                             | Is the alert eligible for review by Carbon Black MDR Analysts.                                                                                   | boolean          |
  | carbon_black_cloud.alert.mdr.alert_notes_present               | Customer visible notes at the alert level that were added by a MDR analyst.                                                                      | boolean          |
  | carbon_black_cloud.alert.mdr.classification.change_timestamp   | WWhen the last MDR classification change occurred, it is a ISO 8601 UTC timestamp.                                                               | date             |
  | carbon_black_cloud.alert.mdr.determination.change_timestamp    | When the last MDR classification change occurred, it is a ISO 8601 UTC timestamp.                                                                | date             |
  | carbon_black_cloud.alert.mdr.determination.value               | A record that identifies the whether the alert was determined to represent a likely or unlikely threat.                                          | keyword          |
  | carbon_black_cloud.alert.mdr.threat_notes_present              | Customer visible notes at the threat level that were added by a MDR analyst.                                                                     | boolean          |
  | carbon_black_cloud.alert.mdr.workflow.change_timestamp         | WWhen the last MDR status change occurred, it is a ISO 8601 UTC timestamp.                                                                       | date             |
  | carbon_black_cloud.alert.mdr.workflow.is_assigned              | If the workflow is assigned or not.                                                                                                              | boolean          |
  | carbon_black_cloud.alert.mdr.workflow.status                   | Primary value used to capture status change during MD Analyst's alert triage.                                                                    | boolean          |
  | carbon_black_cloud.alert.ml_classification_anomalies           | An list of anomalies detected by the machine learning classification.                                                                            | keyword          |
  | carbon_black_cloud.alert.ml_classification_final_verdict       | Final verdict of the alert, based on the ML models that were used to make the prediction.                                                        | keyword          |
  | carbon_black_cloud.alert.ml_classification_global_prevalence   | Categories (low/medium/high) used to describe the prevalence of alerts across all regional organizations.                                        | keyword          |
  | carbon_black_cloud.alert.ml_classification_org_prevalence      | TCategories (low/medium/high) used to describe the prevalence of alerts within an organization.                                                  | keyword          |
  | carbon_black_cloud.alert.netconn.local_ip                      | IP address of the local side of the network connection.                                                                                          | ip               |
  | carbon_black_cloud.alert.netconn.local_ipv4                    | IPv4 address of the local side of the network connection.                                                                                        | ip               |
  | carbon_black_cloud.alert.netconn.local_ipv6                    | IPv6 address of the local side of the network connection.                                                                                        | ip               |
  | carbon_black_cloud.alert.netconn.local_port                    | TCP or UDP port used by the local side of the network connection.                                                                                | integer          |
  | carbon_black_cloud.alert.netconn.protocol                      | Network protocol of the network connection.                                                                                                      | keyword          |
  | carbon_black_cloud.alert.netconn.remote_domain                 | Domain name (FQDN) associated with the remote end of the network connection.                                                                     | keyword          |
  | carbon_black_cloud.alert.netconn.remote_ip                     | IP address of the remote side of the network connection.                                                                                         | ip               |
  | carbon_black_cloud.alert.netconn.remote_ipv4                   | IPv4 address of the remote side of the network connection.                                                                                       | ip               |
  | carbon_black_cloud.alert.netconn.remote_ipv6                   | IPv6 address of the remote side of the network connection.                                                                                       | ip               |
  | carbon_black_cloud.alert.netconn.remote_port                   | TCP or UDP port used by the remote side of the network connection; same as netconn_port and event_network_remote_port.                           | integer          |
  | carbon_black_cloud.alert.org_feature_entitlement               | The feature entitlement of the organization.                                                                                                     | keyword          |
  | carbon_black_cloud.alert.organization_key                      | The unique identifier for the organization associated with the alert.                                                                            | keyword          |
  | carbon_black_cloud.alert.parent.cmdline                        | Command line executed by the parent process.                                                                                                     | keyword          |
  | carbon_black_cloud.alert.parent.effective_reputation           | Effective reputation of the parent hash.                                                                                                         | keyword          |
  | carbon_black_cloud.alert.parent.guid                           | Guid of the parent process that has fired the alert.                                                                                             | keyword          |
  | carbon_black_cloud.alert.parent.hash.md5                       | MD5 hash of the parent process.                                                                                                                  | keyword          |
  | carbon_black_cloud.alert.parent.hash.sha256                    | SHA-256 hash of the parent process.                                                                                                              | keyword          |
  | carbon_black_cloud.alert.parent.name                           | Filesystem path of the parent process binary.                                                                                                    | keyword          |
  | carbon_black_cloud.alert.parent.pid                            | PID of the parent process that has fired the alert.                                                                                              | long             |
  | carbon_black_cloud.alert.parent.reputation                     | Reputation of the parent process; applied when event is processed by the Carbon Black Cloud.                                                     | keyword          |
  | carbon_black_cloud.alert.parent.username                       | User context in which the parent process was executed.                                                                                           | keyword          |
  | carbon_black_cloud.alert.policy_applied                        | Whether a policy was applied.                                                                                                                    | keyword          |
  | carbon_black_cloud.alert.primary_event_id                      | ID of the primary event in the alert.                                                                                                            | keyword          |
  | carbon_black_cloud.alert.process.cmdline                       | Command line executed by the actor process.                                                                                                      | keyword          |
  | carbon_black_cloud.alert.process.effective_reputation          | Effective reputation of the actor hash.                                                                                                          | keyword          |
  | carbon_black_cloud.alert.process.guid                          | Guid of the process that has fired the alert.                                                                                                    | keyword          |
  | carbon_black_cloud.alert.process.hash.md5                      | MD5 hash of the process.                                                                                                                         | keyword          |
  | carbon_black_cloud.alert.process.hash.sha256                   | SHA-256 hash of the process.                                                                                                                     | keyword          |
  | carbon_black_cloud.alert.process.issuer                        | The certificate authority associated with the process's certificate.                                                                             | keyword          |
  | carbon_black_cloud.alert.process.name                          | Filesystem path of the actor process binary.                                                                                                     | keyword          |
  | carbon_black_cloud.alert.process.pid                           | PID of the process that has fired the alert.                                                                                                     | long             |
  | carbon_black_cloud.alert.process.publisher                     | Publisher name on the certificate used to sign the Windows or macOS process binary.                                                              | keyword          |
  | carbon_black_cloud.alert.process.reputation                    | Reputation of the actor process; applied when event is processed by the Carbon Black Cloud.                                                      | keyword          |
  | carbon_black_cloud.alert.process.username                      | User context in which the actor process was executed.                                                                                            | keyword          |
  | carbon_black_cloud.alert.product_id                            | The hexadecimal id of the USB device's product.                                                                                                  | keyword          |
  | carbon_black_cloud.alert.product_name                          | The name of the USB device's vendor.                                                                                                             | keyword          |
  | carbon_black_cloud.alert.reason                                | A spoken language written explanation of the what and why the alert occurred and any action taken.                                               | keyword          |
  | carbon_black_cloud.alert.reason_code                           | Shorthand enum for the full-text reason.                                                                                                         | keyword          |
  | carbon_black_cloud.alert.remote_is_private                     | Indicates whether the remote IP address is private or not.                                                                                       | boolean          |
  | carbon_black_cloud.alert.report.description                    | Description of the IOC report associated with the alert.                                                                                         | keyword          |
  | carbon_black_cloud.alert.report.id                             | The identifier of the report that contains the IOC.                                                                                              | keyword          |
  | carbon_black_cloud.alert.report.link                           | Link of reports that contained the IOC that caused a hit.                                                                                        | keyword          |
  | carbon_black_cloud.alert.report.name                           | The name of the report that contains the IOC.                                                                                                    | keyword          |
  | carbon_black_cloud.alert.report.tags                           | Tags associated with the IOC report.                                                                                                             | keyword          |
  | carbon_black_cloud.alert.rule_category_id                      | ID representing the category of the rule_id for certain alert types.                                                                             | keyword          |
  | carbon_black_cloud.alert.rule_config_id                        | ID of the rule configuration that triggered an alert.                                                                                            | keyword          |
  | carbon_black_cloud.alert.rule_config_name                      | Name of the rule configuration that triggered an alert.                                                                                          | keyword          |
  | carbon_black_cloud.alert.rule_config_type                      | Type of the rule configuration that triggered an alert.                                                                                          | keyword          |
  | carbon_black_cloud.alert.rule_id                               | ID of the rule that triggered an alert.                                                                                                          | keyword          |
  | carbon_black_cloud.alert.run_state                             | Whether the threat in the alert ran.                                                                                                             | keyword          |
  | carbon_black_cloud.alert.sensor_action                         | The action taken by the sensor, according to the rule of the policy.                                                                             | keyword          |
  | carbon_black_cloud.alert.serial_number                         | The serial number of the USB device.                                                                                                             | keyword          |
  | carbon_black_cloud.alert.status                                | status of alert.                                                                                                                                 | keyword          |
  | carbon_black_cloud.alert.tags                                  | Tags associated with the alert.                                                                                                                  | keyword          |
  | carbon_black_cloud.alert.threat_category                       | Categories of threats which we were able to take action on.                                                                                      | keyword          |
  | carbon_black_cloud.alert.threat_id                             | The identifier of a threat which this alert belongs. Threats are comprised of a combination of factors that can be repeated across devices.      | keyword          |
  | carbon_black_cloud.alert.threat_name                           | Name of the threat.                                                                                                                              | keyword          |
  | carbon_black_cloud.alert.threat_notes_present                  | Indicates if notes are associated with the threat_id.                                                                                            | boolean          |
  | carbon_black_cloud.alert.tms_rule_id                           | Threat intrusion detection id.                                                                                                                   | keyword          |
  | carbon_black_cloud.alert.ttps                                  | Other potential malicious activities involved in a threat.                                                                                       | keyword          |
  | carbon_black_cloud.alert.type                                  | Type of alert.                                                                                                                                   | keyword          |
  | carbon_black_cloud.alert.url                                   | Link to the alerts page for this alert. Does not vary by alert type.                                                                             | keyword          |
  | carbon_black_cloud.alert.user_update_timestamp                 | Timestamp of the last property of an alert changed by a user, such as the alert workflow or determination, it is a ISO 8601 UTC timestamp.       | date             |
  | carbon_black_cloud.alert.vendor_id                             | The hexadecimal id of the USB device's vendor.                                                                                                   | keyword          |
  | carbon_black_cloud.alert.vendor_name                           | The name of the USB device's vendor.                                                                                                             | keyword          |
  | carbon_black_cloud.alert.version                               | The version of the schema being emitted.                                                                                                         | keyword          |
  | carbon_black_cloud.alert.watchlists.id                         | Identifier of the watchlist.                                                                                                                     | keyword          |
  | carbon_black_cloud.alert.watchlists.name                       | Name of the watchlist.                                                                                                                           | keyword          |
  | carbon_black_cloud.alert.workflow.change_timestamp             | The last change/update time of workflow.                                                                                                         | date             |
  | carbon_black_cloud.alert.workflow.changed_by                   | The name of process which changed the workflow.                                                                                                  | keyword          |
  | carbon_black_cloud.alert.workflow.changed_by_autoclose_rule_id | The rule id that auto closed the workflow.                                                                                                       | keyword          |
  | carbon_black_cloud.alert.workflow.changed_by_type              | The type of user who changed the workflow.                                                                                                       | keyword          |
  | carbon_black_cloud.alert.workflow.closure_reason               | Reason for which the workflow was closed.                                                                                                        | keyword          |
  | carbon_black_cloud.alert.workflow.status                       | The status of the workflow.                                                                                                                      | keyword          |
  | cloud.image.id                                                 | Image ID for the cloud instance.                                                                                                                 | keyword          |
  | data_stream.dataset                                            | Data stream dataset.                                                                                                                             | constant_keyword |
  | data_stream.namespace                                          | Data stream namespace.                                                                                                                           | constant_keyword |
  | data_stream.type                                               | Data stream type.                                                                                                                                | constant_keyword |
  | event.dataset                                                  | Event dataset.                                                                                                                                   | constant_keyword |
  | event.module                                                   | Event module.                                                                                                                                    | constant_keyword |
  | host.containerized                                             | If the host is a container.                                                                                                                      | boolean          |
  | host.os.build                                                  | OS build information.                                                                                                                            | keyword          |
  | host.os.codename                                               | OS codename, if any.                                                                                                                             | keyword          |
  | input.type                                                     | Input type                                                                                                                                       | keyword          |
  | log.offset                                                     | Log offset                                                                                                                                       | long             |
</dropdown>


### Endpoint Event

This is the `endpoint_event` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-02-10T11:45:02.888Z",
      "agent": {
          "ephemeral_id": "360b318f-d2d9-4d06-a32c-2e11c4190a54",
          "id": "16fa3724-9165-48be-bdb0-836c9bd77a07",
          "name": "elastic-agent-49131",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "aws": {
          "s3": {
              "bucket": {
                  "arn": "arn:aws:s3:::elastic-package-carbon-endpoint-bucket-60445",
                  "name": "elastic-package-carbon-endpoint-bucket-60445"
              },
              "object": {
                  "key": "test-endpoint.log"
              }
          }
      },
      "carbon_black_cloud": {
          "endpoint_event": {
              "backend": {
                  "timestamp": "2022-02-10 11:49:36 +0000 UTC"
              },
              "device": {
                  "external_ip": "67.43.156.12",
                  "os": "WINDOWS",
                  "timestamp": "2022-02-10 11:45:02.8882089 +0000 UTC"
              },
              "event_origin": "EDR",
              "organization_key": "XXXXXXXX",
              "process": {
                  "parent": {
                      "reputation": "REP_RESOLVING"
                  },
                  "publisher": [
                      {
                          "name": "Stellar Cyber Inc",
                          "state": [
                              "FILE_SIGNATURE_STATE_SIGNED",
                              "FILE_SIGNATURE_STATE_VERIFIED",
                              "FILE_SIGNATURE_STATE_TRUSTED"
                          ]
                      }
                  ],
                  "reputation": "REP_RESOLVING",
                  "terminated": false,
                  "username": "NT AUTHORITY\\SYSTEM"
              },
              "schema": 1,
              "sensor_action": "ACTION_ALLOW",
              "type": "endpoint.event.netconn"
          }
      },
      "client": {
          "ip": "127.0.0.1",
          "port": 9716
      },
      "cloud": {
          "region": "us-east-1"
      },
      "data_stream": {
          "dataset": "carbon_black_cloud.endpoint_event",
          "namespace": "80071",
          "type": "logs"
      },
      "destination": {
          "ip": "127.0.0.1",
          "port": 9716
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "16fa3724-9165-48be-bdb0-836c9bd77a07",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "action": "ACTION_CONNECTION_LISTEN",
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "carbon_black_cloud.endpoint_event",
          "ingested": "2025-10-23T08:48:15Z",
          "original": "{\"type\":\"endpoint.event.netconn\",\"process_guid\":\"XXXXXXXX-00442a47-00002328-00000000-1d81e73a30955e7\",\"parent_guid\":\"XXXXXXXX-00442a47-000002d0-00000000-1d807560b2edfc4\",\"backend_timestamp\":\"2022-02-10 11:49:36 +0000 UTC\",\"org_key\":\"XXXXXXXX\",\"device_id\":\"14\",\"device_name\":\"DESKTOP-014\",\"device_external_ip\":\"67.43.156.12\",\"device_os\":\"WINDOWS\",\"device_group\":\"\",\"action\":\"ACTION_CONNECTION_LISTEN\",\"schema\":1,\"device_timestamp\":\"2022-02-10 11:45:02.8882089 +0000 UTC\",\"process_terminated\":false,\"process_reputation\":\"REP_RESOLVING\",\"parent_reputation\":\"REP_RESOLVING\",\"process_pid\":9000,\"parent_pid\":720,\"process_publisher\":[{\"name\":\"Stellar Cyber Inc\",\"state\":\"FILE_SIGNATURE_STATE_SIGNED | FILE_SIGNATURE_STATE_VERIFIED | FILE_SIGNATURE_STATE_TRUSTED\"}],\"process_path\":\"c:\\\\program files\\\\aella\\\\aella_conf_win_srv\\\\aella_conf_win_srv.exe\",\"parent_path\":\"c:\\\\windows\\\\system32\\\\services.exe\",\"process_hash\":[\"6174da1a2dd7594456bbb3ae50ac5587\",\"2ad7d1a17ee2dd897a5a45515e5ae46f8b6b61d3f67c90c1fa0c7910f06d0515\"],\"parent_hash\":[\"d8e577bf078c45954f4531885478d5a9\",\"dfbea9e8c316d9bc118b454b0c722cd674c30d0a256340200e2c3a7480cba674\"],\"process_cmdline\":\"\\\"C:\\\\Program Files\\\\Aella\\\\aella_conf_win_srv\\\\aella_conf_win_srv.exe\\\"\",\"parent_cmdline\":\"C:\\\\WINDOWS\\\\system32\\\\services.exe\",\"process_username\":\"NT AUTHORITY\\\\SYSTEM\",\"sensor_action\":\"ACTION_ALLOW\",\"event_origin\":\"EDR\",\"remote_port\":9001,\"remote_ip\":\"67.43.156.14\",\"local_port\":9716,\"local_ip\":\"127.0.0.1\",\"netconn_domain\":\"example.com\",\"netconn_inbound\":true,\"netconn_protocol\":\"PROTO_TCP\"}",
          "type": [
              "connection"
          ]
      },
      "host": {
          "hostname": "DESKTOP-014",
          "id": "14",
          "ip": [
              "67.43.156.12"
          ],
          "name": "DESKTOP-014",
          "os": {
              "type": "windows"
          }
      },
      "input": {
          "type": "aws-s3"
      },
      "log": {
          "file": {
              "path": "https://elastic-package-carbon-endpoint-bucket-60445.s3.us-east-1.amazonaws.com/test-endpoint.log"
          },
          "offset": 0
      },
      "network": {
          "direction": "inbound",
          "transport": "tcp"
      },
      "process": {
          "command_line": "\"C:\\Program Files\\Aella\\aella_conf_win_srv\\aella_conf_win_srv.exe\"",
          "entity_id": "XXXXXXXX-00442a47-00002328-00000000-1d81e73a30955e7",
          "executable": "c:\\program files\\aella\\aella_conf_win_srv\\aella_conf_win_srv.exe",
          "hash": {
              "md5": "6174da1a2dd7594456bbb3ae50ac5587",
              "sha256": "2ad7d1a17ee2dd897a5a45515e5ae46f8b6b61d3f67c90c1fa0c7910f06d0515"
          },
          "parent": {
              "command_line": "C:\\WINDOWS\\system32\\services.exe",
              "entity_id": "XXXXXXXX-00442a47-000002d0-00000000-1d807560b2edfc4",
              "executable": "c:\\windows\\system32\\services.exe",
              "hash": {
                  "md5": "d8e577bf078c45954f4531885478d5a9",
                  "sha256": "dfbea9e8c316d9bc118b454b0c722cd674c30d0a256340200e2c3a7480cba674"
              },
              "pid": 720
          },
          "pid": 9000
      },
      "related": {
          "hash": [
              "2ad7d1a17ee2dd897a5a45515e5ae46f8b6b61d3f67c90c1fa0c7910f06d0515",
              "6174da1a2dd7594456bbb3ae50ac5587",
              "d8e577bf078c45954f4531885478d5a9",
              "dfbea9e8c316d9bc118b454b0c722cd674c30d0a256340200e2c3a7480cba674"
          ],
          "hosts": [
              "DESKTOP-014"
          ],
          "ip": [
              "67.43.156.14",
              "127.0.0.1",
              "67.43.156.12"
          ],
          "user": [
              "NT AUTHORITY\\SYSTEM"
          ]
      },
      "source": {
          "domain": "example.com",
          "ip": "67.43.156.14",
          "port": 9001
      },
      "tags": [
          "collect_sqs_logs",
          "preserve_original_event",
          "forwarded",
          "carbon_black_cloud-endpoint_event"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                | Description                                                                                                                                                                   | Type             |
  |----------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                           | Event timestamp.                                                                                                                                                              | date             |
  | aws.s3.bucket.arn                                                    | The AWS S3 bucket ARN.                                                                                                                                                        | keyword          |
  | aws.s3.bucket.name                                                   | The AWS S3 bucket name.                                                                                                                                                       | keyword          |
  | aws.s3.object.key                                                    | The AWS S3 Object key.                                                                                                                                                        | keyword          |
  | carbon_black_cloud.endpoint_event.alert_id                           | The ID of the Alert this event is associated with.                                                                                                                            | keyword          |
  | carbon_black_cloud.endpoint_event.backend.timestamp                  | Time when the backend received the batch of events.                                                                                                                           | keyword          |
  | carbon_black_cloud.endpoint_event.create_time                        | The time at which the event was ingested in carbon black cloud.                                                                                                               | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.action                   | The action taken on cross-process.                                                                                                                                            | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.api                      | Name of the operating system API called by the actor process.                                                                                                                 | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.guid                     | Unique ID of the cross process.                                                                                                                                               | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.hash.md5                 | Cryptographic MD5 hashes of the target of the crossproc event.                                                                                                                | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.hash.sha256              | Cryptographic SHA256 hashes of the target of the crossproc event.                                                                                                             | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.name                     | Full path to the target of the crossproc event on the device's local file system.                                                                                             | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.publisher.name           | The name of the publisher.                                                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.publisher.state          | The state of the publisher.                                                                                                                                                   | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.reputation               | Carbon Black Cloud Reputation string for the crossproc.                                                                                                                       | keyword          |
  | carbon_black_cloud.endpoint_event.crossproc.target                   | True if the process was the target of the cross-process event; false if the process was the actor.                                                                            | boolean          |
  | carbon_black_cloud.endpoint_event.device.external_ip                 | External IP of the device.                                                                                                                                                    | ip               |
  | carbon_black_cloud.endpoint_event.device.internal_ip                 | Internal IP of the device.                                                                                                                                                    | ip               |
  | carbon_black_cloud.endpoint_event.device.os                          | Os name.                                                                                                                                                                      | keyword          |
  | carbon_black_cloud.endpoint_event.device.timestamp                   | Time seen on sensor.                                                                                                                                                          | keyword          |
  | carbon_black_cloud.endpoint_event.event_origin                       | Indicates which product the event came from. "EDR" indicates the event originated from Enterprise EDR. "NGAV" indicates the event originated from Endpoint Standard.          | keyword          |
  | carbon_black_cloud.endpoint_event.fileless_scriptload.cmdline        | Deobfuscated script content run in a fileless context by the process.                                                                                                         | keyword          |
  | carbon_black_cloud.endpoint_event.fileless_scriptload.cmdline_length | Character count of the deobfuscated script content run in a fileless context.                                                                                                 | keyword          |
  | carbon_black_cloud.endpoint_event.fileless_scriptload.hash.md5       | MD5 hash of the deobfuscated script content run by the process in a fileless context.                                                                                         | keyword          |
  | carbon_black_cloud.endpoint_event.fileless_scriptload.hash.sha256    | SHA-256 hash of the deobfuscated script content run by the process in a fileless context.                                                                                     | keyword          |
  | carbon_black_cloud.endpoint_event.modload.count                      | Count of modload events reported by the sensor since last initialization.                                                                                                     | long             |
  | carbon_black_cloud.endpoint_event.modload.effective_reputation       | Effective reputation(s) of the loaded module(s); applied by the sensor when the event occurred.                                                                               | keyword          |
  | carbon_black_cloud.endpoint_event.modload.publisher.name             | The name of the publisher.                                                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.modload.publisher.state            | The state of the publisher.                                                                                                                                                   | keyword          |
  | carbon_black_cloud.endpoint_event.netconn.proxy.domain               | DNS name associated with the "proxy" end of this network connection; may be empty if the name cannot be inferred or the connection is made direct to/from a proxy IP address. | keyword          |
  | carbon_black_cloud.endpoint_event.netconn.proxy.ip                   | IPv4 or IPv6 address in string format associated with the "proxy" end of this network connection.                                                                             | ip               |
  | carbon_black_cloud.endpoint_event.netconn.proxy.port                 | UDP/TCP port number associated with the "proxy" end of this network connection.                                                                                               | keyword          |
  | carbon_black_cloud.endpoint_event.organization_key                   | The organization key associated with the console instance.                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.process.duration                   | The time difference in seconds between the process start and process terminate event.                                                                                         | long             |
  | carbon_black_cloud.endpoint_event.process.grandparent.command_line   | Full command line that started the grandparent process, including the absolute path to the executable, and all arguments.                                                     | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.entity_id      | Unique identifier for the grandparent process.                                                                                                                                | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.executable     | Absolute path to the process executable.                                                                                                                                      | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.hash.md5       | Cryptographic MD5 hashes of the grandparent process.                                                                                                                          | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.hash.sha256    | Cryptographic SHA256 hashes of the grandparent process.                                                                                                                       | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.pid            | The grandparent's process id.                                                                                                                                                 | keyword          |
  | carbon_black_cloud.endpoint_event.process.grandparent.reputation     | Reputation of the grandparent process; applied when event is processed by the Carbon Black Cloud i.e. after sensor delivers event to the cloud.                               | keyword          |
  | carbon_black_cloud.endpoint_event.process.parent.publisher.name      | The name of the publisher.                                                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.process.parent.publisher.state     | The state of the publisher.                                                                                                                                                   | keyword          |
  | carbon_black_cloud.endpoint_event.process.parent.reputation          | Reputation of the parent process; applied when event is processed by the Carbon Black Cloud i.e. after sensor delivers event to the cloud.                                    | keyword          |
  | carbon_black_cloud.endpoint_event.process.parent.terminated          | True if parent process was terminated else false.                                                                                                                             | boolean          |
  | carbon_black_cloud.endpoint_event.process.parent.username            | The username associated with the user context that the parent process was started under.                                                                                      | keyword          |
  | carbon_black_cloud.endpoint_event.process.publisher.name             | The name of the publisher.                                                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.process.publisher.state            | The state of the publisher.                                                                                                                                                   | keyword          |
  | carbon_black_cloud.endpoint_event.process.reputation                 | Reputation of the actor process; applied when event is processed by the Carbon Black Cloud i.e. after sensor delivers event to the cloud.                                     | keyword          |
  | carbon_black_cloud.endpoint_event.process.terminated                 | True if process was terminated else false.                                                                                                                                    | boolean          |
  | carbon_black_cloud.endpoint_event.process.username                   | The username associated with the user context that this process was started under.                                                                                            | keyword          |
  | carbon_black_cloud.endpoint_event.schema                             | The schema version. The current schema version is "1". This schema version will only be incremented if the field definitions are changed in a backwards-incompatible way.     | long             |
  | carbon_black_cloud.endpoint_event.scriptload.count                   | Count of scriptload events across all processes reported by the sensor since last initialization.                                                                             | long             |
  | carbon_black_cloud.endpoint_event.scriptload.effective_reputation    | Effective reputation(s) of the script file(s) loaded at process launch; applied by the sensor when the event occurred.                                                        | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.hash.md5                | Cryptographic MD5 hashes of the target of the scriptload event.                                                                                                               | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.hash.sha256             | Cryptographic SHA256 hashes of the target of the scriptload event.                                                                                                            | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.name                    | Full path to the target of the crossproc event on the device's local file system.                                                                                             | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.publisher.name          | The name of the publisher.                                                                                                                                                    | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.publisher.state         | The state of the publisher.                                                                                                                                                   | keyword          |
  | carbon_black_cloud.endpoint_event.scriptload.reputation              | Carbon Black Cloud Reputation string for the scriptload.                                                                                                                      | keyword          |
  | carbon_black_cloud.endpoint_event.sensor_action                      | The sensor action taken on event.                                                                                                                                             | keyword          |
  | carbon_black_cloud.endpoint_event.target_cmdline                     | Process command line associated with the target process.                                                                                                                      | keyword          |
  | carbon_black_cloud.endpoint_event.type                               | The event type.                                                                                                                                                               | keyword          |
  | cloud.image.id                                                       | Image ID for the cloud instance.                                                                                                                                              | keyword          |
  | data_stream.dataset                                                  | Data stream dataset.                                                                                                                                                          | constant_keyword |
  | data_stream.namespace                                                | Data stream namespace.                                                                                                                                                        | constant_keyword |
  | data_stream.type                                                     | Data stream type.                                                                                                                                                             | constant_keyword |
  | event.dataset                                                        | Event dataset.                                                                                                                                                                | constant_keyword |
  | event.module                                                         | Event module.                                                                                                                                                                 | constant_keyword |
  | host.containerized                                                   | If the host is a container.                                                                                                                                                   | boolean          |
  | host.os.build                                                        | OS build information.                                                                                                                                                         | keyword          |
  | host.os.codename                                                     | OS codename, if any.                                                                                                                                                          | keyword          |
  | input.type                                                           | Input type                                                                                                                                                                    | keyword          |
  | log.offset                                                           | Log offset                                                                                                                                                                    | long             |
</dropdown>


### Watchlist Hit

This is the `watchlist_hit` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-02-10T06:53:45.096Z",
      "agent": {
          "ephemeral_id": "8c335d51-58c6-4d1c-b166-4cf713b512ad",
          "id": "e098aaea-d0a3-428c-8bdd-6908e243f733",
          "name": "elastic-agent-59512",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "aws": {
          "s3": {
              "bucket": {
                  "arn": "arn:aws:s3:::elastic-package-carbon-watchlist-bucket-12116",
                  "name": "elastic-package-carbon-watchlist-bucket-12116"
              },
              "object": {
                  "key": "test-watchlist.log"
              }
          }
      },
      "carbon_black_cloud": {
          "watchlist_hit": {
              "device": {
                  "external_ip": "81.2.69.145",
                  "os": "LINUX"
              },
              "ioc": {
                  "hit": "(((process_name:rmdir OR process_name:rm) -process_cmdline:dhclient)) -enriched:true",
                  "id": "480e5065-1ce0-4a6f-ab60-691a7ce0393e-0"
              },
              "organization_key": "7xxxxxxN",
              "process": {
                  "parent": {
                      "reputation": "REP_RESOLVING",
                      "username": "root"
                  },
                  "reputation": "REP_RESOLVING",
                  "username": "root"
              },
              "report": {
                  "id": "GUWNtEmJQhKmuOTxoRV8hA-480e5065-1ce0-4a6f-ab60-691a7ce0393e",
                  "name": "Impact - Data Destruction - rmdir and rm Usage",
                  "tags": [
                      "macos",
                      "mac",
                      "osx",
                      "attackframework",
                      "linux",
                      "t1070",
                      "evasion",
                      "t1485"
                  ]
              },
              "schema": 1,
              "type": "watchlist.hit",
              "watchlists": [
                  {
                      "id": "yY9iugATqCfQMdaUDPQ",
                      "name": "Carbon Black Endpoint Visibility"
                  }
              ]
          }
      },
      "cloud": {
          "region": "us-east-1"
      },
      "data_stream": {
          "dataset": "carbon_black_cloud.watchlist_hit",
          "namespace": "56238",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e098aaea-d0a3-428c-8bdd-6908e243f733",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "carbon_black_cloud.watchlist_hit",
          "ingested": "2025-10-23T08:51:15Z",
          "kind": "event",
          "original": "{\"schema\":1,\"create_time\":\"2022-02-10T06:53:45.096Z\",\"device_external_ip\":\"81.2.69.145\",\"device_id\":6,\"device_name\":\"DESKTOP-006\",\"device_os\":\"LINUX\",\"ioc_hit\":\"(((process_name:rmdir OR process_name:rm) -process_cmdline:dhclient)) -enriched:true\",\"ioc_id\":\"480e5065-1ce0-4a6f-ab60-691a7ce0393e-0\",\"org_key\":\"7xxxxxxN\",\"parent_cmdline\":\"/var/lib/dpkg/info/linux-image-5.11.0-49-generic.postinst configure \",\"parent_guid\":\"7DESJ9GN-00428a2d-000019e5-00000000-1d81e49f1416d17\",\"parent_hash\":[\"\",\"\"],\"parent_path\":\"/usr/bin/dash\",\"parent_pid\":6629,\"parent_reputation\":\"REP_RESOLVING\",\"parent_username\":\"root\",\"process_cmdline\":\"rm -f /lib/modules/5.11.0-49-generic/.fresh-install\",\"process_guid\":\"7DESJ9GN-00428a2d-000019e8-00000000-1d81e49f41898df\",\"process_hash\":[\"\",\"\"],\"process_path\":\"/usr/bin/rm\",\"process_pid\":6632,\"process_reputation\":\"REP_RESOLVING\",\"process_username\":\"root\",\"report_id\":\"GUWNtEmJQhKmuOTxoRV8hA-480e5065-1ce0-4a6f-ab60-691a7ce0393e\",\"report_name\":\"Impact - Data Destruction - rmdir and rm Usage\",\"report_tags\":[\"macos\",\"mac\",\"osx\",\"attackframework\",\"linux\",\"t1070\",\"evasion\",\"t1485\"],\"severity\":1,\"type\":\"watchlist.hit\",\"watchlists\":[{\"id\":\"yY9iugATqCfQMdaUDPQ\",\"name\":\"Carbon Black Endpoint Visibility\"}]}",
          "severity": 1
      },
      "host": {
          "hostname": "DESKTOP-006",
          "id": "6",
          "ip": [
              "81.2.69.145"
          ],
          "name": "DESKTOP-006",
          "os": {
              "type": "linux"
          }
      },
      "input": {
          "type": "aws-s3"
      },
      "log": {
          "file": {
              "path": "https://elastic-package-carbon-watchlist-bucket-12116.s3.us-east-1.amazonaws.com/test-watchlist.log"
          },
          "offset": 2045
      },
      "process": {
          "command_line": "rm -f /lib/modules/5.11.0-49-generic/.fresh-install",
          "entity_id": "7DESJ9GN-00428a2d-000019e8-00000000-1d81e49f41898df",
          "executable": "/usr/bin/rm",
          "parent": {
              "command_line": "/var/lib/dpkg/info/linux-image-5.11.0-49-generic.postinst configure ",
              "entity_id": "7DESJ9GN-00428a2d-000019e5-00000000-1d81e49f1416d17",
              "executable": "/usr/bin/dash",
              "pid": 6629
          },
          "pid": 6632
      },
      "related": {
          "hosts": [
              "DESKTOP-006"
          ],
          "ip": [
              "81.2.69.145"
          ],
          "user": [
              "root"
          ]
      },
      "tags": [
          "collect_sqs_logs",
          "preserve_original_event",
          "forwarded",
          "carbon_black_cloud-watchlist_hit"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                           | Description                                                                                                                               | Type             |
  |-----------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                      | Event timestamp.                                                                                                                          | date             |
  | aws.s3.bucket.arn                                               | The AWS S3 bucket ARN.                                                                                                                    | keyword          |
  | aws.s3.bucket.name                                              | The AWS S3 bucket name.                                                                                                                   | keyword          |
  | aws.s3.object.key                                               | The AWS S3 Object key.                                                                                                                    | keyword          |
  | carbon_black_cloud.watchlist_hit.device.external_ip             | External IP of the device.                                                                                                                | ip               |
  | carbon_black_cloud.watchlist_hit.device.internal_ip             | Internal IP of the device.                                                                                                                | ip               |
  | carbon_black_cloud.watchlist_hit.device.os                      | OS Type of device (Windows/OSX/Linux).                                                                                                    | keyword          |
  | carbon_black_cloud.watchlist_hit.ioc.field                      | Field the IOC hit contains.                                                                                                               | keyword          |
  | carbon_black_cloud.watchlist_hit.ioc.hit                        | IOC field value, or IOC query that matches.                                                                                               | keyword          |
  | carbon_black_cloud.watchlist_hit.ioc.id                         | ID of the IOC that caused the hit.                                                                                                        | keyword          |
  | carbon_black_cloud.watchlist_hit.organization_key               | The organization key associated with the console instance.                                                                                | keyword          |
  | carbon_black_cloud.watchlist_hit.process.parent.publisher.name  | The name of the publisher.                                                                                                                | keyword          |
  | carbon_black_cloud.watchlist_hit.process.parent.publisher.state | The state of the publisher.                                                                                                               | keyword          |
  | carbon_black_cloud.watchlist_hit.process.parent.reputation      | Reputation of the actor process; applied when event is processed by the Carbon Black Cloud i.e. after sensor delivers event to the cloud. | keyword          |
  | carbon_black_cloud.watchlist_hit.process.parent.username        | The username associated with the user context that this process was started under.                                                        | keyword          |
  | carbon_black_cloud.watchlist_hit.process.publisher.name         | The name of the publisher.                                                                                                                | keyword          |
  | carbon_black_cloud.watchlist_hit.process.publisher.state        | The state of the publisher.                                                                                                               | keyword          |
  | carbon_black_cloud.watchlist_hit.process.reputation             | Reputation of the actor process; applied when event is processed by the Carbon Black Cloud i.e. after sensor delivers event to the cloud. | keyword          |
  | carbon_black_cloud.watchlist_hit.process.username               | The username associated with the user context that this process was started under.                                                        | keyword          |
  | carbon_black_cloud.watchlist_hit.report.id                      | ID of the watchlist report(s) that detected a hit on the process.                                                                         | keyword          |
  | carbon_black_cloud.watchlist_hit.report.name                    | Name of the watchlist report(s) that detected a hit on the process.                                                                       | keyword          |
  | carbon_black_cloud.watchlist_hit.report.tags                    | List of tags associated with the report(s) that detected a hit on the process.                                                            | keyword          |
  | carbon_black_cloud.watchlist_hit.schema                         | Schema version.                                                                                                                           | long             |
  | carbon_black_cloud.watchlist_hit.type                           | The watchlist hit type.                                                                                                                   | keyword          |
  | carbon_black_cloud.watchlist_hit.watchlists.id                  | The ID of the watchlists.                                                                                                                 | keyword          |
  | carbon_black_cloud.watchlist_hit.watchlists.name                | The name of the watchlists.                                                                                                               | keyword          |
  | cloud.image.id                                                  | Image ID for the cloud instance.                                                                                                          | keyword          |
  | data_stream.dataset                                             | Data stream dataset.                                                                                                                      | constant_keyword |
  | data_stream.namespace                                           | Data stream namespace.                                                                                                                    | constant_keyword |
  | data_stream.type                                                | Data stream type.                                                                                                                         | constant_keyword |
  | event.dataset                                                   | Event dataset.                                                                                                                            | constant_keyword |
  | event.module                                                    | Event module.                                                                                                                             | constant_keyword |
  | host.containerized                                              | If the host is a container.                                                                                                               | boolean          |
  | host.os.build                                                   | OS build information.                                                                                                                     | keyword          |
  | host.os.codename                                                | OS codename, if any.                                                                                                                      | keyword          |
  | input.type                                                      | Input type                                                                                                                                | keyword          |
  | log.offset                                                      | Log offset                                                                                                                                | long             |
</dropdown>


### Asset Vulnerability Summary

This is the `asset_vulnerability_summary` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-12-16T06:00:33.931Z",
      "agent": {
          "ephemeral_id": "6604f82d-c649-4b54-b5b7-f180dd6f63c7",
          "id": "62d26a97-24c8-4d91-a482-7dce2566959d",
          "name": "elastic-agent-61579",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "carbon_black_cloud": {
          "asset_vulnerability_summary": {
              "last_sync": {
                  "timestamp": "2022-01-17T08:33:37.384Z"
              },
              "os_info": {
                  "os_arch": "64-bit"
              },
              "sync": {
                  "status": "COMPLETED",
                  "type": "SCHEDULED"
              },
              "type": "ENDPOINT",
              "vuln_count": 1770
          }
      },
      "data_stream": {
          "dataset": "carbon_black_cloud.asset_vulnerability_summary",
          "namespace": "10094",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "62d26a97-24c8-4d91-a482-7dce2566959d",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "carbon_black_cloud.asset_vulnerability_summary",
          "ingested": "2025-12-16T06:00:36Z",
          "kind": "state",
          "original": "{\"cve_ids\":null,\"device_id\":8,\"highest_risk_score\":10,\"host_name\":\"DESKTOP-008\",\"last_sync_ts\":\"2022-01-17T08:33:37.384932Z\",\"name\":\"DESKTOP-008KK\",\"os_info\":{\"os_arch\":\"64-bit\",\"os_name\":\"Microsoft Windows 10 Education\",\"os_type\":\"WINDOWS\",\"os_version\":\"10.0.17763\"},\"severity\":\"CRITICAL\",\"sync_status\":\"COMPLETED\",\"sync_type\":\"SCHEDULED\",\"type\":\"ENDPOINT\",\"vm_id\":\"\",\"vm_name\":\"\",\"vuln_count\":1770}"
      },
      "host": {
          "hostname": "DESKTOP-008",
          "id": "8",
          "name": "DESKTOP-008KK",
          "os": {
              "name": "Microsoft Windows 10 Education",
              "type": "windows",
              "version": "10.0.17763"
          }
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hosts": [
              "DESKTOP-008"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "carbon_black_cloud-asset_vulnerability_summary"
      ],
      "vulnerability": {
          "score": {
              "base": 10
          },
          "severity": "CRITICAL"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                              | Description                                                                                                  | Type             |
  |--------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                         | Event timestamp.                                                                                             | date             |
  | carbon_black_cloud.asset_vulnerability_summary.last_sync.timestamp | The identifier is for the Last sync time.                                                                    | date             |
  | carbon_black_cloud.asset_vulnerability_summary.os_info.os_arch     | The identifier is for the Operating system architecture.                                                     | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.sync.status         | The identifier is for the Device sync status.                                                                | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.sync.type           | The identifier is for the Whether a manual sync was triggered for the device, or if it was a scheduled sync. | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.type                | The identifier is for the Device type.                                                                       | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.vm.id               | The identifier is for the Virtual Machine ID.                                                                | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.vm.name             | The identifier is for the Virtual Machine name.                                                              | keyword          |
  | carbon_black_cloud.asset_vulnerability_summary.vuln_count          | The identifier is for the Number of vulnerabilities at this level.                                           | integer          |
  | cloud.image.id                                                     | Image ID for the cloud instance.                                                                             | keyword          |
  | data_stream.dataset                                                | Data stream dataset.                                                                                         | constant_keyword |
  | data_stream.namespace                                              | Data stream namespace.                                                                                       | constant_keyword |
  | data_stream.type                                                   | Data stream type.                                                                                            | constant_keyword |
  | event.dataset                                                      | Event dataset.                                                                                               | constant_keyword |
  | event.module                                                       | Event module.                                                                                                | constant_keyword |
  | host.containerized                                                 | If the host is a container.                                                                                  | boolean          |
  | host.os.build                                                      | OS build information.                                                                                        | keyword          |
  | host.os.codename                                                   | OS codename, if any.                                                                                         | keyword          |
  | input.type                                                         | Input type                                                                                                   | keyword          |
  | log.offset                                                         | Log offset                                                                                                   | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Carbon Black Cloud Alert v7 dashboard screenshot](https://epr.elastic.co/package/carbon_black_cloud/4.2.0/img/carbon_black_cloud-alert_v7-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **4.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16960))Make rows_per_page configurable in alerts_7 data stream and cap it at a maximum value of 10000.                                                                                                                                                                                                                                                          | 9.1.49.0.78.19.4       |
  | **4.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16690))Add `max_executions` configuration to the `alert_v7`, `asset_vulnerability_summary`, and `audit` data streams.                                                                                                                                                                                                                                           | 9.1.49.0.78.19.4       |
  | **4.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16564))Fix pagination logic for `asset_vulnerability_summary` data stream.                                                                                                                                                                                                                                                                                          | 9.1.49.0.78.19.4       |
  | **4.0.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15772))Fix handling mapping of process lineage for `endpoint.event.procstart` events.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15772))Process identity fields are changed for `endpoint.event.procstart` events, with the lineage shifted to be process, parent and grand parent, instead of child, process and parent. | 9.0.08.18.0            |
  | **3.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15220))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15110))Enable Agentless deployment.                                                                                                                                                                                                                                                                                                                             | 9.0.08.16.5            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                  | 9.0.08.16.5            |
  | **3.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                                                                  | 9.0.08.16.5            |
  | **3.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                                                                                                                                                                              | 9.0.08.16.5            |
  | **3.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13169))Removed legacy alert data stream.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13169))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                 | 9.0.08.16.5            |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13035))Enable request trace log removal.                                                                                                                                                                                                                                                                                                                        | 8.16.5                 |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                                                                                                                                                                       | 8.16.5                 |
  | **2.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                                                                                                                         | 8.16.2                 |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                                                                                                                                                                             | 8.16.2                 |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11622))Fix handling of `source.address` to be dependent on direction.                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11611))Map endpoint event types to ECS `event.category` and `event.type`.                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **2.5.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11259))Fix alert_v7 CEL pagination logic.                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.5.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11221))Fix timestamp type when using cursor value.                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **2.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11149))Ensure alert search range is a valid temporal ordering.                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11046))Return full state in CEL program results, to fix a bug causing the loss of 'state.api_key'.                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **2.4.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10672))Deprecate global SQS Queue URL to avoid data loss.                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10346))Improve error reporting for API request failures.                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10307))Improved error handling thereby fixing invalid response parsing. Fixed resource tracer log file path.                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                      | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9467))Added v7 alert data stream with dashboards along with new CEL input type for all http data streams.                                                                                                                                                                                                                                                       | 8.12.0                 |
  | **1.21.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9391))Added support for more device_timestamp formats.                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **1.21.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9380))Fixed handling of @timestamp in endpoint event data stream.                                                                                                                                                                                                                                                                                                   | 8.12.0                 |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9340))Fix handling of network direction.                                                                                                                                                                                                                                                                                                                            | 8.12.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9303))Introduced data stream specific SQS queues.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9303))Fixed data loss issue by providing option for local SQS queues.                                                                                                                                                            | 8.12.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret and add missing mappings.                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.19.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                                                 | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                      | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6613))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                                                                                                                                                                                                     | 8.0.07.17.0            |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5927))Cleanup fields based on Alert API doc                                                                                                                                                                                                                                                                                                                         | 8.0.07.17.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                              | 8.0.07.17.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                    | 8.0.07.17.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                              | 8.0.07.17.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4635))Update Aggregation visualizations to Lens, Add an on_failure processor to the convert and date processors and update the pagination termination condition.                                                                                                                                                                                                | 8.0.07.17.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                              | 8.0.07.17.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4399))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                      | 8.0.07.17.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4316))Add Support of SQS input type.                                                                                                                                                                                                                                                                                                                          | 8.0.07.17.0            |
  | **1.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4296))Ensure stability of related.hash array ordering.                                                                                                                                                                                                                                                                                                            | 8.0.07.17.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/3975))Remove unused visualizations                                                                                                                                                                                                                                                                                                                            | 8.0.07.17.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3842))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                               | 8.0.07.17.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                        | 8.0.07.17.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                              | 8.0.07.17.0            |
  | **1.0.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/3579))Add correct field mapping for event.created                                                                                                                                                                                                                                                                                                                 | 8.0.07.17.0            |
  | **1.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/3462))Fix dashboard issues.                                                                                                                                                                                                                                                                                                                                       | 8.0.07.17.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/3407))Change event.outcome value from failure to failed according to ECS                                                                                                                                                                                                                                                                                          | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3428))Make GA                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3196))Add "VMware" to the title to make it "VMware Carbon Black Cloud".                                                                                                                                                                                                                                                                                         |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3106))Captured domain from username and hostname                                                                                                                                                                                                                                                                                                                |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2760))Initial draft of the package.                                                                                                                                                                                                                                                                                                                             |                        |
</dropdown>