﻿---
title: Box Events Integration
description: The Box Events integration allows you to monitor Box. Box is a secure cloud storage and collaboration service that allows businesses and individuals to...
url: https://www.elastic.co/docs/reference/integrations/box_events
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Box Events Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.1.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4               |

The Box Events integration allows you to monitor [Box](https://app.box.com/). Box is a secure cloud storage and collaboration service that allows businesses and individuals to easily share files.
Use the Box Events integration to ingest the activity logs which are generated each time files are uploaded, accessed, or modified in Box, enabling you to monitor data movement to the cloud. If you have [opted-in to receive additional events](https://developer.box.com/guides/events/event-triggers/shield-alert-events/), the Box Events integration will ingest context-rich alerts on potential threats, such as compromised accounts and data theft, based on anomalous user behavior. Combining this data with other events can lead to the detection of data exfiltration attacks.
Then visualize that data in Kibana, create alerts to notify you if something goes wrong, and reference `box_events.events` when troubleshooting an issue.
For example, if you wanted to set up notifications for incoming Box Shield alerts you could verify that this data is being ingested from the `Box Shield Alerts` Dashboard. Then, go to `Alerts and Insights / Rules and Connectors` in the sidebar and set up a Rule using an Elasticsearch Query against index `*box*alert*` with time field `@timestamp` and DSL
```
{
  "query":{
    "match" : {
      "event.kind": "alert"
    }
  }
}
```

to match incoming box alerts during your desired timeframe and notify you using your preferred connector.

## Compatibility

The Box Web Application does not feature version numbers, see this [Community Post](https://support.box.com/hc/en-us/community/posts/1500000033881/comments/1500000038001). This integration was configured and tested against Box in the second quarter of 2022.

## Box Events

The Box events API enables subscribing to live events across the enterprise or for a particular user, or querying historical events across the enterprise.
The API Returns up to a year of past events for configurable to the `admin` user (default) or for the entire enterprise.

### Elastic Integration for Box Events Settings

The Elastic Integration for Box Events requires the following Authentication Settings in order to connect to the Target service:
- Client ID
- Client Secret
- Box Subject ID
- Box Subject Type
- Grant Type

The Elastic Integration for Box Events requires the following Data Stream Settings to configure the request to the Target API:
- Interval
- Stream Type
- Preserve Original Event

Here is a brief guide to help you generate these settings

### Target Repository Authentication Settings Prerequisites

The Elastic Integration for Box Events connects using OAuth 2.0 to interact with a Box Custom App. As prerequisites you will need to:
- Enable `MFA/2FA` on your admin account by following the instructions in [MFA Setup on Box Support](https://support.box.com/hc/en-us/articles/360043697154-Multi-Factor-Authentication-Set-Up-for-Your-Account)
- Configure a `Box Custom Application using Server Authentication `

  `(with Client Credentials Grant)`. A suggested workflow is provided below, see [Setup with OAuth 2.0](https://developer.box.com/guides/authentication/oauth2/oauth2-setup/) for additional information.


### Authorized User

It is important to login to the [Box Developer Console](https://app.box.com/developers/console) as an `admin` and not `co-admin`.

## A suggested workflow is as follows:


### Create a `Custom Application using Server Authentication (with Client Credentials Grant) authentication`

1. Open the [Box Developer Console](https://app.box.com/developers/console)
2. Click on `Create new App`
3. Click on `Custom App`
4. Select `Server Authentication (Client Credentials Grant)`
5. Provide an App name, for example `elastic-box-integration`
6. Click on `Create App`
7. When your App has been created, scroll down and under `App Access Level` select `App + Enterprise Access`
8. Scroll down to `Application Scopes` and under `Administrative Actions` select
   - `Manage users`
   - `Manage enterprise properties`
9. Scroll down to `Advanced Features` and select
   - `Generate user access tokens`
10. Click on `Save Changes`


### Submit the application for Authorization from the [Box Developer Console](https://app.box.com/developers/console)

1. In the left side bar, at the bottom, click on `</> Dev Console`
2. Click on your application, which should now have an extra `Authorization` tab, so click on this
3. Click on `Review and Submit`, add a comment to explain your changes then click on `Submit`.


### Authorize the Application from the [Box Admin Console](https://app.box.com/master)

If you are the `admin` user you can do this yourself, otherwise reach out to the admin to confirm your motives and request that they authorize your request, since there may be some delay before they are aware of your request.
To authorize the App ensure you are logged in to the [Admin Console](https://app.box.com/master) and follow these steps:
1. In the left side bar click on [Apps](https://app.box.com/master/settings/apps)
2. Click on the [Custom Apps Manager](https://app.box.com/master/custom-apps) tab, you should see your App under `Server Authentication Apps` and the `Authorisation Status` should be `Pending Reauth`
3. Click on your App, it should have the following `App Details`:
   - Last Activity
   - `<date>`
  - Developer Email
- `<your email>`
  - Authorization Status
- `Pending Reauthorization`
  - Enablement Status
- `Enabled`
  - Client ID
- `<alphanumeric id>`
  - App Access
- `All Users`
  - App Scopes
- `Read and write all files and folders stored in Box`
- `Manage enterprise properties`
- `Manage users`
- `Manage app users`
- `Generate user access tokens`
  - Authentication Type
- `OAuth 2.0 with Client Credentials Grant`
4. Click on `Authorize` - a pop up will reconfirm these details
5. Click on `Authorize` - the Authorization Status should update to
   - Authorized


### Locate the Elastic Integration for Box Events Settings


#### Client ID

Click on your App in the [Box Developer Console](https://app.box.com/developers/console), under the `Configuration` tab, scroll down to `OAuth 2.0 Credentials` and copy the `Client ID`

#### Client Secret

Have your 2FA device prepared and to hand. Click on your App in the [Box Developer Console](https://app.box.com/developers/console), under the `Configuration` tab, scroll down to `OAuth 2.0 Credentials` and click on `Fetch Client Secret`. Complete the 2FA challenge to copy the `Client Secret`

#### Box Subject ID

Click on your App in the [Box Developer Console](https://app.box.com/developers/console), under the `General Settings` tab, scroll down to `App Info`. If you intend to harvest events solely for the `admin` user copy the `User ID` otherwise copy the `Enterprise ID`

#### Box Subject Type

If you intend to harvest events solely for the `admin` user set this to `user` otherwise set to `enterprise`

#### Grant Type

Use the provided default `client_credentials`

#### Interval

This sets the interval between requests to the Target Service, for example `300s` will send a request every 300 seconds. Events will be returned in batches of up to 100, with successive calls on expiry of the configured `interval` so you may wish to specify a lower interval when a substantial number of events are expected, however, we suggest to consider bandwidth when using lower settings

#### Stream Type

To retrieve events for a single user, set stream type to `all` (default). To select only events that may cause file tree changes such as file updates or collaborations, use `changes`. To select a subset of `changes` for synced folders, use `sync`. To retrieve events for the entire enterprise, set the stream_type to `admin_logs_streaming` for live monitoring of new events, or `admin_logs` for querying across historical events.

#### Preserve Original Event

Preserves a raw copy of the original event, added to the field `event.original`.
<dropdown title="Exported fields">
  | Field                                                                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |--------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | box.accessible_by.id                                                                       | ID of the entity that can access the item.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.accessible_by.login                                                                    | Login of the entity that can access the item.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | box.accessible_by.name                                                                     | Name of the entity that can access the item.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.accessible_by.type                                                                     | Type of entity that can access the item.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.additional_details.collab_id                                                           | ID of the collaboration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.additional_details.is_performed_by_admin                                               | Whether the action was performed by an admin.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | box.additional_details.role                                                                | Role associated with the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | box.additional_details.shield_alert.alert_id                                               | Box Shield alert ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | box.additional_details.shield_alert.alert_summary.anomaly_period.date_range.end_date       | When the anomaly was last observed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.additional_details.shield_alert.alert_summary.anomaly_period.date_range.start_date     | When the anomaly was last observed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.additional_details.shield_alert.alert_summary.anomaly_period.download_size             | Volume of Anomalous Downloads detected by Box Shield relating to an account holder who may be stealing sensitive content                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.additional_details.shield_alert.alert_summary.anomaly_period.downloaded_files_count    | Number of Anomalous Downloads detected by Box Shield relating to an account holder who may be stealing sensitive content                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | box.additional_details.shield_alert.alert_summary.description                              | Description of Alert                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.additional_details.shield_alert.alert_summary.download_delta_percent                   | Anomaly delta percentage relative to historical expectation                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | box.additional_details.shield_alert.alert_summary.download_delta_size                      | Anomaly delta size relative to historical expectation                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.additional_details.shield_alert.alert_summary.download_ips.ip                          | IP address                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | box.additional_details.shield_alert.alert_summary.historical_period.date_range.end_date    | End of historical period for calculation of historical expectation                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.additional_details.shield_alert.alert_summary.historical_period.date_range.start_date  | Start of historical period for calculation of historical expectation                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.additional_details.shield_alert.alert_summary.historical_period.download_size          | Volume of Anomalous Downloads detected by Box Shield relating to an account holder who may be stealing sensitive content                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.additional_details.shield_alert.alert_summary.historical_period.downloaded_files_count | Number of Anomalous Downloads detected by Box Shield relating to an account holder who may be stealing sensitive content                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | box.additional_details.shield_alert.alert_summary.upload_activity.event_type               | Type of event, e.g. `Upload`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.ip_info.ip               | IP address                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | box.additional_details.shield_alert.alert_summary.upload_activity.ip_info.registrant       | Registrant of IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.item_id                  | ID of item                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.item_name                | Name of item                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.item_path                | Path to Item                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.item_type                | Type of Item                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.occurred_at              | Time of Upload                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | box.additional_details.shield_alert.alert_summary.upload_activity.service_name             | Service used to upload the suspected Malware                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.created_at                                             | Time alert was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | box.additional_details.shield_alert.link                                                   | URL with information about this alert                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.additional_details.shield_alert.malware_info.categories                                | Array of Malware Categories e.g. `Adware`, `Spyware`                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.additional_details.shield_alert.malware_info.description                               | Describes the Malware                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.additional_details.shield_alert.malware_info.detail_link                               | URL with detail of Malware                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.additional_details.shield_alert.malware_info.family                                    | Malware Family                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | box.additional_details.shield_alert.malware_info.file_created                              | Date of file creation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | box.additional_details.shield_alert.malware_info.file_created_by.email                     | Email of file creator                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.additional_details.shield_alert.malware_info.file_created_by.id                        | ID of file creator. The Box Shield documentation example uses `long`, not `string`                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | box.additional_details.shield_alert.malware_info.file_created_by.name                      | Display name of file creator                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.malware_info.file_hash                                 | File hash                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | box.additional_details.shield_alert.malware_info.file_hash_type                            | Hash type, e.g. `SHA-1`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | box.additional_details.shield_alert.malware_info.file_id                                   | File ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | box.additional_details.shield_alert.malware_info.file_name                                 | File name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | box.additional_details.shield_alert.malware_info.file_size_bytes                           | File size in bytes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | box.additional_details.shield_alert.malware_info.file_version                              | File version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | box.additional_details.shield_alert.malware_info.file_version_uploaded                     | Date this version of file was uploaded                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | box.additional_details.shield_alert.malware_info.file_version_uploaded_by.email            | Email of file uploader                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.additional_details.shield_alert.malware_info.file_version_uploaded_by.id               | ID of file uploader                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | box.additional_details.shield_alert.malware_info.file_version_uploaded_by.name             | Display name of file uploader                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | box.additional_details.shield_alert.malware_info.first_seen                                | Time Malware first observed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | box.additional_details.shield_alert.malware_info.last_seen                                 | Time Malware last observed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | box.additional_details.shield_alert.malware_info.malware_name                              | Malware name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.malware_info.status                                    | Malware status e.g. `Malicious`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | box.additional_details.shield_alert.malware_info.tags                                      | Array of Malware Tags e.g. `FILE_MALICIOUS_EXECUTION`                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.additional_details.shield_alert.priority                                               | Box Shield priority of alert                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.additional_details.shield_alert.risk_score                                             | Risk score as calculated by Box Shield                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | box.additional_details.shield_alert.rule_category                                          | Rule Category as allocated by Box Shield                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.additional_details.shield_alert.rule_id                                                | Box Shield rule ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | box.additional_details.shield_alert.rule_name                                              | Box Shield rule name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.additional_details.shield_alert.user.email                                             | User email                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.additional_details.shield_alert.user.id                                                | User ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | box.additional_details.shield_alert.user.name                                              | User name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | box.additional_details.type                                                                | Type of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.created_at                                                                             | When the event object was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
  | box.created_by.id                                                                          | The unique identifier for the connection user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | box.created_by.login                                                                       | The primary email address of the connection user. Maps from **.login                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.created_by.name                                                                        | The display name of the connection user. Maps from **.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.created_by.type                                                                        | E.g. `user`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | box.ip_address                                                                             | IP Address                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.recorded_at                                                                            | The date and time at which this event occurred                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | date             |
  | box.session.id                                                                             | Box `session_id` field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.source.address                                                                         | Physical Address associated with the event                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.source.avatar_url                                                                      | URL for user avatar                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | boolean          |
  | box.source.created_at                                                                      | The date and time at which this folder was originally created                                                                                                                                                                                                                                                                                                                                                                                                                                                                | date             |
  | box.source.created_by.id                                                                   | The unique identifier for this user                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | box.source.created_by.login                                                                | The primary email address of this user. Maps from **.login                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.source.created_by.name                                                                 | The display name of this user. Maps from **.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.source.created_by.type                                                                 | Value is always `user`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.source.description                                                                     | The optional description of this folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | text             |
  | box.source.etag                                                                            | The HTTP etag of this folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.source.file_version.id                                                                 | The unique identifier that represent a file version                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | box.source.file_version.type                                                               | Value is always `file_version`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | box.source.folder_name                                                                     | The name of a folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.source.id                                                                              | The unique identifier that represent a folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | box.source.item_status                                                                     | Defines if this item has been deleted or not. active when the item has is not in the trash trashed when the item has been moved to the trash but not deleted deleted when the item has been permanently deleted. Value is one of `active`, `trashed`, `deleted`                                                                                                                                                                                                                                                              | keyword          |
  | box.source.job_title                                                                       | User job title                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | box.source.language                                                                        | User preferred language                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | boolean          |
  | box.source.login                                                                           | User login                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | box.source.max_upload_size                                                                 | Max upload size                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | box.source.modified_at                                                                     | The date and time at which this folder was last updated                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | box.source.modified_by.id                                                                  | The unique identifier for this user that last modified the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.source.modified_by.login                                                               | The primary email address of this user. Maps from **.login                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.source.modified_by.name                                                                | The display name of this user. Maps from **.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.source.modified_by.type                                                                | Value is always `user`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.source.notification_email.email                                                        | Email to send notifications                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | box.source.notification_email.is_confirmed                                                 | True if `notification_email.email` has been confirmed else false                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | box.source.owned_by.id                                                                     | The unique identifier for this user                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | box.source.owned_by.login                                                                  | The primary email address of this user. Maps from **.login                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | box.source.owned_by.name                                                                   | The display name of this user. Maps from **.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.source.owned_by.type                                                                   | Value is always `user`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.source.parent.etag                                                                     | The HTTP etag of this folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.source.parent.id                                                                       | The unique identifier that represent a folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | box.source.parent.name                                                                     | The name of the folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | box.source.parent.sequence_id                                                              | A numeric identifier that represents the most recent user event that has been applied to this item (parent)                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | box.source.parent.type                                                                     | Value is always `folder`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | box.source.path_collection.entries.etag                                                    | The HTTP etag of this folder                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | box.source.path_collection.entries.id                                                      | The unique identifier that represent a folder. This field is an array                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.source.path_collection.entries.name                                                    | The name of the parent folder. This field is an array                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | box.source.path_collection.entries.sequence_id                                             | A numeric identifier that represents the most recent user event that has been applied to this item                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.source.path_collection.entries.type                                                    | Value is always `folder`. This field is an array                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | box.source.path_collection.total_count                                                     | The number of folders in this list                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | box.source.phone                                                                           | Phone number                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | boolean          |
  | box.source.purged_at                                                                       | The time at which this file is expected to be purged from the trash                                                                                                                                                                                                                                                                                                                                                                                                                                                          | boolean          |
  | box.source.sequence_id                                                                     | A numeric identifier that represents the most recent user event that has been applied to this item                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | box.source.sha1                                                                            | SHA1 hash of the item concerned                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | box.source.space_amount                                                                    | Space amount                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | boolean          |
  | box.source.space_used                                                                      | Space used                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | box.source.status                                                                          | For example: `active`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |
  | box.source.synced                                                                          | Legacy property for compatibility with Box Desktop                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | box.source.timezone                                                                        | Timezone                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |
  | box.source.trashed_at                                                                      | The time at which this file was put in the trash                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | box.source.user_id                                                                         | Unique user ID of the user that triggered the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | box.source.user_name                                                                       | The name of the user that triggered the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | cloud.image.id                                                                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset                                                                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                                                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                                                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                                              | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                                               | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized                                                                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build                                                                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                                                                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type                                                                                 | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | threat.enrichments.indicator.first_seen                                                    | The date and time when intelligence source first reported sighting this indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | threat.enrichments.indicator.last_seen                                                     | The date and time when intelligence source last reported sighting this indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![[Logs Box Events Integration] Events Dashboard](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot.png)

  ![Box Events over Time by Event Type](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_histogram.png)

  ![All Box Events by Event Type](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_type.png)

  ![Box Events by ECS Event Classification](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_ecs_event_classification.png)

  ![All Box Events by File Name](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_name.png)

  ![Total Upload Bytes](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_upload.png)

  ![Total Download Bytes](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_download.png)

  ![Total Trash Bytes](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_trash.png)

  ![Top 10 Users x Number of Events associated with the user](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_actions.png)

  ![Top 10 Users x number of Failed Logins](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_failed_logins.png)

  ![[Logs Box Events Integration] Box Shield Alerts Dashboard](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts.png)

  ![Box Shield Threat Histogram](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_threat_histogram.png)

  ![Box Shield Threat Locations](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_threat_locations.png)

  ![Box Shield Alerts By ECS Threat Classification](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_ecs_event_classification.png)

  ![Top Threats](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_top_threats.png)

  ![Box Shield Anomalous Downloads](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_anomalous_downloads.png)

  ![Box Shield Malware](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_malware.png)

  ![Box Shield Suspicious Locations](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_suspicious_locations.png)

  ![Box Shield Suspicious Sessions](https://epr.elastic.co/package/box_events/3.1.1/img/box_screenshot_shield_alerts_suspicious_sessions.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                               | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17118))Update stream position handling to match string type provided by API.                                                                                                                                            | 9.1.49.0.78.19.4       |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16530))Prevent updating fleet health status to degraded when pagination completes.                                                                                                                                  | 9.1.49.0.78.19.4       |
  | **3.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15947))Remove non-ECS fields that are collided with ECS namespace.Following fields will no longer be available:`related.location.lat`, `related.location.lon`, `related.description`, `related.indicator_type`. | 9.0.08.13.0            |
  | **2.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15299))Fix the description of the interval setting.                                                                                                                                                                     | 9.0.08.13.0            |
  | **2.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15257))Add limit parameter for API requests.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15257))Fix the absence of pagination logic.                                               | 9.0.08.13.0            |
  | **2.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14319))Fix handling of large cursor offsets.                                                                                                                                                                            | 9.0.08.13.0            |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14001))Update and expand ECS `user.*` field mappings.                                                                                                                                                               | 9.0.08.13.0            |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12944))Handle collaboration invite events and improve user field handling.                                                                                                                                          | 9.0.08.13.0            |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                   | 9.0.08.13.0            |
  | **2.11.1** | **Bug fix** ([View pull request](http://github.com/elastic/integrations/pull/12624))Add missing ECS mappings.                                                                                                                                                                                         | 8.13.0                 |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                    | 8.13.0                 |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10897))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                     | 8.13.0                 |
  | **2.9.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10606))Fix handling of empty API responses.                                                                                                                                                                         | 8.13.0                 |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                          | 8.13.0                 |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9498))Use `event_id` field for document fingerprinting.                                                                                                                                                             | 8.12.0                 |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9389))Update manifest format version to v3.0.3.                                                                                                                                                                     | 8.12.0                 |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                                                               | 8.12.0                 |
  | **2.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                | 8.7.1                  |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                       | 8.7.1                  |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                                | 8.7.1                  |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                        | 8.7.1                  |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8097))Modified the field definitions to reference ECS where possible and remove invalid field attributes.                                                                                                           | 8.7.1                  |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                                                                                   | 8.7.1                  |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7906))Aligned ECS categorization fields and update package to ECS 8.10.0.                                                                                                                                           | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                          | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7592))Update package-spec to 2.10.0.                                                                                                                                                                                | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                                                  | 8.7.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                                                                | 8.7.1                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                       | 8.7.1                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6518))Sanitise IP values.                                                                                                                                                                                           | 8.7.1                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                                                  | 8.7.1                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                      | 8.7.1                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                  | 8.3.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5677))Release Box Events as GA.                                                                                                                                                                                     | 8.3.07.17.0            |
  | **0.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                        |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                  |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4578))Consolidate all event streams to reduce bandwidth                                                                                                                                                             |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                  |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3677))Initial beta version of the package                                                                                                                                                                           |                        |
</dropdown>