﻿---
title: BBOT integration
description: The Bighuge BLS OSINT Tool (BBOT) integration is intended for BBOT installations, an Attack Surface Management (ASM) Open Source Inteligence (OSINT) Tool...
url: https://www.elastic.co/docs/reference/integrations/bbot
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# BBOT integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.4.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | File, Webhook                  |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

The Bighuge BLS OSINT Tool (BBOT) integration is intended for [BBOT](https://www.blacklanternsecurity.com/bbot/) installations, an Attack Surface Management (ASM) Open Source Inteligence (OSINT) Tool.
Once the BBOT scan is complete, the integration will ingest the results into Elastic.
This integration requires the external use of BBOT. You will have to download and run the tool apart from this integration. Once your scan is complete, this integration can ingest the results into Elastic using the BBOT `json` output module or the `http` output module aka. HTTP POST/webhooks.
As of version `1.1.2` of this integration, both BBOT `1.x` and `2.x` are supported. However all examples provided by the module documentation now assume use of BBOT `2.x`.
Note that BBOT `1.x` formats are currently being supported on a best-effort basis only and support will eventually be removed.
Please upgrade to BBOT `2.x` as soon as possible to ensure continuity of features and functionality.
To support the conflicting BBOT NDJSON event formats, the following occurs during ingest of BBOT `2.x` SCAN events:
1. The `bbot.data.scan` field, if received as an object, is renamed to `bbot.data.scan_config`
2. `bbot.data.scan` is set using the ID and name of the scan to replicate the field type and content generated by BBOT `1.x`

This tool is used to enhance your external knowledge of your environment. This is done through the integration of many tools into BBOT providing a overview of your attack surface. Here is [how it works](https://www.blacklanternsecurity.com/bbot/how_it_works/).
**Important Note**
You have to provide the following parameter in your BBOT scan to get your `output.json` formatted correctly.
`-c modules.json.siem_friendly=true`
Alternatively, if you are using the HTTP output modules:
`-c modules.http.siem_friendly=true`
It's recommended to at least filter out `HTTP_RESPONSE` and `RAW_TEXT` events from reaching the SIEM, as they may contain excessive field data that could be difficult to process.
Make sure the configuration option is default, or is similar to the following:
```
omit_event_types:
- HTTP_RESPONSE
- RAW_TEXT
```

**Example BBOT Scan**
If you use the integration to collect log files from disk, you can simply use the JSON output module.
`bbot -t example.com -p subdomain-enum -c modules.json.siem_friendly=true -om json`
If you use the integration to receive events via HTTP endpoint listener, you can use the HTTP output module.
`bbot -t example.com -p subdomain-enum --config modules.http.url=http://your.elastic.agent:8080/bbot/asm_intel modules.http.username=bbot modules.http.password=P@55w0rd modules.http.siem_friendly=true -om http`
You will have to configure the path for the output file within the integration settings.
The output modules can also be configured as part of the bbot.yml or preset files.
```
config:
  modules:
    http:
      url: 'https://your.elastic.agent:8443'
      method: POST
      username: 'bbot'
      password: 'P@55w0rd'
      siem_friendly: true
    json:
      siem_friendly: true
```

**Example BBOT Path**
`/home/<user>/.bbot/scans/*/output.json`
BBOT Scanning [Documentation](https://www.blacklanternsecurity.com/bbot/Stable/scanning/).

## Data streams

This integration collects the following logs:
- **asm_intel** Made up of the findings found in the BBOT Scans.


## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

## Enable the integration in Elastic

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **BBOT**.
3. Select the **BBOT** integration and add it.
4. Add all the required configuration parameters, including the path to the `ndjson` file.
5. Save the integration.


## Logs


### ASM Findings

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-02-29T01:41:47.779Z",
      "agent": {
          "ephemeral_id": "0c16a7c4-c1a9-424a-b859-29af68197f5c",
          "id": "91b85fe6-d0c4-4bfc-863d-e10a462e0968",
          "name": "elastic-agent-38224",
          "type": "filebeat",
          "version": "8.15.3"
      },
      "bbot": {
          "data": {
              "dns_name": "example.com"
          },
          "id": "DNS_NAME:f57ba0828becd7bf94faa616db081ed06f31bd3d",
          "module": "TARGET",
          "module_sequence": "TARGET",
          "resolved_hosts": [
              "1.128.0.0"
          ],
          "scan": "SCAN:725368977d3a680e579707504e59428a7e3acc9d",
          "scope_distance": 0,
          "source": "SCAN:725368977d3a680e579707504e59428a7e3acc9d",
          "tags": [
              "resolved",
              "a-record",
              "target",
              "in-scope",
              "subdomain"
          ],
          "timestamp": "1.709170907779394E9",
          "type": "DNS_NAME"
      },
      "data_stream": {
          "dataset": "bbot.asm_intel",
          "namespace": "28270",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "91b85fe6-d0c4-4bfc-863d-e10a462e0968",
          "snapshot": false,
          "version": "8.15.3"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "bbot.asm_intel",
          "ingested": "2024-11-14T08:17:02Z",
          "kind": "asset",
          "original": "{\"data\":{\"DNS_NAME\":\"example.com\"},\"id\":\"DNS_NAME:f57ba0828becd7bf94faa616db081ed06f31bd3d\",\"module\":\"TARGET\",\"module_sequence\":\"TARGET\",\"resolved_hosts\":[\"1.128.0.0\"],\"scan\":\"SCAN:725368977d3a680e579707504e59428a7e3acc9d\",\"scope_distance\":0,\"source\":\"SCAN:725368977d3a680e579707504e59428a7e3acc9d\",\"tags\":[\"resolved\",\"a-record\",\"target\",\"in-scope\",\"subdomain\"],\"timestamp\":1709170907.779394,\"type\":\"DNS_NAME\"}",
          "type": [
              "info"
          ]
      },
      "host": {
          "name": "example.com"
      },
      "input": {
          "type": "http_endpoint"
      },
      "related": {
          "hosts": [
              "1.128.0.0"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "bbot"
      ],
      "url": {
          "domain": [
              "example.com"
          ]
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                              | Description             | Type             |
  |------------------------------------------------------------------------------------|-------------------------|------------------|
  | @timestamp                                                                         | Event timestamp.        | date             |
  | bbot.data.asn.asn                                                                  |                         | keyword          |
  | bbot.data.asn.country                                                              |                         | keyword          |
  | bbot.data.asn.description                                                          |                         | keyword          |
  | bbot.data.asn.name                                                                 |                         | keyword          |
  | bbot.data.asn.subnet                                                               |                         | keyword          |
  | bbot.data.azure_tenant.domains                                                     |                         | keyword          |
  | bbot.data.azure_tenant.tenant-id                                                   |                         | keyword          |
  | bbot.data.azure_tenant.tenant-names                                                |                         | keyword          |
  | bbot.data.code_repository.url                                                      |                         | keyword          |
  | bbot.data.dns_name                                                                 |                         | keyword          |
  | bbot.data.dns_name_unresolved                                                      |                         | keyword          |
  | bbot.data.email_address                                                            |                         | keyword          |
  | bbot.data.filesystem.description                                                   |                         | text             |
  | bbot.data.filesystem.path                                                          |                         | keyword          |
  | bbot.data.finding.description                                                      |                         | text             |
  | bbot.data.finding.host                                                             |                         | keyword          |
  | bbot.data.finding.url                                                              |                         | keyword          |
  | bbot.data.http_response.a                                                          |                         | keyword          |
  | bbot.data.http_response.body                                                       |                         | text             |
  | bbot.data.http_response.cname                                                      |                         | keyword          |
  | bbot.data.http_response.content_length                                             |                         | unsigned_long    |
  | bbot.data.http_response.content_type                                               |                         | keyword          |
  | bbot.data.http_response.csp.domains                                                |                         | keyword          |
  | bbot.data.http_response.failed                                                     |                         | boolean          |
  | bbot.data.http_response.hash.*                                                     |                         | keyword          |
  | bbot.data.http_response.header-dict.*                                              |                         | keyword          |
  | bbot.data.http_response.header-dict.location                                       |                         | text             |
  | bbot.data.http_response.header.*                                                   |                         | keyword          |
  | bbot.data.http_response.host                                                       |                         | keyword          |
  | bbot.data.http_response.input                                                      |                         | keyword          |
  | bbot.data.http_response.lines                                                      |                         | unsigned_long    |
  | bbot.data.http_response.location                                                   |                         | keyword          |
  | bbot.data.http_response.method                                                     |                         | keyword          |
  | bbot.data.http_response.path                                                       |                         | keyword          |
  | bbot.data.http_response.port                                                       |                         | keyword          |
  | bbot.data.http_response.raw_header                                                 |                         | text             |
  | bbot.data.http_response.request                                                    |                         | keyword          |
  | bbot.data.http_response.scheme                                                     |                         | keyword          |
  | bbot.data.http_response.status_code                                                |                         | unsigned_long    |
  | bbot.data.http_response.time                                                       |                         | keyword          |
  | bbot.data.http_response.timestamp                                                  |                         | keyword          |
  | bbot.data.http_response.title                                                      |                         | keyword          |
  | bbot.data.http_response.url                                                        |                         | keyword          |
  | bbot.data.http_response.webserver                                                  |                         | keyword          |
  | bbot.data.http_response.words                                                      |                         | unsigned_long    |
  | bbot.data.ip_address                                                               |                         | keyword          |
  | bbot.data.open_tcp_port                                                            |                         | keyword          |
  | bbot.data.org_stub                                                                 |                         | keyword          |
  | bbot.data.protocol.host                                                            |                         | keyword          |
  | bbot.data.protocol.port                                                            |                         | unsigned_long    |
  | bbot.data.protocol.protocol                                                        |                         | keyword          |
  | bbot.data.raw_dns_record.answer                                                    |                         | keyword          |
  | bbot.data.raw_dns_record.host                                                      |                         | keyword          |
  | bbot.data.raw_dns_record.type                                                      |                         | keyword          |
  | bbot.data.scan                                                                     |                         | keyword          |
  | bbot.data.scan_config.duration                                                     |                         | keyword          |
  | bbot.data.scan_config.duration_seconds                                             |                         | float            |
  | bbot.data.scan_config.finished_at                                                  |                         | date             |
  | bbot.data.scan_config.id                                                           |                         | keyword          |
  | bbot.data.scan_config.name                                                         |                         | keyword          |
  | bbot.data.scan_config.preset.config.aggregate                                      |                         | boolean          |
  | bbot.data.scan_config.preset.config.cloudcheck                                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.deps.ffuf.version                              |                         | keyword          |
  | bbot.data.scan_config.preset.config.deps_behavior                                  |                         | keyword          |
  | bbot.data.scan_config.preset.config.dns.abort_threshold                            |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.brute_threads                              |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.debug                                      |                         | boolean          |
  | bbot.data.scan_config.preset.config.dns.disable                                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.dns.filter_ptrs                                |                         | boolean          |
  | bbot.data.scan_config.preset.config.dns.minimal                                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.dns.omit_queries                               |                         | keyword          |
  | bbot.data.scan_config.preset.config.dns.retries                                    |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.runaway_limit                              |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.search_distance                            |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.threads                                    |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.timeout                                    |                         | integer          |
  | bbot.data.scan_config.preset.config.dns.wildcard_disable                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.dns.wildcard_tests                             |                         | integer          |
  | bbot.data.scan_config.preset.config.dnsresolve                                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.excavate                                       |                         | boolean          |
  | bbot.data.scan_config.preset.config.file_blobs                                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.folder_blobs                                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.home                                           |                         | keyword          |
  | bbot.data.scan_config.preset.config.interactsh_disable                             |                         | boolean          |
  | bbot.data.scan_config.preset.config.keep_scans                                     |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.anubisdb.limit                         |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.asset_inventory.recheck                |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.asset_inventory.summary_netmask        |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.asset_inventory.use_previous           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.baddns.enable_references               |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.baddns.only_high_confidence            |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.baddns_zone.only_high_confidence       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.bevigil.urls                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.binaryedge.max_records                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.bucket_amazon.permutations             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.bucket_azure.permutations              |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.bucket_digitalocean.permutations       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.bucket_file_enum.file_limit            |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.bucket_firebase.permutations           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.bucket_google.permutations             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.builtwith.redirects                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.censys.max_pages                       |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.discord.event_types                    |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.discord.min_severity                   |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.dnsbrute.max_depth                     |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.dnsbrute.wordlist                      |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.dnsbrute_mutations.max_mutations       |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.dnscaa.dns_names                       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.dnscaa.emails                          |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.dnscaa.in_scope_only                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.dnscaa.urls                            |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.dnscommonsrv.max_depth                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.docker_pull.all_tags                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.excavate.retain_querystring            |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.excavate.yara_max_match_data           |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.ffuf.lines                             |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.ffuf.max_depth                         |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.ffuf.wordlist                          |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.find_common_prefixes   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.find_delimiters        |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.ignore_redirects       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.lines                  |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.max_depth              |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.ffuf_shortnames.version                |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.filedownload.base_64_encoded_file      |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.filedownload.extensions                |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.filedownload.max_filesize              |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.fingerprintx.skip_common_web           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.fingerprintx.version                   |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.github_codesearch.limit                |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.github_org.include_member_repos        |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.github_org.include_members             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.github_workflows.num_logs              |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.idle_timeout                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.resolution_x                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.resolution_y                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.social                       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.gowitness.threads                      |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.timeout                      |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.gowitness.version                      |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.http.method                            |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.http.siem_friendly                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.http.timeout                           |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.http.url                               |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.httpx.in_scope_only                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.httpx.max_response_size                |                         | long             |
  | bbot.data.scan_config.preset.config.modules.httpx.probe_all_ips                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.httpx.store_responses                  |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.httpx.threads                          |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.httpx.version                          |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.iis_shortnames.detect_only             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.iis_shortnames.max_node_count          |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.internetdb.show_open_ports             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.ipneighbor.num_bits                    |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.json.siem_friendly                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.neo4j.uri                              |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.ntlm.try_all                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.nuclei.batch_size                      |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.nuclei.budget                          |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.nuclei.concurrency                     |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.nuclei.directory_only                  |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.nuclei.mode                            |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.nuclei.ratelimit                       |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.nuclei.retries                         |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.nuclei.silent                          |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.nuclei.version                         |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.oauth.try_all                          |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_cookies.recycle_words       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_cookies.skip_boring_words   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_getparams.recycle_words     |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_getparams.skip_boring_words |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_headers.recycle_words       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.paramminer_headers.skip_boring_words   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.pgp.search_urls                        |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.portscan.ping_first                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.portscan.ping_only                     |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.portscan.rate                          |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.portscan.top_ports                     |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.portscan.wait                          |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.robots.include_allow                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.robots.include_disallow                |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.robots.include_sitemap                 |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.secretsdb.min_confidence               |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.secretsdb.signatures                   |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.slack.event_types                      |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.slack.min_severity                     |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.speculate.max_hosts                    |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.speculate.ports                        |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.splunk.timeout                         |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.sslcert.skip_non_ssl                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.sslcert.timeout                        |                         | float            |
  | bbot.data.scan_config.preset.config.modules.stdout.accept_dupes                    |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.stdout.format                          |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.stdout.in_scope_only                   |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.subdomains.include_unresolved          |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.teams.event_types                      |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.teams.min_severity                     |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.telerik.exploit_RAU_crypto             |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.trufflehog.concurrency                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.trufflehog.only_verified               |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.trufflehog.version                     |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.unstructured.extensions                |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.unstructured.ignore_folders            |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.url_manipulation.allow_redirects       |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.urlscan.urls                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.vhost.lines                            |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.vhost.wordlist                         |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.wafw00f.generic_detect                 |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.wayback.garbage_threshold              |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.wayback.urls                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.web_report.css_theme_file              |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.websocket.preserve_graph               |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.wpscan.connection_timeout              |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.wpscan.disable_tls_checks              |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.wpscan.enumerate                       |                         | keyword          |
  | bbot.data.scan_config.preset.config.modules.wpscan.force                           |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.wpscan.request_timeout                 |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.wpscan.threads                         |                         | integer          |
  | bbot.data.scan_config.preset.config.modules.zoomeye.include_related                |                         | boolean          |
  | bbot.data.scan_config.preset.config.modules.zoomeye.max_pages                      |                         | integer          |
  | bbot.data.scan_config.preset.config.omit_event_types                               |                         | keyword          |
  | bbot.data.scan_config.preset.config.scope.report_distance                          |                         | integer          |
  | bbot.data.scan_config.preset.config.scope.search_distance                          |                         | integer          |
  | bbot.data.scan_config.preset.config.speculate                                      |                         | boolean          |
  | bbot.data.scan_config.preset.config.status_frequency                               |                         | integer          |
  | bbot.data.scan_config.preset.config.url_extension_blacklist                        |                         | keyword          |
  | bbot.data.scan_config.preset.config.url_extension_httpx_only                       |                         | keyword          |
  | bbot.data.scan_config.preset.config.url_querystring_collapse                       |                         | boolean          |
  | bbot.data.scan_config.preset.config.url_querystring_remove                         |                         | boolean          |
  | bbot.data.scan_config.preset.config.web.debug                                      |                         | boolean          |
  | bbot.data.scan_config.preset.config.web.http_max_redirects                         |                         | integer          |
  | bbot.data.scan_config.preset.config.web.http_retries                               |                         | integer          |
  | bbot.data.scan_config.preset.config.web.http_timeout                               |                         | integer          |
  | bbot.data.scan_config.preset.config.web.httpx_retries                              |                         | integer          |
  | bbot.data.scan_config.preset.config.web.httpx_timeout                              |                         | integer          |
  | bbot.data.scan_config.preset.config.web.spider_depth                               |                         | integer          |
  | bbot.data.scan_config.preset.config.web.spider_distance                            |                         | integer          |
  | bbot.data.scan_config.preset.config.web.spider_links_per_page                      |                         | integer          |
  | bbot.data.scan_config.preset.config.web.ssl_verify                                 |                         | boolean          |
  | bbot.data.scan_config.preset.config.web.user_agent                                 |                         | keyword          |
  | bbot.data.scan_config.preset.description                                           |                         | text             |
  | bbot.data.scan_config.preset.flags                                                 |                         | keyword          |
  | bbot.data.scan_config.preset.modules                                               |                         | keyword          |
  | bbot.data.scan_config.preset.output_modules                                        |                         | keyword          |
  | bbot.data.scan_config.preset.scan_name                                             |                         | keyword          |
  | bbot.data.scan_config.started_at                                                   |                         | date             |
  | bbot.data.scan_config.status                                                       |                         | keyword          |
  | bbot.data.scan_config.target.blacklist_hash                                        |                         | keyword          |
  | bbot.data.scan_config.target.hash                                                  |                         | keyword          |
  | bbot.data.scan_config.target.scope_hash                                            |                         | keyword          |
  | bbot.data.scan_config.target.seed_hash                                             |                         | keyword          |
  | bbot.data.scan_config.target.seeds                                                 |                         | keyword          |
  | bbot.data.scan_config.target.strict_scope                                          |                         | boolean          |
  | bbot.data.scan_config.target.whitelist                                             |                         | keyword          |
  | bbot.data.scan_config.target.whitelist_hash                                        |                         | keyword          |
  | bbot.data.scan_json                                                                |                         | text             |
  | bbot.data.social.platform                                                          |                         | keyword          |
  | bbot.data.social.profile_name                                                      |                         | keyword          |
  | bbot.data.social.url                                                               |                         | keyword          |
  | bbot.data.storage_bucket.name                                                      |                         | keyword          |
  | bbot.data.storage_bucket.url                                                       |                         | keyword          |
  | bbot.data.technology.host                                                          |                         | keyword          |
  | bbot.data.technology.technology                                                    |                         | keyword          |
  | bbot.data.technology.url                                                           |                         | keyword          |
  | bbot.data.url                                                                      |                         | keyword          |
  | bbot.data.url_unverified                                                           |                         | keyword          |
  | bbot.data.vulnerability.description                                                |                         | text             |
  | bbot.data.vulnerability.host                                                       |                         | keyword          |
  | bbot.data.vulnerability.severity                                                   |                         | keyword          |
  | bbot.data.vulnerability.url                                                        |                         | keyword          |
  | bbot.data.waf.host                                                                 |                         | keyword          |
  | bbot.data.waf.url                                                                  |                         | keyword          |
  | bbot.data.waf.waf                                                                  |                         | keyword          |
  | bbot.data.web_parameter.description                                                |                         | keyword          |
  | bbot.data.web_parameter.host                                                       |                         | keyword          |
  | bbot.data.web_parameter.name                                                       |                         | keyword          |
  | bbot.data.web_parameter.original_value                                             |                         | keyword          |
  | bbot.data.web_parameter.type                                                       |                         | keyword          |
  | bbot.data.web_parameter.url                                                        |                         | keyword          |
  | bbot.discovery_context                                                             |                         | text             |
  | bbot.discovery_path                                                                |                         | text             |
  | bbot.dns_children.*                                                                |                         | keyword          |
  | bbot.host                                                                          |                         | keyword          |
  | bbot.id                                                                            |                         | keyword          |
  | bbot.module                                                                        |                         | keyword          |
  | bbot.module_sequence                                                               |                         | keyword          |
  | bbot.netloc                                                                        |                         | keyword          |
  | bbot.parent                                                                        |                         | keyword          |
  | bbot.parent_chain                                                                  |                         | keyword          |
  | bbot.parent_uuid                                                                   |                         | keyword          |
  | bbot.port                                                                          |                         | integer          |
  | bbot.resolved_hosts                                                                |                         | keyword          |
  | bbot.scan                                                                          |                         | keyword          |
  | bbot.scope_description                                                             |                         | keyword          |
  | bbot.scope_distance                                                                |                         | integer          |
  | bbot.source                                                                        |                         | keyword          |
  | bbot.tags                                                                          |                         | keyword          |
  | bbot.timestamp                                                                     |                         | keyword          |
  | bbot.type                                                                          |                         | keyword          |
  | bbot.uuid                                                                          |                         | keyword          |
  | bbot.web_spider_distance                                                           |                         | integer          |
  | data_stream.dataset                                                                | Data stream dataset.    | constant_keyword |
  | data_stream.namespace                                                              | Data stream namespace.  | constant_keyword |
  | data_stream.type                                                                   | Data stream type.       | constant_keyword |
  | host.as.number                                                                     |                         | long             |
  | input.type                                                                         | Type of Filebeat input. | keyword          |
  | log.offset                                                                         | Log offset.             | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![BBOT Screenshot](https://epr.elastic.co/package/bbot/1.4.0/img/BBOT-Dashboard.png)

  ![Add Integration](https://epr.elastic.co/package/bbot/1.4.0/img/add-integration-1.png)

  ![Add Integration](https://epr.elastic.co/package/bbot/1.4.0/img/add-integration-2.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                              | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13573))Remove redundant installation instructions.                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                  | 9.0.08.13.0            |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11742))Update to support BBOT v2 output formats**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11742))Add http_endpoint input option to support BBOT HTTP output module          | 8.13.0                 |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12071))Fix broken links in Security Service integrations packages.                                                                                                                                                     | 8.13.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                   | 8.13.0                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11210))Release package as GA.                                                                                                                                                                                      | 8.13.0                 |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9651))Initial release of the bbot package                                                                                                                                                                          |                        |
</dropdown>