﻿---
title: Azure Network Watcher NSG
description: Network security group (NSG) flow logging is a feature of Azure Network Watcher that allows you to log information about IP traffic flowing through a...
url: https://www.elastic.co/docs/reference/integrations/azure_network_watcher_nsg
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Azure Network Watcher NSG
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | Azure Blob Storage             |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.0                    |

[Network security group](https://learn.microsoft.com/en-us/azure/virtual-network/network-security-groups-overview) (NSG) flow logging is a feature of Azure Network Watcher that allows you to log information about IP traffic flowing through a network security group. Flow logs are the source of truth for all network activity in your cloud environment. Whether you're in a startup that's trying to optimize resources or a large enterprise that's trying to detect intrusion, flow logs can help. You can use them for optimizing network flows, monitoring throughput, verifying compliance, detecting intrusions, and more.

## Data streams

This integration supports ingestion of logs from Azure Network Watcher NSG, via [Azure Blob Storage](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-azure-blob-storage.html) input.
- **Log** is used to retrieve NSG Flow data. See more details in the documentation [here](https://learn.microsoft.com/en-us/azure/network-watcher/nsg-flow-logs-overview).


## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

## Setup


### To collect data from Azure Network Watcher NSG follow the below steps:

1. In the [Azure portal](https://portal.azure.com/), go to your **storage account**.
2. Under **Security + networking**, Click on **Access keys**. Your account access keys appear, as well as the complete connection string for each key.
3. Click on **Show** keys to show your **access keys** and **connection strings** and to enable buttons to copy the values.
4. Under key1, find the Key value. Click on the Copy button to copy the **account key**. Same way you can copy the **storage account name** shown above keys.
5. Go to **Containers** under **Data storage** in your storage account to copy the **container name**.
6. Configure the integration using either Service Account Credentials or Microsoft Entra ID RBAC with OAuth2 options. For OAuth2 (Entra ID RBAC), you'll need the Client ID, Client Secret, and Tenant ID. For Service Account Credentials, you'll need either the Service Account Key or the URI to access the data.

- How to setup the `auth.oauth2` credentials can be found in the Azure documentation [here](https://docs.microsoft.com/en-us/azure/active-directory/develop/quickstart-register-app).
- For more details about the Azure Blob Storage input settings, check the [Filebeat documentation](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-azure-blob-storage.html).

Note:
- Enable virtual network flow logs using the steps provided in [reference](https://learn.microsoft.com/en-us/azure/network-watcher/nsg-flow-logs-portal).
- The service principal must be granted the appropriate permissions to read blobs. Ensure that the necessary role assignments are in place for the service principal to access the storage resources. For more information, please refer to the [Azure Role-Based Access Control (RBAC) documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/built-in-roles/storage).
- We recommend assigning either the **Storage Blob Data Reader** or **Storage Blob Data Owner** role. The **Storage Blob Data Reader** role provides read-only access to blob data and is aligned with the principle of least privilege, making it suitable for most use cases. The **Storage Blob Data Owner** role grants full administrative access — including read, write, and delete permissions — and should be used only when such elevated access is explicitly required.


### Enabling the integration in Elastic:

1. In Kibana navigate to Management > Integrations.
2. In "Search for integrations" top bar, search for `Azure Network Watcher NSG`.
3. Select the "Azure Network Watcher NSG" integration from the search results.
4. Select "Add Azure Network Watcher NSG" to add the integration.
5. While adding the integration, to collect logs via Azure Blob Storage, keep **Collect NSG logs via Azure Blob Storage** toggle on and then configure following parameters:
   For OAuth2 (Microsoft Entra ID RBAC):
   - Toggle on **Collect logs using OAuth2 authentication**
- Account Name
- Client ID
- Client Secret
- Tenant ID
- Container Details.
   For Service Account Credentials:
   - Service Account Key or the URI
- Account Name
- Container Details
6. Save the integration.


## Logs Reference


### Log

This is the `Log` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2018-11-13T12:00:35.389Z",
      "agent": {
          "ephemeral_id": "b9d6de84-93bd-40d6-9dc8-c06a84e0718e",
          "id": "7a02b789-2d3c-4e39-a804-6995ecfd6bc0",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.12.0"
      },
      "azure": {
          "resource": {
              "group": "FABRIKAMRG",
              "id": "/SUBSCRIPTIONS/00000000-0000-0000-0000-000000000000/RESOURCEGROUPS/FABRIKAMRG/PROVIDERS/MICROSOFT.NETWORK/NETWORKSECURITYGROUPS/FABRIAKMVM1-NSG",
              "name": "FABRIAKMVM1-NSG",
              "provider": "MICROSOFT.NETWORK/NETWORKSECURITYGROUPS"
          },
          "storage": {
              "blob": {
                  "content_type": "application/json",
                  "name": "testblob"
              },
              "container": {
                  "name": "azure-container1"
              }
          },
          "subscription_id": "00000000-0000-0000-0000-000000000000"
      },
      "azure_network_watcher_nsg": {
          "log": {
              "category": "NetworkSecurityGroupFlowEvent",
              "operation_name": "NetworkSecurityGroupFlowEvents",
              "properties": {
                  "flows": [
                      {
                          "flows": [
                              {
                                  "mac": "00-0D-3A-F8-78-56",
                                  "tuples": [
                                      {
                                          "destination": {
                                              "ip": "10.5.16.4",
                                              "port": 443
                                          },
                                          "flow_state": "Begin",
                                          "protocol": "UDP",
                                          "source": {
                                              "ip": "94.102.49.190",
                                              "port": 28746
                                          },
                                          "timestamp": "2018-11-13T12:00:02.000Z",
                                          "traffic": {
                                              "decision": "Denied",
                                              "flow": "Inbound"
                                          }
                                      },
                                      {
                                          "destination": {
                                              "ip": "10.5.16.4",
                                              "port": 59336
                                          },
                                          "flow_state": "Begin",
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "176.119.4.10",
                                              "port": 56509
                                          },
                                          "timestamp": "2018-11-13T12:00:24.000Z",
                                          "traffic": {
                                              "decision": "Denied",
                                              "flow": "Inbound"
                                          }
                                      },
                                      {
                                          "destination": {
                                              "ip": "10.5.16.4",
                                              "port": 8088
                                          },
                                          "flow_state": "Begin",
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "167.99.86.8",
                                              "port": 48495
                                          },
                                          "timestamp": "2018-11-13T12:00:32.000Z",
                                          "traffic": {
                                              "decision": "Denied",
                                              "flow": "Inbound"
                                          }
                                      }
                                  ]
                              }
                          ],
                          "rule": "DefaultRule_DenyAllInBound"
                      },
                      {
                          "flows": [
                              {
                                  "mac": "00-0D-3A-F8-78-56",
                                  "tuples": [
                                      {
                                          "destination": {
                                              "ip": "13.67.143.118",
                                              "port": 443
                                          },
                                          "flow_state": "Begin",
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "10.5.16.4",
                                              "port": 59831
                                          },
                                          "timestamp": "2018-11-13T11:59:37.000Z",
                                          "traffic": {
                                              "decision": "Allowed",
                                              "flow": "Outbound"
                                          }
                                      },
                                      {
                                          "bytes": {
                                              "received": 66,
                                              "sent": 66
                                          },
                                          "destination": {
                                              "ip": "13.67.143.117",
                                              "port": 443
                                          },
                                          "flow_state": "End",
                                          "packets": {
                                              "received": 1,
                                              "sent": 1
                                          },
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "10.5.16.4",
                                              "port": 59932
                                          },
                                          "timestamp": "2018-11-13T11:59:39.000Z",
                                          "traffic": {
                                              "decision": "Allowed",
                                              "flow": "Outbound"
                                          }
                                      },
                                      {
                                          "bytes": {
                                              "received": 14008,
                                              "sent": 16978
                                          },
                                          "destination": {
                                              "ip": "13.67.143.115",
                                              "port": 443
                                          },
                                          "flow_state": "Continuing",
                                          "packets": {
                                              "received": 24,
                                              "sent": 30
                                          },
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "10.5.16.4",
                                              "port": 44931
                                          },
                                          "timestamp": "2018-11-13T11:59:39.000Z",
                                          "traffic": {
                                              "decision": "Allowed",
                                              "flow": "Outbound"
                                          }
                                      },
                                      {
                                          "bytes": {
                                              "received": 7054,
                                              "sent": 8489
                                          },
                                          "destination": {
                                              "ip": "40.71.12.225",
                                              "port": 443
                                          },
                                          "flow_state": "End",
                                          "packets": {
                                              "received": 12,
                                              "sent": 15
                                          },
                                          "protocol": "TCP",
                                          "source": {
                                              "ip": "10.5.16.4",
                                              "port": 59929
                                          },
                                          "timestamp": "2018-11-13T12:00:06.000Z",
                                          "traffic": {
                                              "decision": "Allowed",
                                              "flow": "Outbound"
                                          }
                                      }
                                  ]
                              }
                          ],
                          "rule": "DefaultRule_AllowInternetOutBound"
                      }
                  ],
                  "version": "2"
              },
              "resource_id": "/SUBSCRIPTIONS/00000000-0000-0000-0000-000000000000/RESOURCEGROUPS/FABRIKAMRG/PROVIDERS/MICROSOFT.NETWORK/NETWORKSECURITYGROUPS/FABRIAKMVM1-NSG",
              "system_id": "a0fca5ce-022c-47b1-9735-89943b42f2fa",
              "time": "2018-11-13T12:00:35.389Z"
          }
      },
      "cloud": {
          "provider": "azure"
      },
      "data_stream": {
          "dataset": "azure_network_watcher_nsg.log",
          "namespace": "ep",
          "type": "logs"
      },
      "destination": {
          "bytes": [
              66,
              7054,
              14008
          ],
          "ip": [
              "13.67.143.118",
              "13.67.143.117",
              "10.5.16.4",
              "40.71.12.225",
              "13.67.143.115"
          ],
          "packets": [
              1,
              12,
              24
          ],
          "port": [
              8088,
              443,
              59336
          ]
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7a02b789-2d3c-4e39-a804-6995ecfd6bc0",
          "snapshot": false,
          "version": "8.12.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "azure_network_watcher_nsg.log",
          "ingested": "2024-05-03T08:30:09Z",
          "kind": "event",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "azure-blob-storage"
      },
      "log": {
          "file": {
              "path": "http://elastic-package-service-azure-network-watcher-nsg-log-1:10000/devstoreaccount1/azure-container1/testblob"
          },
          "offset": 1
      },
      "network": {
          "direction": [
              "outbound",
              "inbound"
          ],
          "transport": [
              "udp",
              "tcp"
          ]
      },
      "related": {
          "ip": [
              "13.67.143.118",
              "13.67.143.117",
              "10.5.16.4",
              "40.71.12.225",
              "13.67.143.115",
              "176.119.4.10",
              "94.102.49.190",
              "167.99.86.8"
          ]
      },
      "rule": {
          "name": [
              "DefaultRule_DenyAllInBound",
              "DefaultRule_AllowInternetOutBound"
          ]
      },
      "source": {
          "bytes": [
              66,
              8489,
              16978
          ],
          "ip": [
              "176.119.4.10",
              "10.5.16.4",
              "94.102.49.190",
              "167.99.86.8"
          ],
          "mac": [
              "00-0D-3A-F8-78-56"
          ],
          "packets": [
              1,
              15,
              30
          ],
          "port": [
              59932,
              44931,
              59831,
              28746,
              56509,
              59929,
              48495
          ]
      },
      "tags": [
          "forwarded",
          "azure_network_watcher_nsg-log"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                        | Description                                                         | Type             |
  |------------------------------------------------------------------------------|---------------------------------------------------------------------|------------------|
  | @timestamp                                                                   | Event timestamp.                                                    | date             |
  | azure.resource.group                                                         | Resource group.                                                     | keyword          |
  | azure.resource.id                                                            | Resource ID.                                                        | keyword          |
  | azure.resource.name                                                          | Name.                                                               | keyword          |
  | azure.resource.provider                                                      | Resource type/namespace.                                            | keyword          |
  | azure.storage.blob.content_type                                              | The content type of the Azure Blob Storage blob object.             | keyword          |
  | azure.storage.blob.name                                                      | The name of the Azure Blob Storage blob object.                     | keyword          |
  | azure.storage.container.name                                                 | The name of the Azure Blob Storage container.                       | keyword          |
  | azure.subscription_id                                                        | Azure subscription ID.                                              | keyword          |
  | azure_network_watcher_nsg.log.category                                       | Category of the event.                                              | keyword          |
  | azure_network_watcher_nsg.log.operation_name                                 | Always NetworkSecurityGroupFlowEvents.                              | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.flows.mac                     | MAC address of the network interface on which the flows are listed. | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.bytes.received   | Total number of TCP packet bytes sent from destination to source.   | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.bytes.sent       | Total number of TCP packet bytes sent from source to destination.   | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.destination.ip   | Destination IP address.                                             | ip               |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.destination.port | Destination port.                                                   | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.flow_state       | State of the flow.                                                  | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.packets.received | Total number of TCP packets sent from destination to source.        | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.packets.sent     | Total number of TCP packets sent from source to destination.        | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.protocol         | Protocol of the flow.                                               | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.source.ip        | Source IP address.                                                  | ip               |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.source.port      | Source port.                                                        | long             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.timestamp        | Time stamp of when the flow occurred in UNIX epoch format.          | date             |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.traffic.decision | Whether traffic was allowed or denied.                              | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.flows.tuples.traffic.flow     | Direction of the traffic flow.                                      | keyword          |
  | azure_network_watcher_nsg.log.properties.flows.rule                          | Rule for which the flows are listed.                                | keyword          |
  | azure_network_watcher_nsg.log.properties.version                             | Version number of the flow log's event schema.                      | keyword          |
  | azure_network_watcher_nsg.log.resource_id                                    | Resource ID of the network security group.                          | keyword          |
  | azure_network_watcher_nsg.log.system_id                                      | System ID of the network security group.                            | keyword          |
  | azure_network_watcher_nsg.log.time                                           | Time in UTC when the event was logged.                              | date             |
  | data_stream.dataset                                                          | Data stream dataset.                                                | constant_keyword |
  | data_stream.namespace                                                        | Data stream namespace.                                              | constant_keyword |
  | data_stream.type                                                             | Data stream type.                                                   | constant_keyword |
  | event.dataset                                                                | Event dataset.                                                      | constant_keyword |
  | event.module                                                                 | Event module.                                                       | constant_keyword |
  | input.type                                                                   | Type of Filebeat input.                                             | keyword          |
  | log.offset                                                                   | Log offset.                                                         | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Azure Network Watcher NSG Overview Dashboard](https://epr.elastic.co/package/azure_network_watcher_nsg/1.5.0/img/azure-network-watch-nsg-log-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                             | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14396))Add RBAC based authentication for azure blob storage input.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14396))Update the Kibana Version to 8.16.0 to support RABC based authentication for azure blob storage input. | 9.0.08.16.0            |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13573))Remove redundant installation instructions.                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                                                         | 8.13.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                  | 8.13.0                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11210))Release package as GA.                                                                                                                                                                                                                                     | 8.13.0                 |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                   |                        |
  | **0.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10182))Remove reference to a Kibana version from the README.                                                                                                                                                                                                          |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                               |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9652))Initial release.                                                                                                                                                                                                                                            |                        |
</dropdown>