﻿---
title: Azure Frontdoor Logs Integration
description: Azure Front Door provides different logging to help you track, monitor, and debug your Front Door. Access logs have detailed information about every request...
url: https://www.elastic.co/docs/reference/integrations/azure_frontdoor
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Azure Frontdoor Logs Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.2.2 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | Azure Event Hub                |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

Azure Front Door provides different logging to help you track, monitor, and debug your Front Door.
- Access logs have detailed information about every request that AFD receives and help you analyze and monitor access patterns, and debug issues.
- Activity logs provide visibility into the operations done on Azure resources.
- Health Probe logs provides the logs for every failed probe to your origin.
- Web Application Firewall (WAF) logs provide detailed information of requests that gets logged through either detection or prevention mode of an Azure Front Door endpoint. A custom domain that gets configured with WAF can also be viewed through these logs.

The Azure Frontdoor logs integration retrieves the following types of log data from AFD:
- **Access Logs**: Logs categorized as `FrontDoorAccessLog`.
- **Web Application Firewall (WAF) Logs**: Logs categorized as `FrontDoorWebApplicationFirewallLog`.

Currently, the integration does not support **Activity Logs** or **Health Probe logs**.

## Data streams

This integration collects two types of data streams:
- access log
- waf logs


## Requirements


### Credentials

`eventhub` :
*string*
Is the fully managed, real-time data ingestion service.
`consumer_group` :
*string*
The publish/subscribe mechanism of Event Hubs is enabled through consumer groups. A consumer group is a view (state, position, or offset) of an entire event hub. Consumer groups enable multiple consuming applications to each have a separate view of the event stream, and to read the stream independently at their own pace and with their own offsets.
Default value: `$Default`
`connection_string` :
*string*
The connection string required to communicate with Event Hubs, steps here .
A Blob Storage account is required in order to store/retrieve/update the offset or state of the eventhub messages. This means that after stopping the filebeat azure module it can start back up at the spot that it stopped processing messages.
`storage_account` :
*string*
The name of the storage account the state/offsets will be stored and updated.
`storage_account_key` :
*string*
The storage account key, this key will be used to authorize access to data in your storage account.
`resource_manager_endpoint` :
*string*
Optional, by default we are using the azure public environment, to override, users can provide a specific resource manager endpoint in order to use a different azure environment.
Ex:
 for azure ChinaCloud
 for azure GermanCloud
 for azure PublicCloud
 for azure USGovernmentCloud
Users can also use this in case of a Hybrid Cloud model, where one may define their own endpoints.

## Acceess Logs

<dropdown title="Exported fields">
  | Field                                                                        | Description                                                                                                                                                                                                                            | Type             |
  |------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                   | Event timestamp.                                                                                                                                                                                                                       | date             |
  | azure.frontdoor.access.backend_hostname                                      | The host name in the request from client. If you enable custom domains and have wildcard domain (*.contoso.com), hostname is a.contoso.com. if you use Azure Front Door domain (contoso.azurefd.net), hostname is contoso.azurefd.net. | keyword          |
  | azure.frontdoor.access.cache_status                                          | Provides the status code of how the request gets handled by the CDN service when it comes to caching.                                                                                                                                  | keyword          |
  | azure.frontdoor.access.error_info                                            | This field provides detailed info of the error token for each response.                                                                                                                                                                | keyword          |
  | azure.frontdoor.access.identity.authorization.action                         | Action                                                                                                                                                                                                                                 | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.principal_id          | Principal ID                                                                                                                                                                                                                           | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.principal_type        | Principal type                                                                                                                                                                                                                         | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.role                  | Role                                                                                                                                                                                                                                   | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.role_assignment_id    | Role assignment ID                                                                                                                                                                                                                     | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.role_assignment_scope | Role assignment scope                                                                                                                                                                                                                  | keyword          |
  | azure.frontdoor.access.identity.authorization.evidence.role_definition_id    | Role definition ID                                                                                                                                                                                                                     | keyword          |
  | azure.frontdoor.access.identity.authorization.scope                          | Scope                                                                                                                                                                                                                                  | keyword          |
  | azure.frontdoor.access.identity.claims.*                                     | Claims                                                                                                                                                                                                                                 | object           |
  | azure.frontdoor.access.identity.claims_initiated_by_user.fullname            | Fullname                                                                                                                                                                                                                               | keyword          |
  | azure.frontdoor.access.identity.claims_initiated_by_user.givenname           | Givenname                                                                                                                                                                                                                              | keyword          |
  | azure.frontdoor.access.identity.claims_initiated_by_user.name                | Name                                                                                                                                                                                                                                   | keyword          |
  | azure.frontdoor.access.identity.claims_initiated_by_user.schema              | Schema                                                                                                                                                                                                                                 | keyword          |
  | azure.frontdoor.access.identity.claims_initiated_by_user.surname             | Surname                                                                                                                                                                                                                                | keyword          |
  | azure.frontdoor.access.identity_name                                         | identity name                                                                                                                                                                                                                          | keyword          |
  | azure.frontdoor.access.is_received_from_client                               | Boolean value.                                                                                                                                                                                                                         | boolean          |
  | azure.frontdoor.access.pop                                                   | The edge pop, which responded to the user request.                                                                                                                                                                                     | keyword          |
  | azure.frontdoor.access.routing_rule_name                                     | The name of the route that the request matched.                                                                                                                                                                                        | keyword          |
  | azure.frontdoor.access.rules_engine_match_names                              | The names of the rules that were processed.                                                                                                                                                                                            | keyword          |
  | azure.frontdoor.access.time_taken                                            | The length of time from the time AFD edge server receives a client's request to the time that AFD sends the last byte of response to client, in milliseconds. This field doesn't take into account network latency and TCP buffering.  | double           |
  | azure.frontdoor.access.time_to_first_byte                                    | The length of time in milliseconds from AFD receives the request to the time the first byte gets sent to client, as measured on Azure Front Door. This property doesn't measure the client data.                                       | double           |
  | azure.frontdoor.category                                                     | Azure frontdoor category name.                                                                                                                                                                                                         | keyword          |
  | azure.frontdoor.operation_name                                               | Azure operation name.                                                                                                                                                                                                                  | keyword          |
  | azure.frontdoor.resource_id                                                  | Azure Resource ID.                                                                                                                                                                                                                     | keyword          |
  | azure.frontdoor.tracking_reference                                           | The unique reference string that identifies a request served by AFD, also sent as X-Azure-Ref header to the client. Required for searching details in the access logs for a specific request.                                          | keyword          |
  | cloud.image.id                                                               | Image ID for the cloud instance.                                                                                                                                                                                                       | keyword          |
  | data_stream.dataset                                                          | Data stream dataset.                                                                                                                                                                                                                   | constant_keyword |
  | data_stream.namespace                                                        | Data stream namespace.                                                                                                                                                                                                                 | constant_keyword |
  | data_stream.type                                                             | Data stream type.                                                                                                                                                                                                                      | constant_keyword |
  | host.containerized                                                           | If the host is a container.                                                                                                                                                                                                            | boolean          |
  | host.os.build                                                                | OS build information.                                                                                                                                                                                                                  | keyword          |
  | host.os.codename                                                             | OS codename, if any.                                                                                                                                                                                                                   | keyword          |
  | input.type                                                                   | Input type.                                                                                                                                                                                                                            | keyword          |
  | log.offset                                                                   | Log offset.                                                                                                                                                                                                                            | long             |
</dropdown>


## WAF Logs

<dropdown title="Exported fields">
  | Field                                                                     | Description                                                                                                                                                                                   | Type             |
  |---------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                | Event timestamp.                                                                                                                                                                              | date             |
  | azure.frontdoor.category                                                  | Azure frontdoor category name.                                                                                                                                                                | keyword          |
  | azure.frontdoor.operation_name                                            | Azure operation name.                                                                                                                                                                         | keyword          |
  | azure.frontdoor.resource_id                                               | Azure Resource ID.                                                                                                                                                                            | keyword          |
  | azure.frontdoor.tracking_reference                                        | The unique reference string that identifies a request served by AFD, also sent as X-Azure-Ref header to the client. Required for searching details in the access logs for a specific request. | keyword          |
  | azure.frontdoor.waf.details.data                                          | Detail data.                                                                                                                                                                                  | keyword          |
  | azure.frontdoor.waf.details.msg                                           | Detail msg.                                                                                                                                                                                   | keyword          |
  | azure.frontdoor.waf.identity.authorization.action                         | Action                                                                                                                                                                                        | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.principal_id          | Principal ID                                                                                                                                                                                  | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.principal_type        | Principal type                                                                                                                                                                                | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.role                  | Role                                                                                                                                                                                          | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.role_assignment_id    | Role assignment ID                                                                                                                                                                            | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.role_assignment_scope | Role assignment scope                                                                                                                                                                         | keyword          |
  | azure.frontdoor.waf.identity.authorization.evidence.role_definition_id    | Role definition ID                                                                                                                                                                            | keyword          |
  | azure.frontdoor.waf.identity.authorization.scope                          | Scope                                                                                                                                                                                         | keyword          |
  | azure.frontdoor.waf.identity.claims.*                                     | Claims                                                                                                                                                                                        | object           |
  | azure.frontdoor.waf.identity.claims_initiated_by_user.fullname            | Fullname                                                                                                                                                                                      | keyword          |
  | azure.frontdoor.waf.identity.claims_initiated_by_user.givenname           | Givenname                                                                                                                                                                                     | keyword          |
  | azure.frontdoor.waf.identity.claims_initiated_by_user.name                | Name                                                                                                                                                                                          | keyword          |
  | azure.frontdoor.waf.identity.claims_initiated_by_user.schema              | Schema                                                                                                                                                                                        | keyword          |
  | azure.frontdoor.waf.identity.claims_initiated_by_user.surname             | Surname                                                                                                                                                                                       | keyword          |
  | azure.frontdoor.waf.identity_name                                         | identity name                                                                                                                                                                                 | keyword          |
  | azure.frontdoor.waf.policy                                                | WAF policy name.                                                                                                                                                                              | keyword          |
  | azure.frontdoor.waf.policy_mode                                           | WAF policy mode.                                                                                                                                                                              | keyword          |
  | cloud.image.id                                                            | Image ID for the cloud instance.                                                                                                                                                              | keyword          |
  | data_stream.dataset                                                       | Data stream dataset.                                                                                                                                                                          | constant_keyword |
  | data_stream.namespace                                                     | Data stream namespace.                                                                                                                                                                        | constant_keyword |
  | data_stream.type                                                          | Data stream type.                                                                                                                                                                             | constant_keyword |
  | host.containerized                                                        | If the host is a container.                                                                                                                                                                   | boolean          |
  | host.os.build                                                             | OS build information.                                                                                                                                                                         | keyword          |
  | host.os.codename                                                          | OS codename, if any.                                                                                                                                                                          | keyword          |
  | input.type                                                                | Input type.                                                                                                                                                                                   | keyword          |
  | log.offset                                                                | Log offset.                                                                                                                                                                                   | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Azure Frontdoor Overview](https://epr.elastic.co/package/azure_frontdoor/2.2.2/img/azure-frontdoor-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15514))Fix processing of events with "N/A" values.                                                                                                             | 9.0.08.13.0            |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13727))Update README to provide clearer information on supported log types.                                                                                    | 9.0.08.13.0            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **2.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                               | 8.13.0                 |
  | **2.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12151))Add `storage_account_container` variables.                                                                                                              | 8.13.0                 |
  | **2.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12148))Change connection_string to be a secret                                                                                                                 | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **2.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/11272))Changed keyword field type to double in time_to_first_byte, time_taken fields and to date in time fields                                        | 8.13.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                            | 8.13.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10689))Add new field identity.                                                                                                                             | 8.13.0                 |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                      | 8.12.0                 |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.6.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.6.0                  |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7464))Fix Preserve Original Event for both Access and WAF data streams                                                                                         | 8.6.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                          | 8.6.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.6.0                  |
  | **1.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7965))Removing unused ECS field declarations.                                                                                                                  | 8.6.0                  |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7953))Add null checks and ignore_missing checks to the rename processor                                                                                        | 8.6.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                       | 8.6.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.6.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                         | 8.6.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6800))Release Azure Frontdoor as GA.                                                                                                                       | 8.6.0                  |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                              |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                         |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package to ECS 8.7.0.                                                                                                                         |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         |                        |
  | **0.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5329))Modify default storage container name to avoid collisions                                                                                                |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2497))Initial draft of the package                                                                                                                         |                        |
</dropdown>