﻿---
title: Azure Application State Integration
description: The Application State Integration allows users to retrieve application insights state related metrics from specified applications. Application ID:: ([]string)...
url: https://www.elastic.co/docs/reference/integrations/azure_application_insights/app_state
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Azure Application State Integration
|                                                                            |                                |
|----------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                | 1.9.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                          |
| **Ingestion method(s)**                                                    | API                            |
| **Minimum Kibana version(s)**                                              | 9.0.08.13.0                    |

The Application State Integration allows users to retrieve application insights state related metrics from specified applications.

### Integration level configuration options

`Application ID`:: (*[]string*) ID of the application. This is Application ID from the API Access settings blade in the Azure portal.
`Api Key`:: (*[]string*) The API key which will be generated, more on the steps here .

## Additional notes about metrics and costs

Costs: Metric queries are charged based on the number of standard API calls. More information on pricing here .
<dropdown title="Exported fields">
  | Field                                                                 | Description                                                                                | Type             | Metric Type |
  |-----------------------------------------------------------------------|--------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                                                            | Event timestamp.                                                                           | date             |             |
  | agent.id                                                              | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword          |             |
  | azure.app_state.browser_timings_network_duration.avg                  | Browser timings network duration                                                           | float            | gauge       |
  | azure.app_state.browser_timings_processing_duration.avg               | Browser timings processing duration                                                        | float            | gauge       |
  | azure.app_state.browser_timings_receive_duration.avg                  | Browser timings receive duration                                                           | float            | gauge       |
  | azure.app_state.browser_timings_send_duration.avg                     | Browser timings send duration                                                              | float            | gauge       |
  | azure.app_state.browser_timings_total_duration.avg                    | Browser timings total duration                                                             | float            | gauge       |
  | azure.app_state.end_date                                              | The end date                                                                               | date             |             |
  | azure.app_state.exceptions_browser.sum                                | Exception count at browser level                                                           | float            | gauge       |
  | azure.app_state.exceptions_count.sum                                  | Exception count                                                                            | float            | gauge       |
  | azure.app_state.exceptions_server.sum                                 | Exception count at server level                                                            | float            | gauge       |
  | azure.app_state.performance_counters_memory_available_bytes.avg       | Performance counters memory available bytes                                                | float            | gauge       |
  | azure.app_state.performance_counters_process_cpu_percentage.avg       | Performance counters process cpu percentage                                                | float            | gauge       |
  | azure.app_state.performance_counters_process_cpu_percentage_total.avg | Performance counters process cpu percentage total                                          | float            | gauge       |
  | azure.app_state.performance_counters_process_private_bytes.avg        | Performance counters process private bytes                                                 | float            | gauge       |
  | azure.app_state.performance_counters_processiobytes_per_second.avg    | Performance counters process IO bytes per second                                           | float            | gauge       |
  | azure.app_state.requests_count.sum                                    | Request count                                                                              | float            | gauge       |
  | azure.app_state.requests_failed.sum                                   | Request failed count                                                                       | float            | gauge       |
  | azure.app_state.sessions_count.unique                                 | Session count                                                                              | float            | gauge       |
  | azure.app_state.start_date                                            | The start date                                                                             | date             |             |
  | azure.app_state.users_authenticated.unique                            | Authenticated users count                                                                  | float            | gauge       |
  | azure.app_state.users_count.unique                                    | User count                                                                                 | float            | gauge       |
  | azure.application_id                                                  | The application ID                                                                         | keyword          |             |
  | azure.dimensions.browser_timing_url_host                              | The host part of the URL that the browser was accessing when timings were captured.        | keyword          |             |
  | azure.dimensions.browser_timing_url_path                              | The path part of the URL that the browser was accessing when timings were captured.        | keyword          |             |
  | azure.dimensions.cloud_role_instance                                  | The unique identifier of the cloud instance where the application is running.              | keyword          |             |
  | azure.dimensions.cloud_role_name                                      | The name of the role that the cloud instance is performing.                                | keyword          |             |
  | azure.dimensions.exception_type                                       | The type of exception that was thrown.                                                     | keyword          |             |
  | azure.dimensions.request_name                                         | The name of the request that was made.                                                     | keyword          |             |
  | azure.dimensions.request_url_host                                     | The host part of the URL that was requested.                                               | keyword          |             |
  | azure.namespace                                                       | The namespace selected                                                                     | keyword          |             |
  | azure.resource.group                                                  | The resource group                                                                         | keyword          |             |
  | azure.resource.id                                                     | The id of the resource                                                                     | keyword          |             |
  | azure.resource.name                                                   | The name of the resource                                                                   | keyword          |             |
  | azure.resource.tags                                                   | Azure resource tags.                                                                       | flattened        |             |
  | azure.resource.type                                                   | The type of the resource                                                                   | keyword          |             |
  | azure.subscription_id                                                 | The subscription ID                                                                        | keyword          |             |
  | azure.timegrain                                                       | The Azure metric timegrain                                                                 | keyword          |             |
  | cloud.image.id                                                        | Image ID for the cloud instance.                                                           | keyword          |             |
  | cloud.region                                                          | Region in which this host is running.                                                      | keyword          |             |
  | data_stream.dataset                                                   | Data stream dataset name.                                                                  | constant_keyword |             |
  | data_stream.namespace                                                 | Data stream namespace.                                                                     | constant_keyword |             |
  | data_stream.type                                                      | Data stream type.                                                                          | constant_keyword |             |
  | dataset.name                                                          | Dataset name.                                                                              | constant_keyword |             |
  | dataset.namespace                                                     | Dataset namespace.                                                                         | constant_keyword |             |
  | dataset.type                                                          | Dataset type.                                                                              | constant_keyword |             |
  | host.containerized                                                    | If the host is a container.                                                                | boolean          |             |
  | host.os.build                                                         | OS build information.                                                                      | keyword          |             |
  | host.os.codename                                                      | OS codename, if any.                                                                       | keyword          |             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![App State Overview](https://epr.elastic.co/package/azure_application_insights/1.9.1/img/azure_app_insights_app_state-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.9.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15397))Fix the H1 for SEO purpose.                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.13.0            |
  | **1.9.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14769))Add a flag `fips_compatible` to control whether the package is allowed in the ECH FedRAMP High environment.                                                                                                                                                                                                                                                                                                                               | 9.0.08.13.0            |
  | **1.8.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12475))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.13.0            |
  | **1.7.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **1.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10409))Add processor support for app_insights and app_state data streams.                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10162))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9995))Add global filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                 |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9009))Enable 'secret' for the sensitive fields.                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8648))Enable time series data for metrics data streams. This dramatically reduces storage for metrics and is expected to progressively improve query [performance](https://www.elastic.co/blog/70-percent-storage-savings-for-metrics-with-elastic-observability). For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html). | 8.12.0                 |
  | **1.2.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8454))Rename the app insights dimensions fingerprint field to prevent it from being nested within azure.dimensions.                                                                                                                                                                                                                                                                                                                                  | 8.9.0                  |
  | **1.2.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8379))Migrate App State Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                  |
  | **1.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7550))Add dimension and metric_type mappings to the app_state datastream                                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                  |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8041))Update the package format_version to 3.0.0.                                                                                                                                                                                                                                                                                                                                                                                                | 8.9.0                  |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7610))Add app_insights dimensions and metric_type for metrics field.                                                                                                                                                                                                                                                                                                                                                                             | 8.9.0                  |
  | **1.0.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6975))Fix mappings of tags and dimensions                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.14.0            |
  | **1.0.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.14.0            |
  | **1.0.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4754))Fix misspelled field name in the app_state data stream.                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.14.0            |
  | **1.0.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3075))Updated Readme                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.0.07.14.0            |
  | **1.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **1.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2547))Remove beta release tag from data streams                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.14.0            |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2528))Move azure_application_insights package to GA                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.14.0            |
  | **0.3.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2480))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2211))Support Kibana 8.0                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2010))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1689))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/632))initial release                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
</dropdown>