﻿---
title: Azure Platform Logs
description: Platform logs provide detailed diagnostic and auditing information for Azure resources and the Azure platform they depend on. Refer to the Azure Logs...
url: https://www.elastic.co/docs/reference/integrations/azure/platformlogs
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Azure Platform Logs
|                                                                            |                                 |
|----------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                | 1.35.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                           |
| **Ingestion method(s)**                                                    | Azure Event Hub                 |
| **Minimum Kibana version(s)**                                              | 9.2.49.1.108.19.10              |

Platform logs provide detailed diagnostic and auditing information for Azure resources and the Azure platform they depend on.

## Requirements and setup

Refer to the [Azure Logs](https://docs.elastic.co/integrations/azure) page for more information about setting up and using this integration.

## Settings

`eventhub` :
*string*
It is a fully managed, real-time data ingestion service. Elastic recommends using only letters, numbers, and the hyphen (-) character for Event Hub names to maximize compatibility. You can use existing Event Hubs having underscores (_) in the Event Hub name; in this case, the integration will replace underscores with hyphens (-) when it uses the Event Hub name to create dependent Azure resources behind the scenes (e.g., the storage account container to store Event Hub consumer offsets). Elastic also recommends using a separate event hub for each log type as the field mappings of each log type differ.
Default value `insights-operational-logs`.
`consumer_group` :
*string*
The publish/subscribe mechanism of Event Hubs is enabled through consumer groups. A consumer group is a view (state, position, or offset) of an entire event hub. Consumer groups enable multiple consuming applications to each have a separate view of the event stream, and to read the stream independently at their own pace and with their own offsets.
Default value: `$Default`
`connection_string` :
*string*
The connection string required to communicate with Event Hubs, steps here .
A Blob Storage account is required in order to store/retrieve/update the offset or state of the eventhub messages. This means that after stopping the filebeat azure module it can start back up at the spot that it stopped processing messages.
`storage_account` :
*string*
The name of the storage account the state/offsets will be stored and updated.
`storage_account_key` :
*string*
The storage account key, this key will be used to authorize access to data in your storage account.
`storage_account_container` :
*string*
The storage account container where the integration stores the checkpoint data for the consumer group. It is an advanced option to use with extreme care. You MUST use a dedicated storage account container for each Azure log type (activity, sign-in, audit logs, and others). DO NOT REUSE the same container name for more than one Azure log type. See [Container Names](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#container-names) for details on naming rules from Microsoft. The integration generates a default container name if not specified.
`resource_manager_endpoint` :
*string*
Optional, by default we are using the azure public environment, to override, users can provide a specific resource manager endpoint in order to use a different azure environment.
Resource manager endpoints:
```text
# Azure ChinaCloud
https://management.chinacloudapi.cn/

# Azure GermanCloud
https://management.microsoftazure.de/

# Azure PublicCloud 
https://management.azure.com/

# Azure USGovernmentCloud
https://management.usgovcloudapi.net/
```


## Logs


### platformlogs

The `platformlogs` dataset of the Azure Logs package will collect any platform events that have been streamed through an azure event hub.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-11-05T14:07:32.000Z",
      "agent": {
          "ephemeral_id": "d3c4d56c-e7c7-489e-9d25-683452d16ec9",
          "hostname": "DESKTOP-RFOOE09",
          "id": "c1118415-bcb7-4cf9-b64d-a6c6e8ebcfac",
          "name": "DESKTOP-RFOOE09",
          "type": "filebeat",
          "version": "7.10.0"
      },
      "azure": {
          "platformlogs": {
              "ActivityId": "5890c6fc-fc6b-47cd-971a-2366a1641d99",
              "Caller": "Portal",
              "Environment": "PROD",
              "EventTimeString": "11/5/2020 2:07:32 PM +00:00",
              "ScaleUnit": "PROD-AM3-AZ501",
              "category": "OperationalLogs",
              "event_category": "Administrative",
              "properties": {
                  "Namespace": "obstesteventhubs",
                  "SubscriptionId": "7657426d-c4c3-44ac-88a2-3b2cd59e6dba",
                  "TrackingId": "5890c6fc-fc6b-47cd-971a-2366a1641d99_M8CH3_M8CH3_G8S3",
                  "Via": "https://obstesteventhubs.servicebus.windows.net/$Resources/eventhubs?api-version=2017-04&$skip=0&$top=100"
              }
          },
          "resource": {
              "group": "OBS-TEST",
              "id": "/SUBSCRIPTIONS/7657426D-C4C3-44AC-88A2-3B2CD59E6DBA/RESOURCEGROUPS/OBS-TEST/PROVIDERS/MICROSOFT.EVENTHUB/NAMESPACES/OBSTESTEVENTHUBS",
              "name": "OBSTESTEVENTHUBS",
              "provider": "MICROSOFT.EVENTHUB/NAMESPACES"
          },
          "subscription_id": "7657426D-C4C3-44AC-88A2-3B2CD59E6DBA"
      },
      "cloud": {
          "provider": "azure",
          "region": "West Europe"
      },
      "data_stream": {
          "dataset": "azure.platformlogs",
          "namespace": "default",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "02f4e39d-8a1b-4506-a531-b45d0f492ee7",
          "snapshot": false,
          "version": "7.10.0"
      },
      "event": {
          "action": "Retreive Namespace",
          "dataset": "azure.platformlogs",
          "ingested": "2020-11-01T12:02:34.237205200Z",
          "kind": "event",
          "outcome": "success"
      },
      "host": {
          "name": "DESKTOP-RFOOE09"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                    | Description                                                                                                                                                                                                                                         | Type             |
  |------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                               | Event timestamp.                                                                                                                                                                                                                                    | date             |
  | azure.correlation_id                     | Correlation ID                                                                                                                                                                                                                                      | keyword          |
  | azure.platformlogs.ActivityId            | ActivityId                                                                                                                                                                                                                                          | keyword          |
  | azure.platformlogs.Caller                | Caller                                                                                                                                                                                                                                              | keyword          |
  | azure.platformlogs.Cloud                 | Cloud                                                                                                                                                                                                                                               | keyword          |
  | azure.platformlogs.Environment           | Environment                                                                                                                                                                                                                                         | keyword          |
  | azure.platformlogs.EventPrimaryStampName | The primary stamp name for the event                                                                                                                                                                                                                | keyword          |
  | azure.platformlogs.EventStampName        | The stamp name for the event                                                                                                                                                                                                                        | keyword          |
  | azure.platformlogs.EventStampType        | The stamp type for the event                                                                                                                                                                                                                        | keyword          |
  | azure.platformlogs.EventTimeString       | EventTimeString                                                                                                                                                                                                                                     | keyword          |
  | azure.platformlogs.ScaleUnit             | ScaleUnit                                                                                                                                                                                                                                           | keyword          |
  | azure.platformlogs.category              | Category                                                                                                                                                                                                                                            | keyword          |
  | azure.platformlogs.ccpNamespace          | ccpNamespace                                                                                                                                                                                                                                        | keyword          |
  | azure.platformlogs.event_category        | Event Category                                                                                                                                                                                                                                      | keyword          |
  | azure.platformlogs.identity_name         | Identity name                                                                                                                                                                                                                                       | keyword          |
  | azure.platformlogs.operation_name        | Operation name                                                                                                                                                                                                                                      | keyword          |
  | azure.platformlogs.properties            | Event properties                                                                                                                                                                                                                                    | flattened        |
  | azure.platformlogs.result_description    | Result description                                                                                                                                                                                                                                  | keyword          |
  | azure.platformlogs.result_signature      | Result signature                                                                                                                                                                                                                                    | keyword          |
  | azure.platformlogs.result_type           | Result type                                                                                                                                                                                                                                         | keyword          |
  | azure.platformlogs.status                | Status                                                                                                                                                                                                                                              | keyword          |
  | azure.resource.authorization_rule        | Authorization rule                                                                                                                                                                                                                                  | keyword          |
  | azure.resource.group                     | Resource group                                                                                                                                                                                                                                      | keyword          |
  | azure.resource.id                        | Resource ID                                                                                                                                                                                                                                         | keyword          |
  | azure.resource.name                      | Name                                                                                                                                                                                                                                                | keyword          |
  | azure.resource.namespace                 | Resource type/namespace                                                                                                                                                                                                                             | keyword          |
  | azure.resource.provider                  | Resource type/namespace                                                                                                                                                                                                                             | keyword          |
  | azure.subscription_id                    | Azure subscription ID                                                                                                                                                                                                                               | keyword          |
  | azure.tenant_id                          | tenant ID                                                                                                                                                                                                                                           | keyword          |
  | azure_log_forwarder.category             | Azure log category                                                                                                                                                                                                                                  | keyword          |
  | azure_log_forwarder.resource_type        | Azure resource type                                                                                                                                                                                                                                 | keyword          |
  | azure_log_forwarder.service_provider     | Azure service provider                                                                                                                                                                                                                              | keyword          |
  | cloud.image.id                           | Image ID for the cloud instance.                                                                                                                                                                                                                    | keyword          |
  | data_stream.dataset                      | Data stream dataset name.                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.namespace                    | Data stream namespace.                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.type                         | Data stream type.                                                                                                                                                                                                                                   | constant_keyword |
  | event.dataset                            | Event dataset                                                                                                                                                                                                                                       | constant_keyword |
  | event.module                             | Event module                                                                                                                                                                                                                                        | constant_keyword |
  | geo.city_name                            | City name.                                                                                                                                                                                                                                          | keyword          |
  | geo.continent_name                       | Name of the continent.                                                                                                                                                                                                                              | keyword          |
  | geo.country_iso_code                     | Country ISO code.                                                                                                                                                                                                                                   | keyword          |
  | geo.country_name                         | Country name.                                                                                                                                                                                                                                       | keyword          |
  | geo.location                             | Longitude and latitude.                                                                                                                                                                                                                             | geo_point        |
  | geo.name                                 | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword          |
  | host.containerized                       | If the host is a container.                                                                                                                                                                                                                         | boolean          |
  | host.os.build                            | OS build information.                                                                                                                                                                                                                               | keyword          |
  | host.os.codename                         | OS codename, if any.                                                                                                                                                                                                                                | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![filebeat azure overview](https://epr.elastic.co/package/azure/1.35.1/img/filebeat-azure-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.35.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17027))Fix pipeline error when the `category` field is missing.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.49.1.108.19.10     |
  | **1.35.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16955))Add support for AMQP-over-WebSockets transport protocol and proxy configuration.                                                                                                                                                                                                                                                                                                                                                                                                        | 9.2.49.1.108.19.10     |
  | **1.34.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16674))Fix `durationMs` parsing in auditlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.34.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16618))Switch default processor version to v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16610))Support log event routing overrides in Azure Logs v2.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.15.1            |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15807))Update Events v2 routing of `signinlogs` and `springcloud` logs.                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16328))Expand date formats for parsing time fields: ISO8601, `M/d/yyyy h:mm:ss a XXX`, `M/d/yyyy h:mm:ss a`, `M/d/yyyy H:mm:ss`, `yyyy-MM-ddTH:mm:ss.SSSZ`.                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.0** | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16395))Remove `destination.ip` and `destination.port` mapping of `TranslatedIp` and `TranslatedPort`.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16395))Add `destination.ip` to `destination.address` and `source.ip` to `source.address`.Add `TranslatedIp` and `TranslatedPort` to `destination.nat.ip` and `destination.nat.port`.Update event type mappings for AZFWNetworkRule and AZFWApplicationRule categories in firewall_logs data stream. | 9.0.08.15.1            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15900))Add processor version options for the Raw Events (v1) integration.                                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15976))Update `time` formats parsing and fix `durationMs` parsing in signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.15.1            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15690))Parse responseBody and requestBody json in activitylogs.                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.7** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15205))Interim fix to support non-standard log events.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.28.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15203))Add FAQ section to Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.15.1            |
  | **1.28.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14986))Add support to override `Endpoint Suffix` based on deployment environment.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.15.1            |
  | **1.28.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14961))Workaround the invalid field names from Azure Native ISV                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.28.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14959))Handle invalid log events (empty fields and properties as string) from Azure services.                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.28.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14926))Fix Azure platformlogs ingest pipeline for function app logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14415))Support routing with invalid fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14068))Add a flag `fips_compatible` to control whether the package is allowed in the ECH FedRAMP High environment.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13920))Add missing pattern for DNAT request messages for `AzureFirewallNetworkRuleLog` in firewall_logs data stream.                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.15.1            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13922))Fix dashboard link.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.15.1            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14085))Standardize user fields for identity_protection and signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13921))Add Grok processor for `AzureFirewallThreatIntelLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13931))Set `service.id`, `device.id`, `user.id`, `session.id`, and `token.id` in graphactivitylogs dataset.                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.23.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13863))Improve Azure logs documentation with more details on log categories routing rules.                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13882))Fix Grok processor error in ingest pipeline for `AzureFirewallNetworkRuleLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13439))Map `azure.signinlogs.properties.location.state` field to `geo.region_name` instead of `geo.country_name`.                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.15.1            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12802))Enable Event Hub processor v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12735))Fix Platform Logs pipeline inconsistent casing for subscription_id field.                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12926))Fix the custom storage container description for the Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12641))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.20.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12233))Fix casting & naming issues in Graph Activity Logs related to the `event.duration` field.                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12047))Fix string literals in painless scripts.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11984))Add Azure Logs integration v2 (preview)                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.19.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11749))Fix destination.geo.region_name mapping.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.19.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11765))Rename the `Identity` field to `identity` for consistency.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.19.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11732))Rename the `properties` field to `properties.raw` to avoid parse errors when the `properties` field contains a string.                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11660))Fix an error and clarify the docs about the Storage Account container.                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11344))Add entity identifiers to `related.entity`.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10007))Add `event.reason` log field for exact data found in requests that matches a firewall rule.                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11102))Fix [client|source].geo.location ECS field mapping                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10984))Add new section on Azure Functions hosting plans.                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10379))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10583))Expand docs with more details on the Event Hub partitions configuration.                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9428))Add structured log categories to Azure Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10224))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/10224))Updated "event.outcome" values from "Succeeded" to "success" and "Failed" to "failure".                                                                                                                  | 8.13.0                 |
  | **1.11.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9774))Replace Azure AD with Microsoft Entra ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.12.0                 |
  | **1.11.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9701))Update Azure Audit Logs pipeline with support for initiated_by user fields.                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9738))Add missing ECS field definitions.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.11.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9258))Update description for event hub parameter name recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.12.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9554))Use ecs definition of the 'event.dataset' field for eventhub                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9314))Add Microsoft Graph Activity Logs                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.9.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9158))Add docs for running the integration behind a firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9159))Set field type to password on secret fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9022))Add support for integration secrets                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8813))Add caller_ip_address field in pipeline for Azure sign-in logs.                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.0                  |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8666))Update Azure logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8275))Update AD Logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.8.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8432))Allow rerouting of Azure logs events to a different data stream.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8192))Rebrand Azure Spring Cloud Logs to Azure Spring Apps                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8050))Update the package format_version to 3.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.33** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7995))Handle `json.properties.clientIp` as an alias of `json.properties.clientIP` in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.32** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7979))Fix mappings for `azure.activitylogs.claims.*`.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.31** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7376))Migration of Azure AD Identity Protection dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.30** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7375))Migration of Azure AD Provisioning Logs dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.6.0                  |
  | **1.5.29** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7525))Fix Azure dashboards descriptions and titles.                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.28** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Migration Alerts Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.27** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6960))Fix in Firewall dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                  |
  | **1.5.26** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6867))Handle duplicate user_agent.original field in signinlogs logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                  |
  | **1.5.25** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6866))Handle duplicate url.path field in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.24** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6824))Handle firewall events for DNAT'ed requests with attributes                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.23** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6624))Update Azure Logs screenshot                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.22** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6501))Migration of Azure Cloud Overview dashboard to Lens and style changes                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                  |
  | **1.5.21** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6503))Migration of User Activity Dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.20** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6357))Integration settings UI for sanitization                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                  |
  | **1.5.17** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6432))Migration of Spring Cloud Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.5.16** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6435))Migration of Azure Spring Cloud Logs Application Cloud Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.15** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6397))Migration of Spring Cloud System Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.14** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Enhancement/Improving performance of the dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.13** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5604))Extend the Storage Account container documentation and add link to requiements and setup instructions                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.12** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.5.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5382))Add a new message format to the AzureFirewallNetworkRule log category                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.10** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5361))Check for 'event.original' already existing in Application Gateway and Event Hub ingest pipelines                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.5.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5334))Check for 'event.original' already existing in firewall logs ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.5.8**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5290))Add `storage_account_container` option to the Application Gateway integration                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5129))Fix parsing of authentication_processing_details field in signin logs                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5073))Fix parsing error client port is blank and adjust for timeStamp                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4629))Rename identity as identity_name when the value is a string                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.5.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4476))Enable Event Hub integration by default and improve documentation                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4373))Data streams start as disabled on new installs                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4384))Fix PR link in changelog                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4382))Fix documentations formatting (remove extra 'Overview' heading)                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3892))Add Azure Application Gatewaty data stream                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4300))Update Azure Logs documentation                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4149))Add two new data streams to the Azure AD logs integration: Azure Identity Protection logs and Provisioning logs                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3877))Add the possibility to override the default generated storage account container                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3805))Update docs with recommended Event Hub configuration                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3679))Fix Azure Sign-in logs ingest pipeline bug                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3578))Support Azure firewall logs                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.1.11** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3639))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **1.1.10** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3072))Update readme with links to Microsoft documentation                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3411))Improve handling of IPv6 IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3209))Update docs with details about Event Hub name recommendations                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.1.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3211))Add geo.name and result_description fields in platformlogs                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.1.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Fix azure.activitylogs.identity with a a concrete value**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Add identity_name, tenant_id, level and operation_version into activity logs                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2891))Fix `event.duration` field mapping conflict in all Azure data streams.                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2822))Added the `forwarded` tag by default to all log types.                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Add device_detail.is_compliant and device_detail.is_managed fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Change authentication_requirement_policies to flattened type                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflict in the auditlogs data stream for `client.ip`. Changed `azure-eventhub.offset` and `azure-eventhub.sequence_number` to longs from keyword in the eventhub data stream.                                                                                                                                                                                                                                                                                             |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2682))Support new Azure audit logs and signin logs                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2547))Remove beta release tag from data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2528))Move azure package to GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **0.12.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2479))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.12.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2174))Release azure package for v8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1894))Add Azure Event Hub Input                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2005))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1721))signinlogs - Add support for ManagedIdentitySignInLogs, NonInteractiveUserSignInLogs, and ServicePrincipalSignInLogs.                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.9.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1870))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1798))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1688))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1644))Add ECS `client.ip` mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.8.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1542))Update docs and logo                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1466))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1521))Import geo_points from ECS                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1514))Update error message                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1462))Add support for springcloud logs inside the platformlogs pipeline                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1455))Import ECS field definitions                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1355))Add spring cloud logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1372))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1353))Re-add pipeline changes for invalid json                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1051))Add input groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1238))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1121))sync package with module changes                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1113))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/835))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/741))Add check for empty configuration options.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/722))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/272))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
</dropdown>