﻿---
title: Azure Logs Integration (v2 preview)
description: The Azure Logs integration (v2 preview) collects logs from selected Azure services, such as Microsoft Entra ID (Sign-in, Audit, Identity Protection, and...
url: https://www.elastic.co/docs/reference/integrations/azure/events
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Azure Logs Integration (v2 preview)
|                                                                            |                                 |
|----------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                | 1.35.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                           |
| **Ingestion method(s)**                                                    | Azure Event Hub                 |
| **Minimum Kibana version(s)**                                              | 9.2.49.1.108.19.10              |

The Azure Logs integration (v2 preview) collects logs from selected Azure services, such as Microsoft Entra ID (Sign-in, Audit, Identity Protection, and Provisioning logs), Azure Spring Apps, Azure Firewall, Microsoft Graph Activity, and several others.
You can then visualize that data in Kibana, create alerts if something goes wrong, and reference data when troubleshooting an issue.
For example, to detect possible brute force sign-in attacks, you can install the Azure Logs integration to send Azure sign-in logs to Elastic. Then, by setting up a new rule in the Elastic Observability Logs app, you can be alerted when the number of failed sign-in attempts exceeds a certain threshold.
You may also want to plan your Azure capacity better. Send Azure Activity logs to Elastic to track and visualize when your virtual machines fail to start because they exceed the quota limit.

## What's new in the integration v2 preview?

The Azure Logs integration v2 preview introduces:
- A new architecture that allows you to collect all logs through a single event hub.
- Significant efficiency improvements.
- A new event hub processor (v2) that incorporates the latest Event Hubs SDK.


### Architecture

The Azure Logs integration (v2 preview) introduces a new architecture that allows you to forward logs from multiple Azure services to the same event hub.
```text
                                                             ┌─────────────────┐
                                                             │  activity logs  │
                                                          ┌─▶│ <<data stream>> │
                                                          │  └─────────────────┘
                                                          │                     
┌───────────────┐   ┌─────────────┐  ┌─────────────────┐  │  ┌─────────────────┐
│     logs      │   │   Elastic   │  │ events (router) │  │  │  firewall logs  │
│ <<event hub>> │──▶│    Agent    │─▶│ <<data stream>> │──┼─▶│ <<data stream>> │
└───────────────┘   └─────────────┘  └─────────────────┘  │  └─────────────────┘
                                                          │                     
                                                          │  ┌─────────────────┐
                                                          │  │   signin logs   │
                                                          └─▶│ <<data stream>> │
                                                             └─────────────────┘
```

The integration will automatically detect the log category and forward the logs to the appropriate data stream. When the integration v2 preview cannot find a matching data stream for a log category, it forwards the logs to the platform logs data stream.
IMPORTANT: **To use the integration v2 preview, you must turn off all the existing v1 integrations and turn on only the v2 preview integration.**

### Efficiency

The integration v2 preview avoids contention and inefficiencies from using multiple consumers per partition with the same event hub, problems that are typical of the v1 architecture. With the v2 preview, you can still assign the agent policy to multiple Elastic Agents to scale out the logs processing.

### Event Hub Processor v2 ✨

As of version 1.23.0, the integration preview includes the new Processor v2.
Processor v2 introduces several key improvements:
- Built on the latest Azure Event Hubs SDK.
- Features a more efficient checkpoint store leveraging Azure Blob Storage metadata.

Processor v2 is the default and the recommended standard for all use cases. Processor v1 is being retained as a legacy option to ensure backward compatibility until the next major release.
For details on configuration, see the "Event Hub Processor v2 only" section in the integration settings.

### FAQ

Here are a few frequently asked questions about the integration v2 preview.

#### Question: Is the integration v2 production ready?

Yes, the integration v2 is production ready.
The integration v2 is marked with "preview" as we were testing this routing approach, and wanted to keep the option of changing course, if needed. Since the experiment was successful, we'll remove the "preview" from the name as we finalize the plans to transition from v1 to v2.

#### Question: Are all logs routed to the relevant data streams?

Yes, all known logs are routed to the data stream with the best parsing and mapping functionality available.
The `logs-azure.events-default` contains the routing logic based on the `category` field. The routing rules are available in the integrations repo at [packages/azure/data_stream/events/routing_rules.yml](https://github.com/elastic/integrations/blob/main/packages/azure/data_stream/events/routing_rules.yml).

#### Question: How are unsupported Azure logs handled?

The integration v2 inspects the category field to see if there's an integration available with full support. If there isn't a specific integration available, the routing falls back to `logs-azure.platformlogs-default` to apply the standard parsing and mapping.

#### Question: What is in the undocumented data-stream `logs-azure.events-default`?

The `logs-azure.events-default` data stream is the logs entry point for the integration v2. It contains the core logs routing logic.

## Data streams

The Azure Logs integration (v2 preview) collects logs.
**Logs** help you keep a record of events that happen on your Azure account.
Log data streams collected by the Azure Logs integration include Activity, Platform, Microsoft Entra ID (Sign-in, Audit, Identity Protection, Provisioning), Microsoft Graph Activity, and Spring Apps logs.

## Routing

The integration routes the logs to the most appropriate data stream based on the log category.
Use the following table to identify the target data streams for each log category. For example, if the integration receives a log event with the `NonInteractiveUserSignInLogs` category, it will infer `azure.signinlogs` as dataset, indexing the log into `logs-azure.signinlogs-default` data stream.

| Data Stream                        | Log Categories                                                                                                                                               |
|------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `logs-azure.activitylogs-*`        | `Administrative`, `Security`, `ServiceHealth`, `Alert`, `Recommendation`, `Policy`, `Autoscale`, `ResourceHealth`                                            |
| `logs-azure.application_gateway-*` | `ApplicationGatewayFirewallLog`, `ApplicationGatewayAccessLog`                                                                                               |
| `logs-azure.auditlogs-*`           | `AuditLogs`                                                                                                                                                  |
| `logs-azure.firewall_logs-*`       | `AzureFirewallApplicationRule`, `AzureFirewallNetworkRule`, `AzureFirewallDnsProxy`, `AZFWApplicationRule`, `AZFWNetworkRule`, `AZFWNatRule`, `AZFWDnsQuery` |
| `logs-azure.graphactivitylog-*`    | `MicrosoftGraphActivityLogs`                                                                                                                                 |
| `logs-azure.identity_protection-*` | `RiskyUsers`, `UserRiskEvents`                                                                                                                               |
| `logs-azure.provisioning-*`        | `ProvisioningLogs`                                                                                                                                           |
| `logs-azure.signinlogs-*`          | `*SignInLogs`                                                                                                                                                |
| `logs-azure.springcloudlogs-*`     | `ApplicationConsole`, `SystemLogs`, `IngressLogs`, `BuildLogs`, `ContainerEventLogs`                                                                         |
| `logs-azure.platformlogs-*`        | All other log categories                                                                                                                                     |


### Question: What about all other log categories?

The integration indexes all other Azure logs categories using the `logs-azure.platformlogs-*` data stream.

### Question: Can I route the log events to a different data stream?

Yes, you can route the log events to a different data stream by creating a `logs-azure.events@custom` pipeline.
The default pipeline extracts the `routing.category` field and hands it off to the custom pipeline, where you can implement your routing logic.
You can create this pipeline via the integration settings (**Change defaults > Advanced options > Ingest pipelines**) or alternatively using **Dev Tools**.
If you prefer using the Dev Tools, here is a sample configuration that routes the `SQLSecurityAuditEvents` category to a dedicated data stream.
First, check for an existing `logs-azure.events@custom` pipeline:
```text
GET _ingest/pipeline/logs-azure.events@custom
```

If a pipeline already exists, you will need to update it to include the reroute processor.
To define a new `logs-azure.events@custom` pipeline, use the following:
```text
PUT _ingest/pipeline/logs-azure.events@custom
{
  "processors": [
    {
      "reroute": {
        "if": "ctx?.routing?.category == \"SQLSecurityAuditEvents\"",
        "dataset": "azure.synapse"
      }
    }
  ]
}
```

You can target a new dataset (such as `azure.synapse` shown above) or any of the existing out-of-the-box datasets like `azure.activitylogs`.

## Requirements

You need Elasticsearch to store and search for your data and Kibana to visualize and manage it.
You can use our recommended hosted Elasticsearch Service on Elastic Cloud or self-manage the Elastic Stack on your hardware.
Before using the Azure integration, you will need:
- One or more **diagnostic settings** to export logs from Azure services to Event Hubs.
- One **event hub** to store in-flight logs exported by Azure services and make them available to Elastic Agent.
- One **Storage Account container** to store the event hub checkpointing information for each partition.


### Diagnostic settings

Azure diagnostic settings allow you to export metrics and logs from a **source** service (or resource) to one **destination** for analysis and long-term storage.
```text
   ┌────────────────────┐      ┌──────────────┐     ┌─────────────────┐
   │ Microsoft Entra ID │      │  Diagnostic  │     │    Event Hub    │
   │    <<source>>      │─────▶│   settings   │────▶│ <<destination>> │
   └────────────────────┘      └──────────────┘     └─────────────────┘
```

Examples of source services:
- Azure Monitor
- Microsoft Entra ID
- Azure Firewall

The diagnostic settings support several destination types. The Elastic Agent requires diagnostic settings configured with an event hub as the destination.

### Event Hub

[Azure Event Hubs](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-about) is a data streaming platform and event ingestion service that can receive and temporarily store millions of events.
Elastic Agent with the Azure Logs integration will consume logs published in the Event Hubs service.
```text
  ┌────────────────┐      ┌────────────┐
  │     adlogs     │      │  Elastic   │
  │ <<Event Hub>>  │─────▶│   Agent    │
  └────────────────┘      └────────────┘
```

To learn more about Event Hubs, refer to [Features and terminology in Azure Event Hubs](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-features).

### Storage account container

The [Storage account](https://learn.microsoft.com/en-us/azure/storage/common/storage-account-overview) is a versatile Azure service that allows you to store data in various storage types, including blobs, file shares, queues, tables, and disks.
The Azure Logs integration requires a Storage Account container to work. The integration uses the Storage Account container for checkpointing; it stores data about the Consumer Group (state, position, or offset) and shares it among the Elastic Agents. Sharing such information allows multiple Elastic Agents assigned to the same agent policy to work together, enabling horizontal scaling of the logs processing when required.
```text
  ┌────────────────┐                     ┌────────────┐
  │     adlogs     │        logs         │  Elastic   │
  │ <<Event Hub>>  │────────────────────▶│   Agent    │
  └────────────────┘                     └────────────┘
                                                │      
                       consumer group info      │      
  ┌────────────────┐   (state, position, or     │      
  │   azurelogs    │         offset)            │      
  │ <<container>>  │◀───────────────────────────┘      
  └────────────────┘                                                                            
```

The Elastic Agent automatically creates one container for each enabled integration. In the container, the Agent will create one blob for each existing partition on the event hub.
For example, if you enable one integration to fetch data from an event hub with four partitions, the Agent will create the following:
- One Storage Account container.
- Four blobs in that container.

The information stored in the blobs is small (usually < 300 bytes per blob) and accessed relatively frequently. Elastic recommends using the Hot storage tier.
You need to keep the Storage Account container as long as you need to run the integration with the Elastic Agent. If you delete a storage account container, the Elastic Agent will stop working and create a new one the next time it starts. By deleting a storage account container, the Elastic Agent will lose track of the last message processed and start processing messages from the beginning of the event hub retention period.

## Setup

With the Azure Logs integration (v2 preview), you can forward logs from multiple Azure services to the same event hub. The integration will automatically detect the log category and forward the logs to the appropriate data stream.
```text
                                                             ┌─────────────────┐
                                                             │  activity logs  │
                                                          ┌─▶│ <<data stream>> │
                                                          │  └─────────────────┘
                                                          │                     
┌───────────────┐   ┌─────────────┐  ┌─────────────────┐  │  ┌─────────────────┐
│     logs      │   │   Elastic   │  │ events (router) │  │  │  firewall logs  │
│ <<event hub>> │──▶│    Agent    │─▶│ <<data stream>> │──┼─▶│ <<data stream>> │
└───────────────┘   └─────────────┘  └─────────────────┘  │  └─────────────────┘
                                                          │                     
                                                          │  ┌─────────────────┐
                                                          │  │   signin logs   │
                                                          └─▶│ <<data stream>> │
                                                             └─────────────────┘
```

Before adding the integration, you must complete the following tasks.

### Create an Event Hub

The event hub receives the logs exported from the Azure service and makes them available for the Elastic Agent to read.
Here's a high-level overview of the required steps:
- Create a resource group, or select an existing one.
- Create an Event Hubs namespace.
- Create an event hub.

For a detailed step-by-step guide, check the quickstart [Create an event hub using Azure portal](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-create).
Take note of the event hub **Name**, which you will use later when specifying an **eventhub** in the integration settings.

#### Event Hubs Namespace vs Event Hub

In the integration settings, you should use the event hub name (not the Event Hubs namespace name) as the value for the  **event hub ** option.
If you are new to Event Hubs, think of the Event Hubs namespace as the cluster and the event hub as the topic. You will typically have one cluster and multiple topics.
If you are familiar with Kafka, here's a conceptual mapping between the two:

| Kafka Concept  | Event Hub Concept |
|----------------|-------------------|
| Cluster        | Namespace         |
| Topic          | An event hub      |
| Partition      | Partition         |
| Consumer Group | Consumer Group    |
| Offset         | Offset            |


#### How many partitions?

The number of partitions is essential to balance the event hub cost and performance.
Here are a few examples with one or multiple agents, with recommendations on picking the correct number of partitions for your use case.

##### Single Agent

With a single Agent deployment, increasing the number of partitions on the event hub is the primary driver in scale-up performances. The Agent creates one worker for each partition.
```text
┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐    ┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐

│                         │    │                         │

│   ┌─────────────────┐   │    │   ┌─────────────────┐   │
    │   partition 0   │◀───────────│    consumer     │
│   └─────────────────┘   │    │   └─────────────────┘   │
    ┌─────────────────┐            ┌─────────────────┐
│   │   partition 1   │◀──┼────┼───│    consumer     │   │
    └─────────────────┘            └─────────────────┘
│   ┌─────────────────┐   │    │   ┌─────────────────┐   │
    │   partition 2   │◀────────── │    consumer     │
│   └─────────────────┘   │    │   └─────────────────┘   │
    ┌─────────────────┐            ┌─────────────────┐
│   │   partition 3   │◀──┼────┼───│    consumer     │   │
    └─────────────────┘            └─────────────────┘
│                         │    │                         │

│                         │    │                         │

└ Event Hub ─ ─ ─ ─ ─ ─ ─ ┘    └ Agent ─ ─ ─ ─ ─ ─ ─ ─ ─ ┘
```


##### Two or more Agents

With more than one Agent, setting the number of partitions is crucial. The agents share the existing partitions to scale out performance and improve availability.
The number of partitions must be at least the number of agents.
```text
┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐    ┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐

│                         │    │   ┌─────────────────┐   │
                            ┌──────│    consumer     │
│   ┌─────────────────┐   │ │  │   └─────────────────┘   │
    │   partition 0   │◀────┘      ┌─────────────────┐
│   └─────────────────┘   │ ┌──┼───│    consumer     │   │
    ┌─────────────────┐     │      └─────────────────┘
│   │   partition 1   │◀──┼─┘  │                         │
    └─────────────────┘         ─Agent─ ─ ─ ─ ─ ─ ─ ─ ─ ─
│   ┌─────────────────┐   │    ┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐
    │   partition 2   │◀────┐
│   └─────────────────┘   │ │  │  ┌─────────────────┐    │
    ┌─────────────────┐     └─────│    consumer     │
│   │   partition 3   │◀──┼─┐  │  └─────────────────┘    │
    └─────────────────┘     │     ┌─────────────────┐
│                         │ └──┼──│    consumer     │    │
                                  └─────────────────┘
│                         │    │                         │

└ Event Hub ─ ─ ─ ─ ─ ─ ─ ┘    └ Agent ─ ─ ─ ─ ─ ─ ─ ─ ─ ┘
```


##### Recommendations

Create an event hub with at least two partitions. Two partitions allow low-volume deployment to support high availability with two agents. Consider creating four partitions or more to handle medium-volume deployments with availability.
To learn more about event hub partitions, read an in-depth guide from Microsoft at [Quickstart: Create an event hub using Azure portal](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-create).
To learn more about event hub partition from the performance perspective, check the scalability-focused document at [Event Hubs scalability](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-scalability#partitions).

#### How many Event Hubs?

With the Azure Logs integration (v2 preview), Elastic strongly recommends creating one event hub and using it for all Azure services.
For example, if you plan to collect Microsoft Entra ID and Azure Firewall logs, create one event hub and use it for both services.
Here's a high-level diagram of the solution:
```text
┌────────────────┐   ┌───────────────┐                                       
│  MS Entra ID   │   │  Diagnostic   │                                       
│  <<service>>   │──▶│   Settings    │─┐                                     
└────────────────┘   └───────────────┘ │                                     
                                       │  ┌───────────────┐   ┌─────────────┐
                                       │  │     logs      │   │   Elastic   │
                                       ├─▶│ <<event hub>> │──▶│    Agent    │
                                       │  └───────────────┘   └─────────────┘
┌────────────────┐   ┌───────────────┐ │                                     
│ Azure Firewall │   │  Diagnostic   │ │                                     
│  <<service>>   │──▶│   Settings    │─┘                                     
└────────────────┘   └───────────────┘                                       
```

The Azure Logs integration (v2 preview) will automatically detect the log category and forward the logs to the appropriate data stream.

#### Consumer Group

Like all other event hub clients, Elastic Agent needs a consumer group name to access the event hub.
A Consumer Group is an entire event hub's view (state, position, or offset). Consumer groups enable multiple agents to have a separate view of the event stream and to read the logs independently at their own pace and with their offsets.
Consumer groups allow multiple Elastic Agents assigned to the same agent policy to work together; this enables horizontal scaling of the logs processing when required.
In most cases, you can use the default consumer group named `$Default`. If `$Default` is already used by other applications, you can create a consumer group dedicated to the Azure Logs integration.

#### Connection string

The Elastic Agent requires a connection string to access the event hub and fetch the exported logs. The connection string contains details about the event hub used and the credentials required to access it.
To get the connection string for your Event Hubs namespace:
1. Visit the **Event Hubs namespace** you created in a previous step.
2. Select **Settings** > **Shared access policies**.

Create a new Shared Access Policy (SAS):
1. Select **Add** to open the creation panel.
2. Add a **Policy name** (for example, "ElasticAgent").
3. Select the **Listen** claim.
4. Select **Create**.

When the SAS Policy is ready, select it to display the information panel.
Take note of the **Connection string–primary key**, which you will use later when specifying a **connection_string** in the integration settings.

### Create a diagnostic settings

The diagnostic settings export the logs from Azure services to a destination and in order to use Azure Logs integration, it must be an event hub.
To create a diagnostic settings to export logs:
1. Locate the diagnostic settings for the service (for example, Microsoft Entra ID).
2. Select diagnostic settings in the **Monitoring** section of the service. Note that different services may place the diagnostic settings in various positions.
3. Select **Add diagnostic settings**.

In the diagnostic settings page you must select the source **log categories** you want to export and then select their **destination**.

#### Select log categories

Each Azure service exports a well-defined list of log categories. Check the individual integration doc to learn which log categories the integration supports.

#### Select the destination

Select the **subscription** and the **Event Hubs namespace** you previously created. Select the event hub dedicated to this integration.
```text
  ┌───────────────┐   ┌──────────────┐   ┌───────────────┐      ┌───────────┐
  │  MS Entra ID  │   │  Diagnostic  │   │     adlogs    │      │  Elastic  │
  │  <<service>>  ├──▶│   Settings   │──▶│ <<Event Hub>> │─────▶│   Agent   │
  └───────────────┘   └──────────────┘   └───────────────┘      └───────────┘
```


### Create a Storage Account container

The Elastic Agent stores the event hub checkpoint information in a storage account container. Storing checkpoint information in a container allows agents to share message processing and resume from the last processed message after a restart.
<note>
  Use the Storage Account as a checkpoint store only.
</note>

To create the storage account:
1. Sign in to the [Azure Portal](https://portal.azure.com/) and create your storage account.
2. While configuring your project details, make sure you select the following recommended default settings:
   - Hierarchical namespace: disabled
- Minimum TLS version: Version 1.2
- Access tier: Hot
- Enable soft delete for blobs: disabled
- Enable soft delete for containers: disabled
3. When the new storage account is ready, you need to take note of the storage account name and the Storage Account access keys, as you will use them later to authenticate your Elastic application’s requests to this storage account.

This is the final diagram of the setup for collecting Activity logs from the Azure Monitor service.
```text
 ┌───────────────┐   ┌──────────────┐   ┌────────────────┐         ┌───────────┐
 │  MS Entra ID  │   │  Diagnostic  │   │     adlogs     │  logs   │  Elastic  │
 │  <<service>>  ├──▶│   Settings   │──▶│ <<Event Hub>>  │────────▶│   Agent   │
 └───────────────┘   └──────────────┘   └────────────────┘         └───────────┘
                                                                          │     
                     ┌──────────────┐          consumer group info        │     
                     │  azurelogs   │          (state, position, or       │     
                     │<<container>> │◀───────────────offset)──────────────┘     
                     └──────────────┘                                           
```


#### How many Storage Accounts?

The Elastic Agent can use a single Storage Account to store the checkpoint information for multiple integrations.
**CRITICAL**: make sure to use a different **storage_account_container** for each integration. The Elastic Agent uses the **integration name** and the **event hub name** to uniquely identify the container that holds the blobs with the checkpoint information.
```text
┌─────────────────────────────────┐      ┌──────────────────────────────────────────┐
│                                 │      │                                          │
│    ┌─────────────────────┐      │      │  ┌────────────────────────────────────┐  │
│    │   azure-eventhub    │      │      │  │  filebeat-activitylogs-eventhub-1  │  │
│    │      <<input>>      │──────┼──────┼─▶│           <<container>>            │  │
│    └─────────────────────┘      │      │  └────────────────────────────────────┘  │
│    ┌─────────────────────┐      │      │  ┌────────────────────────────────────┐  │
│    │   azure-eventhub    │      │      │  │   filebeat-signinlogs-eventhub-2   │  │
│    │      <<input>>      │──────┼──────┼─▶│           <<container>>            │  │
│    └─────────────────────┘      │      │  └────────────────────────────────────┘  │
│    ┌─────────────────────┐      │      │  ┌────────────────────────────────────┐  │
│    │   azure-eventhub    │      │      │  │   filebeat-auditlogs-eventhub-3    │  │
│    │      <<input>>      │──────┼──────┼─▶│           <<container>>            │  │
│    └─────────────────────┘      │      │  └────────────────────────────────────┘  │
│                                 │      │                                          │
└─Elastic Agent───────────────────┘      └─Storage Account──────────────────────────┘
```


### Running the integration behind a firewall

When the Elastic Agent runs in an environment with network restrictions, you need to check if the required ports are open, depending on the transport protocol used by the integration.
The Elastic agent requires access to the following Azure services:
- Event Hubs
- Storage Accounts

```text
┌────────────────────────────────┐  ┌───────────────────┐  ┌───────────────────┐
│                                │  │                   │  │                   │
│ ┌────────────┐   ┌───────────┐ │  │  ┌──────────────┐ │  │ ┌───────────────┐ │
│ │ diagnostic │   │ event hub │ │  │  │azure-eventhub│ │  │ │ activity logs │ │
│ │  setting   │──▶│           │◀┼AMQP─│  <<input>>   │─┼──┼▶│<<data stream>>│ │
│ └────────────┘   └───────────┘ │  │  └──────────────┘ │  │ └───────────────┘ │
│                                │  │          │        │  │                   │
│                                │  │          │        │  │                   │
│                                │  │          │        │  │                   │
│         ┌─────────────┬─────HTTPS─┼──────────┘        │  │                   │
│ ┌───────┼─────────────┼──────┐ │  │                   │  │                   │
│ │       │             │      │ │  │                   │  │                   │
│ │       ▼             ▼      │ │  └─Agent─────────────┘  └─Elastic Cloud─────┘
│ │ ┌──────────┐  ┌──────────┐ │ │
│ │ │    0     │  │    1     │ │ │
│ │ │ <<blob>> │  │ <<blob>> │ │ │
│ │ └──────────┘  └──────────┘ │ │
│ │                            │ │
│ │                            │ │
│ └─Storage Account Container──┘ │
│                                │
│                                │
└─Azure──────────────────────────┘
```


#### Event Hubs (AMQP)

By default, the integration uses AMQP to communicate with the event hub.
AMQP uses port `5671` and `5672` for secure communication with the event hub. The Elastic Agent acts as a client and initiates **outbound TCP connections** to these ports on the Azure Event Hubs service. By allowing outgoing traffic to these ports, the Elastic Agent can establish a secure connection with the event hub to receive events.
For more information, check the following documents:
- [What ports do I need to open on the firewall?](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-faq#what-ports-do-i-need-to-open-on-the-firewall) from the [Event Hubs frequently asked questions](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-faq#what-ports-do-i-need-to-open-on-the-firewall).
- [AMQP outbound port requirements](https://learn.microsoft.com/en-us/azure/service-bus-messaging/service-bus-amqp-protocol-guide#amqp-outbound-port-requirements)


#### Event Hubs (AMQP-over-Websockets)

If ports `5671` / `5672` are blocked in your environment, the integration can use AMQP-over-WebSockets instead. This protocol tunnels AMQP over port `443` (HTTPS), which is typically allowed through firewalls.

##### Requirements

- **Elastic Agent version**: 8.19.10, 9.1.10, 9.2.4, or later.
- **Processor version**: You must set the `Processor version` to `v2` in the integration settings

To use AMQP-over-Websockets, set the **Event Hubs transport protocol** setting to "AMQP-over-WebSockets" in the **Advanced options** section of the integration.

#### Storage Account

The Elastic Agent initiates **outbound TCP connections** to port `443` (HTTPS) to communicate with the Azure Storage Account service. By allowing outgoing traffic to port `443`, the Elastic Agent can securely access and interact with the Storage Account service, which is essential for storing and retrieving checkpoint data for each event hub partition.

#### DNS

Optionally, you can restrict the traffic to the following domain names:
```text
*.servicebus.windows.net
*.blob.core.windows.net
*.cloudapp.net
```


#### Proxy Support

When using AMQP-over-WebSockets, both Event Hubs and Storage Account traffic use HTTPS (port `443`), which enables proxy support.
The integration supports proxying traffic to the Azure services using the `HTTPS_PROXY` environment variable.

##### Requirements

- **Transport protocol**: You need to set the **Event Hubs transport protocol** setting to "AMQP-over-WebSockets" when using a proxy.
- **Elastic Agent version**: 8.19.10, 9.1.10, 9.2.4, or later.
- **Processor version**: You must set the `Processor version` to `v2` in the integration settings


## Settings

Use the following settings to configure the Azure Logs integration when you add it to Fleet.
`eventhub` :
*string*
A fully managed, real-time data ingestion service. Elastic recommends using only letters, numbers, and the hyphen (-) character for event hub names to maximize compatibility. You can use existing event hubs having underscores (_) in the event hub name; in this case, the integration will replace underscores with hyphens (-) when it uses the event hub name to create dependent Azure resources behind the scenes (e.g., the storage account container to store event hub consumer offsets). Elastic also recommends using a separate event hub for each log type as the field mappings of each log type differ.
Default value `insights-operational-logs`.
`consumer_group` :
*string*
Enable the publish/subscribe mechanism of Event Hubs with consumer groups. A consumer group is a view (state, position, or offset) of an entire event hub. Consumer groups enable multiple consuming applications to each have a separate view of the event stream, and to read the stream independently at their own pace and with their own offsets.
Default value: `$Default`
`connection_string` :
*string*
The connection string is required to communicate with Event Hubs. See [Get an Event Hubs connection string](https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string) for more information.
A Blob Storage account is required to store/retrieve/update the offset or state of the event hub messages. This allows the integration to start back up when it stopped processing messages.
`storage_account` :
*string*
The name of the storage account that the state/offsets will be stored and updated.
`storage_account_key` :
*string*
The storage account key. Used to authorize access to data in your storage account.
`storage_account_container` :
*string*
The storage account container where the integration stores the checkpoint data for the consumer group. It is an advanced option to use with extreme care. You MUST use a dedicated storage account container for each Azure log type (activity, sign-in, audit logs, and others). DO NOT REUSE the same container name for more than one Azure log type. See [Container Names](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#container-names) for details on naming rules from Microsoft. The integration generates a default container name if not specified.
`resource_manager_endpoint` :
*string*
Optional. By default, the integration uses the Azure public environment. To override this and use a different Azure environment, users can provide a specific resource manager endpoint
Examples:
- Azure ChinaCloud: `https://management.chinacloudapi.cn/`
- Azure GermanCloud: `https://management.microsoftazure.de/`
- Azure PublicCloud: `https://management.azure.com/`
- Azure USGovernmentCloud: `https://management.usgovcloudapi.net/`

This setting can also be used to define your own endpoints, like for hybrid cloud models.

### Event Hub Processor v2 only

The following settings are **event hub processor v2 only** and available in the advanced section of the integration.
`processor_version` :
*string*
(processor v2 only) The processor version that the integration should use. Possible values are `v1` (legacy) and `v2`. Using the processor v2 is recommended for typical use cases. Default is `v2`.
`processor_update_interval` :
*string*
(processor v2 only) How often the processor should attempt to claim partitions. Default is `10s`.
`processor_start_position` :
*string*
(processor v2 only) Controls from which position in the event hub the processor should start processing messages for all partitions.
Possible values are `earliest` and `latest`.
- `earliest` (default): starts processing messages from the last checkpoint, or the beginning of the event hub if no checkpoint is available.
- `latest`: starts processing messages from the the latest event in the event hub and continues to process new events as they arrive.

`migrate_checkpoint` :
*boolean*
(processor v2 only) Controls processor behavior upon the initial transition from v1 to v2. If you are starting directly with v2, you can disregard this setting.
Defaults to `true`, which means the processor will automatically migrate checkpoint information from the v1 format to v2.
If set to `false`, the processor will bypass existing v1 checkpoints and replay all events in the Event Hub from the start of the retention window. For example, if set to `false` on an Event Hub with a 1-hour retention period, the processor will replay the last hour's worth of data.
`endpoint_suffix` :
*string*
Override the default endpoint suffix used to construct the connection string. Default is set to `core.windows.net`. For example, US Government Cloud users should set this to `core.usgovcloudapi.net`.
`partition_receive_timeout` :
*string*
(processor v2 only) Maximum time to wait before processing the messages received from the event hub.
The partition consumer waits up to a "receive count" or a "receive timeout", whichever comes first. Default is `5` seconds.
`partition_receive_count` :
*string*
(processor v2 only) Maximum number of messages from the event hub to wait for before processing them.
The partition consumer waits up to a "receive count" or a "receive timeout", whichever comes first. Default is `100` messages.
`transport` :
*string*
(processor v2 only) The transport protocol to use when connecting to the Event Hub. Possible values are:
- `amqp` (default): Use AMQP protocol (ports 5671/5672).
- `websocket`: Use AMQP over WebSockets (port 443). Use this option in environments where AMQP ports are blocked.

When `websocket` is selected, all traffic flows over HTTPS (port 443), enabling proxy support via the `HTTPS_PROXY` environment variable.

## Handling Malformed JSON in Azure Logs

Azure services have been observed occasionally sending [malformed JSON](https://learn.microsoft.com/en-us/answers/questions/1001797/invalid-json-logs-produced-for-function-apps) documents. These logs can disrupt the expected JSON formatting and lead to parsing issues during processing.
To address this issue, the advanced settings section of each data stream offers two sanitization options:
- Sanitizes New Lines: removes new lines in logs.
- Sanitizes Single Quotes: replace single quotes with double quotes in logs, excluding single quotes occurring within double quotes.

Malformed logs can be identified by:
- The presence of a records array in the message field indicates a failure to unmarshal the byte slice.
- An `error.message` field contains the "Received invalid JSON from the Azure Cloud platform. Unable to parse the source log message" text.

Known data streams that might produce malformed logs:
- Platform Logs
- Spring Apps Logs


## Reference

Visit the page for each individual Azure Logs integration to see details about exported fields and sample events.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![filebeat azure overview](https://epr.elastic.co/package/azure/1.35.1/img/filebeat-azure-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.35.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17027))Fix pipeline error when the `category` field is missing.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.49.1.108.19.10     |
  | **1.35.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16955))Add support for AMQP-over-WebSockets transport protocol and proxy configuration.                                                                                                                                                                                                                                                                                                                                                                                                        | 9.2.49.1.108.19.10     |
  | **1.34.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16674))Fix `durationMs` parsing in auditlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.34.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16618))Switch default processor version to v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16610))Support log event routing overrides in Azure Logs v2.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.15.1            |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15807))Update Events v2 routing of `signinlogs` and `springcloud` logs.                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16328))Expand date formats for parsing time fields: ISO8601, `M/d/yyyy h:mm:ss a XXX`, `M/d/yyyy h:mm:ss a`, `M/d/yyyy H:mm:ss`, `yyyy-MM-ddTH:mm:ss.SSSZ`.                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.0** | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16395))Remove `destination.ip` and `destination.port` mapping of `TranslatedIp` and `TranslatedPort`.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16395))Add `destination.ip` to `destination.address` and `source.ip` to `source.address`.Add `TranslatedIp` and `TranslatedPort` to `destination.nat.ip` and `destination.nat.port`.Update event type mappings for AZFWNetworkRule and AZFWApplicationRule categories in firewall_logs data stream. | 9.0.08.15.1            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15900))Add processor version options for the Raw Events (v1) integration.                                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15976))Update `time` formats parsing and fix `durationMs` parsing in signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.15.1            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15690))Parse responseBody and requestBody json in activitylogs.                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.7** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15205))Interim fix to support non-standard log events.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.28.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15203))Add FAQ section to Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.15.1            |
  | **1.28.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14986))Add support to override `Endpoint Suffix` based on deployment environment.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.15.1            |
  | **1.28.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14961))Workaround the invalid field names from Azure Native ISV                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.28.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14959))Handle invalid log events (empty fields and properties as string) from Azure services.                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.28.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14926))Fix Azure platformlogs ingest pipeline for function app logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14415))Support routing with invalid fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14068))Add a flag `fips_compatible` to control whether the package is allowed in the ECH FedRAMP High environment.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13920))Add missing pattern for DNAT request messages for `AzureFirewallNetworkRuleLog` in firewall_logs data stream.                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.15.1            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13922))Fix dashboard link.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.15.1            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14085))Standardize user fields for identity_protection and signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13921))Add Grok processor for `AzureFirewallThreatIntelLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13931))Set `service.id`, `device.id`, `user.id`, `session.id`, and `token.id` in graphactivitylogs dataset.                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.23.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13863))Improve Azure logs documentation with more details on log categories routing rules.                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13882))Fix Grok processor error in ingest pipeline for `AzureFirewallNetworkRuleLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13439))Map `azure.signinlogs.properties.location.state` field to `geo.region_name` instead of `geo.country_name`.                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.15.1            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12802))Enable Event Hub processor v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12735))Fix Platform Logs pipeline inconsistent casing for subscription_id field.                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12926))Fix the custom storage container description for the Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12641))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.20.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12233))Fix casting & naming issues in Graph Activity Logs related to the `event.duration` field.                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12047))Fix string literals in painless scripts.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11984))Add Azure Logs integration v2 (preview)                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.19.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11749))Fix destination.geo.region_name mapping.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.19.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11765))Rename the `Identity` field to `identity` for consistency.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.19.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11732))Rename the `properties` field to `properties.raw` to avoid parse errors when the `properties` field contains a string.                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11660))Fix an error and clarify the docs about the Storage Account container.                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11344))Add entity identifiers to `related.entity`.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10007))Add `event.reason` log field for exact data found in requests that matches a firewall rule.                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11102))Fix [client|source].geo.location ECS field mapping                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10984))Add new section on Azure Functions hosting plans.                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10379))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10583))Expand docs with more details on the Event Hub partitions configuration.                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9428))Add structured log categories to Azure Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10224))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/10224))Updated "event.outcome" values from "Succeeded" to "success" and "Failed" to "failure".                                                                                                                  | 8.13.0                 |
  | **1.11.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9774))Replace Azure AD with Microsoft Entra ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.12.0                 |
  | **1.11.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9701))Update Azure Audit Logs pipeline with support for initiated_by user fields.                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9738))Add missing ECS field definitions.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.11.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9258))Update description for event hub parameter name recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.12.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9554))Use ecs definition of the 'event.dataset' field for eventhub                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9314))Add Microsoft Graph Activity Logs                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.9.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9158))Add docs for running the integration behind a firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9159))Set field type to password on secret fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9022))Add support for integration secrets                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8813))Add caller_ip_address field in pipeline for Azure sign-in logs.                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.0                  |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8666))Update Azure logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8275))Update AD Logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.8.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8432))Allow rerouting of Azure logs events to a different data stream.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8192))Rebrand Azure Spring Cloud Logs to Azure Spring Apps                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8050))Update the package format_version to 3.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.33** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7995))Handle `json.properties.clientIp` as an alias of `json.properties.clientIP` in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.32** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7979))Fix mappings for `azure.activitylogs.claims.*`.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.31** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7376))Migration of Azure AD Identity Protection dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.30** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7375))Migration of Azure AD Provisioning Logs dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.6.0                  |
  | **1.5.29** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7525))Fix Azure dashboards descriptions and titles.                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.28** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Migration Alerts Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.27** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6960))Fix in Firewall dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                  |
  | **1.5.26** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6867))Handle duplicate user_agent.original field in signinlogs logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                  |
  | **1.5.25** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6866))Handle duplicate url.path field in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.24** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6824))Handle firewall events for DNAT'ed requests with attributes                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.23** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6624))Update Azure Logs screenshot                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.22** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6501))Migration of Azure Cloud Overview dashboard to Lens and style changes                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                  |
  | **1.5.21** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6503))Migration of User Activity Dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.20** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6357))Integration settings UI for sanitization                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                  |
  | **1.5.17** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6432))Migration of Spring Cloud Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.5.16** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6435))Migration of Azure Spring Cloud Logs Application Cloud Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.15** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6397))Migration of Spring Cloud System Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.14** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Enhancement/Improving performance of the dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.13** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5604))Extend the Storage Account container documentation and add link to requiements and setup instructions                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.12** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.5.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5382))Add a new message format to the AzureFirewallNetworkRule log category                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.10** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5361))Check for 'event.original' already existing in Application Gateway and Event Hub ingest pipelines                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.5.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5334))Check for 'event.original' already existing in firewall logs ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.5.8**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5290))Add `storage_account_container` option to the Application Gateway integration                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5129))Fix parsing of authentication_processing_details field in signin logs                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5073))Fix parsing error client port is blank and adjust for timeStamp                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4629))Rename identity as identity_name when the value is a string                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.5.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4476))Enable Event Hub integration by default and improve documentation                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4373))Data streams start as disabled on new installs                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4384))Fix PR link in changelog                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4382))Fix documentations formatting (remove extra 'Overview' heading)                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3892))Add Azure Application Gatewaty data stream                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4300))Update Azure Logs documentation                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4149))Add two new data streams to the Azure AD logs integration: Azure Identity Protection logs and Provisioning logs                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3877))Add the possibility to override the default generated storage account container                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3805))Update docs with recommended Event Hub configuration                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3679))Fix Azure Sign-in logs ingest pipeline bug                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3578))Support Azure firewall logs                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.1.11** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3639))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **1.1.10** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3072))Update readme with links to Microsoft documentation                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3411))Improve handling of IPv6 IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3209))Update docs with details about Event Hub name recommendations                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.1.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3211))Add geo.name and result_description fields in platformlogs                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.1.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Fix azure.activitylogs.identity with a a concrete value**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Add identity_name, tenant_id, level and operation_version into activity logs                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2891))Fix `event.duration` field mapping conflict in all Azure data streams.                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2822))Added the `forwarded` tag by default to all log types.                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Add device_detail.is_compliant and device_detail.is_managed fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Change authentication_requirement_policies to flattened type                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflict in the auditlogs data stream for `client.ip`. Changed `azure-eventhub.offset` and `azure-eventhub.sequence_number` to longs from keyword in the eventhub data stream.                                                                                                                                                                                                                                                                                             |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2682))Support new Azure audit logs and signin logs                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2547))Remove beta release tag from data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2528))Move azure package to GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **0.12.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2479))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.12.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2174))Release azure package for v8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1894))Add Azure Event Hub Input                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2005))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1721))signinlogs - Add support for ManagedIdentitySignInLogs, NonInteractiveUserSignInLogs, and ServicePrincipalSignInLogs.                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.9.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1870))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1798))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1688))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1644))Add ECS `client.ip` mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.8.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1542))Update docs and logo                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1466))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1521))Import geo_points from ECS                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1514))Update error message                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1462))Add support for springcloud logs inside the platformlogs pipeline                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1455))Import ECS field definitions                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1355))Add spring cloud logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1372))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1353))Re-add pipeline changes for invalid json                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1051))Add input groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1238))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1121))sync package with module changes                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1113))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/835))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/741))Add check for empty configuration options.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/722))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/272))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
</dropdown>