﻿---
title: Microsoft Entra ID Logs
description: Microsoft Entra ID logs are records of events and activities that occur within a Microsoft Entra ID environment of an organization. These logs capture...
url: https://www.elastic.co/docs/reference/integrations/azure/adlogs
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Microsoft Entra ID Logs
|                                                                            |                                 |
|----------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                | 1.35.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                           |
| **Ingestion method(s)**                                                    | Azure Event Hub                 |
| **Minimum Kibana version(s)**                                              | 9.2.49.1.108.19.10              |

Microsoft Entra ID logs are records of events and activities that occur within a Microsoft Entra ID environment of an organization.
These logs capture important information such as user sign-ins, changes to user accounts, and more. They can be used to monitor and track user activity, identify security threats, troubleshoot issues, and generate reports for compliance purposes.
The Microsoft Entra ID logs integration contain several data streams:
- **Sign-in logs** – Information about sign-ins and how your users use your resources.
- **Identity Protection logs** - Information about user risk status and the events that change it.
- **Provisioning logs** - Information about users and group synchronization to and from external enterprise applications.
- **Audit logs** – Information about changes to your tenant, such as users and group management, or updates to your tenant's resources.

Supported Azure log categories:

| Data Stream         | Log Category                                                                                                                          |
|---------------------|---------------------------------------------------------------------------------------------------------------------------------------|
| Sign-in             | SignInLogs                                                                                                                            |
| Sign-in             | [NonInteractiveUserSignInLogs](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aadnoninteractiveusersigninlogs) |
| Sign-in             | [ServicePrincipalSignInLogs](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aadserviceprincipalsigninlogs)     |
| Sign-in             | [ManagedIdentitySignInLogs](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aadmanagedidentitysigninlogs)       |
| Audit               | [AuditLogs](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/auditlogs)                                          |
| Identity Protection | [RiskyUsers](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aadriskyusers)                                     |
| Identity Protection | [UserRiskEvents](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aaduserriskevents)                             |
| Provisioning        | [ProvisioningLogs](https://docs.microsoft.com/en-us/azure/azure-monitor/reference/tables/aadprovisioninglogs)                         |


## Requirements and setup

Refer to the [Azure Logs](https://docs.elastic.co/integrations/azure) page for more information about setting up and using this integration.

## Settings

`eventhub` :
*string*
This setting expects the name of a single Event Hub (see the [difference between a namespace and an Event Hub](https://docs.elastic.co/integrations/azure#event-hub-namespace-vs-event-hub)). It is a fully managed, real-time data ingestion service. Elastic recommends using only letters, numbers, and the hyphen (-) character for Event Hub names to maximize compatibility. You can use existing Event Hubs having underscores (_) in the Event Hub name; in this case, the integration will replace underscores with hyphens (-) when it uses the Event Hub name to create dependent Azure resources behind the scenes (e.g., the storage account container to store Event Hub consumer offsets). Elastic also recommends using a separate event hub for each log type as the field mappings of each log type differ.
Default value `insights-operational-logs`.
`consumer_group` :
*string*
The publish/subscribe mechanism of Event Hubs is enabled through consumer groups. A consumer group is a view (state, position, or offset) of an entire event hub. Consumer groups enable multiple consuming applications to each have a separate view of the event stream, and to read the stream independently at their own pace and with their own offsets.
Default value: `$Default`
`connection_string` :
*string*
The connection string required to communicate with the specified Event Hub, steps here .
A Blob Storage account is required in order to store/retrieve/update the offset or state of the eventhub messages. This means that after stopping the filebeat azure module it can start back up at the spot that it stopped processing messages.
`storage_account` :
*string*
The name of the storage account the state/offsets will be stored and updated.
`storage_account_key` :
*string*
The storage account key, this key will be used to authorize access to data in your storage account.
`storage_account_container` :
*string*
The storage account container where the integration stores the checkpoint data for the consumer group. It is an advanced option to use with extreme care. You MUST use a dedicated storage account container for each Azure log type (activity, sign-in, audit logs, and others). DO NOT REUSE the same container name for more than one Azure log type. See [Container Names](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#container-names) for details on naming rules from Microsoft. The integration generates a default container name if not specified.
`resource_manager_endpoint` :
*string*
Optional, by default we are using the azure public environment, to override, users can provide a specific resource manager endpoint in order to use a different azure environment.
Resource manager endpoints:
```text
# Azure ChinaCloud
https://management.chinacloudapi.cn/

# Azure GermanCloud
https://management.microsoftazure.de/

# Azure PublicCloud 
https://management.azure.com/

# Azure USGovernmentCloud
https://management.usgovcloudapi.net/
```


## Logs


### Sign-in logs

Retrieves Microsoft Entra ID sign-in logs. The sign-ins report provides information about the usage of managed applications and user sign-in activities.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-10-18T09:45:48.072Z",
      "azure": {
          "correlation_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
          "resource": {
              "id": "/tenants/8a4de8b5-095c-47d0-a96f-a75130c61d53/providers/Microsoft.aadiam",
              "provider": "Microsoft.aadiam"
          },
          "signinlogs": {
              "caller_ip_address": "81.2.69.144",
              "category": "SignInLogs",
              "identity": "Test LTest",
              "operation_name": "Sign-in activity",
              "operation_version": "1.0",
              "properties": {
                  "app_display_name": "Office 365",
                  "app_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
                  "client_app_used": "Browser",
                  "conditional_access_status": "notApplied",
                  "correlation_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
                  "created_at": "2019-10-18T04:45:48.0729893-05:00",
                  "device_detail": {
                      "browser": "Chrome 77.0.3865",
                      "operating_system": "MacOs"
                  },
                  "id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
                  "is_interactive": false,
                  "original_request_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
                  "processing_time_ms": 239,
                  "risk_detail": "none",
                  "risk_level_aggregated": "none",
                  "risk_level_during_signin": "none",
                  "risk_state": "none",
                  "status": {
                      "error_code": 50140
                  },
                  "token_issuer_type": "AzureAD",
                  "user_display_name": "Test LTest",
                  "user_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
                  "user_principal_name": "test@elastic.co"
              },
              "result_description": "This error occurred due to 'Keep me signed in' interrupt when the user was signing-in.",
              "result_signature": "None",
              "result_type": "50140"
          },
          "tenant_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53"
      },
      "client": {
          "ip": "81.2.69.144"
      },
      "cloud": {
          "provider": "azure"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "event": {
          "action": "Sign-in activity",
          "category": [
              "authentication"
          ],
          "duration": 0,
          "id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
          "kind": "event",
          "original": "{\"Level\":\"4\",\"callerIpAddress\":\"81.2.69.144\",\"category\":\"SignInLogs\",\"correlationId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"durationMs\":0,\"identity\":\"Test LTest\",\"location\":\"FR\",\"operationName\":\"Sign-in activity\",\"operationVersion\":\"1.0\",\"properties\":{\"appDisplayName\":\"Office 365\",\"appId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"clientAppUsed\":\"Browser\",\"conditionalAccessStatus\":\"notApplied\",\"correlationId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"createdDateTime\":\"2019-10-18T04:45:48.0729893-05:00\",\"deviceDetail\":{\"browser\":\"Chrome 77.0.3865\",\"deviceId\":\"\",\"operatingSystem\":\"MacOs\"},\"id\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"ipAddress\":\"81.2.69.144\",\"isInteractive\":false,\"location\":{\"city\":\"Champs-Sur-Marne\",\"countryOrRegion\":\"FR\",\"geoCoordinates\":{\"latitude\":48.12341234,\"longitude\":2.12341234},\"state\":\"Seine-Et-Marne\"},\"originalRequestId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"processingTimeInMilliseconds\":239,\"riskDetail\":\"none\",\"riskLevelAggregated\":\"none\",\"riskLevelDuringSignIn\":\"none\",\"riskState\":\"none\",\"servicePrincipalId\":\"\",\"status\":{\"errorCode\":50140,\"failureReason\":\"This error occurred due to 'Keep me signed in' interrupt when the user was signing-in.\"},\"tokenIssuerName\":\"\",\"tokenIssuerType\":\"AzureAD\",\"userDisplayName\":\"Test LTest\",\"userId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"userPrincipalName\":\"test@elastic.co\"},\"resourceId\":\"/tenants/8a4de8b5-095c-47d0-a96f-a75130c61d53/providers/Microsoft.aadiam\",\"resultDescription\":\"This error occurred due to 'Keep me signed in' interrupt when the user was signing-in.\",\"resultSignature\":\"None\",\"resultType\":\"50140\",\"tenantId\":\"8a4de8b5-095c-47d0-a96f-a75130c61d53\",\"time\":\"2019-10-18T09:45:48.0729893Z\"}",
          "outcome": "failure",
          "type": [
              "info"
          ]
      },
      "geo": {
          "city_name": "Champs-Sur-Marne",
          "country_iso_code": "FR",
          "location": {
              "lat": 48.12341234,
              "lon": 2.12341234
          },
          "region_name": "Seine-Et-Marne"
      },
      "log": {
          "level": "4"
      },
      "message": "This error occurred due to 'Keep me signed in' interrupt when the user was signing-in.",
      "related": {
          "entity": [
              "8a4de8b5-095c-47d0-a96f-a75130c61d53"
          ],
          "ip": [
              "81.2.69.144"
          ],
          "user": [
              "8a4de8b5-095c-47d0-a96f-a75130c61d53",
              "test@elastic.co",
              "Test LTest"
          ]
      },
      "source": {
          "address": "81.2.69.144",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "ip": "81.2.69.144"
      },
      "tags": [
          "preserve_original_event"
      ],
      "user": {
          "email": "test@elastic.co",
          "full_name": "Test LTest",
          "id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
          "name": "test@elastic.co"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                           | Description                                                                                                                                                                                                                                                                                 | Type             |
  |-----------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                      | Event timestamp.                                                                                                                                                                                                                                                                            | date             |
  | azure.correlation_id                                            | Correlation ID                                                                                                                                                                                                                                                                              | keyword          |
  | azure.resource.authorization_rule                               | Authorization rule                                                                                                                                                                                                                                                                          | keyword          |
  | azure.resource.group                                            | Resource group                                                                                                                                                                                                                                                                              | keyword          |
  | azure.resource.id                                               | Resource ID                                                                                                                                                                                                                                                                                 | keyword          |
  | azure.resource.name                                             | Name                                                                                                                                                                                                                                                                                        | keyword          |
  | azure.resource.namespace                                        | Resource type/namespace                                                                                                                                                                                                                                                                     | keyword          |
  | azure.resource.provider                                         | Resource type/namespace                                                                                                                                                                                                                                                                     | keyword          |
  | azure.signinlogs.caller_ip_address                              | The IP address of the client that made the request.                                                                                                                                                                                                                                         | ip               |
  | azure.signinlogs.category                                       | Category                                                                                                                                                                                                                                                                                    | keyword          |
  | azure.signinlogs.identity                                       | Identity                                                                                                                                                                                                                                                                                    | keyword          |
  | azure.signinlogs.operation_name                                 | The operation name                                                                                                                                                                                                                                                                          | keyword          |
  | azure.signinlogs.operation_version                              | The operation version                                                                                                                                                                                                                                                                       | keyword          |
  | azure.signinlogs.properties.app_display_name                    | App display name                                                                                                                                                                                                                                                                            | keyword          |
  | azure.signinlogs.properties.app_id                              | App ID                                                                                                                                                                                                                                                                                      | keyword          |
  | azure.signinlogs.properties.applied_conditional_access_policies | A list of conditional access policies that are triggered by the corresponding sign-in activity.                                                                                                                                                                                             | flattened        |
  | azure.signinlogs.properties.authentication_details              | The result of the authentication attempt and additional details on the authentication method.                                                                                                                                                                                               | flattened        |
  | azure.signinlogs.properties.authentication_processing_details   | Additional authentication processing details, such as the agent name in case of PTA/PHS or Server/farm name in case of federated authentication.                                                                                                                                            | flattened        |
  | azure.signinlogs.properties.authentication_protocol             | Authentication protocol type.                                                                                                                                                                                                                                                               | keyword          |
  | azure.signinlogs.properties.authentication_requirement          | This holds the highest level of authentication needed through all the sign-in steps, for sign-in to succeed.                                                                                                                                                                                | keyword          |
  | azure.signinlogs.properties.authentication_requirement_policies | Set of CA policies that apply to this sign-in, each as CA: policy name, and/or MFA: Per-user                                                                                                                                                                                                | flattened        |
  | azure.signinlogs.properties.autonomous_system_number            | Autonomous system number.                                                                                                                                                                                                                                                                   | long             |
  | azure.signinlogs.properties.client_app_used                     | Client app used                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.properties.conditional_access_status           | Conditional access status                                                                                                                                                                                                                                                                   | keyword          |
  | azure.signinlogs.properties.correlation_id                      | Correlation ID                                                                                                                                                                                                                                                                              | keyword          |
  | azure.signinlogs.properties.created_at                          | Date and time (UTC) the sign-in was initiated.                                                                                                                                                                                                                                              | date             |
  | azure.signinlogs.properties.cross_tenant_access_type            |                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.properties.device_detail.browser               | Browser                                                                                                                                                                                                                                                                                     | keyword          |
  | azure.signinlogs.properties.device_detail.device_id             | Device ID                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.signinlogs.properties.device_detail.display_name          | Display name                                                                                                                                                                                                                                                                                | keyword          |
  | azure.signinlogs.properties.device_detail.is_compliant          | If the device is compliant                                                                                                                                                                                                                                                                  | boolean          |
  | azure.signinlogs.properties.device_detail.is_managed            | If the device is managed                                                                                                                                                                                                                                                                    | boolean          |
  | azure.signinlogs.properties.device_detail.operating_system      | Operating system                                                                                                                                                                                                                                                                            | keyword          |
  | azure.signinlogs.properties.device_detail.trust_type            | Trust type                                                                                                                                                                                                                                                                                  | keyword          |
  | azure.signinlogs.properties.flagged_for_review                  |                                                                                                                                                                                                                                                                                             | boolean          |
  | azure.signinlogs.properties.home_tenant_id                      |                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.properties.id                                  | Unique ID representing the sign-in activity.                                                                                                                                                                                                                                                | keyword          |
  | azure.signinlogs.properties.incoming_token_type                 | Incoming token type.                                                                                                                                                                                                                                                                        | keyword          |
  | azure.signinlogs.properties.is_interactive                      | Is interactive                                                                                                                                                                                                                                                                              | boolean          |
  | azure.signinlogs.properties.is_tenant_restricted                |                                                                                                                                                                                                                                                                                             | boolean          |
  | azure.signinlogs.properties.network_location_details            | The network location details including the type of network used and its names.                                                                                                                                                                                                              | flattened        |
  | azure.signinlogs.properties.original_request_id                 | Original request ID                                                                                                                                                                                                                                                                         | keyword          |
  | azure.signinlogs.properties.processing_time_ms                  | Processing time in milliseconds                                                                                                                                                                                                                                                             | float            |
  | azure.signinlogs.properties.resource_display_name               | Resource display name                                                                                                                                                                                                                                                                       | keyword          |
  | azure.signinlogs.properties.resource_id                         | The identifier of the resource that the user signed in to.                                                                                                                                                                                                                                  | keyword          |
  | azure.signinlogs.properties.resource_tenant_id                  |                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.properties.risk_detail                         | Risk detail                                                                                                                                                                                                                                                                                 | keyword          |
  | azure.signinlogs.properties.risk_event_types                    | The list of risk event types associated with the sign-in. Possible values: unlikelyTravel, anonymizedIPAddress, maliciousIPAddress, unfamiliarFeatures, malwareInfectedIPAddress, suspiciousIPAddress, leakedCredentials, investigationsThreatIntelligence, generic, or unknownFutureValue. | keyword          |
  | azure.signinlogs.properties.risk_event_types_v2                 | The list of risk event types associated with the sign-in. Possible values: unlikelyTravel, anonymizedIPAddress, maliciousIPAddress, unfamiliarFeatures, malwareInfectedIPAddress, suspiciousIPAddress, leakedCredentials, investigationsThreatIntelligence, generic, or unknownFutureValue. | keyword          |
  | azure.signinlogs.properties.risk_level_aggregated               | Risk level aggregated                                                                                                                                                                                                                                                                       | keyword          |
  | azure.signinlogs.properties.risk_level_during_signin            | Risk level during signIn                                                                                                                                                                                                                                                                    | keyword          |
  | azure.signinlogs.properties.risk_state                          | Risk state                                                                                                                                                                                                                                                                                  | keyword          |
  | azure.signinlogs.properties.service_principal_credential_key_id | Key id of the service principal that initiated the sign-in.                                                                                                                                                                                                                                 | keyword          |
  | azure.signinlogs.properties.service_principal_id                | The application identifier used for sign-in. This field is populated when you are signing in using an application.                                                                                                                                                                          | keyword          |
  | azure.signinlogs.properties.service_principal_name              | The application name used for sign-in. This field is populated when you are signing in using an application.                                                                                                                                                                                | keyword          |
  | azure.signinlogs.properties.sso_extension_version               |                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.properties.status.error_code                   | Error code                                                                                                                                                                                                                                                                                  | long             |
  | azure.signinlogs.properties.token_issuer_name                   | Token issuer name                                                                                                                                                                                                                                                                           | keyword          |
  | azure.signinlogs.properties.token_issuer_type                   | Token issuer type                                                                                                                                                                                                                                                                           | keyword          |
  | azure.signinlogs.properties.unique_token_identifier             | Unique token identifier for the request.                                                                                                                                                                                                                                                    | keyword          |
  | azure.signinlogs.properties.user_display_name                   | User display name                                                                                                                                                                                                                                                                           | keyword          |
  | azure.signinlogs.properties.user_id                             | User ID                                                                                                                                                                                                                                                                                     | keyword          |
  | azure.signinlogs.properties.user_principal_name                 | User principal name                                                                                                                                                                                                                                                                         | keyword          |
  | azure.signinlogs.properties.user_type                           |                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.signinlogs.result_description                             | Result description                                                                                                                                                                                                                                                                          | keyword          |
  | azure.signinlogs.result_signature                               | Result signature                                                                                                                                                                                                                                                                            | keyword          |
  | azure.signinlogs.result_type                                    | Result type                                                                                                                                                                                                                                                                                 | keyword          |
  | azure.signinlogs.tenant_id                                      | Tenant ID                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.subscription_id                                           | Azure subscription ID                                                                                                                                                                                                                                                                       | keyword          |
  | azure.tenant_id                                                 | tenant ID                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.image.id                                                  | Image ID for the cloud instance.                                                                                                                                                                                                                                                            | keyword          |
  | data_stream.dataset                                             | Data stream dataset name.                                                                                                                                                                                                                                                                   | constant_keyword |
  | data_stream.namespace                                           | Data stream namespace.                                                                                                                                                                                                                                                                      | constant_keyword |
  | data_stream.type                                                | Data stream type.                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.dataset                                                   | Event dataset                                                                                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                    | Event module                                                                                                                                                                                                                                                                                | constant_keyword |
  | geo.city_name                                                   | City name.                                                                                                                                                                                                                                                                                  | keyword          |
  | geo.continent_name                                              | Name of the continent.                                                                                                                                                                                                                                                                      | keyword          |
  | geo.country_iso_code                                            | Country ISO code.                                                                                                                                                                                                                                                                           | keyword          |
  | geo.country_name                                                | Country name.                                                                                                                                                                                                                                                                               | keyword          |
  | geo.location                                                    | Longitude and latitude.                                                                                                                                                                                                                                                                     | geo_point        |
  | geo.region_name                                                 | Region name.                                                                                                                                                                                                                                                                                | keyword          |
  | host.containerized                                              | If the host is a container.                                                                                                                                                                                                                                                                 | boolean          |
  | host.os.build                                                   | OS build information.                                                                                                                                                                                                                                                                       | keyword          |
  | host.os.codename                                                | OS codename, if any.                                                                                                                                                                                                                                                                        | keyword          |
  | related.entity                                                  | All the entity identifiers related to the document. If the document contains multiple entities, identifiers belonging to different entities will be present. Example identifiers include cloud resource IDs, ARNs, email addresses, or hostnames.                                           | keyword          |
</dropdown>


### Identity Protection logs

Retrieves Microsoft Entra ID Protection logs. The [Microsoft Entra ID Protection](https://docs.microsoft.com/en-us/azure/active-directory/identity-protection/overview-identity-protection) service analyzes events from Microsoft Entra ID users' behavior, detects risk situations, and can respond by reporting only or even blocking users at risk, according to policy configurations.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-08-22T18:07:16.000Z",
      "azure": {
          "correlation_id": "ce0ed07f9ccf5be15e4b97d2979af6569b1f67db87ddc9b88b5bb743ea091e47",
          "identityprotection": {
              "category": "UserRiskEvents",
              "operation_name": "User Risk Detection",
              "operation_version": "1.0",
              "properties": {
                  "activity": "signin",
                  "activity_datetime": "2022-08-22T18:05:06.133Z",
                  "additional_info": [
                      {
                          "Key": "userAgent",
                          "Value": "Mozilla/5.0 (Windows NT 10.0; rv:91.0) Gecko/20100101 Firefox/91.0"
                      }
                  ],
                  "correlation_id": "266133c2-fabb-492f-9ebf-bdf12317b817",
                  "detected_datetime": "2022-08-22T18:05:06.133Z",
                  "detection_timing_type": "realtime",
                  "id": "ce0ed07f9ccf5be15e4b97d2979af6569b1f67db87ddc9b88b5bb743ea091e47",
                  "ip_address": "67.43.156.42",
                  "last_updated_datetime": "2022-08-22T18:07:16.894Z",
                  "location": {
                      "city": "Dresden",
                      "countryOrRegion": "DE",
                      "geoCoordinates": {
                          "altitude": 0,
                          "latitude": 51.0714,
                          "longitude": 13.7399
                      },
                      "state": "Sachsen"
                  },
                  "request_id": "e1b6d9d7-5fc0-4638-ae1a-e0abceb92200",
                  "risk_detail": "none",
                  "risk_event_type": "anonymizedIPAddress",
                  "risk_level": "high",
                  "risk_state": "atRisk",
                  "risk_type": "anonymizedIPAddress",
                  "source": "IdentityProtection",
                  "token_issuer_type": "AzureAD",
                  "user_display_name": "Joe Danger",
                  "user_id": "51e26eae-d07b-44e5-bb0b-249f49569a8c",
                  "user_principal_name": "joe.danger@mauriziobrancaoutlook.onmicrosoft.com",
                  "user_type": "member"
              },
              "result_signature": "None"
          },
          "resource": {
              "id": "/tenants/5611623b-9128-461e-9d7f-a0d9c270ead2/providers/microsoft.aadiam",
              "provider": "microsoft.aadiam"
          },
          "tenant_id": "5611623b-9128-461e-9d7f-a0d9c270ead2"
      },
      "cloud": {
          "provider": "azure"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "event": {
          "action": "User Risk Detection",
          "duration": 0,
          "kind": "event",
          "original": "{\"time\":\"8/22/2022 6:07:16 PM\",\"resourceId\":\"/tenants/5611623b-9128-461e-9d7f-a0d9c270ead2/providers/microsoft.aadiam\",\"operationName\":\"User Risk Detection\",\"operationVersion\":\"1.0\",\"category\":\"UserRiskEvents\",\"tenantId\":\"5611623b-9128-461e-9d7f-a0d9c270ead2\",\"resultSignature\":\"None\",\"durationMs\":0,\"callerIpAddress\":\"67.43.156.42\",\"correlationId\":\"ce0ed07f9ccf5be15e4b97d2979af6569b1f67db87ddc9b88b5bb743ea091e47\",\"identity\":\"joe danger\",\"Level\":4,\"location\":\"de\",\"properties\":{\"id\":\"ce0ed07f9ccf5be15e4b97d2979af6569b1f67db87ddc9b88b5bb743ea091e47\",\"requestId\":\"e1b6d9d7-5fc0-4638-ae1a-e0abceb92200\",\"correlationId\":\"266133c2-fabb-492f-9ebf-bdf12317b817\",\"riskType\":\"anonymizedIPAddress\",\"riskEventType\":\"anonymizedIPAddress\",\"riskState\":\"atRisk\",\"riskLevel\":\"high\",\"riskDetail\":\"none\",\"source\":\"IdentityProtection\",\"detectionTimingType\":\"realtime\",\"activity\":\"signin\",\"ipAddress\":\"67.43.156.42\",\"location\":{\"city\":\"Dresden\",\"state\":\"Sachsen\",\"countryOrRegion\":\"DE\",\"geoCoordinates\":{\"altitude\":0,\"latitude\":51.0714,\"longitude\":13.7399}},\"activityDateTime\":\"2022-08-22T18:05:06.133Z\",\"detectedDateTime\":\"2022-08-22T18:05:06.133Z\",\"lastUpdatedDateTime\":\"2022-08-22T18:07:16.894Z\",\"userId\":\"51e26eae-d07b-44e5-bb0b-249f49569a8c\",\"userDisplayName\":\"Joe Danger\",\"userPrincipalName\":\"joe.danger@mauriziobrancaoutlook.onmicrosoft.com\",\"additionalInfo\":\"[{\\\"Key\\\":\\\"userAgent\\\",\\\"Value\\\":\\\"Mozilla/5.0 (Windows NT 10.0; rv:91.0) Gecko/20100101 Firefox/91.0\\\"}]\",\"tokenIssuerType\":\"AzureAD\",\"resourceTenantId\":null,\"homeTenantId\":\"5611623b-9128-461e-9d7f-a0d9c270ead2\",\"userType\":\"member\",\"crossTenantAccessType\":\"none\"}}"
      },
      "source": {
          "as": {
              "number": 35908
          },
          "geo": {
              "continent_name": "Asia",
              "country_iso_code": "BT",
              "country_name": "Bhutan",
              "location": {
                  "lat": 27.5,
                  "lon": 90.5
              }
          },
          "ip": "67.43.156.42"
      },
      "related": {
          "user": [
              "51e26eae-d07b-44e5-bb0b-249f49569a8c",
              "joe.danger@mauriziobrancaoutlook.onmicrosoft.com",
              "Joe Danger"
          ]
      },
      "user": {
          "email": "joe.danger@mauriziobrancaoutlook.onmicrosoft.com",
          "full_name": "Joe Danger",
          "id": "51e26eae-d07b-44e5-bb0b-249f49569a8c",
          "name": "joe.danger@mauriziobrancaoutlook.onmicrosoft.com"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Type             |
  |----------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                     | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | azure.correlation_id                                           | Correlation ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | azure.identityprotection.category                              | Category                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | azure.identityprotection.operation_name                        | Operation name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | azure.identityprotection.operation_version                     | Operation version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | azure.identityprotection.properties.activity                   | Indicates the activity type the detected risk is linked to. Possible values are: signin, user, unknownFutureValue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | azure.identityprotection.properties.activity_datetime          | Date and time that the risky activity occurred. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is look like this: 2014-01-01T00:00:00Z.                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | azure.identityprotection.properties.additional_info            | Additional information associated with the risk detection. Possible keys in the additionalInfo JSON string are: userAgent, alertUrl, relatedEventTimeInUtc, relatedUserAgent, deviceInformation, relatedLocation, requestId, correlationId, lastActivityTimeInUtc, malwareName, clientLocation, clientIp, riskReasons. For more information about riskReasons and possible values, see .                                                                                                                                                                                                                          | flattened        |
  | azure.identityprotection.properties.correlation_id             | Correlation ID of the sign-in associated with the risk detection. This property is null if the risk detection is not associated with a sign-in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.identityprotection.properties.cross_tenant_access_type   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.identityprotection.properties.detected_datetime          | Date and time that the risk was detected. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 looks like this: 2014-01-01T00:00:00Z.                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | azure.identityprotection.properties.detection_timing_type      | Timing of the detected risk (real-time/offline). Possible values are: notDefined, realtime, nearRealtime, offline, unknownFutureValue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | azure.identityprotection.properties.home_tenant_id             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.identityprotection.properties.id                         | Unique ID of the risk detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | azure.identityprotection.properties.ip_address                 | Provides the IP address of the client from where the risk occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | azure.identityprotection.properties.is_deleted                 | Indicates whether the user is deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | boolean          |
  | azure.identityprotection.properties.is_guest                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | azure.identityprotection.properties.is_processing              | Indicates whether a user's risky state is being processed by the backend.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | azure.identityprotection.properties.last_updated_datetime      | Date and time when the risk detection was last updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | azure.identityprotection.properties.location                   | Location of the sign-in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | flattened        |
  | azure.identityprotection.properties.request_id                 | Request ID of the sign-in associated with the risk detection. This property is null if the risk detection is not associated with a sign-in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | azure.identityprotection.properties.resource_tenant_id         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.identityprotection.properties.risk_detail                | Details of the detected risk. Possible values are: none, adminGeneratedTemporaryPassword, userPerformedSecuredPasswordChange, userPerformedSecuredPasswordReset, adminConfirmedSigninSafe, aiConfirmedSigninSafe, userPassedMFADrivenByRiskBasedPolicy, adminDismissedAllRiskForUser, adminConfirmedSigninCompromised, hidden, adminConfirmedUserCompromised, unknownFutureValue.                                                                                                                                                                                                                                 | keyword          |
  | azure.identityprotection.properties.risk_event_type            | The type of risk event detected. The possible values are unlikelyTravel, anonymizedIPAddress, maliciousIPAddress, unfamiliarFeatures, malwareInfectedIPAddress, suspiciousIPAddress, leakedCredentials, investigationsThreatIntelligence, generic,adminConfirmedUserCompromised, passwordSpray, impossibleTravel, newCountry, anomalousToken, tokenIssuerAnomaly,suspiciousBrowser, riskyIPAddress, mcasSuspiciousInboxManipulationRules, suspiciousInboxForwarding, and unknownFutureValue. If the risk detection is a premium detection, will show generic. For more information about each value, see  values. | keyword          |
  | azure.identityprotection.properties.risk_last_updated_datetime | The date and time that the risky user was last updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | azure.identityprotection.properties.risk_level                 | Level of the detected risk. Possible values are: low, medium, high, hidden, none, unknownFutureValue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.identityprotection.properties.risk_state                 | The state of a detected risky user or sign-in. Possible values are: none, confirmedSafe, remediated, dismissed, atRisk, confirmedCompromised, unknownFutureValue.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | azure.identityprotection.properties.risk_type                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | azure.identityprotection.properties.source                     | Source of the risk detection. For example, activeDirectory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | azure.identityprotection.properties.token_issuer_type          | Indicates the type of token issuer for the detected sign-in risk. Possible values are: AzureAD, ADFederationServices, UnknownFutureValue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | azure.identityprotection.properties.user_display_name          | The user display name of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | azure.identityprotection.properties.user_id                    | Unique ID of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | azure.identityprotection.properties.user_principal_name        | The user principal name (UPN) of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | azure.identityprotection.properties.user_type                  | The type of the user (for example, "member").                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | azure.identityprotection.result_signature                      | Result signature                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | azure.resource.group                                           | Resource group                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | azure.resource.id                                              | Resource ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | azure.resource.name                                            | Name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | azure.resource.namespace                                       | Resource type/namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | azure.resource.provider                                        | Resource type/namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | azure.subscription_id                                          | Azure subscription ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | azure.tenant_id                                                | tenant ID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | cloud.image.id                                                 | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset                                            | Data stream dataset name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                                          | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.type                                               | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.dataset                                                  | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | event.module                                                   | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | geo.city_name                                                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | geo.continent_name                                             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | geo.country_iso_code                                           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | geo.country_name                                               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | geo.location                                                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | geo_point        |
  | geo.name                                                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | geo.region_iso_code                                            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | geo.region_name                                                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.containerized                                             | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | boolean          |
  | host.os.build                                                  | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.codename                                               | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


### Provisioning logs

Retrieves Microsoft Entra ID Provisioning logs. The [Microsoft Entra ID Provisioning](https://docs.microsoft.com/en-us/azure/active-directory/app-provisioning/how-provisioning-works) service syncs Microsoft Entra ID users and groups to and from external enterprise applications. For example, you can configure the provisioning service to replicate all existing Microsoft Entra ID users and groups to an external Dropbox Business account or vice versa.
The Provisioning Logs contain a lot of details about a inbound/outbound sync activity, like:
- User or group details.
- Source and target systems (for ex., from Microsoft Entra ID to Dropbox).
- Provisioning status.
- Provisioning steps (with details for each step).

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-08-23T13:36:50.353Z",
      "azure": {
          "correlation_id": "54416401-eef2-461c-8de7-385dde2b3cba",
          "provisioning": {
              "category": "ProvisioningLogs",
              "identity": "d6cbb0bd-c3ec-6455-bd3e-4282141ce369",
              "level": 4,
              "operation_name": "Provisioning activity",
              "operation_version": "1.0",
              "properties": {
                  "action": "Create",
                  "activity_datetime": "2022-08-23T13:36:50.3538931Z",
                  "change_id": "54416401-eef2-461c-8de7-385dde2b3cba",
                  "cycle_id": "cc305635-a28e-4139-a056-42b5102933fe",
                  "duration_ms": 828,
                  "id": "d6cbb0bd-c3ec-6455-bd3e-4282141ce369",
                  "initiated_by": {
                      "id": "",
                      "name": "Azure AD Provisioning Service",
                      "type": "system"
                  },
                  "job_id": "DropboxSCIMOutDelta.5611623b9128461e9d7fa0d9c270ead2.d6163622-bdf8-4b26-976f-7d573c638e2a",
                  "modified_properties": [],
                  "provisioning_action": "create",
                  "provisioning_status_info": {
                      "status": "skipped"
                  },
                  "provisioning_steps": [
                      {
                          "description": "Received User 'ellie@contoso.onmicrosoft.com' change of type (Add) from Azure Active Directory",
                          "details": {
                              "IsSoftDeleted": "False",
                              "accountEnabled": "True",
                              "appRoleAssignments": "User",
                              "displayName": "Ellie",
                              "givenName": "Ellie",
                              "mailNickname": "ellie",
                              "objectId": "7383d412-41f2-478f-a317-7396cc32ce9e",
                              "userPrincipalName": "ellie@contoso.onmicrosoft.com"
                          },
                          "name": "EntryImportAdd",
                          "provisioning_step_type": 0,
                          "status": 0
                      },
                      {
                          "description": "Determine if User in scope by evaluating against each scoping filter",
                          "details": {
                              "Active in the source system": "True",
                              "Assigned to the application": "True",
                              "ScopeEvaluationResult": "{}",
                              "Scoping filter evaluation passed": "True",
                              "User has the required role": "True"
                          },
                          "name": "EntrySynchronizationScoping",
                          "provisioning_step_type": 1,
                          "status": 0
                      },
                      {
                          "description": "User 'ellie@contoso.onmicrosoft.com' will be created in Dropbox (User is active and assigned in Azure Active Directory, but no matching User was found in Dropbox)",
                          "details": {},
                          "name": "EntrySynchronizationAdd",
                          "provisioning_step_type": 2,
                          "status": 0
                      },
                      {
                          "description": "urn:ietf:params:scim:schemas:core:2.0:User 'ellie@contoso.onmicrosoft.com' will be skipped because the value of the property name.familyName is missing or invalid. Please update the value of the property name.familyName on the object in the source system.",
                          "details": {
                              "PropertyName": "name.familyName",
                              "ReportableIdentifier": "ellie@contoso.onmicrosoft.com",
                              "SkipReason": "AttributeValidationFailed"
                          },
                          "name": "EntrySynchronizationSkip",
                          "provisioning_step_type": 3,
                          "status": 2
                      }
                  ],
                  "service_principal": {
                      "id": "74866461-3754-40ed-a743-9c88ff29643e",
                      "name": "Dropbox Business"
                  },
                  "source_identity": {
                      "details": {
                          "display_name": "Ellie",
                          "id": "7383d412-41f2-478f-a317-7396cc32ce9e",
                          "odatatype": "User",
                          "user_principal_name": "ellie@contoso.onmicrosoft.com"
                      },
                      "id": "7383d412-41f2-478f-a317-7396cc32ce9e",
                      "identity_type": "User",
                      "name": "Ellie"
                  },
                  "source_system": {
                      "details": {},
                      "id": "bab3751f-8f21-4657-8fce-698f7391dbdd",
                      "name": "Azure Active Directory"
                  },
                  "target_identity": {
                      "details": {},
                      "id": "",
                      "identity_type": "urn:ietf:params:scim:schemas:core:2.0:User",
                      "name": ""
                  },
                  "target_system": {
                      "details": {
                          "application_id": "97e0a159-74ec-4db1-918a-c03a9c3b6b81",
                          "dervice_principal_display_name": "Dropbox Business",
                          "service_principal_id": "74866461-3754-40ed-a743-9c88ff29643e"
                      },
                      "id": "011a448f-1441-4336-8c20-e2d2cef9c410",
                      "name": "Dropbox"
                  },
                  "tenant_id": "5611623b-9128-461e-9d7f-a0d9c270ead2"
              },
              "result_type": "Skipped"
          },
          "resource": {
              "id": "/tenants/5611623b-9128-461e-9d7f-a0d9c270ead2/providers/Microsoft.aadiam",
              "provider": "Microsoft.aadiam"
          },
          "tenant_id": "5611623b-9128-461e-9d7f-a0d9c270ead2"
      },
      "cloud": {
          "provider": "azure"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "event": {
          "action": "Provisioning activity",
          "duration": 828000000,
          "kind": "event"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                                       | Description                                                                                                                                                                                                                                            | Type             |
  |---------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                  | Event timestamp.                                                                                                                                                                                                                                       | date             |
  | azure.correlation_id                                                                        | Correlation ID                                                                                                                                                                                                                                         | keyword          |
  | azure.provisioning.category                                                                 | Category                                                                                                                                                                                                                                               | keyword          |
  | azure.provisioning.identity                                                                 | Describes the identity of the user or application that performed the operation                                                                                                                                                                         | keyword          |
  | azure.provisioning.level                                                                    | The severity level of the event                                                                                                                                                                                                                        | long             |
  | azure.provisioning.operation_name                                                           | Operation name                                                                                                                                                                                                                                         | keyword          |
  | azure.provisioning.operation_version                                                        | Operation version                                                                                                                                                                                                                                      | keyword          |
  | azure.provisioning.properties.action                                                        | Indicates the activity name or the operation name.                                                                                                                                                                                                     | keyword          |
  | azure.provisioning.properties.activity_datetime                                             | Indicates the date and time the activity was performed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z' | date             |
  | azure.provisioning.properties.change_id                                                     | Unique ID of this change in this cycle                                                                                                                                                                                                                 | keyword          |
  | azure.provisioning.properties.cycle_id                                                      | Unique ID per job iteration                                                                                                                                                                                                                            | keyword          |
  | azure.provisioning.properties.duration_ms                                                   | Indicates how long this provisioning action took to finish. Measured in milliseconds.                                                                                                                                                                  | long             |
  | azure.provisioning.properties.id                                                            | Indicates the unique ID for the activity                                                                                                                                                                                                               | keyword          |
  | azure.provisioning.properties.initiated_by.id                                               | Uniquely identifies the person or service that initiated the provisioning event.                                                                                                                                                                       | keyword          |
  | azure.provisioning.properties.initiated_by.name                                             | Name of the person or service that initiated the provisioning event.                                                                                                                                                                                   | keyword          |
  | azure.provisioning.properties.initiated_by.type                                             | Type of initiator. Possible values are: user, application, system, unknownFutureValue.                                                                                                                                                                 | keyword          |
  | azure.provisioning.properties.job_id                                                        | The unique ID for the whole provisioning job.                                                                                                                                                                                                          | keyword          |
  | azure.provisioning.properties.modified_properties                                           | Details of each property that was modified in this provisioning action on this object.                                                                                                                                                                 | flattened        |
  | azure.provisioning.properties.provisioning_action                                           | Indicates the activity name or the operation name. Possible values are: create, update, delete, stageddelete, disable, other and unknownFutureValue. For a list of activities logged, refer to Microsoft Entra ID activity list.                       | keyword          |
  | azure.provisioning.properties.provisioning_status_info.error_information.additional_details | Additional details in case of error.                                                                                                                                                                                                                   | keyword          |
  | azure.provisioning.properties.provisioning_status_info.error_information.error_category     | Categorizes the error code. Possible values are failure, nonServiceFailure, success, unknownFutureValue.                                                                                                                                               | keyword          |
  | azure.provisioning.properties.provisioning_status_info.error_information.error_code         | Unique error code if any occurred. To learn more, visit                                                                                                                                                                                                | keyword          |
  | azure.provisioning.properties.provisioning_status_info.error_information.reason             | Summarizes the status and describes why the status happened.                                                                                                                                                                                           | keyword          |
  | azure.provisioning.properties.provisioning_status_info.error_information.recommended_action | Provides the resolution for the corresponding error.                                                                                                                                                                                                   | keyword          |
  | azure.provisioning.properties.provisioning_status_info.status                               | Possible values are: success, warning, failure, skipped, unknownFutureValue.                                                                                                                                                                           | keyword          |
  | azure.provisioning.properties.provisioning_steps.description                                | Summary of what occurred during the step.                                                                                                                                                                                                              | keyword          |
  | azure.provisioning.properties.provisioning_steps.details                                    | Details of what occurred during the step.                                                                                                                                                                                                              | flattened        |
  | azure.provisioning.properties.provisioning_steps.name                                       | Name of the step.                                                                                                                                                                                                                                      | keyword          |
  | azure.provisioning.properties.provisioning_steps.provisioning_step_type                     | Type of step.                                                                                                                                                                                                                                          | long             |
  | azure.provisioning.properties.provisioning_steps.status                                     | Status of the step.                                                                                                                                                                                                                                    | long             |
  | azure.provisioning.properties.service_principal.id                                          | Uniquely identifies the servicePrincipal used for provisioning.                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.service_principal.name                                        | Customer-defined name for the servicePrincipal.                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.source_identity.details                                       | Details of the identity.                                                                                                                                                                                                                               | flattened        |
  | azure.provisioning.properties.source_identity.id                                            | Uniquely identifies the identity.                                                                                                                                                                                                                      | keyword          |
  | azure.provisioning.properties.source_identity.identity_type                                 | Type of identity that has been provisioned, such as 'user' or 'group'.                                                                                                                                                                                 | keyword          |
  | azure.provisioning.properties.source_identity.name                                          | Display name of the identity.                                                                                                                                                                                                                          | keyword          |
  | azure.provisioning.properties.source_system.details.application_id                          |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.source_system.details.dervice_principal_display_name          |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.source_system.details.service_principal_id                    |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.source_system.id                                              | Identifier of the system that a user was provisioned to or from.                                                                                                                                                                                       | keyword          |
  | azure.provisioning.properties.source_system.name                                            | Name of the system that a user was provisioned to or from.                                                                                                                                                                                             | keyword          |
  | azure.provisioning.properties.target_identity.details                                       | Details of the identity.                                                                                                                                                                                                                               | flattened        |
  | azure.provisioning.properties.target_identity.id                                            | Uniquely identifies the identity.                                                                                                                                                                                                                      | keyword          |
  | azure.provisioning.properties.target_identity.identity_type                                 | Type of identity that has been provisioned, such as 'user' or 'group'.                                                                                                                                                                                 | keyword          |
  | azure.provisioning.properties.target_identity.name                                          | Display name of the identity.                                                                                                                                                                                                                          | keyword          |
  | azure.provisioning.properties.target_system.details.application_id                          |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.target_system.details.dervice_principal_display_name          |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.target_system.details.service_principal_id                    |                                                                                                                                                                                                                                                        | keyword          |
  | azure.provisioning.properties.target_system.id                                              | Identifier of the system that a user was provisioned to or from.                                                                                                                                                                                       | keyword          |
  | azure.provisioning.properties.target_system.name                                            | Name of the system that a user was provisioned to or from.                                                                                                                                                                                             | keyword          |
  | azure.provisioning.properties.tenant_id                                                     | Unique Microsoft Entra ID tenant ID                                                                                                                                                                                                                    | keyword          |
  | azure.provisioning.result_signature                                                         | Result signature                                                                                                                                                                                                                                       | keyword          |
  | azure.provisioning.result_type                                                              | Result type                                                                                                                                                                                                                                            | keyword          |
  | azure.provisioning.tenant_id                                                                | Unique Microsoft Entra ID tenant ID                                                                                                                                                                                                                    | keyword          |
  | azure.resource.group                                                                        | Resource group                                                                                                                                                                                                                                         | keyword          |
  | azure.resource.id                                                                           | Resource ID                                                                                                                                                                                                                                            | keyword          |
  | azure.resource.name                                                                         | Name                                                                                                                                                                                                                                                   | keyword          |
  | azure.resource.namespace                                                                    | Resource type/namespace                                                                                                                                                                                                                                | keyword          |
  | azure.resource.provider                                                                     | Resource type/namespace                                                                                                                                                                                                                                | keyword          |
  | azure.subscription_id                                                                       | Azure subscription ID                                                                                                                                                                                                                                  | keyword          |
  | azure.tenant_id                                                                             | tenant ID                                                                                                                                                                                                                                              | keyword          |
  | cloud.image.id                                                                              | Image ID for the cloud instance.                                                                                                                                                                                                                       | keyword          |
  | data_stream.dataset                                                                         | Data stream dataset name.                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.namespace                                                                       | Data stream namespace.                                                                                                                                                                                                                                 | constant_keyword |
  | data_stream.type                                                                            | Data stream type.                                                                                                                                                                                                                                      | constant_keyword |
  | event.dataset                                                                               | Event dataset                                                                                                                                                                                                                                          | constant_keyword |
  | event.module                                                                                | Event module                                                                                                                                                                                                                                           | constant_keyword |
  | geo.city_name                                                                               | City name.                                                                                                                                                                                                                                             | keyword          |
  | geo.continent_name                                                                          | Name of the continent.                                                                                                                                                                                                                                 | keyword          |
  | geo.country_iso_code                                                                        | Country ISO code.                                                                                                                                                                                                                                      | keyword          |
  | geo.country_name                                                                            | Country name.                                                                                                                                                                                                                                          | keyword          |
  | geo.location                                                                                | Longitude and latitude.                                                                                                                                                                                                                                | geo_point        |
  | geo.name                                                                                    | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.    | keyword          |
  | geo.region_iso_code                                                                         | Region ISO code.                                                                                                                                                                                                                                       | keyword          |
  | geo.region_name                                                                             | Region name.                                                                                                                                                                                                                                           | keyword          |
  | host.containerized                                                                          | If the host is a container.                                                                                                                                                                                                                            | boolean          |
  | host.os.build                                                                               | OS build information.                                                                                                                                                                                                                                  | keyword          |
  | host.os.codename                                                                            | OS codename, if any.                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### Audit logs

Retrieves Microsoft Entra ID audit logs. The audit logs provide traceability through logs for all changes done by various features within Microsoft Entra ID. Examples of audit logs include changes made to any resources within Microsoft Entra ID like adding or removing users, apps, groups, roles and policies.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-11-02T08:51:36.997Z",
      "azure.auditlogs.category": "AuditLogs",
      "azure.auditlogs.identity": "Device Registration Service",
      "azure.auditlogs.operation_name": "Update device",
      "azure.auditlogs.operation_version": "1.0",
      "azure.auditlogs.properties.activity_datetime": "2019-10-18T15:30:51.0273716+00:00",
      "azure.auditlogs.properties.activity_display_name": "Update device",
      "azure.auditlogs.properties.category": "Device",
      "azure.auditlogs.properties.correlation_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
      "azure.auditlogs.properties.id": "Directory_ESQ",
      "azure.auditlogs.properties.initiated_by.app.displayName": "Device Registration Service",
      "azure.auditlogs.properties.initiated_by.app.servicePrincipalId": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
      "azure.auditlogs.properties.logged_by_service": "Core Directory",
      "azure.auditlogs.properties.operation_type": "Update",
      "azure.auditlogs.properties.result_reason": "",
      "azure.auditlogs.properties.target_resources.0.display_name": "LAPTOP-12",
      "azure.auditlogs.properties.target_resources.0.id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
      "azure.auditlogs.properties.target_resources.0.modified_properties.0.new_value": "\"\"",
      "azure.auditlogs.properties.target_resources.0.type": "Device",
      "azure.auditlogs.result_signature": "None",
      "azure.correlation_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
      "azure.resource.id": "/tenants/8a4de8b5-095c-47d0-a96f-a75130c61d53/providers/Microsoft.aadiam",
      "azure.resource.provider": "Microsoft.aadiam",
      "azure.tenant_id": "8a4de8b5-095c-47d0-a96f-a75130c61d53",
      "cloud": {
          "provider": "azure"
      },
      "data_stream": {
          "dataset": "azure.auditlogs",
          "namespace": "default",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "event": {
          "action": "MICROSOFT.RESOURCES/DEPLOYMENTS/WRITE",
          "dataset": "azure.auditlogs",
          "duration": 0,
          "ingested": "2020-10-30T20:47:48.123859400Z",
          "kind": "event",
          "outcome": "success"
      },
      "log": {
          "level": "Information"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                            | Description                                                                                                                                                                                                                                       | Type             |
  |----------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                       | Event timestamp.                                                                                                                                                                                                                                  | date             |
  | azure.auditlogs.category                                                         | The category of the operation.  Currently, Audit is the only supported value.                                                                                                                                                                     | keyword          |
  | azure.auditlogs.identity                                                         | Identity                                                                                                                                                                                                                                          | keyword          |
  | azure.auditlogs.level                                                            | Value for level.                                                                                                                                                                                                                                  | float            |
  | azure.auditlogs.operation_name                                                   | The operation name                                                                                                                                                                                                                                | keyword          |
  | azure.auditlogs.operation_version                                                | The operation version                                                                                                                                                                                                                             | keyword          |
  | azure.auditlogs.properties.activity_datetime                                     | Activity timestamp                                                                                                                                                                                                                                | date             |
  | azure.auditlogs.properties.activity_display_name                                 | Activity display name                                                                                                                                                                                                                             | keyword          |
  | azure.auditlogs.properties.additional_details.key                                | Additional details key                                                                                                                                                                                                                            | keyword          |
  | azure.auditlogs.properties.additional_details.user_agent                         | User agent name.                                                                                                                                                                                                                                  | keyword          |
  | azure.auditlogs.properties.additional_details.value                              | Additional details value                                                                                                                                                                                                                          | keyword          |
  | azure.auditlogs.properties.authentication_protocol                               | Authentication protocol type.                                                                                                                                                                                                                     | keyword          |
  | azure.auditlogs.properties.category                                              | category                                                                                                                                                                                                                                          | keyword          |
  | azure.auditlogs.properties.correlation_id                                        | Correlation ID                                                                                                                                                                                                                                    | keyword          |
  | azure.auditlogs.properties.id                                                    | ID                                                                                                                                                                                                                                                | keyword          |
  | azure.auditlogs.properties.initiated_by.app.appId                                | App ID                                                                                                                                                                                                                                            | keyword          |
  | azure.auditlogs.properties.initiated_by.app.displayName                          | Display name                                                                                                                                                                                                                                      | keyword          |
  | azure.auditlogs.properties.initiated_by.app.servicePrincipalId                   | Service principal ID                                                                                                                                                                                                                              | keyword          |
  | azure.auditlogs.properties.initiated_by.app.servicePrincipalName                 | Service principal name                                                                                                                                                                                                                            | keyword          |
  | azure.auditlogs.properties.initiated_by.user.displayName                         | Display name                                                                                                                                                                                                                                      | keyword          |
  | azure.auditlogs.properties.initiated_by.user.id                                  | ID                                                                                                                                                                                                                                                | keyword          |
  | azure.auditlogs.properties.initiated_by.user.ipAddress                           | ip Address                                                                                                                                                                                                                                        | keyword          |
  | azure.auditlogs.properties.initiated_by.user.roles                               | User roles                                                                                                                                                                                                                                        | keyword          |
  | azure.auditlogs.properties.initiated_by.user.userPrincipalName                   | User principal name                                                                                                                                                                                                                               | keyword          |
  | azure.auditlogs.properties.logged_by_service                                     | Logged by service                                                                                                                                                                                                                                 | keyword          |
  | azure.auditlogs.properties.operation_type                                        | Operation type                                                                                                                                                                                                                                    | keyword          |
  | azure.auditlogs.properties.result                                                | Log result                                                                                                                                                                                                                                        | keyword          |
  | azure.auditlogs.properties.result_reason                                         | Reason for the log result                                                                                                                                                                                                                         | keyword          |
  | azure.auditlogs.properties.target_resources.*.display_name                       | Display name                                                                                                                                                                                                                                      | keyword          |
  | azure.auditlogs.properties.target_resources.*.id                                 | ID                                                                                                                                                                                                                                                | keyword          |
  | azure.auditlogs.properties.target_resources.*.ip_address                         | ip Address                                                                                                                                                                                                                                        | keyword          |
  | azure.auditlogs.properties.target_resources.*.modified_properties.*.display_name | Display value                                                                                                                                                                                                                                     | keyword          |
  | azure.auditlogs.properties.target_resources.*.modified_properties.*.new_value    | New value                                                                                                                                                                                                                                         | keyword          |
  | azure.auditlogs.properties.target_resources.*.modified_properties.*.old_value    | Old value                                                                                                                                                                                                                                         | keyword          |
  | azure.auditlogs.properties.target_resources.*.type                               | Type                                                                                                                                                                                                                                              | keyword          |
  | azure.auditlogs.properties.target_resources.*.user_principal_name                | User principal name                                                                                                                                                                                                                               | keyword          |
  | azure.auditlogs.result_description                                               | Result description                                                                                                                                                                                                                                | keyword          |
  | azure.auditlogs.result_signature                                                 | Result signature                                                                                                                                                                                                                                  | keyword          |
  | azure.auditlogs.tenant_id                                                        | Tenant ID                                                                                                                                                                                                                                         | keyword          |
  | azure.correlation_id                                                             | Correlation ID                                                                                                                                                                                                                                    | keyword          |
  | azure.resource.authorization_rule                                                | Authorization rule                                                                                                                                                                                                                                | keyword          |
  | azure.resource.group                                                             | Resource group                                                                                                                                                                                                                                    | keyword          |
  | azure.resource.id                                                                | Resource ID                                                                                                                                                                                                                                       | keyword          |
  | azure.resource.name                                                              | Name                                                                                                                                                                                                                                              | keyword          |
  | azure.resource.namespace                                                         | Resource type/namespace                                                                                                                                                                                                                           | keyword          |
  | azure.resource.provider                                                          | Resource type/namespace                                                                                                                                                                                                                           | keyword          |
  | azure.subscription_id                                                            | Azure subscription ID                                                                                                                                                                                                                             | keyword          |
  | azure.tenant_id                                                                  | tenant ID                                                                                                                                                                                                                                         | keyword          |
  | cloud.image.id                                                                   | Image ID for the cloud instance.                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset                                                              | Data stream dataset name.                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                                                            | Data stream namespace.                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.type                                                                 | Data stream type.                                                                                                                                                                                                                                 | constant_keyword |
  | event.dataset                                                                    | Event dataset                                                                                                                                                                                                                                     | constant_keyword |
  | event.module                                                                     | Event module                                                                                                                                                                                                                                      | constant_keyword |
  | geo.city_name                                                                    | City name.                                                                                                                                                                                                                                        | keyword          |
  | geo.continent_name                                                               | Name of the continent.                                                                                                                                                                                                                            | keyword          |
  | geo.country_iso_code                                                             | Country ISO code.                                                                                                                                                                                                                                 | keyword          |
  | geo.country_name                                                                 | Country name.                                                                                                                                                                                                                                     | keyword          |
  | geo.location                                                                     | Longitude and latitude.                                                                                                                                                                                                                           | geo_point        |
  | host.containerized                                                               | If the host is a container.                                                                                                                                                                                                                       | boolean          |
  | host.os.build                                                                    | OS build information.                                                                                                                                                                                                                             | keyword          |
  | host.os.codename                                                                 | OS codename, if any.                                                                                                                                                                                                                              | keyword          |
  | related.entity                                                                   | All the entity identifiers related to the document. If the document contains multiple entities, identifiers belonging to different entities will be present. Example identifiers include cloud resource IDs, ARNs, email addresses, or hostnames. | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![filebeat azure overview](https://epr.elastic.co/package/azure/1.35.1/img/filebeat-azure-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.35.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17027))Fix pipeline error when the `category` field is missing.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.49.1.108.19.10     |
  | **1.35.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16955))Add support for AMQP-over-WebSockets transport protocol and proxy configuration.                                                                                                                                                                                                                                                                                                                                                                                                        | 9.2.49.1.108.19.10     |
  | **1.34.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16674))Fix `durationMs` parsing in auditlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.34.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16618))Switch default processor version to v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16610))Support log event routing overrides in Azure Logs v2.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.15.1            |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15807))Update Events v2 routing of `signinlogs` and `springcloud` logs.                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16328))Expand date formats for parsing time fields: ISO8601, `M/d/yyyy h:mm:ss a XXX`, `M/d/yyyy h:mm:ss a`, `M/d/yyyy H:mm:ss`, `yyyy-MM-ddTH:mm:ss.SSSZ`.                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.31.0** | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16395))Remove `destination.ip` and `destination.port` mapping of `TranslatedIp` and `TranslatedPort`.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16395))Add `destination.ip` to `destination.address` and `source.ip` to `source.address`.Add `TranslatedIp` and `TranslatedPort` to `destination.nat.ip` and `destination.nat.port`.Update event type mappings for AZFWNetworkRule and AZFWApplicationRule categories in firewall_logs data stream. | 9.0.08.15.1            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15900))Add processor version options for the Raw Events (v1) integration.                                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15976))Update `time` formats parsing and fix `durationMs` parsing in signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.15.1            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15690))Parse responseBody and requestBody json in activitylogs.                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.7** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15205))Interim fix to support non-standard log events.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.28.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15203))Add FAQ section to Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.15.1            |
  | **1.28.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14986))Add support to override `Endpoint Suffix` based on deployment environment.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.15.1            |
  | **1.28.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14961))Workaround the invalid field names from Azure Native ISV                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.28.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14959))Handle invalid log events (empty fields and properties as string) from Azure services.                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.15.1            |
  | **1.28.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14926))Fix Azure platformlogs ingest pipeline for function app logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.15.1            |
  | **1.28.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14415))Support routing with invalid fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.15.1            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14068))Add a flag `fips_compatible` to control whether the package is allowed in the ECH FedRAMP High environment.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13920))Add missing pattern for DNAT request messages for `AzureFirewallNetworkRuleLog` in firewall_logs data stream.                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.15.1            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.15.1            |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13922))Fix dashboard link.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.15.1            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14085))Standardize user fields for identity_protection and signinlogs data stream.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.15.1            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13921))Add Grok processor for `AzureFirewallThreatIntelLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13931))Set `service.id`, `device.id`, `user.id`, `session.id`, and `token.id` in graphactivitylogs dataset.                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.15.1            |
  | **1.23.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13863))Improve Azure logs documentation with more details on log categories routing rules.                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13882))Fix Grok processor error in ingest pipeline for `AzureFirewallNetworkRuleLog` in `azure.firewall_logs`.                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.15.1            |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13439))Map `azure.signinlogs.properties.location.state` field to `geo.region_name` instead of `geo.country_name`.                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.15.1            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12802))Enable Event Hub processor v2.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.15.1            |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12735))Fix Platform Logs pipeline inconsistent casing for subscription_id field.                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12926))Fix the custom storage container description for the Azure Logs integration v2.                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12641))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.20.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12233))Fix casting & naming issues in Graph Activity Logs related to the `event.duration` field.                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12047))Fix string literals in painless scripts.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11984))Add Azure Logs integration v2 (preview)                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.19.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11749))Fix destination.geo.region_name mapping.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.19.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11765))Rename the `Identity` field to `identity` for consistency.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.19.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11732))Rename the `properties` field to `properties.raw` to avoid parse errors when the `properties` field contains a string.                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11660))Fix an error and clarify the docs about the Storage Account container.                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11344))Add entity identifiers to `related.entity`.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10007))Add `event.reason` log field for exact data found in requests that matches a firewall rule.                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11102))Fix [client|source].geo.location ECS field mapping                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10984))Add new section on Azure Functions hosting plans.                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10379))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10583))Expand docs with more details on the Event Hub partitions configuration.                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9428))Add structured log categories to Azure Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10224))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/10224))Updated "event.outcome" values from "Succeeded" to "success" and "Failed" to "failure".                                                                                                                  | 8.13.0                 |
  | **1.11.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9774))Replace Azure AD with Microsoft Entra ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.12.0                 |
  | **1.11.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9701))Update Azure Audit Logs pipeline with support for initiated_by user fields.                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9738))Add missing ECS field definitions.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.11.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9258))Update description for event hub parameter name recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.12.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9554))Use ecs definition of the 'event.dataset' field for eventhub                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9314))Add Microsoft Graph Activity Logs                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.9.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9158))Add docs for running the integration behind a firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9159))Set field type to password on secret fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9022))Add support for integration secrets                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8813))Add caller_ip_address field in pipeline for Azure sign-in logs.                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.0                  |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8666))Update Azure logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8275))Update AD Logs documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.8.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8432))Allow rerouting of Azure logs events to a different data stream.                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8192))Rebrand Azure Spring Cloud Logs to Azure Spring Apps                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8050))Update the package format_version to 3.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.33** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7995))Handle `json.properties.clientIp` as an alias of `json.properties.clientIP` in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.32** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7979))Fix mappings for `azure.activitylogs.claims.*`.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.31** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7376))Migration of Azure AD Identity Protection dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.30** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7375))Migration of Azure AD Provisioning Logs dashboard to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.6.0                  |
  | **1.5.29** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7525))Fix Azure dashboards descriptions and titles.                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.28** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Migration Alerts Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                  |
  | **1.5.27** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6960))Fix in Firewall dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                  |
  | **1.5.26** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6867))Handle duplicate user_agent.original field in signinlogs logs                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                  |
  | **1.5.25** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6866))Handle duplicate url.path field in application gateway logs                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.24** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6824))Handle firewall events for DNAT'ed requests with attributes                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.23** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6624))Update Azure Logs screenshot                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.22** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6501))Migration of Azure Cloud Overview dashboard to Lens and style changes                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                  |
  | **1.5.21** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6503))Migration of User Activity Dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                  |
  | **1.5.20** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6357))Integration settings UI for sanitization                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                  |
  | **1.5.17** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6432))Migration of Spring Cloud Overview dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.5.16** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6435))Migration of Azure Spring Cloud Logs Application Cloud Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **1.5.15** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6397))Migration of Spring Cloud System Logs dashboard to Lens                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **1.5.14** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5954))Enhancement/Improving performance of the dashboards                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                  |
  | **1.5.13** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5604))Extend the Storage Account container documentation and add link to requiements and setup instructions                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.12** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.5.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5382))Add a new message format to the AzureFirewallNetworkRule log category                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.10** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5361))Check for 'event.original' already existing in Application Gateway and Event Hub ingest pipelines                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.5.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5334))Check for 'event.original' already existing in firewall logs ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.5.8**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5290))Add `storage_account_container` option to the Application Gateway integration                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5129))Fix parsing of authentication_processing_details field in signin logs                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5073))Fix parsing error client port is blank and adjust for timeStamp                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4629))Rename identity as identity_name when the value is a string                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.5.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4476))Enable Event Hub integration by default and improve documentation                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4373))Data streams start as disabled on new installs                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4384))Fix PR link in changelog                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4382))Fix documentations formatting (remove extra 'Overview' heading)                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3892))Add Azure Application Gatewaty data stream                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4300))Update Azure Logs documentation                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4149))Add two new data streams to the Azure AD logs integration: Azure Identity Protection logs and Provisioning logs                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3877))Add the possibility to override the default generated storage account container                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.0            |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3805))Update docs with recommended Event Hub configuration                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3679))Fix Azure Sign-in logs ingest pipeline bug                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3578))Support Azure firewall logs                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.1.11** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3639))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **1.1.10** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3072))Update readme with links to Microsoft documentation                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.9**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3411))Improve handling of IPv6 IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3209))Update docs with details about Event Hub name recommendations                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.1.7**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3211))Add geo.name and result_description fields in platformlogs                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.1.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Fix azure.activitylogs.identity with a a concrete value**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3019))Add identity_name, tenant_id, level and operation_version into activity logs                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.1.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2891))Fix `event.duration` field mapping conflict in all Azure data streams.                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2822))Added the `forwarded` tag by default to all log types.                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Add device_detail.is_compliant and device_detail.is_managed fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2843))Change authentication_requirement_policies to flattened type                                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflict in the auditlogs data stream for `client.ip`. Changed `azure-eventhub.offset` and `azure-eventhub.sequence_number` to longs from keyword in the eventhub data stream.                                                                                                                                                                                                                                                                                             |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2682))Support new Azure audit logs and signin logs                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2547))Remove beta release tag from data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2528))Move azure package to GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **0.12.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2479))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.12.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2174))Release azure package for v8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1894))Add Azure Event Hub Input                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2005))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1721))signinlogs - Add support for ManagedIdentitySignInLogs, NonInteractiveUserSignInLogs, and ServicePrincipalSignInLogs.                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.9.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1870))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1798))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1688))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1644))Add ECS `client.ip` mapping                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.8.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1542))Update docs and logo                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1466))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.8.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1521))Import geo_points from ECS                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **0.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1514))Update error message                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1462))Add support for springcloud logs inside the platformlogs pipeline                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1455))Import ECS field definitions                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1355))Add spring cloud logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1372))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **0.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1353))Re-add pipeline changes for invalid json                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1051))Add input groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1238))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1121))sync package with module changes                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1113))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/835))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/741))Add check for empty configuration options.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/722))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/272))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
</dropdown>