﻿---
title: AWS Web Application Firewall (WAF) Logs OpenTelemetry Assets
description: The AWS WAF OpenTelemetry Assets allow you to monitor Amazon WAF logs. With AWS WAF, you can protect your web applications from common exploits and monitor...
url: https://www.elastic.co/docs/reference/integrations/aws_waf_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# AWS Web Application Firewall (WAF) Logs OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The AWS WAF Logs OpenTelemetry Assets integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The AWS WAF OpenTelemetry Assets allow you to monitor [Amazon WAF logs](https://aws.amazon.com/waf/). With AWS WAF, you can protect your web applications from common exploits and monitor detailed logs of each web request inspected, including its action (allow, block, count), source, and matching rules.
The [EDOT Cloud Forwarder for AWS](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws) enables you to collect **WAF Logs** from Amazon S3 and forward them directly into Elastic Observability. Use this integration to visualize that data in Kibana, create alerts to notify you if something goes wrong, and reference logs when troubleshooting an issue.

## What do I need to use this integration?

You need an Elastic Observability project (**Serverless only**) for storing, analyzing, and visualizing your WAF logs.
From the AWS side, to collect WAF logs, you need:
- An S3 bucket for storing logs
- AWS WAF logging enabled on your Web ACL to send logs to the S3 bucket


## How do I deploy this integration?

For step-by-step instructions on how to set up an EDOT Cloud Forwarder for AWS, refer to the
[EDOT Cloud Forwarder for AWS](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws) guide.

## Logs Reference

For a complete list of all available logs and their detailed descriptions, refer to:
- [AWS WAF Logging Fields documentation](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html)
- [OpenTelemetry AWS Logs encoding extension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/encoding/awslogsencodingextension#aws-waf-log-record-fields)


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![AWS WAF Logs dashboard screenshot](https://epr.elastic.co/package/aws_waf_otel/0.1.0/img/screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                 | Minimum Kibana version |
  |-----------|---------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15964))Initial draft of the AWS WAF Logs OpenTelemetry Assets package |                        |
</dropdown>