﻿---
title: AWS VPC Flow Logs OpenTelemetry Assets
description: This package contains Kibana assets for monitoring Amazon Virtual Private Cloud (Amazon VPC) flow logs. ECF is the simplest way to configure AWS VPC Flow...
url: https://www.elastic.co/docs/reference/integrations/aws_vpcflow_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# AWS VPC Flow Logs OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.1 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The AWS VPC Flow Logs OpenTelemetry Assets integration v0.1.1 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

This package contains Kibana assets for monitoring [Amazon Virtual Private Cloud (Amazon VPC) flow logs](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html).

## Supported data sources


### EDOT Cloud Forwarder (ECF) for AWS

ECF is the simplest way to configure AWS VPC Flow log collection. Refer to the [ECF for AWS documentation](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws) for full setup instructions.

### Standalone OTel Collector

Any OTel-supported collection method is supported provided the required extension is included.

#### Compatibility

This package has been tested with OpenTelemetry Collector version `0.138.0`. The OpenTelemetry components used are [awss3receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/awss3receiver#aws-s3-receiver), [awslogsencodingextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/encoding/awslogsencodingextension#aws-logs-encoding-extension), and [elasticsearchexporter](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/elasticsearchexporter#elasticsearch-exporter).

#### Sample configuration

```yaml
extensions:
  awslogs_encoding/vpcflow:
    format: vpcflow
    vpcflow:
      file_format: plain-text

receivers:
  awss3:
    sqs:
      queue_url: "<sqs-url>"
      region: "<region>"
    s3downloader:
      region: "<region>"
      s3_bucket: '<bucket_name>'
      s3_prefix: 'AWSLogs/<account-id>'
    encodings:
      - extension: awslogs_encoding/vpcflow

exporters:
  elasticsearch/otel:
    endpoints: https://<host>:<port>
    api_key: <api_key>

service:
  extensions: [awslogs_encoding/vpcflow]
  pipelines:
    logs:
      exporters: [elasticsearch/otel]
      receivers: [awss3]
```


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![AWS VPC Flow Logs dashboard screenshot](https://epr.elastic.co/package/aws_vpcflow_otel/0.1.1/img/screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                      | Minimum Kibana version |
  |-----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15844))Add "Alternative setup using awss3receiver" section to README       |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15402))Initial draft of the AWS VPC Flow Logs OpenTelemetry Assets Package |                        |
</dropdown>