﻿---
title: Amazon MQ
description: Amazon MQ is a fully managed message broker service that supports Apache ActiveMQ Classic and RabbitMQ, making it easy to set up and operate message brokers...
url: https://www.elastic.co/docs/reference/integrations/aws_mq
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Amazon MQ
|                                                                                                 |                                                                 |
|-------------------------------------------------------------------------------------------------|-----------------------------------------------------------------|
| **Version**                                                                                     | 0.11.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                         |
| **Ingestion method(s)**                                                                         | API, AWS CloudWatch                                             |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.5                                                     |

<admonition title="The Amazon MQ integration v0.11.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

[Amazon MQ](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/) is a fully managed message broker service that supports [Apache ActiveMQ](http://activemq.apache.org/) Classic and [RabbitMQ](https://www.rabbitmq.com/), making it easy to set up and operate message brokers in the cloud. It provides automated broker provisioning, maintenance, and scaling, allowing you to focus on building applications without managing the underlying infrastructure. With built-in security, reliability, and support for industry-standard messaging protocols, Amazon MQ enables seamless communication between distributed applications.
The Amazon MQ integration allows you to efficiently collect and monitor broker performance, queue activity, and message throughput by ingesting CloudWatch metrics into Elastic. This integration helps you gain deep insights into broker health, optimize message flow, and troubleshoot issues in real time.
<important>
  Extra AWS charges on API requests will be generated by this integration. Check [API Requests](https://www.elastic.co/docs/current/integrations/aws#aws-api-requests) for more details.
</important>


### Compatibility

This integration presently supports Amazon MQ for [Apache ActiveMQ](http://activemq.apache.org/) and [RabbitMQ](https://www.rabbitmq.com/).

## What data does this integration collect?

The Amazon MQ integration collects metrics and logs from Apache ActiveMQ and RabbitMQ.
Data streams:
- `activemq_general_logs`: Collects ActiveMQ general logs, including system events, warnings, and errors, which are published to a designated Amazon CloudWatch log group.
- `activemq_audit_logs`: Collects ActiveMQ audit logs, including management actions performed via JMX or the Web Console.
- `rabbitmq_general_logs`: Collects RabbitMQ general logs, including system events, warnings, errors, which are published to a designated Amazon CloudWatch log group.
- `activemq_metrics`: Collects broker metrics and destination (queue and topic) metrics.
- `rabbitmq_metrics`: Collects broker, queue and node metrics.


## What do I need to use this integration?

You need Elasticsearch for storing and searching your data and Kibana for
visualizing and managing it. You can use our hosted Elasticsearch Service on
Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your
own hardware.
Before using any Amazon MQ integration you will need:
- **AWS Credentials** to connect with your AWS account.
- **AWS Permissions** to make sure the user you're using to connect has
  permission to share the relevant data.

For more details about these requirements, check the [AWS
integration
documentation](https://docs.elastic.co/integrations/aws#requirements).
- Elastic Agent must be installed. For detailed guidance, follow these [instructions](https://www.elastic.co/guide/en/fleet/current/elastic-agent-installation.html).
- You can install only one Elastic Agent per host.
- Elastic Agent is required to stream data from the S3 bucket and ship the
  data to Elastic, where the events will then be processed through the
  integration's ingest pipelines.


## Setup


### ActiveMQ

To enable the `activemq_general_logs` and `activemq_audit_logs` integrations, you must configure your ActiveMQ broker to publish general logs and audit logs to Amazon CloudWatch Logs. Follow these steps:
1. **Assign Necessary Permissions**: Ensure the IAM user creating or managing the broker has the `logs:CreateLogGroup` permission. This allows Amazon MQ to create the required log groups in CloudWatch.
2. **Set Up a Resource-Based Policy**: Configure a policy that permits Amazon MQ to publish logs to your CloudWatch log groups. This involves granting `logs:CreateLogStream` and `logs:PutLogEvents` permissions.
3. **Enable Logging on the Broker**:
   - Navigate to the [Amazon MQ console](https://console.aws.amazon.com/amazon-mq/).
- During broker creation or by editing an existing broker, expand the **Additional settings** section.
- In the **Logs** section, select the option to publish **General logs** and **Audit logs** to Amazon CloudWatch Logs.

For detailed instructions, refer to the [Amazon MQ Developer Guide](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/configure-logging-monitoring-activemq.html#security-logging-monitoring-configure-cloudwatch-structure).

## Logs


### Collecting Amazon MQ ActiveMQ general logs and audit logs from CloudWatch


### ActiveMQ general logs

When general logging is enabled for your Amazon MQ ActiveMQ broker, it publishes the `activemq.log` file at the default `INFO` logging level to a designated log group. Please note that `DEBUG` logging is not supported.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-03-18T08:33:36.238Z",
      "activemq": {
          "log": {
              "caller": "org.apache.activemq.broker.TransportConnection",
              "thread": "ActiveMQ Transport: ssl:///127.0.0.1:61838"
          }
      },
      "agent": {
          "ephemeral_id": "dd516728-fd01-4a3a-a131-eb0f88e1787d",
          "id": "b440433a-e07d-4648-a88a-4f958e610109",
          "name": "elastic-agent-63969",
          "type": "filebeat",
          "version": "8.16.5"
      },
      "cloud": {
          "provider": "aws",
          "region": "ap-south-1",
          "service": {
              "name": "amazonmq_activemq"
          }
      },
      "data_stream": {
          "dataset": "aws_mq.activemq_general_logs",
          "namespace": "16292",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "b440433a-e07d-4648-a88a-4f958e610109",
          "snapshot": false,
          "version": "8.16.5"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "aws_mq.activemq_general_logs",
          "id": "38854294351682784631118767772200041229292324938090807296",
          "ingested": "2025-03-18T08:33:45Z",
          "type": [
              "error"
          ]
      },
      "input": {
          "type": "aws-cloudwatch"
      },
      "log": {
          "file": {
              "path": "arn:aws:logs:ap-south-1:627286350134:log-group:/aws/amazonmq/broker/b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4/general/activemq-b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4-1.log"
          },
          "level": "WARN"
      },
      "message": "Failed to add Connection id=ID:b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4-1-45943-1741903831778-5:46, clientId=ID:b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4-1-45943-1741903831778-5:46, clientIP=tcp://127.0.0.1:61838 due to User name [elastic] or password is invalid.",
      "tags": [
          "forwarded",
          "aws_mq-activemq-general-logs"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | activemq.log.caller    | Name of the caller issuing the logging request (class or resource).                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | activemq.log.thread    | Thread that generated the logging event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.cloudwatch.message | CloudWatch log message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | text             |
  | cloud.image.id         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset          | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.module           | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build          | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type             | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
</dropdown>


### ActiveMQ audit logs

When audit logging is enabled, ActiveMQ logs management actions performed via JMX or the ActiveMQ Web Console to a designated log group.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-03-19T14:09:28.434Z",
      "activemq": {
          "audit": {
              "thread": "qtp1169933615-14635"
          }
      },
      "agent": {
          "ephemeral_id": "9d06c8c6-9789-4c8a-b10e-9b5f189a50f7",
          "id": "e51aba85-fcc8-40fc-be18-b182b4122255",
          "name": "elastic-agent-43514",
          "type": "filebeat",
          "version": "8.16.5"
      },
      "cloud": {
          "provider": "aws",
          "region": "ap-south-1",
          "service": {
              "name": "amazonmq_activemq"
          }
      },
      "data_stream": {
          "dataset": "aws_mq.activemq_audit_logs",
          "namespace": "13109",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e51aba85-fcc8-40fc-be18-b182b4122255",
          "snapshot": false,
          "version": "8.16.5"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "aws_mq.activemq_audit_logs",
          "id": "38856670549337867603105755278009180321867411962028556288",
          "ingested": "2025-03-19T14:10:17Z",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "aws-cloudwatch"
      },
      "log": {
          "file": {
              "path": "arn:aws:logs:ap-south-1:123445678907:log-group:/aws/amazonmq/broker/b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4/audit/audit-b-cfab2617-b6fb-4a44-bd7a-052aa4cd96f4-1.log"
          },
          "level": "INFO"
      },
      "message": "called org.apache.activemq.broker.jmx.ConnectorView.connectionCount[] on openwire",
      "tags": [
          "forwarded",
          "aws_mq-activemq-audit-logs"
      ],
      "user": {
          "name": "anonymous"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | activemq.audit.thread  | Thread that generated the logging event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.cloudwatch.message | CloudWatch log message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | text             |
  | cloud.image.id         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset          | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.module           | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build          | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type             | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
</dropdown>


### RabbitMQ general logs

When you enable CloudWatch logging for your RabbitMQ brokers, Amazon MQ uses a service-linked role to publish general logs to CloudWatch. If no Amazon MQ service-linked role exists when you first create a broker, Amazon MQ will automatically create one. All subsequent RabbitMQ brokers will use the same service-linked role to publish logs to CloudWatch.
For more details, refer to [Configuring Amazon MQ for RabbitMQ logs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/rabbitmq-logging-monitoring.html?utm_source=chatgpt.com#security-logging-monitoring-rabbitmq).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-03-24T07:05:03.466Z",
      "agent": {
          "ephemeral_id": "a1907291-323c-468f-84e9-0d29e2fe66eb",
          "id": "5a2e2df8-150a-4601-9c3a-e16c359b7f07",
          "name": "elastic-agent-55927",
          "type": "filebeat",
          "version": "8.16.5"
      },
      "cloud": {
          "provider": "aws",
          "region": "ap-south-1",
          "service": {
              "name": "amazonmq_rabbitmq"
          }
      },
      "data_stream": {
          "dataset": "aws_mq.rabbitmq_general_logs",
          "namespace": "70014",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5a2e2df8-150a-4601-9c3a-e16c359b7f07",
          "snapshot": false,
          "version": "8.16.5"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "aws_mq.rabbitmq_general_logs",
          "id": "38865736601051462567581671325129317224302733980316794880",
          "ingested": "2025-03-24T07:06:06Z",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "aws-cloudwatch"
      },
      "log": {
          "file": {
              "path": "arn:aws:logs:ap-south-1:627286350134:log-group:/aws/amazonmq/broker/b-de6a011c-f307-4de0-acf0-e652e6005530/general/rabbit@localhost_general.log"
          },
          "level": "notice"
      },
      "message": "TLS server: In state hello at tls_handshake.erl:401 generated SERVER ALERT: Fatal - Protocol Version",
      "rabbitmq": {
          "log": {
              "pid": "<0.12141597.0>"
          }
      },
      "tags": [
          "forwarded",
          "aws_mq-rabbitmq-general-logs"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | aws.cloudwatch.message | CloudWatch log message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | text             |
  | cloud.image.id         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset          | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.module           | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build          | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type             | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | rabbitmq.log.pid       | The Erlang process id                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
</dropdown>


## Metrics


### ActiveMQ metrics

Amazon MQ for ActiveMQ provides a range of broker and queue metrics that help monitor system performance, resource utilization, and message flow. These metrics can be used for various use cases, including:
- Tracking broker resource utilization, such as compute, memory, and storage.
- Monitoring message throughput and queue performance.
- Identifying connection patterns and active consumers for optimizing messaging workloads.

The following metrics are related to [Amazon MQ quotas](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-limits.html). You can disable their collection by turning off **Collect ActiveMQ quota metrics** under **Advanced Options**:
- AmqpMaximumConnections
- MqttMaximumConnections
- OpenwireMaximumConnections
- StompMaximumConnections
- WsMaximumConnections

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-02-20T11:10:00.000Z",
      "agent": {
          "ephemeral_id": "9995e077-e2f3-4eec-b614-f786ea4f0599",
          "id": "0c953e96-08ac-45dd-9f3a-c31b310d3386",
          "name": "elastic-agent-24296",
          "type": "metricbeat",
          "version": "8.16.2"
      },
      "aws": {
          "amazonmq": {
              "metrics": {
                  "activemq": {
                      "broker": {
                          "AmqpMaximumConnections": {
                              "max": 300
                          },
                          "CpuCreditBalance": {
                              "min": 288
                          },
                          "CpuUtilization": {
                              "avg": 4
                          },
                          "CurrentConnectionsCount": {
                              "max": 0
                          },
                          "EstablishedConnectionsCount": {
                              "max": 0
                          },
                          "HeapUsage": {
                              "avg": 15
                          },
                          "InactiveDurableTopicSubscribersCount": {
                              "max": 0
                          },
                          "JobSchedulerStorePercentUsage": {
                              "avg": 0
                          },
                          "JournalFilesForFastRecovery": {
                              "max": 0
                          },
                          "JournalFilesForFullRecovery": {
                              "max": 1
                          },
                          "MqttMaximumConnections": {
                              "max": 300
                          },
                          "NetworkIn": {
                              "max": 226176
                          },
                          "NetworkOut": {
                              "max": 701286
                          },
                          "OpenTransactionCount": {
                              "max": 0
                          },
                          "OpenwireMaximumConnections": {
                              "max": 300
                          },
                          "StompMaximumConnections": {
                              "max": 300
                          },
                          "StorePercentUsage": {
                              "avg": 0
                          },
                          "TempPercentUsage": {
                              "avg": 0
                          },
                          "TotalConsumerCount": {
                              "max": 0
                          },
                          "TotalDequeueCount": {
                              "max": 0
                          },
                          "TotalEnqueueCount": {
                              "max": 0
                          },
                          "TotalMessageCount": {
                              "max": 2
                          },
                          "TotalProducerCount": {
                              "max": 0
                          },
                          "WsMaximumConnections": {
                              "max": 300
                          }
                      }
                  }
              }
          },
          "cloudwatch": {
              "namespace": "AWS/AmazonMQ"
          },
          "dimensions": {
              "Broker": "ObsIntegrations-ActiveMQ-1"
          }
      },
      "cloud": {
          "account": {
              "id": "11111111111111111",
              "name": "MonitoringAccount"
          },
          "provider": "aws",
          "region": "ap-south-1"
      },
      "data_stream": {
          "dataset": "aws_mq.activemq_metrics",
          "namespace": "60457",
          "type": "metrics"
      },
      "ecs": {
          "version": "8.0.0"
      },
      "elastic_agent": {
          "id": "0c953e96-08ac-45dd-9f3a-c31b310d3386",
          "snapshot": false,
          "version": "8.16.2"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "aws_mq.activemq_metrics",
          "duration": 130811705,
          "ingested": "2025-02-20T11:19:30Z",
          "module": "aws"
      },
      "host": {
          "architecture": "x86_64",
          "containerized": true,
          "hostname": "elastic-agent-24296",
          "ip": [
              "192.168.0.4",
              "192.168.144.2"
          ],
          "mac": [
              "02-42-C0-A8-00-04",
              "02-42-C0-A8-90-02"
          ],
          "name": "elastic-agent-24296",
          "os": {
              "family": "",
              "kernel": "5.4.0-1106-gcp",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "metricset": {
          "name": "cloudwatch",
          "period": 300000
      },
      "service": {
          "type": "aws"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                         | Description                                                                                                                                                                                                                     | Type             | Unit    | Metric Type |
  |-------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|---------|-------------|
  | @timestamp                                                                    | Event timestamp.                                                                                                                                                                                                                | date             |         |             |
  | agent.id                                                                      | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                      | keyword          |         |             |
  | aws.amazonmq.metrics.activemq.broker.AmqpMaximumConnections.max               | The maximum number of clients you can connect to your broker using AMQP.                                                                                                                                                        | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.BurstBalance.min                         | The percentage of burst credits remaining on the Amazon EBS volume used to persist message data for throughput-optimized brokers.                                                                                               | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.CpuCreditBalance.min                     | The number of earned CPU credits that an instance has accrued since it was launched or started.                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.CpuUtilization.avg                       | The percentage of allocated Amazon EC2 compute units that the broker currently uses.                                                                                                                                            | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.CurrentConnectionsCount.max              | The current number of active connections on the current broker.                                                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.EstablishedConnectionsCount.max          | The total number of connections, active and inactive, that have been established on the broker.                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.HeapUsage.avg                            | The percentage of the ActiveMQ JVM memory limit that the broker currently uses.                                                                                                                                                 | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.InactiveDurableTopicSubscribersCount.max | The number of inactive durable topic subscribers.                                                                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.JobSchedulerStorePercentUsage.avg        | The percentage of disk space used by the job scheduler store.                                                                                                                                                                   | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.JournalFilesForFastRecovery.max          | The number of journal files that will be replayed after a clean shutdown.                                                                                                                                                       | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.JournalFilesForFullRecovery.max          | The number of journal files that will be replayed after an unclean shutdown.                                                                                                                                                    | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.MqttMaximumConnections.max               | The maximum number of clients you can connect to your broker using MQTT.                                                                                                                                                        | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.NetworkConnectorConnectionCount.max      | The number of nodes connected to the broker in a network of brokers using NetworkConnector.                                                                                                                                     | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.NetworkIn.max                            | The volume of incoming traffic for the broker.                                                                                                                                                                                  | long             | byte    | gauge       |
  | aws.amazonmq.metrics.activemq.broker.NetworkOut.max                           | The volume of outgoing traffic for the broker.                                                                                                                                                                                  | long             | byte    | gauge       |
  | aws.amazonmq.metrics.activemq.broker.OpenTransactionCount.max                 | The total number of transactions in progress.                                                                                                                                                                                   | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.OpenwireMaximumConnections.max           | The maximum number of clients you can connect to your broker using OpenWire.                                                                                                                                                    | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.StompMaximumConnections.max              | The maximum number of clients you can connect to your broker using STOMP.                                                                                                                                                       | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.StorePercentUsage.avg                    | The percent used by the storage limit. If this reaches 100, the broker will refuse messages.                                                                                                                                    | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TempPercentUsage.avg                     | The percentage of available temporary storage used by non-persistent messages.                                                                                                                                                  | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TotalConsumerCount.max                   | The number of message consumers subscribed to destinations on the current broker.                                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TotalDequeueCount.max                    | The total number of messages that have been consumed by clients.                                                                                                                                                                | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TotalEnqueueCount.max                    | The total number of messages that have been sent to the broker.                                                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TotalMessageCount.max                    | The number of messages stored on the broker.                                                                                                                                                                                    | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.TotalProducerCount.max                   | The number of message producers active on destinations on the current broker.                                                                                                                                                   | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.VolumeReadOps.max                        | The number of read operations performed on the Amazon EBS volume.                                                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.VolumeWriteOps.max                       | The number of write operations performed on the Amazon EBS volume.                                                                                                                                                              | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.broker.WsMaximumConnections.max                 | The maximum number of clients you can connect to your broker using WebSocket.                                                                                                                                                   | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.ConsumerCount.max                   | The number of consumers subscribed to the destination.                                                                                                                                                                          | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.DequeueCount.sum                    | The number of messages acknowledged by consumers.                                                                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.DispatchCount.sum                   | The number of messages sent to consumers.                                                                                                                                                                                       | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.EnqueueCount.sum                    | The number of messages sent to the destination.                                                                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.EnqueueTime.avg                     | The end-to-end latency from when a message arrives at a broker until it is delivered to a consumer.                                                                                                                             | long             | ms      | gauge       |
  | aws.amazonmq.metrics.activemq.destination.ExpiredCount.sum                    | The number of messages that could not be delivered because they expired.                                                                                                                                                        | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.InFlightCount.sum                   | The number of messages sent to consumers that have not been acknowledged.                                                                                                                                                       | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.MemoryUsage.avg                     | The percentage of the memory limit that the destination currently uses.                                                                                                                                                         | long             | percent | gauge       |
  | aws.amazonmq.metrics.activemq.destination.ProducerCount.max                   | The number of producers for the destination.                                                                                                                                                                                    | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.QueueSize.max                       | The number of messages in the queue.                                                                                                                                                                                            | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.ReceiveCount.max                    | The number of messages that have been received from the remote broker for a duplex network connector.                                                                                                                           | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.TotalDequeueCount.max               | The total number of messages that have been consumed by clients.                                                                                                                                                                | long             |         | gauge       |
  | aws.amazonmq.metrics.activemq.destination.TotalEnqueueCount.max               | The total number of messages that have been sent to the broker.                                                                                                                                                                 | long             |         | gauge       |
  | aws.cloudwatch.namespace                                                      | The namespace specified when query cloudwatch api.                                                                                                                                                                              | keyword          |         |             |
  | aws.dimensions.Broker                                                         | The name of the broker.                                                                                                                                                                                                         | keyword          |         |             |
  | aws.dimensions.NetworkConnector                                               | The name of the network connector.                                                                                                                                                                                              | keyword          |         |             |
  | aws.dimensions.Queue                                                          | The name of the queue.                                                                                                                                                                                                          | keyword          |         |             |
  | aws.dimensions.Topic                                                          | The name of the topic.                                                                                                                                                                                                          | keyword          |         |             |
  | cloud.account.id                                                              | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                              | keyword          |         |             |
  | cloud.region                                                                  | Region in which this host, resource, or service is located.                                                                                                                                                                     | keyword          |         |             |
  | data_stream.dataset                                                           | Data stream dataset.                                                                                                                                                                                                            | constant_keyword |         |             |
  | data_stream.namespace                                                         | Data stream namespace.                                                                                                                                                                                                          | constant_keyword |         |             |
  | data_stream.type                                                              | Data stream type.                                                                                                                                                                                                               | constant_keyword |         |             |
  | event.module                                                                  | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | constant_keyword |         |             |
</dropdown>


### RabbitMQ metrics

Amazon MQ for RabbitMQ offers a variety of broker and queue metrics to monitor system performance, resource utilization, and message flow. These metrics are essential for:
- Assessing broker resource usage, including CPU, memory, and storage.
- Tracking message rates and queue depths to ensure efficient message processing.
- Analyzing connection counts and consumer activity to optimize messaging workloads.

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-02-28T10:05:00.000Z",
      "agent": {
          "ephemeral_id": "fc4c4367-978d-456e-8738-d7cae2319a83",
          "id": "151607dd-a8d5-462b-995f-752c336930d8",
          "name": "elastic-agent-97629",
          "type": "metricbeat",
          "version": "8.16.2"
      },
      "aws": {
          "amazonmq": {
              "metrics": {
                  "rabbitmq": {
                      "queue": {
                          "ConsumerCount": {
                              "max": 0
                          },
                          "MessageCount": {
                              "max": 0
                          },
                          "MessageReadyCount": {
                              "max": 0
                          },
                          "MessageUnacknowledgedCount": {
                              "max": 0
                          }
                      }
                  }
              }
          },
          "cloudwatch": {
              "namespace": "AWS/AmazonMQ"
          },
          "dimensions": {
              "Broker": "ObsIntegrations-RabbitMQ",
              "Queue": "obs-infra queue",
              "VirtualHost": "/"
          }
      },
      "cloud": {
          "account": {
              "id": "11111111111",
              "name": "MonitoringAccount"
          },
          "provider": "aws",
          "region": "ap-south-1"
      },
      "data_stream": {
          "dataset": "aws_mq.rabbitmq_metrics",
          "namespace": "16654",
          "type": "metrics"
      },
      "ecs": {
          "version": "8.0.0"
      },
      "elastic_agent": {
          "id": "151607dd-a8d5-462b-995f-752c336930d8",
          "snapshot": false,
          "version": "8.16.2"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "aws_mq.rabbitmq_metrics",
          "duration": 117138104,
          "ingested": "2025-02-28T10:10:52Z",
          "module": "aws"
      },
      "host": {
          "architecture": "x86_64",
          "containerized": true,
          "hostname": "elastic-agent-97629",
          "ip": [
              "192.168.192.2",
              "192.168.0.4"
          ],
          "mac": [
              "02-42-C0-A8-00-04",
              "02-42-C0-A8-C0-02"
          ],
          "name": "elastic-agent-97629",
          "os": {
              "family": "",
              "kernel": "5.4.0-1106-gcp",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "metricset": {
          "name": "cloudwatch",
          "period": 300000
      },
      "service": {
          "type": "aws"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                               | Description                                                                                                                                                                                                                     | Type             | Unit    | Metric Type |
  |---------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|---------|-------------|
  | @timestamp                                                          | Event timestamp.                                                                                                                                                                                                                | date             |         |             |
  | agent.id                                                            | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                      | keyword          |         |             |
  | aws.amazonmq.metrics.rabbitmq.broker.AckRate.max                    | The rate at which messages are being acknowledged by consumers.                                                                                                                                                                 | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.ChannelCount.max               | The total number of channels established on the broker.                                                                                                                                                                         | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.ConfirmRate.max                | The rate at which the RabbitMQ server is confirming published messages.                                                                                                                                                         | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.ConnectionCount.max            | The total number of connections established on the broker.                                                                                                                                                                      | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.ConsumerCount.max              | The total number of consumers connected to the broker.                                                                                                                                                                          | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.ExchangeCount.max              | The total number of exchanges configured on the broker.                                                                                                                                                                         | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.MessageCount.max               | The total number of messages in the queues.                                                                                                                                                                                     | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.MessageReadyCount.max          | The total number of ready messages in the queues.                                                                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.MessageUnacknowledgedCount.max | The total number of unacknowledged messages in the queues.                                                                                                                                                                      | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.PublishRate.max                | The rate at which messages are published to the broker.                                                                                                                                                                         | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.QueueCount.max                 | The total number of queues configured on the broker.                                                                                                                                                                            | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQDiskFree.min           | The total volume of free disk space available in a RabbitMQ broker. For cluster deployments, this value represents the aggregate of all RabbitMQ nodes' corresponding metric values.                                            | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQDiskFreeLimit.max      | The disk limit for a RabbitMQ broker. For cluster deployments, this value represents the aggregate of all RabbitMQ nodes' corresponding metric values.                                                                          | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQFdUsed.max             | The number of file descriptors used. For cluster deployments, this value represents the aggregate of all RabbitMQ nodes' corresponding metric values.                                                                           | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQIOReadAverageTime.max  | The average time for RabbitMQ to perform one read operation.                                                                                                                                                                    | long             | ms      | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQIOWriteAverageTime.max | The average time for RabbitMQ to perform one write operation.                                                                                                                                                                   | long             | ms      | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQMemLimit.max           | The RAM limit for a RabbitMQ broker. For cluster deployments, this value represents the aggregate of all RabbitMQ nodes' corresponding metric values.                                                                           | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.RabbitMQMemUsed.max            | The volume of RAM used by a RabbitMQ broker. For cluster deployments, this value represents the aggregate of all RabbitMQ nodes' corresponding metric values.                                                                   | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.broker.SystemCpuUtilization.max       | The percentage of allocated Amazon EC2 compute units that the broker currently uses. For cluster deployments, this value represents the aggregate of all three RabbitMQ nodes' corresponding metric values.                     | long             | percent | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQDiskFree.min             | The total volume of free disk space available in a RabbitMQ node.                                                                                                                                                               | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQDiskFreeLimit.max        | The disk limit for a RabbitMQ node.                                                                                                                                                                                             | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQFdUsed.max               | Number of file descriptors used.                                                                                                                                                                                                | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQIOReadAverageTime.max    | The average time for RabbitMQ to perform one read operation.                                                                                                                                                                    | long             | ms      | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQIOWriteAverageTime.max   | The average time for RabbitMQ to perform one write operation.                                                                                                                                                                   | long             | ms      | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQMemLimit.max             | The RAM limit for a RabbitMQ node.                                                                                                                                                                                              | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.RabbitMQMemUsed.max              | The volume of RAM used by a RabbitMQ node.                                                                                                                                                                                      | long             | byte    | gauge       |
  | aws.amazonmq.metrics.rabbitmq.node.SystemCpuUtilization.max         | The percentage of allocated Amazon EC2 compute units that the broker currently uses.                                                                                                                                            | long             | percent | gauge       |
  | aws.amazonmq.metrics.rabbitmq.queue.ConsumerCount.max               | The number of consumers subscribed to the queue.                                                                                                                                                                                | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.queue.MessageCount.max                | The total number of MessageReadyCount and MessageUnacknowledgedCount, referred to as queue depth.                                                                                                                               | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.queue.MessageReadyCount.max           | The number of messages that are currently available to be delivered.                                                                                                                                                            | long             |         | gauge       |
  | aws.amazonmq.metrics.rabbitmq.queue.MessageUnacknowledgedCount.max  | The number of messages for which the server is awaiting acknowledgement.                                                                                                                                                        | long             |         | gauge       |
  | aws.cloudwatch.namespace                                            | The namespace specified when query cloudwatch api.                                                                                                                                                                              | keyword          |         |             |
  | aws.dimensions.Broker                                               | The name of the broker.                                                                                                                                                                                                         | keyword          |         |             |
  | aws.dimensions.Node                                                 | The name of the node.                                                                                                                                                                                                           | keyword          |         |             |
  | aws.dimensions.Queue                                                | The name of the queue.                                                                                                                                                                                                          | keyword          |         |             |
  | aws.dimensions.VirtualHost                                          | The name of the virtual host.                                                                                                                                                                                                   | keyword          |         |             |
  | cloud.account.id                                                    | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                              | keyword          |         |             |
  | cloud.region                                                        | Region in which this host, resource, or service is located.                                                                                                                                                                     | keyword          |         |             |
  | data_stream.dataset                                                 | Data stream dataset.                                                                                                                                                                                                            | constant_keyword |         |             |
  | data_stream.namespace                                               | Data stream namespace.                                                                                                                                                                                                          | constant_keyword |         |             |
  | data_stream.type                                                    | Data stream type.                                                                                                                                                                                                               | constant_keyword |         |             |
  | event.module                                                        | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | constant_keyword |         |             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![ActiveMQ overview dashboard](https://epr.elastic.co/package/aws_mq/0.11.0/img/amazonmq-activemq-dashboard.png)

  ![RabbitMQ overview dashboard](https://epr.elastic.co/package/aws_mq/0.11.0/img/amazonmq-rabbitmq-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                          | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16984))Improve dashboard to align with guidelines.                                             |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15320))Improve documentation to align with new guidelines.                                     |                        |
  | **0.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14733))Add description on lastSync start_position configuration for CloudWatch.                    |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13387))Add a dashboard panel for RabbitMQ general logs in the RabbitMQ overview dashboard.     |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13338))Add rabbitmq_general_logs dataset for RabbitMQ general logs.                            |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13328))Add a dashboard panel to show ActiveMQ general logs in the ActiveMQ overview dashboard. |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13187))Add activemq_audit_logs dataset for ActiveMQ audit logs.                                |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13136))Add activemq_general_logs dataset for ActiveMQ general logs.                            |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13032))Add RabbitMQ overview dashboard.                                                        |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12924))Add rabbitmq_metrics dataset for RabbitMQ metrics.                                      |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12862))Add ActiveMQ overview dashboard.                                                        |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12807))Initial draft of the package. Add activemq_metrics dataset for ActiveMQ metrics.        |                        |
</dropdown>