﻿---
title: AWS ELB Access Logs OpenTelemetry Assets
description: This package contains Kibana assets for monitoring AWS ELB load balancers. We support access logs collected from Application Load Balancers (ALBs), Network...
url: https://www.elastic.co/docs/reference/integrations/aws_elb_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# AWS ELB Access Logs OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.1 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The AWS ELB OpenTelemetry Assets integration v0.1.1 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

This package contains Kibana assets for monitoring [AWS ELB load balancers](https://aws.amazon.com/elasticloadbalancing/). We support access logs collected from Application Load Balancers (ALBs), Network Load Balancers (NLBs) and Classic Load Balancers.

## Supported data sources


### EDOT Cloud Forwarder (ECF) for AWS

ECF is the simplest way to configure AWS ELB log collection. Refer to the [ECF for AWS documentation](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws) for full setup instructions.

### Standalone OTel Collector

Any OTel-supported collection method is supported provided the required extension is included.

#### Compatibility

This package has been tested with OpenTelemetry Collector version `0.138.0`. The OpenTelemetry components used are [awss3receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/awss3receiver#aws-s3-receiver), [awslogsencodingextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/encoding/awslogsencodingextension#aws-logs-encoding-extension), and [elasticsearchexporter](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/elasticsearchexporter#elasticsearch-exporter).

#### Sample configuration

```yaml
extensions:
  awslogs_encoding/elbaccess:
    format: elbaccess

receivers:
  awss3:
    sqs:
      queue_url: "<sqs-url>"
      region: "<region>"
    s3downloader:
      region: "<region>"
      s3_bucket: '<bucket_name>'
      s3_prefix: 'AWSLogs/<account-id>'
    encodings:
      - extension: awslogs_encoding/elbaccess

exporters:
  elasticsearch/otel:
    endpoints: https://<host>:<port>
    api_key: <api_key>

service:
  extensions: [awslogs_encoding/elbaccess]
  pipelines:
    logs:
      exporters: [elasticsearch/otel]
      receivers: [awss3]
```


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![AWS ELB dashboard screenshot](https://epr.elastic.co/package/aws_elb_otel/0.1.1/img/elb_dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                        | Minimum Kibana version |
  |-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15844))Add "Alternative setup using awss3receiver" section to README         |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15401))Initial draft of the AWS ELB Access Logs OpenTelemetry Assets package |                        |
</dropdown>