﻿---
title: Security Hub CSPM
description: The AWS Security Hub CSPM integration collects and parses data from AWS Security Hub REST APIs. Agentless integrations allow you to collect data without...
url: https://www.elastic.co/docs/reference/integrations/aws/securityhub
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Security Hub CSPM
|                                                                            |                                |
|----------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                | 6.1.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                          |
| **Ingestion method(s)**                                                    | API, AWS CloudWatch, AWS S3    |
| **Minimum Kibana version(s)**                                              | 9.2.18.19.4                    |

The [AWS Security Hub CSPM](https://docs.aws.amazon.com/securityhub/) integration collects and parses data from AWS Security Hub REST APIs.
<important>
  Extra AWS charges on API requests will be generated by this integration. Check [API Requests](https://www.elastic.co/docs/current/integrations/aws#api-requests) for more details.
</important>


## Agentless Enabled Integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

## Compatibility

1. The minimum compatible version of this module is `Elastic Agent 8.4.0`.
2. This module is tested against `AWS Security Hub API version 1.0`.


## To collect data from AWS Security Hub APIs, users must have an Access Key and a Secret Key. To create API token follow below steps:

1. Login to .
2. Go to  to access the IAM console.
3. On the navigation menu, choose Users.
4. Choose your IAM user name.
5. Select Create access key from the Security Credentials tab.
6. To see the new access key, choose Show.


## Note

1. For the current integration package, it is recommended to have interval in hours.
2. For the current integration package, it is compulsory to add Secret Access Key and Access Key ID.
3. Findings Full Posture data stream request all the historical findings every 24 hours.


## Logs


### Findings

This is the [`securityhub_findings`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindings.html#API_GetFindings_ResponseElements) data stream.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2018-08-31T00:15:09.000Z",
      "agent": {
          "ephemeral_id": "b333f80a-aa3c-4180-bedc-b55bef909b01",
          "id": "76aef659-3329-4b2e-a6c1-36bb8389faac",
          "name": "elastic-agent-79144",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "aws": {
          "securityhub_findings": {
              "action": {
                  "port_probe": {
                      "blocked": false,
                      "details": [
                          {
                              "local": {
                                  "ip": {
                                      "address_v4": "1.128.0.0"
                                  },
                                  "port": {
                                      "name": "HTTP",
                                      "number": 80
                                  }
                              },
                              "remote_ip": {
                                  "city": {
                                      "name": "Example City"
                                  },
                                  "country": {
                                      "name": "Example Country"
                                  },
                                  "geolocation": {
                                      "latitude": 0,
                                      "longitude": 0
                                  },
                                  "organization": {
                                      "asn": "64496",
                                      "asn_organization": "ExampleASO",
                                      "internet_provider": "ExampleOrg",
                                      "internet_service_provider": "ExampleISP"
                                  }
                              }
                          }
                      ]
                  }
              },
              "aws_account_id": "111111111111",
              "company": {
                  "name": "AWS"
              },
              "compliance": {
                  "related_requirements": [
                      "Req1",
                      "Req2"
                  ],
                  "status": "PASSED",
                  "status_reasons": [
                      {
                          "description": "CloudWatch alarms do not exist in the account",
                          "reason_code": "CLOUDWATCH_ALARMS_NOT_PRESENT"
                      }
                  ]
              },
              "confidence": 42,
              "criticality": 99,
              "description": "The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.",
              "first_observed_at": "2017-03-22T13:22:13.933Z",
              "generator": {
                  "id": "acme-vuln-9ab348"
              },
              "last_observed_at": "2017-03-23T13:22:13.933Z",
              "malware": [
                  {
                      "name": "Stringler",
                      "path": "/usr/sbin/stringler",
                      "state": "OBSERVED",
                      "type": "COIN_MINER"
                  }
              ],
              "network": {
                  "open_port_range": {
                      "begin": 443,
                      "end": 443
                  }
              },
              "network_path": [
                  {
                      "component": {
                          "id": "abc-01a234bc56d8901ee",
                          "type": "AWS::EC2::InternetGateway"
                      },
                      "egress": {
                          "destination": {
                              "address": [
                                  "1.128.0.0/24"
                              ],
                              "port_ranges": [
                                  {
                                      "begin": 443,
                                      "end": 443
                                  }
                              ]
                          },
                          "protocol": "TCP",
                          "source": {
                              "address": [
                                  "175.16.199.1/24"
                              ]
                          }
                      },
                      "ingress": {
                          "destination": {
                              "address": [
                                  "175.16.199.1/24"
                              ],
                              "port_ranges": [
                                  {
                                      "begin": 443,
                                      "end": 443
                                  }
                              ]
                          },
                          "protocol": "TCP",
                          "source": {
                              "address": [
                                  "175.16.199.1/24"
                              ]
                          }
                      }
                  }
              ],
              "note": {
                  "text": "Don't forget to check under the mat.",
                  "updated_at": "2018-08-31T00:15:09.000Z",
                  "updated_by": "jsmith"
              },
              "patch_summary": {
                  "failed": {
                      "count": 0
                  },
                  "id": "pb-123456789098",
                  "installed": {
                      "count": 100,
                      "other": {
                          "count": 1023
                      },
                      "pending_reboot": 0,
                      "rejected": {
                          "count": 0
                      }
                  },
                  "missing": {
                      "count": 100
                  },
                  "operation": {
                      "end_time": "2018-09-27T23:39:31.000Z",
                      "start_time": "2018-09-27T23:37:31.000Z",
                      "type": "Install"
                  },
                  "reboot_option": "RebootIfNeeded"
              },
              "product": {
                  "arn": "arn:aws:securityhub:us-east-1:111111111111:product/111111111111/default",
                  "fields": {
                      "Service_Name": "cloudtrail.amazonaws.com",
                      "aws/inspector/AssessmentTargetName": "My prod env",
                      "aws/inspector/AssessmentTemplateName": "My daily CVE assessment",
                      "aws/inspector/RulesPackageName": "Common Vulnerabilities and Exposures",
                      "generico/secure-pro/Count": "6"
                  },
                  "name": "Security Hub"
              },
              "provider_fields": {
                  "confidence": 42,
                  "criticality": 99,
                  "related_findings": [
                      {
                          "id": "123e4567-e89b-12d3-a456-426655440000",
                          "product": {
                              "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                          }
                      }
                  ],
                  "severity": {
                      "label": "MEDIUM",
                      "original": "MEDIUM"
                  },
                  "types": [
                      "Software and Configuration Checks/Vulnerabilities/CVE"
                  ]
              },
              "record_state": "ACTIVE",
              "region": "us-east-1",
              "related_findings": [
                  {
                      "id": "123e4567-e89b-12d3-a456-426655440000",
                      "product": {
                          "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                      }
                  },
                  {
                      "id": "AcmeNerfHerder-111111111111-x189dx7824",
                      "product": {
                          "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                      }
                  }
              ],
              "remediation": {
                  "recommendation": {
                      "text": "Run sudo yum update and cross your fingers and toes.",
                      "url": "http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html"
                  }
              },
              "resources": [
                  {
                      "Details": {
                          "IamInstanceProfileArn": "arn:aws:iam::123456789012:role/IamInstanceProfileArn",
                          "ImageId": "ami-79fd7eee",
                          "IpV4Addresses": [
                              "175.16.199.1"
                          ],
                          "IpV6Addresses": [
                              "2a02:cf40::"
                          ],
                          "KeyName": "testkey",
                          "LaunchedAt": "2018-09-29T01:25:54Z",
                          "MetadataOptions": {
                              "HttpEndpoint": "enabled",
                              "HttpProtocolIpv6": "enabled",
                              "HttpPutResponseHopLimit": 1,
                              "HttpTokens": "optional",
                              "InstanceMetadataTags": "disabled"
                          },
                          "NetworkInterfaces": [
                              {
                                  "NetworkInterfaceId": "eni-e5aa89a3"
                              }
                          ],
                          "SubnetId": "PublicSubnet",
                          "Type": "i3.xlarge",
                          "VirtualizationType": "hvm",
                          "VpcId": "TestVPCIpv6"
                      },
                      "Id": "i-cafebabe",
                      "Partition": "aws",
                      "Region": "us-west-2",
                      "Tags": {
                          "billingCode": "Lotus-1-2-3",
                          "needsPatching": "true"
                      },
                      "Type": "AwsEc2Instance"
                  }
              ],
              "sample": true,
              "schema": {
                  "version": "2018-10-08"
              },
              "severity": {
                  "label": "CRITICAL",
                  "original": "8.3"
              },
              "source_url": "http://threatintelweekly.org/backdoors/8888",
              "threat_intel_indicators": [
                  {
                      "category": "BACKDOOR",
                      "source": "Threat Intel Weekly",
                      "source_url": "http://threatintelweekly.org/backdoors/8888",
                      "value": "175.16.199.1"
                  }
              ],
              "title": "EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up",
              "types": [
                  "Software and Configuration Checks/Vulnerabilities/CVE"
              ],
              "updated_at": "2018-08-31T00:15:09.000Z",
              "user_defined_fields": {
                  "comeBackToLater": "Check this again on Monday",
                  "reviewedByCio": "true"
              },
              "verification_state": "UNKNOWN",
              "vulnerabilities": [
                  {
                      "cvss": [
                          {
                              "base_score": 4.7,
                              "base_vector": "AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N",
                              "version": "V3"
                          },
                          {
                              "base_score": 4.7,
                              "base_vector": "AV:L/AC:M/Au:N/C:C/I:N/A:N",
                              "version": "V2"
                          }
                      ],
                      "related_vulnerabilities": [
                          "CVE-2020-12345"
                      ],
                      "vendor": {
                          "created_at": "2020-01-16T00:01:43.000Z",
                          "severity": "Medium",
                          "updated_at": "2020-01-16T00:01:43.000Z",
                          "url": "https://alas.aws.amazon.com/ALAS-2020-1337.html"
                      },
                      "vulnerable_packages": [
                          {
                              "architecture": "x86_64",
                              "epoch": "1",
                              "name": "openssl",
                              "release": "16.amzn2.0.3",
                              "version": "1.0.2k"
                          }
                      ]
                  }
              ],
              "workflow": {
                  "state": "NEW",
                  "status": "NEW"
              }
          }
      },
      "cloud": {
          "account": {
              "id": "111111111111"
          },
          "instance": {
              "id": "i-cafebabe",
              "name": "i-cafebabe"
          },
          "provider": "aws",
          "region": "us-east-1"
      },
      "data_stream": {
          "dataset": "aws.securityhub_findings",
          "namespace": "43694",
          "type": "logs"
      },
      "destination": {
          "domain": "example2.com",
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ],
          "port": 80
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "76aef659-3329-4b2e-a6c1-36bb8389faac",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "port_probe",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-12-09T05:40:33.772Z",
          "dataset": "aws.securityhub_findings",
          "id": "us-west-2/111111111111/98aebb2207407c87f51e89943f12b1ef",
          "ingested": "2025-12-09T05:40:36Z",
          "kind": "state",
          "original": "{\"Action\":{\"ActionType\":\"PORT_PROBE\",\"PortProbeAction\":{\"Blocked\":false,\"PortProbeDetails\":[{\"LocalIpDetails\":{\"IpAddressV4\":\"1.128.0.0\"},\"LocalPortDetails\":{\"Port\":80,\"PortName\":\"HTTP\"},\"RemoteIpDetails\":{\"City\":{\"CityName\":\"Example City\"},\"Country\":{\"CountryName\":\"Example Country\"},\"GeoLocation\":{\"Lat\":0,\"Lon\":0},\"Organization\":{\"Asn\":64496,\"AsnOrg\":\"ExampleASO\",\"Isp\":\"ExampleISP\",\"Org\":\"ExampleOrg\"}}}]}},\"AwsAccountId\":\"111111111111\",\"CompanyName\":\"AWS\",\"Compliance\":{\"RelatedRequirements\":[\"Req1\",\"Req2\"],\"Status\":\"PASSED\",\"StatusReasons\":[{\"Description\":\"CloudWatch alarms do not exist in the account\",\"ReasonCode\":\"CLOUDWATCH_ALARMS_NOT_PRESENT\"}]},\"Confidence\":42,\"CreatedAt\":\"2017-03-22T13:22:13.933Z\",\"Criticality\":99,\"Description\":\"The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.\",\"FindingProviderFields\":{\"Confidence\":42,\"Criticality\":99,\"RelatedFindings\":[{\"Id\":\"123e4567-e89b-12d3-a456-426655440000\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"}],\"Severity\":{\"Label\":\"MEDIUM\",\"Original\":\"MEDIUM\"},\"Types\":[\"Software and Configuration Checks/Vulnerabilities/CVE\"]},\"FirstObservedAt\":\"2017-03-22T13:22:13.933Z\",\"GeneratorId\":\"acme-vuln-9ab348\",\"Id\":\"us-west-2/111111111111/98aebb2207407c87f51e89943f12b1ef\",\"LastObservedAt\":\"2017-03-23T13:22:13.933Z\",\"Malware\":[{\"Name\":\"Stringler\",\"Path\":\"/usr/sbin/stringler\",\"State\":\"OBSERVED\",\"Type\":\"COIN_MINER\"}],\"Network\":{\"DestinationDomain\":\"example2.com\",\"DestinationIpV4\":\"1.128.0.0\",\"DestinationIpV6\":\"2a02:cf40::\",\"DestinationPort\":\"80\",\"Direction\":\"IN\",\"OpenPortRange\":{\"Begin\":443,\"End\":443},\"Protocol\":\"TCP\",\"SourceDomain\":\"example1.com\",\"SourceIpV4\":\"1.128.0.0\",\"SourceIpV6\":\"2a02:cf40::\",\"SourceMac\":\"00:0d:83:b1:c0:8e\",\"SourcePort\":\"42\"},\"NetworkPath\":[{\"ComponentId\":\"abc-01a234bc56d8901ee\",\"ComponentType\":\"AWS::EC2::InternetGateway\",\"Egress\":{\"Destination\":{\"Address\":[\"1.128.0.0/24\"],\"PortRanges\":[{\"Begin\":443,\"End\":443}]},\"Protocol\":\"TCP\",\"Source\":{\"Address\":[\"175.16.199.1/24\"]}},\"Ingress\":{\"Destination\":{\"Address\":[\"175.16.199.1/24\"],\"PortRanges\":[{\"Begin\":443,\"End\":443}]},\"Protocol\":\"TCP\",\"Source\":{\"Address\":[\"175.16.199.1/24\"]}}}],\"Note\":{\"Text\":\"Don't forget to check under the mat.\",\"UpdatedAt\":\"2018-08-31T00:15:09Z\",\"UpdatedBy\":\"jsmith\"},\"PatchSummary\":{\"FailedCount\":\"0\",\"Id\":\"pb-123456789098\",\"InstalledCount\":\"100\",\"InstalledOtherCount\":\"1023\",\"InstalledPendingReboot\":\"0\",\"InstalledRejectedCount\":\"0\",\"MissingCount\":\"100\",\"Operation\":\"Install\",\"OperationEndTime\":\"2018-09-27T23:39:31Z\",\"OperationStartTime\":\"2018-09-27T23:37:31Z\",\"RebootOption\":\"RebootIfNeeded\"},\"Process\":{\"LaunchedAt\":\"2018-09-27T22:37:31Z\",\"Name\":\"syslogd\",\"ParentPid\":56789,\"Path\":\"/usr/sbin/syslogd\",\"Pid\":12345,\"TerminatedAt\":\"2018-09-27T23:37:31Z\"},\"ProductArn\":\"arn:aws:securityhub:us-east-1:111111111111:product/111111111111/default\",\"ProductFields\":{\"Service_Name\":\"cloudtrail.amazonaws.com\",\"aws/inspector/AssessmentTargetName\":\"My prod env\",\"aws/inspector/AssessmentTemplateName\":\"My daily CVE assessment\",\"aws/inspector/RulesPackageName\":\"Common Vulnerabilities and Exposures\",\"generico/secure-pro/Count\":\"6\"},\"ProductName\":\"Security Hub\",\"RecordState\":\"ACTIVE\",\"Region\":\"us-east-1\",\"RelatedFindings\":[{\"Id\":\"123e4567-e89b-12d3-a456-426655440000\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"},{\"Id\":\"AcmeNerfHerder-111111111111-x189dx7824\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"}],\"Remediation\":{\"Recommendation\":{\"Text\":\"Run sudo yum update and cross your fingers and toes.\",\"Url\":\"http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html\"}},\"Resources\":[{\"Details\":{\"IamInstanceProfileArn\":\"arn:aws:iam::123456789012:role/IamInstanceProfileArn\",\"ImageId\":\"ami-79fd7eee\",\"IpV4Addresses\":[\"175.16.199.1\"],\"IpV6Addresses\":[\"2a02:cf40::\"],\"KeyName\":\"testkey\",\"LaunchedAt\":\"2018-09-29T01:25:54Z\",\"MetadataOptions\":{\"HttpEndpoint\":\"enabled\",\"HttpProtocolIpv6\":\"enabled\",\"HttpPutResponseHopLimit\":1,\"HttpTokens\":\"optional\",\"InstanceMetadataTags\":\"disabled\"},\"NetworkInterfaces\":[{\"NetworkInterfaceId\":\"eni-e5aa89a3\"}],\"SubnetId\":\"PublicSubnet\",\"Type\":\"i3.xlarge\",\"VirtualizationType\":\"hvm\",\"VpcId\":\"TestVPCIpv6\"},\"Id\":\"i-cafebabe\",\"Partition\":\"aws\",\"Region\":\"us-west-2\",\"Tags\":{\"billingCode\":\"Lotus-1-2-3\",\"needsPatching\":\"true\"},\"Type\":\"AwsEc2Instance\"}],\"Sample\":true,\"SchemaVersion\":\"2018-10-08\",\"Severity\":{\"Label\":\"CRITICAL\",\"Original\":\"8.3\"},\"SourceUrl\":\"http://threatintelweekly.org/backdoors/8888\",\"ThreatIntelIndicators\":[{\"Category\":\"BACKDOOR\",\"LastObservedAt\":\"2018-09-27T23:37:31Z\",\"Source\":\"Threat Intel Weekly\",\"SourceUrl\":\"http://threatintelweekly.org/backdoors/8888\",\"Type\":\"IPV4_ADDRESS\",\"Value\":\"175.16.199.1\"}],\"Threats\":[{\"FilePaths\":[{\"FileName\":\"b.txt\",\"FilePath\":\"/tmp/b.txt\",\"Hash\":\"sha256\",\"ResourceId\":\"arn:aws:ec2:us-west-2:123456789012:volume/vol-032f3bdd89aee112f\"}],\"ItemCount\":3,\"Name\":\"Iot.linux.mirai.vwisi\",\"Severity\":\"HIGH\"}],\"Title\":\"EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up\",\"Types\":[\"Software and Configuration Checks/Vulnerabilities/CVE\"],\"UpdatedAt\":\"2018-08-31T00:15:09Z\",\"UserDefinedFields\":{\"comeBackToLater\":\"Check this again on Monday\",\"reviewedByCio\":\"true\"},\"VerificationState\":\"UNKNOWN\",\"Vulnerabilities\":[{\"Cvss\":[{\"BaseScore\":4.7,\"BaseVector\":\"AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N\",\"Version\":\"V3\"},{\"BaseScore\":4.7,\"BaseVector\":\"AV:L/AC:M/Au:N/C:C/I:N/A:N\",\"Version\":\"V2\"}],\"Id\":\"CVE-2020-12345\",\"ReferenceUrls\":[\"http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-12418\",\"http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-17563\"],\"RelatedVulnerabilities\":[\"CVE-2020-12345\"],\"Vendor\":{\"Name\":\"Alas\",\"Url\":\"https://alas.aws.amazon.com/ALAS-2020-1337.html\",\"VendorCreatedAt\":\"2020-01-16T00:01:43Z\",\"VendorSeverity\":\"Medium\",\"VendorUpdatedAt\":\"2020-01-16T00:01:43Z\"},\"VulnerablePackages\":[{\"Architecture\":\"x86_64\",\"Epoch\":\"1\",\"Name\":\"openssl\",\"Release\":\"16.amzn2.0.3\",\"Version\":\"1.0.2k\"}]}],\"Workflow\":{\"Status\":\"NEW\"},\"WorkflowState\":\"NEW\"}",
          "outcome": "success",
          "type": [
              "info"
          ]
      },
      "host": {
          "id": "i-cafebabe"
      },
      "input": {
          "type": "httpjson"
      },
      "network": {
          "direction": "inbound",
          "protocol": "tcp"
      },
      "observer": {
          "vendor": "AWS Security Hub CSPM"
      },
      "organization": {
          "name": "AWS"
      },
      "process": {
          "end": "2018-09-27T23:37:31.000Z",
          "executable": "/usr/sbin/syslogd",
          "name": "syslogd",
          "parent": {
              "pid": 56789
          },
          "pid": 12345,
          "start": "2018-09-27T22:37:31.000Z"
      },
      "related": {
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ]
      },
      "resource": {
          "id": "i-cafebabe",
          "name": "i-cafebabe",
          "type": "AwsEc2Instance"
      },
      "result": {
          "evaluation": "passed"
      },
      "rule": {
          "description": "The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.",
          "id": "acme-vuln-9ab348",
          "name": "EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up",
          "reference": "http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html",
          "remediation": "Run sudo yum update and cross your fingers and toes.\r\nhttp://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html",
          "ruleset": [
              "Req1",
              "Req2"
          ]
      },
      "source": {
          "domain": "example1.com",
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ],
          "mac": "00-0D-83-B1-C0-8E",
          "port": 42
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "aws_securityhub_findings"
      ],
      "threat": {
          "indicator": {
              "last_seen": "2018-09-27T23:37:31.000Z",
              "type": "ipv4-addr"
          }
      },
      "url": {
          "domain": "threatintelweekly.org",
          "full": "http://threatintelweekly.org/backdoors/8888",
          "original": "http://threatintelweekly.org/backdoors/8888",
          "path": "/backdoors/8888",
          "scheme": "http"
      },
      "vulnerability": {
          "id": "CVE-2020-12345",
          "reference": [
              "http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-12418",
              "http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-17563"
          ],
          "scanner": {
              "vendor": "Alas"
          },
          "score": {
              "base": 4.7,
              "version": "V2"
          }
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Type             |
  |-----------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                          | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                 | date             |
  | aws.securityhub_findings.action.aws_api_call.affected_resources                                     | Identifies the resources that were affected by the API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_findings.action.aws_api_call.api                                                    | The name of the API method that was issued.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.aws_api_call.caller.type                                            | Indicates whether the API call originated from a remote IP address(remoteip) or from a DNS domain(domain).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.action.aws_api_call.domain_details.domain                                  | The name of the DNS domain that issued the API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.action.aws_api_call.first_seen                                             | An ISO8601-formatted timestamp that indicates when the API call was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | date             |
  | aws.securityhub_findings.action.aws_api_call.last_seen                                              | An ISO8601-formatted timestamp that indicates when the API call was most recently observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.city.name                                    | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.country.code                                 | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.country.name                                 | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.geolocation.latitude                         | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | double           |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.geolocation.longitude                        | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | double           |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.ip.address_v4                                | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.organization.asn                             | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.organization.asn_organization                | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.organization.internet_provider               | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.action.aws_api_call.remote_ip.organization.internet_service_provider       | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.action.aws_api_call.service.name                                           | The name of the Amazon Web Services service that the API method belongs to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.dns_request.blocked                                                 | Indicates whether the DNS request was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | boolean          |
  | aws.securityhub_findings.action.dns_request.domain                                                  | The DNS domain that is associated with the DNS request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.action.dns_request.protocol                                                | The protocol that was used for the DNS request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings.action.network_connection.blocked                                          | Indicates whether the network connection attempt was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |
  | aws.securityhub_findings.action.network_connection.direction                                        | The direction of the network connection request(IN or OUT).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.network_connection.local.port.name                                  | The port name of the local connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.action.network_connection.local.port.number                                | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | aws.securityhub_findings.action.network_connection.protocol                                         | The protocol used to make the network connection request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings.action.network_connection.remote.port.name                                 | The port name of the remote connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.action.network_connection.remote.port.number                               | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | aws.securityhub_findings.action.network_connection.remote_ip.city.name                              | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.country.code                           | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.country.name                           | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.geolocation.latitude                   | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | double           |
  | aws.securityhub_findings.action.network_connection.remote_ip.geolocation.longitude                  | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | double           |
  | aws.securityhub_findings.action.network_connection.remote_ip.ip.address_v4                          | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | aws.securityhub_findings.action.network_connection.remote_ip.organization.asn                       | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.organization.asn_organization          | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.organization.internet_provider         | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.action.network_connection.remote_ip.organization.internet_service_provider | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.action.port_probe.blocked                                                  | Indicates whether the port probe was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |
  | aws.securityhub_findings.action.port_probe.details.local.ip.address_v4                              | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | aws.securityhub_findings.action.port_probe.details.local.port.name                                  | The port name of the local connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.action.port_probe.details.local.port.number                                | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.city.name                              | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.country.code                           | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.country.name                           | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.geolocation.latitude                   | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | double           |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.geolocation.longitude                  | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | double           |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.ip.address_v4                          | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | ip               |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.organization.asn                       | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.organization.asn_organization          | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.organization.internet_provider         | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.action.port_probe.details.remote_ip.organization.internet_service_provider | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.action.type                                                                | The type of action that was detected.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.aws_account_id                                                             | The Amazon Web Services account ID that a finding is generated in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.company.name                                                               | The name of the company for the product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.compliance.related_requirements                                            | For a control, the industry or regulatory framework requirements that are related to the control.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.compliance.security_control_id                                             | Unique identifier of a control across standards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.compliance.status                                                          | The result of a standards check.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.compliance.status_reasons.description                                      | The corresponding description for the status reason code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings.compliance.status_reasons.reason_code                                      | A code that represents a reason for the control status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.confidence                                                                 | A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | aws.securityhub_findings.created_at                                                                 | Indicates when the security-findings provider created the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.securityhub_findings.criticality                                                                | The level of importance assigned to the resources associated with the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | aws.securityhub_findings.description                                                                | A finding's description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.first_observed_at                                                          | Indicates when the security-findings provider first observed the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | date             |
  | aws.securityhub_findings.generator.id                                                               | The identifier for the solution-specific component(a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.id                                                                         | The security findings provider-specific identifier for a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.last_observed_at                                                           | Indicates when the security-findings provider most recently observed the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | aws.securityhub_findings.malware.name                                                               | The name of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.malware.path                                                               | The file system path of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.malware.state                                                              | The state of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.malware.type                                                               | The type of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.network.destination.domain                                                 | The destination domain of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.network.destination.ip.v4                                                  | The destination IPv4 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | aws.securityhub_findings.network.destination.ip.v6                                                  | The destination IPv6 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | aws.securityhub_findings.network.destination.port                                                   | The destination port of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | aws.securityhub_findings.network.direction                                                          | The direction of network traffic associated with a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.network.open_port_range.begin                                              | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings.network.open_port_range.end                                                | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.securityhub_findings.network.protocol                                                           | The protocol of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings.network.source.domain                                                      | The source domain of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.network.source.ip.v4                                                       | The source IPv4 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | aws.securityhub_findings.network.source.ip.v6                                                       | The source IPv6 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | aws.securityhub_findings.network.source.mac                                                         | The source media access control(MAC) address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings.network.source.port                                                        | The source port of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | aws.securityhub_findings.network_path.component.id                                                  | The identifier of a component in the network path.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.network_path.component.type                                                | The type of component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.network_path.egress.destination.address                                    | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.egress.destination.port_ranges.begin                          | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings.network_path.egress.destination.port_ranges.end                            | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.securityhub_findings.network_path.egress.protocol                                               | The protocol used for the component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.egress.source.address                                         | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.egress.source.port_ranges.begin                               | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings.network_path.egress.source.port_ranges.end                                 | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.securityhub_findings.network_path.ingress.destination.address                                   | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.ingress.destination.port_ranges.begin                         | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings.network_path.ingress.destination.port_ranges.end                           | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.securityhub_findings.network_path.ingress.protocol                                              | The protocol used for the component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.ingress.source.address                                        | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.network_path.ingress.source.port_ranges.begin                              | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings.network_path.ingress.source.port_ranges.end                                | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.securityhub_findings.note.text                                                                  | The text of a note.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.note.updated_at                                                            | The timestamp of when the note was updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.securityhub_findings.note.updated_by                                                            | The principal that created a note.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.patch_summary.failed.count                                                 | The number of patches from the compliance standard that failed to install.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | aws.securityhub_findings.patch_summary.id                                                           | The identifier of the compliance standard that was used to determine the patch compliance status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.patch_summary.installed.count                                              | The number of patches from the compliance standard that were installed successfully.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | aws.securityhub_findings.patch_summary.installed.other.count                                        | The number of installed patches that are not part of the compliance standard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | aws.securityhub_findings.patch_summary.installed.pending_reboot                                     | The number of patches that were applied, but that require the instance to be rebooted in order to be marked as installed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | aws.securityhub_findings.patch_summary.installed.rejected.count                                     | The number of patches that are installed but are also on a list of patches that the customer rejected.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings.patch_summary.missing.count                                                | The number of patches that are part of the compliance standard but are not installed. The count includes patches that failed to install.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | aws.securityhub_findings.patch_summary.operation.end_time                                           | Indicates when the operation completed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | aws.securityhub_findings.patch_summary.operation.start_time                                         | Indicates when the operation started.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | date             |
  | aws.securityhub_findings.patch_summary.operation.type                                               | The type of patch operation performed. For Patch Manager, the values are SCAN and INSTALL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.patch_summary.reboot_option                                                | The reboot option specified for the instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings.process.launched_at                                                        | Indicates when the process was launched.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | aws.securityhub_findings.process.name                                                               | The name of the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.process.parent.pid                                                         | The parent process ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings.process.path                                                               | The path to the process executable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.process.pid                                                                | The process ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | aws.securityhub_findings.process.terminated_at                                                      | Indicates when the process was terminated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | aws.securityhub_findings.processed_at                                                               | Indicates when AWS Security Hub received a finding and begins to process it.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_findings.product.arn                                                                | The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.product.fields                                                             | A data type where security-findings providers can include additional solution-specific details that aren't part of the defined AwsSecurityFinding format.                                                                                                                                                                                                                                                                                                                                                                                                                                         | flattened        |
  | aws.securityhub_findings.product.name                                                               | The name of the product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.provider_fields.confidence                                                 | A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | aws.securityhub_findings.provider_fields.criticality                                                | The level of importance assigned to the resources associated with the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | aws.securityhub_findings.provider_fields.related_findings.id                                        | The product-generated identifier for a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.provider_fields.related_findings.product.arn                               | The ARN of the product that generated a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.provider_fields.severity.label                                             | The severity label assigned to the finding by the finding provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.provider_fields.severity.normalized                                        | The normalized severity of a finding provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.provider_fields.severity.original                                          | The finding provider's original value for the severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.provider_fields.severity.product                                           | The finding provider's product for the severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.provider_fields.types                                                      | One or more finding types in the format of namespace/category/classifier that classify a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.record_state                                                               | The record state of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.region                                                                     | The Region from which the finding was generated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.related_findings.id                                                        | The product-generated identifier for a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.related_findings.product.arn                                               | The ARN of the product that generated a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.remediation.recommendation.text                                            | Describes the recommended steps to take to remediate an issue identified in a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | text             |
  | aws.securityhub_findings.remediation.recommendation.url                                             | A URL to a page or site that contains information about how to remediate a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.resources                                                                  | A set of resource data types that describe the resources that the finding refers to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_findings.sample                                                                     | Indicates whether the finding is a sample finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | aws.securityhub_findings.schema.version                                                             | The schema version that a finding is formatted for.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings.severity.label                                                             | The severity value of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.severity.normalized                                                        | The normalized severity of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.severity.original                                                          | The native severity from the finding product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings.severity.product                                                           | The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.source_url                                                                 | A URL that links to a page about the current finding in the security-findings provider's solution.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.threat_intel_indicators.category                                           | The category of a threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.threat_intel_indicators.last_observed_at                                   | Indicates when the most recent instance of a threat intelligence indicator was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | aws.securityhub_findings.threat_intel_indicators.source                                             | The source of the threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.threat_intel_indicators.source_url                                         | The URL to the page or site where you can get more information about the threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.threat_intel_indicators.type                                               | The type of threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.threat_intel_indicators.value                                              | The value of a threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings.title                                                                      | A finding's title.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | text             |
  | aws.securityhub_findings.types                                                                      | One or more finding types in the format of namespace/category/classifier that classify a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.updated_at                                                                 | Indicates when the security-findings provider last updated the finding record.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | date             |
  | aws.securityhub_findings.user_defined_fields                                                        | A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_findings.verification_state                                                         | Indicates the veracity of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.vulnerabilities.cvss.adjustments.metric                                    | The metric to adjust.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings.vulnerabilities.cvss.adjustments.reason                                    | The reason for the adjustment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings.vulnerabilities.cvss.base_score                                            | The base CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | aws.securityhub_findings.vulnerabilities.cvss.base_vector                                           | The base scoring vector for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.vulnerabilities.cvss.source                                                | The origin of the original CVSS score and vector.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.vulnerabilities.cvss.version                                               | The version of CVSS for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.vulnerabilities.id                                                         | The identifier of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.vulnerabilities.reference_urls                                             | A list of URLs that provide additional information about the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.vulnerabilities.related_vulnerabilities                                    | List of vulnerabilities that are related to this vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings.vulnerabilities.vendor.created_at                                          | Indicates when the vulnerability advisory was created.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
  | aws.securityhub_findings.vulnerabilities.vendor.name                                                | The name of the vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings.vulnerabilities.vendor.severity                                            | The severity that the vendor assigned to the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.vulnerabilities.vendor.updated_at                                          | Indicates when the vulnerability advisory was last updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.securityhub_findings.vulnerabilities.vendor.url                                                 | The URL of the vulnerability advisory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.architecture                           | The architecture used for the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.epoch                                  | The epoch of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.file_path                              | The file system path to the package manager inventory file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.name                                   | The name of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.package_manager                        | The source of the package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.release                                | The release of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.vulnerabilities.vulnerable_packages.version                                | The version of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings.workflow.state                                                             | The workflow state of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings.workflow.status                                                            | The status of the investigation into the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.image.id                                                                                      | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.provider                                                                                      | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.dataset                                                                                 | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                      | constant_keyword |
  | data_stream.namespace                                                                               | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                     | constant_keyword |
  | data_stream.type                                                                                    | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                   | constant_keyword |
  | event.dataset                                                                                       | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                                                                                                    | constant_keyword |
  | event.kind                                                                                          | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword          |
  | event.module                                                                                        | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                                                                                                   | constant_keyword |
  | host.containerized                                                                                  | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | boolean          |
  | host.os.build                                                                                       | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.codename                                                                                    | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                                                                                          | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | log.offset                                                                                          | Log offset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | observer.vendor                                                                                     | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | resource.id                                                                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | resource.name                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | resource.type                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | result.evaluation                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | rule.remediation                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | url.user_info                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### Findings Full Posture

This is the [`securityhub_findings_full_posture`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindings.html#API_GetFindings_ResponseElements) data stream.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-12-09T05:41:36.060358393Z",
      "agent": {
          "ephemeral_id": "2fc81c8f-5b52-4a9c-93d7-85d9dedab857",
          "id": "a97254ef-b03a-4701-8ffd-0d94d12aa849",
          "name": "elastic-agent-75964",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "aws": {
          "securityhub_findings_full_posture": {
              "action": {
                  "port_probe": {
                      "blocked": false,
                      "details": [
                          {
                              "local": {
                                  "ip": {
                                      "address_v4": "1.128.0.0"
                                  },
                                  "port": {
                                      "name": "HTTP",
                                      "number": 80
                                  }
                              },
                              "remote_ip": {
                                  "city": {
                                      "name": "Example City"
                                  },
                                  "country": {
                                      "name": "Example Country"
                                  },
                                  "geolocation": {
                                      "latitude": 0,
                                      "longitude": 0
                                  },
                                  "organization": {
                                      "asn": "64496",
                                      "asn_organization": "ExampleASO",
                                      "internet_provider": "ExampleOrg",
                                      "internet_service_provider": "ExampleISP"
                                  }
                              }
                          }
                      ]
                  }
              },
              "aws_account_id": "111111111111",
              "company": {
                  "name": "AWS"
              },
              "compliance": {
                  "related_requirements": [
                      "Req1",
                      "Req2"
                  ],
                  "status": "PASSED",
                  "status_reasons": [
                      {
                          "description": "CloudWatch alarms do not exist in the account",
                          "reason_code": "CLOUDWATCH_ALARMS_NOT_PRESENT"
                      }
                  ]
              },
              "confidence": 42,
              "criticality": 99,
              "description": "The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.",
              "first_observed_at": "2017-03-22T13:22:13.933Z",
              "generator": {
                  "id": "acme-vuln-9ab348"
              },
              "last_observed_at": "2017-03-23T13:22:13.933Z",
              "malware": [
                  {
                      "name": "Stringler",
                      "path": "/usr/sbin/stringler",
                      "state": "OBSERVED",
                      "type": "COIN_MINER"
                  }
              ],
              "network": {
                  "open_port_range": {
                      "begin": 443,
                      "end": 443
                  }
              },
              "network_path": [
                  {
                      "component": {
                          "id": "abc-01a234bc56d8901ee",
                          "type": "AWS::EC2::InternetGateway"
                      },
                      "egress": {
                          "destination": {
                              "address": [
                                  "1.128.0.0/24"
                              ],
                              "port_ranges": [
                                  {
                                      "begin": 443,
                                      "end": 443
                                  }
                              ]
                          },
                          "protocol": "TCP",
                          "source": {
                              "address": [
                                  "175.16.199.1/24"
                              ]
                          }
                      },
                      "ingress": {
                          "destination": {
                              "address": [
                                  "175.16.199.1/24"
                              ],
                              "port_ranges": [
                                  {
                                      "begin": 443,
                                      "end": 443
                                  }
                              ]
                          },
                          "protocol": "TCP",
                          "source": {
                              "address": [
                                  "175.16.199.1/24"
                              ]
                          }
                      }
                  }
              ],
              "note": {
                  "text": "Don't forget to check under the mat.",
                  "updated_at": "2018-08-31T00:15:09.000Z",
                  "updated_by": "jsmith"
              },
              "patch_summary": {
                  "failed": {
                      "count": 0
                  },
                  "id": "pb-123456789098",
                  "installed": {
                      "count": 100,
                      "other": {
                          "count": 1023
                      },
                      "pending_reboot": 0,
                      "rejected": {
                          "count": 0
                      }
                  },
                  "missing": {
                      "count": 100
                  },
                  "operation": {
                      "end_time": "2018-09-27T23:39:31.000Z",
                      "start_time": "2018-09-27T23:37:31.000Z",
                      "type": "Install"
                  },
                  "reboot_option": "RebootIfNeeded"
              },
              "product": {
                  "arn": "arn:aws:securityhub:us-east-1:111111111111:product/111111111111/default",
                  "fields": {
                      "Service_Name": "cloudtrail.amazonaws.com",
                      "aws/inspector/AssessmentTargetName": "My prod env",
                      "aws/inspector/AssessmentTemplateName": "My daily CVE assessment",
                      "aws/inspector/RulesPackageName": "Common Vulnerabilities and Exposures",
                      "generico/secure-pro/Count": "6"
                  },
                  "name": "Security Hub"
              },
              "provider_fields": {
                  "confidence": 42,
                  "criticality": 99,
                  "related_findings": [
                      {
                          "id": "123e4567-e89b-12d3-a456-426655440000",
                          "product": {
                              "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                          }
                      }
                  ],
                  "severity": {
                      "label": "MEDIUM",
                      "original": "MEDIUM"
                  },
                  "types": [
                      "Software and Configuration Checks/Vulnerabilities/CVE"
                  ]
              },
              "record_state": "ACTIVE",
              "region": "us-east-1",
              "related_findings": [
                  {
                      "id": "123e4567-e89b-12d3-a456-426655440000",
                      "product": {
                          "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                      }
                  },
                  {
                      "id": "AcmeNerfHerder-111111111111-x189dx7824",
                      "product": {
                          "arn": "arn:aws:securityhub:us-west-2::product/aws/guardduty"
                      }
                  }
              ],
              "remediation": {
                  "recommendation": {
                      "text": "Run sudo yum update and cross your fingers and toes.",
                      "url": "http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html"
                  }
              },
              "resources": [
                  {
                      "Details": {
                          "IamInstanceProfileArn": "arn:aws:iam::123456789012:role/IamInstanceProfileArn",
                          "ImageId": "ami-79fd7eee",
                          "IpV4Addresses": [
                              "175.16.199.1"
                          ],
                          "IpV6Addresses": [
                              "2a02:cf40::"
                          ],
                          "KeyName": "testkey",
                          "LaunchedAt": "2018-09-29T01:25:54Z",
                          "MetadataOptions": {
                              "HttpEndpoint": "enabled",
                              "HttpProtocolIpv6": "enabled",
                              "HttpPutResponseHopLimit": 1,
                              "HttpTokens": "optional",
                              "InstanceMetadataTags": "disabled"
                          },
                          "NetworkInterfaces": [
                              {
                                  "NetworkInterfaceId": "eni-e5aa89a3"
                              }
                          ],
                          "SubnetId": "PublicSubnet",
                          "Type": "i3.xlarge",
                          "VirtualizationType": "hvm",
                          "VpcId": "TestVPCIpv6"
                      },
                      "Id": "i-cafebabe",
                      "Partition": "aws",
                      "Region": "us-west-2",
                      "Tags": {
                          "billingCode": "Lotus-1-2-3",
                          "needsPatching": "true"
                      },
                      "Type": "AwsEc2Instance"
                  }
              ],
              "sample": true,
              "schema": {
                  "version": "2018-10-08"
              },
              "severity": {
                  "label": "CRITICAL",
                  "original": "8.3"
              },
              "source_url": "http://threatintelweekly.org/backdoors/8888",
              "threat_intel_indicators": [
                  {
                      "category": "BACKDOOR",
                      "source": "Threat Intel Weekly",
                      "source_url": "http://threatintelweekly.org/backdoors/8888",
                      "value": "175.16.199.1"
                  }
              ],
              "title": "EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up",
              "types": [
                  "Software and Configuration Checks/Vulnerabilities/CVE"
              ],
              "updated_at": "2018-08-31T00:15:09.000Z",
              "user_defined_fields": {
                  "comeBackToLater": "Check this again on Monday",
                  "reviewedByCio": "true"
              },
              "verification_state": "UNKNOWN",
              "vulnerabilities": [
                  {
                      "cvss": [
                          {
                              "base_score": 4.7,
                              "base_vector": "AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N",
                              "version": "V3"
                          },
                          {
                              "base_score": 4.7,
                              "base_vector": "AV:L/AC:M/Au:N/C:C/I:N/A:N",
                              "version": "V2"
                          }
                      ],
                      "related_vulnerabilities": [
                          "CVE-2020-12345"
                      ],
                      "vendor": {
                          "created_at": "2020-01-16T00:01:43.000Z",
                          "severity": "Medium",
                          "updated_at": "2020-01-16T00:01:43.000Z",
                          "url": "https://alas.aws.amazon.com/ALAS-2020-1337.html"
                      },
                      "vulnerable_packages": [
                          {
                              "architecture": "x86_64",
                              "epoch": "1",
                              "name": "openssl",
                              "release": "16.amzn2.0.3",
                              "version": "1.0.2k"
                          }
                      ]
                  }
              ],
              "workflow": {
                  "state": "NEW",
                  "status": "NEW"
              }
          }
      },
      "cloud": {
          "account": {
              "id": "111111111111"
          },
          "instance": {
              "id": "i-cafebabe",
              "name": "i-cafebabe"
          },
          "provider": "aws",
          "region": "us-east-1"
      },
      "data_stream": {
          "dataset": "aws.securityhub_findings_full_posture",
          "namespace": "28602",
          "type": "logs"
      },
      "destination": {
          "domain": "example2.com",
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ],
          "port": 80
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "a97254ef-b03a-4701-8ffd-0d94d12aa849",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "port_probe",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-12-09T05:41:33.075Z",
          "dataset": "aws.securityhub_findings_full_posture",
          "id": "us-west-2/111111111111/98aebb2207407c87f51e89943f12b1ef",
          "ingested": "2025-12-09T05:41:36Z",
          "kind": "state",
          "original": "{\"Action\":{\"ActionType\":\"PORT_PROBE\",\"PortProbeAction\":{\"Blocked\":false,\"PortProbeDetails\":[{\"LocalIpDetails\":{\"IpAddressV4\":\"1.128.0.0\"},\"LocalPortDetails\":{\"Port\":80,\"PortName\":\"HTTP\"},\"RemoteIpDetails\":{\"City\":{\"CityName\":\"Example City\"},\"Country\":{\"CountryName\":\"Example Country\"},\"GeoLocation\":{\"Lat\":0,\"Lon\":0},\"Organization\":{\"Asn\":64496,\"AsnOrg\":\"ExampleASO\",\"Isp\":\"ExampleISP\",\"Org\":\"ExampleOrg\"}}}]}},\"AwsAccountId\":\"111111111111\",\"CompanyName\":\"AWS\",\"Compliance\":{\"RelatedRequirements\":[\"Req1\",\"Req2\"],\"Status\":\"PASSED\",\"StatusReasons\":[{\"Description\":\"CloudWatch alarms do not exist in the account\",\"ReasonCode\":\"CLOUDWATCH_ALARMS_NOT_PRESENT\"}]},\"Confidence\":42,\"CreatedAt\":\"2017-03-22T13:22:13.933Z\",\"Criticality\":99,\"Description\":\"The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.\",\"FindingProviderFields\":{\"Confidence\":42,\"Criticality\":99,\"RelatedFindings\":[{\"Id\":\"123e4567-e89b-12d3-a456-426655440000\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"}],\"Severity\":{\"Label\":\"MEDIUM\",\"Original\":\"MEDIUM\"},\"Types\":[\"Software and Configuration Checks/Vulnerabilities/CVE\"]},\"FirstObservedAt\":\"2017-03-22T13:22:13.933Z\",\"GeneratorId\":\"acme-vuln-9ab348\",\"Id\":\"us-west-2/111111111111/98aebb2207407c87f51e89943f12b1ef\",\"LastObservedAt\":\"2017-03-23T13:22:13.933Z\",\"Malware\":[{\"Name\":\"Stringler\",\"Path\":\"/usr/sbin/stringler\",\"State\":\"OBSERVED\",\"Type\":\"COIN_MINER\"}],\"Network\":{\"DestinationDomain\":\"example2.com\",\"DestinationIpV4\":\"1.128.0.0\",\"DestinationIpV6\":\"2a02:cf40::\",\"DestinationPort\":\"80\",\"Direction\":\"IN\",\"OpenPortRange\":{\"Begin\":443,\"End\":443},\"Protocol\":\"TCP\",\"SourceDomain\":\"example1.com\",\"SourceIpV4\":\"1.128.0.0\",\"SourceIpV6\":\"2a02:cf40::\",\"SourceMac\":\"00:0d:83:b1:c0:8e\",\"SourcePort\":\"42\"},\"NetworkPath\":[{\"ComponentId\":\"abc-01a234bc56d8901ee\",\"ComponentType\":\"AWS::EC2::InternetGateway\",\"Egress\":{\"Destination\":{\"Address\":[\"1.128.0.0/24\"],\"PortRanges\":[{\"Begin\":443,\"End\":443}]},\"Protocol\":\"TCP\",\"Source\":{\"Address\":[\"175.16.199.1/24\"]}},\"Ingress\":{\"Destination\":{\"Address\":[\"175.16.199.1/24\"],\"PortRanges\":[{\"Begin\":443,\"End\":443}]},\"Protocol\":\"TCP\",\"Source\":{\"Address\":[\"175.16.199.1/24\"]}}}],\"Note\":{\"Text\":\"Don't forget to check under the mat.\",\"UpdatedAt\":\"2018-08-31T00:15:09Z\",\"UpdatedBy\":\"jsmith\"},\"PatchSummary\":{\"FailedCount\":\"0\",\"Id\":\"pb-123456789098\",\"InstalledCount\":\"100\",\"InstalledOtherCount\":\"1023\",\"InstalledPendingReboot\":\"0\",\"InstalledRejectedCount\":\"0\",\"MissingCount\":\"100\",\"Operation\":\"Install\",\"OperationEndTime\":\"2018-09-27T23:39:31Z\",\"OperationStartTime\":\"2018-09-27T23:37:31Z\",\"RebootOption\":\"RebootIfNeeded\"},\"Process\":{\"LaunchedAt\":\"2018-09-27T22:37:31Z\",\"Name\":\"syslogd\",\"ParentPid\":56789,\"Path\":\"/usr/sbin/syslogd\",\"Pid\":12345,\"TerminatedAt\":\"2018-09-27T23:37:31Z\"},\"ProductArn\":\"arn:aws:securityhub:us-east-1:111111111111:product/111111111111/default\",\"ProductFields\":{\"Service_Name\":\"cloudtrail.amazonaws.com\",\"aws/inspector/AssessmentTargetName\":\"My prod env\",\"aws/inspector/AssessmentTemplateName\":\"My daily CVE assessment\",\"aws/inspector/RulesPackageName\":\"Common Vulnerabilities and Exposures\",\"generico/secure-pro/Count\":\"6\"},\"ProductName\":\"Security Hub\",\"RecordState\":\"ACTIVE\",\"Region\":\"us-east-1\",\"RelatedFindings\":[{\"Id\":\"123e4567-e89b-12d3-a456-426655440000\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"},{\"Id\":\"AcmeNerfHerder-111111111111-x189dx7824\",\"ProductArn\":\"arn:aws:securityhub:us-west-2::product/aws/guardduty\"}],\"Remediation\":{\"Recommendation\":{\"Text\":\"Run sudo yum update and cross your fingers and toes.\",\"Url\":\"http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html\"}},\"Resources\":[{\"Details\":{\"IamInstanceProfileArn\":\"arn:aws:iam::123456789012:role/IamInstanceProfileArn\",\"ImageId\":\"ami-79fd7eee\",\"IpV4Addresses\":[\"175.16.199.1\"],\"IpV6Addresses\":[\"2a02:cf40::\"],\"KeyName\":\"testkey\",\"LaunchedAt\":\"2018-09-29T01:25:54Z\",\"MetadataOptions\":{\"HttpEndpoint\":\"enabled\",\"HttpProtocolIpv6\":\"enabled\",\"HttpPutResponseHopLimit\":1,\"HttpTokens\":\"optional\",\"InstanceMetadataTags\":\"disabled\"},\"NetworkInterfaces\":[{\"NetworkInterfaceId\":\"eni-e5aa89a3\"}],\"SubnetId\":\"PublicSubnet\",\"Type\":\"i3.xlarge\",\"VirtualizationType\":\"hvm\",\"VpcId\":\"TestVPCIpv6\"},\"Id\":\"i-cafebabe\",\"Partition\":\"aws\",\"Region\":\"us-west-2\",\"Tags\":{\"billingCode\":\"Lotus-1-2-3\",\"needsPatching\":\"true\"},\"Type\":\"AwsEc2Instance\"}],\"Sample\":true,\"SchemaVersion\":\"2018-10-08\",\"Severity\":{\"Label\":\"CRITICAL\",\"Original\":\"8.3\"},\"SourceUrl\":\"http://threatintelweekly.org/backdoors/8888\",\"ThreatIntelIndicators\":[{\"Category\":\"BACKDOOR\",\"LastObservedAt\":\"2018-09-27T23:37:31Z\",\"Source\":\"Threat Intel Weekly\",\"SourceUrl\":\"http://threatintelweekly.org/backdoors/8888\",\"Type\":\"IPV4_ADDRESS\",\"Value\":\"175.16.199.1\"}],\"Threats\":[{\"FilePaths\":[{\"FileName\":\"b.txt\",\"FilePath\":\"/tmp/b.txt\",\"Hash\":\"sha256\",\"ResourceId\":\"arn:aws:ec2:us-west-2:123456789012:volume/vol-032f3bdd89aee112f\"}],\"ItemCount\":3,\"Name\":\"Iot.linux.mirai.vwisi\",\"Severity\":\"HIGH\"}],\"Title\":\"EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up\",\"Types\":[\"Software and Configuration Checks/Vulnerabilities/CVE\"],\"UpdatedAt\":\"2018-08-31T00:15:09Z\",\"UserDefinedFields\":{\"comeBackToLater\":\"Check this again on Monday\",\"reviewedByCio\":\"true\"},\"VerificationState\":\"UNKNOWN\",\"Vulnerabilities\":[{\"Cvss\":[{\"BaseScore\":4.7,\"BaseVector\":\"AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N\",\"Version\":\"V3\"},{\"BaseScore\":4.7,\"BaseVector\":\"AV:L/AC:M/Au:N/C:C/I:N/A:N\",\"Version\":\"V2\"}],\"Id\":\"CVE-2020-12345\",\"ReferenceUrls\":[\"http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-12418\",\"http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-17563\"],\"RelatedVulnerabilities\":[\"CVE-2020-12345\"],\"Vendor\":{\"Name\":\"Alas\",\"Url\":\"https://alas.aws.amazon.com/ALAS-2020-1337.html\",\"VendorCreatedAt\":\"2020-01-16T00:01:43Z\",\"VendorSeverity\":\"Medium\",\"VendorUpdatedAt\":\"2020-01-16T00:01:43Z\"},\"VulnerablePackages\":[{\"Architecture\":\"x86_64\",\"Epoch\":\"1\",\"Name\":\"openssl\",\"Release\":\"16.amzn2.0.3\",\"Version\":\"1.0.2k\"}]}],\"Workflow\":{\"Status\":\"NEW\"},\"WorkflowState\":\"NEW\"}",
          "outcome": "success",
          "type": [
              "info"
          ]
      },
      "host": {
          "id": "i-cafebabe"
      },
      "input": {
          "type": "httpjson"
      },
      "network": {
          "direction": "inbound",
          "protocol": "tcp"
      },
      "observer": {
          "vendor": "AWS Security Hub CSPM"
      },
      "organization": {
          "name": "AWS"
      },
      "process": {
          "end": "2018-09-27T23:37:31.000Z",
          "executable": "/usr/sbin/syslogd",
          "name": "syslogd",
          "parent": {
              "pid": 56789
          },
          "pid": 12345,
          "start": "2018-09-27T22:37:31.000Z"
      },
      "related": {
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ]
      },
      "resource": {
          "id": "i-cafebabe",
          "name": "i-cafebabe",
          "type": "AwsEc2Instance"
      },
      "result": {
          "evaluation": "passed"
      },
      "rule": {
          "description": "The version of openssl found on instance i-abcd1234 is known to contain a vulnerability.",
          "id": "acme-vuln-9ab348",
          "name": "EC2.20 Both VPN tunnels for an AWS Site-to-Site VPN connection should be up",
          "reference": "http://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html",
          "remediation": "Run sudo yum update and cross your fingers and toes.\r\nhttp://myfp.com/recommendations/dangerous_things_and_how_to_fix_them.html",
          "ruleset": [
              "Req1",
              "Req2"
          ]
      },
      "source": {
          "domain": "example1.com",
          "ip": [
              "1.128.0.0",
              "2a02:cf40::"
          ],
          "mac": "00-0D-83-B1-C0-8E",
          "port": 42
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "aws_securityhub_findings_full_posture"
      ],
      "threat": {
          "indicator": {
              "last_seen": "2018-09-27T23:37:31.000Z",
              "type": "ipv4-addr"
          }
      },
      "url": {
          "domain": "threatintelweekly.org",
          "full": "http://threatintelweekly.org/backdoors/8888",
          "original": "http://threatintelweekly.org/backdoors/8888",
          "path": "/backdoors/8888",
          "scheme": "http"
      },
      "vulnerability": {
          "id": "CVE-2020-12345",
          "reference": [
              "http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-12418",
              "http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-17563"
          ],
          "scanner": {
              "vendor": "Alas"
          },
          "score": {
              "base": 4.7,
              "version": "V2"
          }
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                                                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                                       | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | aws.securityhub_findings_full_posture.action.aws_api_call.affected_resources                                     | Identifies the resources that were affected by the API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | flattened        |
  | aws.securityhub_findings_full_posture.action.aws_api_call.api                                                    | The name of the API method that was issued.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.caller.type                                            | Indicates whether the API call originated from a remote IP address(remoteip) or from a DNS domain(domain).                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.domain_details.domain                                  | The name of the DNS domain that issued the API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.first_seen                                             | An ISO8601-formatted timestamp that indicates when the API call was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | aws.securityhub_findings_full_posture.action.aws_api_call.last_seen                                              | An ISO8601-formatted timestamp that indicates when the API call was most recently observed.                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.city.name                                    | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.country.code                                 | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.country.name                                 | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.geolocation.latitude                         | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.geolocation.longitude                        | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | double           |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.ip.address_v4                                | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.organization.asn                             | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.organization.asn_organization                | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.organization.internet_provider               | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.remote_ip.organization.internet_service_provider       | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.action.aws_api_call.service.name                                           | The name of the Amazon Web Services service that the API method belongs to.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.dns_request.blocked                                                 | Indicates whether the DNS request was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | aws.securityhub_findings_full_posture.action.dns_request.domain                                                  | The DNS domain that is associated with the DNS request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.action.dns_request.protocol                                                | The protocol that was used for the DNS request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.blocked                                          | Indicates whether the network connection attempt was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | aws.securityhub_findings_full_posture.action.network_connection.direction                                        | The direction of the network connection request(IN or OUT).                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.local.port.name                                  | The port name of the local connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.local.port.number                                | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | aws.securityhub_findings_full_posture.action.network_connection.protocol                                         | The protocol used to make the network connection request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote.port.name                                 | The port name of the remote connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote.port.number                               | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.city.name                              | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.country.code                           | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.country.name                           | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.geolocation.latitude                   | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.geolocation.longitude                  | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | double           |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.ip.address_v4                          | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.organization.asn                       | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.organization.asn_organization          | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.organization.internet_provider         | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.action.network_connection.remote_ip.organization.internet_service_provider | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.blocked                                                  | Indicates whether the port probe was blocked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.local.ip.address_v4                              | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | aws.securityhub_findings_full_posture.action.port_probe.details.local.port.name                                  | The port name of the local connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.local.port.number                                | The number of the port.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.city.name                              | The name of the city.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.country.code                           | The 2-letter ISO 3166 country code for the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.country.name                           | The name of the country.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.geolocation.latitude                   | The longitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.geolocation.longitude                  | The latitude of the location.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | double           |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.ip.address_v4                          | The IP address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.organization.asn                       | The Autonomous System Number(ASN) of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.organization.asn_organization          | The name of the organization that registered the ASN.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.organization.internet_provider         | The ISP information for the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.action.port_probe.details.remote_ip.organization.internet_service_provider | The name of the internet provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.action.type                                                                | The type of action that was detected.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.aws_account_id                                                             | The Amazon Web Services account ID that a finding is generated in.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.company.name                                                               | The name of the company for the product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.compliance.related_requirements                                            | For a control, the industry or regulatory framework requirements that are related to the control.                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.compliance.security_control_id                                             | Unique identifier of a control across standards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.compliance.status                                                          | The result of a standards check.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.compliance.status_reasons.description                                      | The corresponding description for the status reason code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_findings_full_posture.compliance.status_reasons.reason_code                                      | A code that represents a reason for the control status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.confidence                                                                 | A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings_full_posture.created_at                                                                 | Indicates when the security-findings provider created the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | aws.securityhub_findings_full_posture.criticality                                                                | The level of importance assigned to the resources associated with the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_findings_full_posture.description                                                                | A finding's description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.first_observed_at                                                          | Indicates when the security-findings provider first observed the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | aws.securityhub_findings_full_posture.generator.id                                                               | The identifier for the solution-specific component(a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.id                                                                         | The security findings provider-specific identifier for a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.last_observed_at                                                           | Indicates when the security-findings provider most recently observed the potential security issue that a finding captured.                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | aws.securityhub_findings_full_posture.malware.name                                                               | The name of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.malware.path                                                               | The file system path of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.malware.state                                                              | The state of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.malware.type                                                               | The type of the malware that was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.network.destination.domain                                                 | The destination domain of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.network.destination.ip.v4                                                  | The destination IPv4 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |
  | aws.securityhub_findings_full_posture.network.destination.ip.v6                                                  | The destination IPv6 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |
  | aws.securityhub_findings_full_posture.network.destination.port                                                   | The destination port of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | aws.securityhub_findings_full_posture.network.direction                                                          | The direction of network traffic associated with a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.network.open_port_range.begin                                              | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings_full_posture.network.open_port_range.end                                                | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.securityhub_findings_full_posture.network.protocol                                                           | The protocol of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings_full_posture.network.source.domain                                                      | The source domain of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.network.source.ip.v4                                                       | The source IPv4 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | aws.securityhub_findings_full_posture.network.source.ip.v6                                                       | The source IPv6 address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | aws.securityhub_findings_full_posture.network.source.mac                                                         | The source media access control(MAC) address of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.securityhub_findings_full_posture.network.source.port                                                        | The source port of network-related information about a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | aws.securityhub_findings_full_posture.network_path.component.id                                                  | The identifier of a component in the network path.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.network_path.component.type                                                | The type of component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.network_path.egress.destination.address                                    | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.egress.destination.port_ranges.begin                          | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings_full_posture.network_path.egress.destination.port_ranges.end                            | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.securityhub_findings_full_posture.network_path.egress.protocol                                               | The protocol used for the component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.egress.source.address                                         | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.egress.source.port_ranges.begin                               | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings_full_posture.network_path.egress.source.port_ranges.end                                 | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.securityhub_findings_full_posture.network_path.ingress.destination.address                                   | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.ingress.destination.port_ranges.begin                         | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings_full_posture.network_path.ingress.destination.port_ranges.end                           | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.securityhub_findings_full_posture.network_path.ingress.protocol                                              | The protocol used for the component.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.ingress.source.address                                        | The IP addresses of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.network_path.ingress.source.port_ranges.begin                              | The first port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.securityhub_findings_full_posture.network_path.ingress.source.port_ranges.end                                | The last port in the port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.securityhub_findings_full_posture.note.text                                                                  | The text of a note.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.note.updated_at                                                            | The timestamp of when the note was updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | aws.securityhub_findings_full_posture.note.updated_by                                                            | The principal that created a note.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.patch_summary.failed.count                                                 | The number of patches from the compliance standard that failed to install.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | aws.securityhub_findings_full_posture.patch_summary.id                                                           | The identifier of the compliance standard that was used to determine the patch compliance status.                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.patch_summary.installed.count                                              | The number of patches from the compliance standard that were installed successfully.                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | aws.securityhub_findings_full_posture.patch_summary.installed.other.count                                        | The number of installed patches that are not part of the compliance standard.                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | aws.securityhub_findings_full_posture.patch_summary.installed.pending_reboot                                     | The number of patches that were applied, but that require the instance to be rebooted in order to be marked as installed.                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | aws.securityhub_findings_full_posture.patch_summary.installed.rejected.count                                     | The number of patches that are installed but are also on a list of patches that the customer rejected.                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | aws.securityhub_findings_full_posture.patch_summary.missing.count                                                | The number of patches that are part of the compliance standard but are not installed. The count includes patches that failed to install.                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | aws.securityhub_findings_full_posture.patch_summary.operation.end_time                                           | Indicates when the operation completed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_findings_full_posture.patch_summary.operation.start_time                                         | Indicates when the operation started.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | aws.securityhub_findings_full_posture.patch_summary.operation.type                                               | The type of patch operation performed. For Patch Manager, the values are SCAN and INSTALL.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.patch_summary.reboot_option                                                | The reboot option specified for the instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings_full_posture.process.launched_at                                                        | Indicates when the process was launched.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_findings_full_posture.process.name                                                               | The name of the process.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.process.parent.pid                                                         | The parent process ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | aws.securityhub_findings_full_posture.process.path                                                               | The path to the process executable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.process.pid                                                                | The process ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | aws.securityhub_findings_full_posture.process.terminated_at                                                      | Indicates when the process was terminated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | aws.securityhub_findings_full_posture.processed_at                                                               | Indicates when AWS Security Hub received a finding and begins to process it.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | date             |
  | aws.securityhub_findings_full_posture.product.arn                                                                | The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.product.fields                                                             | A data type where security-findings providers can include additional solution-specific details that aren't part of the defined AwsSecurityFinding format.                                                                                                                                                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_findings_full_posture.product.name                                                               | The name of the product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.confidence                                                 | A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.securityhub_findings_full_posture.provider_fields.criticality                                                | The level of importance assigned to the resources associated with the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_findings_full_posture.provider_fields.related_findings.id                                        | The product-generated identifier for a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.related_findings.product.arn                               | The ARN of the product that generated a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.severity.label                                             | The severity label assigned to the finding by the finding provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.severity.normalized                                        | The normalized severity of a finding provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.severity.original                                          | The finding provider's original value for the severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.severity.product                                           | The finding provider's product for the severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.provider_fields.types                                                      | One or more finding types in the format of namespace/category/classifier that classify a finding.                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.record_state                                                               | The record state of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.region                                                                     | The Region from which the finding was generated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.related_findings.id                                                        | The product-generated identifier for a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.related_findings.product.arn                                               | The ARN of the product that generated a related finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.remediation.recommendation.text                                            | Describes the recommended steps to take to remediate an issue identified in a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                       | text             |
  | aws.securityhub_findings_full_posture.remediation.recommendation.url                                             | A URL to a page or site that contains information about how to remediate a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.resources                                                                  | A set of resource data types that describe the resources that the finding refers to.                                                                                                                                                                                                                                                                                                                                                                                                                                         | flattened        |
  | aws.securityhub_findings_full_posture.sample                                                                     | Indicates whether the finding is a sample finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | aws.securityhub_findings_full_posture.schema.version                                                             | The schema version that a finding is formatted for.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.securityhub_findings_full_posture.severity.label                                                             | The severity value of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.severity.normalized                                                        | The normalized severity of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.severity.original                                                          | The native severity from the finding product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.securityhub_findings_full_posture.severity.product                                                           | The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.source_url                                                                 | A URL that links to a page about the current finding in the security-findings provider's solution.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.category                                           | The category of a threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.last_observed_at                                   | Indicates when the most recent instance of a threat intelligence indicator was observed.                                                                                                                                                                                                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.source                                             | The source of the threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.source_url                                         | The URL to the page or site where you can get more information about the threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.type                                               | The type of threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.threat_intel_indicators.value                                              | The value of a threat intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_findings_full_posture.title                                                                      | A finding's title.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | text             |
  | aws.securityhub_findings_full_posture.types                                                                      | One or more finding types in the format of namespace/category/classifier that classify a finding.                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.updated_at                                                                 | Indicates when the security-findings provider last updated the finding record.                                                                                                                                                                                                                                                                                                                                                                                                                                               | date             |
  | aws.securityhub_findings_full_posture.user_defined_fields                                                        | A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.                                                                                                                                                                                                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_findings_full_posture.verification_state                                                         | Indicates the veracity of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.adjustments.metric                                    | The metric to adjust.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.adjustments.reason                                    | The reason for the adjustment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.base_score                                            | The base CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | double           |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.base_vector                                           | The base scoring vector for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.source                                                | The origin of the original CVSS score and vector.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.cvss.version                                               | The version of CVSS for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.id                                                         | The identifier of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.reference_urls                                             | A list of URLs that provide additional information about the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.related_vulnerabilities                                    | List of vulnerabilities that are related to this vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vendor.created_at                                          | Indicates when the vulnerability advisory was created.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.securityhub_findings_full_posture.vulnerabilities.vendor.name                                                | The name of the vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vendor.severity                                            | The severity that the vendor assigned to the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vendor.updated_at                                          | Indicates when the vulnerability advisory was last updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | aws.securityhub_findings_full_posture.vulnerabilities.vendor.url                                                 | The URL of the vulnerability advisory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.architecture                           | The architecture used for the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.epoch                                  | The epoch of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.file_path                              | The file system path to the package manager inventory file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.name                                   | The name of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.package_manager                        | The source of the package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.release                                | The release of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.vulnerabilities.vulnerable_packages.version                                | The version of the software package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.securityhub_findings_full_posture.workflow.state                                                             | The workflow state of a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.securityhub_findings_full_posture.workflow.status                                                            | The status of the investigation into the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.image.id                                                                                                   | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.provider                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.dataset                                                                                              | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                                                                            | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                                                                                 | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                                                                    | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.kind                                                                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.module                                                                                                     | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized                                                                                               | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build                                                                                                    | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                                                                                                 | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type                                                                                                       | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | log.offset                                                                                                       | Log offset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | observer.vendor                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | resource.id                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.name                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.type                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | result.evaluation                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | rule.remediation                                                                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | url.user_info                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


### Insights

This is the [`securityhub_insights`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsights.html#API_GetInsights_ResponseElements) data stream.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-12-09T09:35:13.696Z",
      "agent": {
          "ephemeral_id": "301055f2-e64f-49af-9475-186afec36268",
          "id": "fa813af5-4a32-4079-8743-a3f152e25625",
          "name": "elastic-agent-12387",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "aws": {
          "securityhub_insights": {
              "filters": {
                  "aws_account_id": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "company": {
                      "name": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "compliance": {
                      "status": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "confidence": [
                      {
                          "Eq": 20,
                          "Gte": 20,
                          "Lte": 20
                      }
                  ],
                  "created_at": [
                      {
                          "date_range": {
                              "unit": "string",
                              "value": 20
                          },
                          "end": "2020-07-10T15:00:00.000Z",
                          "start": "2020-07-10T15:00:00.000Z"
                      }
                  ],
                  "criticality": [
                      {
                          "Eq": 20,
                          "Gte": 20,
                          "Lte": 20
                      }
                  ],
                  "description": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "finding_provider_fields": {
                      "confidence": [
                          {
                              "Eq": 20,
                              "Gte": 20,
                              "Lte": 20
                          }
                      ],
                      "criticality": [
                          {
                              "Eq": 20,
                              "Gte": 20,
                              "Lte": 20
                          }
                      ],
                      "related_findings": {
                          "id": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "product": {
                              "arn": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          }
                      },
                      "severity": {
                          "label": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "original": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ]
                      },
                      "types": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "first_observed_at": [
                      {
                          "date_range": {
                              "unit": "string",
                              "value": 20
                          },
                          "end": "2020-07-10T15:00:00.000Z",
                          "start": "2020-07-10T15:00:00.000Z"
                      }
                  ],
                  "generator": {
                      "id": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "id": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "keyword": [
                      {
                          "Value": "string"
                      }
                  ],
                  "last_observed_at": [
                      {
                          "date_range": {
                              "unit": "string",
                              "value": 20
                          },
                          "end": "2020-07-10T15:00:00.000Z",
                          "start": "2020-07-10T15:00:00.000Z"
                      }
                  ],
                  "malware": {
                      "name": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "path": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "state": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "type": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "network": {
                      "destination": {
                          "domain": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "ip": {
                              "v4": [
                                  {
                                      "Cidr": "string"
                                  }
                              ],
                              "v6": [
                                  {
                                      "Cidr": "string"
                                  }
                              ]
                          },
                          "port": [
                              {
                                  "Eq": 20,
                                  "Gte": 20,
                                  "Lte": 20
                              }
                          ]
                      },
                      "direction": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "protocol": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "source": {
                          "domain": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "ip": {
                              "v4": [
                                  {
                                      "Cidr": "string"
                                  }
                              ],
                              "v6": [
                                  {
                                      "Cidr": "string"
                                  }
                              ]
                          },
                          "mac": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "port": [
                              {
                                  "Eq": 20,
                                  "Gte": 20,
                                  "Lte": 20
                              }
                          ]
                      }
                  },
                  "note": {
                      "text": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "updated_at": [
                          {
                              "date_range": {
                                  "unit": "string",
                                  "value": 20
                              },
                              "end": "2020-07-10T15:00:00.000Z",
                              "start": "2020-07-10T15:00:00.000Z"
                          }
                      ],
                      "updated_by": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "process": {
                      "launched_at": [
                          {
                              "date_range": {
                                  "unit": "string",
                                  "value": 20
                              },
                              "end": "2020-07-10T15:00:00.000Z",
                              "start": "2020-07-10T15:00:00.000Z"
                          }
                      ],
                      "name": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "parent": {
                          "pid": [
                              {
                                  "Eq": 20,
                                  "Gte": 20,
                                  "Lte": 20
                              }
                          ]
                      },
                      "path": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "pid": [
                          {
                              "Eq": 20,
                              "Gte": 20,
                              "Lte": 20
                          }
                      ],
                      "terminated_at": [
                          {
                              "date_range": {
                                  "unit": "string",
                                  "value": 20
                              },
                              "end": "2020-07-10T15:00:00.000Z",
                              "start": "2020-07-10T15:00:00.000Z"
                          }
                      ]
                  },
                  "product": {
                      "arn": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "fields": [
                          {
                              "Comparison": "string",
                              "Key": "string",
                              "Value": "string"
                          }
                      ],
                      "name": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "recommendation_text": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "record_state": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "region": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "related_findings": {
                      "id": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "product": {
                          "arn": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ]
                      }
                  },
                  "resource": {
                      "aws_ec2_instance": {
                          "iam_instance_profile": {
                              "arn": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "image": {
                              "id": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "ip": {
                              "v4_addresses": [
                                  {
                                      "Cidr": "string"
                                  }
                              ],
                              "v6_addresses": [
                                  {
                                      "Cidr": "string"
                                  }
                              ]
                          },
                          "key": {
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "launched_at": [
                              {
                                  "date_range": {
                                      "unit": "string",
                                      "value": 20
                                  },
                                  "end": "2020-07-10T15:00:00.000Z",
                                  "start": "2020-07-10T15:00:00.000Z"
                              }
                          ],
                          "subnet": {
                              "id": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "type": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "vpc": {
                              "id": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          }
                      },
                      "aws_iam_access_key": {
                          "created_at": [
                              {
                                  "date_range": {
                                      "unit": "string",
                                      "value": 20
                                  },
                                  "end": "2020-07-10T15:00:00.000Z",
                                  "start": "2020-07-10T15:00:00.000Z"
                              }
                          ],
                          "principal": {
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "status": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ],
                          "user": {
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          }
                      },
                      "aws_iam_user": {
                          "user": {
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          }
                      },
                      "aws_s3_bucket": {
                          "owner": {
                              "id": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ],
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          }
                      },
                      "container": {
                          "image": {
                              "id": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ],
                              "name": [
                                  {
                                      "Comparison": "string",
                                      "Value": "string"
                                  }
                              ]
                          },
                          "launched_at": [
                              {
                                  "date_range": {
                                      "unit": "string",
                                      "value": 20
                                  },
                                  "end": "2020-07-10T15:00:00.000Z",
                                  "start": "2020-07-10T15:00:00.000Z"
                              }
                          ],
                          "name": [
                              {
                                  "Comparison": "string",
                                  "Value": "string"
                              }
                          ]
                      },
                      "details_other": [
                          {
                              "Comparison": "string",
                              "Key": "string",
                              "Value": "string"
                          }
                      ],
                      "id": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "partition": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "region": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "tags": [
                          {
                              "Comparison": "string",
                              "Key": "string",
                              "Value": "string"
                          }
                      ],
                      "type": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "sample": [
                      {
                          "Value": true
                      }
                  ],
                  "severity": {
                      "label": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "normalized": [
                          {
                              "Eq": 20,
                              "Gte": 20,
                              "Lte": 20
                          }
                      ],
                      "product": [
                          {
                              "Eq": 20,
                              "Gte": 20,
                              "Lte": 20
                          }
                      ]
                  },
                  "source_url": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "threat_intel_indicator": {
                      "category": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "last_observed_at": [
                          {
                              "date_range": {
                                  "unit": "string",
                                  "value": 20
                              },
                              "end": "2020-07-10T15:00:00.000Z",
                              "start": "2020-07-10T15:00:00.000Z"
                          }
                      ],
                      "source": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "source_url": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "type": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "value": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "title": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "type": [
                      {
                          "Comparison": "string",
                          "Value": "string"
                      }
                  ],
                  "updated_at": [
                      {
                          "date_range": {
                              "unit": "string",
                              "value": 20
                          },
                          "end": "2020-07-10T15:00:00.000Z",
                          "start": "2020-07-10T15:00:00.000Z"
                      }
                  ],
                  "user_defined_fields": [
                      {
                          "Comparison": "string",
                          "Key": "string",
                          "Value": "string"
                      }
                  ],
                  "verification": {
                      "state": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  },
                  "workflow": {
                      "state": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ],
                      "status": [
                          {
                              "Comparison": "string",
                              "Value": "string"
                          }
                      ]
                  }
              },
              "group_by_attribute": "string",
              "insight_arn": "string",
              "name": "string"
          }
      },
      "data_stream": {
          "dataset": "aws.securityhub_insights",
          "namespace": "32954",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "fa813af5-4a32-4079-8743-a3f152e25625",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-12-09T09:35:13.696Z",
          "dataset": "aws.securityhub_insights",
          "ingested": "2025-12-09T09:35:16Z",
          "kind": "event",
          "original": "{\"Filters\":{\"AwsAccountId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"CompanyName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ComplianceStatus\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Confidence\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"CreatedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"Criticality\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"Description\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FindingProviderFieldsConfidence\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"FindingProviderFieldsCriticality\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"FindingProviderFieldsRelatedFindingsId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FindingProviderFieldsRelatedFindingsProductArn\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FindingProviderFieldsSeverityLabel\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FindingProviderFieldsSeverityOriginal\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FindingProviderFieldsTypes\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"FirstObservedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"GeneratorId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Id\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Keyword\":[{\"Value\":\"string\"}],\"LastObservedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"MalwareName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"MalwarePath\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"MalwareState\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"MalwareType\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkDestinationDomain\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkDestinationIpV4\":[{\"Cidr\":\"string\"}],\"NetworkDestinationIpV6\":[{\"Cidr\":\"string\"}],\"NetworkDestinationPort\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"NetworkDirection\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkProtocol\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkSourceDomain\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkSourceIpV4\":[{\"Cidr\":\"string\"}],\"NetworkSourceIpV6\":[{\"Cidr\":\"string\"}],\"NetworkSourceMac\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NetworkSourcePort\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"NoteText\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"NoteUpdatedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"NoteUpdatedBy\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ProcessLaunchedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ProcessName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ProcessParentPid\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"ProcessPath\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ProcessPid\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"ProcessTerminatedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ProductArn\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ProductFields\":[{\"Comparison\":\"string\",\"Key\":\"string\",\"Value\":\"string\"}],\"ProductName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"RecommendationText\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"RecordState\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Region\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"RelatedFindingsId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"RelatedFindingsProductArn\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceIamInstanceProfileArn\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceImageId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceIpV4Addresses\":[{\"Cidr\":\"string\"}],\"ResourceAwsEc2InstanceIpV6Addresses\":[{\"Cidr\":\"string\"}],\"ResourceAwsEc2InstanceKeyName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceLaunchedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ResourceAwsEc2InstanceSubnetId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceType\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsEc2InstanceVpcId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsIamAccessKeyCreatedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ResourceAwsIamAccessKeyPrincipalName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsIamAccessKeyStatus\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsIamAccessKeyUserName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsIamUserUserName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsS3BucketOwnerId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceAwsS3BucketOwnerName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceContainerImageId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceContainerImageName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceContainerLaunchedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ResourceContainerName\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceDetailsOther\":[{\"Comparison\":\"string\",\"Key\":\"string\",\"Value\":\"string\"}],\"ResourceId\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourcePartition\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceRegion\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ResourceTags\":[{\"Comparison\":\"string\",\"Key\":\"string\",\"Value\":\"string\"}],\"ResourceType\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Sample\":[{\"Value\":true}],\"SeverityLabel\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"SeverityNormalized\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"SeverityProduct\":[{\"Eq\":20,\"Gte\":20,\"Lte\":20}],\"SourceUrl\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ThreatIntelIndicatorCategory\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ThreatIntelIndicatorLastObservedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"ThreatIntelIndicatorSource\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ThreatIntelIndicatorSourceUrl\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ThreatIntelIndicatorType\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"ThreatIntelIndicatorValue\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Title\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"Type\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"UpdatedAt\":[{\"DateRange\":{\"Unit\":\"string\",\"Value\":20},\"End\":\"2020-07-10 15:00:00.000\",\"Start\":\"2020-07-10 15:00:00.000\"}],\"UserDefinedFields\":[{\"Comparison\":\"string\",\"Key\":\"string\",\"Value\":\"string\"}],\"VerificationState\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"WorkflowState\":[{\"Comparison\":\"string\",\"Value\":\"string\"}],\"WorkflowStatus\":[{\"Comparison\":\"string\",\"Value\":\"string\"}]},\"GroupByAttribute\":\"string\",\"InsightArn\":\"string\",\"Name\":\"string\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "AWS Security Hub CSPM"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "aws_securityhub_insights"
      ]
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                                     | Description                                                                                                                                                                                                                                                                           | Type             |
  |-------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                | Event timestamp.                                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.aws_account_id                                           | The Amazon Web Services account ID that a finding is generated in.                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.company.name                                             | The name of the findings provider(company) that owns the solution(product) that generates findings.                                                                                                                                                                                   | flattened        |
  | aws.securityhub_insights.filters.compliance.status                                        | Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.                                                               | flattened        |
  | aws.securityhub_insights.filters.confidence                                               | A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.created_at.date_range.unit                               | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.created_at.date_range.value                              | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.created_at.end                                           | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.created_at.start                                         | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.criticality                                              | The level of importance assigned to the resources associated with the finding.                                                                                                                                                                                                        | flattened        |
  | aws.securityhub_insights.filters.description                                              | A finding's description.                                                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.confidence                       | The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.                                                                                           | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.criticality                      | The finding provider value for the level of importance assigned to the resources associated with the findings.                                                                                                                                                                        | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.related_findings.id              | The finding identifier of a related finding that is identified by the finding provider.                                                                                                                                                                                               | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.related_findings.product.arn     | The ARN of the solution that generated a related finding that is identified by the finding provider.                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.severity.label                   | The finding provider value for the severity label.                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.severity.original                | The finding provider's original value for the severity.                                                                                                                                                                                                                               | flattened        |
  | aws.securityhub_insights.filters.finding_provider_fields.types                            | One or more finding types that the finding provider assigned to the finding. Uses the format of namespace/category/classifier that classify a finding.                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.first_observed_at.date_range.unit                        | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.first_observed_at.date_range.value                       | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.first_observed_at.end                                    | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.first_observed_at.start                                  | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.generator.id                                             | The identifier for the solution-specific component(a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.                                                    | flattened        |
  | aws.securityhub_insights.filters.id                                                       | The security findings provider-specific identifier for a finding.                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.keyword                                                  | A keyword for a finding.                                                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.last_observed_at.date_range.unit                         | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.last_observed_at.date_range.value                        | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.last_observed_at.end                                     | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.last_observed_at.start                                   | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.malware.name                                             | The name of the malware that was observed.                                                                                                                                                                                                                                            | flattened        |
  | aws.securityhub_insights.filters.malware.path                                             | The filesystem path of the malware that was observed.                                                                                                                                                                                                                                 | flattened        |
  | aws.securityhub_insights.filters.malware.state                                            | The state of the malware that was observed.                                                                                                                                                                                                                                           | flattened        |
  | aws.securityhub_insights.filters.malware.type                                             | The type of the malware that was observed.                                                                                                                                                                                                                                            | flattened        |
  | aws.securityhub_insights.filters.network.destination.domain                               | The destination domain of network-related information about a finding.                                                                                                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.network.destination.ip.v4                                | The destination IPv4 address of network-related information about a finding.                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.network.destination.ip.v6                                | The destination IPv6 address of network-related information about a finding.                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.network.destination.port                                 | The destination port of network-related information about a finding.                                                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.network.direction                                        | Indicates the direction of network traffic associated with a finding.                                                                                                                                                                                                                 | flattened        |
  | aws.securityhub_insights.filters.network.protocol                                         | The protocol of network-related information about a finding.                                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.network.source.domain                                    | The source domain of network-related information about a finding.                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.network.source.ip.v4                                     | The source IPv4 address of network-related information about a finding.                                                                                                                                                                                                               | flattened        |
  | aws.securityhub_insights.filters.network.source.ip.v6                                     | The source IPv6 address of network-related information about a finding.                                                                                                                                                                                                               | flattened        |
  | aws.securityhub_insights.filters.network.source.mac                                       | The source media access control(MAC) address of network-related information about a finding.                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.network.source.port                                      | The source port of network-related information about a finding.                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.filters.note.text                                                | The text of a note.                                                                                                                                                                                                                                                                   | flattened        |
  | aws.securityhub_insights.filters.note.updated_at.by                                       | The principal that created a note.                                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.note.updated_at.date_range.unit                          | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.note.updated_at.date_range.value                         | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.note.updated_at.end                                      | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.note.updated_at.start                                    | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.note.updated_by                                          | The text of a note.                                                                                                                                                                                                                                                                   | flattened        |
  | aws.securityhub_insights.filters.process.launched_at.date_range.unit                      | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.process.launched_at.date_range.value                     | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.process.launched_at.end                                  | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.process.launched_at.start                                | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.process.name                                             | The name of the process.                                                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.process.parent.pid                                       | The parent process ID.                                                                                                                                                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.process.path                                             | The path to the process executable.                                                                                                                                                                                                                                                   | flattened        |
  | aws.securityhub_insights.filters.process.pid                                              | The process ID.                                                                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.filters.process.terminated_at.date_range.unit                    | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.process.terminated_at.date_range.value                   | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.process.terminated_at.end                                | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.process.terminated_at.start                              | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.product.arn                                              | The ARN generated by Security Hub that uniquely identifies a third-party company(security findings provider) after this provider's product(solution that generates findings) is registered with Security Hub.                                                                         | flattened        |
  | aws.securityhub_insights.filters.product.fields                                           | A data type where security-findings providers can include additional solution-specific details that aren't part of the defined AwsSecurityFinding format.                                                                                                                             | flattened        |
  | aws.securityhub_insights.filters.product.name                                             | The name of the solution(product) that generates findings.                                                                                                                                                                                                                            | flattened        |
  | aws.securityhub_insights.filters.recommendation_text                                      | The recommendation of what to do about the issue described in a finding.                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.record_state                                             | The updated record state for the finding.                                                                                                                                                                                                                                             | flattened        |
  | aws.securityhub_insights.filters.region                                                   | The Region from which the finding was generated.                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.related_findings.id                                      | The solution-generated identifier for a related finding.                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.related_findings.product.arn                             | The ARN of the solution that generated a related finding.                                                                                                                                                                                                                             | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.iam_instance_profile.arn       | The IAM profile ARN of the instance.                                                                                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.image.id                       | The Amazon Machine Image(AMI) ID of the instance.                                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.ip.v4_addresses                | The IPv4 addresses associated with the instance.                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.ip.v6_addresses                | The IPv6 addresses associated with the instance.                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.key.name                       | The key name associated with the instance.                                                                                                                                                                                                                                            | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.launched_at.date_range.unit    | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.launched_at.date_range.value   | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.launched_at.end                | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.launched_at.start              | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.subnet.id                      | The identifier of the subnet that the instance was launched in.                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.type                           | The instance type of the instance.                                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.resource.aws_ec2_instance.vpc.id                         | The identifier of the VPC that the instance was launched in.                                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.created_at.date_range.unit   | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.created_at.date_range.value  | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.created_at.end               | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.created_at.start             | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.principal.name               | The name of the principal that is associated with an IAM access key.                                                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.status                       | The status of the IAM access key related to a finding.                                                                                                                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.resource.aws_iam_access_key.user.name                    | The user associated with the IAM access key related to a finding.                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.resource.aws_iam_user.user.name                          | The name of an IAM user.                                                                                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.resource.aws_s3_bucket.owner.id                          | The canonical user ID of the owner of the S3 bucket.                                                                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.resource.aws_s3_bucket.owner.name                        | The display name of the owner of the S3 bucket.                                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.filters.resource.container.image.id                              | The identifier of the image related to a finding.                                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.resource.container.image.name                            | The name of the image related to a finding.                                                                                                                                                                                                                                           | flattened        |
  | aws.securityhub_insights.filters.resource.container.launched_at.date_range.unit           | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.resource.container.launched_at.date_range.value          | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.resource.container.launched_at.end                       | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.resource.container.launched_at.start                     | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.resource.container.name                                  | The name of the container related to a finding.                                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.filters.resource.details_other                                   | The details of a resource that doesn't have a specific subfield for the resource type defined.                                                                                                                                                                                        | flattened        |
  | aws.securityhub_insights.filters.resource.id                                              | The canonical identifier for the given resource type.                                                                                                                                                                                                                                 | flattened        |
  | aws.securityhub_insights.filters.resource.partition                                       | The canonical Amazon Web Services partition name that the Region is assigned to.                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.resource.region                                          | The canonical Amazon Web Services external Region name where this resource is located.                                                                                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.resource.tags                                            | A list of Amazon Web Services tags associated with a resource at the time the finding was processed.                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.resource.type                                            | Specifies the type of the resource that details are provided for.                                                                                                                                                                                                                     | flattened        |
  | aws.securityhub_insights.filters.sample                                                   | Indicates whether or not sample findings are included in the filter results.                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.severity.label                                           | The label of a finding's severity.                                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.severity.normalized                                      | The normalized severity of a finding.                                                                                                                                                                                                                                                 | flattened        |
  | aws.securityhub_insights.filters.severity.product                                         | The native severity as defined by the security-findings provider's solution that generated the finding.                                                                                                                                                                               | flattened        |
  | aws.securityhub_insights.filters.source_url                                               | A URL that links to a page about the current finding in the security-findings provider's solution.                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.threat_intel_indicator.category                          | The category of a threat intelligence indicator.                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.threat_intel_indicator.last_observed_at.date_range.unit  | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.threat_intel_indicator.last_observed_at.date_range.value | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.threat_intel_indicator.last_observed_at.end              | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.threat_intel_indicator.last_observed_at.start            | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.threat_intel_indicator.source                            | The source of the threat intelligence.                                                                                                                                                                                                                                                | flattened        |
  | aws.securityhub_insights.filters.threat_intel_indicator.source_url                        | The URL for more details from the source of the threat intelligence.                                                                                                                                                                                                                  | flattened        |
  | aws.securityhub_insights.filters.threat_intel_indicator.type                              | The type of a threat intelligence indicator.                                                                                                                                                                                                                                          | flattened        |
  | aws.securityhub_insights.filters.threat_intel_indicator.value                             | The value of a threat intelligence indicator.                                                                                                                                                                                                                                         | flattened        |
  | aws.securityhub_insights.filters.title                                                    | A finding's title.                                                                                                                                                                                                                                                                    | flattened        |
  | aws.securityhub_insights.filters.type                                                     | A finding type in the format of namespace/category/classifier that classifies a finding.                                                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.updated_at.date_range.unit                               | A date range unit for the date filter.                                                                                                                                                                                                                                                | keyword          |
  | aws.securityhub_insights.filters.updated_at.date_range.value                              | A date range value for the date filter.                                                                                                                                                                                                                                               | long             |
  | aws.securityhub_insights.filters.updated_at.end                                           | An end date for the date filter.                                                                                                                                                                                                                                                      | date             |
  | aws.securityhub_insights.filters.updated_at.start                                         | A start date for the date filter.                                                                                                                                                                                                                                                     | date             |
  | aws.securityhub_insights.filters.user_defined_fields                                      | A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.                                                                                                                                                              | flattened        |
  | aws.securityhub_insights.filters.verification.state                                       | The veracity of a finding.                                                                                                                                                                                                                                                            | flattened        |
  | aws.securityhub_insights.filters.workflow.state                                           | The workflow state of a finding.                                                                                                                                                                                                                                                      | flattened        |
  | aws.securityhub_insights.filters.workflow.status                                          | The status of the investigation into a finding.                                                                                                                                                                                                                                       | flattened        |
  | aws.securityhub_insights.group_by_attribute                                               | The grouping attribute for the insight's findings. Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers. | keyword          |
  | aws.securityhub_insights.insight_arn                                                      | The ARN of a Security Hub insight.                                                                                                                                                                                                                                                    | keyword          |
  | aws.securityhub_insights.name                                                             | The name of a Security Hub insight.                                                                                                                                                                                                                                                   | keyword          |
  | cloud.image.id                                                                            | Image ID for the cloud instance.                                                                                                                                                                                                                                                      | keyword          |
  | data_stream.dataset                                                                       | Data stream dataset.                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.namespace                                                                     | Data stream namespace.                                                                                                                                                                                                                                                                | constant_keyword |
  | data_stream.type                                                                          | Data stream type.                                                                                                                                                                                                                                                                     | constant_keyword |
  | event.module                                                                              | Event module.                                                                                                                                                                                                                                                                         | constant_keyword |
  | host.containerized                                                                        | If the host is a container.                                                                                                                                                                                                                                                           | boolean          |
  | host.os.build                                                                             | OS build information.                                                                                                                                                                                                                                                                 | keyword          |
  | host.os.codename                                                                          | OS codename, if any.                                                                                                                                                                                                                                                                  | keyword          |
  | input.type                                                                                | Input type                                                                                                                                                                                                                                                                            | keyword          |
  | log.offset                                                                                | Log offset                                                                                                                                                                                                                                                                            | long             |
  | observer.vendor                                                                           | Vendor name of the observer.                                                                                                                                                                                                                                                          | constant_keyword |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Security Hub CSPM Findings and Insights dashboard screenshot](https://epr.elastic.co/package/aws/6.1.0/img/securityhub_cspm_findings_insights_dashboard.png)

  ![Security Hub CSPM summary dashboard screenshot](https://epr.elastic.co/package/aws/6.1.0/img/securityhub_cspm_summary_dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version              | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Minimum Kibana version  |
  |----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
  | **6.1.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17084))Remove fixed value `event.dataset` mapping for lambda_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **6.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16133))Remove third-party pipeline for previously removed 'third-party REST API' input from 'AWS Cloudtrail'.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16991))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16755))Update AWS ALB Grok patterns to support the conn_trace_id field and parse malformed requests missing HTTP versions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16905))Added support for extracting user name from AWS GovCloud STS ARNs and fixed management_event field type conversion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.18.19.4             |
  | **5.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16713))Add dashboards for AWS Web Application Firewall data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.2.18.19.4             |
  | **5.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16695))S3 Access logs, improve S3KEY regex to handle special characters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.2.18.19.4             |
  | **5.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15346))Add ec2_metrics, lambda, sqs and sns alert rule templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16122))Add `cookies` field in cloudfront logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16579))Added rate limiting and retry configuration for AWS Config data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **5.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15601))Normalize user fields for AWS CloudTrail events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **5.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16515))Set `event.kind` to `alert` on AWS WAF events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16195))Rebrand AWS Security Hub as AWS Security Hub CSPM to align with the vendor's current branding.This change involves updating the `observer.vendor` value to `AWS Security Hub CSPM`.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **4.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15929))Add type-specific entity fields to data stream.This enables better entity classification while maintaining backward compatibility with existing `actor.entity.id` and `target.entity.id` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **4.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16098))Retain CloudTrail `sessionCredentialFromConsole` field as `aws.cloudtrail.session_credential_from_console`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.48.19.4             |
  | **4.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15945))Prevent updating fleet health status to degraded when the HTTPJSON template value evaluation is empty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.1.48.19.4             |
  | **4.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15279))Prefer set with copy_from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.08.19.0             |
  | **4.3.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out document containing an error.message from AWS Config, AWS Inspector, and AWS Security Hub latest indexes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15737))Update the AWS CloudWatch documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15320))Improve documentation to align with new guidelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.1.08.19.0             |
  | **4.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15436))Add `user.name` to Cloudtrail's `UserAuthentication` events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.1.08.19.0             |
  | **4.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` and `misconfiguration_workflow` sub category labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.1.08.19.0             |
  | **4.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15230))Add latest transform to `AWS Config` and `AWS Inspector`.This enables support for extended protections for `AWS Config` and `AWS Inspector`.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15230))The latest transforms requires `transform` node and necessary permissions to use the transform.The transforms stores the latest copy of vulnerabilities and misconfigurations in the destination indices, which will require additional storage.Due to change in fingeprinting on source indices, duplicates occur on source indices of `AWS Config` and `AWS Inspector`.                                 | 9.1.08.19.0             |
  | **3.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17064))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16998))Disable lastSync start_position configuration for CloudWatch as it's incompatible with versions below 9.x.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15312))Enable Agentless deployment for AWS GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15217))Map `recipient_account_id` to `cloud.account.id` for AWS CloudTrail.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15077))Add support for VPC Flow logs versions 6, 7, and 8.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14995))Remove unused agent files.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.14.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14958))Fixed issue where empty DescribeConfigRules responses caused 'index out of bounds' errors in AWS Config integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.08.17.48.16.6 |
  | **3.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14947))Prevent logging expected agent HTTP JSON template errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14733))Add description on lastSync start_position configuration for CloudWatch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.13.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14734))Remove redundant code from config data stream agent configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.13.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14573))Remove Include Linked Accounts config option from AWS Health.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14525))Avoid updating fleet health status to degraded when Guardduty has no findings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14441))Reduce unnecessary work done in cloudtrail data stream when flattened fields are not required.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14306))Mapping changes in `inspector` datastream for Cloud Detection and Response (CDR) vulnerability workflow.Parse and map newly introduced fields in the `inspector` data stream.Enable request trace log removal and Agentless deployment in the `inspector` data stream.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.11.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13345))Fix `tlsVersion` parsing when not properly defined in cloudtrail event.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13345))Add empty value removal script to cloudtrail data stream ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.18.08.17.48.16.6 |
  | **3.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14439))Fix configuration template typo.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14236))Allow user-specification of fields to retain in the cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14354))Ingest managed insights from Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14264))Fix null reference in securityhub_findings* data streams when extracting `host.ip`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.08.17.48.16.6 |
  | **3.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14251))Modify the data type of `event.kind` from a constant_keyword to a keyword to handle pipeline errors that send `event.kind` as `pipeline_error`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14181))Add AWS lambda logs overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14070))Add AWS lambda logs dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.5.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14179))Add Redshift `InstanceType` dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14169))Change Redshift terraform node type because `dc2.large` is deprecated and leads to system tests fails.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13956))Add the `external_id` field to data streams collecting data from S3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13830))Add new AWS Config datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.3.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13978))Update README - Document ingested log types of AWS Network Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13434))Update README - EC2 Instance IAM Role for AWS Authentication                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13676))Fix handling of duplicate fields in Network Firewall Logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13246))Remove deprecated httpjson input for cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13367))Add agentless deployment for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13542))Enhancements for Guardduty dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13372))Add new Security Hub Findings Full Posture data stream. If you rely on Findings > Misconfigurations view, enable this new data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **2.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13486))Update grok pattern for AWS S3 access ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.16.5             |
  | **2.45.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.45.0**           | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13370))Update default data_stream.dataset to aws.cloudwatch_logs for cloudwatch_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.16.5             |
  | **2.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12685))Add `actor.entity.id` and `target.entity.id`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.16.5             |
  | **2.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13099))Set `event.type` and `event.action` fields in vpcflow logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.16.5             |
  | **2.41.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12727))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.16.2             |
  | **2.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12755))Ignore long `cloudtrail.request_parameters` and `cloudtrail.response_elements` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.16.2             |
  | **2.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12637))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.16.2             |
  | **2.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.2                  |
  | **2.38.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.2                  |
  | **2.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.2                  |
  | **2.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.2                  |
  | **2.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11883))Map aws.dimensions as object instead of flattened in CloudWatch metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.16.0                  |
  | **2.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12110))Include pipeline test examples to accommodate the new Cloudtrail format for the `CreateGroup` and `UpdateGroup` event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12072))Add SQS API calls documentation and required S3 permissions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12030))Add ELB connection logs dashboards for application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.16.0                  |
  | **2.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11933))Add the support for connection logs for AWS ELB dataset for Application Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.16.0                  |
  | **2.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11907))Add Lambda Event Source Mapping metrics and improve Lambda dashboard to display the new metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.0                  |
  | **2.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11484))Add option to check linked accounts when using log group prefixes to derive matching log groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.32.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11829))Implemented grok processor based parsing for ipv6 & ipv4 addresses in the AWS CloudFront logs.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11829))Auto formatted various text descriptions and newlines across all data streams via elastic-package.                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.31.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11794))Update documentation with required permissions for AWS Inspector.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.16.0                  |
  | **2.31.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11654))Removed the `reducedTimeRange` filter from the AWS Billing Total Estimated Charges lens to ensure value is displayed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.0                  |
  | **2.31.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11590))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.31.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11608))Add `cloud.provider`, `event.kind`, and `observer.vendor` fields to _source as needed by CDR workflows.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.16.0                  |
  | **2.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11158))Improve support for Cloud Detection and Response (CDR) workflows in securityhub_findings data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.30.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12237))Map aws.dimensions as object instead of flattened in CloudWatch metrics (backported from 2.37.0)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.15.2                  |
  | **2.30.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11706))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.15.2                  |
  | **2.30.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11498))Update the AWS dashboard panels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.15.2                  |
  | **2.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11442))Support configuring the Owning Account                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.2                  |
  | **2.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11392))Add mapping for the service.runtimeDetails fields in GuardDuty events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11416))Add reference to AWS API requests and pricing information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.15.0                  |
  | **2.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11112))Improve ingest pipeline error reporting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.15.0                  |
  | **2.26.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11397))Add more data to related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.26.0-preview01** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11115))Add related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **2.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11368))Add aws.metrics_names_fingerprint field and mark it as a dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11369))Fix aws.metrics_names_fingerprint field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11281))Add aws.metrics_names_fingerprint.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.14.0                  |
  | **2.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10216))Fixed and refactored AWS cloudfront log parsing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.14.0                  |
  | **2.24.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10683))Add dot_expander processor into metrics ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.23.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10444))Split the current AWS ELB dashboard into 3 separate dashboards, each focusing on a specific type of load balancer ELB, ALB, and NLB.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.22.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10480))Update max_number_of_messages parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10324))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.14.0                  |
  | **2.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9249))Fix route53 public logs grok pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10460))Add S3 polling option to data streams use aws-s3 input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.14.0                  |
  | **2.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10488))Add a visualization panel to display the Inbound and Outbound traffic of Application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/10119))Add AWS Health integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.14.0                  |
  | **2.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10223))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                  |
  | **2.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10181))Add TargetResponseTime metric to ELB Application metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10082))Fix AWS Network Firewall title and description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                  |
  | **2.15.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9865))Add endpoint + region variables to all SQS based AWS integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                  |
  | **2.15.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9763))Fix AWS Cloudtrail resources field processing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9705))Don't index empty AWS Security Hub responses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9782))Adds async event age and drops metrics, and implements sum aggregation for existing lambda metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                  |
  | **2.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9669))Update aggregation function for AWS lambda invocation metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9290))Document billing data stream limitations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8414))Add ability to set processors and leader election on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                  |
  | **2.13.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9346))Update latency parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                  |
  | **2.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9133))Add Amazon MSK integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.12.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9253))Fix an issue were the "_id" field was being used to aggregate data in Severity Over Time dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                  |
  | **2.12.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9213))Add cloudsecurity_cdr sub category label.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9009))Enable 'secret' for the sensitive fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8882))Fix query range calculation for GuardDuty datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.10.2                  |
  | **2.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8811))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.11.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8703))Improve wording on milliseconds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.10.2                  |
  | **2.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8509))Convert Total Estimated Charges panel to new metric visualization.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.10.2                  |
  | **2.10.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8709))Fix dimensions fingerprint field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.10.2                  |
  | **2.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.10.2                  |
  | **2.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8513))Convert "AWS Redshift metrics overview" visualizations to new metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8521))Change SQS metrics statistic method, which includes changing ApproximateAgeOfOldestMessage from average to max, changing NumberOfMessagesDeleted, NumberOfEmptyReceives, NumberOfMessagesReceived and NumberOfMessagesSent from average to sum.                                                                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **2.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.9.0                   |
  | **2.8.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8398))Add missing fields from beats input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.8.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8332))Update donut charts with pie for better representation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **2.8.4**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8140))Remove unused aws.*.metrics.*.* and aws.s3.bucket.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.8.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Include documentation and mappings for subfields of dns.answers**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping for tags and dynamic metric fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7933))Add null checks and ignore_missing checks to the rename processor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7659))Fix incorrect billing metrics displayed under AWS Billing overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8027))Allow configuration of TLD for guardduty, inspector, and security hub datastreams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Upgrade package spec to 3.0.0.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Fix duplicated and invalid field definitions.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add missing dashboard filters.                                                                                                                       | 8.9.0                   |
  | **2.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7990))Fix AWS API Gateway logs dashboard lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **2.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8002))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6352))Update Cloudtrail datastream to support tlsDetails field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **2.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7900))Fix Security Hub Findings to abide by ECS allowed values.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **2.4.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7876))Add AWS API Gateway metrics dashboards for each API type and additional filters which ensure data consistency                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7856))Change include_linked_accounts default to true                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7785))Fix GuardDuty API call parameter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7702))Add AWS API Gateway metrics dashboard Stage filter, control groups and clean up                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.1.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7675))Fix AWS API Gateway metrics dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7541))Improve AWS API Gateway dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7497))Enable TSDB by default for EC2 metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                                | 8.9.0                   |
  | **2.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6247))Remove deprecated option for "Cloudwatch via S3"from the AWS CloudWatch integration. If you are using it take note that logs WON'T BE ingested via this route anymore once you update.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **1.53.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7490))Set metric type in EC2 data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.9.0                   |
  | **1.53.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7487))Add dimension fields to EC2 data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **1.53.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7425))Add missing fields definition for ec2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **1.53.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7331))Remove the remove processor since rename processor removes old field already.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **1.53.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7435))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.9.0                   |
  | **1.53.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7151))Add AWS API Gateway custom acccess logging fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **1.52.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7129))Use default color for AWS dashboards metric charts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **1.52.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7262))Enable TSDB by default for cloudwatch metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **1.51.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8888))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.51.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7438))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.51.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7327))Use object metric type for the cloudwatch metrics                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.51.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6936))Add standalone S3 option for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.50.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6999))Add metric_type metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.50.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6871))Migrate AWS Security Hub dashboards to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.50.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6962))Migrate AWS VPC dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.50.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7075))Add EMR logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.50.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6644))Migrate AWS Billing dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.50.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6683))Add AWS API Gateway logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.50.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6895))Add EMR logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.49.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6530))Add API Gateway logs datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.8.1                   |
  | **1.48.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6915))Adding missing fields for the CloudTrail datastream - add option for standalone S3 bucket                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.47.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6865))Migrate AWS Redshift dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.47.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6487))Migrate AWS S3 Server Access Log Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.46.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6995))Migrate AWS Network Firewall dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.46.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6827))Add dimensions metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.46.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6969))Enable time series data streams for the API Gateway and EMR data streams. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.46.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6964))Update metric type and set dimension fields for AWS EMR data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.46.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6952))Fix metric type for API Gateway metric fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.46.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6950))Set dimensions fields for API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.46.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6916))Add missing S3 fields for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.46.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6887))Enable time series data streams for the S3 daily storage and S3 request datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                  | 8.8.1                   |
  | **1.46.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6886))Enable time series data streams for the Usage dataset. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.46.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6782))Enable time series data streams for the metrics datasets Billing, DynamoDB, EBS, ECS, ELB, Firewall, Kinesis, Lambda, NAT gateway, RDS, Redshift, S3 Storage Lens, SNS, SQS, Transit Gateway and VPN. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                              | 8.8.1                   |
  | **1.45.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6749))Add new fingerprint dimension to AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.45.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6667))Add metric_type metadata to s3_daily_storage and s3_request data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6666))Add dimension fields metadata to s3_request and s3_data_storage data streams to support TSDB                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.45.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6584))Add metric type to S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.45.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6583))Set dimension fields for S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6648))Remove aws.dimensions.* from package-fields.yml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6606))Add AWS EMR metrics dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6476))Add AWS API Gateway dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6120))Add AWS EMR metrics data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.8.1                   |
  | **1.44.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6543))Migrate AWS Metric Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.44.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6521))Migrate AWS ELB Access Log dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.44.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6561))Fix image link in readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.44.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5651))Migrate AWS TransitGateway metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for cloudwatch_logs and ec2_logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.43.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6231))Add documentation for latency parameter                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.43.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6526))Add tags_filter and include_linked_accounts config parameter in missing metric data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6459))Add include_linked_accounts config parameter for metrics data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6421))Add field agent.id to be set as dimension for TSDB migration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5426))Migrate AWS NATGateway metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.40.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5643))Migrate AWS ELB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5626))Migrate EC2 metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.40.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5650))Add AWS Firewall metrics dashboard input control groups.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                   |
  | **1.40.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6455))Migrate AWS S3 Storage Lens dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.40.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6368))Migrate Usage Overview dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6374))Migrate AWS CloudTrail dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.40.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6296))Add fields metric type to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.40.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6440))Replace aws.rds.db_instance.identifier with aws.dimensions.DBInstanceIdentifier in RDS dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.40.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6480))Add link to main AWS requirements in all integrations page.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6319))Add metric type to SNS, SQS and Billing data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6188))Add AWS API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.38.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6311))Add dimension fields to billing, sns and sqs data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.38.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6339))Add dimension fields to firewall, transit gateway and vpn data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.38.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6365))Add metric type to vpn, firewall and transit gateway data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6094))Add metric type to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6079))Add dimensions to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.37.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6353))Fix incorrect fields on multiple visualizations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5640))Migrate AWS RDS metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5642))Migrate AWS SNS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5644))Migrate AWS SQS metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.36.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5649))Migrate AWS VPN metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6213))Add dimension fields to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.36.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5973))Add dimension fields to Lambda data stream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6105))Add metric type to natgateway data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.36.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6063))Add metric type to EBS fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                   |
  | **1.36.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5866))Add support for TSDB on kinesis data stream (metric type).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.36.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6083))Add dimensions to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6087))Add metric type mapping to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6102))Add dimension fields to natgateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6045))Add metric type to Lambda fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.35.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6213))Fix typo in field name causing erroneous timestamp detection on the s3access data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6161))Add a new flag to enable request tracing on `httpjson` based input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.34.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5455))Migrate AWS Lambda metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                   |
  | **1.34.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5288))Migrate AWS DynamoDB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                   |
  | **1.34.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5968))Add field metric type to ECS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.34.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5891))Add dimension fields to Kinesis datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.6.0                   |
  | **1.34.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5895))Add dimension fields to ECS datastream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                   |
  | **1.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6062))Add dimensions to EBS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.33.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5794))Add number_of_workers and latency to all CloudWatch Logs based integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.33.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5791))Add missing permissions in the AWS Billing integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                   |
  | **1.33.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5790))Add missing permissions in the AWS CloudWatch Logs integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5777))Add latency configuration option on the CloudWatch Logs integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.32.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5646))Fix a minor documentation format issue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.32.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                   |
  | **1.32.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5212))Migrate AWS EBS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4915))Add a data stream for Amazon GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                   |
  | **1.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5178))Add dashboards data streams filters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.29.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5017))Drop comments from CloudFront loglines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4515))Add data_granularity parameter and rename period title to Collection Period.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.28.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4857))Remove quotes from VPC flow log message field and move dot_expander processor to top                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.28.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Add dot_expander processor to expand all fields with dot into object fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Support VPC flow log with message field                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.4.0                   |
  | **1.28.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4794))Adjust kinesis integration to kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.4.0                   |
  | **1.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4641))Enhance S3 integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.27.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4676))Support multiple forwarded IPs in cloudfront integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.4.0                   |
  | **1.27.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4703))Update the pagination termination condition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.4.0                   |
  | **1.27.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4596))Added a Summary Dashboard for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.4.0                   |
  | **1.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4604))Add Inspector data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.4.0                   |
  | **1.25.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4657))Remove duplicate fields from agent.yml and use ecs.yml for ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.25.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4567/))Update ec2 fields.yml doc                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.3.0                   |
  | **1.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4592))Remove duplicate 'content_type' config that causes errors while configurating the integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.3.0                   |
  | **1.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4532))Force content type where json content is expected                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4551))Enhance Kinesis integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4437))Allow adding multiple processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.24.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4430))Do not rely on dynamodb lightweight module metricset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4395))Fix adding processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.3.0                   |
  | **1.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4308))Fix billing datastream agent template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.0                   |
  | **1.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4281))Fix aws.cloudtrail.request_id parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4158))Expose Default Region setting to UI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.3.0                   |
  | **1.23.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4103))Set default endpoint to empty string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.23.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4083))Fix Billing Dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.23.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4057))Fix EC2 dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.3.0                   |
  | **1.23.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3907))Update all AWS documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.23.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4049))Fix file.path field in cloudtrail data stream to use json.digestS3Object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.1.0                   |
  | **1.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4024))Update `cloud.region` parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3553))Add Security Hub Findings and Insights data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.1.0                   |
  | **1.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3688))Improve dashboards by removing individual visualizations from library                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.1.0                   |
  | **1.19.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3856))Move ebs metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3874))Update sample_event.json in kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.19.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3873))Move NATGateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.19.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3840))Move Transit Gateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3829))Add Kinesis metrics datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.18.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_request metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_daily_storage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SQS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SNS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/3599))Move lambda metrics config from beats to integrations | 8.0.07.15.0             |
  | **1.18.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3860))Release AWS billing integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3799))Add ECS metricset**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3799))Fix incorrect fields on multiple visualizations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.17.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3851))Release Amazon Redshift integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.17.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3844))Fix data_stream.dataset indentation on cloudwatch_logs integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3795))Add missing endpoint config to metrics datasets.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move usage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move dynamodb metrics config from beats to integrations                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3682))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3610))Fix misspelling of Log Stream Prefix variable in manifest for aws-cloudwatch input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3569))Added Redshift integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.15.0             |
  | **1.16.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3308))Update documentation with additional context for new users.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.16.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3474))Move ELB metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3499))Fix ELB dataset to parse URLs with spaces**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3499))Upgrade ECS to 8.2.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.16.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3467))Move RDS metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3357))Move EC2 metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3342))Fix invalid values for ECS fields in vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3305))Move VPN configuration file into integrations and add tag collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Deprecate s3 input in cloudwatch integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Improve description for cloudwatch integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.8**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3285))Fix http.response.status_code to accept 000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.14.7**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for rds data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for sns data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Add aws.dimensions.* for dynamodb data stream                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3240))Improve s3 integration tile title and description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.14.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3226))Fix duplicate titles for integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3192))Fix cloudfront integration grok pattern                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.14.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2912))Add new pattern to VPC Flow logs including all 29 v5 fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **1.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2946))Fix billing dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2790))Add configuration for max_number_of_messages to the aws.firewall_logs S3 input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2838))Fix metricbeat- reference in dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2767))Compress dashboard screenshots.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.12.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflicts in the elb_logs data stream relating to ECS fields (`trace.id`, `source.port`, and a few others).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2476))Add CloudFront Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2470))Add Ingest Pipeline script to map IANA Protocol Numbers                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2642))Changing missing ecs versions to 8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2560))Add data_stream.dataset option for custom aws-cloudwatch log input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2635))Update permission list                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2478))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2536))Change cloudwatch metrics and logs default to false                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.15.0             |
  | **1.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2530))Add description of supported vpcflow formats                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                         |
  | **1.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2323))Add cloudwatch input into AWS package for log collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2341))Add Route 53 Resolver Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2316))Add Route 53 Public Zone Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2199))Add integration for AWS Network Firewall                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **1.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2325))Fix the value of event.created in CloudTrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2299))Add max_number_of_messages config option to AWS S3 input config.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **1.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2282))Add missing sample events                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2206))Support Kibana 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2153))Add Overview dashboard for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 7.15.0                  |
  | **1.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2142))Add integration for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2003))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1917))Add config parameter descriptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1886))Add WAF datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.2.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1871))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1797))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1687))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **1.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1772))vpcflow sync with filebeat fileset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 7.14.0                  |
  | **1.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1623))Release AWS as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 7.14.0                  |
  | **0.10.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1648))Add proxy config                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.10.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1606))Fix aws.billing.EstimatedCharges field name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.10.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1590))Add event.created field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.10.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1449))Improve RDS dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.10.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1465))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1371))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **0.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **0.9.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1357))Fix categories for each policy template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.9.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1334))Add linked account information into billing metricset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1333))Fix `aws.s3access` pipeline when remote IP is a `-`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1320))Change default credential options to access keys                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1245))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                         |
  | **0.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/767))Introduce granularity using input_groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.6.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1147))Add support for Splunk authorization tokens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.6.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1201))Fix bug in Third Party ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1212))Removed incorrect `http.request.referrer` field from elb logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1079))Add support for CloudTrail Digest & Insight logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1070))Update ECS version, add event.original and preparing for package GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1000))Fix stack compatability                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/979))Allow role_arn work with access keys for AWS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.5.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/631))Rename s3 input to aws-s3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing "geo" fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.5.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/834))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/791))Ignore missing "json" field in ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/782))Moving edge processors to ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **0.4.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/721))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.0.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/21))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                         |
</dropdown>