﻿---
title: Inspector
description: The Amazon Inspector integration collects and parses data from Amazon Inspector Findings REST APIs. This module is tested against Amazon Inspector API...
url: https://www.elastic.co/docs/reference/integrations/aws/inspector
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Inspector
|                                                                            |                                |
|----------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                | 6.1.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                          |
| **Ingestion method(s)**                                                    | API, AWS CloudWatch, AWS S3    |
| **Minimum Kibana version(s)**                                              | 9.2.18.19.4                    |

The [Amazon Inspector](https://docs.aws.amazon.com/inspector/) integration collects and parses data from Amazon Inspector [Findings](https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindings.html) REST APIs.
<important>
  Extra AWS charges on API requests will be generated by this integration. Check [API Requests](https://www.elastic.co/docs/current/integrations/aws#api-requests) for more details.
</important>


## Compatibility

This module is tested against `Amazon Inspector API version 2.0`.

## Agentless-enabled integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

## To collect data from Amazon Inspector API, users must have an Access Key and a Secret Key. To create API token follow below steps:

1. Login to .
2. Go to  to access the IAM console.
3. On the navigation menu, choose Users.
4. Choose your IAM user name.
5. Select Create access key from the Security Credentials tab.
6. To see the new access key, choose Show.


## Note

- For the current integration package, it is compulsory to add Secret Access Key and Access Key ID.
- This data stream doesn't support setting a Role ARN.
- Ensure your IAM has the `inspector2:ListFindings` permission granted. Without this permission, API requests will be denied.


## Troubleshooting


### Breaking Changes


#### Support for Elastic Vulnerability Findings page.

Version `4.0.0` of the AWS integration adds support for [Elastic Cloud Security workflow](https://www.elastic.co/docs/solutions/security/cloud/ingest-third-party-cloud-security-data#_ingest_third_party_security_posture_and_vulnerability_data). The enhancement enables the users of the AWS Inspector integration to ingest their enriched vulnerabilities from the Amazon Inspector platform into Elastic and get insights directly from the Elastic [Vulnerability Findings page](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3).
This update adds [Elastic Latest Transform](https://www.elastic.co/docs/explore-analyze/transforms/transform-overview#latest-transform-overview) which copies the latest vulnerability findings from source indices matching the pattern `logs-aws.inspector-*` into new destination indices matching the pattern `security_solution-aws.vulnerability_latest-*`. The Elastic Vulnerability Findings page will display vulnerabilities based on the destination indices.
For existing users of the AWS integration, before upgrading to `4.0.0` please ensure the following requirements are met:
1. Users need [Elastic Security solution](https://www.elastic.co/docs/solutions/security) which has requirements documented [here](https://www.elastic.co/docs/solutions/security/get-started/elastic-security-requirements).
2. To use transforms, users must have:
   - at least one [transform node](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#transform-node-role),
- management features visible in the Kibana space, and
- security privileges that:
  - grant use of transforms, and
- grant access to source and destination indices
  For more details on Transform Setup, refer to the link [here](https://www.elastic.co/docs/explore-analyze/transforms/transform-setup)
3. Because the latest copy of vulnerabilities is now indexed in two places, that is, in both source and destination indices, users must anticipate storage requirements accordingly.


## Logs


### Inspector

This is the [`Inspector`](https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindings.html#inspector2-ListFindings-response-findings) data stream.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-06-05T23:23:16.162Z",
      "agent": {
          "ephemeral_id": "298d11b5-7677-42b9-b1d3-9e35584a76e0",
          "id": "c0caf694-09ce-4dae-b92d-0e7b52f94631",
          "name": "elastic-agent-63222",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "aws": {
          "inspector": {
              "epss": {
                  "score": 0.00024
              },
              "exploit_available": "NO",
              "finding_arn": "arn:aws:inspector2:us-east-2:123456789012:finding/fb6294abcdef0123456789abcdef8123",
              "first_observed_at": "2025-05-29T17:28:07.919Z",
              "fix_available": "YES",
              "inspector_score": 6.5,
              "inspector_score_details": {
                  "adjusted_cvss": {
                      "cvss_source": "NVD",
                      "score": {
                          "source": "NVD"
                      },
                      "scoring_vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L"
                  }
              },
              "last_observed_at": "2025-06-05T23:23:16.162Z",
              "package_nested": [
                  {
                      "epoch": 0,
                      "file_path": "vol-0e47545061282cd35:/p1:opt/cni/bin/aws-cni",
                      "fixed_in_version": "0.38.0",
                      "name": "golang.org/x/net",
                      "package_manager": "GOBINARY",
                      "version": "v0.1.0"
                  },
                  {
                      "epoch": 0,
                      "file_path": "vol-0e47545061282cd35:/p1:etc/eks/image-credential-provider/ecr-credential-provider",
                      "fixed_in_version": "0.38.0",
                      "name": "golang.org/x/net",
                      "package_manager": "GOBINARY",
                      "version": "v0.30.0"
                  },
                  {
                      "epoch": 0,
                      "file_path": "vol-0e47545061282cd35:/p1:opt/cni/bin/dhcp",
                      "fixed_in_version": "0.38.0",
                      "name": "golang.org/x/net",
                      "package_manager": "GOBINARY",
                      "version": "v0.30.0"
                  },
                  {
                      "epoch": 0,
                      "file_path": "vol-0e47545061282cd35:/p1:usr/bin/aws-iam-authenticator",
                      "fixed_in_version": "0.38.0",
                      "name": "golang.org/x/net",
                      "package_manager": "GOBINARY",
                      "version": "v0.30.0"
                  },
                  {
                      "epoch": 0,
                      "file_path": "vol-0e47545061282cd35:/p1:usr/bin/kubelet",
                      "fixed_in_version": "0.38.0",
                      "name": "golang.org/x/net",
                      "package_manager": "GOBINARY",
                      "version": "v0.30.0"
                  },
                  {
                      "arch": "X86_64",
                      "epoch": 0,
                      "fixed_in_version": "0:2.0.5-1.amzn2.0.1",
                      "name": "nerdctl",
                      "package_manager": "OS",
                      "release": "1.amzn2.0.1",
                      "remediation": "yum update nerdctl",
                      "version": "2.0.4"
                  }
              ],
              "package_vulnerability_details": {
                  "cvss": [
                      {
                          "base_score": 6.5,
                          "scoring_vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L",
                          "source": "NVD",
                          "version": "3.1"
                      },
                      {
                          "base_score": 6.5,
                          "scoring_vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L",
                          "source": "NVD",
                          "version": "3.1"
                      }
                  ],
                  "source": {
                      "url": {
                          "domain": "nvd.nist.gov",
                          "original": "https://nvd.nist.gov/vuln/detail/CVE-2025-22872",
                          "path": "/vuln/detail/CVE-2025-22872",
                          "scheme": "https"
                      },
                      "value": "NVD"
                  },
                  "vendor": {
                      "severity": "MEDIUM",
                      "updated_at": "2025-05-16T23:15:19.000Z"
                  },
                  "vulnerable_packages": [
                      {
                          "epoch": 0,
                          "file_path": "vol-0e47545061282cd35:/p1:opt/cni/bin/aws-cni",
                          "fixed_in_version": "0.38.0",
                          "name": "golang.org/x/net",
                          "package_manager": "GOBINARY",
                          "version": "v0.1.0"
                      },
                      {
                          "epoch": 0,
                          "file_path": "vol-0e47545061282cd35:/p1:etc/eks/image-credential-provider/ecr-credential-provider",
                          "fixed_in_version": "0.38.0",
                          "name": "golang.org/x/net",
                          "package_manager": "GOBINARY",
                          "version": "v0.30.0"
                      },
                      {
                          "epoch": 0,
                          "file_path": "vol-0e47545061282cd35:/p1:opt/cni/bin/dhcp",
                          "fixed_in_version": "0.38.0",
                          "name": "golang.org/x/net",
                          "package_manager": "GOBINARY",
                          "version": "v0.30.0"
                      },
                      {
                          "epoch": 0,
                          "file_path": "vol-0e47545061282cd35:/p1:usr/bin/aws-iam-authenticator",
                          "fixed_in_version": "0.38.0",
                          "name": "golang.org/x/net",
                          "package_manager": "GOBINARY",
                          "version": "v0.30.0"
                      },
                      {
                          "epoch": 0,
                          "file_path": "vol-0e47545061282cd35:/p1:usr/bin/kubelet",
                          "fixed_in_version": "0.38.0",
                          "name": "golang.org/x/net",
                          "package_manager": "GOBINARY",
                          "version": "v0.30.0"
                      },
                      {
                          "arch": "X86_64",
                          "epoch": 0,
                          "fixed_in_version": "0:2.0.5-1.amzn2.0.1",
                          "name": "nerdctl",
                          "package_manager": "OS",
                          "release": "1.amzn2.0.1",
                          "remediation": "yum update nerdctl",
                          "version": "2.0.4"
                      }
                  ]
              },
              "remediation": {
                  "recommendation": {
                      "text": "None Provided"
                  }
              },
              "resources": [
                  {
                      "details": {
                          "aws": {
                              "ec2_instance": {
                                  "iam_instance_profile_arn": "arn:aws:iam::123456789012:instance-profile/eks-0012345a-1234-5678-1234-6c1abcdef012",
                                  "image_id": "ami-0e0f0123456789abd",
                                  "ipv4_addresses": [
                                      "10.90.1.245",
                                      "10.90.1.45",
                                      "10.90.1.168",
                                      "10.90.1.157",
                                      "1.128.0.1",
                                      "10.90.1.103",
                                      "10.90.1.197",
                                      "10.90.1.220",
                                      "10.90.1.86",
                                      "10.90.1.29",
                                      "10.90.1.18",
                                      "10.90.1.181",
                                      "10.90.1.161",
                                      "10.90.1.229",
                                      "10.90.1.108",
                                      "10.90.1.219",
                                      "10.90.1.9",
                                      "10.90.1.106",
                                      "10.90.1.206"
                                  ],
                                  "launched_at": "2025-05-29T16:06:08.000Z",
                                  "platform": "AMAZON_LINUX_2",
                                  "subnet_id": "subnet-0ababcdefabcdef8b",
                                  "type": "t3.medium",
                                  "vpc_id": "vpc-04ab0123456789123"
                              }
                          }
                      },
                      "id": "i-0fabcdefabcdef50b",
                      "partition": "aws",
                      "region": "us-east-2",
                      "tags": {
                          "aws:autoscaling:groupName": "eks-sei_demo_prod_linux-00c12345-abcd-1234-5678-601234567896",
                          "aws:ec2launchtemplate:version": "6",
                          "aws:eks:cluster-name": "sei_demo_prod",
                          "eks:cluster-name": "sei_demo_prod",
                          "eks:nodegroup-name": "sei_demo_prod_linux",
                          "k8s.io/cluster-autoscaler/enabled": "true",
                          "k8s.io/cluster-autoscaler/sei_demo_prod": "owned",
                          "kubernetes.io/cluster/sei_demo_prod": "owned"
                      },
                      "type": "AWS_EC2_INSTANCE"
                  }
              ],
              "severity": "MEDIUM",
              "status": "ACTIVE",
              "transform_unique_id": "CVE-2025-22872|i-0fabcdefabcdef50b|{0=golang.org/x/net, 1=nerdctl}|{0=v0.1.0, 1=v0.30.0, 2=2.0.4}",
              "type": "PACKAGE_VULNERABILITY"
          }
      },
      "cloud": {
          "account": {
              "id": "123456789012"
          },
          "instance": {
              "id": "i-0fabcdefabcdef50b"
          },
          "machine": {
              "type": "t3.medium"
          },
          "provider": "aws",
          "region": "us-east-2"
      },
      "data_stream": {
          "dataset": "aws.inspector",
          "namespace": "35676",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "c0caf694-09ce-4dae-b92d-0e7b52f94631",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "created": "2025-11-12T05:49:57.024Z",
          "dataset": "aws.inspector",
          "id": "CVE-2025-22872|i-0fabcdefabcdef50b|{0=golang.org/x/net, 1=nerdctl}|{0=v0.1.0, 1=v0.30.0, 2=2.0.4}|2025-06-05T23:23:16.162Z",
          "ingested": "2025-11-12T05:50:00Z",
          "kind": "event",
          "original": "{\"awsAccountId\":\"123456789012\",\"description\":\"The tokenizer incorrectly interprets tags with unquoted attribute values that end with a solidus character (/) as self-closing. When directly using Tokenizer, this can result in such tags incorrectly being marked as self-closing, and when using the Parse functions, this can result in content following such tags as being placed in the wrong scope during DOM construction, but only when tags are in foreign content (e.g. \\u003cmath\\u003e, \\u003csvg\\u003e, etc contexts).\",\"epss\":{\"score\":0.00024},\"exploitAvailable\":\"NO\",\"findingArn\":\"arn:aws:inspector2:us-east-2:123456789012:finding/fb6294abcdef0123456789abcdef8123\",\"firstObservedAt\":1748539687.919,\"fixAvailable\":\"YES\",\"inspectorScore\":6.5,\"inspectorScoreDetails\":{\"adjustedCvss\":{\"adjustments\":[],\"cvssSource\":\"NVD\",\"score\":6.5,\"scoreSource\":\"NVD\",\"scoringVector\":\"CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L\",\"version\":\"3.1\"}},\"lastObservedAt\":1749165796.162,\"packageVulnerabilityDetails\":{\"cvss\":[{\"baseScore\":6.5,\"scoringVector\":\"CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L\",\"source\":\"NVD\",\"version\":\"3.1\"},{\"baseScore\":6.5,\"scoringVector\":\"CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L\",\"source\":\"NVD\",\"version\":\"3.1\"}],\"referenceUrls\":[\"https://groups.google.com/g/golang-announce/c/ezSKR9vqbqA\",\"https://nvd.nist.gov/vuln/detail/CVE-2025-22872\",\"https://alas.aws.amazon.com/AL2023/ALAS-2025-981.html\",\"https://alas.aws.amazon.com/AL2/ALASDOCKER-2025-064.html\",\"https://alas.aws.amazon.com/AL2023/ALAS-2025-980.html\",\"https://alas.aws.amazon.com/AL2/ALASDOCKER-2025-063.html\",\"https://alas.aws.amazon.com/AL2023/ALAS-2025-979.html\",\"https://alas.aws.amazon.com/cve/json/v1/CVE-2025-22872.json\",\"https://alas.aws.amazon.com/AL2/ALAS-2025-2863.html\",\"https://alas.aws.amazon.com/cve/json/v1/CVE-2025-22872.json\"],\"relatedVulnerabilities\":[],\"source\":\"NVD\",\"sourceUrl\":\"https://nvd.nist.gov/vuln/detail/CVE-2025-22872\",\"vendorCreatedAt\":1744827364,\"vendorSeverity\":\"MEDIUM\",\"vendorUpdatedAt\":1747437319,\"vulnerabilityId\":\"CVE-2025-22872\",\"vulnerablePackages\":[{\"epoch\":0,\"filePath\":\"vol-0e47545061282cd35:/p1:opt/cni/bin/aws-cni\",\"fixedInVersion\":\"0.38.0\",\"name\":\"golang.org/x/net\",\"packageManager\":\"GOBINARY\",\"version\":\"v0.1.0\"},{\"epoch\":0,\"filePath\":\"vol-0e47545061282cd35:/p1:etc/eks/image-credential-provider/ecr-credential-provider\",\"fixedInVersion\":\"0.38.0\",\"name\":\"golang.org/x/net\",\"packageManager\":\"GOBINARY\",\"version\":\"v0.30.0\"},{\"epoch\":0,\"filePath\":\"vol-0e47545061282cd35:/p1:opt/cni/bin/dhcp\",\"fixedInVersion\":\"0.38.0\",\"name\":\"golang.org/x/net\",\"packageManager\":\"GOBINARY\",\"version\":\"v0.30.0\"},{\"epoch\":0,\"filePath\":\"vol-0e47545061282cd35:/p1:usr/bin/aws-iam-authenticator\",\"fixedInVersion\":\"0.38.0\",\"name\":\"golang.org/x/net\",\"packageManager\":\"GOBINARY\",\"version\":\"v0.30.0\"},{\"epoch\":0,\"filePath\":\"vol-0e47545061282cd35:/p1:usr/bin/kubelet\",\"fixedInVersion\":\"0.38.0\",\"name\":\"golang.org/x/net\",\"packageManager\":\"GOBINARY\",\"version\":\"v0.30.0\"},{\"arch\":\"X86_64\",\"epoch\":0,\"fixedInVersion\":\"0:2.0.5-1.amzn2.0.1\",\"name\":\"nerdctl\",\"packageManager\":\"OS\",\"release\":\"1.amzn2.0.1\",\"remediation\":\"yum update nerdctl\",\"version\":\"2.0.4\"}]},\"remediation\":{\"recommendation\":{\"text\":\"None Provided\"}},\"resources\":[{\"details\":{\"awsEc2Instance\":{\"iamInstanceProfileArn\":\"arn:aws:iam::123456789012:instance-profile/eks-0012345a-1234-5678-1234-6c1abcdef012\",\"imageId\":\"ami-0e0f0123456789abd\",\"ipV4Addresses\":[\"10.90.1.245\",\"10.90.1.45\",\"10.90.1.168\",\"10.90.1.157\",\"1.128.0.1\",\"10.90.1.103\",\"10.90.1.197\",\"10.90.1.220\",\"10.90.1.86\",\"10.90.1.29\",\"10.90.1.18\",\"10.90.1.181\",\"10.90.1.161\",\"10.90.1.229\",\"10.90.1.108\",\"10.90.1.219\",\"10.90.1.9\",\"10.90.1.106\",\"10.90.1.206\"],\"ipV6Addresses\":[],\"launchedAt\":1748534768,\"platform\":\"AMAZON_LINUX_2\",\"subnetId\":\"subnet-0ababcdefabcdef8b\",\"type\":\"t3.medium\",\"vpcId\":\"vpc-04ab0123456789123\"}},\"id\":\"i-0fabcdefabcdef50b\",\"partition\":\"aws\",\"region\":\"us-east-2\",\"tags\":{\"aws:autoscaling:groupName\":\"eks-sei_demo_prod_linux-00c12345-abcd-1234-5678-601234567896\",\"aws:ec2launchtemplate:version\":\"6\",\"aws:eks:cluster-name\":\"sei_demo_prod\",\"eks:cluster-name\":\"sei_demo_prod\",\"eks:nodegroup-name\":\"sei_demo_prod_linux\",\"k8s.io/cluster-autoscaler/enabled\":\"true\",\"k8s.io/cluster-autoscaler/sei_demo_prod\":\"owned\",\"kubernetes.io/cluster/sei_demo_prod\":\"owned\"},\"type\":\"AWS_EC2_INSTANCE\"}],\"severity\":\"MEDIUM\",\"status\":\"ACTIVE\",\"title\":\"CVE-2025-22872 - golang.org/x/net, golang.org/x/net and 4 more\",\"type\":\"PACKAGE_VULNERABILITY\",\"updatedAt\":1749165796.162}",
          "type": [
              "info"
          ]
      },
      "host": {
          "id": "i-0fabcdefabcdef50b",
          "ip": [
              "10.90.1.245",
              "10.90.1.45",
              "10.90.1.168",
              "10.90.1.157",
              "1.128.0.1",
              "10.90.1.103",
              "10.90.1.197",
              "10.90.1.220",
              "10.90.1.86",
              "10.90.1.29",
              "10.90.1.18",
              "10.90.1.181",
              "10.90.1.161",
              "10.90.1.229",
              "10.90.1.108",
              "10.90.1.219",
              "10.90.1.9",
              "10.90.1.106",
              "10.90.1.206"
          ],
          "os": {
              "platform": "AMAZON_LINUX_2",
              "type": "linux"
          },
          "type": "t3.medium"
      },
      "input": {
          "type": "httpjson"
      },
      "message": "The tokenizer incorrectly interprets tags with unquoted attribute values that end with a solidus character (/) as self-closing. When directly using Tokenizer, this can result in such tags incorrectly being marked as self-closing, and when using the Parse functions, this can result in content following such tags as being placed in the wrong scope during DOM construction, but only when tags are in foreign content (e.g. <math>, <svg>, etc contexts).",
      "observer": {
          "vendor": "Amazon Inspector"
      },
      "package": {
          "architecture": [
              "X86_64"
          ],
          "fixed_version": [
              "0.38.0",
              "0:2.0.5-1.amzn2.0.1"
          ],
          "name": [
              "golang.org/x/net",
              "nerdctl"
          ],
          "path": [
              "vol-0e47545061282cd35:/p1:opt/cni/bin/aws-cni",
              "vol-0e47545061282cd35:/p1:etc/eks/image-credential-provider/ecr-credential-provider",
              "vol-0e47545061282cd35:/p1:opt/cni/bin/dhcp",
              "vol-0e47545061282cd35:/p1:usr/bin/aws-iam-authenticator",
              "vol-0e47545061282cd35:/p1:usr/bin/kubelet"
          ],
          "version": [
              "v0.1.0",
              "v0.30.0",
              "2.0.4"
          ]
      },
      "related": {
          "ip": [
              "10.90.1.245",
              "10.90.1.45",
              "10.90.1.168",
              "10.90.1.157",
              "1.128.0.1",
              "10.90.1.103",
              "10.90.1.197",
              "10.90.1.220",
              "10.90.1.86",
              "10.90.1.29",
              "10.90.1.18",
              "10.90.1.181",
              "10.90.1.161",
              "10.90.1.229",
              "10.90.1.108",
              "10.90.1.219",
              "10.90.1.9",
              "10.90.1.106",
              "10.90.1.206"
          ]
      },
      "resource": {
          "id": "i-0fabcdefabcdef50b",
          "type": "AWS_EC2_INSTANCE"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "aws-inspector"
      ],
      "vulnerability": {
          "description": "The tokenizer incorrectly interprets tags with unquoted attribute values that end with a solidus character (/) as self-closing. When directly using Tokenizer, this can result in such tags incorrectly being marked as self-closing, and when using the Parse functions, this can result in content following such tags as being placed in the wrong scope during DOM construction, but only when tags are in foreign content (e.g. <math>, <svg>, etc contexts).",
          "id": "CVE-2025-22872",
          "published_date": "2025-04-16T18:16:04.000Z",
          "reference": [
              "https://groups.google.com/g/golang-announce/c/ezSKR9vqbqA",
              "https://nvd.nist.gov/vuln/detail/CVE-2025-22872",
              "https://alas.aws.amazon.com/AL2023/ALAS-2025-981.html",
              "https://alas.aws.amazon.com/AL2/ALASDOCKER-2025-064.html",
              "https://alas.aws.amazon.com/AL2023/ALAS-2025-980.html",
              "https://alas.aws.amazon.com/AL2/ALASDOCKER-2025-063.html",
              "https://alas.aws.amazon.com/AL2023/ALAS-2025-979.html",
              "https://alas.aws.amazon.com/cve/json/v1/CVE-2025-22872.json",
              "https://alas.aws.amazon.com/AL2/ALAS-2025-2863.html",
              "https://alas.aws.amazon.com/cve/json/v1/CVE-2025-22872.json"
          ],
          "scanner": {
              "vendor": "Amazon Inspector"
          },
          "score": {
              "base": 6.5,
              "version": "3.1"
          },
          "severity": "Medium",
          "title": "CVE-2025-22872 - golang.org/x/net, golang.org/x/net and 4 more"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                              | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | aws.inspector.aws_account_id                                                            | The AWS account ID associated with the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.code_vulnerability_details.cwes                                           | The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.code_vulnerability_details.detector_id                                    | The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see Amazon CodeGuru Detector Library.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.code_vulnerability_details.detector_name                                  | The name of the detector used to identify the code vulnerability. For more information on detectors see CodeGuru Detector Library.                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.inspector.code_vulnerability_details.detector_tags                                  | The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes or tactics. For a list of available tags by programming language, see Java tags, or Python tags.                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.inspector.code_vulnerability_details.file_path.end_line                             | The line number of the last line of code that a vulnerability was found in.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | aws.inspector.code_vulnerability_details.file_path.name                                 | The name of the file the code vulnerability was found in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.code_vulnerability_details.file_path.path                                 | The file path to the code that a vulnerability was found in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.code_vulnerability_details.file_path.start_line                           | The line number of the first line of code that a vulnerability was found in.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             |
  | aws.inspector.code_vulnerability_details.reference_urls                                 | A URL containing supporting documentation about the code vulnerability detected.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.code_vulnerability_details.rule_id                                        | The identifier for a rule that was used to detect the code vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.code_vulnerability_details.source_lambda_layer_arn                        | The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.description                                                               | The description of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | aws.inspector.epss.score                                                                | The EPSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | aws.inspector.exploit_available                                                         | If a finding discovered in your environment has an exploit available.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.inspector.exploitability_details.last_known_exploit_at                              | The date and time of the last exploit associated with a finding discovered in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | aws.inspector.finding_arn                                                               | The Amazon Resource Number (ARN) of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.first_observed_at                                                         | The date and time that the finding was first observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | aws.inspector.fix_available                                                             | Details on whether a fix is available through a version update. This value can be YES, NO, or PARTIAL. A PARTIAL fix means that some, but not all, of the packages identified in the finding have fixes available through updated versions.                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.inspector.inspector_score                                                           | The Amazon Inspector score given to the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | double           |
  | aws.inspector.inspector_score_details.adjusted_cvss.adjustments.metric                  | The metric used to adjust the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.inspector_score_details.adjusted_cvss.adjustments.reason                  | The reason the CVSS score has been adjustment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.inspector_score_details.adjusted_cvss.cvss_source                         | The source of the CVSS data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.inspector_score_details.adjusted_cvss.score.source                        | The source for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.inspector_score_details.adjusted_cvss.score.value                         | The CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | aws.inspector.inspector_score_details.adjusted_cvss.scoring_vector                      | The vector for the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.inspector_score_details.adjusted_cvss.version                             | The CVSS version used in scoring.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.inspector.last_observed_at                                                          | The date and time that the finding was last observed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | aws.inspector.network_reachability_details.network_path.steps.component.arn             | The component ARN. The ARN can be null and is not displayed in the AWS console.                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.network_reachability_details.network_path.steps.component.id              | The component ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.inspector.network_reachability_details.network_path.steps.component.type            | The component type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.network_reachability_details.open_port_range.begin                        | The beginning port in a port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | aws.inspector.network_reachability_details.open_port_range.end                          | The ending port in a port range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | aws.inspector.network_reachability_details.protocol                                     | The protocol associated with a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.inspector.package_nested.arch                                                       | The architecture of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.inspector.package_nested.epoch                                                      | The epoch of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | aws.inspector.package_nested.file_path                                                  | The file path of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.package_nested.fixed_in_version                                           | The version of the package that contains the vulnerability fix.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.package_nested.name                                                       | The name of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.package_nested.package_manager                                            | The package manager of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.package_nested.release                                                    | The release of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.package_nested.remediation                                                | The code to run in your environment to update packages with a fix available.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.package_nested.source_lambda_layer_arn                                    | The Amazon Resource Number (ARN) of the AWS Lambda function affected by a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.inspector.package_nested.source_layer_hash                                          | The source layer hash of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.package_nested.version                                                    | The version of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.package_vulnerability_details.cvss.base_score                             | The base CVSS score used for the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | double           |
  | aws.inspector.package_vulnerability_details.cvss.scoring_vector                         | The vector string of the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.package_vulnerability_details.cvss.source                                 | The source of the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.inspector.package_vulnerability_details.cvss.version                                | The version of CVSS used for the score.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.inspector.package_vulnerability_details.reference_urls                              | One or more URLs that contain details about this vulnerability type.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.package_vulnerability_details.related_vulnerabilities                     | One or more vulnerabilities related to the one identified in this finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.domain                           | A domain to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.extension                        | A extension to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.original                         | A original to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.path                             | A path to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.query                            | A query to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.inspector.package_vulnerability_details.source.url.scheme                           | A scheme to the source url of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.package_vulnerability_details.source.value                                | The source of the vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.package_vulnerability_details.vendor.created_at                           | The date and time that this vulnerability was first added to the vendor's database.                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | aws.inspector.package_vulnerability_details.vendor.severity                             | The severity the vendor has given to this vulnerability type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | aws.inspector.package_vulnerability_details.vendor.updated_at                           | The date and time the vendor last updated this vulnerability in their database.                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | aws.inspector.package_vulnerability_details.vulnerability_id                            | The ID given to this vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.arch                    | The architecture of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.epoch                   | The epoch of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.file_path               | The file path of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.fixed_in_version        | The version of the package that contains the vulnerability fix.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.name                    | The name of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.package_manager         | The package manager of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.release                 | The release of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.remediation             | The code to run in your environment to update packages with a fix available.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.source_lambda_layer_arn | The Amazon Resource Number (ARN) of the AWS Lambda function affected by a finding.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.source_layer_hash       | The source layer hash of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.package_vulnerability_details.vulnerable_packages.version                 | The version of the vulnerable package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.remediation.recommendation.text                                           | The recommended course of action to remediate the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.inspector.remediation.recommendation.url.domain                                     | The domain to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.remediation.recommendation.url.extension                                  | The extension to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.remediation.recommendation.url.original                                   | The original to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.remediation.recommendation.url.path                                       | The path to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.remediation.recommendation.url.query                                      | The query to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.inspector.remediation.recommendation.url.scheme                                     | The scheme to the CVE remediation url recommendations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.iam_instance_profile_arn               | The IAM instance profile ARN of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.image_id                               | The image ID of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.ipv4_addresses                         | The IPv4 addresses of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | aws.inspector.resources.details.aws.ec2_instance.ipv6_addresses                         | The IPv6 addresses of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | aws.inspector.resources.details.aws.ec2_instance.key_name                               | The name of the key pair used to launch the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.launched_at                            | The date and time the Amazon EC2 instance was launched at.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | date             |
  | aws.inspector.resources.details.aws.ec2_instance.platform                               | The platform of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.subnet_id                              | The subnet ID of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.type                                   | The type of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.resources.details.aws.ec2_instance.vpc_id                                 | The VPC ID of the Amazon EC2 instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.architecture                    | The architecture of the Amazon ECR container image.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.author                          | The image author of the Amazon ECR container image.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.image.hash                      | The image hash of the Amazon ECR container image.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.image.tags                      | The image tags attached to the Amazon ECR container image.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.in_use_count                    | The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR container image is in use.                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | aws.inspector.resources.details.aws.ecr_container_image.last_in_use_at                  | The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS pod.                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | aws.inspector.resources.details.aws.ecr_container_image.platform                        | The platform of the Amazon ECR container image.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.pushed_at                       | The date and time the Amazon ECR container image was pushed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | date             |
  | aws.inspector.resources.details.aws.ecr_container_image.registry                        | The registry the Amazon ECR container image belongs to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.inspector.resources.details.aws.ecr_container_image.repository_name                 | The name of the repository the Amazon ECR container image resides in.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.architectures                       | The instruction set architecture that the AWS Lambda function supports. Architecture is a string array with one of the valid values. The default architecture value is x86_64.                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.code_sha256                         | The SHA256 hash of the AWS Lambda function's deployment package.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.execution_role_arn                  | The AWS Lambda function's execution role.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.function_name                       | The name of the AWS Lambda function.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.last_modified_at                    | The date and time that a user last updated the configuration, in ISO 8601 format.                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
  | aws.inspector.resources.details.aws.lambda_function.layers                              | The AWS Lambda function's layers. A Lambda function can have up to five layers.                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.package_type                        | The type of deployment package. Set to Image for container image and set Zip for .zip file archive.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.runtime                             | The runtime environment for the AWS Lambda function.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.version                             | The version of the AWS Lambda function.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.vpc_config.security_group_ids       | The VPC security groups and subnets that are attached to an AWS Lambda function. For more information, see VPC Settings.                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.vpc_config.subnet_ids               | A list of VPC subnet IDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.resources.details.aws.lambda_function.vpc_config.vpc_id                   | The ID of the VPC.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | aws.inspector.resources.details.code_repository.integration_arn                         | The Amazon Resource Name (ARN) of the code security integration associated with the repository.                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.resources.details.code_repository.project_name                            | The name of the project in the code repository.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.resources.details.code_repository.provider_type                           | The type of repository provider (such as GitHub, GitLab, etc.).                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.resources.id                                                              | The ID of the resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | aws.inspector.resources.partition                                                       | The partition of the resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | aws.inspector.resources.region                                                          | The AWS Region the impacted resource is located in.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | aws.inspector.resources.tags                                                            | The tags attached to the resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | flattened        |
  | aws.inspector.resources.type                                                            | The type of resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | aws.inspector.severity                                                                  | The severity of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | aws.inspector.status                                                                    | The status of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | aws.inspector.title                                                                     | The title of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | aws.inspector.transform_unique_id                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | aws.inspector.type                                                                      | The type of the finding.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | aws.inspector.updated_at                                                                | The date and time the finding was last updated at.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | cloud.image.id                                                                          | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset                                                                     | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                                                   | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                                                        | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                                           | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                                            | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | host.containerized                                                                      | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.os.build                                                                           | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                                                                        | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | input.type                                                                              | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | log.file.device_id                                                                      | Device Id of the log file this event came from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | log.file.inode                                                                          | Inode number of the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | log.file.path                                                                           | Path to the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | log.offset                                                                              | Log offset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | observer.vendor                                                                         | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | package.fixed_version                                                                   | In which version of the package the vulnerability was fixed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | resource.id                                                                             | The ID of the vulnerable resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | resource.name                                                                           | The name of the vulnerable resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | resource.type                                                                           | The type of the vulnerable resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | vulnerability.cve                                                                       | The CVE id of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | vulnerability.published_date                                                            | When the vulnerability was published.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | vulnerability.scanner.vendor                                                            | The name of the vulnerability scanner vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | vulnerability.title                                                                     | The human readeable title of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Inspector Findings Overview dashboard](https://epr.elastic.co/package/aws/6.1.0/img/inspector-findings-overview-dashboard.png)

  ![Inspector Severity dashboard](https://epr.elastic.co/package/aws/6.1.0/img/inspector-severity-dashboard.png)

  ![Inspector Vulnerabilities dashboard](https://epr.elastic.co/package/aws/6.1.0/img/inspector-vulnerabilities-dashboard.png)

  ![Inspector EC2 & ECR Overview dashboard](https://epr.elastic.co/package/aws/6.1.0/img/inspector-ec2-ecr-overview-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version              | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Minimum Kibana version  |
  |----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
  | **6.1.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17084))Remove fixed value `event.dataset` mapping for lambda_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **6.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16133))Remove third-party pipeline for previously removed 'third-party REST API' input from 'AWS Cloudtrail'.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16991))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16755))Update AWS ALB Grok patterns to support the conn_trace_id field and parse malformed requests missing HTTP versions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16905))Added support for extracting user name from AWS GovCloud STS ARNs and fixed management_event field type conversion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.18.19.4             |
  | **5.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16713))Add dashboards for AWS Web Application Firewall data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.2.18.19.4             |
  | **5.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16695))S3 Access logs, improve S3KEY regex to handle special characters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.2.18.19.4             |
  | **5.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15346))Add ec2_metrics, lambda, sqs and sns alert rule templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16122))Add `cookies` field in cloudfront logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16579))Added rate limiting and retry configuration for AWS Config data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **5.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15601))Normalize user fields for AWS CloudTrail events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **5.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16515))Set `event.kind` to `alert` on AWS WAF events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16195))Rebrand AWS Security Hub as AWS Security Hub CSPM to align with the vendor's current branding.This change involves updating the `observer.vendor` value to `AWS Security Hub CSPM`.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **4.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15929))Add type-specific entity fields to data stream.This enables better entity classification while maintaining backward compatibility with existing `actor.entity.id` and `target.entity.id` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **4.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16098))Retain CloudTrail `sessionCredentialFromConsole` field as `aws.cloudtrail.session_credential_from_console`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.48.19.4             |
  | **4.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15945))Prevent updating fleet health status to degraded when the HTTPJSON template value evaluation is empty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.1.48.19.4             |
  | **4.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15279))Prefer set with copy_from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.08.19.0             |
  | **4.3.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out document containing an error.message from AWS Config, AWS Inspector, and AWS Security Hub latest indexes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15737))Update the AWS CloudWatch documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15320))Improve documentation to align with new guidelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.1.08.19.0             |
  | **4.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15436))Add `user.name` to Cloudtrail's `UserAuthentication` events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.1.08.19.0             |
  | **4.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` and `misconfiguration_workflow` sub category labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.1.08.19.0             |
  | **4.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15230))Add latest transform to `AWS Config` and `AWS Inspector`.This enables support for extended protections for `AWS Config` and `AWS Inspector`.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15230))The latest transforms requires `transform` node and necessary permissions to use the transform.The transforms stores the latest copy of vulnerabilities and misconfigurations in the destination indices, which will require additional storage.Due to change in fingeprinting on source indices, duplicates occur on source indices of `AWS Config` and `AWS Inspector`.                                 | 9.1.08.19.0             |
  | **3.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17064))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16998))Disable lastSync start_position configuration for CloudWatch as it's incompatible with versions below 9.x.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15312))Enable Agentless deployment for AWS GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15217))Map `recipient_account_id` to `cloud.account.id` for AWS CloudTrail.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15077))Add support for VPC Flow logs versions 6, 7, and 8.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14995))Remove unused agent files.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.14.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14958))Fixed issue where empty DescribeConfigRules responses caused 'index out of bounds' errors in AWS Config integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.08.17.48.16.6 |
  | **3.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14947))Prevent logging expected agent HTTP JSON template errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14733))Add description on lastSync start_position configuration for CloudWatch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.13.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14734))Remove redundant code from config data stream agent configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.13.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14573))Remove Include Linked Accounts config option from AWS Health.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14525))Avoid updating fleet health status to degraded when Guardduty has no findings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14441))Reduce unnecessary work done in cloudtrail data stream when flattened fields are not required.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14306))Mapping changes in `inspector` datastream for Cloud Detection and Response (CDR) vulnerability workflow.Parse and map newly introduced fields in the `inspector` data stream.Enable request trace log removal and Agentless deployment in the `inspector` data stream.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.11.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13345))Fix `tlsVersion` parsing when not properly defined in cloudtrail event.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13345))Add empty value removal script to cloudtrail data stream ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.18.08.17.48.16.6 |
  | **3.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14439))Fix configuration template typo.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14236))Allow user-specification of fields to retain in the cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14354))Ingest managed insights from Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14264))Fix null reference in securityhub_findings* data streams when extracting `host.ip`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.08.17.48.16.6 |
  | **3.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14251))Modify the data type of `event.kind` from a constant_keyword to a keyword to handle pipeline errors that send `event.kind` as `pipeline_error`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14181))Add AWS lambda logs overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14070))Add AWS lambda logs dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.5.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14179))Add Redshift `InstanceType` dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14169))Change Redshift terraform node type because `dc2.large` is deprecated and leads to system tests fails.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13956))Add the `external_id` field to data streams collecting data from S3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13830))Add new AWS Config datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.3.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13978))Update README - Document ingested log types of AWS Network Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13434))Update README - EC2 Instance IAM Role for AWS Authentication                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13676))Fix handling of duplicate fields in Network Firewall Logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13246))Remove deprecated httpjson input for cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13367))Add agentless deployment for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13542))Enhancements for Guardduty dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13372))Add new Security Hub Findings Full Posture data stream. If you rely on Findings > Misconfigurations view, enable this new data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **2.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13486))Update grok pattern for AWS S3 access ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.16.5             |
  | **2.45.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.45.0**           | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13370))Update default data_stream.dataset to aws.cloudwatch_logs for cloudwatch_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.16.5             |
  | **2.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12685))Add `actor.entity.id` and `target.entity.id`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.16.5             |
  | **2.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13099))Set `event.type` and `event.action` fields in vpcflow logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.16.5             |
  | **2.41.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12727))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.16.2             |
  | **2.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12755))Ignore long `cloudtrail.request_parameters` and `cloudtrail.response_elements` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.16.2             |
  | **2.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12637))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.16.2             |
  | **2.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.2                  |
  | **2.38.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.2                  |
  | **2.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.2                  |
  | **2.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.2                  |
  | **2.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11883))Map aws.dimensions as object instead of flattened in CloudWatch metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.16.0                  |
  | **2.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12110))Include pipeline test examples to accommodate the new Cloudtrail format for the `CreateGroup` and `UpdateGroup` event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12072))Add SQS API calls documentation and required S3 permissions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12030))Add ELB connection logs dashboards for application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.16.0                  |
  | **2.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11933))Add the support for connection logs for AWS ELB dataset for Application Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.16.0                  |
  | **2.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11907))Add Lambda Event Source Mapping metrics and improve Lambda dashboard to display the new metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.0                  |
  | **2.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11484))Add option to check linked accounts when using log group prefixes to derive matching log groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.32.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11829))Implemented grok processor based parsing for ipv6 & ipv4 addresses in the AWS CloudFront logs.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11829))Auto formatted various text descriptions and newlines across all data streams via elastic-package.                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.31.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11794))Update documentation with required permissions for AWS Inspector.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.16.0                  |
  | **2.31.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11654))Removed the `reducedTimeRange` filter from the AWS Billing Total Estimated Charges lens to ensure value is displayed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.0                  |
  | **2.31.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11590))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.31.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11608))Add `cloud.provider`, `event.kind`, and `observer.vendor` fields to _source as needed by CDR workflows.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.16.0                  |
  | **2.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11158))Improve support for Cloud Detection and Response (CDR) workflows in securityhub_findings data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.30.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12237))Map aws.dimensions as object instead of flattened in CloudWatch metrics (backported from 2.37.0)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.15.2                  |
  | **2.30.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11706))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.15.2                  |
  | **2.30.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11498))Update the AWS dashboard panels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.15.2                  |
  | **2.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11442))Support configuring the Owning Account                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.2                  |
  | **2.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11392))Add mapping for the service.runtimeDetails fields in GuardDuty events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11416))Add reference to AWS API requests and pricing information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.15.0                  |
  | **2.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11112))Improve ingest pipeline error reporting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.15.0                  |
  | **2.26.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11397))Add more data to related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.26.0-preview01** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11115))Add related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **2.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11368))Add aws.metrics_names_fingerprint field and mark it as a dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11369))Fix aws.metrics_names_fingerprint field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11281))Add aws.metrics_names_fingerprint.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.14.0                  |
  | **2.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10216))Fixed and refactored AWS cloudfront log parsing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.14.0                  |
  | **2.24.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10683))Add dot_expander processor into metrics ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.23.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10444))Split the current AWS ELB dashboard into 3 separate dashboards, each focusing on a specific type of load balancer ELB, ALB, and NLB.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.22.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10480))Update max_number_of_messages parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10324))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.14.0                  |
  | **2.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9249))Fix route53 public logs grok pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10460))Add S3 polling option to data streams use aws-s3 input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.14.0                  |
  | **2.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10488))Add a visualization panel to display the Inbound and Outbound traffic of Application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/10119))Add AWS Health integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.14.0                  |
  | **2.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10223))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                  |
  | **2.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10181))Add TargetResponseTime metric to ELB Application metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10082))Fix AWS Network Firewall title and description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                  |
  | **2.15.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9865))Add endpoint + region variables to all SQS based AWS integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                  |
  | **2.15.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9763))Fix AWS Cloudtrail resources field processing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9705))Don't index empty AWS Security Hub responses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9782))Adds async event age and drops metrics, and implements sum aggregation for existing lambda metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                  |
  | **2.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9669))Update aggregation function for AWS lambda invocation metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9290))Document billing data stream limitations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8414))Add ability to set processors and leader election on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                  |
  | **2.13.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9346))Update latency parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                  |
  | **2.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9133))Add Amazon MSK integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.12.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9253))Fix an issue were the "_id" field was being used to aggregate data in Severity Over Time dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                  |
  | **2.12.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9213))Add cloudsecurity_cdr sub category label.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9009))Enable 'secret' for the sensitive fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8882))Fix query range calculation for GuardDuty datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.10.2                  |
  | **2.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8811))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.11.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8703))Improve wording on milliseconds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.10.2                  |
  | **2.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8509))Convert Total Estimated Charges panel to new metric visualization.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.10.2                  |
  | **2.10.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8709))Fix dimensions fingerprint field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.10.2                  |
  | **2.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.10.2                  |
  | **2.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8513))Convert "AWS Redshift metrics overview" visualizations to new metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8521))Change SQS metrics statistic method, which includes changing ApproximateAgeOfOldestMessage from average to max, changing NumberOfMessagesDeleted, NumberOfEmptyReceives, NumberOfMessagesReceived and NumberOfMessagesSent from average to sum.                                                                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **2.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.9.0                   |
  | **2.8.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8398))Add missing fields from beats input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.8.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8332))Update donut charts with pie for better representation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **2.8.4**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8140))Remove unused aws.*.metrics.*.* and aws.s3.bucket.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.8.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Include documentation and mappings for subfields of dns.answers**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping for tags and dynamic metric fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7933))Add null checks and ignore_missing checks to the rename processor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7659))Fix incorrect billing metrics displayed under AWS Billing overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8027))Allow configuration of TLD for guardduty, inspector, and security hub datastreams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Upgrade package spec to 3.0.0.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Fix duplicated and invalid field definitions.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add missing dashboard filters.                                                                                                                       | 8.9.0                   |
  | **2.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7990))Fix AWS API Gateway logs dashboard lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **2.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8002))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6352))Update Cloudtrail datastream to support tlsDetails field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **2.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7900))Fix Security Hub Findings to abide by ECS allowed values.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **2.4.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7876))Add AWS API Gateway metrics dashboards for each API type and additional filters which ensure data consistency                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7856))Change include_linked_accounts default to true                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7785))Fix GuardDuty API call parameter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7702))Add AWS API Gateway metrics dashboard Stage filter, control groups and clean up                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.1.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7675))Fix AWS API Gateway metrics dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7541))Improve AWS API Gateway dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7497))Enable TSDB by default for EC2 metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                                | 8.9.0                   |
  | **2.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6247))Remove deprecated option for "Cloudwatch via S3"from the AWS CloudWatch integration. If you are using it take note that logs WON'T BE ingested via this route anymore once you update.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **1.53.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7490))Set metric type in EC2 data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.9.0                   |
  | **1.53.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7487))Add dimension fields to EC2 data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **1.53.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7425))Add missing fields definition for ec2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **1.53.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7331))Remove the remove processor since rename processor removes old field already.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **1.53.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7435))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.9.0                   |
  | **1.53.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7151))Add AWS API Gateway custom acccess logging fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **1.52.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7129))Use default color for AWS dashboards metric charts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **1.52.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7262))Enable TSDB by default for cloudwatch metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **1.51.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8888))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.51.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7438))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.51.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7327))Use object metric type for the cloudwatch metrics                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.51.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6936))Add standalone S3 option for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.50.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6999))Add metric_type metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.50.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6871))Migrate AWS Security Hub dashboards to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.50.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6962))Migrate AWS VPC dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.50.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7075))Add EMR logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.50.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6644))Migrate AWS Billing dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.50.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6683))Add AWS API Gateway logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.50.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6895))Add EMR logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.49.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6530))Add API Gateway logs datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.8.1                   |
  | **1.48.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6915))Adding missing fields for the CloudTrail datastream - add option for standalone S3 bucket                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.47.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6865))Migrate AWS Redshift dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.47.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6487))Migrate AWS S3 Server Access Log Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.46.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6995))Migrate AWS Network Firewall dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.46.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6827))Add dimensions metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.46.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6969))Enable time series data streams for the API Gateway and EMR data streams. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.46.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6964))Update metric type and set dimension fields for AWS EMR data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.46.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6952))Fix metric type for API Gateway metric fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.46.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6950))Set dimensions fields for API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.46.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6916))Add missing S3 fields for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.46.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6887))Enable time series data streams for the S3 daily storage and S3 request datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                  | 8.8.1                   |
  | **1.46.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6886))Enable time series data streams for the Usage dataset. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.46.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6782))Enable time series data streams for the metrics datasets Billing, DynamoDB, EBS, ECS, ELB, Firewall, Kinesis, Lambda, NAT gateway, RDS, Redshift, S3 Storage Lens, SNS, SQS, Transit Gateway and VPN. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                              | 8.8.1                   |
  | **1.45.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6749))Add new fingerprint dimension to AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.45.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6667))Add metric_type metadata to s3_daily_storage and s3_request data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6666))Add dimension fields metadata to s3_request and s3_data_storage data streams to support TSDB                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.45.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6584))Add metric type to S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.45.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6583))Set dimension fields for S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6648))Remove aws.dimensions.* from package-fields.yml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6606))Add AWS EMR metrics dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6476))Add AWS API Gateway dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6120))Add AWS EMR metrics data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.8.1                   |
  | **1.44.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6543))Migrate AWS Metric Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.44.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6521))Migrate AWS ELB Access Log dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.44.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6561))Fix image link in readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.44.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5651))Migrate AWS TransitGateway metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for cloudwatch_logs and ec2_logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.43.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6231))Add documentation for latency parameter                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.43.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6526))Add tags_filter and include_linked_accounts config parameter in missing metric data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6459))Add include_linked_accounts config parameter for metrics data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6421))Add field agent.id to be set as dimension for TSDB migration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5426))Migrate AWS NATGateway metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.40.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5643))Migrate AWS ELB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5626))Migrate EC2 metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.40.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5650))Add AWS Firewall metrics dashboard input control groups.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                   |
  | **1.40.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6455))Migrate AWS S3 Storage Lens dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.40.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6368))Migrate Usage Overview dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6374))Migrate AWS CloudTrail dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.40.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6296))Add fields metric type to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.40.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6440))Replace aws.rds.db_instance.identifier with aws.dimensions.DBInstanceIdentifier in RDS dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.40.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6480))Add link to main AWS requirements in all integrations page.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6319))Add metric type to SNS, SQS and Billing data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6188))Add AWS API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.38.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6311))Add dimension fields to billing, sns and sqs data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.38.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6339))Add dimension fields to firewall, transit gateway and vpn data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.38.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6365))Add metric type to vpn, firewall and transit gateway data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6094))Add metric type to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6079))Add dimensions to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.37.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6353))Fix incorrect fields on multiple visualizations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5640))Migrate AWS RDS metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5642))Migrate AWS SNS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5644))Migrate AWS SQS metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.36.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5649))Migrate AWS VPN metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6213))Add dimension fields to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.36.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5973))Add dimension fields to Lambda data stream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6105))Add metric type to natgateway data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.36.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6063))Add metric type to EBS fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                   |
  | **1.36.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5866))Add support for TSDB on kinesis data stream (metric type).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.36.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6083))Add dimensions to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6087))Add metric type mapping to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6102))Add dimension fields to natgateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6045))Add metric type to Lambda fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.35.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6213))Fix typo in field name causing erroneous timestamp detection on the s3access data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6161))Add a new flag to enable request tracing on `httpjson` based input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.34.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5455))Migrate AWS Lambda metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                   |
  | **1.34.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5288))Migrate AWS DynamoDB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                   |
  | **1.34.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5968))Add field metric type to ECS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.34.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5891))Add dimension fields to Kinesis datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.6.0                   |
  | **1.34.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5895))Add dimension fields to ECS datastream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                   |
  | **1.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6062))Add dimensions to EBS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.33.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5794))Add number_of_workers and latency to all CloudWatch Logs based integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.33.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5791))Add missing permissions in the AWS Billing integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                   |
  | **1.33.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5790))Add missing permissions in the AWS CloudWatch Logs integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5777))Add latency configuration option on the CloudWatch Logs integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.32.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5646))Fix a minor documentation format issue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.32.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                   |
  | **1.32.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5212))Migrate AWS EBS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4915))Add a data stream for Amazon GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                   |
  | **1.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5178))Add dashboards data streams filters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.29.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5017))Drop comments from CloudFront loglines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4515))Add data_granularity parameter and rename period title to Collection Period.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.28.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4857))Remove quotes from VPC flow log message field and move dot_expander processor to top                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.28.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Add dot_expander processor to expand all fields with dot into object fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Support VPC flow log with message field                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.4.0                   |
  | **1.28.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4794))Adjust kinesis integration to kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.4.0                   |
  | **1.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4641))Enhance S3 integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.27.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4676))Support multiple forwarded IPs in cloudfront integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.4.0                   |
  | **1.27.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4703))Update the pagination termination condition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.4.0                   |
  | **1.27.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4596))Added a Summary Dashboard for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.4.0                   |
  | **1.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4604))Add Inspector data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.4.0                   |
  | **1.25.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4657))Remove duplicate fields from agent.yml and use ecs.yml for ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.25.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4567/))Update ec2 fields.yml doc                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.3.0                   |
  | **1.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4592))Remove duplicate 'content_type' config that causes errors while configurating the integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.3.0                   |
  | **1.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4532))Force content type where json content is expected                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4551))Enhance Kinesis integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4437))Allow adding multiple processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.24.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4430))Do not rely on dynamodb lightweight module metricset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4395))Fix adding processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.3.0                   |
  | **1.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4308))Fix billing datastream agent template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.0                   |
  | **1.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4281))Fix aws.cloudtrail.request_id parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4158))Expose Default Region setting to UI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.3.0                   |
  | **1.23.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4103))Set default endpoint to empty string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.23.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4083))Fix Billing Dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.23.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4057))Fix EC2 dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.3.0                   |
  | **1.23.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3907))Update all AWS documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.23.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4049))Fix file.path field in cloudtrail data stream to use json.digestS3Object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.1.0                   |
  | **1.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4024))Update `cloud.region` parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3553))Add Security Hub Findings and Insights data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.1.0                   |
  | **1.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3688))Improve dashboards by removing individual visualizations from library                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.1.0                   |
  | **1.19.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3856))Move ebs metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3874))Update sample_event.json in kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.19.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3873))Move NATGateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.19.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3840))Move Transit Gateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3829))Add Kinesis metrics datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.18.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_request metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_daily_storage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SQS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SNS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/3599))Move lambda metrics config from beats to integrations | 8.0.07.15.0             |
  | **1.18.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3860))Release AWS billing integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3799))Add ECS metricset**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3799))Fix incorrect fields on multiple visualizations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.17.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3851))Release Amazon Redshift integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.17.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3844))Fix data_stream.dataset indentation on cloudwatch_logs integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3795))Add missing endpoint config to metrics datasets.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move usage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move dynamodb metrics config from beats to integrations                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3682))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3610))Fix misspelling of Log Stream Prefix variable in manifest for aws-cloudwatch input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3569))Added Redshift integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.15.0             |
  | **1.16.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3308))Update documentation with additional context for new users.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.16.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3474))Move ELB metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3499))Fix ELB dataset to parse URLs with spaces**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3499))Upgrade ECS to 8.2.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.16.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3467))Move RDS metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3357))Move EC2 metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3342))Fix invalid values for ECS fields in vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3305))Move VPN configuration file into integrations and add tag collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Deprecate s3 input in cloudwatch integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Improve description for cloudwatch integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.8**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3285))Fix http.response.status_code to accept 000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.14.7**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for rds data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for sns data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Add aws.dimensions.* for dynamodb data stream                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3240))Improve s3 integration tile title and description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.14.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3226))Fix duplicate titles for integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3192))Fix cloudfront integration grok pattern                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.14.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2912))Add new pattern to VPC Flow logs including all 29 v5 fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **1.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2946))Fix billing dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2790))Add configuration for max_number_of_messages to the aws.firewall_logs S3 input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2838))Fix metricbeat- reference in dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2767))Compress dashboard screenshots.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.12.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflicts in the elb_logs data stream relating to ECS fields (`trace.id`, `source.port`, and a few others).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2476))Add CloudFront Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2470))Add Ingest Pipeline script to map IANA Protocol Numbers                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2642))Changing missing ecs versions to 8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2560))Add data_stream.dataset option for custom aws-cloudwatch log input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2635))Update permission list                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2478))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2536))Change cloudwatch metrics and logs default to false                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.15.0             |
  | **1.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2530))Add description of supported vpcflow formats                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                         |
  | **1.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2323))Add cloudwatch input into AWS package for log collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2341))Add Route 53 Resolver Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2316))Add Route 53 Public Zone Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2199))Add integration for AWS Network Firewall                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **1.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2325))Fix the value of event.created in CloudTrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2299))Add max_number_of_messages config option to AWS S3 input config.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **1.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2282))Add missing sample events                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2206))Support Kibana 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2153))Add Overview dashboard for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 7.15.0                  |
  | **1.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2142))Add integration for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2003))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1917))Add config parameter descriptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1886))Add WAF datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.2.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1871))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1797))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1687))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **1.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1772))vpcflow sync with filebeat fileset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 7.14.0                  |
  | **1.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1623))Release AWS as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 7.14.0                  |
  | **0.10.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1648))Add proxy config                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.10.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1606))Fix aws.billing.EstimatedCharges field name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.10.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1590))Add event.created field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.10.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1449))Improve RDS dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.10.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1465))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1371))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **0.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **0.9.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1357))Fix categories for each policy template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.9.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1334))Add linked account information into billing metricset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1333))Fix `aws.s3access` pipeline when remote IP is a `-`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1320))Change default credential options to access keys                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1245))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                         |
  | **0.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/767))Introduce granularity using input_groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.6.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1147))Add support for Splunk authorization tokens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.6.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1201))Fix bug in Third Party ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1212))Removed incorrect `http.request.referrer` field from elb logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1079))Add support for CloudTrail Digest & Insight logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1070))Update ECS version, add event.original and preparing for package GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1000))Fix stack compatability                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/979))Allow role_arn work with access keys for AWS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.5.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/631))Rename s3 input to aws-s3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing "geo" fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.5.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/834))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/791))Ignore missing "json" field in ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/782))Moving edge processors to ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **0.4.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/721))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.0.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/21))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                         |
</dropdown>