﻿---
title: AWS CloudWatch
description: The AWS CloudWatch integration allows you to monitor AWS CloudWatch. AWS CloudWatch is a service that provides data and insights for monitoring applications...
url: https://www.elastic.co/docs/reference/integrations/aws/cloudwatch
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# AWS CloudWatch
|                                                                            |                                |
|----------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                | 6.1.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                          |
| **Ingestion method(s)**                                                    | API, AWS CloudWatch, AWS S3    |
| **Minimum Kibana version(s)**                                              | 9.2.18.19.4                    |

The AWS CloudWatch integration allows you to monitor [AWS CloudWatch](https://aws.amazon.com/cloudwatch/). AWS CloudWatch is a service that provides data and insights for monitoring applications and changes to system performance.
Use the AWS CloudWatch integration to collect metrics and logs on the operational health of your AWS resources, applications, and services running on AWS and on-premises. Then visualize that data in Kibana, create alerts to notify you if something goes wrong, and reference logs and metrics when troubleshooting an issue.
For example, you could use the data from this integration to detect anomalous behavior in your environments. You could also use the data to troubleshoot the underlying issue by looking at additional context in the logs and metrics, such as the source of the behavior, and more.
<important>
  Extra AWS charges on API requests will be generated by this integration. Check [API Requests](https://www.elastic.co/docs/current/integrations/aws#api-requests) for more details.
</important>


## What data does this integration collect?

The AWS CloudWatch integration collects two types of data: logs and metrics.
**Logs** help you keep a record of different services in AWS, like EC2, RDS, and S3.
The log data stream includes the CloudWatch log message along with contextual information. See more details in the *Logs reference*.
**Metrics** give you insight into the state of different services in AWS, like EC2, RDS, and S3.
The metric data stream includes the metrics that are returned from a CloudWatch API query along with contextual information. See more details in the *Metrics reference*.

## What do I need to use this integration?

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.
Before using any AWS integration you will need:
- **AWS Credentials** to connect with your AWS account.
- **AWS Permissions** to make sure the user you're using to connect has permission to share the relevant data.

For more details about these requirements, refer to the [AWS integration documentation](https://docs.elastic.co/integrations/aws#requirements).

## Setup

Use this integration if you only need to collect data from the AWS CloudWatch service.
If you want to collect data from two or more AWS services, consider using the **AWS** integration.
When you configure the AWS integration, you can collect data from as many AWS services as you'd like.
For step-by-step instructions on how to set up an integration, see the
[Getting started](https://www.elastic.co/guide/en/starting-with-the-elasticsearch-platform-and-its-solutions/current/getting-started-observability.html) guide.

### Advanced options for specific use cases


##### Set CloudWatch Logs latency

AWS CloudWatch Logs sometimes takes extra time to make the latest logs available to clients like the Agent.
The CloudWatch integration offers the `latency` setting to address this scenario. Latency translates the query's time range to consider the CloudWatch Logs latency. For example, a `5m` latency means the integration will query CloudWatch for logs available 5 minutes ago.

##### Specify number of workers

If you are collecting log events from multiple log groups using `log_group_name_prefix`, you should review the value of the `number_of_workers`.
The `number_of_workers` setting defines the number of workers assigned to reading from log groups. Each log group matching the `log_group_name_prefix` requires a worker to keep log ingestion as close to real-time as possible. For example, if `log_group_name_prefix` matches five log groups, then `number_of_workers` should be set to `5`. The default value is `1`.

##### Collect AWS specific metrics

To collect AWS specific metrics, follow these steps:
1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **AWS CloudWatch**.
3. Select the **AWS CloudWatch** integration and add it.
4. Toggle on **Collect metrics from CloudWatch** and expand the **Change defaults** drop-down. You can add or remove metrics by specifying the name of the resource instance or tags, as shown in the following example:
   ```yaml
   - namespace: AWS/EC2
   ```

resource_type: ec2:instance
name:
- CPUUtilization
- DiskWriteOps
statistic:
- Average
- Maximum

# dimensions:


# - name: InstanceId

```
  # value: i-123456
```


# tags:

```
# - key: created-by
  # value: foo
```

```

5. Save the integration.

## Logs reference

The `cloudwatch` data stream collects CloudWatch logs. Users can use Amazon
CloudWatch logs to monitor, store, and access log files from different sources.

**ECS Field Reference**

For detailed information on ECS fields, check the [ECS field reference](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) documentation.

**Exported fields**

| Field | Description | Type |
|---|---|---|
| @timestamp | Event timestamp. | date |
| aws.cloudwatch.message | CloudWatch log message. | text |
| cloud.image.id | Image ID for the cloud instance. | keyword |
| data_stream.dataset | Data stream dataset. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| event.module | Event module | constant_keyword |
| host.containerized | If the host is a container. | boolean |
| host.os.build | OS build information. | keyword |
| host.os.codename | OS codename, if any. | keyword |


An example event for `cloudwatch` looks as following:

```json
{
  "@timestamp": "2020-02-20T07:02:37.000Z",
  "aws": {
      "cloudwatch": {
          "message": "ip-172-31-81-156 ec2net: [get_meta] Trying to get http://169.254.169.254/latest/meta-data/network/interfaces/macs/12:e2:a9:95:8b:97/local-ipv4s"
      }
  },
  "data_stream": {
      "dataset": "aws.cloudwatch_logs",
      "namespace": "default",
      "type": "logs"
  },
  "ecs": {
      "version": "8.11.0"
  },
  "event": {
      "ingested": "2021-07-19T21:47:04.696803300Z",
      "original": "2020-02-20T07:02:37.000Z Feb 20 07:02:37 ip-172-31-81-156 ec2net: [get_meta] Trying to get http://169.254.169.254/latest/meta-data/network/interfaces/macs/12:e2:a9:95:8b:97/local-ipv4s"
  },
  "tags": [
      "preserve_original_event"
  ]
}
```


## Metrics reference

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-05-28T17:17:02.812Z",
      "agent": {
          "ephemeral_id": "17803f33-b617-4ce9-a9ac-e218c02aeb4b",
          "id": "12f376ef-5186-4e8b-a175-70f1140a8f30",
          "name": "MacBook-Elastic.local",
          "type": "metricbeat",
          "version": "8.0.0"
      },
      "aws": {
          "cloudwatch": {
              "namespace": "AWS/EC2"
          },
          "dimensions": {
              "InstanceId": "i-0830bfecfa7173cbe"
          },
          "ec2": {
              "metrics": {
                  "CPUUtilization": {
                      "avg": 0.7661943132361363,
                      "max": 0.833333333333333
                  },
                  "DiskWriteOps": {
                      "avg": 0,
                      "max": 0
                  }
              }
          }
      },
      "cloud": {
          "account": {
              "id": "428152502467",
              "name": "elastic-beats"
          },
          "provider": "aws",
          "region": "us-west-2"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "event": {
          "dataset": "aws.cloudwatch_metrics",
          "duration": 14119105951,
          "module": "aws"
      },
      "metricset": {
          "name": "cloudwatch",
          "period": 300000
      },
      "service": {
          "type": "aws"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                      | Description                                                                                                                                                                        | Type             | Metric Type |
  |----------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                 | Event timestamp.                                                                                                                                                                   | date             |             |
  | agent.id                   | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                         | keyword          |             |
  | aws.*.metrics.*.*          | Metrics that returned from Cloudwatch API query.                                                                                                                                   | object           | gauge       |
  | aws.cloudwatch.namespace   | The namespace specified when query cloudwatch api.                                                                                                                                 | keyword          |             |
  | aws.dimensions.*           | Metric dimensions.                                                                                                                                                                 | keyword          |             |
  | aws.dimensions_fingerprint | Autogenerated ID representing the fingerprint of the aws.dimensions object                                                                                                         | keyword          |             |
  | aws.tags                   | Tag key value pairs from aws resources.                                                                                                                                            | flattened        |             |
  | cloud.account.id           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword          |             |
  | cloud.image.id             | Image ID for the cloud instance.                                                                                                                                                   | keyword          |             |
  | cloud.region               | Region in which this host, resource, or service is located.                                                                                                                        | keyword          |             |
  | data_stream.dataset        | Data stream dataset.                                                                                                                                                               | constant_keyword |             |
  | data_stream.namespace      | Data stream namespace.                                                                                                                                                             | constant_keyword |             |
  | data_stream.type           | Data stream type.                                                                                                                                                                  | constant_keyword |             |
  | event.module               | Event module                                                                                                                                                                       | constant_keyword |             |
  | host.containerized         | If the host is a container.                                                                                                                                                        | boolean          |             |
  | host.os.build              | OS build information.                                                                                                                                                              | keyword          |             |
  | host.os.codename           | OS codename, if any.                                                                                                                                                               | keyword          |             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![metricbeat aws overview](https://epr.elastic.co/package/aws/6.1.0/img/metricbeat-aws-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version              | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Minimum Kibana version  |
  |----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
  | **6.1.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17084))Remove fixed value `event.dataset` mapping for lambda_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **6.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16133))Remove third-party pipeline for previously removed 'third-party REST API' input from 'AWS Cloudtrail'.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16991))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16755))Update AWS ALB Grok patterns to support the conn_trace_id field and parse malformed requests missing HTTP versions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.2.18.19.4             |
  | **5.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16905))Added support for extracting user name from AWS GovCloud STS ARNs and fixed management_event field type conversion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.2.18.19.4             |
  | **5.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16713))Add dashboards for AWS Web Application Firewall data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.2.18.19.4             |
  | **5.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16695))S3 Access logs, improve S3KEY regex to handle special characters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.2.18.19.4             |
  | **5.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15346))Add ec2_metrics, lambda, sqs and sns alert rule templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.2.18.19.4             |
  | **5.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16122))Add `cookies` field in cloudfront logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16579))Added rate limiting and retry configuration for AWS Config data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **5.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15601))Normalize user fields for AWS CloudTrail events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **5.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16515))Set `event.kind` to `alert` on AWS WAF events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.1.48.19.4             |
  | **5.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/16195))Rebrand AWS Security Hub as AWS Security Hub CSPM to align with the vendor's current branding.This change involves updating the `observer.vendor` value to `AWS Security Hub CSPM`.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.1.48.19.4             |
  | **4.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15929))Add type-specific entity fields to data stream.This enables better entity classification while maintaining backward compatibility with existing `actor.entity.id` and `target.entity.id` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4             |
  | **4.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16098))Retain CloudTrail `sessionCredentialFromConsole` field as `aws.cloudtrail.session_credential_from_console`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.48.19.4             |
  | **4.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15945))Prevent updating fleet health status to degraded when the HTTPJSON template value evaluation is empty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.1.48.19.4             |
  | **4.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15279))Prefer set with copy_from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.08.19.0             |
  | **4.3.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out document containing an error.message from AWS Config, AWS Inspector, and AWS Security Hub latest indexes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15737))Update the AWS CloudWatch documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.1.08.19.0             |
  | **4.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15320))Improve documentation to align with new guidelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.1.08.19.0             |
  | **4.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15436))Add `user.name` to Cloudtrail's `UserAuthentication` events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.1.08.19.0             |
  | **4.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` and `misconfiguration_workflow` sub category labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.1.08.19.0             |
  | **4.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15230))Add latest transform to `AWS Config` and `AWS Inspector`.This enables support for extended protections for `AWS Config` and `AWS Inspector`.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15230))The latest transforms requires `transform` node and necessary permissions to use the transform.The transforms stores the latest copy of vulnerabilities and misconfigurations in the destination indices, which will require additional storage.Due to change in fingeprinting on source indices, duplicates occur on source indices of `AWS Config` and `AWS Inspector`.                                 | 9.1.08.19.0             |
  | **3.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17064))Fix Cloudtrail's Lambda event parsing of `vpcConfig.securityGroupIds` and `vpcConfig.subnetIds` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16998))Disable lastSync start_position configuration for CloudWatch as it's incompatible with versions below 9.x.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15312))Enable Agentless deployment for AWS GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15217))Map `recipient_account_id` to `cloud.account.id` for AWS CloudTrail.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15077))Add support for VPC Flow logs versions 6, 7, and 8.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.08.17.48.16.6 |
  | **3.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14995))Remove unused agent files.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.14.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14958))Fixed issue where empty DescribeConfigRules responses caused 'index out of bounds' errors in AWS Config integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.08.17.48.16.6 |
  | **3.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14947))Prevent logging expected agent HTTP JSON template errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14733))Add description on lastSync start_position configuration for CloudWatch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.13.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14734))Remove redundant code from config data stream agent configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.13.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14573))Remove Include Linked Accounts config option from AWS Health.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.08.17.48.16.6 |
  | **3.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14525))Avoid updating fleet health status to degraded when Guardduty has no findings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14441))Reduce unnecessary work done in cloudtrail data stream when flattened fields are not required.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14306))Mapping changes in `inspector` datastream for Cloud Detection and Response (CDR) vulnerability workflow.Parse and map newly introduced fields in the `inspector` data stream.Enable request trace log removal and Agentless deployment in the `inspector` data stream.                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.11.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13345))Fix `tlsVersion` parsing when not properly defined in cloudtrail event.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13345))Add empty value removal script to cloudtrail data stream ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.18.08.17.48.16.6 |
  | **3.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14439))Fix configuration template typo.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14236))Allow user-specification of fields to retain in the cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14354))Ingest managed insights from Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **3.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14264))Fix null reference in securityhub_findings* data streams when extracting `host.ip`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.08.17.48.16.6 |
  | **3.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14251))Modify the data type of `event.kind` from a constant_keyword to a keyword to handle pipeline errors that send `event.kind` as `pipeline_error`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.08.17.48.16.6 |
  | **3.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14181))Add AWS lambda logs overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.08.17.48.16.6 |
  | **3.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14070))Add AWS lambda logs dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.5.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14179))Add Redshift `InstanceType` dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14169))Change Redshift terraform node type because `dc2.large` is deprecated and leads to system tests fails.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13956))Add the `external_id` field to data streams collecting data from S3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13830))Add new AWS Config datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.3.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13978))Update README - Document ingested log types of AWS Network Firewall.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.08.17.48.16.6 |
  | **3.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13434))Update README - EC2 Instance IAM Role for AWS Authentication                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.3.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13676))Fix handling of duplicate fields in Network Firewall Logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.08.17.48.16.6 |
  | **3.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13246))Remove deprecated httpjson input for cloudtrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.08.17.48.16.6 |
  | **3.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13367))Add agentless deployment for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.08.17.48.16.6 |
  | **3.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13542))Enhancements for Guardduty dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.08.17.48.16.6 |
  | **3.0.0**            | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13372))Add new Security Hub Findings Full Posture data stream. If you rely on Findings > Misconfigurations view, enable this new data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.08.17.48.16.6 |
  | **2.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13486))Update grok pattern for AWS S3 access ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.16.5             |
  | **2.45.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.45.0**           | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13370))Update default data_stream.dataset to aws.cloudwatch_logs for cloudwatch_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.16.5             |
  | **2.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12685))Add `actor.entity.id` and `target.entity.id`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.16.5             |
  | **2.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13099))Set `event.type` and `event.action` fields in vpcflow logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.16.5             |
  | **2.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.16.5             |
  | **2.41.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12727))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.16.2             |
  | **2.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12755))Ignore long `cloudtrail.request_parameters` and `cloudtrail.response_elements` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.16.2             |
  | **2.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12637))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.16.2             |
  | **2.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.2                  |
  | **2.38.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.2                  |
  | **2.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.2                  |
  | **2.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.2                  |
  | **2.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11883))Map aws.dimensions as object instead of flattened in CloudWatch metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.16.0                  |
  | **2.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12110))Include pipeline test examples to accommodate the new Cloudtrail format for the `CreateGroup` and `UpdateGroup` event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12072))Add SQS API calls documentation and required S3 permissions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.16.0                  |
  | **2.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12030))Add ELB connection logs dashboards for application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.16.0                  |
  | **2.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11933))Add the support for connection logs for AWS ELB dataset for Application Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.16.0                  |
  | **2.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11907))Add Lambda Event Source Mapping metrics and improve Lambda dashboard to display the new metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.16.0                  |
  | **2.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11484))Add option to check linked accounts when using log group prefixes to derive matching log groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.32.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11829))Implemented grok processor based parsing for ipv6 & ipv4 addresses in the AWS CloudFront logs.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11829))Auto formatted various text descriptions and newlines across all data streams via elastic-package.                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.31.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11794))Update documentation with required permissions for AWS Inspector.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.16.0                  |
  | **2.31.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11654))Removed the `reducedTimeRange` filter from the AWS Billing Total Estimated Charges lens to ensure value is displayed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.0                  |
  | **2.31.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11590))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.16.0                  |
  | **2.31.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11608))Add `cloud.provider`, `event.kind`, and `observer.vendor` fields to _source as needed by CDR workflows.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.16.0                  |
  | **2.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11158))Improve support for Cloud Detection and Response (CDR) workflows in securityhub_findings data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.16.0                  |
  | **2.30.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12237))Map aws.dimensions as object instead of flattened in CloudWatch metrics (backported from 2.37.0)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.15.2                  |
  | **2.30.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11706))Add the support for listeners with ALPN policy extension in ELB dataset for Network Load Balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.15.2                  |
  | **2.30.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11498))Update the AWS dashboard panels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.15.2                  |
  | **2.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11442))Support configuring the Owning Account                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.2                  |
  | **2.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11392))Add mapping for the service.runtimeDetails fields in GuardDuty events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11416))Add reference to AWS API requests and pricing information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.15.0                  |
  | **2.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11112))Improve ingest pipeline error reporting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.15.0                  |
  | **2.26.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11397))Add more data to related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.15.0                  |
  | **2.26.0-preview01** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11115))Add related.entity field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **2.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11368))Add aws.metrics_names_fingerprint field and mark it as a dimension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10888))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11369))Fix aws.metrics_names_fingerprint field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11281))Add aws.metrics_names_fingerprint.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.14.0                  |
  | **2.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10216))Fixed and refactored AWS cloudfront log parsing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.14.0                  |
  | **2.24.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10683))Add dot_expander processor into metrics ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.14.0                  |
  | **2.23.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10444))Split the current AWS ELB dashboard into 3 separate dashboards, each focusing on a specific type of load balancer ELB, ALB, and NLB.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.22.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10480))Update max_number_of_messages parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.14.0                  |
  | **2.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10324))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.14.0                  |
  | **2.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9249))Fix route53 public logs grok pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10460))Add S3 polling option to data streams use aws-s3 input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.14.0                  |
  | **2.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10488))Add a visualization panel to display the Inbound and Outbound traffic of Application load balancers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.14.0                  |
  | **2.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/10119))Add AWS Health integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.14.0                  |
  | **2.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10223))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                  |
  | **2.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10181))Add TargetResponseTime metric to ELB Application metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10082))Fix AWS Network Firewall title and description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                  |
  | **2.15.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9865))Add endpoint + region variables to all SQS based AWS integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                  |
  | **2.15.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9763))Fix AWS Cloudtrail resources field processing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.15.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9705))Don't index empty AWS Security Hub responses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9782))Adds async event age and drops metrics, and implements sum aggregation for existing lambda metrics.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                  |
  | **2.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9669))Update aggregation function for AWS lambda invocation metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9290))Document billing data stream limitations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8414))Add ability to set processors and leader election on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                  |
  | **2.13.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9346))Update latency parameter description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                  |
  | **2.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9133))Add Amazon MSK integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                  |
  | **2.12.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9253))Fix an issue were the "_id" field was being used to aggregate data in Severity Over Time dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                  |
  | **2.12.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9213))Add cloudsecurity_cdr sub category label.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9009))Enable 'secret' for the sensitive fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                  |
  | **2.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8882))Fix query range calculation for GuardDuty datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.10.2                  |
  | **2.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8811))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.11.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8703))Improve wording on milliseconds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.10.2                  |
  | **2.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8509))Convert Total Estimated Charges panel to new metric visualization.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.10.2                  |
  | **2.10.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8709))Fix dimensions fingerprint field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.10.2                  |
  | **2.10.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.10.2                  |
  | **2.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8513))Convert "AWS Redshift metrics overview" visualizations to new metric.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.10.2                  |
  | **2.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8521))Change SQS metrics statistic method, which includes changing ApproximateAgeOfOldestMessage from average to max, changing NumberOfMessagesDeleted, NumberOfEmptyReceives, NumberOfMessagesReceived and NumberOfMessagesSent from average to sum.                                                                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **2.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.9.0                   |
  | **2.8.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8398))Add missing fields from beats input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.8.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8332))Update donut charts with pie for better representation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **2.8.4**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8140))Remove unused aws.*.metrics.*.* and aws.s3.bucket.name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.8.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Include documentation and mappings for subfields of dns.answers**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping for tags and dynamic metric fields                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7933))Add null checks and ignore_missing checks to the rename processor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.8.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7659))Fix incorrect billing metrics displayed under AWS Billing overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8027))Allow configuration of TLD for guardduty, inspector, and security hub datastreams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **2.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7955))Upgrade package spec to 3.0.0.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Fix duplicated and invalid field definitions.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7955))Add missing dashboard filters.                                                                                                                       | 8.9.0                   |
  | **2.6.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7990))Fix AWS API Gateway logs dashboard lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **2.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8002))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6352))Update Cloudtrail datastream to support tlsDetails field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **2.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7900))Fix Security Hub Findings to abide by ECS allowed values.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **2.4.0**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7876))Add AWS API Gateway metrics dashboards for each API type and additional filters which ensure data consistency                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **2.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7856))Change include_linked_accounts default to true                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.9.0                   |
  | **2.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7785))Fix GuardDuty API call parameter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.9.0                   |
  | **2.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7702))Add AWS API Gateway metrics dashboard Stage filter, control groups and clean up                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.9.0                   |
  | **2.1.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7675))Fix AWS API Gateway metrics dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7541))Improve AWS API Gateway dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.9.0                   |
  | **2.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7497))Enable TSDB by default for EC2 metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                                | 8.9.0                   |
  | **2.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6247))Remove deprecated option for "Cloudwatch via S3"from the AWS CloudWatch integration. If you are using it take note that logs WON'T BE ingested via this route anymore once you update.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.9.0                   |
  | **1.53.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7490))Set metric type in EC2 data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.9.0                   |
  | **1.53.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7487))Add dimension fields to EC2 data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                   |
  | **1.53.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7425))Add missing fields definition for ec2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.9.0                   |
  | **1.53.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7331))Remove the remove processor since rename processor removes old field already.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.9.0                   |
  | **1.53.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7435))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.9.0                   |
  | **1.53.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7151))Add AWS API Gateway custom acccess logging fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.9.0                   |
  | **1.52.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7129))Use default color for AWS dashboards metric charts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.9.0                   |
  | **1.52.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7262))Enable TSDB by default for cloudwatch metrics data stream. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                         | 8.9.0                   |
  | **1.51.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8888))Remove hardcoded event.dataset field and use ecs instead.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.51.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7438))Disable TSDB on AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.51.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7327))Use object metric type for the cloudwatch metrics                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.51.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6936))Add standalone S3 option for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.50.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6999))Add metric_type metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.50.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6871))Migrate AWS Security Hub dashboards to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.50.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6962))Migrate AWS VPC dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.50.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7075))Add EMR logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.50.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6644))Migrate AWS Billing dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.50.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6683))Add AWS API Gateway logs dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.50.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6895))Add EMR logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.49.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6530))Add API Gateway logs datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.8.1                   |
  | **1.48.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6915))Adding missing fields for the CloudTrail datastream - add option for standalone S3 bucket                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.47.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6865))Migrate AWS Redshift dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.47.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6487))Migrate AWS S3 Server Access Log Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.46.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6995))Migrate AWS Network Firewall dashboard input controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.46.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6827))Add dimensions metadata to the cloudwatch data_stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.8.1                   |
  | **1.46.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6969))Enable time series data streams for the API Gateway and EMR data streams. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.46.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6964))Update metric type and set dimension fields for AWS EMR data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.46.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6952))Fix metric type for API Gateway metric fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.46.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6950))Set dimensions fields for API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.46.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6916))Add missing S3 fields for vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.8.1                   |
  | **1.46.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6887))Enable time series data streams for the S3 daily storage and S3 request datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                  | 8.8.1                   |
  | **1.46.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6886))Enable time series data streams for the Usage dataset. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.46.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6782))Enable time series data streams for the metrics datasets Billing, DynamoDB, EBS, ECS, ELB, Firewall, Kinesis, Lambda, NAT gateway, RDS, Redshift, S3 Storage Lens, SNS, SQS, Transit Gateway and VPN. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                              | 8.8.1                   |
  | **1.45.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6749))Add new fingerprint dimension to AWS Billing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.45.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6667))Add metric_type metadata to s3_daily_storage and s3_request data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6666))Add dimension fields metadata to s3_request and s3_data_storage data streams to support TSDB                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.45.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6584))Add metric type to S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.8.1                   |
  | **1.45.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6583))Set dimension fields for S3 Storage Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.8.1                   |
  | **1.45.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6648))Remove aws.dimensions.* from package-fields.yml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.8.1                   |
  | **1.45.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6606))Add AWS EMR metrics dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6476))Add AWS API Gateway dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.8.1                   |
  | **1.45.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6120))Add AWS EMR metrics data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.8.1                   |
  | **1.44.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6543))Migrate AWS Metric Overview dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.8.1                   |
  | **1.44.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6521))Migrate AWS ELB Access Log dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.44.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6561))Fix image link in readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.1                   |
  | **1.44.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5651))Migrate AWS TransitGateway metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.44.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for cloudwatch_logs and ec2_logs datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.1                   |
  | **1.43.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6231))Add documentation for latency parameter                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.8.1                   |
  | **1.43.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6526))Add tags_filter and include_linked_accounts config parameter in missing metric data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.8.1                   |
  | **1.43.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6459))Add include_linked_accounts config parameter for metrics data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.1                   |
  | **1.42.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6421))Add field agent.id to be set as dimension for TSDB migration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.41.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5426))Migrate AWS NATGateway metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.40.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5643))Migrate AWS ELB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5626))Migrate EC2 metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.40.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5650))Add AWS Firewall metrics dashboard input control groups.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                   |
  | **1.40.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6455))Migrate AWS S3 Storage Lens dashboard visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.40.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6368))Migrate Usage Overview dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6374))Migrate AWS CloudTrail dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.40.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6296))Add fields metric type to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.40.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6440))Replace aws.rds.db_instance.identifier with aws.dimensions.DBInstanceIdentifier in RDS dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.40.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6480))Add link to main AWS requirements in all integrations page.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.40.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6319))Add metric type to SNS, SQS and Billing data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.39.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6188))Add AWS API Gateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.38.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6311))Add dimension fields to billing, sns and sqs data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.38.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6339))Add dimension fields to firewall, transit gateway and vpn data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.38.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6365))Add metric type to vpn, firewall and transit gateway data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.38.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6094))Add metric type to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.38.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6079))Add dimensions to RDS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.37.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6353))Fix incorrect fields on multiple visualizations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5640))Migrate AWS RDS metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.37.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5642))Migrate AWS SNS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                   |
  | **1.37.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5644))Migrate AWS SQS metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                   |
  | **1.36.9**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5649))Migrate AWS VPN metrics dashboard to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.8**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6213))Add dimension fields to usage, dynamoDB and ELB data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                   |
  | **1.36.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5973))Add dimension fields to Lambda data stream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                   |
  | **1.36.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6105))Add metric type to natgateway data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.36.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6063))Add metric type to EBS fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                   |
  | **1.36.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5866))Add support for TSDB on kinesis data stream (metric type).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                   |
  | **1.36.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6083))Add dimensions to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                   |
  | **1.36.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6087))Add metric type mapping to Redshift data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                   |
  | **1.36.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6102))Add dimension fields to natgateway data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                   |
  | **1.36.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6045))Add metric type to Lambda fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                   |
  | **1.35.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6213))Fix typo in field name causing erroneous timestamp detection on the s3access data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                   |
  | **1.35.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6161))Add a new flag to enable request tracing on `httpjson` based input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                   |
  | **1.34.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5455))Migrate AWS Lambda metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.6.0                   |
  | **1.34.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5288))Migrate AWS DynamoDB metrics dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.6.0                   |
  | **1.34.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5968))Add field metric type to ECS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.34.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5891))Add dimension fields to Kinesis datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.6.0                   |
  | **1.34.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5895))Add dimension fields to ECS datastream for TSDB support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                   |
  | **1.34.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6062))Add dimensions to EBS data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.33.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5794))Add number_of_workers and latency to all CloudWatch Logs based integrations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.33.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5791))Add missing permissions in the AWS Billing integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                   |
  | **1.33.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5790))Add missing permissions in the AWS CloudWatch Logs integration documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                   |
  | **1.33.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5777))Add latency configuration option on the CloudWatch Logs integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.32.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5646))Fix a minor documentation format issue.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.32.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.6.0                   |
  | **1.32.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5212))Migrate AWS EBS dashboard visualizations to lenses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                   |
  | **1.31.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4915))Add a data stream for Amazon GuardDuty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.6.0                   |
  | **1.30.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5178))Add dashboards data streams filters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.6.0                   |
  | **1.29.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5017))Drop comments from CloudFront loglines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                   |
  | **1.29.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4515))Add data_granularity parameter and rename period title to Collection Period.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.6.0                   |
  | **1.28.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4857))Remove quotes from VPC flow log message field and move dot_expander processor to top                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.28.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Add dot_expander processor to expand all fields with dot into object fields**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4830))Support VPC flow log with message field                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.4.0                   |
  | **1.28.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4794))Adjust kinesis integration to kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.4.0                   |
  | **1.28.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4641))Enhance S3 integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.4.0                   |
  | **1.27.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4676))Support multiple forwarded IPs in cloudfront integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.4.0                   |
  | **1.27.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4703))Update the pagination termination condition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.4.0                   |
  | **1.27.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4596))Added a Summary Dashboard for AWS Security Hub.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.4.0                   |
  | **1.27.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4604))Add Inspector data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.4.0                   |
  | **1.25.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4657))Remove duplicate fields from agent.yml and use ecs.yml for ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.25.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4567/))Update ec2 fields.yml doc                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.3.0                   |
  | **1.25.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4592))Remove duplicate 'content_type' config that causes errors while configurating the integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.3.0                   |
  | **1.25.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4532))Force content type where json content is expected                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4551))Enhance Kinesis integration dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4437))Allow adding multiple processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.24.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4430))Do not rely on dynamodb lightweight module metricset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4395))Fix adding processors in cloudfront logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.3.0                   |
  | **1.24.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4308))Fix billing datastream agent template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.0                   |
  | **1.24.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4281))Fix aws.cloudtrail.request_id parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.24.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4158))Expose Default Region setting to UI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.3.0                   |
  | **1.23.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4103))Set default endpoint to empty string                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.0                   |
  | **1.23.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4083))Fix Billing Dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.0                   |
  | **1.23.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4057))Fix EC2 dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.3.0                   |
  | **1.23.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3907))Update all AWS documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.23.0**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4049))Fix file.path field in cloudtrail data stream to use json.digestS3Object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.1.0                   |
  | **1.22.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4024))Update `cloud.region` parsing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.1.0                   |
  | **1.21.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3553))Add Security Hub Findings and Insights data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.1.0                   |
  | **1.20.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3688))Improve dashboards by removing individual visualizations from library                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.1.0                   |
  | **1.19.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3856))Move ebs metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.19.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3874))Update sample_event.json in kinesis data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.19.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3873))Move NATGateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.19.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3840))Move Transit Gateway metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.19.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3829))Add Kinesis metrics datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.18.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_request metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move s3_daily_storage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SQS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3838))Move SNS metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/3599))Move lambda metrics config from beats to integrations | 8.0.07.15.0             |
  | **1.18.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3860))Release AWS billing integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.18.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3799))Add ECS metricset**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3799))Fix incorrect fields on multiple visualizations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.17.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3851))Release Amazon Redshift integration as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.17.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3844))Fix data_stream.dataset indentation on cloudwatch_logs integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3795))Add missing endpoint config to metrics datasets.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move usage metrics config from beats to integrations**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3764))Move dynamodb metrics config from beats to integrations                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.17.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3682))Improve support for event.original field from upstream forwarders.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3610))Fix misspelling of Log Stream Prefix variable in manifest for aws-cloudwatch input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.15.0             |
  | **1.17.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3569))Added Redshift integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.15.0             |
  | **1.16.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3308))Update documentation with additional context for new users.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.15.0             |
  | **1.16.5**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3474))Move ELB metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3499))Fix ELB dataset to parse URLs with spaces**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3499))Upgrade ECS to 8.2.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.16.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3467))Move RDS metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3357))Move EC2 metrics config from beats to integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.16.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3342))Fix invalid values for ECS fields in vpcflow                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.16.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3305))Move VPN configuration file into integrations and add tag collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.15.0             |
  | **1.15.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Deprecate s3 input in cloudwatch integration**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3304))Improve description for cloudwatch integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.8**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3285))Fix http.response.status_code to accept 000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.0.07.15.0             |
  | **1.14.7**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for rds data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Fix aws.dimensions.* for sns data stream**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3253))Add aws.dimensions.* for dynamodb data stream                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.6**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3240))Improve s3 integration tile title and description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.14.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3226))Fix duplicate titles for integrations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.14.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3192))Fix cloudfront integration grok pattern                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.14.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2912))Add new pattern to VPC Flow logs including all 29 v5 fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **1.14.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2946))Fix billing dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.14.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2790))Add configuration for max_number_of_messages to the aws.firewall_logs S3 input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.13.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2838))Fix metricbeat- reference in dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.13.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2767))Compress dashboard screenshots.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0             |
  | **1.12.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflicts in the elb_logs data stream relating to ECS fields (`trace.id`, `source.port`, and a few others).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.12.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2476))Add CloudFront Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.4**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2470))Add Ingest Pipeline script to map IANA Protocol Numbers                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **1.11.3**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2642))Changing missing ecs versions to 8.0.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.2**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2560))Add data_stream.dataset option for custom aws-cloudwatch log input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.11.1**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2635))Update permission list                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.11.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2478))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.15.0             |
  | **1.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2536))Change cloudwatch metrics and logs default to false                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.15.0             |
  | **1.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2530))Add description of supported vpcflow formats                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                         |
  | **1.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2323))Add cloudwatch input into AWS package for log collection                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2341))Add Route 53 Resolver Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.15.0             |
  | **1.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2316))Add Route 53 Public Zone Logs Datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.7.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **1.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2199))Add integration for AWS Network Firewall                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **1.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                         |
  | **1.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2325))Fix the value of event.created in CloudTrail data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2299))Add max_number_of_messages config option to AWS S3 input config.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **1.5.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2282))Add missing sample events                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.15.0             |
  | **1.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2206))Support Kibana 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.15.0             |
  | **1.4.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2153))Add Overview dashboard for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 7.15.0                  |
  | **1.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2142))Add integration for AWS S3 Storage Lens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2003))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **1.3.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1917))Add config parameter descriptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **1.3.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1886))Add WAF datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **1.2.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1871))Prevent pipeline script error                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1797))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **1.2.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1687))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **1.1.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1772))vpcflow sync with filebeat fileset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 7.14.0                  |
  | **1.0.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1623))Release AWS as GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 7.14.0                  |
  | **0.10.7**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1648))Add proxy config                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.10.6**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1606))Fix aws.billing.EstimatedCharges field name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.10.5**           | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1590))Add event.created field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.10.4**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1449))Improve RDS dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.10.3**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1465))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.10.2**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1371))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                         |
  | **0.10.1**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.10.0**           | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                         |
  | **0.9.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1357))Fix categories for each policy template                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.9.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1334))Add linked account information into billing metricset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.9.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1333))Fix `aws.s3access` pipeline when remote IP is a `-`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                         |
  | **0.9.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1320))Change default credential options to access keys                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.8.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1245))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                         |
  | **0.7.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/767))Introduce granularity using input_groups                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.6.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1147))Add support for Splunk authorization tokens                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.6.3**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1201))Fix bug in Third Party ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.6.2**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1212))Removed incorrect `http.request.referrer` field from elb logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.6.1**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1079))Add support for CloudTrail Digest & Insight logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                         |
  | **0.6.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1070))Update ECS version, add event.original and preparing for package GA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.6**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1000))Fix stack compatability                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                         |
  | **0.5.5**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/979))Allow role_arn work with access keys for AWS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                         |
  | **0.5.4**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/631))Rename s3 input to aws-s3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing "geo" fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                         |
  | **0.5.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/834))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                         |
  | **0.5.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/791))Ignore missing "json" field in ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                         |
  | **0.5.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/782))Moving edge processors to ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                         |
  | **0.4.2**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.1**            | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                         |
  | **0.4.0**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/721))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                         |
  | **0.0.3**            | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/21))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                         |
</dropdown>