﻿---
title: Atlassian Jira Integration
description: The Jira integration collects audit logs from the audit log files or the audit API. When setting up the Atlassian Jira Integration for Atlassian Cloud...
url: https://www.elastic.co/docs/reference/integrations/atlassian_jira
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Atlassian Jira Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.31.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | API, File                       |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

The Jira integration collects audit logs from the audit log files or the [audit API](https://confluence.atlassian.com/jiracore/audit-log-improvements-for-developers-1019401815.html).

## Authentication Set-Up

When setting up the Atlassian Jira Integration for Atlassian Cloud you will need to use the "Jira User Identifier" and "Jira API Token" fields in the integration configuration. These will allow connection to the [Atlassian Cloud REST API](https://developer.atlassian.com/cloud/jira/platform/basic-auth-for-rest-apis/) via [Basic Authentication](https://developer.atlassian.com/server/jira/platform/basic-authentication/).
If you are using a self-hosted instance, you will be able to use either the "Jira User Identifier" and "Jira API Token" fields above, *or* use the "Personal Access Token" field to [authenticate with a PAT](https://confluence.atlassian.com/enterprise/using-personal-access-tokens-1026032365.html). If the "Personal Access Token" field is set in the configuration, it will take precedence over the User ID/API Token fields.

## Logs


### Audit

The Jira integration collects audit logs from the audit log files or the audit API from self hosted Jira Data Center. It has been tested with Jira 8.20.2 but is expected to work with newer versions.  As of version 1.2.0, this integration added experimental support for Atlassian JIRA Cloud.  JIRA Cloud only supports Basic Auth using username and a Personal Access Token.
<dropdown title="Exported fields">
  | Field                            | Description                      | Type             |
  |----------------------------------|----------------------------------|------------------|
  | @timestamp                       | Event timestamp.                 | date             |
  | cloud.image.id                   | Image ID for the cloud instance. | keyword          |
  | data_stream.dataset              | Data stream dataset.             | constant_keyword |
  | data_stream.namespace            | Data stream namespace.           | constant_keyword |
  | data_stream.type                 | Data stream type.                | constant_keyword |
  | event.dataset                    | Event dataset                    | constant_keyword |
  | event.module                     | Event module                     | constant_keyword |
  | host.containerized               | If the host is a container.      | boolean          |
  | host.os.build                    | OS build information.            | keyword          |
  | host.os.codename                 | OS codename, if any.             | keyword          |
  | input.type                       | Input type                       | keyword          |
  | jira.audit.additional_source_ips | List of IP address               | ip               |
  | jira.audit.affected_objects      | Affected Objects                 | flattened        |
  | jira.audit.changed_values        | Changed Values                   | flattened        |
  | jira.audit.extra_attributes      | Extra Attributes                 | flattened        |
  | jira.audit.method                | Method                           | keyword          |
  | jira.audit.type.action           | Action                           | keyword          |
  | jira.audit.type.actionI18nKey    | actionI18nKey                    | keyword          |
  | jira.audit.type.area             | Area                             | keyword          |
  | jira.audit.type.category         | Category                         | keyword          |
  | jira.audit.type.categoryI18nKey  | categoryI18nKey                  | keyword          |
  | jira.audit.type.level            | Audit Level                      | keyword          |
  | log.offset                       | Log offset                       | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-11-22T00:05:08.514Z",
      "agent": {
          "ephemeral_id": "83a814ad-eee1-4f9d-b854-e39fd5e1472e",
          "id": "c57be62c-8f34-45aa-b639-58f4f8de312a",
          "name": "elastic-agent-44957",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "atlassian_jira.audit",
          "namespace": "61685",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "c57be62c-8f34-45aa-b639-58f4f8de312a",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "jira.auditing.group.created",
          "agent_id_status": "verified",
          "category": [
              "iam"
          ],
          "dataset": "atlassian_jira.audit",
          "ingested": "2025-12-17T10:23:22Z",
          "kind": "event",
          "original": "{\"affectedObjects\":[{\"name\":\"jira-software-users\",\"type\":\"GROUP\"}],\"auditType\":{\"action\":\"Group created\",\"actionI18nKey\":\"jira.auditing.group.created\",\"area\":\"USER_MANAGEMENT\",\"category\":\"group management\",\"categoryI18nKey\":\"jira.auditing.category.groupmanagement\",\"level\":\"BASE\"},\"author\":{\"id\":\"-2\",\"name\":\"Anonymous\",\"type\":\"user\"},\"changedValues\":[],\"extraAttributes\":[],\"method\":\"Browser\",\"source\":\"10.50.33.72\",\"system\":\"http://jira.internal:8088\",\"timestamp\":{\"epochSecond\":1637539508,\"nano\":514000000},\"version\":\"1.0\"}",
          "type": [
              "group",
              "creation"
          ]
      },
      "group": {
          "name": "jira-software-users"
      },
      "host": {
          "architecture": "aarch64",
          "containerized": false,
          "hostname": "elastic-agent-44957",
          "ip": [
              "172.19.0.2",
              "172.18.0.4"
          ],
          "mac": [
              "6A-DA-3D-D5-D0-6F",
              "82-F3-70-C9-7C-F6"
          ],
          "name": "elastic-agent-44957",
          "os": {
              "kernel": "6.12.54-linuxkit",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "input": {
          "type": "log"
      },
      "jira": {
          "audit": {
              "affected_objects": [
                  {
                      "name": "jira-software-users",
                      "type": "GROUP"
                  }
              ],
              "method": "Browser",
              "type": {
                  "action": "Group created",
                  "actionI18nKey": "jira.auditing.group.created",
                  "area": "USER_MANAGEMENT",
                  "category": "group management",
                  "categoryI18nKey": "jira.auditing.category.groupmanagement",
                  "level": "BASE"
              }
          }
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/test-audit.log"
          },
          "offset": 0
      },
      "related": {
          "hosts": [
              "jira.internal"
          ],
          "ip": [
              "10.50.33.72"
          ],
          "user": [
              "Anonymous"
          ]
      },
      "service": {
          "address": "http://jira.internal:8088"
      },
      "source": {
          "address": "10.50.33.72",
          "ip": "10.50.33.72"
      },
      "tags": [
          "preserve_original_event",
          "jira-audit"
      ],
      "user": {
          "id": "-2",
          "name": "Anonymous"
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16596))Prevent updating fleet health status to degraded when pagination completes.                                                                                              | 9.1.49.0.78.19.4       |
  | **1.30.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13784))Expected timestamp layout added in cursor logic.                                                                                                                             | 9.0.08.13.0            |
  | **1.30.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13665))Update cursor logic to remove duplicate events.                                                                                                                              | 9.0.08.13.0            |
  | **1.30.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13073))Handle multiple IP address.                                                                                                                                                  | 9.0.08.13.0            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12977))Improve error reporting.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12977))Handle empty string values more robustly.                   | 9.0.08.13.0            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **1.28.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.13.0                 |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **1.27.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10417))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                      | 8.12.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.23.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.7.1                  |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7922))Add stop condition for Jira Cloud pagination.                                                                                                                                 | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7759))Ensure from/to timestamps are properly encoded.                                                                                                                               | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7369))Add ability to set condition for logfile logs.                                                                                                                            | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4713))Fix handling of messages with no events.                                                                                                                                      | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3693))Clarify basic authentication config options.                                                                                                                                  | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3841))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2715))Add support for Atlassian JIRA Cloud                                                                                                                                      | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                         | 8.0.07.16.0            |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3063))Update Readme                                                                                                                                                             | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2379))Update to ECS 8.0                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2203))Initial draft of the package                                                                                                                                              | 8.0.07.16.0            |
</dropdown>