﻿---
title: Atlassian Confluence Integration
description: The Confluence integration collects audit logs from the audit log files or the audit API. When setting up the Atlassian Confluence Integration for Atlassian...
url: https://www.elastic.co/docs/reference/integrations/atlassian_confluence
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Atlassian Confluence Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.30.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | API, File                       |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

The Confluence integration collects [audit logs](https://confluence.atlassian.com/doc/auditing-in-confluence-829076528.html) from the audit log files or the [audit API](https://developer.atlassian.com/cloud/confluence/rest/api-group-audit/).

## Authentication Set-Up

When setting up the Atlassian Confluence Integration for Atlassian Cloud you will need to use the "Confluence User Identifier" and "Confluence API Token" fields in the integration configuration. These will allow connection to the [Atlassian Cloud REST API](https://developer.atlassian.com/cloud/confluence/basic-auth-for-rest-apis/).
If you are using a self-hosted instance, you will be able to use either the "Confluence User Identifier" and "Confluence API Token" fields above, *or* use the "Personal Access Token" field to [authenticate with a PAT](https://confluence.atlassian.com/enterprise/using-personal-access-tokens-1026032365.html). If the "Personal Access Token" field is set in the configuration, it will take precedence over the User ID/API Token fields.

## Logs


### Audit

The Confluence integration collects audit logs from the audit log files or the audit API from self hosted Confluence Data Center. It has been tested with Confluence 7.14.2 but is expected to work with newer versions. As of version 1.2.0, this integration added experimental support for Atlassian Confluence Cloud.  JIRA Cloud only supports Basic Auth using username and a Personal Access Token.
<dropdown title="Exported fields">
  | Field                                  | Description                                       | Type             |
  |----------------------------------------|---------------------------------------------------|------------------|
  | @timestamp                             | Event timestamp.                                  | date             |
  | cloud.image.id                         | Image ID for the cloud instance.                  | keyword          |
  | confluence.audit.affected_objects      | Affected Objects                                  | flattened        |
  | confluence.audit.changed_values        | Changed Values                                    | flattened        |
  | confluence.audit.external_collaborator | Whether the user is an external collaborator user | boolean          |
  | confluence.audit.extra_attributes      | Extra Attributes                                  | flattened        |
  | confluence.audit.method                | Method                                            | keyword          |
  | confluence.audit.type.action           | Action                                            | keyword          |
  | confluence.audit.type.actionI18nKey    | actionI18nKey                                     | keyword          |
  | confluence.audit.type.area             | Area                                              | keyword          |
  | confluence.audit.type.category         | Category                                          | keyword          |
  | confluence.audit.type.categoryI18nKey  | categoryI18nKey                                   | keyword          |
  | confluence.audit.type.level            | Audit Level                                       | keyword          |
  | data_stream.dataset                    | Data stream dataset.                              | constant_keyword |
  | data_stream.namespace                  | Data stream namespace.                            | constant_keyword |
  | data_stream.type                       | Data stream type.                                 | constant_keyword |
  | event.dataset                          | Event dataset                                     | constant_keyword |
  | event.module                           | Event module                                      | constant_keyword |
  | host.containerized                     | If the host is a container.                       | boolean          |
  | host.os.build                          | OS build information.                             | keyword          |
  | host.os.codename                       | OS codename, if any.                              | keyword          |
  | input.type                             | Input type                                        | keyword          |
  | log.offset                             | Log offset                                        | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-11-22T23:44:13.873Z",
      "agent": {
          "ephemeral_id": "5de25f34-0a0a-44ab-b6cf-ddf6d3e10467",
          "id": "8c63ae6c-a626-40b8-9a24-b90a9bfde848",
          "name": "elastic-agent-92724",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "confluence": {
          "audit": {
              "extra_attributes": [
                  {
                      "name": "Query",
                      "nameI18nKey": "atlassian.audit.event.attribute.query"
                  },
                  {
                      "name": "Results returned",
                      "nameI18nKey": "atlassian.audit.event.attribute.results",
                      "value": "57"
                  },
                  {
                      "name": "ID Range",
                      "nameI18nKey": "atlassian.audit.event.attribute.id",
                      "value": "1 - 57"
                  },
                  {
                      "name": "Timestamp Range",
                      "nameI18nKey": "atlassian.audit.event.attribute.timestamp",
                      "value": "2021-11-22T23:42:45.791Z - 2021-11-22T23:43:22.615Z"
                  }
              ],
              "method": "Browser",
              "type": {
                  "action": "Audit Log search performed",
                  "actionI18nKey": "atlassian.audit.event.action.audit.search",
                  "area": "AUDIT_LOG",
                  "category": "Auditing",
                  "categoryI18nKey": "atlassian.audit.event.category.audit",
                  "level": "BASE"
              }
          }
      },
      "data_stream": {
          "dataset": "atlassian_confluence.audit",
          "namespace": "95121",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8c63ae6c-a626-40b8-9a24-b90a9bfde848",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "atlassian.audit.event.action.audit.search",
          "agent_id_status": "verified",
          "dataset": "atlassian_confluence.audit",
          "ingested": "2025-12-17T10:43:52Z",
          "kind": "event",
          "original": "{\"affectedObjects\":[],\"auditType\":{\"action\":\"Audit Log search performed\",\"actionI18nKey\":\"atlassian.audit.event.action.audit.search\",\"area\":\"AUDIT_LOG\",\"category\":\"Auditing\",\"categoryI18nKey\":\"atlassian.audit.event.category.audit\",\"level\":\"BASE\"},\"author\":{\"id\":\"2c9580827d4a06e8017d4a07c3e10000\",\"name\":\"test.user\",\"type\":\"user\"},\"changedValues\":[],\"extraAttributes\":[{\"name\":\"Query\",\"nameI18nKey\":\"atlassian.audit.event.attribute.query\",\"value\":\"\"},{\"name\":\"Results returned\",\"nameI18nKey\":\"atlassian.audit.event.attribute.results\",\"value\":\"57\"},{\"name\":\"ID Range\",\"nameI18nKey\":\"atlassian.audit.event.attribute.id\",\"value\":\"1 - 57\"},{\"name\":\"Timestamp Range\",\"nameI18nKey\":\"atlassian.audit.event.attribute.timestamp\",\"value\":\"2021-11-22T23:42:45.791Z - 2021-11-22T23:43:22.615Z\"}],\"method\":\"Browser\",\"source\":\"81.2.69.143\",\"system\":\"http://confluence.internal:8090\",\"timestamp\":{\"epochSecond\":1637624653,\"nano\":873000000},\"version\":\"1.0\"}",
          "type": [
              "info"
          ]
      },
      "host": {
          "architecture": "aarch64",
          "containerized": false,
          "hostname": "elastic-agent-92724",
          "ip": [
              "172.19.0.2",
              "172.18.0.4"
          ],
          "mac": [
              "52-B9-17-2C-21-10",
              "72-59-40-DC-CA-4F"
          ],
          "name": "elastic-agent-92724",
          "os": {
              "kernel": "6.12.54-linuxkit",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "input": {
          "type": "log"
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/test-audit.log"
          },
          "offset": 0
      },
      "related": {
          "hosts": [
              "confluence.internal"
          ],
          "ip": [
              "81.2.69.143"
          ]
      },
      "service": {
          "address": "http://confluence.internal:8090"
      },
      "source": {
          "address": "81.2.69.143",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "ip": "81.2.69.143"
      },
      "tags": [
          "preserve_original_event",
          "confluence-audit"
      ],
      "user": {
          "full_name": "test.user",
          "id": "2c9580827d4a06e8017d4a07c3e10000"
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16598))Prevent updating fleet health status to degraded when pagination completes.                                                                                              | 9.1.49.0.78.19.4       |
  | **1.29.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13784))Expected timestamp layout added in cursor logic.                                                                                                                             | 9.0.08.13.0            |
  | **1.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13665))Update cursor logic to remove duplicate events.                                                                                                                              | 9.0.08.13.0            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12977))Improve error reporting.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12977))Handle empty string values more robustly.                   | 9.0.08.13.0            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.13.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10417))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.23.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8406))Resolve possible infinite pagination for Confluence Cloud.                                                                                                                    | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.16.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7802))Ensure pagination request timestamps are properly encoded.                                                                                                                    | 8.7.1                  |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7647))Fixed cursor timestamp handling.                                                                                                                                              | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7370))Add ability to set condition for logfile logs.                                                                                                                            | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4713))Fix handling of messages with no events.                                                                                                                                      | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3693))Clarify basic authentication config options.                                                                                                                                  | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3841))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2715))Add support for Atlassian Confluence Cloud                                                                                                                                | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                         |                        |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3062))Update readme                                                                                                                                                             | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2378))Update to ECS 8.0                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2208))Initial draft of the package                                                                                                                                              |                        |
</dropdown>