﻿---
title: Atlassian Bitbucket Integration
description: The Bitbucket integration collects audit logs from the audit log files or the audit API. For more information on auditing in Bitbucket and how it can...
url: https://www.elastic.co/docs/reference/integrations/atlassian_bitbucket
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Atlassian Bitbucket Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | API, File                      |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4               |

The Bitbucket integration collects audit logs from the audit log files or the [audit API](https://developer.atlassian.com/server/bitbucket/reference/rest-api/).
For more information on auditing in Bitbucket and how it can be configured, see [View and configure the audit log](https://confluence.atlassian.com/bitbucketserver/view-and-configure-the-audit-log-776640417.html) on Atlassian's website.

## Logs


### Audit

The Bitbucket integration collects audit logs from the audit log files or the audit API from self hosted Bitbucket Data Center. It has been tested with Bitbucket 7.18.1 but is expected to work with newer versions.  This has not been tested with Bitbucket Cloud and is not expected to work.
<dropdown title="Exported fields">
  | Field                                | Description                      | Type             |
  |--------------------------------------|----------------------------------|------------------|
  | @timestamp                           | Event timestamp.                 | date             |
  | bitbucket.audit.affected_objects     | Affected Objects                 | flattened        |
  | bitbucket.audit.changed_values       | Changed Values                   | flattened        |
  | bitbucket.audit.extra_attributes     | Extra Attributes                 | flattened        |
  | bitbucket.audit.method               | Method                           | keyword          |
  | bitbucket.audit.type.action          | Action                           | keyword          |
  | bitbucket.audit.type.actionI18nKey   | actionI18nKey                    | keyword          |
  | bitbucket.audit.type.area            | Area                             | keyword          |
  | bitbucket.audit.type.category        | Category                         | keyword          |
  | bitbucket.audit.type.categoryI18nKey | categoryI18nKey                  | keyword          |
  | bitbucket.audit.type.level           | Audit Level                      | keyword          |
  | cloud.image.id                       | Image ID for the cloud instance. | keyword          |
  | data_stream.dataset                  | Data stream dataset.             | constant_keyword |
  | data_stream.namespace                | Data stream namespace.           | constant_keyword |
  | data_stream.type                     | Data stream type.                | constant_keyword |
  | event.dataset                        | Event dataset                    | constant_keyword |
  | event.module                         | Event module                     | constant_keyword |
  | host.containerized                   | If the host is a container.      | boolean          |
  | host.os.build                        | OS build information.            | keyword          |
  | host.os.codename                     | OS codename, if any.             | keyword          |
  | input.type                           | Input type                       | keyword          |
  | log.offset                           | Log offset                       | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-11-27T18:13:19.888Z",
      "agent": {
          "ephemeral_id": "949c3cd9-59d0-4214-bd94-b4388d99ca39",
          "id": "111e6217-e5c2-49d6-88df-a1a2f716685b",
          "name": "elastic-agent-45713",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "bitbucket": {
          "audit": {
              "affected_objects": [
                  {
                      "id": "3",
                      "name": "AT",
                      "type": "PROJECT"
                  }
              ],
              "extra_attributes": [
                  {
                      "name": "target",
                      "nameI18nKey": "bitbucket.audit.attribute.legacy.target",
                      "value": "AT"
                  }
              ],
              "method": "Browser",
              "type": {
                  "action": "Project deletion requested",
                  "actionI18nKey": "bitbucket.service.project.audit.action.projectdeletionrequested",
                  "area": "LOCAL_CONFIG_AND_ADMINISTRATION",
                  "category": "Projects",
                  "categoryI18nKey": "bitbucket.service.audit.category.projects",
                  "level": "BASE"
              }
          }
      },
      "data_stream": {
          "dataset": "atlassian_bitbucket.audit",
          "namespace": "68281",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "111e6217-e5c2-49d6-88df-a1a2f716685b",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "bitbucket.service.project.audit.action.projectdeletionrequested",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "dataset": "atlassian_bitbucket.audit",
          "ingested": "2025-10-05T12:01:16Z",
          "kind": "event",
          "original": "{\"affectedObjects\":[{\"id\":\"3\",\"name\":\"AT\",\"type\":\"PROJECT\"}],\"auditType\":{\"action\":\"Project deletion requested\",\"actionI18nKey\":\"bitbucket.service.project.audit.action.projectdeletionrequested\",\"area\":\"LOCAL_CONFIG_AND_ADMINISTRATION\",\"category\":\"Projects\",\"categoryI18nKey\":\"bitbucket.service.audit.category.projects\",\"level\":\"BASE\"},\"author\":{\"id\":\"2\",\"name\":\"admin\",\"type\":\"NORMAL\"},\"changedValues\":[],\"extraAttributes\":[{\"name\":\"target\",\"nameI18nKey\":\"bitbucket.audit.attribute.legacy.target\",\"value\":\"AT\"}],\"method\":\"Browser\",\"node\":\"8767044c-1b98-4d64-82db-ef29af8c3792\",\"source\":\"10.100.100.2\",\"system\":\"http://bitbucket.internal:7990\",\"timestamp\":{\"epochSecond\":1638036799,\"nano\":888000000},\"version\":\"1.0\"}",
          "type": [
              "deletion"
          ]
      },
      "host": {
          "architecture": "x86_64",
          "containerized": false,
          "hostname": "elastic-agent-45713",
          "ip": [
              "192.168.244.2",
              "192.168.240.8"
          ],
          "mac": [
              "82-A2-D4-5B-A7-85",
              "9E-8C-8A-A2-0F-DB"
          ],
          "name": "elastic-agent-45713",
          "os": {
              "kernel": "5.15.0-156-generic",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "input": {
          "type": "log"
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/test-audit.log"
          },
          "offset": 0
      },
      "related": {
          "hosts": [
              "bitbucket.internal"
          ],
          "ip": [
              "10.100.100.2"
          ],
          "user": [
              "admin"
          ]
      },
      "service": {
          "address": "http://bitbucket.internal:7990"
      },
      "source": {
          "address": "10.100.100.2",
          "ip": "10.100.100.2"
      },
      "tags": [
          "preserve_original_event",
          "bitbucket-audit"
      ],
      "user": {
          "id": "2",
          "name": "admin"
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15584))Prevent updating fleet health status to degraded.                                                                                                                        | 9.1.49.0.78.19.4       |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12977))Improve error reporting.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12977))Handle empty string values more robustly.                   | 9.0.08.13.0            |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.13.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **2.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10417))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `event.type` field conform to ECS field definition.                                                                                                                 | 8.12.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.22.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7371))Add ability to set condition for logfile logs.                                                                                                                            | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4713))Fix handling of messages with no events.                                                                                                                                      | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3841))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                        | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3579))Add correct field mapping for event.created                                                                                                                                   |                        |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3061))Update Readme                                                                                                                                                             | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                         |                        |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2376))Update to ECS 8.0                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2281))Initial draft of the package                                                                                                                                              | 8.0.07.16.0            |
</dropdown>