﻿---
title: APM integration
description: Elastic APM is an application performance monitoring system built on the Elastic Stack. It allows you to monitor software services and applications in...
url: https://www.elastic.co/docs/reference/integrations/apm
products:
  - Elastic integrations
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# APM integration
Elastic APM is an application performance monitoring system built on the Elastic Stack. It allows you to monitor software services and applications in real-time, by collecting detailed performance information on response time for incoming requests, database queries, calls to caches, external HTTP requests, and more.
<note applies-to="Elastic Cloud Serverless: Generally available">
  Do not use the APM integration with Serverless projects. Instead use the [Managed OTLP Endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) (recommended) or the managed intake service.
</note>


## Resources

- Ready to jump in? Read the [Get started with traces and APM](https://www.elastic.co/docs/solutions/observability/apm/get-started).
- The APM integration enables central management of APM Server with Fleet.
  To learn more, see [Fleet-managed APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/fleet-managed).
- APM events are indexed into data streams.
  For more information, refer to [APM data streams](https://www.elastic.co/docs/solutions/observability/apm/data-streams).