﻿---
title: Integrations quick reference
description: 
url: https://www.elastic.co/docs/reference/integrations/all_integrations
products:
  - Elastic integrations
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Integrations quick reference
| Integration                                                                                                                           | Description                                                                                                                                                                                                                                                                                       | Release status                  | Version | Minimum Kibana version       |
|---------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------|---------|------------------------------|
| [1Password](https://www.elastic.co/docs/reference/integrations/1password)                                                             | Collect logs from 1Password with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.34.0  | 9.0.78.19.4                  |
| [Abnormal AI](https://www.elastic.co/docs/reference/integrations/abnormal_security)                                                   | Collect logs from Abnormal AI with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 1.12.0  | 9.1.08.19.0                  |
| [abuse.ch](https://www.elastic.co/docs/reference/integrations/ti_abusech)                                                             | Ingest threat intelligence indicators from URL Haus, Malware Bazaar, and Threat Fox feeds with Elastic Agent.                                                                                                                                                                                     | GA                              | 3.5.0   | 9.1.08.19.0                  |
| [Active Directory Entity Analytics](https://www.elastic.co/docs/reference/integrations/entityanalytics_ad)                            | Collect User Identities from Active Directory Entity with Elastic Agent.                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.17.1  | 9.0.38.19.0                  |
| [ActiveMQ](https://www.elastic.co/docs/reference/integrations/activemq)                                                               | Collect logs and metrics from ActiveMQ instances with Elastic Agent.                                                                                                                                                                                                                              | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [Admin By Request EPM](https://www.elastic.co/docs/reference/integrations/admin_by_request_epm)                                       | Collect logs from Admin By Request EPM with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.1.1   | 9.0.08.15.3                  |
| [Airflow](https://www.elastic.co/docs/reference/integrations/airflow)                                                                 | Airflow Integration.                                                                                                                                                                                                                                                                              | GA                              | 1.0.0   | 9.0.08.13.0                  |
| [Airlock Digital](https://www.elastic.co/docs/reference/integrations/airlock_digital)                                                 | Collect logs from Airlock Digital with Elastic Agent.                                                                                                                                                                                                                                             | <applies-to>: Beta</applies-to> | 0.3.0   | 9.1.08.19.0                  |
| [Akamai](https://www.elastic.co/docs/reference/integrations/akamai)                                                                   | Collect logs from Akamai with Elastic Agent.                                                                                                                                                                                                                                                      | GA                              | 3.1.0   | 9.0.08.18.0                  |
| [AlienVault OTX](https://www.elastic.co/docs/reference/integrations/ti_otx)                                                           | Ingest threat intelligence indicators from AlienVault Open Threat Exchange (OTX) with Elastic Agent.                                                                                                                                                                                              | GA                              | 1.30.0  | 9.1.49.0.78.19.4             |
| [Amazon Bedrock](https://www.elastic.co/docs/reference/integrations/aws_bedrock)                                                      | Collect Amazon Bedrock model invocation logs and runtime metrics with Elastic Agent.                                                                                                                                                                                                              | GA                              | 1.5.1   | 9.0.08.16.5                  |
| [Amazon Bedrock AgentCore](https://www.elastic.co/docs/reference/integrations/aws_bedrock_agentcore)                                  | Collect Amazon Bedrock AgentCore's Agent runtime, Gateway, Identity, Memory, Browser Tools and Code Interpreter metrics and logs using Elastic Agent                                                                                                                                              | <applies-to>: Beta</applies-to> | 0.7.0   | 9.2.18.19.0                  |
| [Amazon CloudFront](https://www.elastic.co/docs/reference/integrations/aws/cloudfront)                                                | Collect Amazon CloudFront logs with Elastic Agent                                                                                                                                                                                                                                                 | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Data Firehose](https://www.elastic.co/docs/reference/integrations/awsfirehose)                                                | Stream logs and metrics from Amazon Data Firehose into Elastic Cloud.                                                                                                                                                                                                                             | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [Amazon DynamoDB](https://www.elastic.co/docs/reference/integrations/aws/dynamodb)                                                    | Collect Amazon DynamoDB metrics with Elastic Agent                                                                                                                                                                                                                                                | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon EBS](https://www.elastic.co/docs/reference/integrations/aws/ebs)                                                              | Collect Amazon Elastic Block Storage metrics with Elastic Agent                                                                                                                                                                                                                                   | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon EC2](https://www.elastic.co/docs/reference/integrations/aws/ec2)                                                              | Collect logs and metrics for Amazon Elastic Compute Cloud service with Elastic Agent                                                                                                                                                                                                              | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon ECS](https://www.elastic.co/docs/reference/integrations/aws/ecs)                                                              | Collect metrics for Amazon Elastic Container Service with Elastic Agent                                                                                                                                                                                                                           | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon EMR](https://www.elastic.co/docs/reference/integrations/aws/emr)                                                              | Collect logs and metrics for Amazon EMR service with Elastic Agent                                                                                                                                                                                                                                | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon GuardDuty](https://www.elastic.co/docs/reference/integrations/aws/guardduty)                                                  | Collect Amazon GuardDuty logs with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Inspector](https://www.elastic.co/docs/reference/integrations/aws/inspector)                                                  | Collect Amazon Inspector Logs with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Kinesis Data Stream](https://www.elastic.co/docs/reference/integrations/aws/kinesis)                                          | Collect Amazon Kinesis Data Stream metrics with Elastic Agent                                                                                                                                                                                                                                     | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Managed Streaming for Apache Kafka (MSK)](https://www.elastic.co/docs/reference/integrations/aws/kafka)                       | Collect Amazon MSK metrics with Elastic Agent                                                                                                                                                                                                                                                     | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon MQ](https://www.elastic.co/docs/reference/integrations/aws_mq)                                                                | Collect Amazon MQ metrics and logs with Elastic Agent                                                                                                                                                                                                                                             | <applies-to>: Beta</applies-to> | 0.11.0  | 9.0.08.16.5                  |
| [Amazon NAT Gateway](https://www.elastic.co/docs/reference/integrations/aws/natgateway)                                               | Collect Amazon NAT Gateways metrics with Elastic Agent                                                                                                                                                                                                                                            | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon RDS](https://www.elastic.co/docs/reference/integrations/aws/rds)                                                              | Collect Amazon Relational Database Service metrics with Elastic Agent                                                                                                                                                                                                                             | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Redshift](https://www.elastic.co/docs/reference/integrations/aws/redshift)                                                    | Collect Amazon Redshift metrics with Elastic Agent                                                                                                                                                                                                                                                | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon S3](https://www.elastic.co/docs/reference/integrations/aws/s3)                                                                | Monitor Amazon S3 buckets by collecting access logs, storage & request metrics with Elastic Agent                                                                                                                                                                                                 | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon S3 Storage Lens](https://www.elastic.co/docs/reference/integrations/aws/s3_storage_lens)                                      | Collect Amazon S3 Storage Lens metrics with Elastic Agent                                                                                                                                                                                                                                         | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon Security Lake](https://www.elastic.co/docs/reference/integrations/amazon_security_lake)                                       | Collect logs from Amazon Security Lake with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 2.8.1   | 9.0.08.16.5                  |
| [Amazon SNS](https://www.elastic.co/docs/reference/integrations/aws/sns)                                                              | Collect Amazon SNS metrics with Elastic Agent                                                                                                                                                                                                                                                     | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon SQS](https://www.elastic.co/docs/reference/integrations/aws/sqs)                                                              | Collect Amazon SQS metrics with Elastic Agent                                                                                                                                                                                                                                                     | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon VPC](https://www.elastic.co/docs/reference/integrations/aws/vpcflow)                                                          | Collect Amazon VPC flow logs with Elastic Agent                                                                                                                                                                                                                                                   | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Amazon VPN](https://www.elastic.co/docs/reference/integrations/aws/vpn)                                                              | Collect VPN metrics with Elastic Agent                                                                                                                                                                                                                                                            | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [Anomali](https://www.elastic.co/docs/reference/integrations/ti_anomali)                                                              | Ingest threat intelligence indicators from Anomali with Elastic Agent.                                                                                                                                                                                                                            | GA                              | 2.3.1   | 9.0.08.18.0                  |
| [Apache HTTP Server](https://www.elastic.co/docs/reference/integrations/apache)                                                       | Collect logs and metrics from Apache servers with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 3.0.0   | 9.0.08.13.0                  |
| [Apache OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/apache_otel)                                         | Apache status metrics from OpenTelemtry Collector                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [Apache Spark](https://www.elastic.co/docs/reference/integrations/apache_spark)                                                       | Collect metrics from Apache Spark with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 1.5.0   | 9.0.08.13.0                  |
| [Apache Tomcat](https://www.elastic.co/docs/reference/integrations/apache_tomcat)                                                     | Collect and parse logs and metrics from Apache Tomcat servers with Elastic Agent.                                                                                                                                                                                                                 | GA                              | 1.13.0  | 9.0.08.13.0                  |
| [Arista NG Firewall](https://www.elastic.co/docs/reference/integrations/arista_ngfw)                                                  | Collect logs and metrics from Arista NG Firewall.                                                                                                                                                                                                                                                 | GA                              | 1.5.0   | 9.0.08.11.0                  |
| [Armis](https://www.elastic.co/docs/reference/integrations/armis)                                                                     | Collect logs from Armis with Elastic Agent.                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.4.1   | 9.0.08.18.0                  |
| [Atlassian Bitbucket](https://www.elastic.co/docs/reference/integrations/atlassian_bitbucket)                                         | Collect logs from Atlassian Bitbucket with Elastic Agent.                                                                                                                                                                                                                                         | GA                              | 2.6.0   | 9.1.49.0.78.19.4             |
| [Atlassian Confluence](https://www.elastic.co/docs/reference/integrations/atlassian_confluence)                                       | Collect logs from Atlassian Confluence with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.30.0  | 9.1.49.0.78.19.4             |
| [Atlassian Jira](https://www.elastic.co/docs/reference/integrations/atlassian_jira)                                                   | Collect logs from Atlassian Jira with Elastic Agent.                                                                                                                                                                                                                                              | GA                              | 1.31.0  | 9.1.49.0.78.19.4             |
| [Auditd Logs](https://www.elastic.co/docs/reference/integrations/auditd)                                                              | Collect logs from Linux audit daemon with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 3.22.1  | 9.0.08.11.0                  |
| [Auditd Manager](https://www.elastic.co/docs/reference/integrations/auditd_manager)                                                   | The Auditd Manager Integration receives audit events from the Linux Audit Framework that is a part of the Linux kernel.                                                                                                                                                                           | GA                              | 1.19.1  | 9.0.08.16.0                  |
| [Auth0](https://www.elastic.co/docs/reference/integrations/auth0)                                                                     | Collect logs from Auth0 with Elastic Agent.                                                                                                                                                                                                                                                       | GA                              | 1.23.0  | 9.0.08.13.0                  |
| [authentik](https://www.elastic.co/docs/reference/integrations/authentik)                                                             | Collect logs from authentik with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.7.0   | 9.0.08.16.0                  |
| [AWS](https://www.elastic.co/docs/reference/integrations/aws)                                                                         | Collect logs and metrics from Amazon Web Services (AWS) with Elastic Agent.                                                                                                                                                                                                                       | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS API Gateway](https://www.elastic.co/docs/reference/integrations/aws/apigateway)                                                  | Collect logs and metrics for AWS API Gateway with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Billing](https://www.elastic.co/docs/reference/integrations/aws/billing)                                                         | Collect billing metrics with Elastic Agent                                                                                                                                                                                                                                                        | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS CloudTrail](https://www.elastic.co/docs/reference/integrations/aws/cloudtrail)                                                   | Collect AWS CloudTrail logs with Elastic Agent                                                                                                                                                                                                                                                    | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS CloudTrail Logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/aws_cloudtrail_otel)                    | AWS CloudTrail Logs OpenTelemetry Assets                                                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [AWS CloudWatch](https://www.elastic.co/docs/reference/integrations/aws/cloudwatch)                                                   | Use this integration to collect logs and metrics from Amazon CloudWatch with Elastic Agent, where no out of the box integration is available.                                                                                                                                                     | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Config](https://www.elastic.co/docs/reference/integrations/aws/config)                                                           | Collect AWS Config Logs with Elastic Agent.                                                                                                                                                                                                                                                       | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Cost and Usage Report (CUR 2.0)](https://www.elastic.co/docs/reference/integrations/aws_billing)                                 | Collect AWS CUR 2.0 billing data from S3 with Elastic Agent.                                                                                                                                                                                                                                      | <applies-to>: Beta</applies-to> | 0.2.1   | 9.0.08.18.0                  |
| [AWS ELB](https://www.elastic.co/docs/reference/integrations/aws/elb)                                                                 | Collect logs and metrics for Amazon Elastic Load Balancing service with Elastic Agent                                                                                                                                                                                                             | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS ELB OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/aws_elb_otel)                                       | AWS ELB logs for OpenTelemetry Collector                                                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.1.1   | 9.2.0                        |
| [AWS Fargate (for ECS clusters)](https://www.elastic.co/docs/reference/integrations/awsfargate)                                       | Collects metrics from containers and tasks running on Amazon ECS clusters with Elastic Agent.                                                                                                                                                                                                     | GA                              | 1.3.0   | 9.0.08.13.0                  |
| [AWS Health](https://www.elastic.co/docs/reference/integrations/aws/awshealth)                                                        | Collect AWS Health metrics with Elastic Agent (experimental)                                                                                                                                                                                                                                      | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Lambda](https://www.elastic.co/docs/reference/integrations/aws/lambda)                                                           | Collect Lambda metrics and logs with Elastic Agent                                                                                                                                                                                                                                                | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Network Firewall](https://www.elastic.co/docs/reference/integrations/aws/firewall)                                               | Collect AWS Network Firewall logs and metrics with Elastic Agent                                                                                                                                                                                                                                  | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Route 53](https://www.elastic.co/docs/reference/integrations/aws/route53)                                                        | Collect AWS Route53 logs with Elastic Agent                                                                                                                                                                                                                                                       | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Security Hub](https://www.elastic.co/docs/reference/integrations/aws_securityhub)                                                | Collect logs from AWS Security Hub with Elastic Agent.                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.1.0   | 9.3.0                        |
| [AWS Security Hub CSPM](https://www.elastic.co/docs/reference/integrations/aws/securityhub)                                           | Collect AWS Security Hub CSPM Logs with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Transit Gateway](https://www.elastic.co/docs/reference/integrations/aws/transitgateway)                                          | Collect AWS Transit Gateways metrics with Elastic Agent                                                                                                                                                                                                                                           | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS Usage](https://www.elastic.co/docs/reference/integrations/aws/usage)                                                             | Collect AWS usage metrics with Elastic Agent                                                                                                                                                                                                                                                      | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS VPC Flow Logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/aws_vpcflow_otel)                         | AWS VPC Flow Logs OpenTelemetry Assets                                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.1.1   | 9.2.0                        |
| [AWS WAF](https://www.elastic.co/docs/reference/integrations/aws/waf)                                                                 | Collect AWS WAF logs with Elastic Agent                                                                                                                                                                                                                                                           | GA                              | 6.1.0   | 9.2.18.19.4                  |
| [AWS WAF Logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/aws_waf_otel)                                  | AWS WAF Logs OpenTelemetry Assets                                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Azure Activity Logs](https://www.elastic.co/docs/reference/integrations/azure/activitylogs)                                          | Azure Activity Logs integration                                                                                                                                                                                                                                                                   | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure App Service](https://www.elastic.co/docs/reference/integrations/azure_app_service)                                             | Collect logs from Azure App Service with Elastic Agent.                                                                                                                                                                                                                                           | GA                              | 1.0.0   | 9.0.08.13.0                  |
| [Azure Application Gateway](https://www.elastic.co/docs/reference/integrations/azure/application_gateway)                             | Collect Azure Application Gateway logs with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Application Insights Metrics](https://www.elastic.co/docs/reference/integrations/azure_application_insights/app_insights)      | Collect application insights metrics from Azure Monitor with Elastic Agent.                                                                                                                                                                                                                       | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [Azure Application Insights Metrics Overview](https://www.elastic.co/docs/reference/integrations/azure_application_insights)          | Collect application insights metrics from Azure Monitor with Elastic Agent.                                                                                                                                                                                                                       | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [Azure Application State Insights Metrics](https://www.elastic.co/docs/reference/integrations/azure_application_insights/app_state)   | Collect application state related metrics from Azure Monitor with Elastic Agent.                                                                                                                                                                                                                  | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [Azure Billing Metrics](https://www.elastic.co/docs/reference/integrations/azure_billing)                                             | Collect billing metrics with Elastic Agent.                                                                                                                                                                                                                                                       | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [Azure Container Instance Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/container_instance)               | Collect metrics from Azure Container Instances with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Container Registry Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/container_registry)               | Collect metrics from Azure Container Registry with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Container Service Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/container_service)                 | Collect metrics from Azure Container Service with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Database Account Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/database_account)                   | Collect metrics from Azure Database accounts with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Event Hub Input](https://www.elastic.co/docs/reference/integrations/azure/eventhub)                                            | Azure Event Hub input integration                                                                                                                                                                                                                                                                 | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Firewall logs](https://www.elastic.co/docs/reference/integrations/azure/firewall_logs)                                         | Azure firewall logs integration                                                                                                                                                                                                                                                                   | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Frontdoor](https://www.elastic.co/docs/reference/integrations/azure_frontdoor)                                                 | This Elastic integration collects logs from Azure Frontdoor.                                                                                                                                                                                                                                      | GA                              | 2.2.2   | 9.0.08.13.0                  |
| [Azure Functions](https://www.elastic.co/docs/reference/integrations/azure_functions)                                                 | Get metrics and logs from Azure Functions                                                                                                                                                                                                                                                         | <applies-to>: Beta</applies-to> | 0.11.0  | 9.0.08.13.0                  |
| [Azure Logs](https://www.elastic.co/docs/reference/integrations/azure)                                                                | This Elastic integration collects logs from Azure                                                                                                                                                                                                                                                 | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Logs (v2 preview)](https://www.elastic.co/docs/reference/integrations/azure/events)                                            | Azure Logs (v2 preview) integration                                                                                                                                                                                                                                                               | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Monitor Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/monitor)                                     | Collect metrics from Azure Monitor with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Network Watcher NSG](https://www.elastic.co/docs/reference/integrations/azure_network_watcher_nsg)                             | Collect logs from Azure Network Watcher NSG with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.5.0   | 9.0.08.16.0                  |
| [Azure Network Watcher VNet](https://www.elastic.co/docs/reference/integrations/azure_network_watcher_vnet)                           | Collect logs from Azure Network Watcher VNet with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.6.0   | 9.0.08.16.0                  |
| [Azure OpenAI](https://www.elastic.co/docs/reference/integrations/azure_openai)                                                       | Collects Azure OpenAI Logs and Metrics                                                                                                                                                                                                                                                            | GA                              | 1.10.1  | 9.2.18.19.0                  |
| [Azure platform logs](https://www.elastic.co/docs/reference/integrations/azure/platformlogs)                                          | Azure platform logs integration                                                                                                                                                                                                                                                                   | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Resource Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics)                                            | Collect metrics from Azure resources with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Spring Apps logs](https://www.elastic.co/docs/reference/integrations/azure/springcloudlogs)                                    | Azure Spring Apps logs integration                                                                                                                                                                                                                                                                | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Azure Storage Account Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/storage_account)                     | Collect metrics from Azure Storage accounts with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Virtual Machines Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/compute_vm)                         | Collect metrics from Azure Virtual Machines with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Azure Virtual Machines Scaleset Metrics](https://www.elastic.co/docs/reference/integrations/azure_metrics/compute_vm_scaleset)       | Collect metrics from Azure Virtual Machine Scalesets with Elastic Agent.                                                                                                                                                                                                                          | GA                              | 1.11.0  | 9.1.59.0.88.19.58.18.8       |
| [Barracuda CloudGen Firewall Logs](https://www.elastic.co/docs/reference/integrations/barracuda_cloudgen_firewall)                    | Collect logs from Barracuda CloudGen Firewall devices with Elastic Agent.                                                                                                                                                                                                                         | GA                              | 1.16.0  | 9.0.08.13.0                  |
| [Barracuda Web Application Firewall](https://www.elastic.co/docs/reference/integrations/barracuda)                                    | Collect logs from Barracuda Web Application Firewall with Elastic Agent.                                                                                                                                                                                                                          | GA                              | 1.18.0  | 9.0.08.13.0                  |
| [BBOT (Bighuge BLS OSINT Tool)](https://www.elastic.co/docs/reference/integrations/bbot)                                              | BBOT is a recursive internet scanner inspired by Spiderfoot, but designed to be faster, more reliable, and friendlier to pentesters, bug bounty hunters, and developers.                                                                                                                          | GA                              | 1.4.0   | 9.0.08.13.0                  |
| [Beat](https://www.elastic.co/docs/reference/integrations/beat)                                                                       | Beat Integration                                                                                                                                                                                                                                                                                  | GA                              | 1.0.1   | 9.0.08.10.2                  |
| [Beelzebub](https://www.elastic.co/docs/reference/integrations/beelzebub)                                                             | Beelzebub is an advanced honeypot framework designed to provide a highly secure environment for detecting and analyzing cyber attacks. It offers a low code approach for easy implementation and uses AI to mimic the behavior of a high-interaction honeypot.                                    | <applies-to>: Beta</applies-to> | 0.4.0   | 9.0.08.17.1                  |
| [BeyondInsight and Password Safe](https://www.elastic.co/docs/reference/integrations/beyondinsight_password_safe)                     | Ingest privileged access management (PAM) data from BeyondTrust's BeyondInsight PAM Reporting Platform and Password Safe, using Elastic Agent.                                                                                                                                                    | <applies-to>: Beta</applies-to> | 0.12.1  | 9.0.08.18.0                  |
| [BeyondTrust PRA](https://www.elastic.co/docs/reference/integrations/beyondtrust_pra)                                                 | Collect logs from BeyondTrust PRA with Elastic Agent.                                                                                                                                                                                                                                             | <applies-to>: Beta</applies-to> | 0.3.2   | 9.0.08.18.0                  |
| [BitDefender](https://www.elastic.co/docs/reference/integrations/bitdefender)                                                         | Ingest BitDefender GravityZone logs and data                                                                                                                                                                                                                                                      | GA                              | 2.7.0   | 9.0.08.18.0                  |
| [Bitsight](https://www.elastic.co/docs/reference/integrations/bitsight)                                                               | Ingest data from the Bitsight API.                                                                                                                                                                                                                                                                | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.17.3                  |
| [Bitwarden](https://www.elastic.co/docs/reference/integrations/bitwarden)                                                             | Collect logs from Bitwarden with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.18.0  | 9.1.49.0.78.19.4             |
| [blacklens.io](https://www.elastic.co/docs/reference/integrations/blacklens)                                                          | Collect logs from blacklens.io with Elastic Agent                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.5.0   | 9.1.49.0.78.19.4             |
| [Box Events](https://www.elastic.co/docs/reference/integrations/box_events)                                                           | Collect logs from Box with Elastic Agent                                                                                                                                                                                                                                                          | GA                              | 3.1.1   | 9.1.49.0.78.19.4             |
| [Bravura Monitor](https://www.elastic.co/docs/reference/integrations/hid_bravura_monitor)                                             | Collect logs from Bravura Security Fabric with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.21.0  | 9.0.08.11.0                  |
| [Broadcom ProxySG](https://www.elastic.co/docs/reference/integrations/proxysg)                                                        | Collect access logs from Broadcom ProxySG with Elastic Agent.                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.7.0   | 9.0.08.13.0                  |
| [Canva](https://www.elastic.co/docs/reference/integrations/canva)                                                                     | Collect logs from Canva with Elastic Agent.                                                                                                                                                                                                                                                       | GA                              | 1.0.0   | 9.0.08.16.5                  |
| [Cassandra](https://www.elastic.co/docs/reference/integrations/cassandra)                                                             | This Elastic integration collects logs and metrics from cassandra.                                                                                                                                                                                                                                | GA                              | 1.20.0  | 9.0.08.13.0                  |
| [Ceph](https://www.elastic.co/docs/reference/integrations/ceph)                                                                       | This Elastic integration collects metrics from Ceph instance.                                                                                                                                                                                                                                     | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [Check Point](https://www.elastic.co/docs/reference/integrations/checkpoint)                                                          | Collect logs from Check Point with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 1.45.2  | 9.0.08.11.0                  |
| [Check Point Harmony Email & Collaboration](https://www.elastic.co/docs/reference/integrations/checkpoint_email)                      | Collect logs from Check Point Harmony Email & Collaboration with Elastic Agent.                                                                                                                                                                                                                   | GA                              | 1.3.0   | 9.0.08.18.0                  |
| [Check Point Harmony Endpoint](https://www.elastic.co/docs/reference/integrations/checkpoint_harmony_endpoint)                        | Collect logs from Check Point Harmony Endpoint                                                                                                                                                                                                                                                    | GA                              | 1.0.1   | 9.0.08.14.0                  |
| [Cilium Tetragon](https://www.elastic.co/docs/reference/integrations/cilium_tetragon)                                                 | Collect Cilium Tetragon logs from Kubernetes environments.                                                                                                                                                                                                                                        | <applies-to>: Beta</applies-to> | 0.3.0   | 9.0.08.13.0                  |
| [CISA Known Exploited Vulnerabilities](https://www.elastic.co/docs/reference/integrations/cisa_kevs)                                  | This package allows the ingest of known exploited vulnerabilities according to the Cybersecurity and Infrastructure Security Agency of the United States of America. This information could be used to enrich or track exisiting vulnerabilities that are known to be exploited in the wild.      | GA                              | 1.7.0   | 9.0.08.13.0                  |
| [Cisco Aironet](https://www.elastic.co/docs/reference/integrations/cisco_aironet)                                                     | Integration for Cisco Aironet WLC Logs                                                                                                                                                                                                                                                            | GA                              | 1.19.0  | 9.0.08.11.0                  |
| [Cisco ASA](https://www.elastic.co/docs/reference/integrations/cisco_asa)                                                             | Collect logs from Cisco ASA with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 2.44.1  | 9.0.08.11.0                  |
| [Cisco Duo](https://www.elastic.co/docs/reference/integrations/cisco_duo)                                                             | Collect logs from Cisco Duo with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 2.8.0   | 9.0.08.18.0                  |
| [Cisco FTD](https://www.elastic.co/docs/reference/integrations/cisco_ftd)                                                             | Collect logs from Cisco FTD with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 3.13.1  | 9.0.08.11.0                  |
| [Cisco IOS](https://www.elastic.co/docs/reference/integrations/cisco_ios)                                                             | Collect logs from Cisco IOS with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.34.0  | 9.0.08.11.0                  |
| [Cisco ISE](https://www.elastic.co/docs/reference/integrations/cisco_ise)                                                             | Collect logs from Cisco ISE with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.31.2  | 9.0.08.11.0                  |
| [Cisco Meraki](https://www.elastic.co/docs/reference/integrations/cisco_meraki)                                                       | Collect logs from Cisco Meraki with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 1.31.0  | 9.0.08.13.0                  |
| [Cisco Meraki Metrics](https://www.elastic.co/docs/reference/integrations/cisco_meraki_metrics)                                       | Collect metrics from Cisco Meraki with Elastic Agent.                                                                                                                                                                                                                                             | <applies-to>: Beta</applies-to> | 0.4.3   | 9.0.08.15.2                  |
| [Cisco Nexus](https://www.elastic.co/docs/reference/integrations/cisco_nexus)                                                         | Collect logs from Cisco Nexus with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 1.5.0   | 9.0.08.11.0                  |
| [Cisco Secure Email Gateway](https://www.elastic.co/docs/reference/integrations/cisco_secure_email_gateway)                           | Collect logs from Cisco Secure Email Gateway with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.28.4  | 9.0.08.11.0                  |
| [Cisco Secure Endpoint](https://www.elastic.co/docs/reference/integrations/cisco_secure_endpoint)                                     | Collect logs from Cisco Secure Endpoint (AMP) with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 2.33.0  | 9.1.49.0.78.19.4             |
| [Cisco Umbrella](https://www.elastic.co/docs/reference/integrations/cisco_umbrella)                                                   | Collect logs from Cisco Umbrella with Elastic Agent.                                                                                                                                                                                                                                              | GA                              | 1.33.0  | 9.0.08.16.5                  |
| [Citrix ADC](https://www.elastic.co/docs/reference/integrations/citrix_adc)                                                           | This Elastic integration collects logs and metrics from Citrix ADC product.                                                                                                                                                                                                                       | GA                              | 1.18.2  | 9.0.08.13.0                  |
| [Citrix Web App Firewall](https://www.elastic.co/docs/reference/integrations/citrix_waf)                                              | Ingest events from Citrix Systems Web App Firewall.                                                                                                                                                                                                                                               | GA                              | 1.19.0  | 9.0.08.11.0                  |
| [Claroty CTD](https://www.elastic.co/docs/reference/integrations/claroty_ctd)                                                         | Collect logs from Claroty CTD using Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 1.1.1   | 9.0.08.16.0                  |
| [Claroty xDome](https://www.elastic.co/docs/reference/integrations/claroty_xdome)                                                     | Collect logs from Claroty xDome with Elastic Agent.                                                                                                                                                                                                                                               | GA                              | 1.0.1   | 9.0.08.18.0                  |
| [Cloud Asset Discovery](https://www.elastic.co/docs/reference/integrations/cloud_asset_inventory)                                     | Discover and Create Cloud Assets Discovery                                                                                                                                                                                                                                                        | GA                              | 1.4.1   | 9.3.0                        |
| [Cloud Native Vulnerability Management (CNVM)](https://www.elastic.co/docs/reference/integrations/cloud_security_posture/vuln_mgmt)   | Scan for cloud workload vulnerabilities                                                                                                                                                                                                                                                           | GA                              | 3.2.1   | 9.3.0                        |
| [Cloud Security Posture Management (CSPM)](https://www.elastic.co/docs/reference/integrations/cloud_security_posture/cspm)            | Identify & remediate configuration risks in the Cloud services you leverage                                                                                                                                                                                                                       | GA                              | 3.2.1   | 9.3.0                        |
| [Cloudflare](https://www.elastic.co/docs/reference/integrations/cloudflare)                                                           | Collect logs from Cloudflare with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 2.32.0  | 9.1.49.0.78.19.4             |
| [Cloudflare Logpush](https://www.elastic.co/docs/reference/integrations/cloudflare_logpush)                                           | Collect and parse logs from Cloudflare API with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.43.2  | 9.0.08.17.1                  |
| [CockroachDB Metrics](https://www.elastic.co/docs/reference/integrations/cockroachdb)                                                 | Collect metrics from CockroachDB servers with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 1.13.1  | 9.0.08.13.0                  |
| [Collective Intelligence Framework v3](https://www.elastic.co/docs/reference/integrations/ti_cif3)                                    | Ingest threat indicators from a Collective Intelligence Framework v3 instance with Elastic Agent.                                                                                                                                                                                                 | GA                              | 1.18.0  | 9.0.08.13.0                  |
| [Common Event Format (CEF)](https://www.elastic.co/docs/reference/integrations/cef)                                                   | Collect logs from CEF Logs with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 2.22.0  | 9.0.08.15.1                  |
| [Containerd](https://www.elastic.co/docs/reference/integrations/containerd)                                                           | Collect metrics from containerd containers.                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.6.0   | 9.0.08.13.0                  |
| [CoreDNS](https://www.elastic.co/docs/reference/integrations/coredns)                                                                 | Collect logs from CoreDNS instances with Elastic Agent.                                                                                                                                                                                                                                           | <applies-to>: Beta</applies-to> | 0.10.0  | 9.0.08.13.0                  |
| [Corelight](https://www.elastic.co/docs/reference/integrations/corelight)                                                             | Collect logs from Corelight with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.0.0   | 9.0.08.16.0                  |
| [Couchbase](https://www.elastic.co/docs/reference/integrations/couchbase)                                                             | Collect metrics from Couchbase databases with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [CouchDB](https://www.elastic.co/docs/reference/integrations/couchdb)                                                                 | Collect metrics from CouchDB with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 1.5.1   | 9.0.08.13.0                  |
| [Cribl](https://www.elastic.co/docs/reference/integrations/cribl)                                                                     | Stream logs from Cribl into Elastic.                                                                                                                                                                                                                                                              | GA                              | 1.0.1   | 9.0.08.13.0                  |
| [CrowdStrike](https://www.elastic.co/docs/reference/integrations/crowdstrike)                                                         | Collect logs from Crowdstrike with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 3.3.0   | 9.0.08.18.0                  |
| [CrowdStrike Falcon Intelligence](https://www.elastic.co/docs/reference/integrations/ti_crowdstrike)                                  | Collect logs from CrowdStrike Falcon Intelligence with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 2.6.1   | 9.0.08.18.0                  |
| [Custom API](https://www.elastic.co/docs/reference/integrations/httpjson)                                                             | Collect custom events from an API endpoint with Elastic agent                                                                                                                                                                                                                                     | GA                              | 1.24.0  | 9.1.49.0.78.19.4             |
| [Custom API using Common Expression Language](https://www.elastic.co/docs/reference/integrations/cel)                                 | Collect custom events from an API with Elastic agent                                                                                                                                                                                                                                              | GA                              | 1.19.0  | 9.1.08.19.0                  |
| [Custom AWS Logs](https://www.elastic.co/docs/reference/integrations/aws_logs)                                                        | Collect raw logs from AWS S3 or CloudWatch with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.8.3   | 9.0.08.16.5                  |
| [Custom Azure Blob Storage Input](https://www.elastic.co/docs/reference/integrations/azure_blob_storage)                              | Collect log data from configured Azure Blob Storage Container with Elastic Agent.                                                                                                                                                                                                                 | GA                              | 2.3.0   | 9.0.08.16.0                  |
| [Custom Azure Logs](https://www.elastic.co/docs/reference/integrations/azure_logs)                                                    | Collect log events from Azure Event Hubs with Elastic Agent                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.5.0   | 9.0.08.15.1                  |
| [Custom GCS (Google Cloud Storage) Input](https://www.elastic.co/docs/reference/integrations/google_cloud_storage)                    | Collect JSON data from configured GCS Bucket with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 2.2.0   | 9.0.08.13.0                  |
| [Custom Google Pub/Sub Logs](https://www.elastic.co/docs/reference/integrations/gcp_pubsub)                                           | Collect Logs from Google Pub/Sub topics                                                                                                                                                                                                                                                           | GA                              | 2.2.1   | 9.0.08.13.0                  |
| [Custom HTTP Endpoint Logs](https://www.elastic.co/docs/reference/integrations/http_endpoint)                                         | Collect JSON data from listening HTTP port with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 2.5.0   | 9.0.08.15.0                  |
| [Custom Journald logs](https://www.elastic.co/docs/reference/integrations/journald)                                                   | Collect logs from journald with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 1.2.1   | 9.0.08.8.0                   |
| [Custom Kafka Logs](https://www.elastic.co/docs/reference/integrations/kafka_log)                                                     | Collect data from kafka topic with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [Custom Logs (Deprecated)](https://www.elastic.co/docs/reference/integrations/log)                                                    | Collect custom logs with Elastic Agent.                                                                                                                                                                                                                                                           | GA                              | 2.4.4   | 9.0.08.8.0                   |
| [Custom Logs (Filestream)](https://www.elastic.co/docs/reference/integrations/filestream)                                             | Collect log data using filestream with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 2.3.2   | 9.2.0                        |
| [Custom macOS Unified Logs](https://www.elastic.co/docs/reference/integrations/unifiedlogs)                                           | Collect and parse logs from macOS unified logs with Elastic Agent.                                                                                                                                                                                                                                | <applies-to>: Beta</applies-to> | 0.4.0   | 9.0.08.18.0                  |
| [Custom TCP Logs](https://www.elastic.co/docs/reference/integrations/tcp)                                                             | Collect raw TCP data from listening TCP port with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 2.1.0   | 9.2.0                        |
| [Custom Threat Intelligence](https://www.elastic.co/docs/reference/integrations/ti_custom)                                            | Ingest threat intelligence data in STIX 2.1 format with Elastic Agent                                                                                                                                                                                                                             | GA                              | 1.3.0   | 9.0.08.16.0                  |
| [Custom UDP Logs](https://www.elastic.co/docs/reference/integrations/udp)                                                             | Collect raw UDP data from listening UDP port with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 2.3.0   | 9.2.0                        |
| [Custom Websocket logs](https://www.elastic.co/docs/reference/integrations/websocket)                                                 | Collect custom events from a socket server with Elastic agent.                                                                                                                                                                                                                                    | GA                              | 1.0.0   | 9.0.08.17.18.16.3            |
| [Custom Windows ETW logs](https://www.elastic.co/docs/reference/integrations/windows_etw)                                             | Collect and parse logs from any Windows ETW provider with Elastic Agent.                                                                                                                                                                                                                          | GA                              | 1.0.0   | 9.0.08.17.0                  |
| [Custom Windows Event Logs](https://www.elastic.co/docs/reference/integrations/winlog)                                                | Collect and parse logs from any Windows event log channel with Elastic Agent.                                                                                                                                                                                                                     | GA                              | 2.4.0   | 9.0.08.10.1                  |
| [Custom WMI Input Package](https://www.elastic.co/docs/reference/integrations/wmi)                                                    | Custom WMI Input Package                                                                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.0.2   | 9.1.08.19.0                  |
| [CyberArk EPM](https://www.elastic.co/docs/reference/integrations/cyberark_epm)                                                       | Collect logs from CyberArk EPM with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 1.3.0   | 9.0.08.16.0                  |
| [CyberArk Privileged Access Security](https://www.elastic.co/docs/reference/integrations/cyberarkpas)                                 | Collect logs from CyberArk Privileged Access Security with Elastic Agent.                                                                                                                                                                                                                         | GA                              | 2.28.0  | 9.0.08.14.0                  |
| [Cyberark Privileged Threat Analytics](https://www.elastic.co/docs/reference/integrations/cyberark_pta)                               | Collect security logs from Cyberark PTA integration.                                                                                                                                                                                                                                              | GA                              | 1.14.0  | 9.0.08.13.0                  |
| [Cybereason](https://www.elastic.co/docs/reference/integrations/cybereason)                                                           | Collect logs from Cybereason with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 1.4.1   | 9.0.08.13.0                  |
| [Cybersixgill](https://www.elastic.co/docs/reference/integrations/ti_cybersixgill)                                                    | Ingest threat intelligence indicators from Cybersixgill with Elastic Agent.                                                                                                                                                                                                                       | GA                              | 1.34.0  | 9.0.08.13.0                  |
| [Cyera](https://www.elastic.co/docs/reference/integrations/cyera)                                                                     | Collect logs from Cyera with Elastic Agent.                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.5.0   | 9.3.09.2.19.1.78.19.7        |
| [CylanceProtect Logs (Deprecated)](https://www.elastic.co/docs/reference/integrations/cylance)                                        | Collect logs from CylanceProtect devices with Elastic Agent.                                                                                                                                                                                                                                      | <applies-to>: Beta</applies-to> | 0.24.0  | 9.0.08.13.0                  |
| [Cyware Intel Exchange](https://www.elastic.co/docs/reference/integrations/ti_cyware_intel_exchange)                                  | Collect logs from Cyware Intel Exchange with Elastic Agent.                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.2.0   | 9.0.08.18.0                  |
| [Darktrace](https://www.elastic.co/docs/reference/integrations/darktrace)                                                             | Collect logs from Darktrace with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 2.0.0   | 9.0.08.13.0                  |
| [Data Exfiltration Detection](https://www.elastic.co/docs/reference/integrations/ded)                                                 | ML package to detect data exfiltration in your network and file data.                                                                                                                                                                                                                             | GA                              | 2.4.1   | 9.0.08.10.1                  |
| [Defend for Containers (BETA)](https://www.elastic.co/docs/reference/integrations/cloud_defend)                                       | Elastic Defend for Containers (BETA) provides cloud-native runtime protections for containerized environments.                                                                                                                                                                                    | GA                              | 1.4.0   | 9.3.08.11.0                  |
| [Digital Guardian](https://www.elastic.co/docs/reference/integrations/digital_guardian)                                               | Collect logs from Digital Guardian with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.7.0   | 9.0.08.16.0                  |
| [Docker](https://www.elastic.co/docs/reference/integrations/docker)                                                                   | Collect metrics and logs from Docker instances with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 2.15.0  | 9.0.08.16.2                  |
| [Docker OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/docker_otel)                                         | Utilise the pre-built dashboard for OTel-native metrics of Docker hosts and their running containers                                                                                                                                                                                              | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [Domain Generation Algorithm Detection](https://www.elastic.co/docs/reference/integrations/dga)                                       | ML solution package to detect domain generation algorithm (DGA) activity in your network data.                                                                                                                                                                                                    | GA                              | 2.3.5   | 9.0.08.9.0                   |
| [DomainTools Feeds](https://www.elastic.co/docs/reference/integrations/ti_domaintools)                                                | DomainTools Feeds provide data on the different stages of the domain lifecycle: from first-observed in the wild, to newly re-activated after a period of quiet.                                                                                                                                   | GA                              | 1.3.0   | 9.0.08.16.0                  |
| [EclecticIQ](https://www.elastic.co/docs/reference/integrations/ti_eclecticiq)                                                        | Ingest threat intelligence from EclecticIQ with Elastic Agent                                                                                                                                                                                                                                     | GA                              | 1.5.0   | 9.0.08.13.0                  |
| [Elastic Agent](https://www.elastic.co/docs/reference/integrations/elastic_agent)                                                     | Collect logs and metrics from Elastic Agents.                                                                                                                                                                                                                                                     | GA                              | 2.7.0   | 9.0.08.15.0                  |
| [Elastic Cloud Enterprise](https://www.elastic.co/docs/reference/integrations/ece)                                                    | This is a helpful integration for all customers using ECE and need to track the events generated within the ECE admin UI or against the ECE API.                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.0.2   | 9.0.08.17.0                  |
| [Elastic Defend](https://www.elastic.co/docs/reference/integrations/endpoint)                                                         | Protect your hosts and cloud workloads with threat prevention, detection, and deep security data visibility.                                                                                                                                                                                      | GA                              | 9.3.0   | 9.3.0                        |
| [Elastic Package Registry](https://www.elastic.co/docs/reference/integrations/elastic_package_registry)                               | Collect metrics from a Elastic Package Registry instance                                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.3.1   | 9.0.08.0.0                   |
| [Elastic Security](https://www.elastic.co/docs/reference/integrations/elastic_security)                                               | Collect logs from Elastic Instance with Elastic Agent.                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.4.0   | 9.1.1                        |
| [Elasticsearch](https://www.elastic.co/docs/reference/integrations/elasticsearch)                                                     | Elasticsearch Integration                                                                                                                                                                                                                                                                         | GA                              | 1.19.1  | 9.0.08.10.1                  |
| [Elasticsearch Service Billing](https://www.elastic.co/docs/reference/integrations/ess_billing)                                       | Collects billing metrics from Elasticsearch Service billing API                                                                                                                                                                                                                                   | GA                              | 1.7.0   | 9.0.08.18.0                  |
| [Endace](https://www.elastic.co/docs/reference/integrations/endace)                                                                   | This Endace integration configures Network Packet Capture for flow generation and adds a pivot field to your Endace platform.                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.2.0   | 9.0.08.13.0                  |
| [Entro](https://www.elastic.co/docs/reference/integrations/entro)                                                                     | Collect logs from Entro with Elastic Agent.                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.1.1   | 9.0.08.18.0                  |
| [Envoyproxy](https://www.elastic.co/docs/reference/integrations/envoyproxy)                                                           | Envoyproxy Integration                                                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.4.0   | 9.0.08.15.0                  |
| [ESET PROTECT](https://www.elastic.co/docs/reference/integrations/eset_protect)                                                       | Collect logs from ESET PROTECT with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 1.12.0  | 9.0.08.16.0                  |
| [ESET Threat Intelligence](https://www.elastic.co/docs/reference/integrations/ti_eset)                                                | Ingest threat intelligence indicators from ESET Threat Intelligence with Elastic Agent.                                                                                                                                                                                                           | GA                              | 1.9.0   | 9.1.49.0.78.19.4             |
| [etcd](https://www.elastic.co/docs/reference/integrations/etcd)                                                                       | Collect metrics from etcd instances with Elastic Agent.                                                                                                                                                                                                                                           | GA                              | 1.4.1   | 9.0.08.13.0                  |
| [ExtraHop](https://www.elastic.co/docs/reference/integrations/extrahop)                                                               | Collect logs from ExtraHop RevealX 360 with Elastic Agent.                                                                                                                                                                                                                                        | <applies-to>: Beta</applies-to> | 0.2.1   | 9.1.29.0.58.19.28.18.5       |
| [F5 BIG-IP](https://www.elastic.co/docs/reference/integrations/f5_bigip)                                                              | Collect logs from F5 BIG-IP with Elastic Agent.                                                                                                                                                                                                                                                   | GA                              | 1.27.1  | 9.0.08.16.5                  |
| [Falco](https://www.elastic.co/docs/reference/integrations/falco)                                                                     | Collect events and alerts from Falco using Elastic Agent                                                                                                                                                                                                                                          | GA                              | 2.0.2   | 9.0.08.13.3                  |
| [File Integrity Monitoring](https://www.elastic.co/docs/reference/integrations/fim)                                                   | The File Integrity Monitoring integration reports filesystem changes in real time.                                                                                                                                                                                                                | GA                              | 1.16.0  | 9.0.08.7.1                   |
| [File Log OpenTelemetry input](https://www.elastic.co/docs/reference/integrations/filelog_otel)                                       | Tails and parses logs from files using the filelog receiver of the OTel collector.                                                                                                                                                                                                                | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [FireEye Network Security](https://www.elastic.co/docs/reference/integrations/fireeye)                                                | Collect logs from FireEye NX with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 1.27.0  | 9.0.08.13.0                  |
| [First EPSS](https://www.elastic.co/docs/reference/integrations/first_epss)                                                           | Collect exploit prediction score data from the First EPSS API with Elastic Agent.                                                                                                                                                                                                                 | GA                              | 1.1.1   | 9.0.08.16.0                  |
| [Fleet Server](https://www.elastic.co/docs/reference/integrations/fleet_server)                                                       | Centrally manage Elastic Agents with the Fleet Server integration.                                                                                                                                                                                                                                | GA                              | 1.6.0   | 9.0.08.12.0                  |
| [Forcepoint Web Security](https://www.elastic.co/docs/reference/integrations/forcepoint_web)                                          | Forcepoint Web Security                                                                                                                                                                                                                                                                           | GA                              | 1.13.0  | 9.0.08.13.0                  |
| [ForgeRock](https://www.elastic.co/docs/reference/integrations/forgerock)                                                             | Collect audit logs from ForgeRock with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 1.22.0  | 9.1.49.0.78.19.4             |
| [Fortinet FortiEDR Logs](https://www.elastic.co/docs/reference/integrations/fortinet_fortiedr)                                        | Collect logs from Fortinet FortiEDR instances with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 1.20.0  | 9.0.08.11.0                  |
| [Fortinet FortiGate Firewall Logs](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)                             | Collect logs from Fortinet FortiGate firewalls with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 1.36.2  | 9.0.08.11.0                  |
| [Fortinet FortiMail](https://www.elastic.co/docs/reference/integrations/fortinet_fortimail)                                           | Collect logs from Fortinet FortiMail instances with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 2.18.0  | 9.0.08.11.0                  |
| [Fortinet FortiManager Logs](https://www.elastic.co/docs/reference/integrations/fortinet_fortimanager)                                | Collect logs from Fortinet FortiManager instances with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 2.17.0  | 9.0.08.11.0                  |
| [Fortinet FortiProxy](https://www.elastic.co/docs/reference/integrations/fortinet_fortiproxy)                                         | Collect logs from Fortinet FortiProxy with Elastic Agent.                                                                                                                                                                                                                                         | GA                              | 1.3.0   | 9.0.08.12.2                  |
| [GCP Audit Logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/gcp_audit_otel)                              | GCP Audit Logs OpenTelemetry Assets                                                                                                                                                                                                                                                               | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.1                        |
| [GCP Metrics Input](https://www.elastic.co/docs/reference/integrations/gcp_metrics)                                                   | GCP Metrics Input                                                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.3.1   | 9.0.08.15.0                  |
| [GCP Vertex AI](https://www.elastic.co/docs/reference/integrations/gcp_vertexai)                                                      | Collect GCP Vertex AI metrics and logs with Elastic Agent                                                                                                                                                                                                                                         | GA                              | 1.4.0   | 9.2.0                        |
| [GCP VPC Flow Logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/gcp_vpcflow_otel)                         | GCP VPC Flow Logs OpenTelemetry Assets                                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.1                        |
| [Gigamon](https://www.elastic.co/docs/reference/integrations/gigamon)                                                                 | Collect logs from Gigamon with Elastic Agent.                                                                                                                                                                                                                                                     | GA                              | 2.1.0   | 9.0.08.13.0                  |
| [GitHub](https://www.elastic.co/docs/reference/integrations/github)                                                                   | Collect logs from GitHub with Elastic Agent.                                                                                                                                                                                                                                                      | GA                              | 2.21.0  | 9.1.49.0.78.19.4             |
| [GitLab](https://www.elastic.co/docs/reference/integrations/gitlab)                                                                   | Collect logs from GitLab with Elastic Agent.                                                                                                                                                                                                                                                      | GA                              | 2.3.3   | 9.0.08.13.0                  |
| [GoFlow2 logs](https://www.elastic.co/docs/reference/integrations/goflow2)                                                            | Collect logs from goflow2 with Elastic Agent.                                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.6.0   | 9.0.08.11.0                  |
| [Golang](https://www.elastic.co/docs/reference/integrations/golang)                                                                   | This Elastic integration collects metrics from Golang applications.                                                                                                                                                                                                                               | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [Google Cloud Platform](https://www.elastic.co/docs/reference/integrations/gcp)                                                       | Collect logs and metrics from Google Cloud Platform with Elastic Agent.                                                                                                                                                                                                                           | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Audit logs](https://www.elastic.co/docs/reference/integrations/gcp/audit)                                | Collect audit logs from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                            | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Billing metrics](https://www.elastic.co/docs/reference/integrations/gcp/billing)                         | Collect billing metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                       | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Cloud Run metrics](https://www.elastic.co/docs/reference/integrations/gcp/cloudrun)                      | Collect Cloud Run metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                     | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) CloudSQL metrics](https://www.elastic.co/docs/reference/integrations/gcp/cloudsql)                       | Collect CloudSQL metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                      | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Compute metrics](https://www.elastic.co/docs/reference/integrations/gcp/compute)                         | Collect compute metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                       | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Dataproc metrics](https://www.elastic.co/docs/reference/integrations/gcp/dataproc)                       | Collect dataproc metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                      | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) DNS logs](https://www.elastic.co/docs/reference/integrations/gcp/dns)                                    | Collect DNS logs from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                              | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Firestore metrics](https://www.elastic.co/docs/reference/integrations/gcp/firestore)                     | Collect firestore metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                     | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Firewall logs](https://www.elastic.co/docs/reference/integrations/gcp/firewall)                          | Collect firewall logs from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                         | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) GKE metrics](https://www.elastic.co/docs/reference/integrations/gcp/gke)                                 | Collect gke metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                           | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Load Balancing metrics](https://www.elastic.co/docs/reference/integrations/gcp/loadbalancing)            | Collect Load Balancing metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) PubSub metrics](https://www.elastic.co/docs/reference/integrations/gcp/pubsub)                           | Collect pubsub metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                        | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Redis metrics](https://www.elastic.co/docs/reference/integrations/gcp/redis)                             | Collect Redis metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                         | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) Storage metrics](https://www.elastic.co/docs/reference/integrations/gcp/storage)                         | Collect storage metrics from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                       | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Cloud Platform (GCP) VPC Flow logs](https://www.elastic.co/docs/reference/integrations/gcp/vpcflow)                           | Collect vpcflow logs from Google Cloud Platform (GCP) with Elastic Agent                                                                                                                                                                                                                          | GA                              | 2.47.1  | 9.0.08.13.0                  |
| [Google Santa](https://www.elastic.co/docs/reference/integrations/santa)                                                              | Collect logs from Google Santa with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 3.24.0  | 9.0.08.13.0                  |
| [Google SecOps](https://www.elastic.co/docs/reference/integrations/google_secops)                                                     | Collect alerts from Google SecOps with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 1.2.2   | 9.0.08.18.0                  |
| [Google Security Command Center](https://www.elastic.co/docs/reference/integrations/google_scc)                                       | Collect logs from Google Security Command Center with Elastic Agent.                                                                                                                                                                                                                              | GA                              | 2.2.1   | 9.1.48.19.4                  |
| [Google Threat Intelligence](https://www.elastic.co/docs/reference/integrations/ti_google_threat_intelligence)                        | Collect Threat Intelligence Events from Google Threat Intelligence using Elastic Agent, and perform enrichment on Elasticsearch by correlating Indicators of Compromise (IOCs).                                                                                                                   | <applies-to>: Beta</applies-to> | 0.8.0   | 9.0.08.16.0                  |
| [Google Workspace](https://www.elastic.co/docs/reference/integrations/google_workspace)                                               | Collect logs from Google Workspace with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 3.2.0   | 9.1.49.0.78.19.4             |
| [GreyNoise](https://www.elastic.co/docs/reference/integrations/ti_greynoise)                                                          | Collect Threat Intelligence Indicators from GreyNoise using Elastic Agent, and perform enrichment on Elasticsearch by correlating Indicators of Compromise (IOCs).                                                                                                                                | <applies-to>: Beta</applies-to> | 0.7.2   | 9.0.08.17.0                  |
| [Hadoop](https://www.elastic.co/docs/reference/integrations/hadoop)                                                                   | Collect metrics from Apache Hadoop with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.9.0   | 9.0.08.13.0                  |
| [HAProxy](https://www.elastic.co/docs/reference/integrations/haproxy)                                                                 | Collect logs and metrics from HAProxy servers with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 1.17.2  | 9.0.08.13.0                  |
| [Hashicorp Vault](https://www.elastic.co/docs/reference/integrations/hashicorp_vault)                                                 | Collect logs and metrics from Hashicorp Vault with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 1.29.0  | 9.0.08.12.0                  |
| [Host Metrics OpenTelemetry Input Package](https://www.elastic.co/docs/reference/integrations/hostmetrics_input_otel)                 | Collect system metrics using OpenTelemetry Collector                                                                                                                                                                                                                                              | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Host Traffic Anomalies](https://www.elastic.co/docs/reference/integrations/hta)                                                      | Prebuilt dashboard for Machine Learning module Security: Host.                                                                                                                                                                                                                                    | GA                              | 1.0.1   | 9.0.08.18.0                  |
| [HPE Aruba CX](https://www.elastic.co/docs/reference/integrations/hpe_aruba_cx)                                                       | Collect logs from HPE Aruba CX with Elastic Agent                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.3.0   | 9.0.08.15.0                  |
| [IBM MQ](https://www.elastic.co/docs/reference/integrations/ibmmq)                                                                    | Collect logs and metrics from IBM MQ with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 1.8.0   | 9.0.08.13.0                  |
| [IBM QRadar](https://www.elastic.co/docs/reference/integrations/ibm_qradar)                                                           | Collect logs from IBM QRadar with Elastic Agent.                                                                                                                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.1.1   | 9.0.08.18.0                  |
| [IIS](https://www.elastic.co/docs/reference/integrations/iis)                                                                         | Collect logs and metrics from Internet Information Services (IIS) servers with Elastic Agent.                                                                                                                                                                                                     | GA                              | 1.24.4  | 9.0.08.13.0                  |
| [IIS OpenTelemetry assets](https://www.elastic.co/docs/reference/integrations/iis_otel)                                               | IIS Assets for OpenTelemetry Collector                                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [IIS OpenTelemetry Input Package](https://www.elastic.co/docs/reference/integrations/iis_otel_input)                                  | IIS OpenTelemetry Input Package                                                                                                                                                                                                                                                                   | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Imperva](https://www.elastic.co/docs/reference/integrations/imperva)                                                                 | Collect logs from Imperva devices with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 1.9.0   | 9.0.08.11.0                  |
| [Imperva Cloud WAF](https://www.elastic.co/docs/reference/integrations/imperva_cloud_waf)                                             | Collect logs from Imperva Cloud WAF with Elastic Agent.                                                                                                                                                                                                                                           | GA                              | 1.13.1  | 9.0.08.16.5                  |
| [InfluxDb](https://www.elastic.co/docs/reference/integrations/influxdb)                                                               | Collect metrics from Influxdb database                                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.11.0  | 9.0.08.13.0                  |
| [Infoblox BloxOne DDI](https://www.elastic.co/docs/reference/integrations/infoblox_bloxone_ddi)                                       | Collect logs from Infoblox BloxOne DDI with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.22.0  | 9.1.49.0.78.19.4             |
| [Infoblox NIOS](https://www.elastic.co/docs/reference/integrations/infoblox_nios)                                                     | Collect logs from Infoblox NIOS with Elastic Agent.                                                                                                                                                                                                                                               | GA                              | 2.1.1   | 9.0.08.13.0                  |
| [Infoblox Threat Defense](https://www.elastic.co/docs/reference/integrations/infoblox_threat_defense)                                 | Collect logs from Infoblox Threat Defense with Elastic Agent.                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.18.0                  |
| [Iptables](https://www.elastic.co/docs/reference/integrations/iptables)                                                               | Collect logs from Iptables with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 1.22.0  | 9.0.08.11.0                  |
| [Island Browser](https://www.elastic.co/docs/reference/integrations/island_browser)                                                   | Collect logs from Island Browser with Elastic Agent.                                                                                                                                                                                                                                              | GA                              | 1.0.0   | 9.1.59.0.88.19.58.18.8       |
| [Istio](https://www.elastic.co/docs/reference/integrations/istio)                                                                     | Collect logs and metrics from the service mesh Istio with Elastic Agent.                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.8.0   | 9.0.08.11.0                  |
| [Jamf Compliance Reporter](https://www.elastic.co/docs/reference/integrations/jamf_compliance_reporter)                               | Collect logs from Jamf Compliance Reporter with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.16.0  | 9.0.08.13.0                  |
| [Jamf Pro](https://www.elastic.co/docs/reference/integrations/jamf_pro)                                                               | Collect logs and inventory data from Jamf Pro with Elastic Agent                                                                                                                                                                                                                                  | GA                              | 1.0.0   | 9.0.08.15.0                  |
| [Jamf Protect](https://www.elastic.co/docs/reference/integrations/jamf_protect)                                                       | Receives events from Jamf Protect with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 3.2.2   | 9.0.08.16.5                  |
| [Jolokia Input](https://www.elastic.co/docs/reference/integrations/jolokia)                                                           | Collects Metrics from Jolokia Agents                                                                                                                                                                                                                                                              | GA                              | 1.0.0   | 9.0.08.17.0                  |
| [JumpCloud](https://www.elastic.co/docs/reference/integrations/jumpcloud)                                                             | Collect logs from JumpCloud Directory as a Service                                                                                                                                                                                                                                                | GA                              | 1.17.0  | 9.0.08.13.0                  |
| [Juniper SRX](https://www.elastic.co/docs/reference/integrations/juniper_srx)                                                         | Collect logs from Juniper SRX devices with Elastic Agent.                                                                                                                                                                                                                                         | GA                              | 1.26.0  | 9.0.08.11.0                  |
| [JupiterOne](https://www.elastic.co/docs/reference/integrations/jupiter_one)                                                          | Collect logs from JupiterOne with Elastic Agent.                                                                                                                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.1.0   | 9.4.09.3.19.2.49.1.108.19.10 |
| [Kafka](https://www.elastic.co/docs/reference/integrations/kafka)                                                                     | Collect logs and metrics from Kafka servers with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.26.0  | 9.0.68.19.6                  |
| [Keeper Security](https://www.elastic.co/docs/reference/integrations/keeper)                                                          | Keeper Security agentless integration for collecting audit events directly via Elasticsearch Bulk API. No agents required - Keeper pushes data directly to Elasticsearch.                                                                                                                         |                                 |         |                              |
| <applies-to>: Beta</applies-to>                                                                                                       | 0.1.0                                                                                                                                                                                                                                                                                             | 9.1.08.19.0                     |         |                              |
| [Keycloak](https://www.elastic.co/docs/reference/integrations/keycloak)                                                               | Collect logs from Keycloak with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 1.31.0  | 9.0.08.13.0                  |
| [Kibana](https://www.elastic.co/docs/reference/integrations/kibana)                                                                   | Collect logs and metrics from Kibana with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 2.8.0   | 9.0.08.10.1                  |
| [Kube-apiserver Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-apiserver)                                | Collect metrics from Kubernetes API Server with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kube-controller-manager Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-controller-manager)              | Collect metrics from Kubernetes Controller Manager with Elastic Agent.                                                                                                                                                                                                                            | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kube-proxy Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-proxy)                                        | Collect metrics from Kubernetes Proxy server with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kube-scheduler Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-scheduler)                                | Collect metrics from Kubernetes Scheduler with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kube-state-metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-state-metrics)                                | Collect container metrics from Kubernetes Kube-state-metrics with Elastic Agent.                                                                                                                                                                                                                  | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubelet Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/kubelet)                                              | Collect metrics from Kubernetes Kubelet API with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubelet Stats OpenTelemetry Input](https://www.elastic.co/docs/reference/integrations/kubeletstats_input_otel)                       | Collect Kubernetes node, pod, container, and volume metrics from the Kubelet API using the OpenTelemetry Collector.                                                                                                                                                                               | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Kubernetes](https://www.elastic.co/docs/reference/integrations/kubernetes)                                                           | Collect logs and metrics from Kubernetes clusters with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubernetes Audit Logs](https://www.elastic.co/docs/reference/integrations/kubernetes/audit-logs)                                     | Collect audit logs from Kubernetes nodes with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubernetes Container Logs](https://www.elastic.co/docs/reference/integrations/kubernetes/container-logs)                             | Collect container related logs from Kubernetes clusters with Elastic Agent.                                                                                                                                                                                                                       | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubernetes Event Metrics](https://www.elastic.co/docs/reference/integrations/kubernetes/events)                                      | Collect events related metrics from Kubernetes API server with Elastic Agent.                                                                                                                                                                                                                     | GA                              | 1.84.1  | 9.3.09.2.49.1.10             |
| [Kubernetes OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/kubernetes_otel)                                 | Utilise the pre-built dashboard for OTel-native metrics and events collected from a Kubernetes cluster                                                                                                                                                                                            | GA                              | 1.4.0   | 9.2.0                        |
| [Kubernetes Security Posture Management (KSPM)](https://www.elastic.co/docs/reference/integrations/cloud_security_posture/kspm)       | Identify & remediate configuration risks in Kubernetes                                                                                                                                                                                                                                            | GA                              | 3.2.1   | 9.3.0                        |
| [LastPass](https://www.elastic.co/docs/reference/integrations/lastpass)                                                               | Collect logs from LastPass with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 1.21.0  | 9.1.49.0.78.19.4             |
| [Lateral Movement Detection](https://www.elastic.co/docs/reference/integrations/lmd)                                                  | ML package to detect lateral movement based on file transfer activity and Windows RDP events.                                                                                                                                                                                                     | GA                              | 2.6.1   | 9.0.08.9.0                   |
| [Linux Metrics](https://www.elastic.co/docs/reference/integrations/linux)                                                             | Collect metrics from Linux servers with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.0.0   | 9.0.08.17.0                  |
| [Living off the Land Attack Detection](https://www.elastic.co/docs/reference/integrations/problemchild)                               | ML solution package to detect Living off the Land (LotL) attacks in your environment. Requires a Platinum subscription.                                                                                                                                                                           | GA                              | 2.4.5   | 9.0.08.9.0                   |
| [Logstash](https://www.elastic.co/docs/reference/integrations/logstash)                                                               | Collect logs and metrics from Logstash with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 2.8.0   | 9.0.08.17.0                  |
| [Lumos](https://www.elastic.co/docs/reference/integrations/lumos)                                                                     | An integration with Lumos to ship your Activity logs to your Elastic instance.                                                                                                                                                                                                                    | GA                              | 1.6.0   | 9.1.49.0.78.19.4             |
| [Lyve Cloud](https://www.elastic.co/docs/reference/integrations/lyve_cloud)                                                           | Collect S3 API audit log from Lyve Cloud with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 1.17.0  | 9.0.08.13.0                  |
| [macOS](https://www.elastic.co/docs/reference/integrations/macos)                                                                     | Collect logs from macOS with Elastic Agent.                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.18.0                  |
| [Maltiverse](https://www.elastic.co/docs/reference/integrations/ti_maltiverse)                                                        | Ingest threat intelligence indicators from Maltiverse feeds with Elastic Agent                                                                                                                                                                                                                    | GA                              | 1.6.0   | 9.0.08.13.0                  |
| [Mandiant Advantage](https://www.elastic.co/docs/reference/integrations/ti_mandiant_advantage)                                        | Collect Threat Intelligence from products within the Mandiant Advantage platform.                                                                                                                                                                                                                 | GA                              | 1.10.0  | 9.1.49.0.78.19.4             |
| [Mattermost](https://www.elastic.co/docs/reference/integrations/mattermost)                                                           | Collect logs from Mattermost with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 2.5.0   | 9.0.08.13.0                  |
| [Memcached](https://www.elastic.co/docs/reference/integrations/memcached)                                                             | Memcached Integration                                                                                                                                                                                                                                                                             | GA                              | 1.7.1   | 9.0.08.13.0                  |
| [Menlo Security](https://www.elastic.co/docs/reference/integrations/menlo)                                                            | Collect logs from Menlo Security products with Elastic Agent                                                                                                                                                                                                                                      | GA                              | 1.7.1   | 9.1.08.19.0                  |
| [Microsoft Defender for Cloud](https://www.elastic.co/docs/reference/integrations/microsoft_defender_cloud)                           | Collect logs from Microsoft Defender for Cloud with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 3.2.0   | 9.1.48.19.4                  |
| [Microsoft Defender for Endpoint](https://www.elastic.co/docs/reference/integrations/microsoft_defender_endpoint)                     | Collect logs from Microsoft Defender for Endpoint with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 4.3.0   | 9.1.28.19.3                  |
| [Microsoft Defender XDR](https://www.elastic.co/docs/reference/integrations/m365_defender)                                            | Collect logs from Microsoft Defender XDR with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 5.6.0   | 9.1.48.19.4                  |
| [Microsoft DHCP](https://www.elastic.co/docs/reference/integrations/microsoft_dhcp)                                                   | Collect logs from Microsoft DHCP with Elastic Agent.                                                                                                                                                                                                                                              | GA                              | 1.27.0  | 9.0.08.11.0                  |
| [Microsoft DNS Server](https://www.elastic.co/docs/reference/integrations/microsoft_dnsserver)                                        | Collect logs from Microsoft DNS Server with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.5.0   | 9.0.08.13.0                  |
| [Microsoft Entra ID](https://www.elastic.co/docs/reference/integrations/azure/adlogs)                                                 | Collect logs from Microsoft Entra ID (formerly Azure Active Directory) with Elastic Agent.                                                                                                                                                                                                        | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Microsoft Entra ID Entity Analytics](https://www.elastic.co/docs/reference/integrations/entityanalytics_entra_id)                    | Collect identities from Microsoft Entra ID (formerly Azure Active Directory) with Elastic Agent.                                                                                                                                                                                                  | GA                              | 1.8.2   | 9.0.08.15.1                  |
| [Microsoft Exchange Online Message Trace](https://www.elastic.co/docs/reference/integrations/microsoft_exchange_online_message_trace) | Microsoft Exchange Online Message Trace Integration                                                                                                                                                                                                                                               | GA                              | 1.29.1  | 9.1.49.0.78.19.4             |
| [Microsoft Exchange Server](https://www.elastic.co/docs/reference/integrations/microsoft_exchange_server)                             | Collect logs from Microsoft Exchange Server with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.4.1   | 9.0.08.11.0                  |
| [Microsoft Foundry](https://www.elastic.co/docs/reference/integrations/azure_ai_foundry)                                              | Collects Microsoft Foundry logs and metrics                                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.8.0   | 9.2.1                        |
| [Microsoft Graph Activity Logs](https://www.elastic.co/docs/reference/integrations/azure/graphactivitylogs)                           | Microsoft Graph Activity Logs integration                                                                                                                                                                                                                                                         | GA                              | 1.35.1  | 9.2.49.1.108.19.10           |
| [Microsoft Office 365 Metrics](https://www.elastic.co/docs/reference/integrations/o365_metrics)                                       | Collect metrics from Microsoft Office 365 with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.1.0   | 9.0.08.16.0                  |
| [Microsoft Sentinel](https://www.elastic.co/docs/reference/integrations/microsoft_sentinel)                                           | Collect logs from Microsoft Sentinel with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 1.2.2   | 9.0.08.18.0                  |
| [Microsoft SQL Server](https://www.elastic.co/docs/reference/integrations/microsoft_sqlserver)                                        | Collect events from Microsoft SQL Server with Elastic Agent                                                                                                                                                                                                                                       | GA                              | 2.16.0  | 9.2.18.19.0                  |
| [Mimecast](https://www.elastic.co/docs/reference/integrations/mimecast)                                                               | Collect logs from Mimecast with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 3.3.1   | 9.1.49.0.78.19.4             |
| [Miniflux RSS reader](https://www.elastic.co/docs/reference/integrations/miniflux)                                                    | Collect RSS feed content from the Miniflux API with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 1.0.0   | 9.0.08.17.4                  |
| [MISP](https://www.elastic.co/docs/reference/integrations/ti_misp)                                                                    | Ingest threat intelligence indicators from MISP platform with Elastic Agent.                                                                                                                                                                                                                      | GA                              | 1.41.0  | 9.0.08.13.0                  |
| [ModSecurity Audit](https://www.elastic.co/docs/reference/integrations/modsecurity)                                                   | Collect logs from ModSecurity with Elastic Agent                                                                                                                                                                                                                                                  | GA                              | 1.22.0  | 9.0.08.11.0                  |
| [MongoDB](https://www.elastic.co/docs/reference/integrations/mongodb)                                                                 | Collect logs and metrics from MongoDB instances with Elastic Agent.                                                                                                                                                                                                                               | GA                              | 1.24.0  | 9.2.18.19.0                  |
| [MongoDB Atlas](https://www.elastic.co/docs/reference/integrations/mongodb_atlas)                                                     | This Elastic integration collects logs and metrics from MongoDB Atlas instance.                                                                                                                                                                                                                   | GA                              | 1.1.0   | 9.0.08.13.0                  |
| [MySQL](https://www.elastic.co/docs/reference/integrations/mysql)                                                                     | Collect logs and metrics from MySQL servers with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.29.2  | 9.2.18.19.0                  |
| [MySQL Enterprise](https://www.elastic.co/docs/reference/integrations/mysql_enterprise)                                               | Collect audit logs from MySQL Enterprise with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 1.17.0  | 9.0.08.11.0                  |
| [MySQL OpenTelemetry assets](https://www.elastic.co/docs/reference/integrations/mysql_otel)                                           | MySQL metrics for OpenTelemetry Collector                                                                                                                                                                                                                                                         | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [Nagios XI](https://www.elastic.co/docs/reference/integrations/nagios_xi)                                                             | Collect Logs and Metrics from Nagios XI with Elastic Agent.                                                                                                                                                                                                                                       | GA                              | 1.8.0   | 9.0.08.13.0                  |
| [NATS](https://www.elastic.co/docs/reference/integrations/nats)                                                                       | Collect logs and metrics from NATS servers with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.12.0  | 9.0.08.13.0                  |
| [Neon Cyber](https://www.elastic.co/docs/reference/integrations/neon_cyber)                                                           | The Neon Cyber integration for the Elastic Stack                                                                                                                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.17.0                  |
| [NetFlow Records](https://www.elastic.co/docs/reference/integrations/netflow)                                                         | Collect flow records from NetFlow and IPFIX exporters with Elastic Agent.                                                                                                                                                                                                                         | GA                              | 2.24.1  | 9.0.08.14.0                  |
| [Netskope](https://www.elastic.co/docs/reference/integrations/netskope)                                                               | Collect logs from Netskope with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 3.1.2   | 9.1.08.19.9                  |
| [Network Beaconing Identification](https://www.elastic.co/docs/reference/integrations/beaconing)                                      | Package to identify beaconing activity in your network events.                                                                                                                                                                                                                                    | GA                              | 1.5.2   | 9.0.08.10.1                  |
| [Network Packet Capture](https://www.elastic.co/docs/reference/integrations/network_traffic)                                          | Capture and analyze network traffic from a host with Elastic Agent.                                                                                                                                                                                                                               | GA                              | 1.34.0  | 9.0.08.14.0                  |
| [Nginx](https://www.elastic.co/docs/reference/integrations/nginx)                                                                     | Collect logs and metrics from Nginx HTTP servers with Elastic Agent.                                                                                                                                                                                                                              | GA                              | 3.0.0   | 9.0.08.13.0                  |
| [Nginx Ingress Controller Logs](https://www.elastic.co/docs/reference/integrations/nginx_ingress_controller)                          | Collect Nginx Ingress Controller logs.                                                                                                                                                                                                                                                            | GA                              | 1.14.0  | 9.0.08.14.0                  |
| [Nginx Ingress Controller OpenTelemetry Logs](https://www.elastic.co/docs/reference/integrations/nginx_ingress_controller_otel)       | Collect Nginx Ingress Controller logs using the OpenTelemetry collector.                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.2.2   | 9.0.08.16.0                  |
| [NGINX OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/nginx_otel)                                           | NGINX metrics from OpenTelemetry Collector                                                                                                                                                                                                                                                        | <applies-to>: Beta</applies-to> | 0.2.1   | 9.2.0                        |
| [NGINX OpenTelemetry Input Package](https://www.elastic.co/docs/reference/integrations/nginx_otel_input)                              | NGINX OpenTelemetry Input Package                                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [Nozomi Networks](https://www.elastic.co/docs/reference/integrations/nozomi_networks)                                                 | Collect logs from Nozomi Networks with Elastic Agent.                                                                                                                                                                                                                                             | <applies-to>: Beta</applies-to> | 0.2.1   | 9.0.08.18.0                  |
| [NVIDIA GPU Monitoring](https://www.elastic.co/docs/reference/integrations/nvidia_gpu)                                                | Monitor NVIDIA GPUs via NVIDIA Data Center GPU Manager                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.4.1   | 9.0.08.16.0                  |
| [Okta](https://www.elastic.co/docs/reference/integrations/okta)                                                                       | Collect and parse event logs from Okta API with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 3.14.0  | 9.2.28.19.8                  |
| [Okta Entity Analytics](https://www.elastic.co/docs/reference/integrations/entityanalytics_okta)                                      | Collect Identities from Okta with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 2.5.1   | 9.0.28.18.3                  |
| [OpenAI](https://www.elastic.co/docs/reference/integrations/openai)                                                                   | Collect OpenAI usage metrics with Elastic Agent.                                                                                                                                                                                                                                                  |                                 |         |                              |
| GA                                                                                                                                    | 1.2.1                                                                                                                                                                                                                                                                                             | 9.0.08.16.3                     |         |                              |
| [OpenCanary](https://www.elastic.co/docs/reference/integrations/opencanary)                                                           | This integration collects and parses logs from OpenCanary honeypots.                                                                                                                                                                                                                              | GA                              | 1.0.0   | 9.0.08.15.0                  |
| [OpenCTI](https://www.elastic.co/docs/reference/integrations/ti_opencti)                                                              | Ingest threat intelligence indicators from OpenCTI with Elastic Agent.                                                                                                                                                                                                                            | GA                              | 2.12.0  | 9.0.08.16.0                  |
| [OpenTelemetry Internal Telemetry](https://www.elastic.co/docs/reference/integrations/otel_internal_telemetry)                        | This package contains dashboards that visualize the internal telemetry from OpenTelemetry components                                                                                                                                                                                              | <applies-to>: Beta</applies-to> | 0.0.3   | 9.2.1                        |
| [Oracle](https://www.elastic.co/docs/reference/integrations/oracle)                                                                   | Collect Oracle Audit Log, Performance metrics, Tablespace metrics, Sysmetrics metrics, System statistics metrics, memory metrics from Oracle database.                                                                                                                                            | GA                              | 1.31.1  | 9.0.08.13.0                  |
| [Oracle WebLogic](https://www.elastic.co/docs/reference/integrations/oracle_weblogic)                                                 | Collect logs and metrics from Oracle WebLogic with Elastic Agent.                                                                                                                                                                                                                                 | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [Osquery Logs](https://www.elastic.co/docs/reference/integrations/osquery)                                                            | Collect logs from Osquery with Elastic Agent.                                                                                                                                                                                                                                                     | GA                              | 1.24.0  | 9.0.08.11.0                  |
| [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager)                                                 | Deploy Osquery with Elastic Agent, then run and schedule queries in Kibana                                                                                                                                                                                                                        | GA                              | 1.22.0  | 9.3.0                        |
| [Palo Alto Cortex XDR](https://www.elastic.co/docs/reference/integrations/panw_cortex_xdr)                                            | Collect logs from Palo Alto Cortex XDR with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 2.5.0   | 9.1.49.0.78.19.4             |
| [Palo Alto Networks Metrics](https://www.elastic.co/docs/reference/integrations/panw_metrics)                                         | Collect metrics from Palo Alto Networks with Elastic Agent.                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.2.0   | 9.0.08.15.2                  |
| [Palo Alto Next-Gen Firewall](https://www.elastic.co/docs/reference/integrations/panw)                                                | Collect logs from Palo Alto next-gen firewalls with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 5.4.1   | 9.0.08.11.0                  |
| [Palo Alto Prisma Access](https://www.elastic.co/docs/reference/integrations/prisma_access)                                           | Collect logs from Palo Alto Prisma Access with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.6.1   | 9.0.08.13.0                  |
| [Palo Alto Prisma Cloud](https://www.elastic.co/docs/reference/integrations/prisma_cloud)                                             | Collect logs from Prisma Cloud with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 4.0.0   | 9.3.09.2.29.1.88.19.8        |
| [pfSense](https://www.elastic.co/docs/reference/integrations/pfsense)                                                                 | Collect logs from pfSense and OPNsense with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.25.0  | 9.0.08.11.0                  |
| [PHP-FPM](https://www.elastic.co/docs/reference/integrations/php_fpm)                                                                 | This Elastic integration collects metrics from PHP-FPM.                                                                                                                                                                                                                                           | GA                              | 1.6.0   | 9.0.08.13.0                  |
| [PingFederate](https://www.elastic.co/docs/reference/integrations/ping_federate)                                                      | Collect logs from PingFederate with Elastic Agent.                                                                                                                                                                                                                                                | GA                              | 1.0.2   | 9.0.08.16.0                  |
| [PingOne](https://www.elastic.co/docs/reference/integrations/ping_one)                                                                | Collect logs from PingOne with Elastic-Agent.                                                                                                                                                                                                                                                     | GA                              | 1.22.0  | 9.1.49.0.78.19.4             |
| [Pleasant Password Server](https://www.elastic.co/docs/reference/integrations/pps)                                                    | Integration for Pleasant Password Server Syslog Messages                                                                                                                                                                                                                                          | GA                              | 1.1.0   | 9.0.08.13.0                  |
| [PostgreSQL](https://www.elastic.co/docs/reference/integrations/postgresql)                                                           | Collect logs and metrics from PostgreSQL servers with Elastic Agent.                                                                                                                                                                                                                              | GA                              | 1.32.1  | 9.2.18.19.0                  |
| [PostgreSQL OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/postgresql_otel)                                 | PostgreSQL Assets for OpenTelemetry Collector                                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.2.0   | 9.2.0                        |
| [Prebuilt Security Detection Rules](https://www.elastic.co/docs/reference/integrations/security_detection_engine)                     | Prebuilt detection rules for Elastic Security                                                                                                                                                                                                                                                     | GA                              | 9.3.3   | 9.3.0                        |
| [Privileged Access Detection](https://www.elastic.co/docs/reference/integrations/pad)                                                 | ML package to detect anomalous privileged access activity in Windows, Linux and Okta logs                                                                                                                                                                                                         | GA                              | 1.1.1   | 9.0.08.18.0                  |
| [Profilingmetrics OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/profilingmetrics_otel)                     | Create metrics from profiling data.                                                                                                                                                                                                                                                               | <applies-to>: Beta</applies-to> | 0.0.4   | 9.2.0                        |
| [Prometheus](https://www.elastic.co/docs/reference/integrations/prometheus)                                                           | Collect metrics from Prometheus servers with Elastic Agent.                                                                                                                                                                                                                                       | GA                              | 1.24.2  | 9.0.08.16.0                  |
| [Prometheus Input](https://www.elastic.co/docs/reference/integrations/prometheus_input)                                               | Collects metrics from Prometheus exporter.                                                                                                                                                                                                                                                        | GA                              | 1.0.0   | 9.0.08.13.0                  |
| [Prometheus OTel Scrape (Bring Your Own Config)](https://www.elastic.co/docs/reference/integrations/prometheus_input_otel_raw)        | Scrape Prometheus metrics endpoints using the OpenTelemetry Collector Prometheus receiver with raw scrape configuration                                                                                                                                                                           | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Prometheus OTel Scrape (Guided)](https://www.elastic.co/docs/reference/integrations/prometheus_input_otel)                           | Scrape Prometheus metrics endpoints using the OpenTelemetry Collector Prometheus receiver with guided configuration                                                                                                                                                                               | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Proofpoint Essentials](https://www.elastic.co/docs/reference/integrations/proofpoint_essentials)                                     | Collect logs from Proofpoint Essentials with Elastic Agent.                                                                                                                                                                                                                                       | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.18.0                  |
| [Proofpoint ITM](https://www.elastic.co/docs/reference/integrations/proofpoint_itm)                                                   | Collect logs from Proofpoint ITM using Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 1.0.1   | 9.0.08.18.0                  |
| [Proofpoint On Demand](https://www.elastic.co/docs/reference/integrations/proofpoint_on_demand)                                       | Collect logs from Proofpoint On Demand with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.8.0   | 9.1.08.19.0                  |
| [Proofpoint TAP](https://www.elastic.co/docs/reference/integrations/proofpoint_tap)                                                   | Collect logs from Proofpoint TAP with Elastic Agent.                                                                                                                                                                                                                                              | GA                              | 1.29.0  | 9.1.49.0.78.19.4             |
| [Pulse Connect Secure](https://www.elastic.co/docs/reference/integrations/pulse_connect_secure)                                       | Collect logs from Pulse Connect Secure with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 2.6.0   | 9.0.08.13.0                  |
| [QNAP NAS](https://www.elastic.co/docs/reference/integrations/qnap_nas)                                                               | Collect logs from QNAP NAS devices with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.24.0  | 9.0.08.11.0                  |
| [Qualys Global AssetView](https://www.elastic.co/docs/reference/integrations/qualys_gav)                                              | Collect logs from Qualys Global AssetView with Elastic Agent.                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.7.1   | 9.2.58.19.11                 |
| [Qualys VMDR](https://www.elastic.co/docs/reference/integrations/qualys_vmdr)                                                         | Collect data from Qualys VMDR platform with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 6.15.0  | 9.1.08.19.0                  |
| [Qualys Web Application Scanning (WAS)](https://www.elastic.co/docs/reference/integrations/qualys_was)                                | Collect data from Qualys Web Application Scanning platform with Elastic Agent or Agentless                                                                                                                                                                                                        | <applies-to>: Beta</applies-to> | 0.3.0   | 9.0.08.18.0                  |
| [RabbitMQ Logs and Metrics](https://www.elastic.co/docs/reference/integrations/rabbitmq)                                              | Collect and parse logs from RabbitMQ servers with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.22.0  | 9.0.08.13.0                  |
| [Rapid7 InsightVM](https://www.elastic.co/docs/reference/integrations/rapid7_insightvm)                                               | Collect logs from Rapid7 InsightVM with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 2.5.1   | 9.1.48.19.4                  |
| [Rapid7 Threat Command](https://www.elastic.co/docs/reference/integrations/ti_rapid7_threat_command)                                  | Collect threat intelligence from Threat Command API with Elastic Agent.                                                                                                                                                                                                                           | GA                              | 2.7.0   | 9.1.49.0.78.19.4             |
| [Recorded Future](https://www.elastic.co/docs/reference/integrations/ti_recordedfuture)                                               | Ingest threat intelligence and alert data from Recorded Future with Elastic Agent.                                                                                                                                                                                                                | GA                              | 2.4.0   | 9.0.08.18.0                  |
| [Redis](https://www.elastic.co/docs/reference/integrations/redis)                                                                     | Collect logs and metrics from Redis servers with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 1.20.0  | 9.0.08.13.0                  |
| [Redis Enterprise](https://www.elastic.co/docs/reference/integrations/redisenterprise)                                                | Collect metrics from Redis Enterprise Cluster                                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.12.0  | 9.0.08.13.0                  |
| [Rubrik RSC Metrics](https://www.elastic.co/docs/reference/integrations/rubrik)                                                       | Collect Metrics from Rubrik RSC with Elastic Agent.                                                                                                                                                                                                                                               | <applies-to>: Beta</applies-to> | 0.9.3   | 9.0.08.16.0                  |
| [Sailpoint Identity Security Cloud](https://www.elastic.co/docs/reference/integrations/sailpoint_identity_sc)                         | Sailpoint identity security cloud provides enterprise identity governance and security capabilities. The integration allows users to extract audit information from their identity security cloud tenant using the ISC's AuditEvent API.                                                          | GA                              | 1.2.0   | 9.0.08.16.1                  |
| [Salesforce](https://www.elastic.co/docs/reference/integrations/salesforce)                                                           | Collect logs from Salesforce instances using the Elastic Agent. This integration enables monitoring and analysis of various Salesforce logs, including Login, Logout, Setup Audit Trail, and Apex execution logs. Gain insights into user activity, security events, and application performance. |                                 |         |                              |
| GA                                                                                                                                    | 1.7.0                                                                                                                                                                                                                                                                                             | 9.0.08.16.0                     |         |                              |
| [Security AI Prompts](https://www.elastic.co/docs/reference/integrations/security_ai_prompts)                                         | Prompts used by Security AI features, including the Security Assistant, and Attack discovery                                                                                                                                                                                                      | GA                              | 1.0.13  | 9.1.08.19.0                  |
| [Security Posture Management](https://www.elastic.co/docs/reference/integrations/cloud_security_posture)                              | Identify & remediate configuration risks in your Cloud infrastructure                                                                                                                                                                                                                             | GA                              | 3.2.1   | 9.3.0                        |
| [SentinelOne](https://www.elastic.co/docs/reference/integrations/sentinel_one)                                                        | Collect logs from SentinelOne with Elastic Agent.                                                                                                                                                                                                                                                 | GA                              | 2.1.0   | 9.3.09.2.19.1.78.19.7        |
| [SentinelOne Cloud Funnel](https://www.elastic.co/docs/reference/integrations/sentinel_one_cloud_funnel)                              | Collect logs from SentinelOne Cloud Funnel with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.13.1  | 9.0.08.16.5                  |
| [ServiceNow](https://www.elastic.co/docs/reference/integrations/servicenow)                                                           | Collect logs from ServiceNow with Elastic Agent.                                                                                                                                                                                                                                                  | GA                              | 1.3.2   | 9.0.08.16.5                  |
| [Simple HTTP Check](https://www.elastic.co/docs/reference/integrations/httpcheck_otel)                                                | Perform HTTP checks using the HTTP Check receiver of the OTel Collector.                                                                                                                                                                                                                          | <applies-to>: Beta</applies-to> | 0.1.0   | 9.2.0                        |
| [Slack Logs](https://www.elastic.co/docs/reference/integrations/slack)                                                                | Slack Logs Integration                                                                                                                                                                                                                                                                            | GA                              | 1.26.0  | 9.1.49.0.78.19.4             |
| [Snort](https://www.elastic.co/docs/reference/integrations/snort)                                                                     | Collect logs from Snort with Elastic Agent.                                                                                                                                                                                                                                                       | GA                              | 1.20.0  | 9.0.08.11.0                  |
| [Snyk](https://www.elastic.co/docs/reference/integrations/snyk)                                                                       | Collect logs from Snyk with Elastic Agent.                                                                                                                                                                                                                                                        | GA                              | 3.2.0   | 9.0.08.18.0                  |
| [SonicWall Firewall](https://www.elastic.co/docs/reference/integrations/sonicwall_firewall)                                           | Integration for SonicWall firewall logs                                                                                                                                                                                                                                                           | GA                              | 1.21.0  | 9.0.08.11.0                  |
| [Sophos](https://www.elastic.co/docs/reference/integrations/sophos)                                                                   | Collect logs from Sophos with Elastic Agent.                                                                                                                                                                                                                                                      | GA                              | 3.16.0  | 9.0.08.11.0                  |
| [Sophos Central](https://www.elastic.co/docs/reference/integrations/sophos_central)                                                   | This Elastic integration collects logs from Sophos Central with Elastic Agent.                                                                                                                                                                                                                    | GA                              | 1.20.0  | 9.1.49.0.78.19.4             |
| [Splunk](https://www.elastic.co/docs/reference/integrations/splunk)                                                                   | Collect logs from Splunk with Elastic Agent.                                                                                                                                                                                                                                                      | GA                              | 1.0.1   | 9.1.08.19.0                  |
| [Spring Boot](https://www.elastic.co/docs/reference/integrations/spring_boot)                                                         | This Elastic integration collects logs and metrics from Spring Boot integration.                                                                                                                                                                                                                  | GA                              | 1.9.1   | 9.0.08.13.0                  |
| [SpyCloud Enterprise Protection](https://www.elastic.co/docs/reference/integrations/spycloud)                                         | Collect data from SpyCloud Enterprise Protection with Elastic Agent.                                                                                                                                                                                                                              | GA                              | 1.5.1   | 9.0.08.16.0                  |
| [SQL Input](https://www.elastic.co/docs/reference/integrations/sql)                                                                   | Collects Metrics by querying SQL Databases                                                                                                                                                                                                                                                        | GA                              | 1.1.0   | 9.1.0                        |
| [Squid Proxy](https://www.elastic.co/docs/reference/integrations/squid)                                                               | Collect and parse logs from Squid devices with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.4.0   | 9.0.08.14.1                  |
| [STAN](https://www.elastic.co/docs/reference/integrations/stan)                                                                       | Collect logs and metrics from STAN servers with Elastic Agent.                                                                                                                                                                                                                                    | GA                              | 1.11.0  | 9.0.08.13.0                  |
| [StatsD Input](https://www.elastic.co/docs/reference/integrations/statsd_input)                                                       | StatsD Input Package                                                                                                                                                                                                                                                                              | GA                              | 1.0.0   | 9.0.08.13.0                  |
| [StormShield SNS](https://www.elastic.co/docs/reference/integrations/stormshield)                                                     | Stormshield SNS integration.                                                                                                                                                                                                                                                                      | GA                              | 1.4.0   | 9.0.08.11.4                  |
| [Sublime Security](https://www.elastic.co/docs/reference/integrations/sublime_security)                                               | Collect logs from Sublime Security with Elastic Agent.                                                                                                                                                                                                                                            | GA                              | 1.11.1  | 9.0.08.18.0                  |
| [Suricata](https://www.elastic.co/docs/reference/integrations/suricata)                                                               | Collect logs from Suricata with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 2.27.0  | 9.0.08.11.0                  |
| [Swimlane Turbine](https://www.elastic.co/docs/reference/integrations/swimlane)                                                       | Collect Swimlane Turbine Audit logs with Elastic Agent                                                                                                                                                                                                                                            | <applies-to>: Beta</applies-to> | 0.4.1   | 9.0.08.17.4                  |
| [Symantec Endpoint Protection](https://www.elastic.co/docs/reference/integrations/symantec_endpoint)                                  | Collect logs from Symantec Endpoint Protection with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 2.20.0  | 9.0.08.13.0                  |
| [Symantec Endpoint Security](https://www.elastic.co/docs/reference/integrations/symantec_endpoint_security)                           | Collect logs from Symantec Endpoint Security with Elastic Agent.                                                                                                                                                                                                                                  | GA                              | 1.14.2  | 9.0.08.16.5                  |
| [Sysdig](https://www.elastic.co/docs/reference/integrations/sysdig)                                                                   | Collect logs from Sysdig using Elastic Agent.                                                                                                                                                                                                                                                     | GA                              | 2.2.0   | 9.0.08.16.0                  |
| [Syslog Router](https://www.elastic.co/docs/reference/integrations/syslog_router)                                                     | Route syslog events to integrations with Elastic Agent.                                                                                                                                                                                                                                           | <applies-to>: Beta</applies-to> | 0.4.0   | 9.0.08.14.3                  |
| [Sysmon for Linux](https://www.elastic.co/docs/reference/integrations/sysmon_linux)                                                   | Collect Sysmon Linux logs with Elastic Agent.                                                                                                                                                                                                                                                     | GA                              | 1.9.0   | 9.0.08.11.0                  |
| [System](https://www.elastic.co/docs/reference/integrations/system)                                                                   | Collect system logs and metrics from your servers with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 2.12.0  | 9.2.1                        |
| [System Audit](https://www.elastic.co/docs/reference/integrations/system_audit)                                                       | Collect various logs & metrics from System Audit modules with Elastic Agent.                                                                                                                                                                                                                      | GA                              | 1.11.0  | 9.0.08.7.1                   |
| [System OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/system_otel)                                         | Dashboards for the OpenTelemetry data collected with the `hostmetrics` receiver.                                                                                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.2.4   | 9.0.08.18.0                  |
| [Tanium](https://www.elastic.co/docs/reference/integrations/tanium)                                                                   | This Elastic integration collects logs from Tanium with Elastic Agent.                                                                                                                                                                                                                            | GA                              | 1.17.0  | 9.0.08.16.5                  |
| [Teleport](https://www.elastic.co/docs/reference/integrations/teleport)                                                               | Collect logs from Teleport with Elastic Agent.                                                                                                                                                                                                                                                    | GA                              | 1.6.0   | 9.0.08.14.0                  |
| [Tenable OT Security](https://www.elastic.co/docs/reference/integrations/tenable_ot_security)                                         | Tenable OT Security                                                                                                                                                                                                                                                                               | GA                              | 1.0.0   | 9.0.08.16.1                  |
| [Tenable Security Center](https://www.elastic.co/docs/reference/integrations/tenable_sc)                                              | Collect data from Tenable Security Center with Elastic Agent.                                                                                                                                                                                                                                     |                                 |         |                              |
| GA                                                                                                                                    | 2.1.0                                                                                                                                                                                                                                                                                             | 9.1.49.0.78.19.4                |         |                              |
| [Tenable Vulnerability Management](https://www.elastic.co/docs/reference/integrations/tenable_io)                                     | Collect logs from Tenable Vulnerability Management with Elastic Agent.                                                                                                                                                                                                                            | GA                              | 4.8.0   | 9.1.08.19.0                  |
| [Tencent Cloud](https://www.elastic.co/docs/reference/integrations/tencent_cloud)                                                     | 从腾讯云的 COS 中采集审计日志                                                                                                                                                                                                                                                                                 | <applies-to>: Beta</applies-to> | 0.2.0   | 9.0.08.16.0                  |
| [Threat Intelligence Utilities](https://www.elastic.co/docs/reference/integrations/ti_util)                                           | Prebuilt Threat Intelligence dashboard for Elastic Security                                                                                                                                                                                                                                       | GA                              | 1.7.0   | 9.0.08.13.0                  |
| [Threat Map](https://www.elastic.co/docs/reference/integrations/threat_map)                                                           | The Threat Map integration includes a dashboard for analyzing network traffic data.                                                                                                                                                                                                               | GA                              | 1.1.0   | 9.0.08.14.0                  |
| [ThreatConnect](https://www.elastic.co/docs/reference/integrations/ti_threatconnect)                                                  | Collects Indicators from ThreatConnect using the Elastic Agent and saves them as logs inside Elastic                                                                                                                                                                                              | GA                              | 1.12.0  | 9.0.08.13.0                  |
| [ThreatQuotient](https://www.elastic.co/docs/reference/integrations/ti_threatq)                                                       | Ingest threat intelligence indicators from ThreatQuotient with Elastic Agent.                                                                                                                                                                                                                     | GA                              | 1.37.0  | 9.1.49.0.78.19.4             |
| [Thycotic Secret Server](https://www.elastic.co/docs/reference/integrations/thycotic_ss)                                              | Thycotic Secret Server logs                                                                                                                                                                                                                                                                       | GA                              | 1.12.1  | 9.0.08.13.0                  |
| [Tines](https://www.elastic.co/docs/reference/integrations/tines)                                                                     | Tines Logs & Time Saved Reports                                                                                                                                                                                                                                                                   | GA                              | 1.16.0  | 9.1.49.0.78.19.4             |
| [Tomcat NetWitness Logs (Deprecated)](https://www.elastic.co/docs/reference/integrations/tomcat)                                      | Collect and parse logs from Apache Tomcat servers with Elastic Agent.                                                                                                                                                                                                                             | GA                              | 1.14.0  | 9.0.08.13.0                  |
| [Traefik](https://www.elastic.co/docs/reference/integrations/traefik)                                                                 | Collect logs from Traefik servers with Elastic Agent.                                                                                                                                                                                                                                             | GA                              | 2.7.0   | 9.0.08.13.0                  |
| [Trellix EDR Cloud](https://www.elastic.co/docs/reference/integrations/trellix_edr_cloud)                                             | Collect logs from Trellix EDR Cloud with Elastic Agent.                                                                                                                                                                                                                                           | GA                              | 1.9.0   | 9.0.08.16.5                  |
| [Trellix ePO Cloud](https://www.elastic.co/docs/reference/integrations/trellix_epo_cloud)                                             | Collect logs from Trellix ePO Cloud with Elastic Agent.                                                                                                                                                                                                                                           | GA                              | 1.15.0  | 9.0.08.13.0                  |
| [Trend Micro Deep Security](https://www.elastic.co/docs/reference/integrations/trendmicro)                                            | Collect logs from Trend Micro Deep Security with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 2.8.0   | 9.0.08.13.0                  |
| [Trend Micro Vision One](https://www.elastic.co/docs/reference/integrations/trend_micro_vision_one)                                   | Collect logs from Trend Micro Vision One with Elastic Agent.                                                                                                                                                                                                                                      | GA                              | 2.7.1   | 9.1.49.0.78.19.4             |
| [TYCHON Agentless](https://www.elastic.co/docs/reference/integrations/tychon)                                                         | Collect complete master endpoint datasets including vulnerability and STIG to comply with DISA endpoint requirements and C2C without adding services to your endpoints.                                                                                                                           | GA                              | 1.1.0   | 9.0.08.14.0                  |
| [Universal Profiling Agent](https://www.elastic.co/docs/reference/integrations/profiler_agent)                                        | Fleet-wide, whole-system, continuous profiling with zero instrumentation.                                                                                                                                                                                                                         | GA                              | 8.17.3  | 9.0.08.17.3                  |
| [Universal Profiling Collector](https://www.elastic.co/docs/reference/integrations/profiler_collector)                                | Fleet-wide, whole-system, continuous profiling with zero instrumentation.                                                                                                                                                                                                                         | GA                              | 8.17.3  | 9.0.08.17.3                  |
| [Universal Profiling Symbolizer](https://www.elastic.co/docs/reference/integrations/profiler_symbolizer)                              | Fleet-wide, whole-system, continuous profiling with zero instrumentation.                                                                                                                                                                                                                         | GA                              | 8.17.3  | 9.0.08.17.3                  |
| [Varonis](https://www.elastic.co/docs/reference/integrations/varonis)                                                                 | Collect Varonis syslog alerts using TCP/UDP input.                                                                                                                                                                                                                                                | GA                              | 1.0.0   | 9.0.08.15.3                  |
| [Vectra Detect](https://www.elastic.co/docs/reference/integrations/vectra_detect)                                                     | Collect logs from Vectra Detect with Elastic Agent.                                                                                                                                                                                                                                               | GA                              | 1.14.0  | 9.0.08.13.0                  |
| [Vectra RUX](https://www.elastic.co/docs/reference/integrations/vectra_rux)                                                           | Collect logs from Vectra RUX with Elastic Agent.                                                                                                                                                                                                                                                  | <applies-to>: Beta</applies-to> | 0.3.3   | 9.0.08.18.0                  |
| [VMware Carbon Black Cloud](https://www.elastic.co/docs/reference/integrations/carbon_black_cloud)                                    | Collect logs from VMWare Carbon Black Cloud with Elastic Agent.                                                                                                                                                                                                                                   | GA                              | 4.2.0   | 9.1.49.0.78.19.4             |
| [VMware Carbon Black EDR](https://www.elastic.co/docs/reference/integrations/carbonblack_edr)                                         | Collect logs from VMware Carbon Black EDR with Elastic Agent.                                                                                                                                                                                                                                     | GA                              | 1.21.0  | 9.0.08.13.0                  |
| [VMware vSphere](https://www.elastic.co/docs/reference/integrations/vsphere)                                                          | This Elastic integration collects metrics and logs from vSphere/vCenter servers                                                                                                                                                                                                                   | GA                              | 1.23.1  | 9.1.08.19.0                  |
| [WatchGuard Firebox](https://www.elastic.co/docs/reference/integrations/watchguard_firebox)                                           | Collect logs from WatchGuard Firebox with Elastic Agent.                                                                                                                                                                                                                                          | GA                              | 1.5.0   | 9.0.08.13.0                  |
| [WebSphere Application Server](https://www.elastic.co/docs/reference/integrations/websphere_application_server)                       | Collects metrics from IBM WebSphere Application Server with Elastic Agent.                                                                                                                                                                                                                        | GA                              | 1.6.1   | 9.0.08.13.0                  |
| [Windows](https://www.elastic.co/docs/reference/integrations/windows)                                                                 | Collect logs and metrics from Windows OS and services with Elastic Agent.                                                                                                                                                                                                                         | GA                              | 3.4.0   | 9.0.08.14.0                  |
| [WithSecure Elements](https://www.elastic.co/docs/reference/integrations/withsecure_elements)                                         | Ingest WithSecure Elements incidents and security events data                                                                                                                                                                                                                                     | <applies-to>: Beta</applies-to> | 0.1.0   | 9.0.08.18.0                  |
| [Wiz](https://www.elastic.co/docs/reference/integrations/wiz)                                                                         | Collect logs from Wiz with Elastic Agent.                                                                                                                                                                                                                                                         | GA                              | 4.0.0   | 9.0.08.18.08.17.48.16.6      |
| [Zeek](https://www.elastic.co/docs/reference/integrations/zeek)                                                                       | Collect logs from Zeek with Elastic Agent.                                                                                                                                                                                                                                                        | GA                              | 4.0.0   | 9.0.08.12.0                  |
| [Zero Networks](https://www.elastic.co/docs/reference/integrations/zeronetworks)                                                      | Zero Networks Logs integration                                                                                                                                                                                                                                                                    | GA                              | 1.19.0  | 9.1.49.0.78.19.4             |
| [ZeroFox](https://www.elastic.co/docs/reference/integrations/zerofox)                                                                 | Collect logs from ZeroFox with Elastic Agent.                                                                                                                                                                                                                                                     | GA                              | 1.29.0  | 9.1.49.0.78.19.4             |
| [ZooKeeper Metrics](https://www.elastic.co/docs/reference/integrations/zookeeper)                                                     | Collect metrics from ZooKeeper service with Elastic Agent.                                                                                                                                                                                                                                        | GA                              | 1.14.0  | 9.0.08.13.0                  |
| [Zoom](https://www.elastic.co/docs/reference/integrations/zoom)                                                                       | Collect logs from Zoom with Elastic Agent.                                                                                                                                                                                                                                                        | GA                              | 1.23.0  | 9.0.08.13.0                  |
| [Zscaler Internet Access](https://www.elastic.co/docs/reference/integrations/zscaler_zia)                                             | Collect logs from Zscaler Internet Access (ZIA) with Elastic Agent.                                                                                                                                                                                                                               | GA                              | 3.17.0  | 9.0.08.18.0                  |
| [Zscaler Private Access](https://www.elastic.co/docs/reference/integrations/zscaler_zpa)                                              | Collect logs from Zscaler Private Access (ZPA) with Elastic Agent.                                                                                                                                                                                                                                | GA                              | 1.23.3  | 9.0.08.13.0                  |