﻿---
title: Akamai Integration
description: The Akamai integration collects events from the Akamai API, specifically reading from the Akamai SIEM API. The Security Information and Event Management...
url: https://www.elastic.co/docs/reference/integrations/akamai
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Akamai Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.1.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | API, Google Cloud Storage      |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                    |

The Akamai integration collects events from the Akamai API, specifically reading from the [Akamai SIEM API](https://techdocs.akamai.com/siem-integration/reference/api).

## Logs


### SIEM

The Security Information and Event Management API allows you to capture security events generated on the Akamai platform in your SIEM application.
Use this API to get security event data generated on the Akamai platform and correlate it with data from other sources in your SIEM solution. Capture security event data incrementally, or replay missed security events from the past 12 hours. You can store, query, and analyze the data delivered through this API on your end, then go back and adjust your Akamai security settings. If you’re coding your own SIEM connector, it needs to adhere to these specifications in order to pull in security events from Akamai Security Events Collector (ASEC) and process them properly.
See [Akamai API get started](https://techdocs.akamai.com/siem-integration/reference/api-get-started) to set up your Akamai account and get your credentials.

### To collect data from GCS Bucket, follow the below steps:

- Configure the [Data Forwarder](https://techdocs.akamai.com/datastream2/docs/stream-google-cloud/) to ingest data into a GCS bucket.
- Configure the GCS bucket names and credentials along with the required configs under the "Collect Akamai SIEM logs via Google Cloud Storage" section.
- Make sure the service account and authentication being used, has proper levels of access to the GCS bucket [Manage Service Account Keys](https://cloud.google.com/iam/docs/creating-managing-service-account-keys/)

**Note**:
- The GCS input currently does not support fetching of buckets using bucket prefixes, so the bucket names have to be configured manually for each data stream.
- The GCS input currently only accepts a service account JSON key or a service account JSON file for authentication.
- The GCS input currently only supports JSON data.

<dropdown title="Exported fields">
  | Field                                  | Description                                                                                                                                                            | Type             |
  |----------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                             | Event timestamp.                                                                                                                                                       | date             |
  | akamai.siem.bot.response_segment       | Numeric response segment indicator. Segments are used to group and categorize bot scores.                                                                              | long             |
  | akamai.siem.bot.score                  | Score assigned to the request by Botman Manager.                                                                                                                       | long             |
  | akamai.siem.client_data.app_bundle_id  | Unique identifier of the app bundle. An app bundle contains both the software itself and the accompanying configuration information.                                   | keyword          |
  | akamai.siem.client_data.app_version    | Version number of the app.                                                                                                                                             | keyword          |
  | akamai.siem.client_data.sdk_version    | SDK version                                                                                                                                                            | keyword          |
  | akamai.siem.client_data.telemetry_type | Specifies the telemetry type in use.                                                                                                                                   | long             |
  | akamai.siem.client_reputation          | Client IP scores for Client Reputation.                                                                                                                                | keyword          |
  | akamai.siem.config_id                  | ID of the Security Configuration applied to the request.                                                                                                               | keyword          |
  | akamai.siem.policy_id                  | ID of the Firewall policy applied to the request.                                                                                                                      | keyword          |
  | akamai.siem.request.headers            | HTTP Request headers                                                                                                                                                   | flattened        |
  | akamai.siem.response.headers           | HTTP response headers                                                                                                                                                  | flattened        |
  | akamai.siem.rule_actions               | Actions taken for this request.                                                                                                                                        | keyword          |
  | akamai.siem.rule_tags                  | The set of categories for the triggered rule.                                                                                                                          | keyword          |
  | akamai.siem.rules                      | Rules triggered by this request                                                                                                                                        | nested           |
  | akamai.siem.rules.ruleActions          | Actions of rules that triggered for this request.                                                                                                                      | keyword          |
  | akamai.siem.rules.ruleData             | User data of rules that triggered for this request.                                                                                                                    | keyword          |
  | akamai.siem.rules.ruleMessages         | Messages of rules that triggered for this request.                                                                                                                     | keyword          |
  | akamai.siem.rules.ruleSelectors        | Selectors of rules that triggered for this request.                                                                                                                    | keyword          |
  | akamai.siem.rules.ruleTags             | Tags of rules that triggered for this request.                                                                                                                         | keyword          |
  | akamai.siem.rules.ruleVersions         | Versions of rules triggered for this request.                                                                                                                          | keyword          |
  | akamai.siem.rules.rules                | Rules that triggered for this request.                                                                                                                                 | keyword          |
  | akamai.siem.slow_post_action           | Action taken if a Slow POST attack is detected: W for Warn or A for deny (abort).                                                                                      | keyword          |
  | akamai.siem.slow_post_rate             | Recorded rate of a detected Slow POST attack.                                                                                                                          | long             |
  | akamai.siem.user_risk.allow            | Indicates whether the user is on the allow list. A 0 indicates that the user was not on the list; a 1 indicates that the user was on the list.                         | long             |
  | akamai.siem.user_risk.general          | Indicators of general behavior observed for relevant attributes. For example, duc_1h represents the number of users recorded on a specific device in the past hour.    | flattened        |
  | akamai.siem.user_risk.risk             | Indicators that increased the calculated risk score. For example, the value udfp represents the risk of the device fingerprint based on the user's behavioral profile. | flattened        |
  | akamai.siem.user_risk.score            | Calculated risk scores. Scores range from 0 (no risk) to 100 (the highest possible risk).                                                                              | long             |
  | akamai.siem.user_risk.status           | Status code indicating any errors that might have occurred when calculating the risk score.                                                                            | long             |
  | akamai.siem.user_risk.trust            | Indicators that were trusted. For example, the value ugp indicates that the user’s country or area is trusted.                                                         | flattened        |
  | akamai.siem.user_risk.uuid             | Unique identifier of the user whose risk data is being provided.                                                                                                       | keyword          |
  | data_stream.dataset                    | Data stream dataset name.                                                                                                                                              | constant_keyword |
  | data_stream.namespace                  | Data stream namespace.                                                                                                                                                 | constant_keyword |
  | data_stream.type                       | Data stream type.                                                                                                                                                      | constant_keyword |
  | event.dataset                          | Event dataset                                                                                                                                                          | constant_keyword |
  | event.module                           | Event module                                                                                                                                                           | constant_keyword |
  | gcs.storage.bucket.name                | The name of the Google Cloud Storage Bucket.                                                                                                                           | keyword          |
  | gcs.storage.object.content_type        | The content type of the Google Cloud Storage object.                                                                                                                   | keyword          |
  | gcs.storage.object.name                | The content type of the Google Cloud Storage object.                                                                                                                   | keyword          |
  | host.containerized                     | If the host is a container.                                                                                                                                            | boolean          |
  | host.os.build                          | OS build information.                                                                                                                                                  | keyword          |
  | host.os.codename                       | OS codename, if any.                                                                                                                                                   | keyword          |
  | input.type                             | Type of Filebeat input.                                                                                                                                                | keyword          |
  | log.flags                              | Flags for the log file.                                                                                                                                                | keyword          |
  | log.offset                             | Offset of the entry in the log file.                                                                                                                                   | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-12-09T22:28:27.000Z",
      "agent": {
          "ephemeral_id": "782a8cff-220e-4ab6-9349-2208799e9a24",
          "id": "efbc3410-6820-4850-87d0-bbb212062a6d",
          "name": "elastic-agent-59351",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "akamai": {
          "siem": {
              "bot": {
                  "response_segment": 3,
                  "score": 100
              },
              "client_data": {
                  "app_bundle_id": "com.mydomain.myapp",
                  "app_version": "1.23",
                  "sdk_version": "4.7.1",
                  "telemetry_type": 2
              },
              "config_id": "14227",
              "policy_id": "qik1_26545",
              "request": {
                  "headers": {
                      "Accept": "text/html,application/xhtml xml",
                      "User-Agent": "BOT/0.1 (BOT for JCE)"
                  }
              },
              "response": {
                  "headers": {
                      "Content-Length": "150",
                      "Content-Type": "text/html",
                      "Mime-Version": "1.0",
                      "Server": "AkamaiGHost"
                  }
              },
              "rule_actions": [
                  "alert",
                  "deny"
              ],
              "rule_tags": [
                  "owasp_crs/web_attack/file_injection",
                  "owasp_crs/web_attack/command_inject"
              ],
              "rules": [
                  {
                      "ruleActions": "alert",
                      "ruleData": "telnet.exe",
                      "ruleMessages": "System Command Access",
                      "ruleSelectors": "ARGS:option",
                      "ruleTags": "OWASP_CRS/WEB_ATTACK/FILE_INJECTION",
                      "ruleVersions": "4",
                      "rules": "950002"
                  },
                  {
                      "ruleActions": "alert",
                      "ruleData": "telnet.exe",
                      "ruleMessages": "System Command Injection",
                      "ruleSelectors": "ARGS:option",
                      "ruleTags": "OWASP_CRS/WEB_ATTACK/COMMAND_INJECT",
                      "ruleVersions": "4",
                      "rules": "950006"
                  },
                  {
                      "ruleActions": "deny",
                      "ruleData": "Vector Score: 10, DENY threshold: 9, Ale",
                      "ruleMessages": "Anomaly Score Exceeded fo",
                      "ruleVersions": "1",
                      "rules": "CMD-INJECTION-ANOMALY"
                  }
              ],
              "user_risk": {
                  "allow": 0,
                  "general": {
                      "duc_1d": "30",
                      "duc_1h": "10"
                  },
                  "risk": {
                      "udfp": "1325gdg4g4343g/M",
                      "unp": "74256/H"
                  },
                  "score": 75,
                  "status": 0,
                  "trust": {
                      "ugp": "US"
                  },
                  "uuid": "964d54b7-0821-413a-a4d6-8131770ec8d5"
              }
          }
      },
      "client": {
          "address": "89.160.20.156",
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156"
      },
      "data_stream": {
          "dataset": "akamai.siem",
          "namespace": "70206",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "efbc3410-6820-4850-87d0-bbb212062a6d",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "akamai.siem",
          "id": "187fac8e80dfae00",
          "ingested": "2025-12-10T10:23:29Z",
          "kind": "event",
          "original": "{\"attackData\":{\"clientIP\":\"89.160.20.156\",\"configId\":\"14227\",\"policyId\":\"qik1_26545\",\"ruleActions\":\"YWxlcnQ%3d%3bYWxlcnQ%3d%3bZGVueQ%3d%3d\",\"ruleData\":\"dGVsbmV0LmV4ZQ%3d%3d%3bdGVsbmV0LmV4ZQ%3d%3d%3bVmVjdG9yIFNjb3JlOiAxMCwgREVOWSB0aHJlc2hvbGQ6IDksIEFsZX \",\"ruleMessages\":\"U3lzdGVtIENvbW1hbmQgQWNjZXNz%3bU3lzdGVtIENvbW1hbmQgSW5qZWN0aW9u%3bQW5vbWFseSBTY29yZSBFeGNlZWRlZCBmb3 \",\"ruleSelectors\":\"QVJHUzpvcHRpb24%3d%3bQVJHUzpvcHRpb24%3d%3b\",\"ruleTags\":\"T1dBU1BfQ1JTL1dFQl9BVFRBQ0svRklMRV9JTkpFQ1RJT04%3d%3bT1dBU1BfQ1JTL1dFQl9BVFRBQ0svQ09NTUFORF9JTkpFQ1R \",\"ruleVersions\":\"NA%3d%3d%3bNA%3d%3d%3bMQ%3d%3d\",\"rules\":\"OTUwMDAy%3bOTUwMDA2%3bQ01ELUlOSkVDVElPTi1BTk9NQUxZ\"},\"botData\":{\"botScore\":\"100\",\"responseSegment\":\"3\"},\"clientData\":{\"appBundleId\":\"com.mydomain.myapp\",\"appVersion\":\"1.23\",\"sdkVersion\":\"4.7.1\",\"telemetryType\":\"2\"},\"format\":\"json\",\"geo\":{\"asn\":\"14618\",\"city\":\"ASHBURN\",\"continent\":\"288\",\"country\":\"US\",\"regionCode\":\"VA\"},\"httpMessage\":{\"bytes\":\"266\",\"host\":\"www.hmapi.com\",\"method\":\"GET\",\"path\":\"/\",\"port\":\"80\",\"protocol\":\"HTTP/1.1\",\"query\":\"option=com_jce%20telnet.exe\",\"requestHeaders\":\"User-Agent%3a%20BOT%2f0.1%20(BOT%20for%20JCE)%0d%0aAccept%3a%20text%2fhtml,application%2fxhtml+xml\",\"requestId\":\"187fac8e80dfae00\",\"responseHeaders\":\"Server%3a%20AkamaiGHost%0d%0aMime-Version%3a%201.0%0d%0aContent-Type%3a%20text%2fhtml%0d%0aContent-Length%3a%20150\",\"start\":1765319307,\"status\":\"200\"},\"type\":\"akamai_siem\",\"userRiskData\":{\"allow\":\"0\",\"general\":\"duc_1h:10|duc_1d:30\",\"risk\":\"udfp:1325gdg4g4343g/M|unp:74256/H\",\"score\":\"75\",\"status\":\"0\",\"trust\":\"ugp:US\",\"uuid\":\"964d54b7-0821-413a-a4d6-8131770ec8d5\"},\"version\":\"1.0\"}",
          "start": "2025-12-09T22:28:27.000Z"
      },
      "http": {
          "request": {
              "id": "187fac8e80dfae00",
              "method": "GET"
          },
          "response": {
              "bytes": 266,
              "status_code": 200
          },
          "version": "1.1"
      },
      "input": {
          "type": "cel"
      },
      "network": {
          "protocol": "http",
          "transport": "tcp"
      },
      "observer": {
          "type": "proxy",
          "vendor": "akamai"
      },
      "related": {
          "ip": [
              "89.160.20.156"
          ]
      },
      "source": {
          "address": "89.160.20.156",
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156"
      },
      "tags": [
          "preserve_original_event",
          "akamai-siem",
          "forwarded"
      ],
      "url": {
          "domain": "www.hmapi.com",
          "full": "www.hmapi.com/?option=com_jce%20telnet.exe",
          "path": "/",
          "port": 80,
          "query": "option=com_jce telnet.exe"
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version        | Details                                                                                                                                                                                                                                                                                                                                                               | Minimum Kibana version |
  |----------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.1.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16568))Add recovery_interval parameter to control lookback period during recovery mode.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16568))Handle 400 status code with invalid timestamp error switching to recovery mode.                         | 9.0.08.18.0            |
  | **3.0.2**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16494))Fix the issue of populating tags and terminate the pipeline on agent failures.                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **3.0.1**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16225))Fixed pagination logic to use the conditional check `number of events returned >= event_limit` instead of relying on the offset field's presence.                                                                                                                                | 9.0.08.18.0            |
  | **3.0.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15713))Migrated SIEM data stream from HTTPJSON to CEL.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15713))Credentials will likely need to be re-configured since the integration has beenupdated to use the new CEL input.                 | 9.0.08.18.0            |
  | **2.28.2**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15893))Remove empty HTTP message headers placeholder.                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **2.28.1**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15649))Fixed time duration handling in request parameters to conform to API guidelines.                                                                                                                                                                                                 | 9.0.08.13.0            |
  | **2.28.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **2.27.3**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                     | 8.13.0                 |
  | **2.27.2**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12393))Events with the same requestId are now properly indexed. Previously, multiple records with the same requestId could conflict (and be dropped) due to variations in other fields like httpMessage.bytes or httpMessage.responseHeaders.                                           | 8.13.0                 |
  | **2.27.1**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12275))Fix pipeline error when converting an empty numerical field.                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.27.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                    | 8.13.0                 |
  | **2.26.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10158))Handle input leniently.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10158))Improve efficiency of script processing.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10158))Fix handling of missing fields. | 8.13.0                 |
  | **2.25.4**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11474))Remove experimental/beta status warnings.                                                                                                                                                                                                                                        | 8.13.0                 |
  | **2.25.3**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                             | 8.13.0                 |
  | **2.25.2**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                             | 8.13.0                 |
  | **2.25.1**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11016))Fix definition of subfields of nested objects                                                                                                                                                                                                                                    | 8.13.0                 |
  | **2.25.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10417))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                     | 8.13.0                 |
  | **2.24.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                          | 8.13.0                 |
  | **2.23.2**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9486))Handle HTTP headers without values.                                                                                                                                                                                                                                               | 8.12.0                 |
  | **2.23.1**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9483))Fix errors processing empty userRiskData.{risk,trust,general} values.                                                                                                                                                                                                             | 8.12.0                 |
  | **2.23.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret and add missing mappings.                                                                                                                                                                                                                      | 8.12.0                 |
  | **2.22.0**     | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9042))Require 8.11.0 or greater because it contains necessary fixes to the Elastic Agent.                                                                                                                                                                                               | 8.11.0                 |
  | **2.21.1**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.21.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.20.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.19.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.18.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **2.17.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.16.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                     | 8.7.1                  |
  | **2.15.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                          | 8.7.1                  |
  | **2.14.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.13.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **2.12.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7132))Add event limit parameter to REST endpoint stream.                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.11.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.10.0**     | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.9.1**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6384))Fix sign of initial interval for start time offset calculation.                                                                                                                                                                                                                   | 8.7.1                  |
  | **2.9.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6325))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.8.2**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6199))fixed a variable naming issue in manifest.yml files for the gcs stream.                                                                                                                                                                                                       | 8.7.1                  |
  | **2.8.1**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6164))fixed a variable naming issue in the gcs.yml.hbs file.                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.8.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                      | 8.7.1                  |
  | **2.7.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6135))Update package-spec version to 2.7.0.                                                                                                                                                                                                                                         | 8.4.0                  |
  | **2.6.2-beta** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6107))Added support for the 'to' query parameter in the initial time based requests.                                                                                                                                                                                                    |                        |
  | **2.6.1-beta** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5827))Modify pagination to begin with a time based query and then switch to offset based.                                                                                                                                                                                               |                        |
  | **2.6.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5825))Added optional toggle to enable debug trace logging.                                                                                                                                                                                                                          | 8.5.0                  |
  | **2.5.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                  | 8.3.0                  |
  | **2.4.1**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                        | 8.3.0                  |
  | **2.4.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                  | 8.3.0                  |
  | **2.3.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4728))Added support for GCS input.                                                                                                                                                                                                                                                  | 8.3.0                  |
  | **2.2.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                  | 8.3.0                  |
  | **2.1.2**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4399))Remove duplicate fields.                                                                                                                                                                                                                                                          | 8.3.0                  |
  | **2.1.1**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                                                                                            | 8.3.0                  |
  | **2.1.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3841))Update package to ECS 8.4.0                                                                                                                                                                                                                                                   | 8.3.0                  |
  | **2.0.1**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                            | 8.3.0                  |
  | **2.0.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3739))Add dashboard.                                                                                                                                                                                                                                                                | 8.3.0                  |
  | **1.1.1**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.1.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.0.1**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3532))improve the English in the readme file                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.0.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3428))Make GA                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **0.2.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                                                                                                                                             |                        |
  | **0.1.3**      | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3092))Fix typo in config template for ignoring host enrichment                                                                                                                                                                                                                          |                        |
  | **0.1.2**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                            |                        |
  | **0.1.1**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2369))Update to ECS 8.0                                                                                                                                                                                                                                                             |                        |
  | **0.1.0**      | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1643))initial release                                                                                                                                                                                                                                                               |                        |
</dropdown>