﻿---
title: 1Password Events Reporting
description: With 1Password Business, you can send your account activity to your security information and event management (SIEM) system, using the 1Password Events...
url: https://www.elastic.co/docs/reference/integrations/1password
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# 1Password Events Reporting
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.34.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.0.78.19.4                     |

With [1Password Business](https://support.1password.com/explore/business/), you can send your account activity to your security information and event management (SIEM) system, using the 1Password Events API.
Get reports about 1Password activity, such as sign-in attempts and item usage, while you manage all your company’s applications and services from a central location.
With 1Password Events Reporting and Elastic SIEM, you can:
- Control your 1Password data retention
- Build custom graphs and dashboards
- Set up custom alerts that trigger specific actions
- Cross-reference 1Password events with the data from other services

You can set up Events Reporting if you’re an owner or administrator.

Ready to get started? [Learn how to set up the Elastic Events Reporting integration](https://support.1password.com/events-reporting).

## Agentless Enabled Integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

## Events


### Sign-in Attempts

Use the 1Password Events API to retrieve information about sign-in attempts. Events include the name and IP address of the user who attempted to sign in to the account, when the attempt was made, and – for failed attempts – the cause of the failure.
<dropdown title="Exported fields">
  | Field                               | Description                                                                                                                                               | Type             |
  |-------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Event timestamp.                                                                                                                                          | date             |
  | data_stream.dataset                 | Data stream dataset.                                                                                                                                      | constant_keyword |
  | data_stream.namespace               | Data stream namespace.                                                                                                                                    | constant_keyword |
  | data_stream.type                    | Data stream type.                                                                                                                                         | constant_keyword |
  | event.dataset                       | Event dataset                                                                                                                                             | constant_keyword |
  | event.module                        | Event module                                                                                                                                              | constant_keyword |
  | input.type                          | Input type                                                                                                                                                | keyword          |
  | onepassword.client.app_name         | The name of the 1Password app that attempted to sign in to the account                                                                                    | keyword          |
  | onepassword.client.app_version      | The version number of the 1Password app                                                                                                                   | keyword          |
  | onepassword.client.platform_name    | The name of the platform running the 1Password app                                                                                                        | keyword          |
  | onepassword.client.platform_version | The version of the browser or computer where the 1Password app is installed, or the CPU of the machine where the 1Password command-line tool is installed | keyword          |
  | onepassword.country                 | The country code of the event. Uses the ISO 3166 standard                                                                                                 | keyword          |
  | onepassword.details.value           |                                                                                                                                                           | keyword          |
  | onepassword.session_uuid            | The UUID of the session that created the event                                                                                                            | keyword          |
  | onepassword.type                    | Details about the sign-in attempt                                                                                                                         | keyword          |
  | onepassword.uuid                    | The UUID of the event                                                                                                                                     | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-08-11T14:28:03.000Z",
      "agent": {
          "ephemeral_id": "ce227beb-fb58-4f3d-a379-0b3b0f163883",
          "id": "bb785601-3e94-4772-8d05-48517f9740bc",
          "name": "elastic-agent-11750",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "1password.signin_attempts",
          "namespace": "35031",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "bb785601-3e94-4772-8d05-48517f9740bc",
          "snapshot": true,
          "version": "8.19.4"
      },
      "event": {
          "action": "success",
          "agent_id_status": "verified",
          "category": [
              "authentication"
          ],
          "created": "2025-09-19T12:38:09.666Z",
          "dataset": "1password.signin_attempts",
          "ingested": "2025-09-19T12:38:12Z",
          "kind": "event",
          "original": "{\"category\":\"success\",\"client\":{\"app_name\":\"1Password Browser Extension\",\"app_version\":\"1109\",\"ip_address\":\"1.1.1.1\",\"os_name\":\"Android\",\"os_version\":\"10\",\"platform_name\":\"Chrome\",\"platform_version\":\"93.0.4577.62\"},\"country\":\"AR\",\"details\":null,\"session_uuid\":\"UED4KFZ5BH37IQWTJ7LG4VPWK7\",\"target_user\":{\"email\":\"email@1password.com\",\"name\":\"Name\",\"uuid\":\"OJQGU46KAPROEJLCK674RHSAY5\"},\"timestamp\":\"2021-08-11T14:28:03Z\",\"type\":\"credentials_ok\",\"uuid\":\"HGIF4OEWXDTVWKEQDIWTKV26HU\"}",
          "outcome": "success",
          "type": [
              "info"
          ]
      },
      "host": {
          "os": {
              "name": "Android",
              "version": "10"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "onepassword": {
          "client": {
              "app_name": "1Password Browser Extension",
              "app_version": "1109",
              "platform_name": "Chrome",
              "platform_version": "93.0.4577.62"
          },
          "country": "AR",
          "session_uuid": "UED4KFZ5BH37IQWTJ7LG4VPWK7",
          "type": "credentials_ok",
          "uuid": "HGIF4OEWXDTVWKEQDIWTKV26HU"
      },
      "related": {
          "ip": [
              "1.1.1.1"
          ],
          "user": [
              "OJQGU46KAPROEJLCK674RHSAY5",
              "email@1password.com",
              "Name"
          ]
      },
      "source": {
          "ip": "1.1.1.1"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "1password-signin_attempts"
      ],
      "user": {
          "email": "email@1password.com",
          "full_name": "Name",
          "id": "OJQGU46KAPROEJLCK674RHSAY5",
          "name": "Name"
      }
  }
  ```
</dropdown>


### Item Usages

This uses the 1Password Events API to retrieve information about items in shared vaults that have been modified, accessed, or used. Events include the name and IP address of the user who accessed the item, when it was accessed, and the vault where the item is stored.
<dropdown title="Exported fields">
  | Field                               | Description                                                                                                                                               | Type             |
  |-------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Event timestamp.                                                                                                                                          | date             |
  | data_stream.dataset                 | Data stream dataset.                                                                                                                                      | constant_keyword |
  | data_stream.namespace               | Data stream namespace.                                                                                                                                    | constant_keyword |
  | data_stream.type                    | Data stream type.                                                                                                                                         | constant_keyword |
  | event.dataset                       | Event dataset                                                                                                                                             | constant_keyword |
  | event.module                        | Event module                                                                                                                                              | constant_keyword |
  | input.type                          | Input type                                                                                                                                                | keyword          |
  | onepassword.client.app_name         | The name of the 1Password app the item was accessed from                                                                                                  | keyword          |
  | onepassword.client.app_version      | The version number of the 1Password app                                                                                                                   | keyword          |
  | onepassword.client.platform_name    | The name of the platform the item was accessed from                                                                                                       | keyword          |
  | onepassword.client.platform_version | The version of the browser or computer where the 1Password app is installed, or the CPU of the machine where the 1Password command-line tool is installed | keyword          |
  | onepassword.item_uuid               | The UUID of the item that was accessed                                                                                                                    | keyword          |
  | onepassword.used_version            | The version of the item that was accessed                                                                                                                 | integer          |
  | onepassword.uuid                    | The UUID of the event                                                                                                                                     | keyword          |
  | onepassword.vault_uuid              | The UUID of the vault the item is in                                                                                                                      | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-08-30T18:57:42.484Z",
      "agent": {
          "ephemeral_id": "15ef1f40-9e00-477b-9aed-4672138ab4ab",
          "id": "8337aa82-bf10-4d6f-b937-95dd6db12de7",
          "name": "elastic-agent-33999",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "1password.item_usages",
          "namespace": "31026",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8337aa82-bf10-4d6f-b937-95dd6db12de7",
          "snapshot": true,
          "version": "8.19.4"
      },
      "event": {
          "action": "reveal",
          "agent_id_status": "verified",
          "category": [
              "file"
          ],
          "created": "2025-09-19T12:37:21.588Z",
          "dataset": "1password.item_usages",
          "ingested": "2025-09-19T12:37:24Z",
          "kind": "event",
          "original": "{\"action\":\"reveal\",\"client\":{\"app_name\":\"1Password Browser Extension\",\"app_version\":\"1109\",\"ip_address\":\"1.1.1.1\",\"os_name\":\"Android\",\"os_version\":\"10\",\"platform_name\":\"Chrome\",\"platform_version\":\"93.0.4577.62\"},\"item_uuid\":\"bvwmmwxisuca7wbehrbyqhag54\",\"location\":{\"city\":\"Toronto\",\"country\":\"Canada\",\"latitude\":43.64,\"longitude\":-79.433,\"region\":\"Ontario\"},\"timestamp\":\"2021-08-30T18:57:42.484Z\",\"used_version\":1,\"user\":{\"email\":\"email@1password.com\",\"name\":\"Name\",\"uuid\":\"OJQGU46KAPROEJLCK674RHSAY5\"},\"uuid\":\"MCQODBBWJD5HISKYNP3HJPV2DV\",\"vault_uuid\":\"jaqxqf5qylslqiitnduawrndc5\"}",
          "type": [
              "access"
          ]
      },
      "host": {
          "os": {
              "name": "Android",
              "version": "10"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "onepassword": {
          "client": {
              "app_name": "1Password Browser Extension",
              "app_version": "1109",
              "platform_name": "Chrome",
              "platform_version": "93.0.4577.62"
          },
          "item_uuid": "bvwmmwxisuca7wbehrbyqhag54",
          "used_version": 1,
          "uuid": "MCQODBBWJD5HISKYNP3HJPV2DV",
          "vault_uuid": "jaqxqf5qylslqiitnduawrndc5"
      },
      "related": {
          "ip": [
              "1.1.1.1"
          ],
          "user": [
              "OJQGU46KAPROEJLCK674RHSAY5",
              "email@1password.com",
              "Name"
          ]
      },
      "source": {
          "ip": "1.1.1.1"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "1password-item_usages"
      ],
      "user": {
          "email": "email@1password.com",
          "full_name": "Name",
          "id": "OJQGU46KAPROEJLCK674RHSAY5",
          "name": "Name"
      }
  }
  ```
</dropdown>


### Audit Events

This uses the 1Password Events API to retrieve information about audit events. Events includes information about actions performed by team members such as account updates, access and invitations, device authorization, changes to vault permissions, and more.
<dropdown title="Exported fields">
  | Field                            | Description                                               | Type             |
  |----------------------------------|-----------------------------------------------------------|------------------|
  | @timestamp                       | Event timestamp.                                          | date             |
  | data_stream.dataset              | Data stream dataset.                                      | constant_keyword |
  | data_stream.namespace            | Data stream namespace.                                    | constant_keyword |
  | data_stream.type                 | Data stream type.                                         | constant_keyword |
  | event.dataset                    | Event dataset                                             | constant_keyword |
  | event.module                     | Event module                                              | constant_keyword |
  | input.type                       | Input type                                                | keyword          |
  | onepassword.actor_details.email  | The email of the actor.                                   | keyword          |
  | onepassword.actor_details.name   | The name of the actor.                                    | keyword          |
  | onepassword.actor_details.uuid   | The UUID of the actor.                                    | keyword          |
  | onepassword.actor_uuid           | The UUID of the actor.                                    | keyword          |
  | onepassword.aux_details.email    | The email of the aux resource.                            | keyword          |
  | onepassword.aux_details.name     | The name of the aux resource.                             | keyword          |
  | onepassword.aux_details.uuid     | The UUID of the aux resource.                             | keyword          |
  | onepassword.aux_id               | Any auxilary id related to the event.                     | long             |
  | onepassword.aux_info             | Any auxilary info related to the event.                   | text             |
  | onepassword.aux_uuid             | Any auxilary uuid related to the event.                   | keyword          |
  | onepassword.object_details.email | The email of the object.                                  | keyword          |
  | onepassword.object_details.name  | The name of the object.                                   | keyword          |
  | onepassword.object_details.uuid  | The UUID of the object.                                   | keyword          |
  | onepassword.object_type          | The type of object changed by the event.                  | keyword          |
  | onepassword.object_uuid          | The UUID of the object changed by the event.              | keyword          |
  | onepassword.session.device_uuid  | The device uuid of the session used to create the event.  | keyword          |
  | onepassword.session.login_time   | The login time of the session used to create the event.   | date             |
  | onepassword.session.uuid         | The session uuid of the session used to create the event. | keyword          |
  | onepassword.uuid                 | The UUID of the event.                                    | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-24T21:16:52.827Z",
      "agent": {
          "ephemeral_id": "8addaae9-87b5-4f3b-b998-54a98b2586f5",
          "id": "764d6ce1-2012-437a-a1e4-d6fc25cb83e6",
          "name": "elastic-agent-26645",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "1password.audit_events",
          "namespace": "75533",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "764d6ce1-2012-437a-a1e4-d6fc25cb83e6",
          "snapshot": true,
          "version": "8.19.4"
      },
      "event": {
          "action": "suspend",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-09-19T12:36:31.698Z",
          "dataset": "1password.audit_events",
          "ingested": "2025-09-19T12:36:34Z",
          "kind": "event",
          "original": "{\"action\":\"suspend\",\"actor_uuid\":\"GLF6WUEKS5CSNDJ2OG6TCZD3M4\",\"location\":{\"city\":\"Toronto\",\"country\":\"Canada\",\"latitude\":43.64,\"longitude\":-79.433,\"region\":\"Ontario\"},\"object_type\":\"user\",\"object_uuid\":\"ZRQCUD6A65AKHFETOUFO7NL4OM\",\"session\":{\"device_uuid\":\"rqtd557fn2husnstp5nc66w2xa\",\"ip\":\"89.160.20.156\",\"login_time\":\"2022-10-24T21:07:34.703106271Z\",\"uuid\":\"ODOHXUYQCJBUJKRGZNNPBJURPE\"},\"timestamp\":\"2022-10-24T21:16:52.827288935Z\",\"uuid\":\"3UQOGUC7DVOCN4OZP2MDKHFLSG\"}",
          "type": [
              "access"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "onepassword": {
          "object_type": "user",
          "object_uuid": "ZRQCUD6A65AKHFETOUFO7NL4OM",
          "session": {
              "device_uuid": "rqtd557fn2husnstp5nc66w2xa",
              "login_time": "2022-10-24T21:07:34.703106271Z",
              "uuid": "ODOHXUYQCJBUJKRGZNNPBJURPE"
          },
          "uuid": "3UQOGUC7DVOCN4OZP2MDKHFLSG"
      },
      "related": {
          "ip": [
              "89.160.20.156"
          ],
          "user": [
              "GLF6WUEKS5CSNDJ2OG6TCZD3M4",
              "ZRQCUD6A65AKHFETOUFO7NL4OM"
          ]
      },
      "source": {
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "1password-audit_events"
      ],
      "user": {
          "id": "GLF6WUEKS5CSNDJ2OG6TCZD3M4"
      }
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Sign-in attempts](https://epr.elastic.co/package/1password/1.34.0/img/1password-signinattempts-screenshot.png)

  ![Item usages](https://epr.elastic.co/package/1password/1.34.0/img/1password-itemusages-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.34.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15415))Prevent updating fleet health status to degraded.                                                                                                   | 9.0.78.19.4            |
  | **1.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15345))Enable Agentless deployment.                                                                                                                        | 9.0.08.18.0            |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                    | 8.13.0                 |
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.30.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11825))Unify the use of `user.full_name` and `user.name` in all data streams.                                                                                  | 8.13.0                 |
  | **1.30.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10417))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                            | 8.13.0                 |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                 | 8.12.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8725))Set sensitive values as secret.                                                                                                                      | 8.12.0                 |
  | **1.26.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.7.1                  |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                              | 8.7.1                  |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.7.1                  |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                               | 8.7.1                  |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping for `onepassword.details` field                                                                                                              | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'partner' owner type.                                                                                                                            | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.7.1                  |
  | **1.21.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7963))Correct invalid ECS field usages at root-level.                                                                                                          | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7905))ECS version updated to 8.10.0.                                                                                                                       | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6851))Add user detail fields to actor, object, and aux_info.                                                                                               | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7107))Update package to ECS 8.9.0.                                                                                                                         | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                             | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6819))Convert dashboard to lens.                                                                                                                           | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6599))Ensure event.kind is correctly set for pipeline errors.                                                                                              | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6373))Update package to ECS 8.8.0 and package-spec 2.7.0.                                                                                                  | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                             | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         | 8.6.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5496))Add audit events to 1Password Events Reporting                                                                                                       | 8.6.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5483))Allow configuration of HTTP keep-alive to allow for connection reuse.                                                                                | 8.6.1                  |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                               | 8.1.0                  |
  | **1.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5471))Fix pagination termination when response contains has_more=false.                                                                                        | 8.1.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                         | 8.1.0                  |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4516))Migrate the visualizations to by value in dashboards to minimize the saved object clutter and reduce time to load                                    | 8.1.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3841))Update package to ECS 8.4.0                                                                                                                          | 8.0.07.16.0            |
  | **1.5.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                   | 8.0.07.16.0            |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                   | 8.0.07.16.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3534))Update readme to improve English                                                                                                                     | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3245))Change name of package                                                                                                                               | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2778))Update to ECS 8.2                                                                                                                                    | 8.0.07.16.0            |
  | **1.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3092))Fix typo in config template for ignoring host enrichment                                                                                                 | 8.0.07.16.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                   | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2775))Add new "event.action" to item_usages events.                                                                                                        | 8.0.07.16.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2687))Fix field mapping conflict for ECS `event.created`.                                                                                                      | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2368))Update to ECS 8.0                                                                                                                                    | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2360))GA integration                                                                                                                                       | 8.0.07.16.0            |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                       |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                           |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2214))Add 8.0.0 version constraint                                                                                                                         |                        |
  | **0.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1997))Update Title and Description.                                                                                                                            |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1722))Initial draft of the package                                                                                                                         |                        |
</dropdown>