﻿---
title: Elastic integrations
description: An Elastic integration is a collection of assets that defines how to observe a specific product or service with the Elastic Stack. Each integration comes...
url: https://www.elastic.co/docs/reference/integrations
products:
  - Elastic integrations
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic integrations
An Elastic integration is a collection of assets that defines how to observe a specific product or service with the Elastic Stack. Each integration comes pre-packaged with assets that support your needs and allow you to easily collect, store, and visualize any data from any source.
Elastic offers over 300 turn-key integrations. Choose the integration that best fits your needs:
- [Search](https://www.elastic.co/integrations/data-integrations?solution=search)
- [Security](https://www.elastic.co/integrations/data-integrations?solution=security)
- [Observability](https://www.elastic.co/integrations/data-integrations?solution=observability)

You can also browse through the catalogue of Cloud provider integrations:
- [AWS](https://www.elastic.co/docs/reference/integrations/aws)
- [Azure](https://www.elastic.co/docs/reference/integrations/azure)
- [GCP](https://www.elastic.co/docs/reference/integrations/google-cloud-intro)


## Get started

If you want to quickly get started, follow these steps:
1. Spin up an Elastic Stack deployment. You can [try it out for free](https://www.elastic.co/cloud/elasticsearch-service/signup?page=docs&placement=docs-body) on AWS, GCP, or Azure.
2. Install the Elastic Agent. [Elastic Agent](https://www.elastic.co/guide/en/observability/current/logs-metrics-get-started.html) is a single, unified way to add monitoring for logs, metrics, and other types of data to a host.