﻿---
title: URL Decode
description: The urldecode processor specifies a list of fields to decode from URL encoded format. In this example, field1 is decoded in field2. See Conditions for...
url: https://www.elastic.co/docs/reference/fleet/urldecode-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# URL Decode
The `urldecode` processor specifies a list of fields to decode from URL encoded format.

## Example

In this example, `field1` is decoded in `field2`.
```yaml
  - urldecode:
      fields:
        - from: "field1"
          to: "field2"
      ignore_missing: false
      fail_on_error: true
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default | Description                                                                                                                                                                                                           |
|------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `fields`         | Yes      |         | Contains:* `from: "source-field"`, where `from` is the source field name* `to: "target-field"`, where `to` is the target field name (defaults to the `from` value)                                                    |
| `ignore_missing` | No       | `false` | Whether to ignore missing keys. If `true`, no error is logged if a key that should be URL-decoded is missing.                                                                                                         |
| `fail_on_error`  | No       | `true`  | Whether to fail if an error occurs. If `true` and an error occurs, the URL-decoding of fields is stopped, and the original event is returned. If `false`, decoding continues even if an error occurs during decoding. |

See [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions) for a list of supported conditions.