﻿---
title: Upgrade standalone Elastic Agents
description: To upgrade a standalone agent running on an edge node: Make sure the elastic-agent service is running.From the directory where Elastic Agent is installed,...
url: https://www.elastic.co/docs/reference/fleet/upgrade-standalone
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Upgrade standalone Elastic Agents
To upgrade a standalone agent running on an edge node:
1. Make sure the `elastic-agent` service is running.
2. From the directory where Elastic Agent is installed, run the `upgrade` command to upgrade to a new version. Not sure where the agent is installed? Refer to [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout).
   For example, to upgrade the agent from version 9.1.0 to 9.1.1, you would run:
   <tab-set>
   <tab-item title="macOS">
   ```shell
   sudo elastic-agent upgrade 9.1.1
   ```
   </tab-item>

   <tab-item title="Linux">
   ```shell
   sudo elastic-agent upgrade 9.1.1
   ```
   </tab-item>

   <tab-item title="Windows">
   As an Administrator, run:
   ```shell
   .\elastic-agent.exe upgrade 9.1.1
   ```
   </tab-item>

   <tab-item title="DEB">
   ```shell
   sudo elastic-agent upgrade 9.1.1
   ```
   </tab-item>

   <tab-item title="RPM">
   ```shell
   sudo elastic-agent upgrade 9.1.1
   ```
   </tab-item>
   </tab-set>

This command upgrades the binary. Your agent policy should continue to work, but you might need to upgrade it to use new features and capabilities.
For more command-line options, see the help for the [`upgrade`](/docs/reference/fleet/agent-command-reference#elastic-agent-upgrade-command) command.

## Upgrading standalone Elastic Agent in an air-gapped environment

The basic upgrade scenario should work for most use cases. However, in an air-gapped environment Elastic Agent is not able to access the Elastic Artifact Registry at `artifacts.elastic.co` directly.
As an alterative, you can do one of the following:
- [Configure a proxy server](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support) for standalone Elastic Agent to access the Elastic Artifact Registry.
- [Host your own artifact registry](/docs/reference/fleet/air-gapped#host-artifact-registry) for standalone Elastic Agent to access binary downloads.

As well, starting from version 8.9.0, during the upgrade process Elastic Agent needs to download a PGP/GPG key. Refer to [Configure Elastic Agents to download a PGP/GPG key from Fleet Server](/docs/reference/fleet/air-gapped#air-gapped-pgp-fleet) for the steps to configure the key download location in an air-gapped environment.
Refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped) for more details.

## Verifying Elastic Agent package signatures

Standalone Elastic Agent verifies each package that it downloads using publicly available SHA hash and .asc PGP signature files. The SHA file is used to verify that the package has not been modified, and the .asc file is used to verify that the package was released by Elastic. For this purpose, the Elastic public GPG key is embedded in Elastic Agent itself.
At times, the Elastic private GPG key may need to be rotated, either due to the key expiry or due to the private key having been exposed. In this case, standalone Elastic Agent upgrades can fail because the embedded public key no longer works.
In the event of a private GPG key rotation, you can use the following options with the [`upgrade`](/docs/reference/fleet/agent-command-reference#elastic-agent-upgrade-command) command to either skip the verification process (not recommended) or force Elastic Agent to use a new public key for verification:
<definitions>
  <definition term="--skip-verify">
    Skip the package verification process. This option is not recommended as it is insecure.
    Example:
    ```yaml
    ./elastic-agent upgrade 9.1.0 --skip-verify
    ```
  </definition>
  <definition term="--pgp-path <string>">
    Use a locally stored copy of the PGP key to verify the upgrade package.
    Example:
    ```yaml
    ./elastic-agent upgrade 9.1.0 --pgp-path /home/elastic-agent/GPG-KEY-elasticsearch
    ```
  </definition>
  <definition term="--pgp-uri <string>">
    Use the specified online PGP key to verify the upgrade package.
    Example:
    ```yaml
    ./elastic-agent upgrade 8.7.0-SNAPSHOT --pgp-uri "https://artifacts.elastic.co/GPG-KEY-elasticsearch"
    ```
  </definition>
</definitions>

Under the basic upgrade scenario standalone Elastic Agent will automatically fetch the most current public key, however in an air-gapped environment or in the event that the Elastic Artifact Registry is otherwise inaccessible, these commands can be used instead.