﻿---
title: Uninstall Elastic Agents from edge hosts
description: To uninstall Elastic Agent, run the uninstall command from the directory where Elastic Agent is running. Follow the prompts to confirm that you want to...
url: https://www.elastic.co/docs/reference/fleet/uninstall-elastic-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Uninstall Elastic Agents from edge hosts
## Uninstall on macOS, Linux, and Windows

To uninstall Elastic Agent, run the `uninstall` command from the directory where Elastic Agent is running.
<important>
  Be sure to run the `uninstall` command from a directory outside of where Elastic Agent is installed.For example, on a Windows system the install location is `C:\Program Files\Elastic\Agent`. Run the uninstall command from `C:\Program Files\Elastic` or `\tmp`, or even your default home directory:
  ```shell
  C:\"Program Files"\Elastic\Agent\elastic-agent.exe uninstall
  ```
</important>

<tab-set>
  <tab-item title="macOS">
    <tip>
      You must run this command as the root user.
    </tip>

    ```shell
    sudo /Library/Elastic/Agent/elastic-agent uninstall
    ```
  </tab-item>

  <tab-item title="Linux">
    <tip>
      You must run this command as the root user.
    </tip>

    ```shell
    sudo /opt/Elastic/Agent/elastic-agent uninstall
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, run:
    ```shell
    C:\"Program Files"\Elastic\Agent\elastic-agent.exe uninstall
    ```
  </tab-item>
</tab-set>

Follow the prompts to confirm that you want to uninstall Elastic Agent. The command stops and uninstalls any managed programs, such as Beats and Elastic Endpoint, before it stops and uninstalls Elastic Agent.
If you run into problems, refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).
If you are using DEB or RPM, you can use the package manager to remove the installed package.
<note>
  For hosts enrolled in the Elastic Defend integration with Agent tamper protection enabled, you’ll need to include the uninstall token in the command, using the `--uninstall-token` flag. For more information, refer to [Prevent Elastic Agent uninstallation](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/prevent-elastic-agent-uninstallation).
</note>


## Remove Elastic Agent files manually

You might need to remove Elastic Agent files manually if there’s a failure during installation.
To remove Elastic Agent manually from your system:
1. [Unenroll the agent](https://www.elastic.co/docs/reference/fleet/unenroll-elastic-agent) if it’s managed by Fleet.
2. For standalone agents, back up any configuration files you want to preserve.
3. On your host, [stop the agent](/docs/reference/fleet/start-stop-elastic-agent#stop-elastic-agent-service). If any Elastic Agent-related processes are still running, stop them too.
   <tip>
   Search for these processes and stop them if they’re still running: `filebeat`, `metricbeat`, `fleet-server`, and `elastic-endpoint`.
   </tip>
4. Manually remove the Elastic Agent files from your system. For example, if you’re running Elastic Agent on macOS, delete `/Library/Elastic/Agent/*`. Not sure where the files are installed? Refer to [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout).
5. If you’ve configured the Elastic Defend integration, also remove the files installed for endpoint protection. The directory structure is similar to Elastic Agent, for example, `/Library/Elastic/Endpoint/*`.
   <note>
   When you remove the Elastic Defend integration from a macOS host (10.13, 10.14, or 10.15), the Endpoint System Extension is left on disk intentionally. If you want to remove the extension, refer to the documentation for your operating system.
   </note>